#
# TABLE STRUCTURE FOR: accounting_periods
#

DROP TABLE IF EXISTS `accounting_periods`;

CREATE TABLE `accounting_periods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `period_name` varchar(50) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `status` enum('open','closed','locked') DEFAULT 'open',
  `closed_by` int(11) DEFAULT NULL,
  `closed_at` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_period_dates` (`start_date`,`end_date`),
  KEY `idx_status` (`status`),
  KEY `idx_period_range` (`start_date`,`end_date`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `accounting_periods` (`id`, `period_name`, `start_date`, `end_date`, `status`, `closed_by`, `closed_at`, `created_at`) VALUES (1, 'January 2025', '2025-01-01', '2025-01-31', 'open', NULL, NULL, '2025-07-11 06:06:45');
INSERT INTO `accounting_periods` (`id`, `period_name`, `start_date`, `end_date`, `status`, `closed_by`, `closed_at`, `created_at`) VALUES (2, 'February 2025', '2025-02-01', '2025-02-28', 'open', NULL, NULL, '2025-07-11 06:06:45');
INSERT INTO `accounting_periods` (`id`, `period_name`, `start_date`, `end_date`, `status`, `closed_by`, `closed_at`, `created_at`) VALUES (3, 'March 2025', '2025-03-01', '2025-03-31', 'open', NULL, NULL, '2025-07-11 06:06:45');
INSERT INTO `accounting_periods` (`id`, `period_name`, `start_date`, `end_date`, `status`, `closed_by`, `closed_at`, `created_at`) VALUES (4, 'April 2025', '2025-04-01', '2025-04-30', 'open', NULL, NULL, '2025-07-11 06:06:45');
INSERT INTO `accounting_periods` (`id`, `period_name`, `start_date`, `end_date`, `status`, `closed_by`, `closed_at`, `created_at`) VALUES (5, 'May 2025', '2025-05-01', '2025-05-31', 'open', NULL, NULL, '2025-07-11 06:06:45');
INSERT INTO `accounting_periods` (`id`, `period_name`, `start_date`, `end_date`, `status`, `closed_by`, `closed_at`, `created_at`) VALUES (6, 'June 2025', '2025-06-01', '2025-06-30', 'open', NULL, NULL, '2025-07-11 06:06:45');
INSERT INTO `accounting_periods` (`id`, `period_name`, `start_date`, `end_date`, `status`, `closed_by`, `closed_at`, `created_at`) VALUES (7, 'July 2025', '2025-07-01', '2025-07-31', 'open', NULL, NULL, '2025-07-11 06:06:45');
INSERT INTO `accounting_periods` (`id`, `period_name`, `start_date`, `end_date`, `status`, `closed_by`, `closed_at`, `created_at`) VALUES (8, 'August 2025', '2025-08-01', '2025-08-31', 'open', NULL, NULL, '2025-07-11 06:06:45');
INSERT INTO `accounting_periods` (`id`, `period_name`, `start_date`, `end_date`, `status`, `closed_by`, `closed_at`, `created_at`) VALUES (9, 'September 2025', '2025-09-01', '2025-09-30', 'open', NULL, NULL, '2025-07-11 06:06:45');
INSERT INTO `accounting_periods` (`id`, `period_name`, `start_date`, `end_date`, `status`, `closed_by`, `closed_at`, `created_at`) VALUES (10, 'October 2025', '2025-10-01', '2025-10-31', 'open', NULL, NULL, '2025-07-11 06:06:45');
INSERT INTO `accounting_periods` (`id`, `period_name`, `start_date`, `end_date`, `status`, `closed_by`, `closed_at`, `created_at`) VALUES (11, 'November 2025', '2025-11-01', '2025-11-30', 'open', NULL, NULL, '2025-07-11 06:06:45');
INSERT INTO `accounting_periods` (`id`, `period_name`, `start_date`, `end_date`, `status`, `closed_by`, `closed_at`, `created_at`) VALUES (12, 'December 2025', '2025-12-01', '2025-12-31', 'open', NULL, NULL, '2025-07-11 06:06:45');


#
# TABLE STRUCTURE FOR: ambulance_call
#

DROP TABLE IF EXISTS `ambulance_call`;

CREATE TABLE `ambulance_call` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `vehicle_id` int(11) DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `vehicle_model` varchar(20) DEFAULT NULL,
  `driver` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `call_from` varchar(200) NOT NULL,
  `call_to` varchar(200) NOT NULL,
  `charge_category_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `standard_charge` int(11) DEFAULT NULL,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `discount` float(10,2) DEFAULT 0.00,
  `tax_percentage` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT 0.00,
  `net_amount` float(10,2) DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `vehicle_id` (`vehicle_id`),
  KEY `generated_by` (`generated_by`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `transaction_id` (`transaction_id`),
  KEY `charge_id` (`charge_id`),
  KEY `idx_contact_no` (`contact_no`),
  KEY `idx_vehicle_model` (`vehicle_model`),
  KEY `idx_driver` (`driver`),
  KEY `index_date` (`date`),
  KEY `index_call_from` (`call_from`),
  KEY `index_call_to` (`call_to`),
  KEY `index_charge_category_id` (`charge_category_id`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_discount` (`discount`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_amount` (`amount`),
  KEY `index_net_amount` (`net_amount`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: annual_calendar
#

DROP TABLE IF EXISTS `annual_calendar`;

CREATE TABLE `annual_calendar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `holiday_type` int(11) NOT NULL COMMENT '1 for holiday , 2 for activity , 3 for vacation',
  `from_date` datetime DEFAULT NULL,
  `to_date` datetime DEFAULT NULL,
  `description` text NOT NULL COMMENT 'Holiday Description',
  `is_active` int(11) NOT NULL DEFAULT 1 COMMENT '1 for active 0 for inactive',
  `holiday_color` varchar(200) NOT NULL,
  `front_site` int(11) NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_holiday_type` (`holiday_type`),
  KEY `idx_created_by` (`created_by`),
  KEY `index_from_date` (`from_date`) USING BTREE,
  KEY `index_to_date` (`to_date`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: antenatal_examine
#

DROP TABLE IF EXISTS `antenatal_examine`;

CREATE TABLE `antenatal_examine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `primary_examine_id` int(11) NOT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `ipdid` int(11) DEFAULT NULL,
  `uter_size` varchar(250) DEFAULT NULL,
  `uterus_size` varchar(250) DEFAULT NULL,
  `presentation_position` varchar(250) DEFAULT NULL,
  `brim_presentation` varchar(250) DEFAULT NULL,
  `foeta_heart` varchar(250) DEFAULT NULL,
  `blood_pressure` varchar(250) DEFAULT NULL,
  `antenatal_oedema` varchar(250) DEFAULT NULL,
  `antenatal_weight` varchar(250) DEFAULT NULL,
  `urine_sugar` varchar(250) DEFAULT NULL,
  `urine` varchar(250) DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `next_visit` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `ipdid` (`ipdid`),
  KEY `index_uter_size` (`uter_size`),
  KEY `index_uterus_size` (`uterus_size`),
  KEY `index_presentation_position` (`presentation_position`),
  KEY `index_brim_presentation` (`brim_presentation`),
  KEY `index_foeta_heart` (`foeta_heart`),
  KEY `index_blood_pressure` (`blood_pressure`),
  KEY `index_antenatal_oedema` (`antenatal_oedema`),
  KEY `index_antenatal_weight` (`antenatal_weight`),
  KEY `index_urine_sugar` (`urine_sugar`),
  KEY `index_urine` (`urine`),
  KEY `primary_examine_id` (`primary_examine_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: appoint_priority
#

DROP TABLE IF EXISTS `appoint_priority`;

CREATE TABLE `appoint_priority` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appoint_priority` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_appoint_priority` (`appoint_priority`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (1, 'Normal', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (2, 'Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (3, 'Very Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (5, 'Low', '2021-09-24 15:28:40');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `priority` varchar(100) NOT NULL,
  `specialist` varchar(100) NOT NULL,
  `doctor` int(11) DEFAULT NULL,
  `amount` varchar(200) NOT NULL,
  `message` text DEFAULT NULL,
  `appointment_status` varchar(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `is_opd` varchar(10) NOT NULL,
  `is_ipd` varchar(10) NOT NULL,
  `doctor_shift_time_id` int(11) DEFAULT NULL,
  `doctor_global_shift_id` int(11) DEFAULT NULL,
  `is_queue` int(11) DEFAULT NULL,
  `created_time` datetime DEFAULT NULL,
  `rejected_time` datetime DEFAULT NULL,
  `live_consult` varchar(50) DEFAULT NULL,
  `live_consult_link` int(11) NOT NULL DEFAULT 1 COMMENT '1 (link created) 0 (not created)',
  `consultation_charge` decimal(10,2) DEFAULT 0.00,
  `discount_percentage` decimal(5,2) DEFAULT 0.00,
  `tax_percentage` decimal(5,2) DEFAULT 0.00,
  `total_amount` decimal(10,2) DEFAULT 0.00,
  `payment_mode` varchar(50) DEFAULT NULL,
  `payment_status` enum('pending','paid','partial') DEFAULT 'pending',
  `payment_date` datetime DEFAULT NULL,
  `payment_notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `doctor` (`doctor`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `doctor_shift_time_id` (`doctor_shift_time_id`),
  KEY `idx_total_amount` (`total_amount`),
  KEY `idx_payment_status` (`payment_status`),
  KEY `idx_payment_date` (`payment_date`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `consultation_charge`, `discount_percentage`, `tax_percentage`, `total_amount`, `payment_mode`, `payment_status`, `payment_date`, `payment_notes`, `created_at`) VALUES (1, 8, 1, 1, '2025-06-09 07:00:00', '1', '', 2, '', '', 'approved', 'Offline', '', '', 1, 1, 0, NULL, NULL, 'no', 1, '0.00', '0.00', '0.00', '0.00', NULL, 'pending', NULL, NULL, '2025-06-06 13:32:18');


#
# TABLE STRUCTURE FOR: appointment_charges
#

DROP TABLE IF EXISTS `appointment_charges`;

CREATE TABLE `appointment_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) NOT NULL,
  `charge_category_id` int(11) DEFAULT NULL,
  `charge_name` varchar(200) NOT NULL DEFAULT 'Consultation',
  `base_amount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `discount_amount` decimal(10,2) DEFAULT 0.00,
  `discount_percentage` decimal(5,2) DEFAULT 0.00,
  `tax_amount` decimal(10,2) DEFAULT 0.00,
  `tax_percentage` decimal(5,2) DEFAULT 0.00,
  `net_amount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `quantity` int(11) DEFAULT 1,
  `unit_price` decimal(10,2) DEFAULT 0.00,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_appointment_id` (`appointment_id`),
  KEY `idx_charge_category` (`charge_category_id`),
  KEY `idx_net_amount` (`net_amount`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: appointment_payment
#

DROP TABLE IF EXISTS `appointment_payment`;

CREATE TABLE `appointment_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `standard_amount` float(10,2) NOT NULL DEFAULT 0.00,
  `tax` float(10,2) NOT NULL DEFAULT 0.00,
  `discount_percentage` float(10,2) NOT NULL DEFAULT 0.00,
  `paid_amount` float(10,2) NOT NULL,
  `payment_mode` varchar(50) DEFAULT NULL,
  `payment_type` varchar(100) NOT NULL,
  `transaction_id` varchar(255) DEFAULT NULL,
  `note` varchar(100) DEFAULT NULL,
  `date` datetime NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_id` (`charge_id`),
  KEY `appointment_id` (`appointment_id`),
  KEY `index_standard_amount` (`standard_amount`),
  KEY `index_tax` (`tax`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_paid_amount` (`paid_amount`),
  KEY `index_payment_mode` (`payment_mode`),
  KEY `index_payment_type` (`payment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `appointment_payment` (`id`, `appointment_id`, `charge_id`, `standard_amount`, `tax`, `discount_percentage`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`, `created_at`) VALUES (1, 1, 1, '2500.00', '0.00', '1.00', '2475.00', NULL, 'Offline', NULL, NULL, '2025-06-06 11:32:18', '2025-06-06 13:32:18');


#
# TABLE STRUCTURE FOR: appointment_queue
#

DROP TABLE IF EXISTS `appointment_queue`;

CREATE TABLE `appointment_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `shift_id` int(11) DEFAULT NULL,
  `date` date NOT NULL DEFAULT '2021-01-11',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `appointment_id` (`appointment_id`),
  KEY `staff_id` (`staff_id`),
  KEY `global_shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: appointment_transactions
#

DROP TABLE IF EXISTS `appointment_transactions`;

CREATE TABLE `appointment_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) NOT NULL,
  `transaction_type` enum('payment','refund','adjustment') DEFAULT 'payment',
  `amount` decimal(10,2) NOT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `reference_number` varchar(100) DEFAULT NULL,
  `transaction_date` datetime NOT NULL,
  `processed_by` int(11) DEFAULT NULL,
  `status` enum('pending','completed','failed','cancelled') DEFAULT 'pending',
  `gateway_response` text DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_appointment_id` (`appointment_id`),
  KEY `idx_transaction_date` (`transaction_date`),
  KEY `idx_amount` (`amount`),
  KEY `idx_status` (`status`),
  KEY `idx_processed_by` (`processed_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: bank_accounts
#

DROP TABLE IF EXISTS `bank_accounts`;

CREATE TABLE `bank_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_name` varchar(255) NOT NULL,
  `bank_name` varchar(255) NOT NULL,
  `account_number` varchar(50) NOT NULL,
  `iban` varchar(34) DEFAULT NULL,
  `swift_code` varchar(11) DEFAULT NULL,
  `account_type` enum('checking','savings','credit_card','line_of_credit','petty_cash') NOT NULL,
  `chart_account_id` int(11) NOT NULL,
  `opening_balance` decimal(15,2) DEFAULT 0.00,
  `current_balance` decimal(15,2) DEFAULT 0.00,
  `currency` varchar(3) DEFAULT 'USD',
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `account_number` (`account_number`),
  KEY `idx_chart_account_id` (`chart_account_id`),
  KEY `idx_is_active` (`is_active`),
  KEY `idx_account_type` (`account_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: bank_reconciliations
#

DROP TABLE IF EXISTS `bank_reconciliations`;

CREATE TABLE `bank_reconciliations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_account_id` int(11) NOT NULL,
  `reconciliation_date` date NOT NULL,
  `statement_ending_balance` decimal(15,2) NOT NULL,
  `book_ending_balance` decimal(15,2) NOT NULL,
  `difference` decimal(15,2) NOT NULL,
  `status` enum('draft','reconciled','unreconciled') DEFAULT 'draft',
  `notes` text DEFAULT NULL,
  `reconciled_by` int(11) DEFAULT NULL,
  `reconciled_at` timestamp NULL DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_bank_account_id` (`bank_account_id`),
  KEY `idx_reconciliation_date` (`reconciliation_date`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: bed
#

DROP TABLE IF EXISTS `bed`;

CREATE TABLE `bed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `bed_type_id` int(11) DEFAULT NULL,
  `bed_group_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `bed_type_id` (`bed_type_id`),
  KEY `bed_group_id` (`bed_group_id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: bed_group
#

DROP TABLE IF EXISTS `bed_group`;

CREATE TABLE `bed_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `color` varchar(50) NOT NULL DEFAULT '#f4f4f4',
  `description` text NOT NULL,
  `floor` int(11) NOT NULL,
  `is_active` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_color` (`color`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: bed_type
#

DROP TABLE IF EXISTS `bed_type`;

CREATE TABLE `bed_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: bill
#

DROP TABLE IF EXISTS `bill`;

CREATE TABLE `bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `case_id` int(11) NOT NULL,
  `attachment` mediumtext DEFAULT NULL,
  `attachment_name` mediumtext DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `payment_mode` varchar(100) DEFAULT NULL,
  `cheque_no` varchar(100) DEFAULT NULL,
  `cheque_date` date DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `note` mediumtext DEFAULT NULL,
  `received_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_id` (`case_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: billing_account_mapping
#

DROP TABLE IF EXISTS `billing_account_mapping`;

CREATE TABLE `billing_account_mapping` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_name` varchar(50) NOT NULL COMMENT 'opd, ipd, pathology, radiology, pharmacy, etc.',
  `transaction_type` varchar(50) NOT NULL COMMENT 'billing, payment, refund, etc.',
  `debit_account_id` int(11) NOT NULL,
  `credit_account_id` int(11) NOT NULL,
  `tax_account_id` int(11) DEFAULT NULL,
  `discount_account_id` int(11) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_module_transaction` (`module_name`,`transaction_type`),
  KEY `idx_debit_account_id` (`debit_account_id`),
  KEY `idx_credit_account_id` (`credit_account_id`),
  KEY `idx_tax_account_id` (`tax_account_id`),
  KEY `idx_discount_account_id` (`discount_account_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `billing_account_mapping` (`id`, `module_name`, `transaction_type`, `debit_account_id`, `credit_account_id`, `tax_account_id`, `discount_account_id`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (1, 'opd', 'billing', 5, 28, 18, 57, 1, NULL, '2025-06-26 21:00:13', '2025-06-26 21:00:13');
INSERT INTO `billing_account_mapping` (`id`, `module_name`, `transaction_type`, `debit_account_id`, `credit_account_id`, `tax_account_id`, `discount_account_id`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (2, 'ipd', 'billing', 5, 29, 18, 58, 1, NULL, '2025-06-26 21:00:13', '2025-06-26 21:00:13');
INSERT INTO `billing_account_mapping` (`id`, `module_name`, `transaction_type`, `debit_account_id`, `credit_account_id`, `tax_account_id`, `discount_account_id`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (3, 'pathology', 'billing', 5, 30, 18, 59, 1, NULL, '2025-06-26 21:00:13', '2025-06-26 21:00:13');
INSERT INTO `billing_account_mapping` (`id`, `module_name`, `transaction_type`, `debit_account_id`, `credit_account_id`, `tax_account_id`, `discount_account_id`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (4, 'radiology', 'billing', 5, 31, 18, 60, 1, NULL, '2025-06-26 21:00:13', '2025-06-26 21:00:13');
INSERT INTO `billing_account_mapping` (`id`, `module_name`, `transaction_type`, `debit_account_id`, `credit_account_id`, `tax_account_id`, `discount_account_id`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (5, 'pharmacy', 'billing', 5, 32, 18, 61, 1, NULL, '2025-06-26 21:00:13', '2025-06-26 21:00:13');
INSERT INTO `billing_account_mapping` (`id`, `module_name`, `transaction_type`, `debit_account_id`, `credit_account_id`, `tax_account_id`, `discount_account_id`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (6, 'blood_bank', 'billing', 5, 33, 18, 62, 1, NULL, '2025-06-26 21:00:13', '2025-06-26 21:00:13');
INSERT INTO `billing_account_mapping` (`id`, `module_name`, `transaction_type`, `debit_account_id`, `credit_account_id`, `tax_account_id`, `discount_account_id`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (7, 'ambulance', 'billing', 5, 34, 18, 63, 1, NULL, '2025-06-26 21:00:13', '2025-06-26 21:00:13');
INSERT INTO `billing_account_mapping` (`id`, `module_name`, `transaction_type`, `debit_account_id`, `credit_account_id`, `tax_account_id`, `discount_account_id`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (8, 'payment', 'cash', 1, 5, NULL, NULL, 1, NULL, '2025-06-26 21:00:13', '2025-06-26 21:00:13');
INSERT INTO `billing_account_mapping` (`id`, `module_name`, `transaction_type`, `debit_account_id`, `credit_account_id`, `tax_account_id`, `discount_account_id`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (9, 'payment', 'bank', 2, 5, NULL, NULL, 1, NULL, '2025-06-26 21:00:13', '2025-06-26 21:00:13');
INSERT INTO `billing_account_mapping` (`id`, `module_name`, `transaction_type`, `debit_account_id`, `credit_account_id`, `tax_account_id`, `discount_account_id`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (10, 'payment', 'card', 2, 5, NULL, NULL, 1, NULL, '2025-06-26 21:00:13', '2025-06-26 21:00:13');


#
# TABLE STRUCTURE FOR: billing_report_config
#

DROP TABLE IF EXISTS `billing_report_config`;

CREATE TABLE `billing_report_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_name` varchar(100) NOT NULL,
  `report_type` enum('summary','detailed','outstanding','trends') NOT NULL,
  `parameters` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_report_type` (`report_type`),
  KEY `created_by` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `billing_report_config` (`id`, `report_name`, `report_type`, `parameters`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (1, 'Daily Billing Summary', 'summary', '{\"period\":\"daily\",\"departments\":[\"all\"]}', 1, NULL, '2025-07-01 19:23:23', '2025-07-01 19:23:23');
INSERT INTO `billing_report_config` (`id`, `report_name`, `report_type`, `parameters`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (2, 'Monthly Revenue Report', 'summary', '{\"period\":\"monthly\",\"departments\":[\"all\"]}', 1, NULL, '2025-07-01 19:23:23', '2025-07-01 19:23:23');
INSERT INTO `billing_report_config` (`id`, `report_name`, `report_type`, `parameters`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (3, 'Outstanding Payments', 'outstanding', '{\"aging\":\"all\",\"departments\":[\"all\"]}', 1, NULL, '2025-07-01 19:23:23', '2025-07-01 19:23:23');
INSERT INTO `billing_report_config` (`id`, `report_name`, `report_type`, `parameters`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (4, 'Department Wise Billing', 'detailed', '{\"group_by\":\"department\",\"period\":\"monthly\"}', 1, NULL, '2025-07-01 19:23:23', '2025-07-01 19:23:23');
INSERT INTO `billing_report_config` (`id`, `report_name`, `report_type`, `parameters`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (5, 'Patient Billing Trends', 'trends', '{\"period\":\"yearly\",\"metric\":\"revenue\"}', 1, NULL, '2025-07-01 19:23:23', '2025-07-01 19:23:23');


#
# TABLE STRUCTURE FOR: birth_report
#

DROP TABLE IF EXISTS `birth_report`;

CREATE TABLE `birth_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `child_name` varchar(200) NOT NULL,
  `child_pic` text NOT NULL,
  `gender` varchar(200) NOT NULL,
  `birth_date` datetime DEFAULT NULL,
  `weight` varchar(200) NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `contact` varchar(20) NOT NULL,
  `mother_pic` text NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `father_pic` text NOT NULL,
  `birth_report` mediumtext DEFAULT NULL,
  `document` text NOT NULL,
  `address` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `patient_id` (`patient_id`),
  KEY `index_child_name` (`child_name`),
  KEY `index_gender` (`gender`),
  KEY `index_weight` (`weight`),
  KEY `index_contact` (`contact`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: blood_bank_products
#

DROP TABLE IF EXISTS `blood_bank_products`;

CREATE TABLE `blood_bank_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `is_blood_group` int(11) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: blood_donor
#

DROP TABLE IF EXISTS `blood_donor`;

CREATE TABLE `blood_donor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `donor_name` varchar(100) DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `blood_bank_product_id` int(11) DEFAULT NULL,
  `gender` varchar(11) DEFAULT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  KEY `index_donor_name` (`donor_name`),
  KEY `index_gender` (`gender`),
  KEY `index_father_name` (`father_name`),
  KEY `index_contact_no` (`contact_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: blood_donor_cycle
#

DROP TABLE IF EXISTS `blood_donor_cycle`;

CREATE TABLE `blood_donor_cycle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_donor_cycle_id` int(11) NOT NULL,
  `blood_bank_product_id` int(11) DEFAULT NULL,
  `blood_donor_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `donate_date` date DEFAULT NULL,
  `bag_no` varchar(11) DEFAULT NULL,
  `lot` varchar(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `standard_charge` float(10,2) DEFAULT NULL,
  `apply_charge` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `institution` text DEFAULT NULL,
  `note` text DEFAULT NULL,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `tax_percentage` float(10,2) DEFAULT 0.00,
  `volume` varchar(100) DEFAULT NULL,
  `unit` int(11) DEFAULT NULL,
  `available` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  KEY `blood_donor_id` (`blood_donor_id`),
  KEY `charge_id` (`charge_id`),
  KEY `index_bag_no` (`bag_no`),
  KEY `index_lot` (`lot`),
  KEY `index_amount` (`amount`),
  KEY `index_unit` (`unit`),
  KEY `index_volume` (`volume`),
  KEY `index_quantity` (`quantity`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_apply_charge` (`apply_charge`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: blood_group
#

DROP TABLE IF EXISTS `blood_group`;

CREATE TABLE `blood_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(10) NOT NULL,
  `is_blood_group` varchar(5) NOT NULL DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `blood_group` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (1, 'A+', 'yes', '2025-07-01 19:48:05');
INSERT INTO `blood_group` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (2, 'A-', 'yes', '2025-07-01 19:48:05');
INSERT INTO `blood_group` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (3, 'B+', 'yes', '2025-07-01 19:48:05');
INSERT INTO `blood_group` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (4, 'B-', 'yes', '2025-07-01 19:48:05');
INSERT INTO `blood_group` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (5, 'AB+', 'yes', '2025-07-01 19:48:05');
INSERT INTO `blood_group` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (6, 'AB-', 'yes', '2025-07-01 19:48:05');
INSERT INTO `blood_group` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (7, 'O+', 'yes', '2025-07-01 19:48:05');
INSERT INTO `blood_group` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (8, 'O-', 'yes', '2025-07-01 19:48:05');
INSERT INTO `blood_group` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (9, 'Unknown', 'no', '2025-07-01 19:48:05');


#
# TABLE STRUCTURE FOR: blood_issue
#

DROP TABLE IF EXISTS `blood_issue`;

CREATE TABLE `blood_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `blood_donor_cycle_id` int(11) DEFAULT NULL,
  `date_of_issue` datetime DEFAULT NULL,
  `hospital_doctor` int(11) DEFAULT NULL,
  `reference` text DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `standard_charge` int(11) NOT NULL,
  `tax_percentage` float(10,2) NOT NULL,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `amount` float(10,2) DEFAULT NULL,
  `net_amount` float(10,2) NOT NULL,
  `institution` text DEFAULT NULL,
  `technician` text DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `organisation_id` int(11) DEFAULT NULL,
  `insurance_validity` date DEFAULT NULL,
  `insurance_id` varchar(250) DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `blood_donor_cycle_id` (`blood_donor_cycle_id`),
  KEY `patient_id` (`patient_id`),
  KEY `charge_id` (`charge_id`),
  KEY `generated_by` (`generated_by`),
  KEY `organisation_id` (`organisation_id`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_amount` (`amount`),
  KEY `index_net_amount` (`net_amount`),
  KEY `hospital_doctor` (`hospital_doctor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: budget_lines
#

DROP TABLE IF EXISTS `budget_lines`;

CREATE TABLE `budget_lines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `budgeted_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `q1_amount` decimal(15,2) DEFAULT 0.00,
  `q2_amount` decimal(15,2) DEFAULT 0.00,
  `q3_amount` decimal(15,2) DEFAULT 0.00,
  `q4_amount` decimal(15,2) DEFAULT 0.00,
  `jan_amount` decimal(15,2) DEFAULT 0.00,
  `feb_amount` decimal(15,2) DEFAULT 0.00,
  `mar_amount` decimal(15,2) DEFAULT 0.00,
  `apr_amount` decimal(15,2) DEFAULT 0.00,
  `may_amount` decimal(15,2) DEFAULT 0.00,
  `jun_amount` decimal(15,2) DEFAULT 0.00,
  `jul_amount` decimal(15,2) DEFAULT 0.00,
  `aug_amount` decimal(15,2) DEFAULT 0.00,
  `sep_amount` decimal(15,2) DEFAULT 0.00,
  `oct_amount` decimal(15,2) DEFAULT 0.00,
  `nov_amount` decimal(15,2) DEFAULT 0.00,
  `dec_amount` decimal(15,2) DEFAULT 0.00,
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_budget_account` (`budget_id`,`account_id`),
  KEY `idx_account_id` (`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: budgets
#

DROP TABLE IF EXISTS `budgets`;

CREATE TABLE `budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_name` varchar(255) NOT NULL,
  `fiscal_year` year(4) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `total_budget` decimal(15,2) NOT NULL DEFAULT 0.00,
  `budget_type` enum('operational','capital','master') DEFAULT 'operational',
  `status` enum('draft','submitted','approved','active','closed','rejected') DEFAULT 'draft',
  `version` int(11) DEFAULT 1,
  `created_by` int(11) NOT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `approved_at` timestamp NULL DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_fiscal_year` (`fiscal_year`),
  KEY `idx_status` (`status`),
  KEY `idx_budget_type` (`budget_type`),
  KEY `idx_created_by` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: captcha
#

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (1, 'userlogin', 0, '2021-10-22 07:21:32');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (2, 'login', 0, '2021-10-22 07:21:38');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (3, 'appointment', 0, '2021-10-22 07:21:40');


#
# TABLE STRUCTURE FOR: case_references
#

DROP TABLE IF EXISTS `case_references`;

CREATE TABLE `case_references` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_id` int(11) DEFAULT NULL,
  `discount_percentage` float(10,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_references_ibfk_1` (`bill_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (1, NULL, '0.00', '2025-06-06 13:32:18');


#
# TABLE STRUCTURE FOR: certificates
#

DROP TABLE IF EXISTS `certificates`;

CREATE TABLE `certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) NOT NULL,
  `certificate_text` text DEFAULT NULL,
  `left_header` varchar(100) NOT NULL,
  `center_header` varchar(100) NOT NULL,
  `right_header` varchar(100) NOT NULL,
  `left_footer` varchar(100) NOT NULL,
  `right_footer` varchar(100) NOT NULL,
  `center_footer` varchar(100) NOT NULL,
  `background_image` text NOT NULL,
  `created_for` tinyint(1) NOT NULL COMMENT '1 = staff, 2 = patients',
  `status` tinyint(1) NOT NULL,
  `header_height` int(11) NOT NULL,
  `content_height` int(11) NOT NULL,
  `footer_height` int(11) NOT NULL,
  `content_width` int(11) NOT NULL,
  `enable_patient_image` tinyint(1) NOT NULL COMMENT '0=no,1=yes',
  `enable_image_height` int(11) NOT NULL,
  `updated_at` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (12, 'Sample Patient File Cover', '<table class=\"table table-bordered\" width=\"100%\">\r\n <tr>\r\n  <td width=\"50%\">Patient Name  </td>\r\n  <td width=\"50%\">[name] ([patient_id]) </td>\r\n </tr>\r\n <tr>\r\n  <td>Date of birth</td>\r\n  <td valign=\"top\">[dob]</td>\r\n </tr>\r\n <tr>\r\n  <td>Age</td>\r\n  <td valign=\"top\">[age]</td>\r\n </tr>\r\n <tr>\r\n  <td>Gender</td>\r\n  <td valign=\"top\">[gender]</td>\r\n </tr>\r\n \r\n <tr>\r\n  <td>Phone</td>\r\n  <td valign=\"top\">[phone]</td>\r\n </tr>\r\n <tr>\r\n  <td>Guardian Name</td>\r\n  <td valign=\"top\">[guardian_name]</td>\r\n </tr>\r\n <tr>\r\n  <td>Address</td>\r\n  <td valign=\"top\">[address]</td>\r\n </tr>\r\n <tr>\r\n  <td>Email</td>\r\n  <td valign=\"top\">[email]</td>\r\n </tr>\r\n <tr>\r\n  <td>OPD/IPD NO</td>\r\n  <td valign=\"top\">[opd_ipd_no]</td>\r\n </tr>\r\n  <tr>\r\n  <td>OPD Checkup Id</td>\r\n  <td valign=\"top\">[opd_checkup_id]</td>\r\n </tr>\r\n <tr>\r\n  <td>Consultant Doctor</td>\r\n  <td valign=\"top\">[consultant_doctor]</td>\r\n </tr>\r\n</table>', '<h2>Patient Detail</h2>', '', '', '', '', '', 'certificate.jpg', 2, 1, 140, 300, 700, 600, 1, 200, NULL, '2021-10-29 00:58:45');


#
# TABLE STRUCTURE FOR: charge_categories
#

DROP TABLE IF EXISTS `charge_categories`;

CREATE TABLE `charge_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type_id` int(11) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `short_code` varchar(30) DEFAULT NULL,
  `is_default` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_type_id` (`charge_type_id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (1, 1, 'Consultation', 'Consultation', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (2, 5, 'Radiology Investigation', NULL, NULL, '', '2025-06-28 19:37:12');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (3, 5, 'X-Ray Examination', NULL, NULL, '', '2025-06-28 19:37:12');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (4, 5, 'CT Scan Services', NULL, NULL, '', '2025-06-28 19:37:12');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (5, 5, 'MRI Services', NULL, NULL, '', '2025-06-28 19:37:12');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (6, 5, 'Ultrasound Services', NULL, NULL, '', '2025-06-28 19:37:12');


#
# TABLE STRUCTURE FOR: charge_type_master
#

DROP TABLE IF EXISTS `charge_type_master`;

CREATE TABLE `charge_type_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) NOT NULL,
  `is_default` varchar(10) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_charge_type` (`charge_type`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (1, 'Appointment', 'yes', 'yes', '2021-09-24 16:10:32');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (2, 'OPD', 'yes', 'yes', '2021-09-24 16:10:02');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (3, 'IPD', 'yes', 'yes', '2021-09-24 16:10:47');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (4, 'Pathology', 'yes', 'yes', '2021-10-22 23:40:03');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (5, 'Radiology', 'yes', 'yes', '2021-10-23 00:10:21');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (6, 'Blood Bank', 'yes', 'yes', '2021-10-23 00:10:33');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (7, 'Ambulance', 'yes', 'yes', '2021-10-23 00:10:44');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (8, 'Procedures', 'yes', 'yes', '2018-08-17 15:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (9, 'Investigations', 'yes', 'yes', '2018-08-17 15:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (10, 'Supplier', 'yes', 'yes', '2018-08-17 15:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (11, 'Operations', 'yes', 'yes', '2018-08-17 15:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (12, 'Others', 'yes', 'yes', '2018-08-17 15:40:07');


#
# TABLE STRUCTURE FOR: charge_type_module
#

DROP TABLE IF EXISTS `charge_type_module`;

CREATE TABLE `charge_type_module` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type_master_id` int(11) DEFAULT NULL,
  `module_shortcode` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_type_master_id` (`charge_type_master_id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (2, 1, 'appointment', '2021-10-23 05:52:42');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (4, 2, 'opd', '2021-10-23 05:52:45');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (5, 3, 'ipd', '2021-10-23 05:52:49');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (6, 4, 'pathology', '2021-10-23 05:52:52');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (7, 5, 'radiology', '2021-10-23 05:52:54');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (8, 6, 'blood_bank', '2021-10-23 05:52:56');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (9, 7, 'ambulance', '2021-10-23 05:52:59');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (10, 8, 'opd', '2021-10-23 05:53:03');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (11, 8, 'ipd', '2021-10-23 05:53:04');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (13, 9, 'pathology', '2021-10-23 05:53:09');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (14, 9, 'radiology', '2021-10-23 05:53:11');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (15, 10, 'opd', '2021-10-23 05:53:14');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (16, 10, 'ipd', '2021-10-23 05:53:16');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (17, 11, 'opd', '2021-10-23 05:53:18');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (18, 11, 'ipd', '2021-10-23 05:53:18');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (19, 12, 'appointment', '2021-10-23 05:53:20');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (20, 12, 'opd', '2021-10-23 05:53:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (21, 12, 'ipd', '2021-10-23 05:53:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (24, 12, 'pathology', '2021-10-23 05:53:25');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (25, 12, 'radiology', '2021-10-23 05:53:27');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (26, 12, 'blood_bank', '2021-10-23 05:53:30');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (27, 12, 'ambulance', '2021-10-23 05:53:31');


#
# TABLE STRUCTURE FOR: charge_units
#

DROP TABLE IF EXISTS `charge_units`;

CREATE TABLE `charge_units` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `unit` varchar(50) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_unit` (`unit`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (1, 'Initial', 0, '2025-06-06 13:28:26');


#
# TABLE STRUCTURE FOR: charges
#

DROP TABLE IF EXISTS `charges`;

CREATE TABLE `charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_category_id` int(11) DEFAULT NULL,
  `tax_category_id` int(11) DEFAULT NULL,
  `charge_unit_id` int(11) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `standard_charge` float(10,2) DEFAULT 0.00,
  `date` date DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_category_id` (`charge_category_id`),
  KEY `tax_category_id` (`tax_category_id`),
  KEY `charge_unit_id` (`charge_unit_id`),
  KEY `index_name` (`name`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_date` (`date`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (1, 1, 2, 1, 'Consultation', '2500.00', NULL, '', '', '2025-06-06 13:29:56');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (2, 2, 3, NULL, 'Chest X-Ray', '50.00', NULL, 'Standard chest X-ray examination', '', '2025-06-28 19:37:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (3, 2, 3, NULL, 'Abdominal Ultrasound', '120.00', NULL, 'Abdominal ultrasound examination', '', '2025-06-28 19:37:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (4, 2, 3, NULL, 'Head CT Scan', '300.00', NULL, 'CT scan of head without contrast', '', '2025-06-28 19:37:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (5, 2, 3, NULL, 'Brain MRI', '800.00', NULL, 'MRI scan of brain without contrast', '', '2025-06-28 19:37:12');


#
# TABLE STRUCTURE FOR: chart_of_accounts
#

DROP TABLE IF EXISTS `chart_of_accounts`;

CREATE TABLE `chart_of_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_code` varchar(20) NOT NULL,
  `account_name` varchar(255) NOT NULL,
  `account_type` enum('asset','liability','equity','revenue','expense') NOT NULL,
  `parent_account_id` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `opening_balance` decimal(15,2) DEFAULT 0.00,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `balance_type` enum('debit','credit') NOT NULL DEFAULT 'debit',
  `normal_balance` enum('debit','credit') NOT NULL DEFAULT 'debit' COMMENT 'Normal balance side for this account type',
  PRIMARY KEY (`id`),
  UNIQUE KEY `account_code` (`account_code`),
  KEY `parent_account_id` (`parent_account_id`),
  KEY `account_type` (`account_type`),
  KEY `is_active` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=172 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (1, '1000', 'Cash', 'asset', NULL, 'Cash in hand', 1, '50000.00', '2025-06-26 20:56:48', '2025-06-28 18:30:44', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (2, '1010', 'Bank - Current Account', 'asset', NULL, 'Primary bank account', 1, '100000.00', '2025-06-26 20:56:48', '2025-06-28 18:30:44', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (3, '1020', 'Bank - Savings Account', 'asset', NULL, 'Savings account', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (4, '1050', 'Petty Cash', 'asset', NULL, 'Petty cash fund', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (5, '1200', 'Accounts Receivable', 'asset', NULL, 'Amount owed by patients/customers', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (6, '1210', 'Allowance for Doubtful Accounts', 'asset', NULL, 'Provision for bad debts', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (7, '1300', 'Medical Supplies Inventory', 'asset', NULL, 'Medical supplies stock', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (8, '1310', 'Medicines Inventory', 'asset', NULL, 'Pharmaceutical inventory', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (9, '1320', 'Equipment Inventory', 'asset', NULL, 'Medical equipment inventory', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (10, '1400', 'Prepaid Expenses', 'asset', NULL, 'Expenses paid in advance', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (11, '1410', 'Prepaid Insurance', 'asset', NULL, 'Insurance premiums paid in advance', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (12, '1500', 'Equipment', 'asset', NULL, 'Medical and office equipment', 1, '75000.00', '2025-06-26 20:56:48', '2025-06-28 18:30:44', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (13, '1510', 'Accumulated Depreciation - Equipment', 'asset', NULL, 'Depreciation on equipment', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (14, '1600', 'Building', 'asset', NULL, 'Hospital building', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (15, '1610', 'Accumulated Depreciation - Building', 'asset', NULL, 'Depreciation on building', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (16, '2000', 'Accounts Payable', 'liability', NULL, 'Amount owed to suppliers', 1, '25000.00', '2025-06-26 20:56:48', '2025-06-28 18:30:44', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (17, '2100', 'Tax Payable', 'liability', NULL, 'Taxes owed to government', 1, '15000.00', '2025-06-26 20:56:48', '2025-06-28 18:30:44', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (18, '2110', 'GST/VAT Payable', 'liability', NULL, 'GST/VAT collected from customers', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (19, '2120', 'Income Tax Payable', 'liability', NULL, 'Income tax liability', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (20, '2200', 'Accrued Expenses', 'liability', NULL, 'Expenses incurred but not yet paid', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (21, '2210', 'Salary Payable', 'liability', NULL, 'Staff salaries payable', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (22, '2300', 'Bank Loan', 'liability', NULL, 'Bank loans and mortgages', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (23, '2400', 'Deposits from Patients', 'liability', NULL, 'Advance payments from patients', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (24, '3000', 'Owner Equity', 'equity', NULL, 'Owner\'s capital investment', 1, '185000.00', '2025-06-26 20:56:48', '2025-06-28 18:30:44', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (25, '3100', 'Retained Earnings', 'equity', NULL, 'Accumulated profits/losses', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (26, '3200', 'Current Year Earnings', 'equity', NULL, 'Current year profit/loss', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (27, '4000', 'General Consultation Revenue', 'revenue', NULL, 'Revenue from general consultations', 1, '0.00', '2025-06-26 20:56:48', '2025-07-06 16:14:10', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (28, '4100', 'OPD Revenue', 'revenue', NULL, 'Outpatient department revenue', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (29, '4200', 'IPD Revenue', 'revenue', NULL, 'Inpatient department revenue', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (30, '4300', 'Pathology Revenue', 'revenue', NULL, 'Laboratory services revenue', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (31, '4400', 'Radiology Revenue', 'revenue', NULL, 'Radiology services revenue', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (32, '4500', 'Pharmacy Revenue', 'revenue', NULL, 'Pharmacy sales revenue', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (33, '4600', 'Blood Bank Revenue', 'revenue', NULL, 'Blood bank services revenue', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (34, '4700', 'Ambulance Revenue', 'revenue', NULL, 'Ambulance services revenue', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (35, '4800', 'Other Revenue', 'revenue', NULL, 'Miscellaneous revenue', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (36, '4900', 'Interest Income', 'revenue', NULL, 'Interest earned on deposits', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (37, '5000', 'General Expense', 'expense', NULL, 'General operating expenses', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (38, '5010', 'Salary Expense', 'expense', NULL, 'Staff salaries and wages', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (39, '5020', 'Utilities Expense', 'expense', NULL, 'Electricity, water, gas expenses', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (40, '5030', 'Rent Expense', 'expense', NULL, 'Building and equipment rent', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (41, '5040', 'Maintenance Expense', 'expense', NULL, 'Equipment and building maintenance', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (42, '5050', 'Marketing Expense', 'expense', NULL, 'Advertising and marketing costs', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (43, '5060', 'Professional Fees', 'expense', NULL, 'Legal, audit, consulting fees', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (44, '5070', 'Insurance Expense', 'expense', NULL, 'Insurance premiums', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (45, '5080', 'Depreciation Expense', 'expense', NULL, 'Depreciation of assets', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (46, '5090', 'Office Supplies Expense', 'expense', NULL, 'Office supplies and stationery', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (47, '5100', 'Medical Supplies Expense', 'expense', NULL, 'Medical supplies consumed', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (48, '5110', 'Travel Expense', 'expense', NULL, 'Travel and transportation costs', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (49, '5120', 'Communication Expense', 'expense', NULL, 'Phone, internet, postage', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (50, '5130', 'Training Expense', 'expense', NULL, 'Staff training and development', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (51, '5140', 'Legal Expense', 'expense', NULL, 'Legal fees and court costs', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (52, '5150', 'Audit Expense', 'expense', NULL, 'External audit fees', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (53, '5200', 'Payment Processing Fees', 'expense', NULL, 'Credit card and payment processing fees', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (54, '5300', 'Refunds Expense', 'expense', NULL, 'Refunds issued to patients', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (55, '5400', 'Inventory Adjustment', 'expense', NULL, 'Inventory write-offs and adjustments', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (56, '6000', 'General Discount', 'expense', NULL, 'General discounts given', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (57, '6100', 'OPD Discount', 'expense', NULL, 'OPD service discounts', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (58, '6200', 'IPD Discount', 'expense', NULL, 'IPD service discounts', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (59, '6300', 'Pathology Discount', 'expense', NULL, 'Laboratory service discounts', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (60, '6400', 'Radiology Discount', 'expense', NULL, 'Radiology service discounts', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (61, '6500', 'Pharmacy Discount', 'expense', NULL, 'Pharmacy discounts', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (62, '6600', 'Blood Bank Discount', 'expense', NULL, 'Blood bank service discounts', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (63, '6700', 'Ambulance Discount', 'expense', NULL, 'Ambulance service discounts', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (64, '6800', 'Employee Discount', 'expense', NULL, 'Discounts given to employees', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (65, '6900', 'Senior Citizen Discount', 'expense', NULL, 'Senior citizen discounts', 1, '0.00', '2025-06-26 20:56:48', '2025-06-26 21:00:13', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (131, '1001', 'Cash Account', 'asset', NULL, 'Cash received from patients', 1, '0.00', '2025-06-27 08:07:14', '2025-07-06 16:14:10', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (132, '1002', 'Bank Account', 'asset', NULL, NULL, 1, '0.00', '2025-06-27 08:07:14', '2025-06-27 08:07:14', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (133, '2001', 'Accounts Payable', 'liability', NULL, NULL, 1, '0.00', '2025-06-27 08:07:14', '2025-06-28 18:34:20', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (134, '3001', 'Owner Equity', 'equity', NULL, NULL, 1, '0.00', '2025-06-27 08:07:14', '2025-06-28 18:34:20', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (135, '4001', 'Consultation Revenue', 'revenue', NULL, 'Revenue from medical consultations', 1, '0.00', '2025-06-27 08:07:14', '2025-07-06 16:14:10', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (136, '4002', 'IPD Revenue', 'revenue', NULL, NULL, 1, '0.00', '2025-06-27 08:07:14', '2025-06-28 18:34:20', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (137, '4003', 'Pathology Revenue', 'revenue', NULL, NULL, 1, '0.00', '2025-06-27 08:07:14', '2025-06-28 18:34:20', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (138, '4004', 'Radiology Revenue', 'revenue', NULL, 'Revenue from radiology services', 1, '0.00', '2025-06-27 08:07:14', '2025-07-06 16:14:10', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (139, '4005', 'Pharmacy Revenue', 'revenue', NULL, NULL, 1, '0.00', '2025-06-27 08:07:14', '2025-06-28 18:34:20', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (140, '4006', 'Laboratory Revenue', 'revenue', NULL, 'Revenue from laboratory services', 1, '0.00', '2025-06-27 08:07:14', '2025-07-06 16:14:10', 'credit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (141, '5001', 'Staff Salaries', 'expense', NULL, NULL, 1, '0.00', '2025-06-27 08:07:14', '2025-06-27 08:07:14', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (142, '5002', 'Doctor Fees', 'expense', NULL, NULL, 1, '0.00', '2025-06-27 08:07:14', '2025-06-27 08:07:14', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (143, '5003', 'Medical Supplies', 'expense', NULL, NULL, 1, '0.00', '2025-06-27 08:07:14', '2025-06-27 08:07:14', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (144, '5004', 'Utilities', 'expense', NULL, NULL, 1, '0.00', '2025-06-27 08:07:14', '2025-06-27 08:07:14', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (145, '5005', 'Equipment Maintenance', 'expense', NULL, NULL, 1, '0.00', '2025-06-27 08:07:14', '2025-06-27 08:07:14', 'debit', 'debit');
INSERT INTO `chart_of_accounts` (`id`, `account_code`, `account_name`, `account_type`, `parent_account_id`, `description`, `is_active`, `opening_balance`, `created_at`, `updated_at`, `balance_type`, `normal_balance`) VALUES (146, '5006', 'Office Expenses', 'expense', NULL, NULL, 1, '0.00', '2025-06-27 08:07:14', '2025-06-27 08:07:14', 'debit', 'debit');


#
# TABLE STRUCTURE FOR: chart_of_accounts_view
#

DROP TABLE IF EXISTS `chart_of_accounts_view`;

CREATE TABLE `chart_of_accounts_view` (
  `id` int(11) DEFAULT NULL,
  `account_code` varchar(20) DEFAULT NULL,
  `account_name` varchar(255) DEFAULT NULL,
  `account_type` enum('asset','liability','equity','revenue','expense') DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `opening_balance` decimal(15,2) DEFAULT NULL,
  `parent_account_name` varchar(255) DEFAULT NULL,
  `parent_account_code` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: chat_connections
#

DROP TABLE IF EXISTS `chat_connections`;

CREATE TABLE `chat_connections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chat_user_one` int(11) NOT NULL,
  `chat_user_two` int(11) NOT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_one` (`chat_user_one`),
  KEY `chat_user_two` (`chat_user_two`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: chat_messages
#

DROP TABLE IF EXISTS `chat_messages`;

CREATE TABLE `chat_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `chat_user_id` int(11) NOT NULL,
  `ip` varchar(30) NOT NULL,
  `time` int(11) NOT NULL,
  `is_first` int(11) DEFAULT 0,
  `is_read` int(11) NOT NULL DEFAULT 0,
  `chat_connection_id` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_id` (`chat_user_id`),
  KEY `chat_connection_id` (`chat_connection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: chat_users
#

DROP TABLE IF EXISTS `chat_users`;

CREATE TABLE `chat_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_type` varchar(20) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT NULL,
  `create_patient_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  KEY `create_staff_id` (`create_staff_id`),
  KEY `create_patient_id` (`create_patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type_id` int(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text DEFAULT NULL,
  `image` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `complaint_type_id` (`complaint_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_complaint_type` (`complaint_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: conference_staff
#

DROP TABLE IF EXISTS `conference_staff`;

CREATE TABLE `conference_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `conference_id` (`conference_id`),
  KEY `staff_id` (`staff_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: conferences
#

DROP TABLE IF EXISTS `conferences`;

CREATE TABLE `conferences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purpose` varchar(200) NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `ipd_id` int(11) DEFAULT NULL,
  `created_id` int(11) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `date` datetime NOT NULL,
  `duration` int(11) NOT NULL,
  `password` varchar(100) NOT NULL,
  `host_video` int(11) NOT NULL,
  `client_video` int(11) NOT NULL,
  `description` mediumtext DEFAULT NULL,
  `timezone` text DEFAULT NULL,
  `return_response` text DEFAULT NULL,
  `api_type` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `live_consult_link` int(11) NOT NULL DEFAULT 1 COMMENT 'appointment zoom link for front user status',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `created_id` (`created_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: conferences_history
#

DROP TABLE IF EXISTS `conferences_history`;

CREATE TABLE `conferences_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `total_hit` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `conference_id` (`conference_id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: consult_charges
#

DROP TABLE IF EXISTS `consult_charges`;

CREATE TABLE `consult_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor` int(11) DEFAULT NULL,
  `standard_charge` float(10,2) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `doctor` (`doctor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: consultant_register
#

DROP TABLE IF EXISTS `consultant_register`;

CREATE TABLE `consultant_register` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `ins_date` date DEFAULT NULL,
  `instruction` text DEFAULT NULL,
  `cons_doctor` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `cons_doctor` (`cons_doctor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: consultation_diagnosis
#

DROP TABLE IF EXISTS `consultation_diagnosis`;

CREATE TABLE `consultation_diagnosis` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `consultation_id` int(11) NOT NULL,
  `diagnosis_code_id` int(11) NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fk_consultation_diagnosis_consultation` (`consultation_id`),
  KEY `fk_consultation_diagnosis_code` (`diagnosis_code_id`),
  KEY `idx_consultation_primary` (`consultation_id`,`is_primary`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `consultation_diagnosis` (`id`, `consultation_id`, `diagnosis_code_id`, `is_primary`, `notes`, `created_at`) VALUES (1, 4, 8, 1, NULL, '2025-06-29 12:40:42');
INSERT INTO `consultation_diagnosis` (`id`, `consultation_id`, `diagnosis_code_id`, `is_primary`, `notes`, `created_at`) VALUES (2, 5, 13, 1, NULL, '2025-06-29 15:07:11');
INSERT INTO `consultation_diagnosis` (`id`, `consultation_id`, `diagnosis_code_id`, `is_primary`, `notes`, `created_at`) VALUES (3, 6, 8, 1, NULL, '2025-06-29 15:33:29');


#
# TABLE STRUCTURE FOR: consultation_financials
#

DROP TABLE IF EXISTS `consultation_financials`;

CREATE TABLE `consultation_financials` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `consultation_id` int(11) NOT NULL,
  `base_amount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `discount_percentage` decimal(5,2) NOT NULL DEFAULT 0.00,
  `discount_amount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `tax_percentage` decimal(5,2) NOT NULL DEFAULT 0.00,
  `tax_amount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `total_amount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `payment_mode` varchar(50) DEFAULT NULL,
  `payment_status` enum('pending','paid','partial') DEFAULT 'pending',
  `payment_notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `consultation_id` (`consultation_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `consultation_financials` (`id`, `consultation_id`, `base_amount`, `discount_percentage`, `discount_amount`, `tax_percentage`, `tax_amount`, `total_amount`, `payment_mode`, `payment_status`, `payment_notes`, `created_at`, `updated_at`) VALUES (1, 4, '150.00', '0.00', '0.00', '0.00', '0.00', '150.00', 'Cash', 'pending', '', '2025-06-29 12:40:42', NULL);
INSERT INTO `consultation_financials` (`id`, `consultation_id`, `base_amount`, `discount_percentage`, `discount_amount`, `tax_percentage`, `tax_amount`, `total_amount`, `payment_mode`, `payment_status`, `payment_notes`, `created_at`, `updated_at`) VALUES (2, 5, '1500.00', '0.00', '0.00', '0.00', '0.00', '1500.00', 'Cash', 'pending', '', '2025-06-29 15:07:11', NULL);
INSERT INTO `consultation_financials` (`id`, `consultation_id`, `base_amount`, `discount_percentage`, `discount_amount`, `tax_percentage`, `tax_amount`, `total_amount`, `payment_mode`, `payment_status`, `payment_notes`, `created_at`, `updated_at`) VALUES (3, 6, '1500.00', '0.00', '0.00', '0.00', '0.00', '1500.00', '', 'pending', '', '2025-06-29 15:33:29', NULL);
INSERT INTO `consultation_financials` (`id`, `consultation_id`, `base_amount`, `discount_percentage`, `discount_amount`, `tax_percentage`, `tax_amount`, `total_amount`, `payment_mode`, `payment_status`, `payment_notes`, `created_at`, `updated_at`) VALUES (4, 7, '150.00', '0.00', '0.00', '0.00', '0.00', '150.00', '', 'pending', '', '2025-06-30 08:10:20', NULL);


#
# TABLE STRUCTURE FOR: consultation_logs
#

DROP TABLE IF EXISTS `consultation_logs`;

CREATE TABLE `consultation_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `consultation_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `action` varchar(50) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `timestamp` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `consultation_id` (`consultation_id`),
  KEY `patient_id` (`patient_id`),
  KEY `user_id` (`user_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: consultations
#

DROP TABLE IF EXISTS `consultations`;

CREATE TABLE `consultations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `doctor` int(11) NOT NULL,
  `date` date NOT NULL,
  `symptoms` text DEFAULT NULL,
  `diagnosis` text DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `verification_status` enum('verified','unverified','skipped') DEFAULT 'unverified',
  `verification_score` int(11) DEFAULT 0,
  `verification_quality` varchar(50) DEFAULT NULL,
  `created_by` int(11) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `doctor` (`doctor`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (1, 8, 3, '2025-06-08', 'Test', 'Test', 'TEst', 'verified', 0, NULL, 1, '2025-06-08 05:41:12', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (2, 28, 3, '2025-06-18', 'Headache, Abdominal Pains', 'Acute Abdominal Pains', 'NAD', 'verified', 0, NULL, 1, '2025-06-18 05:06:02', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (3, 52, 3, '2025-06-25', 'tesrt', '', '', 'verified', 0, NULL, 1, '2025-06-25 16:02:07', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (4, 24, 3, '2025-06-29', 'Headache', 'I20.9 - Angina pectoris, unspecified', '', 'verified', 0, NULL, 1, '2025-06-29 12:40:42', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (5, 52, 3, '2025-06-29', 'Glucose\r\nHbA1c\r\nCBC\r\n', 'K59.0 - Constipation', '', 'verified', 0, NULL, 1, '2025-06-29 15:07:11', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (6, 36, 2, '2025-06-29', 'Headache\r\nCBC\r\nGlucose', 'I20.9 - Angina pectoris, unspecified', '', 'verified', 0, NULL, 1, '2025-06-29 15:33:29', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (7, 36, 3, '2025-06-30', 'CBC', 'K29.9 - Gastritis, unspecified', '', 'verified', 0, NULL, 1, '2025-06-30 08:10:20', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (8, 40, 3, '2025-07-01', 'CBC', NULL, 'None', 'verified', 0, '', 1, '2025-07-01 18:11:26', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (9, 40, 3, '2025-07-01', 'CBC', NULL, 'None', 'verified', 0, '', 1, '2025-07-01 18:14:24', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (10, 40, 3, '2025-07-01', 'CBC', NULL, 'None', 'verified', 0, '', 1, '2025-07-01 18:14:30', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (11, 40, 3, '2025-07-01', 'hffgh', NULL, 'ttlkk', 'verified', 0, '', 1, '2025-07-01 15:19:10', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (12, 54, 3, '2025-07-01', 'CBC', NULL, 'None', 'verified', 0, '', 1, '2025-07-01 15:28:33', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (13, 28, 3, '2025-07-01', 'great', NULL, 'great ', 'verified', 0, '', 1, '2025-07-01 17:51:37', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (14, 56, 3, '2025-07-03', 'CBC', NULL, '', 'verified', 0, '', 1, '2025-07-03 12:44:27', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (15, 57, 4, '2025-07-04', 'abdominal pain cramps', NULL, 'none', 'verified', 0, '', 1, '2025-07-04 04:04:16', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (16, 27, 2, '2025-07-04', 'Migraines', NULL, '', 'verified', 0, '', 1, '2025-07-04 09:51:28', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (17, 102, 2, '2025-07-06', 'dqwrtioplkgfdsaxcv,./\';][#=-09865543321`', NULL, '', 'verified', 0, '', 1, '2025-07-06 07:47:05', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (18, 130, 3, '2025-07-06', 'Test', NULL, 'CBC', 'verified', 0, '', 1, '2025-07-06 11:41:33', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (19, 133, 3, '2025-07-06', 'CBC', NULL, 'Blood Test required\r\nTest', 'verified', 0, '', 1, '2025-07-06 14:09:06', NULL);
INSERT INTO `consultations` (`id`, `patient_id`, `doctor`, `date`, `symptoms`, `diagnosis`, `notes`, `verification_status`, `verification_score`, `verification_quality`, `created_by`, `created_at`, `updated_at`) VALUES (20, 134, 3, '2025-07-07', 'Periodic Headaches, Dizzy spells', NULL, '', 'verified', 0, '', 1, '2025-07-07 12:15:14', NULL);


#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: content_types
#

DROP TABLE IF EXISTS `content_types`;

CREATE TABLE `content_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` int(11) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `file` text DEFAULT NULL,
  `note` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `belong_table_id` int(11) DEFAULT NULL,
  `custom_field_id` int(11) DEFAULT NULL,
  `field_value` varchar(500) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`),
  KEY `index_field_value` (`field_value`),
  KEY `index_belong_table_id` (`belong_table_id`),
  KEY `index_custom_field_id` (`custom_field_id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (44, 1, 0, 'gcc', '2025-07-20 11:14:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (45, 1, 0, '1', '2025-07-20 11:14:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (46, 1, 0, '10500.00', '2025-07-20 11:14:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (47, 1, 0, '1', '2025-07-20 11:14:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (48, 2, 0, 'gcc', '2025-07-20 11:17:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (49, 2, 0, '1', '2025-07-20 11:17:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (50, 2, 0, '10500.00', '2025-07-20 11:17:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (51, 2, 0, '1', '2025-07-20 11:17:25');


#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int(11) DEFAULT NULL,
  `validation` int(11) DEFAULT 0,
  `field_values` mediumtext DEFAULT NULL,
  `visible_on_print` int(11) DEFAULT NULL,
  `visible_on_report` int(11) DEFAULT NULL,
  `visible_on_table` int(11) DEFAULT NULL,
  `visible_on_patient_panel` int(11) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_belong_to` (`belong_to`),
  KEY `index_type` (`type`),
  KEY `index_visible_on_table` (`visible_on_table`),
  KEY `index_visible_on_print` (`visible_on_print`),
  KEY `index_visible_on_report` (`visible_on_report`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: death_report
#

DROP TABLE IF EXISTS `death_report`;

CREATE TABLE `death_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `attachment` text NOT NULL,
  `attachment_name` text DEFAULT NULL,
  `death_date` datetime NOT NULL,
  `guardian_name` varchar(200) NOT NULL,
  `death_report` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `patient_id` (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_department_name` (`department_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: department_billing
#

DROP TABLE IF EXISTS `department_billing`;

CREATE TABLE `department_billing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `department` enum('xray','laboratory','pharmacy') NOT NULL,
  `bill_no` varchar(50) NOT NULL,
  `bill_date` datetime NOT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `paid_amount` decimal(10,2) NOT NULL DEFAULT 0.00,
  `status` enum('pending','paid','cancelled') NOT NULL DEFAULT 'pending',
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `created_by` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: department_billing_items
#

DROP TABLE IF EXISTS `department_billing_items`;

CREATE TABLE `department_billing_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_id` int(11) NOT NULL,
  `item_name` varchar(255) NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit_price` decimal(10,2) NOT NULL,
  `total_price` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `bill_id` (`bill_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: department_billing_payments
#

DROP TABLE IF EXISTS `department_billing_payments`;

CREATE TABLE `department_billing_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_id` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `payment_date` datetime NOT NULL,
  `payment_mode` varchar(50) NOT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `bill_id` (`bill_id`),
  KEY `created_by` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: departments
#

DROP TABLE IF EXISTS `departments`;

CREATE TABLE `departments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(100) NOT NULL,
  `department_code` varchar(20) NOT NULL,
  `head_of_department` int(11) DEFAULT NULL,
  `budget_allocated` decimal(15,2) DEFAULT 0.00,
  `is_active` enum('yes','no') DEFAULT 'yes',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `department_code` (`department_code`),
  KEY `fk_hod` (`head_of_department`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `departments` (`id`, `department_name`, `department_code`, `head_of_department`, `budget_allocated`, `is_active`, `created_at`) VALUES (1, 'Pharmacy', 'PHARM', NULL, '0.00', 'yes', '2025-06-26 09:40:31');
INSERT INTO `departments` (`id`, `department_name`, `department_code`, `head_of_department`, `budget_allocated`, `is_active`, `created_at`) VALUES (2, 'Laboratory', 'LAB', NULL, '0.00', 'yes', '2025-06-26 09:40:31');
INSERT INTO `departments` (`id`, `department_name`, `department_code`, `head_of_department`, `budget_allocated`, `is_active`, `created_at`) VALUES (3, 'Radiology', 'RAD', NULL, '0.00', 'yes', '2025-06-26 09:40:31');
INSERT INTO `departments` (`id`, `department_name`, `department_code`, `head_of_department`, `budget_allocated`, `is_active`, `created_at`) VALUES (4, 'Surgery', 'SURG', NULL, '0.00', 'yes', '2025-06-26 09:40:31');
INSERT INTO `departments` (`id`, `department_name`, `department_code`, `head_of_department`, `budget_allocated`, `is_active`, `created_at`) VALUES (5, 'Emergency', 'EMER', NULL, '0.00', 'yes', '2025-06-26 09:40:31');
INSERT INTO `departments` (`id`, `department_name`, `department_code`, `head_of_department`, `budget_allocated`, `is_active`, `created_at`) VALUES (6, 'Administration', 'ADMIN', NULL, '0.00', 'yes', '2025-06-26 09:40:31');
INSERT INTO `departments` (`id`, `department_name`, `department_code`, `head_of_department`, `budget_allocated`, `is_active`, `created_at`) VALUES (7, 'Maintenance', 'MAINT', NULL, '0.00', 'yes', '2025-06-26 09:40:31');


#
# TABLE STRUCTURE FOR: diagnosis_codes
#

DROP TABLE IF EXISTS `diagnosis_codes`;

CREATE TABLE `diagnosis_codes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `icd_version` enum('ICD10','ICD11') NOT NULL DEFAULT 'ICD10',
  `code` varchar(20) NOT NULL,
  `title` varchar(500) NOT NULL,
  `description` text DEFAULT NULL,
  `category` varchar(100) DEFAULT NULL,
  `subcategory` varchar(100) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_code_version` (`code`,`icd_version`),
  KEY `idx_icd_version` (`icd_version`),
  KEY `idx_category` (`category`),
  KEY `idx_active` (`is_active`),
  KEY `idx_code` (`code`),
  KEY `idx_diagnosis_search` (`code`,`title`,`category`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'ICD10', 'A00', 'Cholera', 'Cholera due to Vibrio cholerae', 'Infectious diseases', 'Intestinal infectious diseases', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'ICD10', 'A01.0', 'Typhoid fever', 'Typhoid fever due to Salmonella typhi', 'Infectious diseases', 'Intestinal infectious diseases', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'ICD10', 'A09', 'Diarrhea and gastroenteritis', 'Diarrhea and gastroenteritis of presumed infectious origin', 'Infectious diseases', 'Intestinal infectious diseases', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'ICD10', 'B00.9', 'Herpes simplex infection, unspecified', 'Herpes simplex infection, unspecified', 'Infectious diseases', 'Viral infections', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'ICD10', 'E10', 'Type 1 diabetes mellitus', 'Type 1 diabetes mellitus', 'Endocrine diseases', 'Diabetes mellitus', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'ICD10', 'E11', 'Type 2 diabetes mellitus', 'Type 2 diabetes mellitus', 'Endocrine diseases', 'Diabetes mellitus', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'ICD10', 'I10', 'Essential hypertension', 'Essential (primary) hypertension', 'Circulatory diseases', 'Hypertensive diseases', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'ICD10', 'I20.9', 'Angina pectoris, unspecified', 'Angina pectoris, unspecified', 'Circulatory diseases', 'Ischemic heart diseases', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'ICD10', 'J00', 'Acute nasopharyngitis (common cold)', 'Acute nasopharyngitis [common cold]', 'Respiratory diseases', 'Upper respiratory tract infections', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'ICD10', 'J06.9', 'Acute upper respiratory infection', 'Acute upper respiratory infection, unspecified', 'Respiratory diseases', 'Upper respiratory tract infections', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'ICD10', 'J18.9', 'Pneumonia, unspecified', 'Pneumonia, unspecified organism', 'Respiratory diseases', 'Lower respiratory tract infections', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'ICD10', 'K29.9', 'Gastritis, unspecified', 'Gastroduodenitis, unspecified', 'Digestive diseases', 'Diseases of stomach and duodenum', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'ICD10', 'K59.0', 'Constipation', 'Constipation', 'Digestive diseases', 'Other diseases of intestines', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'ICD10', 'M79.3', 'Panniculitis, unspecified', 'Panniculitis, unspecified', 'Musculoskeletal diseases', 'Soft tissue disorders', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'ICD10', 'R05', 'Cough', 'Cough', 'Symptoms and signs', 'Respiratory and circulatory symptoms', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'ICD10', 'R50.9', 'Fever, unspecified', 'Fever, unspecified', 'Symptoms and signs', 'General symptoms', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'ICD10', 'R51', 'Headache', 'Headache', 'Symptoms and signs', 'Nervous system symptoms', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'ICD10', 'Z00.00', 'General medical examination', 'Encounter for general adult medical examination without abnormal findings', 'Health status', 'Health examination', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'ICD11', '1A00', 'Cholera', 'Cholera due to Vibrio cholerae', 'Infectious diseases', 'Intestinal infectious diseases', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (20, 'ICD11', '1A40.Z', 'Typhoid fever', 'Typhoid fever, unspecified', 'Infectious diseases', 'Intestinal infectious diseases', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'ICD11', '5A11', 'Type 1 diabetes mellitus', 'Type 1 diabetes mellitus', 'Endocrine diseases', 'Diabetes mellitus', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'ICD11', '5A10', 'Type 2 diabetes mellitus', 'Type 2 diabetes mellitus', 'Endocrine diseases', 'Diabetes mellitus', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'ICD11', 'BA00', 'Essential hypertension', 'Essential hypertension', 'Circulatory diseases', 'Hypertensive diseases', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'ICD11', 'CA40.Z', 'Pneumonia', 'Pneumonia, unspecified', 'Respiratory diseases', 'Lower respiratory tract infections', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');
INSERT INTO `diagnosis_codes` (`id`, `icd_version`, `code`, `title`, `description`, `category`, `subcategory`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'ICD11', 'MD90.0', 'Headache', 'Headache, unspecified', 'Symptoms and signs', 'Nervous system symptoms', 1, '2025-06-25 11:51:42', '2025-06-25 11:51:42');


#
# TABLE STRUCTURE FOR: discharge_card
#

DROP TABLE IF EXISTS `discharge_card`;

CREATE TABLE `discharge_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `case_reference_id` int(11) DEFAULT NULL,
  `opd_details_id` int(11) DEFAULT NULL,
  `ipd_details_id` int(11) DEFAULT NULL,
  `discharge_by` int(11) DEFAULT NULL,
  `discharge_date` datetime DEFAULT NULL,
  `discharge_status` int(11) NOT NULL,
  `death_date` datetime DEFAULT NULL,
  `refer_date` datetime DEFAULT NULL,
  `refer_to_hospital` varchar(255) DEFAULT NULL,
  `reason_for_referral` varchar(255) DEFAULT NULL,
  `operation` varchar(225) NOT NULL,
  `diagnosis` varchar(255) NOT NULL,
  `investigations` text DEFAULT NULL,
  `treatment_home` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `opd_details_id` (`opd_details_id`),
  KEY `ipd_details_id` (`ipd_details_id`),
  KEY `discharge_by` (`discharge_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `address` text DEFAULT NULL,
  `note` text DEFAULT NULL,
  `from_title` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `image` varchar(100) NOT NULL,
  `type` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_reference_no` (`reference_no`),
  KEY `index_to_title` (`to_title`),
  KEY `index_from_title` (`from_title`),
  KEY `index_date` (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: doctor_absent
#

DROP TABLE IF EXISTS `doctor_absent`;

CREATE TABLE `doctor_absent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `index_date` (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: doctor_global_shift
#

DROP TABLE IF EXISTS `doctor_global_shift`;

CREATE TABLE `doctor_global_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `global_shift_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `global_shift_id` (`global_shift_id`),
  KEY `staff_id` (`staff_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (1, 2, 1, '2025-06-06 13:23:52');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (2, 3, 1, '2025-06-06 13:23:53');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (3, 4, 1, '2025-06-06 13:23:55');


#
# TABLE STRUCTURE FOR: doctor_shift_time
#

DROP TABLE IF EXISTS `doctor_shift_time`;

CREATE TABLE `doctor_shift_time` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` varchar(20) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `doctor_global_shift_id` int(11) DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `doctor_global_shift_id` (`doctor_global_shift_id`),
  KEY `index_day` (`day`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (1, 'Monday', 2, 1, '07:00:00', '07:30:00', '2025-06-06 13:31:04');


#
# TABLE STRUCTURE FOR: dose_duration
#

DROP TABLE IF EXISTS `dose_duration`;

CREATE TABLE `dose_duration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: dose_interval
#

DROP TABLE IF EXISTS `dose_interval`;

CREATE TABLE `dose_interval` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: duty_roster_assign
#

DROP TABLE IF EXISTS `duty_roster_assign`;

CREATE TABLE `duty_roster_assign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` int(11) NOT NULL,
  `roster_duty_date` date DEFAULT NULL,
  `floor_id` int(11) DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `staff_id` int(11) NOT NULL,
  `duty_roster_list_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `duty_roster_list_id` (`duty_roster_list_id`),
  KEY `department_id` (`department_id`),
  KEY `staff_id` (`staff_id`),
  KEY `floor_id` (`floor_id`),
  KEY `index_roster_duty_date` (`roster_duty_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: duty_roster_list
#

DROP TABLE IF EXISTS `duty_roster_list`;

CREATE TABLE `duty_roster_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `duty_roster_shift_id` int(11) NOT NULL,
  `duty_roster_start_date` date NOT NULL,
  `duty_roster_end_date` date NOT NULL,
  `duty_roster_total_day` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `duty_roster_shift_id` (`duty_roster_shift_id`),
  KEY `index_duty_roster_start_date` (`duty_roster_start_date`),
  KEY `index_duty_roster_end_date` (`duty_roster_end_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: duty_roster_shift
#

DROP TABLE IF EXISTS `duty_roster_shift`;

CREATE TABLE `duty_roster_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shift_name` varchar(255) NOT NULL,
  `shift_start` time NOT NULL,
  `shift_end` time NOT NULL,
  `shift_hour` time NOT NULL,
  `is_active` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_shift_name` (`shift_name`),
  KEY `index_shift_start` (`shift_start`),
  KEY `index_shift_end` (`shift_end`),
  KEY `index_shift_hour` (`shift_hour`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `smtp_auth` varchar(10) NOT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_username`, `smtp_password`, `ssl_tls`, `smtp_auth`, `is_active`, `created_at`) VALUES (1, 'smtp', 'mail.cityhealth.co.ke', '465', 'smtp@cityhealth.co.ke', '#@#2025wemadeit', '', 'true', 'yes', '2025-07-21 16:49:26');


#
# TABLE STRUCTURE FOR: error_log
#

DROP TABLE IF EXISTS `error_log`;

CREATE TABLE `error_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `error_type` varchar(100) NOT NULL,
  `error_message` text DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_error_type` (`error_type`),
  KEY `idx_patient_id` (`patient_id`),
  KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `error_log` (`id`, `error_type`, `error_message`, `patient_id`, `created_at`) VALUES (1, 'TRIGGER_UPDATE_ERROR', 'Failed to create GCC financial entries on update', 128, '2025-07-06 12:31:09');
INSERT INTO `error_log` (`id`, `error_type`, `error_message`, `patient_id`, `created_at`) VALUES (2, 'GCC_FINANCIAL_ENTRY_ERROR', NULL, 128, '2025-07-06 12:50:37');
INSERT INTO `error_log` (`id`, `error_type`, `error_message`, `patient_id`, `created_at`) VALUES (3, 'GCC_FINANCIAL_ENTRY_ERROR', NULL, 129, '2025-07-06 12:58:22');
INSERT INTO `error_log` (`id`, `error_type`, `error_message`, `patient_id`, `created_at`) VALUES (4, 'TRIGGER_UPDATE_ERROR', 'Failed to create GCC financial entries on update', 53, '2025-07-10 21:15:34');
INSERT INTO `error_log` (`id`, `error_type`, `error_message`, `patient_id`, `created_at`) VALUES (5, 'TRIGGER_UPDATE_ERROR', 'Failed to create GCC financial entries on update', 55, '2025-07-10 21:15:34');
INSERT INTO `error_log` (`id`, `error_type`, `error_message`, `patient_id`, `created_at`) VALUES (6, 'TRIGGER_UPDATE_ERROR', 'Failed to create GCC financial entries on update', 56, '2025-07-10 21:15:34');
INSERT INTO `error_log` (`id`, `error_type`, `error_message`, `patient_id`, `created_at`) VALUES (7, 'TRIGGER_UPDATE_ERROR', 'Failed to create GCC financial entries on update', 57, '2025-07-10 21:15:34');
INSERT INTO `error_log` (`id`, `error_type`, `error_message`, `patient_id`, `created_at`) VALUES (8, 'TRIGGER_UPDATE_ERROR', 'Failed to create GCC financial entries on update', 58, '2025-07-10 21:15:34');
INSERT INTO `error_log` (`id`, `error_type`, `error_message`, `patient_id`, `created_at`) VALUES (9, 'TRIGGER_UPDATE_ERROR', 'Failed to create GCC financial entries on update', 78, '2025-07-10 21:15:34');


#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` text DEFAULT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `start_date` (`start_date`),
  KEY `index_end_date` (`end_date`),
  KEY `index_event_type` (`event_type`) USING BTREE,
  KEY `index_event_color` (`event_color`) USING BTREE,
  KEY `index_event_title` (`event_title`),
  KEY `role_id` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `is_deleted` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_exp_category` (`exp_category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `documents` text DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `is_deleted` varchar(10) DEFAULT 'no',
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `exp_head_id` (`exp_head_id`),
  KEY `generated_by` (`generated_by`),
  KEY `index_invoice_no` (`invoice_no`),
  KEY `index_name` (`name`),
  KEY `index_date` (`date`) USING BTREE,
  KEY `index_amount` (`amount`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: filetypes
#

DROP TABLE IF EXISTS `filetypes`;

CREATE TABLE `filetypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_extension` text DEFAULT NULL,
  `file_mime` text DEFAULT NULL,
  `file_size` int(11) NOT NULL,
  `image_extension` text DEFAULT NULL,
  `image_mime` text DEFAULT NULL,
  `image_size` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: financial_periods
#

DROP TABLE IF EXISTS `financial_periods`;

CREATE TABLE `financial_periods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `period_name` varchar(100) NOT NULL,
  `period_type` enum('monthly','quarterly','yearly') NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `fiscal_year` year(4) NOT NULL,
  `status` enum('open','closed','locked') DEFAULT 'open',
  `closed_by` int(11) DEFAULT NULL,
  `closed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_period` (`period_type`,`start_date`,`end_date`),
  KEY `idx_fiscal_year` (`fiscal_year`),
  KEY `idx_status` (`status`),
  KEY `idx_start_date` (`start_date`),
  KEY `idx_end_date` (`end_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: financial_reports_cache
#

DROP TABLE IF EXISTS `financial_reports_cache`;

CREATE TABLE `financial_reports_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_type` varchar(100) NOT NULL,
  `parameters` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`parameters`)),
  `parameters_hash` varchar(64) NOT NULL,
  `report_data` longtext NOT NULL,
  `file_path` varchar(500) DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `generated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_count` int(11) DEFAULT 0,
  `last_accessed` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_report_cache` (`report_type`,`parameters_hash`),
  KEY `idx_expires_at` (`expires_at`),
  KEY `idx_report_type` (`report_type`),
  KEY `idx_generated_by` (`generated_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: financial_settings
#

DROP TABLE IF EXISTS `financial_settings`;

CREATE TABLE `financial_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(100) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `setting_key` (`setting_key`),
  KEY `fk_settings_updater` (`updated_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: financial_transactions
#

DROP TABLE IF EXISTS `financial_transactions`;

CREATE TABLE `financial_transactions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `transaction_date` datetime NOT NULL,
  `transaction_type` enum('revenue','expense','asset','liability') NOT NULL,
  `category` varchar(50) NOT NULL,
  `subcategory` varchar(50) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL,
  `description` text DEFAULT NULL,
  `reference_table` varchar(50) DEFAULT NULL,
  `reference_id` int(11) DEFAULT NULL,
  `patient_id` varchar(50) DEFAULT NULL,
  `department` varchar(50) DEFAULT NULL,
  `payment_method` enum('cash','card','cheque','bank_transfer','mobile_money') DEFAULT NULL,
  `receipt_number` varchar(50) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`,`transaction_date`),
  KEY `idx_type` (`transaction_type`),
  KEY `idx_category` (`category`),
  KEY `idx_date` (`transaction_date`),
  KEY `idx_amount` (`amount`),
  KEY `idx_reference` (`reference_table`,`reference_id`),
  KEY `idx_patient` (`patient_id`),
  KEY `idx_department` (`department`),
  KEY `idx_payment_method` (`payment_method`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci
 PARTITION BY RANGE (year(`transaction_date`))
(PARTITION `p2023` VALUES LESS THAN (2024) ENGINE = InnoDB,
 PARTITION `p2024` VALUES LESS THAN (2025) ENGINE = InnoDB,
 PARTITION `p2025` VALUES LESS THAN (2026) ENGINE = InnoDB,
 PARTITION `p_future` VALUES LESS THAN MAXVALUE ENGINE = InnoDB);

INSERT INTO `financial_transactions` (`id`, `transaction_date`, `transaction_type`, `category`, `subcategory`, `amount`, `description`, `reference_table`, `reference_id`, `patient_id`, `department`, `payment_method`, `receipt_number`, `created_by`, `created_at`) VALUES ('1', '2025-07-06 14:30:59', 'revenue', 'medical_services', 'consultation', '1500.00', 'GCC Consultation Services', 'patients', 132, 'PAT-132', 'OPD', 'cash', 'GCC-20250706-132', 1, '2025-07-06 13:30:59');
INSERT INTO `financial_transactions` (`id`, `transaction_date`, `transaction_type`, `category`, `subcategory`, `amount`, `description`, `reference_table`, `reference_id`, `patient_id`, `department`, `payment_method`, `receipt_number`, `created_by`, `created_at`) VALUES ('2', '2025-07-06 14:30:59', 'revenue', 'medical_services', 'laboratory', '8000.00', 'GCC Laboratory Services', 'patients', 132, 'PAT-132', 'Laboratory', 'cash', 'GCC-20250706-132', 1, '2025-07-06 13:30:59');
INSERT INTO `financial_transactions` (`id`, `transaction_date`, `transaction_type`, `category`, `subcategory`, `amount`, `description`, `reference_table`, `reference_id`, `patient_id`, `department`, `payment_method`, `receipt_number`, `created_by`, `created_at`) VALUES ('3', '2025-07-06 14:30:59', 'revenue', 'medical_services', 'radiology', '1000.00', 'GCC Radiology Services', 'patients', 132, 'PAT-132', 'Radiology', 'cash', 'GCC-20250706-132', 1, '2025-07-06 13:30:59');
INSERT INTO `financial_transactions` (`id`, `transaction_date`, `transaction_type`, `category`, `subcategory`, `amount`, `description`, `reference_table`, `reference_id`, `patient_id`, `department`, `payment_method`, `receipt_number`, `created_by`, `created_at`) VALUES ('4', '2025-07-06 14:31:25', 'revenue', 'medical_services', 'consultation', '1500.00', 'GCC Consultation Services', 'patients', 132, 'PAT-132', 'OPD', 'cash', 'GCC-20250706-132', 1, '2025-07-06 13:31:25');
INSERT INTO `financial_transactions` (`id`, `transaction_date`, `transaction_type`, `category`, `subcategory`, `amount`, `description`, `reference_table`, `reference_id`, `patient_id`, `department`, `payment_method`, `receipt_number`, `created_by`, `created_at`) VALUES ('5', '2025-07-06 14:31:25', 'revenue', 'medical_services', 'laboratory', '8000.00', 'GCC Laboratory Services', 'patients', 132, 'PAT-132', 'Laboratory', 'cash', 'GCC-20250706-132', 1, '2025-07-06 13:31:25');
INSERT INTO `financial_transactions` (`id`, `transaction_date`, `transaction_type`, `category`, `subcategory`, `amount`, `description`, `reference_table`, `reference_id`, `patient_id`, `department`, `payment_method`, `receipt_number`, `created_by`, `created_at`) VALUES ('6', '2025-07-06 14:31:25', 'revenue', 'medical_services', 'radiology', '1000.00', 'GCC Radiology Services', 'patients', 132, 'PAT-132', 'Radiology', 'cash', 'GCC-20250706-132', 1, '2025-07-06 13:31:25');
INSERT INTO `financial_transactions` (`id`, `transaction_date`, `transaction_type`, `category`, `subcategory`, `amount`, `description`, `reference_table`, `reference_id`, `patient_id`, `department`, `payment_method`, `receipt_number`, `created_by`, `created_at`) VALUES ('7', '2025-07-06 15:05:04', 'revenue', 'medical_services', 'consultation', '1500.00', 'GCC Consultation Services', 'patients', 133, 'PAT-133', 'OPD', 'cash', 'GCC-20250706-133', 1, '2025-07-06 14:05:04');
INSERT INTO `financial_transactions` (`id`, `transaction_date`, `transaction_type`, `category`, `subcategory`, `amount`, `description`, `reference_table`, `reference_id`, `patient_id`, `department`, `payment_method`, `receipt_number`, `created_by`, `created_at`) VALUES ('8', '2025-07-06 15:05:04', 'revenue', 'medical_services', 'laboratory', '8000.00', 'GCC Laboratory Services', 'patients', 133, 'PAT-133', 'Laboratory', 'cash', 'GCC-20250706-133', 1, '2025-07-06 14:05:04');
INSERT INTO `financial_transactions` (`id`, `transaction_date`, `transaction_type`, `category`, `subcategory`, `amount`, `description`, `reference_table`, `reference_id`, `patient_id`, `department`, `payment_method`, `receipt_number`, `created_by`, `created_at`) VALUES ('9', '2025-07-06 15:05:04', 'revenue', 'medical_services', 'radiology', '1000.00', 'GCC Radiology Services', 'patients', 133, 'PAT-133', 'Radiology', 'cash', 'GCC-20250706-133', 1, '2025-07-06 14:05:04');
INSERT INTO `financial_transactions` (`id`, `transaction_date`, `transaction_type`, `category`, `subcategory`, `amount`, `description`, `reference_table`, `reference_id`, `patient_id`, `department`, `payment_method`, `receipt_number`, `created_by`, `created_at`) VALUES ('10', '2025-07-20 12:14:20', 'revenue', 'medical_services', 'consultation', '1500.00', 'GCC Consultation Services', 'patients', 1, 'PAT-1', 'OPD', 'cash', 'GCC-20250720-1', 1, '2025-07-20 12:14:20');
INSERT INTO `financial_transactions` (`id`, `transaction_date`, `transaction_type`, `category`, `subcategory`, `amount`, `description`, `reference_table`, `reference_id`, `patient_id`, `department`, `payment_method`, `receipt_number`, `created_by`, `created_at`) VALUES ('11', '2025-07-20 12:14:20', 'revenue', 'medical_services', 'laboratory', '8000.00', 'GCC Laboratory Services', 'patients', 1, 'PAT-1', 'Laboratory', 'cash', 'GCC-20250720-1', 1, '2025-07-20 12:14:20');
INSERT INTO `financial_transactions` (`id`, `transaction_date`, `transaction_type`, `category`, `subcategory`, `amount`, `description`, `reference_table`, `reference_id`, `patient_id`, `department`, `payment_method`, `receipt_number`, `created_by`, `created_at`) VALUES ('12', '2025-07-20 12:14:20', 'revenue', 'medical_services', 'radiology', '1000.00', 'GCC Radiology Services', 'patients', 1, 'PAT-1', 'Radiology', 'cash', 'GCC-20250720-1', 1, '2025-07-20 12:14:20');
INSERT INTO `financial_transactions` (`id`, `transaction_date`, `transaction_type`, `category`, `subcategory`, `amount`, `description`, `reference_table`, `reference_id`, `patient_id`, `department`, `payment_method`, `receipt_number`, `created_by`, `created_at`) VALUES ('13', '2025-07-20 12:17:25', 'revenue', 'medical_services', 'consultation', '1500.00', 'GCC Consultation Services', 'patients', 2, 'PAT-2', 'OPD', 'cash', 'GCC-20250720-2', 1, '2025-07-20 12:17:25');
INSERT INTO `financial_transactions` (`id`, `transaction_date`, `transaction_type`, `category`, `subcategory`, `amount`, `description`, `reference_table`, `reference_id`, `patient_id`, `department`, `payment_method`, `receipt_number`, `created_by`, `created_at`) VALUES ('14', '2025-07-20 12:17:25', 'revenue', 'medical_services', 'laboratory', '8000.00', 'GCC Laboratory Services', 'patients', 2, 'PAT-2', 'Laboratory', 'cash', 'GCC-20250720-2', 1, '2025-07-20 12:17:25');
INSERT INTO `financial_transactions` (`id`, `transaction_date`, `transaction_type`, `category`, `subcategory`, `amount`, `description`, `reference_table`, `reference_id`, `patient_id`, `department`, `payment_method`, `receipt_number`, `created_by`, `created_at`) VALUES ('15', '2025-07-20 12:17:25', 'revenue', 'medical_services', 'radiology', '1000.00', 'GCC Radiology Services', 'patients', 2, 'PAT-2', 'Radiology', 'cash', 'GCC-20250720-2', 1, '2025-07-20 12:17:25');


#
# TABLE STRUCTURE FOR: finding
#

DROP TABLE IF EXISTS `finding`;

CREATE TABLE `finding` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` text DEFAULT NULL,
  `finding_category_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `finding_category_id` (`finding_category_id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: finding_category
#

DROP TABLE IF EXISTS `finding_category`;

CREATE TABLE `finding_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: fingerprint_updates
#

DROP TABLE IF EXISTS `fingerprint_updates`;

CREATE TABLE `fingerprint_updates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `updated_by` int(11) NOT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `timestamp` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `updated_by` (`updated_by`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: fingerprint_verification_log
#

DROP TABLE IF EXISTS `fingerprint_verification_log`;

CREATE TABLE `fingerprint_verification_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) NOT NULL,
  `match_score` decimal(5,2) DEFAULT NULL,
  `is_match` tinyint(1) DEFAULT 0,
  `verification_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `staff_id` int(11) DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `verification_date` (`verification_date`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `fingerprint_verification_log` (`id`, `patient_id`, `match_score`, `is_match`, `verification_date`, `staff_id`, `ip_address`) VALUES (1, '21', '50.33', 0, '2025-06-09 11:56:29', 1, '102.5.178.164');
INSERT INTO `fingerprint_verification_log` (`id`, `patient_id`, `match_score`, `is_match`, `verification_date`, `staff_id`, `ip_address`) VALUES (2, '21', '46.44', 0, '2025-06-09 11:56:42', 1, '102.5.178.164');
INSERT INTO `fingerprint_verification_log` (`id`, `patient_id`, `match_score`, `is_match`, `verification_date`, `staff_id`, `ip_address`) VALUES (3, '21', '47.00', 0, '2025-06-09 11:56:52', 1, '102.5.178.164');
INSERT INTO `fingerprint_verification_log` (`id`, `patient_id`, `match_score`, `is_match`, `verification_date`, `staff_id`, `ip_address`) VALUES (4, '23', '38.60', 0, '2025-06-09 11:58:37', 1, '102.5.178.164');
INSERT INTO `fingerprint_verification_log` (`id`, `patient_id`, `match_score`, `is_match`, `verification_date`, `staff_id`, `ip_address`) VALUES (5, '23', '55.69', 0, '2025-06-09 11:58:52', 1, '102.5.178.164');
INSERT INTO `fingerprint_verification_log` (`id`, `patient_id`, `match_score`, `is_match`, `verification_date`, `staff_id`, `ip_address`) VALUES (6, '23', '53.99', 0, '2025-06-09 11:59:22', 1, '102.5.178.164');
INSERT INTO `fingerprint_verification_log` (`id`, `patient_id`, `match_score`, `is_match`, `verification_date`, `staff_id`, `ip_address`) VALUES (7, '23', '51.60', 0, '2025-06-09 12:41:45', 1, '102.5.178.164');
INSERT INTO `fingerprint_verification_log` (`id`, `patient_id`, `match_score`, `is_match`, `verification_date`, `staff_id`, `ip_address`) VALUES (8, '23', '43.64', 0, '2025-06-09 12:42:26', 1, '102.5.178.164');
INSERT INTO `fingerprint_verification_log` (`id`, `patient_id`, `match_score`, `is_match`, `verification_date`, `staff_id`, `ip_address`) VALUES (9, '23', '34.28', 0, '2025-06-09 12:43:32', 1, '102.5.178.164');


#
# TABLE STRUCTURE FOR: fingerprint_verification_logs
#

DROP TABLE IF EXISTS `fingerprint_verification_logs`;

CREATE TABLE `fingerprint_verification_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `module` varchar(50) NOT NULL,
  `verification_date` datetime NOT NULL,
  `verified_by` int(11) NOT NULL,
  `status` enum('success','failed') NOT NULL,
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `verified_by` (`verified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: floor
#

DROP TABLE IF EXISTS `floor`;

CREATE TABLE `floor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` mediumtext DEFAULT NULL,
  `vid_title` varchar(250) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) DEFAULT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `ext_url` mediumtext DEFAULT NULL,
  `open_new_tab` int(11) DEFAULT 0,
  `ext_url_link` mediumtext DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (1, 2, 'Home', 1, 0, NULL, NULL, NULL, 'home-1', NULL, 0, NULL, 'no', '2018-07-14 05:14:12');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (2, 1, 'Appointment', 0, 0, '1', NULL, 'http://yourdomainname.com/form/appointment', 'appointment', 2, 0, NULL, 'no', '2021-09-27 14:04:57');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (3, 1, 'Home', 1, 0, NULL, NULL, NULL, 'home', NULL, 0, NULL, 'no', '2019-01-24 05:18:17');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (4, 2, 'Appointment', 0, 0, '1', NULL, 'http://yourdomainname.com/form/appointment', 'appointment-1', NULL, 0, NULL, 'no', '2019-11-02 12:54:41');


#
# TABLE STRUCTURE FOR: front_cms_menus
#

DROP TABLE IF EXISTS `front_cms_menus`;

CREATE TABLE `front_cms_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `open_new_tab` int(11) NOT NULL DEFAULT 0,
  `ext_url` mediumtext DEFAULT NULL,
  `ext_url_link` mediumtext DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (1, 'Main Menu', 'main-menu', 'Main menu', 0, '', '', 0, 'default', 'no', '2018-04-20 05:54:49');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (2, 'Bottom Menu', 'bottom-menu', 'Bottom Menu', 0, '', '', 0, 'default', 'no', '2018-04-20 05:54:55');


#
# TABLE STRUCTURE FOR: front_cms_page_contents
#

DROP TABLE IF EXISTS `front_cms_page_contents`;

CREATE TABLE `front_cms_page_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int(11) DEFAULT 0,
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` mediumtext DEFAULT NULL,
  `meta_description` mediumtext DEFAULT NULL,
  `meta_keyword` mediumtext DEFAULT NULL,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `publish` int(11) DEFAULT 0,
  `sidebar` int(11) DEFAULT 0,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (1, 'default', 1, 'Home page first new', 'page/home-page-first-new', 'page', 'home-page-first-new', '', '', '', '', '<p>Home page first</p>', '0000-00-00', 1, 1, 'no', '2021-09-28 17:49:10');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (2, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<div class=\"col-md-12 col-sm-12\">\r\n<h2 class=\"text-center\">&nbsp;</h2>\r\n\r\n<p class=\"text-center\">[form-builder:complain]</p>\r\n</div>', '0000-00-00', 1, 1, 'no', '2019-01-24 05:00:12');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (3, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<title></title>\r\n<p>404 page found</p>', '0000-00-00', 0, NULL, 'no', '2021-09-24 13:35:15');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (4, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<p>[form-builder:contact_us]</p>', '0000-00-00', 0, NULL, 'no', '2021-09-24 08:27:54');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (5, 'manual', 0, 'our-appointment', 'page/our-appointment', 'page', 'our-appointment', '', '', '', '', '<form action=\"welcome/appointment\" method=\"get\">First name: <input name=\"fname\" type=\"text\" /><br />\r\nLast name: <input name=\"lname\" type=\"text\" /><br />\r\n<input type=\"submit\" value=\"Submit\" />&nbsp;</form>', '0000-00-00', 0, 1, 'no', '2021-09-24 13:35:25');


#
# TABLE STRUCTURE FOR: front_cms_program_photos
#

DROP TABLE IF EXISTS `front_cms_program_photos`;

CREATE TABLE `front_cms_program_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `program_id` int(11) DEFAULT NULL,
  `media_gallery_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `program_id` (`program_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_programs
#

DROP TABLE IF EXISTS `front_cms_programs`;

CREATE TABLE `front_cms_programs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` mediumtext DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` mediumtext DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `meta_title` mediumtext DEFAULT NULL,
  `meta_description` mediumtext DEFAULT NULL,
  `meta_keyword` mediumtext DEFAULT NULL,
  `feature_image` text DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `publish` varchar(10) NOT NULL DEFAULT '0',
  `sidebar` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: front_cms_settings
#

DROP TABLE IF EXISTS `front_cms_settings`;

CREATE TABLE `front_cms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int(11) DEFAULT 0,
  `is_active_front_cms` int(11) DEFAULT 0,
  `is_active_online_appointment` int(11) DEFAULT NULL,
  `is_active_sidebar` int(11) DEFAULT 0,
  `logo` text DEFAULT NULL,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` mediumtext DEFAULT NULL,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` mediumtext DEFAULT NULL,
  `footer_text` varchar(500) DEFAULT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `front_cms_settings` (`id`, `theme`, `is_active_rtl`, `is_active_front_cms`, `is_active_online_appointment`, `is_active_sidebar`, `logo`, `contact_us_email`, `complain_form_email`, `sidebar_options`, `fb_url`, `twitter_url`, `youtube_url`, `google_plus`, `instagram_url`, `pinterest_url`, `linkedin_url`, `google_analytics`, `footer_text`, `fav_icon`, `created_at`) VALUES (1, 'turquoise_blue', NULL, NULL, NULL, NULL, '', '', '', '[\"news\",\"complain\"]', '', '', '', '', '', '', '', '', '', '', '2024-08-21 11:29:55');


#
# TABLE STRUCTURE FOR: gateway_ins
#

DROP TABLE IF EXISTS `gateway_ins`;

CREATE TABLE `gateway_ins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `online_appointment_id` int(11) DEFAULT NULL,
  `type` varchar(30) NOT NULL COMMENT 'patient_bill,appointment	',
  `gateway_name` varchar(50) NOT NULL,
  `module_type` varchar(255) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `parameter_details` mediumtext NOT NULL,
  `payment_status` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_type` (`type`),
  KEY `index_gateway_name` (`gateway_name`),
  KEY `index_module_type` (`module_type`),
  KEY `index_unique_id` (`unique_id`),
  KEY `online_appointment_id` (`online_appointment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: gateway_ins_response
#

DROP TABLE IF EXISTS `gateway_ins_response`;

CREATE TABLE `gateway_ins_response` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gateway_ins_id` int(11) DEFAULT NULL,
  `posted_data` text DEFAULT NULL,
  `response` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `gateway_ins_id` (`gateway_ins_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: gcc_patient_tests
#

DROP TABLE IF EXISTS `gcc_patient_tests`;

CREATE TABLE `gcc_patient_tests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `gcc_test_id` int(11) NOT NULL,
  `status` enum('pending','in_progress','completed','abnormal','cancelled') DEFAULT 'pending',
  `result` text DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `performed_by` int(11) DEFAULT NULL,
  `performed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_patient_id` (`patient_id`),
  KEY `idx_gcc_test_id` (`gcc_test_id`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: gcc_tests
#

DROP TABLE IF EXISTS `gcc_tests`;

CREATE TABLE `gcc_tests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_name` varchar(255) NOT NULL,
  `test_code` varchar(50) NOT NULL,
  `test_category` varchar(100) NOT NULL,
  `is_mandatory` tinyint(1) DEFAULT 1,
  `test_order` int(11) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `test_code` (`test_code`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `gcc_tests` (`id`, `test_name`, `test_code`, `test_category`, `is_mandatory`, `test_order`, `created_at`) VALUES (1, 'Complete Blood Count', 'CBC', 'hematology', 1, 1, '2025-06-30 11:52:47');
INSERT INTO `gcc_tests` (`id`, `test_name`, `test_code`, `test_category`, `is_mandatory`, `test_order`, `created_at`) VALUES (2, 'Blood Glucose', 'BG', 'biochemistry', 1, 2, '2025-06-30 11:52:47');
INSERT INTO `gcc_tests` (`id`, `test_name`, `test_code`, `test_category`, `is_mandatory`, `test_order`, `created_at`) VALUES (3, 'Hepatitis B Surface Antigen', 'HBsAg', 'serology', 1, 3, '2025-06-30 11:52:47');
INSERT INTO `gcc_tests` (`id`, `test_name`, `test_code`, `test_category`, `is_mandatory`, `test_order`, `created_at`) VALUES (4, 'Hepatitis C Antibody', 'HCV', 'serology', 1, 4, '2025-06-30 11:52:47');
INSERT INTO `gcc_tests` (`id`, `test_name`, `test_code`, `test_category`, `is_mandatory`, `test_order`, `created_at`) VALUES (5, 'HIV Screening', 'HIV', 'serology', 1, 5, '2025-06-30 11:52:47');
INSERT INTO `gcc_tests` (`id`, `test_name`, `test_code`, `test_category`, `is_mandatory`, `test_order`, `created_at`) VALUES (6, 'Chest X-Ray', 'CXR', 'radiology', 1, 6, '2025-06-30 11:52:47');
INSERT INTO `gcc_tests` (`id`, `test_name`, `test_code`, `test_category`, `is_mandatory`, `test_order`, `created_at`) VALUES (7, 'ECG', 'ECG', 'cardiology', 1, 7, '2025-06-30 11:52:47');
INSERT INTO `gcc_tests` (`id`, `test_name`, `test_code`, `test_category`, `is_mandatory`, `test_order`, `created_at`) VALUES (8, 'Urine Analysis', 'UA', 'clinical_pathology', 1, 8, '2025-06-30 11:52:47');
INSERT INTO `gcc_tests` (`id`, `test_name`, `test_code`, `test_category`, `is_mandatory`, `test_order`, `created_at`) VALUES (9, 'VDRL/Syphilis', 'VDRL', 'serology', 1, 9, '2025-06-30 11:52:47');
INSERT INTO `gcc_tests` (`id`, `test_name`, `test_code`, `test_category`, `is_mandatory`, `test_order`, `created_at`) VALUES (10, 'Tuberculosis Screening', 'TB', 'microbiology', 1, 10, '2025-06-30 11:52:47');


#
# TABLE STRUCTURE FOR: general_calls
#

DROP TABLE IF EXISTS `general_calls`;

CREATE TABLE `general_calls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` text DEFAULT NULL,
  `follow_up_date` date DEFAULT NULL,
  `call_duration` varchar(50) NOT NULL,
  `note` mediumtext DEFAULT NULL,
  `call_type` varchar(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_contact` (`contact`),
  KEY `index_date` (`date`),
  KEY `index_call_duration` (`call_duration`),
  KEY `index_follow_up_date` (`follow_up_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: general_ledger
#

DROP TABLE IF EXISTS `general_ledger`;

CREATE TABLE `general_ledger` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `transaction_date` date NOT NULL,
  `account_id` int(11) NOT NULL,
  `reference_type` varchar(50) DEFAULT NULL,
  `reference_id` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `debit_amount` decimal(15,2) DEFAULT 0.00,
  `credit_amount` decimal(15,2) DEFAULT 0.00,
  `running_balance` decimal(15,2) DEFAULT NULL,
  `posted_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`,`transaction_date`),
  KEY `idx_account` (`account_id`),
  KEY `idx_date` (`transaction_date`),
  KEY `idx_reference` (`reference_type`,`reference_id`),
  KEY `idx_amounts` (`debit_amount`,`credit_amount`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci
 PARTITION BY RANGE (to_days(`transaction_date`))
(PARTITION `p2023` VALUES LESS THAN (739251) ENGINE = InnoDB,
 PARTITION `p2024` VALUES LESS THAN (739617) ENGINE = InnoDB,
 PARTITION `p2025` VALUES LESS THAN (739982) ENGINE = InnoDB,
 PARTITION `p_future` VALUES LESS THAN MAXVALUE ENGINE = InnoDB);

INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('1', '2025-07-06', 131, 'gcc_registration', 132, 'Cash received for GCC services', '10500.00', '0.00', NULL, 1, '2025-07-06 13:30:59');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('2', '2025-07-06', 135, 'gcc_registration', 132, 'GCC Consultation Revenue', '0.00', '1500.00', NULL, 1, '2025-07-06 13:30:59');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('3', '2025-07-06', 140, 'gcc_registration', 132, 'GCC Laboratory Revenue', '0.00', '8000.00', NULL, 1, '2025-07-06 13:30:59');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('4', '2025-07-06', 138, 'gcc_registration', 132, 'GCC Radiology Revenue', '0.00', '1000.00', NULL, 1, '2025-07-06 13:30:59');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('5', '2025-07-06', 131, 'gcc_registration', 132, 'Cash received for GCC services', '10500.00', '0.00', NULL, 1, '2025-07-06 13:31:25');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('6', '2025-07-06', 135, 'gcc_registration', 132, 'GCC Consultation Revenue', '0.00', '1500.00', NULL, 1, '2025-07-06 13:31:25');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('7', '2025-07-06', 140, 'gcc_registration', 132, 'GCC Laboratory Revenue', '0.00', '8000.00', NULL, 1, '2025-07-06 13:31:25');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('8', '2025-07-06', 138, 'gcc_registration', 132, 'GCC Radiology Revenue', '0.00', '1000.00', NULL, 1, '2025-07-06 13:31:25');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('9', '2025-07-06', 131, 'gcc_registration', 133, 'Cash received for GCC services', '10500.00', '0.00', NULL, 1, '2025-07-06 14:05:04');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('10', '2025-07-06', 135, 'gcc_registration', 133, 'GCC Consultation Revenue', '0.00', '1500.00', NULL, 1, '2025-07-06 14:05:04');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('11', '2025-07-06', 140, 'gcc_registration', 133, 'GCC Laboratory Revenue', '0.00', '8000.00', NULL, 1, '2025-07-06 14:05:04');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('12', '2025-07-06', 138, 'gcc_registration', 133, 'GCC Radiology Revenue', '0.00', '1000.00', NULL, 1, '2025-07-06 14:05:04');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('13', '2025-07-20', 131, 'gcc_registration', 1, 'Cash received for GCC services', '10500.00', '0.00', NULL, 1, '2025-07-20 12:14:20');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('14', '2025-07-20', 135, 'gcc_registration', 1, 'GCC Consultation Revenue', '0.00', '1500.00', NULL, 1, '2025-07-20 12:14:20');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('15', '2025-07-20', 140, 'gcc_registration', 1, 'GCC Laboratory Revenue', '0.00', '8000.00', NULL, 1, '2025-07-20 12:14:20');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('16', '2025-07-20', 138, 'gcc_registration', 1, 'GCC Radiology Revenue', '0.00', '1000.00', NULL, 1, '2025-07-20 12:14:20');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('17', '2025-07-20', 131, 'gcc_registration', 2, 'Cash received for GCC services', '10500.00', '0.00', NULL, 1, '2025-07-20 12:17:25');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('18', '2025-07-20', 135, 'gcc_registration', 2, 'GCC Consultation Revenue', '0.00', '1500.00', NULL, 1, '2025-07-20 12:17:25');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('19', '2025-07-20', 140, 'gcc_registration', 2, 'GCC Laboratory Revenue', '0.00', '8000.00', NULL, 1, '2025-07-20 12:17:25');
INSERT INTO `general_ledger` (`id`, `transaction_date`, `account_id`, `reference_type`, `reference_id`, `description`, `debit_amount`, `credit_amount`, `running_balance`, `posted_by`, `created_at`) VALUES ('20', '2025-07-20', 138, 'gcc_registration', 2, 'GCC Radiology Revenue', '0.00', '1000.00', NULL, 1, '2025-07-20 12:17:25');


#
# TABLE STRUCTURE FOR: general_ledger_with_account
#

DROP TABLE IF EXISTS `general_ledger_with_account`;

CREATE TABLE `general_ledger_with_account` (
  `id` bigint(20) DEFAULT NULL,
  `transaction_date` date DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `reference_type` varchar(50) DEFAULT NULL,
  `reference_id` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `debit_amount` decimal(15,2) DEFAULT NULL,
  `credit_amount` decimal(15,2) DEFAULT NULL,
  `running_balance` decimal(15,2) DEFAULT NULL,
  `posted_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `account_code` varchar(20) DEFAULT NULL,
  `account_name` varchar(255) DEFAULT NULL,
  `account_type` enum('asset','liability','equity','revenue','expense') DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: global_shift
#

DROP TABLE IF EXISTS `global_shift`;

CREATE TABLE `global_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_start_time` (`start_time`),
  KEY `index_end_time` (`end_time`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (1, 'Morning', '07:00:00', '08:30:00', '2025-06-06 13:22:37');


#
# TABLE STRUCTURE FOR: goods_received_notes
#

DROP TABLE IF EXISTS `goods_received_notes`;

CREATE TABLE `goods_received_notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grn_number` varchar(50) NOT NULL,
  `purchase_order_id` int(11) NOT NULL,
  `supplier_delivery_note` varchar(100) DEFAULT NULL,
  `received_date` datetime NOT NULL,
  `received_by` int(11) NOT NULL,
  `quality_check_status` enum('pending','passed','failed','partial') DEFAULT 'pending',
  `quality_checked_by` int(11) DEFAULT NULL,
  `quality_check_date` datetime DEFAULT NULL,
  `quality_notes` text DEFAULT NULL,
  `storage_location` varchar(100) DEFAULT NULL,
  `total_received_value` decimal(15,2) DEFAULT 0.00,
  `discrepancy_notes` text DEFAULT NULL,
  `status` enum('draft','verified','posted','disputed') DEFAULT 'draft',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `grn_number` (`grn_number`),
  UNIQUE KEY `unique_grn_number` (`grn_number`),
  KEY `fk_grn_po` (`purchase_order_id`),
  KEY `fk_grn_received_by` (`received_by`),
  KEY `fk_grn_quality_checked` (`quality_checked_by`),
  KEY `idx_grn_date_status` (`received_date`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: grn_items
#

DROP TABLE IF EXISTS `grn_items`;

CREATE TABLE `grn_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grn_id` int(11) NOT NULL,
  `purchase_order_item_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `quantity_ordered` int(11) NOT NULL,
  `quantity_received` int(11) NOT NULL,
  `quantity_accepted` int(11) DEFAULT 0,
  `quantity_rejected` int(11) DEFAULT 0,
  `unit_cost` decimal(10,2) NOT NULL,
  `total_value` decimal(15,2) NOT NULL,
  `batch_number` varchar(100) DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  `manufacturing_date` date DEFAULT NULL,
  `serial_numbers` text DEFAULT NULL,
  `condition_on_receipt` enum('excellent','good','fair','damaged') DEFAULT 'good',
  `rejection_reason` text DEFAULT NULL,
  `storage_location` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fk_grn_item` (`grn_id`),
  KEY `fk_grn_po_item` (`purchase_order_item_id`),
  KEY `fk_grn_item_master` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inc_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT 0.00,
  `note` text DEFAULT NULL,
  `is_deleted` varchar(10) DEFAULT 'no',
  `documents` text DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `inc_head_id` (`inc_head_id`),
  KEY `generated_by` (`generated_by`),
  KEY `index_name` (`name`),
  KEY `index_invoice_no` (`invoice_no`),
  KEY `index_date` (`date`),
  KEY `index_amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: income_head
#

DROP TABLE IF EXISTS `income_head`;

CREATE TABLE `income_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `income_category` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_income_category` (`income_category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: inventory_alerts
#

DROP TABLE IF EXISTS `inventory_alerts`;

CREATE TABLE `inventory_alerts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` bigint(20) unsigned NOT NULL,
  `location_id` bigint(20) unsigned DEFAULT NULL,
  `alert_type` enum('low_stock','expiry','out_of_stock','overstock') NOT NULL,
  `alert_level` enum('info','warning','critical') NOT NULL,
  `message` text NOT NULL,
  `is_read` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `read_at` timestamp NULL DEFAULT NULL,
  `read_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `location_id` (`location_id`),
  KEY `alert_type` (`alert_type`),
  KEY `is_read` (`is_read`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: inventory_assets
#

DROP TABLE IF EXISTS `inventory_assets`;

CREATE TABLE `inventory_assets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_tag` varchar(50) NOT NULL,
  `item_id` bigint(20) unsigned NOT NULL,
  `location_id` bigint(20) unsigned NOT NULL,
  `serial_number` varchar(100) DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_cost` decimal(12,2) DEFAULT 0.00,
  `warranty_expiry` date DEFAULT NULL,
  `depreciation_rate` decimal(5,2) DEFAULT 0.00,
  `current_value` decimal(12,2) DEFAULT 0.00,
  `condition_status` enum('excellent','good','fair','poor','damaged','disposed') DEFAULT 'good',
  `assigned_to` bigint(20) unsigned DEFAULT NULL,
  `maintenance_schedule` enum('weekly','monthly','quarterly','annually','as_needed') DEFAULT 'as_needed',
  `last_maintenance` date DEFAULT NULL,
  `next_maintenance` date DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `asset_tag` (`asset_tag`),
  KEY `item_id` (`item_id`),
  KEY `location_id` (`location_id`),
  KEY `assigned_to` (`assigned_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: inventory_categories
#

DROP TABLE IF EXISTS `inventory_categories`;

CREATE TABLE `inventory_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(100) NOT NULL,
  `category_code` varchar(20) NOT NULL,
  `description` text DEFAULT NULL,
  `parent_category_id` int(11) DEFAULT NULL,
  `is_active` enum('yes','no') DEFAULT 'yes',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `category_code` (`category_code`),
  KEY `parent_category_id` (`parent_category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `inventory_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Medicines', 'MED', 'Pharmaceutical products and medications', NULL, 'yes', '2025-06-24 19:19:44', NULL);
INSERT INTO `inventory_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Medical Devices', 'DEV', 'Medical equipment and devices', NULL, 'yes', '2025-06-24 19:19:44', NULL);
INSERT INTO `inventory_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Surgical Instruments', 'SUR', 'Surgical tools and instruments', NULL, 'yes', '2025-06-24 19:19:44', NULL);
INSERT INTO `inventory_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'Laboratory Supplies', 'LAB', 'Laboratory consumables and reagents', NULL, 'yes', '2025-06-24 19:19:44', NULL);
INSERT INTO `inventory_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Office Supplies', 'OFF', 'General office and administrative supplies', NULL, 'yes', '2025-06-24 19:19:44', NULL);
INSERT INTO `inventory_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'Cleaning Supplies', 'CLN', 'Cleaning and sanitation products', NULL, 'yes', '2025-06-24 19:19:44', NULL);
INSERT INTO `inventory_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'IT Equipment', 'IT', 'Information technology equipment', NULL, 'yes', '2025-06-24 19:19:44', NULL);
INSERT INTO `inventory_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Furniture', 'FUR', 'Hospital furniture and fixtures', NULL, 'yes', '2025-06-24 19:19:44', NULL);


#
# TABLE STRUCTURE FOR: inventory_locations
#

DROP TABLE IF EXISTS `inventory_locations`;

CREATE TABLE `inventory_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `location_code` varchar(20) NOT NULL,
  `location_name` varchar(100) NOT NULL,
  `location_type` enum('warehouse','pharmacy','ward','emergency','ot','icu','lab','store') NOT NULL,
  `department_id` int(11) DEFAULT NULL,
  `responsible_staff_id` int(11) DEFAULT NULL,
  `is_active` enum('yes','no') DEFAULT 'yes',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `location_code` (`location_code`),
  KEY `location_type` (`location_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: inventory_maintenance
#

DROP TABLE IF EXISTS `inventory_maintenance`;

CREATE TABLE `inventory_maintenance` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint(20) unsigned NOT NULL,
  `maintenance_type` enum('preventive','corrective','emergency','routine') NOT NULL,
  `maintenance_date` date NOT NULL,
  `description` text NOT NULL,
  `cost` decimal(10,2) DEFAULT 0.00,
  `performed_by` varchar(255) DEFAULT NULL,
  `next_maintenance_date` date DEFAULT NULL,
  `status` enum('scheduled','in_progress','completed','cancelled') DEFAULT 'scheduled',
  `created_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `asset_id` (`asset_id`),
  KEY `maintenance_date` (`maintenance_date`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: ipd_details
#

DROP TABLE IF EXISTS `ipd_details`;

CREATE TABLE `ipd_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `height` varchar(5) DEFAULT NULL,
  `weight` varchar(5) DEFAULT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `bp` varchar(20) DEFAULT NULL,
  `bed` int(11) DEFAULT NULL,
  `bed_group_id` int(11) DEFAULT NULL,
  `case_type` varchar(100) NOT NULL,
  `casualty` varchar(100) NOT NULL,
  `symptoms` longtext NOT NULL,
  `known_allergies` varchar(200) DEFAULT NULL,
  `patient_old` varchar(50) NOT NULL,
  `note` text DEFAULT NULL,
  `refference` varchar(200) NOT NULL,
  `cons_doctor` int(11) DEFAULT NULL,
  `organisation_id` int(11) DEFAULT NULL,
  `credit_limit` varchar(100) NOT NULL,
  `payment_mode` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `discharged` varchar(200) NOT NULL,
  `live_consult` varchar(50) DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `is_antenatal` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `cons_doctor` (`cons_doctor`),
  KEY `bed_group_id` (`bed_group_id`),
  KEY `bed` (`bed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: ipd_details_partitioned
#

DROP TABLE IF EXISTS `ipd_details_partitioned`;

CREATE TABLE `ipd_details_partitioned` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) NOT NULL,
  `date` date NOT NULL,
  `case_type` varchar(50) DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `payment_mode` varchar(20) DEFAULT NULL,
  `discharge_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`,`date`),
  KEY `idx_patient` (`patient_id`),
  KEY `idx_amount` (`amount`),
  KEY `idx_payment_mode` (`payment_mode`),
  KEY `idx_discharge` (`discharge_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci
 PARTITION BY RANGE (year(`date`))
(PARTITION `p2023` VALUES LESS THAN (2024) ENGINE = InnoDB,
 PARTITION `p2024` VALUES LESS THAN (2025) ENGINE = InnoDB,
 PARTITION `p2025` VALUES LESS THAN (2026) ENGINE = InnoDB,
 PARTITION `p_future` VALUES LESS THAN MAXVALUE ENGINE = InnoDB);

#
# TABLE STRUCTURE FOR: ipd_doctors
#

DROP TABLE IF EXISTS `ipd_doctors`;

CREATE TABLE `ipd_doctors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) NOT NULL,
  `consult_doctor` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `consult_doctor` (`consult_doctor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: ipd_prescription_basic
#

DROP TABLE IF EXISTS `ipd_prescription_basic`;

CREATE TABLE `ipd_prescription_basic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `attachment` text NOT NULL,
  `attachment_name` text NOT NULL,
  `header_note` text DEFAULT NULL,
  `footer_note` text DEFAULT NULL,
  `finding_description` text DEFAULT NULL,
  `is_finding_print` varchar(100) DEFAULT NULL,
  `date` date NOT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `prescribe_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `generated_by` (`generated_by`),
  KEY `index_date` (`date`),
  KEY `prescribe_by` (`prescribe_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: ipd_prescription_details
#

DROP TABLE IF EXISTS `ipd_prescription_details`;

CREATE TABLE `ipd_prescription_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `basic_id` int(11) DEFAULT NULL,
  `pharmacy_id` int(11) DEFAULT NULL,
  `dosage` int(11) DEFAULT NULL,
  `dose_interval_id` int(11) DEFAULT NULL,
  `dose_duration_id` int(11) DEFAULT NULL,
  `instruction` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `basic_id` (`basic_id`),
  KEY `pharmacy_id` (`pharmacy_id`),
  KEY `index_dosage` (`dosage`),
  KEY `index_dose_interval_id` (`dose_interval_id`),
  KEY `index_dose_duration_id` (`dose_duration_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: ipd_prescription_test
#

DROP TABLE IF EXISTS `ipd_prescription_test`;

CREATE TABLE `ipd_prescription_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_prescription_basic_id` int(11) DEFAULT NULL,
  `pathology_id` int(11) DEFAULT NULL,
  `radiology_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_prescription_basic_id` (`ipd_prescription_basic_id`),
  KEY `pathology_id` (`pathology_id`),
  KEY `radiology_id` (`radiology_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_category_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `unit` varchar(200) NOT NULL,
  `item_photo` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `quantity` int(11) NOT NULL,
  `date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `index_name` (`name`),
  KEY `index_unit` (`unit`),
  KEY `index_quantity` (`quantity`),
  KEY `index_date` (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: item_categories
#

DROP TABLE IF EXISTS `item_categories`;

CREATE TABLE `item_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(100) NOT NULL,
  `category_code` varchar(20) NOT NULL,
  `description` text DEFAULT NULL,
  `parent_category_id` int(11) DEFAULT NULL,
  `is_active` enum('yes','no') DEFAULT 'yes',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `category_code` (`category_code`),
  KEY `fk_parent_category` (`parent_category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `item_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Medical Supplies', 'MED', 'General medical supplies and consumables', NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47');
INSERT INTO `item_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Pharmaceuticals', 'PHARM', 'Medicines and pharmaceutical products', NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47');
INSERT INTO `item_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Laboratory Equipment', 'LAB_EQ', 'Laboratory equipment and instruments', NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47');
INSERT INTO `item_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'Laboratory Supplies', 'LAB_SUP', 'Laboratory consumables and reagents', NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47');
INSERT INTO `item_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Office Supplies', 'OFFICE', 'General office supplies and stationery', NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47');
INSERT INTO `item_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'Maintenance Supplies', 'MAINT', 'Maintenance and repair supplies', NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47');
INSERT INTO `item_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'IT Equipment', 'IT', 'Information technology equipment', NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47');
INSERT INTO `item_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Furniture', 'FURN', 'Office and medical furniture', NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47');
INSERT INTO `item_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'Cleaning Supplies', 'CLEAN', 'Cleaning and sanitation supplies', NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47');
INSERT INTO `item_categories` (`id`, `category_name`, `category_code`, `description`, `parent_category_id`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'Safety Equipment', 'SAFETY', 'Personal protective equipment and safety items', NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47');


#
# TABLE STRUCTURE FOR: item_category
#

DROP TABLE IF EXISTS `item_category`;

CREATE TABLE `item_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_category` varchar(255) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'yes',
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_item_category` (`item_category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: item_issue
#

DROP TABLE IF EXISTS `item_issue`;

CREATE TABLE `item_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_type` int(11) DEFAULT NULL,
  `issue_to` int(11) DEFAULT NULL,
  `issue_by` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `quantity` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `is_returned` int(11) NOT NULL DEFAULT 1,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `issue_to` (`issue_to`),
  KEY `index_issue_date` (`issue_date`),
  KEY `index_return_date` (`return_date`),
  KEY `index_quantity` (`quantity`),
  KEY `index_is_returned` (`is_returned`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: item_stock
#

DROP TABLE IF EXISTS `item_stock`;

CREATE TABLE `item_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `symbol` varchar(10) NOT NULL DEFAULT '+',
  `store_id` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `purchase_price` float(10,2) DEFAULT 0.00,
  `date` date DEFAULT NULL,
  `attachment` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `store_id` (`store_id`),
  KEY `index_quantity` (`quantity`),
  KEY `index_purchase_price` (`purchase_price`),
  KEY `index_date` (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: item_store
#

DROP TABLE IF EXISTS `item_store`;

CREATE TABLE `item_store` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_store` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_item_store` (`item_store`),
  KEY `index_code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: item_supplier
#

DROP TABLE IF EXISTS `item_supplier`;

CREATE TABLE `item_supplier` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_supplier` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `contact_person_name` varchar(255) NOT NULL,
  `contact_person_phone` varchar(255) NOT NULL,
  `contact_person_email` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_item_supplier` (`item_supplier`),
  KEY `index_phone` (`phone`),
  KEY `index_email` (`email`),
  KEY `index_address` (`address`),
  KEY `index_contact_person_name` (`contact_person_name`),
  KEY `index_contact_person_phone` (`contact_person_phone`),
  KEY `index_contact_person_email` (`contact_person_email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: items
#

DROP TABLE IF EXISTS `items`;

CREATE TABLE `items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_code` varchar(50) NOT NULL,
  `item_name` varchar(200) NOT NULL,
  `description` text DEFAULT NULL,
  `category_id` int(11) NOT NULL,
  `unit_of_measure` varchar(50) NOT NULL DEFAULT 'pieces',
  `unit_cost` decimal(10,2) DEFAULT 0.00,
  `minimum_stock` int(11) DEFAULT 0,
  `maximum_stock` int(11) DEFAULT 0,
  `reorder_level` int(11) DEFAULT 0,
  `current_stock` int(11) DEFAULT 0,
  `item_type` enum('consumable','non_consumable','service') DEFAULT 'consumable',
  `is_prescription_required` enum('yes','no') DEFAULT 'no',
  `manufacturer` varchar(100) DEFAULT NULL,
  `brand` varchar(100) DEFAULT NULL,
  `specifications` text DEFAULT NULL,
  `is_active` enum('yes','no') DEFAULT 'yes',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `item_code` (`item_code`),
  UNIQUE KEY `unique_item_code` (`item_code`),
  KEY `fk_item_category` (`category_id`),
  KEY `idx_item_type` (`item_type`),
  KEY `idx_is_active` (`is_active`),
  KEY `idx_items_category_active` (`category_id`,`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `items` (`id`, `item_code`, `item_name`, `description`, `category_id`, `unit_of_measure`, `unit_cost`, `minimum_stock`, `maximum_stock`, `reorder_level`, `current_stock`, `item_type`, `is_prescription_required`, `manufacturer`, `brand`, `specifications`, `is_active`, `created_at`, `updated_at`, `created_by`) VALUES (1, 'SYR001', 'Disposable Syringes 5ml', 'Sterile disposable syringes', 1, 'pieces', '15.00', 100, 1000, 200, 0, 'consumable', 'no', NULL, NULL, NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47', NULL);
INSERT INTO `items` (`id`, `item_code`, `item_name`, `description`, `category_id`, `unit_of_measure`, `unit_cost`, `minimum_stock`, `maximum_stock`, `reorder_level`, `current_stock`, `item_type`, `is_prescription_required`, `manufacturer`, `brand`, `specifications`, `is_active`, `created_at`, `updated_at`, `created_by`) VALUES (2, 'GLV001', 'Latex Gloves Medium', 'Disposable latex examination gloves', 1, 'box', '800.00', 10, 100, 20, 0, 'consumable', 'no', NULL, NULL, NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47', NULL);
INSERT INTO `items` (`id`, `item_code`, `item_name`, `description`, `category_id`, `unit_of_measure`, `unit_cost`, `minimum_stock`, `maximum_stock`, `reorder_level`, `current_stock`, `item_type`, `is_prescription_required`, `manufacturer`, `brand`, `specifications`, `is_active`, `created_at`, `updated_at`, `created_by`) VALUES (3, 'PAR001', 'Paracetamol 500mg', 'Pain relief medication', 2, 'tablets', '2.50', 500, 5000, 1000, 0, 'consumable', 'no', NULL, NULL, NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47', NULL);
INSERT INTO `items` (`id`, `item_code`, `item_name`, `description`, `category_id`, `unit_of_measure`, `unit_cost`, `minimum_stock`, `maximum_stock`, `reorder_level`, `current_stock`, `item_type`, `is_prescription_required`, `manufacturer`, `brand`, `specifications`, `is_active`, `created_at`, `updated_at`, `created_by`) VALUES (4, 'AMX001', 'Amoxicillin 250mg', 'Antibiotic capsules', 2, 'tablets', '8.00', 200, 2000, 400, 0, 'consumable', 'no', NULL, NULL, NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47', NULL);
INSERT INTO `items` (`id`, `item_code`, `item_name`, `description`, `category_id`, `unit_of_measure`, `unit_cost`, `minimum_stock`, `maximum_stock`, `reorder_level`, `current_stock`, `item_type`, `is_prescription_required`, `manufacturer`, `brand`, `specifications`, `is_active`, `created_at`, `updated_at`, `created_by`) VALUES (5, 'GAUS001', 'Sterile Gauze 4x4', 'Sterile gauze pads', 1, 'pieces', '25.00', 50, 500, 100, 0, 'consumable', 'no', NULL, NULL, NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47', NULL);
INSERT INTO `items` (`id`, `item_code`, `item_name`, `description`, `category_id`, `unit_of_measure`, `unit_cost`, `minimum_stock`, `maximum_stock`, `reorder_level`, `current_stock`, `item_type`, `is_prescription_required`, `manufacturer`, `brand`, `specifications`, `is_active`, `created_at`, `updated_at`, `created_by`) VALUES (6, 'TEST001', 'Blood Test Tubes', 'EDTA blood collection tubes', 4, 'pieces', '35.00', 100, 1000, 200, 0, 'consumable', 'no', NULL, NULL, NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47', NULL);
INSERT INTO `items` (`id`, `item_code`, `item_name`, `description`, `category_id`, `unit_of_measure`, `unit_cost`, `minimum_stock`, `maximum_stock`, `reorder_level`, `current_stock`, `item_type`, `is_prescription_required`, `manufacturer`, `brand`, `specifications`, `is_active`, `created_at`, `updated_at`, `created_by`) VALUES (7, 'PEN001', 'Ballpoint Pens Blue', 'Office writing pens', 5, 'pieces', '20.00', 20, 200, 50, 0, 'consumable', 'no', NULL, NULL, NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47', NULL);
INSERT INTO `items` (`id`, `item_code`, `item_name`, `description`, `category_id`, `unit_of_measure`, `unit_cost`, `minimum_stock`, `maximum_stock`, `reorder_level`, `current_stock`, `item_type`, `is_prescription_required`, `manufacturer`, `brand`, `specifications`, `is_active`, `created_at`, `updated_at`, `created_by`) VALUES (8, 'CHAIR001', 'Office Chair Executive', 'Ergonomic office chair', 8, 'pieces', '15000.00', 2, 20, 5, 0, 'non_consumable', 'no', NULL, NULL, NULL, 'yes', '2025-06-26 08:30:47', '2025-06-26 08:30:47', NULL);


#
# TABLE STRUCTURE FOR: journal_audit_trail
#

DROP TABLE IF EXISTS `journal_audit_trail`;

CREATE TABLE `journal_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `journal_id` int(11) NOT NULL,
  `action` enum('created','updated','approved','rejected','reversed','deleted') NOT NULL,
  `old_data` text DEFAULT NULL,
  `new_data` text DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `journal_id` (`journal_id`),
  KEY `action` (`action`),
  KEY `user_id` (`user_id`),
  KEY `created_at` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `journal_audit_trail` (`id`, `journal_id`, `action`, `old_data`, `new_data`, `user_id`, `ip_address`, `user_agent`, `created_at`) VALUES (1, 4, 'created', NULL, '{\"activity_type\":\"radiology_order_created\",\"source_id\":22,\"amount\":5800}', 1, '41.90.187.95', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:139.0) Gecko/20100101 Firefox/139.0', '2025-07-11 03:15:34');


#
# TABLE STRUCTURE FOR: journal_entries
#

DROP TABLE IF EXISTS `journal_entries`;

CREATE TABLE `journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `date` date NOT NULL,
  `description` text DEFAULT NULL,
  `total_amount` decimal(15,2) NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `source_module` varchar(50) DEFAULT NULL,
  `source_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference_no` (`reference_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: journal_entry_lines
#

DROP TABLE IF EXISTS `journal_entry_lines`;

CREATE TABLE `journal_entry_lines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `journal_entry_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `debit_amount` decimal(15,2) DEFAULT 0.00,
  `credit_amount` decimal(15,2) DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `journal_entry_id` (`journal_entry_id`),
  KEY `account_id` (`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: journal_headers
#

DROP TABLE IF EXISTS `journal_headers`;

CREATE TABLE `journal_headers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `date` date NOT NULL,
  `description` text NOT NULL,
  `total_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `source_module` varchar(50) DEFAULT NULL COMMENT 'opd, ipd, pathology, radiology, pharmacy, payment, manual',
  `source_id` int(11) DEFAULT NULL COMMENT 'ID from source module',
  `patient_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `status` enum('draft','pending','approved','posted','reversed') DEFAULT 'posted',
  `approved_by` int(11) DEFAULT NULL,
  `approved_at` timestamp NULL DEFAULT NULL,
  `reversed_by` int(11) DEFAULT NULL,
  `reversed_at` timestamp NULL DEFAULT NULL,
  `reversed_entry_id` int(11) DEFAULT NULL,
  `reversal_reason` text DEFAULT NULL,
  `rejection_reason` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `journal_type` enum('general','revenue','payment','refund','adjustment') DEFAULT 'general' COMMENT 'Type of journal entry',
  `batch_no` varchar(50) DEFAULT NULL COMMENT 'Batch number for grouped entries',
  `exchange_rate` decimal(10,4) DEFAULT 1.0000 COMMENT 'Exchange rate if foreign currency',
  `currency_code` varchar(3) DEFAULT 'KES' COMMENT 'Currency code',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference_no` (`reference_no`),
  KEY `date` (`date`),
  KEY `source_module` (`source_module`),
  KEY `source_id` (`source_id`),
  KEY `patient_id` (`patient_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `status` (`status`),
  KEY `created_by` (`created_by`),
  KEY `reversed_entry_id` (`reversed_entry_id`),
  KEY `fk_journal_approver` (`approved_by`),
  KEY `idx_journal_type` (`journal_type`),
  KEY `idx_batch_no` (`batch_no`),
  KEY `idx_source_module_id` (`source_module`,`source_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `journal_headers` (`id`, `reference_no`, `date`, `description`, `total_amount`, `source_module`, `source_id`, `patient_id`, `supplier_id`, `status`, `approved_by`, `approved_at`, `reversed_by`, `reversed_at`, `reversed_entry_id`, `reversal_reason`, `rejection_reason`, `created_by`, `created_at`, `updated_at`, `journal_type`, `batch_no`, `exchange_rate`, `currency_code`) VALUES (1, 'GCC-20250706-132', '2025-07-06', 'GCC Registration - Patient: Myne B (ID: PAT-132)', '10500.00', 'gcc_registration', 132, 132, NULL, 'posted', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-07-06 13:30:59', '2025-07-06 16:30:59', 'general', NULL, '1.0000', 'KES');
INSERT INTO `journal_headers` (`id`, `reference_no`, `date`, `description`, `total_amount`, `source_module`, `source_id`, `patient_id`, `supplier_id`, `status`, `approved_by`, `approved_at`, `reversed_by`, `reversed_at`, `reversed_entry_id`, `reversal_reason`, `rejection_reason`, `created_by`, `created_at`, `updated_at`, `journal_type`, `batch_no`, `exchange_rate`, `currency_code`) VALUES (3, 'GCC-20250706-133', '2025-07-06', 'GCC Registration - Patient: John J (ID: PAT-133)', '10500.00', 'gcc_registration', 133, 133, NULL, 'posted', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-07-06 14:05:04', '2025-07-06 17:05:04', 'general', NULL, '1.0000', 'KES');
INSERT INTO `journal_headers` (`id`, `reference_no`, `date`, `description`, `total_amount`, `source_module`, `source_id`, `patient_id`, `supplier_id`, `status`, `approved_by`, `approved_at`, `reversed_by`, `reversed_at`, `reversed_entry_id`, `reversal_reason`, `rejection_reason`, `created_by`, `created_at`, `updated_at`, `journal_type`, `batch_no`, `exchange_rate`, `currency_code`) VALUES (4, 'RAD-20250711-000022', '2025-07-11', 'Radiology Services - John J (Order #22)', '5800.00', 'radiology', 22, 133, NULL, 'posted', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-07-11 03:15:34', '2025-07-11 03:15:34', 'general', NULL, '1.0000', 'KES');
INSERT INTO `journal_headers` (`id`, `reference_no`, `date`, `description`, `total_amount`, `source_module`, `source_id`, `patient_id`, `supplier_id`, `status`, `approved_by`, `approved_at`, `reversed_by`, `reversed_at`, `reversed_entry_id`, `reversal_reason`, `rejection_reason`, `created_by`, `created_at`, `updated_at`, `journal_type`, `batch_no`, `exchange_rate`, `currency_code`) VALUES (5, 'GCC-20250720-1', '2025-07-20', 'GCC Registration - Patient: JOHN KARIUKI (ID: PAT-1)', '10500.00', 'gcc_registration', 1, 1, NULL, 'posted', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-07-20 12:14:20', '2025-07-20 11:14:20', 'general', NULL, '1.0000', 'KES');
INSERT INTO `journal_headers` (`id`, `reference_no`, `date`, `description`, `total_amount`, `source_module`, `source_id`, `patient_id`, `supplier_id`, `status`, `approved_by`, `approved_at`, `reversed_by`, `reversed_at`, `reversed_entry_id`, `reversal_reason`, `rejection_reason`, `created_by`, `created_at`, `updated_at`, `journal_type`, `batch_no`, `exchange_rate`, `currency_code`) VALUES (6, 'GCC-20250720-2', '2025-07-20', 'GCC Registration - Patient: CLINTON ONDITI (ID: PAT-2)', '10500.00', 'gcc_registration', 2, 2, NULL, 'posted', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '2025-07-20 12:17:25', '2025-07-20 11:17:25', 'general', NULL, '1.0000', 'KES');


#
# TABLE STRUCTURE FOR: journal_lines
#

DROP TABLE IF EXISTS `journal_lines`;

CREATE TABLE `journal_lines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `journal_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `debit_amount` decimal(15,2) DEFAULT 0.00,
  `credit_amount` decimal(15,2) DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `line_number` int(11) NOT NULL DEFAULT 1 COMMENT 'Line number within journal entry',
  `department` varchar(50) DEFAULT NULL COMMENT 'Department/cost center',
  `reference_info` text DEFAULT NULL COMMENT 'Additional reference information',
  PRIMARY KEY (`id`),
  KEY `journal_id` (`journal_id`),
  KEY `account_id` (`account_id`),
  KEY `debit_amount` (`debit_amount`),
  KEY `credit_amount` (`credit_amount`),
  KEY `idx_line_number` (`journal_id`,`line_number`),
  KEY `idx_department` (`department`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (1, 1, 131, '10500.00', '0.00', 'Cash received for GCC services', '2025-07-06 13:30:59', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (2, 1, 135, '0.00', '1500.00', 'GCC Consultation Revenue', '2025-07-06 13:30:59', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (3, 1, 140, '0.00', '8000.00', 'GCC Laboratory Revenue', '2025-07-06 13:30:59', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (4, 1, 138, '0.00', '1000.00', 'GCC Radiology Revenue', '2025-07-06 13:30:59', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (9, 3, 131, '10500.00', '0.00', 'Cash received for GCC services', '2025-07-06 14:05:04', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (10, 3, 135, '0.00', '1500.00', 'GCC Consultation Revenue', '2025-07-06 14:05:04', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (11, 3, 140, '0.00', '8000.00', 'GCC Laboratory Revenue', '2025-07-06 14:05:04', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (12, 3, 138, '0.00', '1000.00', 'GCC Radiology Revenue', '2025-07-06 14:05:04', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (13, 4, 5, '5800.00', '0.00', 'Radiology services provided to John J', '2025-07-11 03:15:34', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (14, 4, 31, '0.00', '5000.00', 'Revenue from radiology services', '2025-07-11 03:15:34', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (15, 4, 17, '0.00', '800.00', 'VAT on radiology services (16%)', '2025-07-11 03:15:34', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (16, 5, 131, '10500.00', '0.00', 'Cash received for GCC services', '2025-07-20 12:14:20', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (17, 5, 135, '0.00', '1500.00', 'GCC Consultation Revenue', '2025-07-20 12:14:20', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (18, 5, 140, '0.00', '8000.00', 'GCC Laboratory Revenue', '2025-07-20 12:14:20', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (19, 5, 138, '0.00', '1000.00', 'GCC Radiology Revenue', '2025-07-20 12:14:20', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (20, 6, 131, '10500.00', '0.00', 'Cash received for GCC services', '2025-07-20 12:17:25', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (21, 6, 135, '0.00', '1500.00', 'GCC Consultation Revenue', '2025-07-20 12:17:25', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (22, 6, 140, '0.00', '8000.00', 'GCC Laboratory Revenue', '2025-07-20 12:17:25', 1, NULL, NULL);
INSERT INTO `journal_lines` (`id`, `journal_id`, `account_id`, `debit_amount`, `credit_amount`, `description`, `created_at`, `line_number`, `department`, `reference_info`) VALUES (23, 6, 138, '0.00', '1000.00', 'GCC Radiology Revenue', '2025-07-20 12:17:25', 1, NULL, NULL);


#
# TABLE STRUCTURE FOR: lab
#

DROP TABLE IF EXISTS `lab`;

CREATE TABLE `lab` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lab_name` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (1, 'Radiology', '2025-06-28 19:37:12');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (2, 'X-Ray', '2025-06-28 19:37:12');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (3, 'CT Scan', '2025-06-28 19:37:12');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (4, 'MRI', '2025-06-28 19:37:12');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (5, 'Ultrasound', '2025-06-28 19:37:12');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (6, 'Mammography', '2025-06-28 19:37:12');


#
# TABLE STRUCTURE FOR: lab_activity_logs
#

DROP TABLE IF EXISTS `lab_activity_logs`;

CREATE TABLE `lab_activity_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lab_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `action` varchar(100) NOT NULL,
  `details` text DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `timestamp` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `lab_id` (`lab_id`),
  KEY `patient_id` (`patient_id`),
  KEY `timestamp` (`timestamp`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Laboratory activity audit trail';

INSERT INTO `lab_activity_logs` (`id`, `lab_id`, `patient_id`, `action`, `details`, `user_id`, `ip_address`, `user_agent`, `timestamp`) VALUES (1, 5, 36, 'Lab test created', '{\"test_name\":\"Complete Blood Count\",\"verification_status\":\"1\",\"consultation_linked\":\"No\"}', 1, '41.90.187.196', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:139.0) Gecko/20100101 Firefox/139.0', '2025-06-29 16:45:44');


#
# TABLE STRUCTURE FOR: lab_billing
#

DROP TABLE IF EXISTS `lab_billing`;

CREATE TABLE `lab_billing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `lab_ids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`lab_ids`)),
  `subtotal` decimal(10,2) DEFAULT 0.00,
  `discount_percentage` decimal(5,2) DEFAULT 0.00,
  `discount_amount` decimal(10,2) DEFAULT 0.00,
  `tax_percentage` decimal(5,2) DEFAULT 0.00,
  `tax_amount` decimal(10,2) DEFAULT 0.00,
  `total_amount` decimal(10,2) DEFAULT 0.00,
  `payment_status` enum('pending','partial','paid') DEFAULT 'pending',
  `amount_paid` decimal(10,2) DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_patient` (`patient_id`),
  KEY `idx_payment_status` (`payment_status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: lab_reference_ranges
#

DROP TABLE IF EXISTS `lab_reference_ranges`;

CREATE TABLE `lab_reference_ranges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `min_value` decimal(15,6) DEFAULT NULL,
  `max_value` decimal(15,6) DEFAULT NULL,
  `gender` enum('male','female','both') DEFAULT 'both',
  `age_min` int(11) DEFAULT NULL,
  `age_max` int(11) DEFAULT NULL,
  `conditions` text DEFAULT NULL,
  `interpretation` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `test_id` (`test_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: lab_test_categories
#

DROP TABLE IF EXISTS `lab_test_categories`;

CREATE TABLE `lab_test_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `category_name` (`category_name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `lab_test_categories` (`id`, `category_name`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Hematology', 'Blood-related tests', 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_test_categories` (`id`, `category_name`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Clinical Chemistry', 'Chemical analysis tests', 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_test_categories` (`id`, `category_name`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Microbiology', 'Bacterial and viral tests', 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_test_categories` (`id`, `category_name`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'Immunology', 'Immune system tests', 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_test_categories` (`id`, `category_name`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Urine Analysis', 'Urine-based tests', 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_test_categories` (`id`, `category_name`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'Serology', 'Blood serum tests', 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_test_categories` (`id`, `category_name`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Endocrinology', 'Hormone tests', 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_test_categories` (`id`, `category_name`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Cardiology', 'Heart-related tests', 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_test_categories` (`id`, `category_name`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'Parasitology', 'Parasite detection tests', 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_test_categories` (`id`, `category_name`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'Molecular Biology', 'DNA/RNA tests', 1, '2025-06-29 04:29:16', NULL);


#
# TABLE STRUCTURE FOR: lab_test_parameters
#

DROP TABLE IF EXISTS `lab_test_parameters`;

CREATE TABLE `lab_test_parameters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `parameter_name` varchar(100) NOT NULL,
  `unit_id` int(11) DEFAULT NULL,
  `reference_range` varchar(100) DEFAULT NULL,
  `display_order` int(11) DEFAULT 1,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `test_id` (`test_id`),
  KEY `unit_id` (`unit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: lab_tests
#

DROP TABLE IF EXISTS `lab_tests`;

CREATE TABLE `lab_tests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_name` varchar(150) NOT NULL,
  `short_name` varchar(50) NOT NULL,
  `category_id` int(11) NOT NULL,
  `unit_id` int(11) DEFAULT NULL,
  `cost` decimal(10,2) NOT NULL DEFAULT 0.00,
  `report_days` int(11) DEFAULT NULL,
  `method` varchar(100) DEFAULT NULL,
  `sample_type` varchar(100) DEFAULT NULL,
  `test_type` enum('quantitative','qualitative','descriptive') DEFAULT 'qualitative',
  `description` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `is_gcc` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'GCC required: 1=Yes, 0=No',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `test_name` (`test_name`),
  KEY `category_id` (`category_id`),
  KEY `unit_id` (`unit_id`),
  KEY `idx_is_gcc` (`is_gcc`)
) ENGINE=InnoDB AUTO_INCREMENT=212 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (136, 'Complete Blood Count (CBC)', 'COMBLOCOU(', 6, NULL, '1200.00', 1, 'Automated', 'EDTA Blood', 'quantitative', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (137, 'Blood Culture', 'BLOCUL', 6, NULL, '6000.00', 1, 'Culture', 'Blood', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (138, 'Blood ethanol levels', 'BLOETHLEV', 6, NULL, '5000.00', 1, 'Enzymatic', 'Blood', 'quantitative', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (139, 'Blood Grouping', 'BLOGRO', 6, NULL, '400.00', 1, 'Agglutination', 'Blood', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (140, 'ESR', 'ESR', 6, NULL, '500.00', 1, 'Westergren', 'Blood', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (141, 'Full Blood Count', 'FULBLOCOU', 6, NULL, '1200.00', 1, 'Automated', 'Blood', 'quantitative', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (142, 'Hemoglobin', 'HEM', 6, NULL, '500.00', 1, 'Spectrophotometry', 'Blood', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (143, 'Platelet Count', 'PLACOU', 6, NULL, '800.00', 1, 'Automated', 'Blood', 'quantitative', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (144, 'White Blood Cell Count', 'WHIBLOCELC', 6, NULL, '600.00', 1, 'Automated', 'Blood', 'quantitative', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (145, 'Reticulocyte Count', 'RETCOU', 6, NULL, '1000.00', 1, 'Flow Cytometry', 'Blood', 'quantitative', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (146, 'Peripheral Blood Film', 'PERBLOFIL', 6, NULL, '800.00', 1, 'Microscopy', 'Blood', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (147, 'ANTI THYROID PEROXIDASE ANTIBODIES( TPO )', 'ANTTHYPERA', 5, NULL, '3000.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (148, 'FT3', 'FT3', 5, NULL, '2000.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (149, 'FT4', 'FT4', 5, NULL, '2000.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (150, 'TSH', 'TSH', 5, NULL, '2000.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (151, 'T3', '', 5, NULL, '1800.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (152, 'T4', '', 5, NULL, '1800.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (153, 'Thyroid Function Tests', 'THYFUNTES', 5, NULL, '4500.00', 1, 'ELISA Panel', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (154, 'PTH', 'PTH', 5, NULL, '4000.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (155, 'Cortisol', 'COR', 5, NULL, '3500.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (156, 'Growth Hormone', 'GROHOR', 5, NULL, '5000.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (157, 'HBA1C', 'HBA', 8, NULL, '3000.00', 1, 'HPLC', 'Blood', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (158, 'Fasting Blood Sugar', 'FASBLOSUG', 8, NULL, '500.00', 1, 'Enzymatic', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (159, 'Random Blood Sugar', 'RANBLOSUG', 8, NULL, '500.00', 1, 'Enzymatic', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (160, 'Oral Glucose Tolerance Test', 'ORAGLUTOLT', 8, NULL, '1500.00', 1, 'Enzymatic', 'Serum', 'quantitative', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (161, 'fluid glucose', 'FLUGLU', 8, NULL, '100.00', 1, 'Enzymatic', 'Various', 'quantitative', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (162, 'ANTI PHOSPHOLIPID ANTIBODIES', 'ANTPHOANT', 4, NULL, '6000.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (163, 'HDL Cholesterol', 'HDLCHO', 4, NULL, '500.00', 1, 'Enzymatic', 'Serum', 'quantitative', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (164, 'LIPID PROFILE', 'LIPPRO', 4, NULL, '3000.00', 1, 'Enzymatic Panel', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (165, 'LDL Cholesterol', 'LDLCHO', 4, NULL, '800.00', 1, 'Calculated/Direct', 'Serum', 'quantitative', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (166, 'Total Cholesterol', 'TOTCHO', 4, NULL, '600.00', 1, 'Enzymatic', 'Serum', 'quantitative', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (167, 'Triglycerides', 'TRI', 4, NULL, '700.00', 1, 'Enzymatic', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (168, 'ALT/GPT (Alanine Aminotransferase.)', 'ALT(ALAMI', 3, NULL, '500.00', 1, 'Enzymatic', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (169, 'APTT Activated partial Thromboplastin Time', 'APTACTPART', 3, NULL, '1500.00', 1, 'Coagulation', 'Plasma', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (170, 'HEPATITIS  C  VIRUS ANTIBODY', 'HEPVIRANT', 3, NULL, '1000.00', 1, 'ELISA', 'Serum', 'qualitative', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (171, 'HEPATITIS B SURFACE ANTIGEN', 'HEPSURANT', 3, NULL, '1000.00', 1, 'ELISA', 'Serum', 'qualitative', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (172, 'AST/GOT', 'AST', 3, NULL, '500.00', 1, 'Enzymatic', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (173, 'Bilirubin Total', 'BILTOT', 3, NULL, '600.00', 1, 'Spectrophotometry', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (174, 'Bilirubin Direct', 'BILDIR', 3, NULL, '600.00', 1, 'Spectrophotometry', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (175, 'Alkaline Phosphatase', 'ALKPHO', 3, NULL, '700.00', 1, 'Enzymatic', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (176, 'GGT', 'GGT', 3, NULL, '800.00', 1, 'Enzymatic', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (177, 'Total Protein', 'TOTPRO', 3, NULL, '500.00', 1, 'Biuret', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (178, 'Albumin', 'ALB', 3, NULL, '500.00', 1, 'BCG', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (187, 'CULTURE & SENSITIVITY', 'CULSEN', 7, NULL, '2050.00', 1, 'Culture', 'Various', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (188, 'Fluid Culture & Sensitivity', 'FLUCULSEN', 7, NULL, '2500.00', 1, 'Culture', 'Body Fluid', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (189, 'Microscopy, culture & Sensitivity MCS', 'MICCULSENM', 7, NULL, '1450.00', 1, 'Culture', 'Various', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (190, 'Folate (Folic Acid)', 'FOL(FOACI', 9, NULL, '2700.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (191, 'Vitamin B 12', 'VIT', 9, NULL, '6000.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (192, 'Vitamin B12', 'VITB12', 9, NULL, '3450.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (193, 'Vitamin D', 'VIT', 9, NULL, '4000.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (194, 'TROPONIN', 'TRO', 10, NULL, '4000.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (195, '15000 comprehensive female wellness', '150COMFEMW', 2, NULL, '15000.00', 1, 'Combined', 'Various', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', '2025-07-10 05:25:52');
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (196, '18000 Female Comprehensive Wellness', '180FEMCOMW', 2, NULL, '18000.00', 1, 'Combined', 'Various', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (197, 'BAHRAIN MEDICAL PACKAGE', 'BAHMEDPAC', 2, NULL, '4700.00', 1, 'Combined', 'Various', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (198, 'Basic Health Screen', 'BASHEASCR', 2, NULL, '3500.00', 1, 'Combined', 'Various', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (199, 'Executive Health Package', 'EXEHEAPAC', 2, NULL, '8500.00', 1, 'Combined', 'Various', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (200, 'Cardiac Risk Assessment', 'CARRISASS', 2, NULL, '6500.00', 1, 'Combined', 'Various', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (201, 'Diabetes Screen', 'DIASCR', 2, NULL, '2500.00', 1, 'Combined', 'Various', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (202, 'Liver Function Package', 'LIVFUNPAC', 2, NULL, '3200.00', 1, 'Combined', 'Various', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (203, 'C ANCA', 'ANC', 1, NULL, '5500.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (204, 'P ANCA', 'ANC', 1, NULL, '5500.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (205, 'AAFB test', 'AAFTES', 1, NULL, '1000.00', 1, 'Microscopy', 'Sputum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (206, 'ACR- Albumin Creatinine Ratio', 'ACRALBCRER', 1, NULL, '3200.00', 1, 'Immunoturbidimetric', 'Urine', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (207, 'ALPHA FETOPROTEIN', 'ALPFET', 1, NULL, '3500.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (208, 'AMYLASE', 'AMY', 1, NULL, '1500.00', 1, 'Enzymatic', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (209, 'Anti CCP', 'ANTCCP', 1, NULL, '5000.00', 1, 'ELISA', 'Serum', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (210, 'APTT', 'APT', 1, NULL, '1500.00', 1, 'Coagulation', 'Plasma', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);
INSERT INTO `lab_tests` (`id`, `test_name`, `short_name`, `category_id`, `unit_id`, `cost`, `report_days`, `method`, `sample_type`, `test_type`, `description`, `is_active`, `is_gcc`, `created_at`, `updated_at`) VALUES (211, 'ASCITIC TAP', 'ASCTAP', 1, NULL, '3000.00', 1, 'Cytology', 'Ascitic Fluid', 'descriptive', NULL, 1, 0, '2025-07-01 07:16:32', NULL);


#
# TABLE STRUCTURE FOR: lab_units
#

DROP TABLE IF EXISTS `lab_units`;

CREATE TABLE `lab_units` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `unit_name` varchar(50) NOT NULL,
  `unit_symbol` varchar(10) NOT NULL,
  `description` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unit_name` (`unit_name`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `lab_units` (`id`, `unit_name`, `unit_symbol`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Grams per deciliter', 'g/dL', NULL, 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_units` (`id`, `unit_name`, `unit_symbol`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Milligrams per deciliter', 'mg/dL', NULL, 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_units` (`id`, `unit_name`, `unit_symbol`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Micrograms per deciliter', 'μg/dL', NULL, 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_units` (`id`, `unit_name`, `unit_symbol`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'International Units per liter', 'IU/L', NULL, 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_units` (`id`, `unit_name`, `unit_symbol`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Units per liter', 'U/L', NULL, 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_units` (`id`, `unit_name`, `unit_symbol`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'Millimoles per liter', 'mmol/L', NULL, 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_units` (`id`, `unit_name`, `unit_symbol`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Micromoles per liter', 'μmol/L', NULL, 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_units` (`id`, `unit_name`, `unit_symbol`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Nanograms per milliliter', 'ng/mL', NULL, 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_units` (`id`, `unit_name`, `unit_symbol`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'Picograms per milliliter', 'pg/mL', NULL, 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_units` (`id`, `unit_name`, `unit_symbol`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'Cells per microliter', 'cells/μL', NULL, 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_units` (`id`, `unit_name`, `unit_symbol`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Percentage', '%', NULL, 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_units` (`id`, `unit_name`, `unit_symbol`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'Ratio', 'ratio', NULL, 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_units` (`id`, `unit_name`, `unit_symbol`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Milliseconds', 'ms', NULL, 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_units` (`id`, `unit_name`, `unit_symbol`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Millimeters per hour', 'mm/hr', NULL, 1, '2025-06-29 04:29:16', NULL);
INSERT INTO `lab_units` (`id`, `unit_name`, `unit_symbol`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Count', 'count', NULL, 1, '2025-06-29 04:29:16', NULL);


#
# TABLE STRUCTURE FOR: laboratory
#

DROP TABLE IF EXISTS `laboratory`;

CREATE TABLE `laboratory` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `test_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `test_name` varchar(255) NOT NULL,
  `short_name` varchar(50) DEFAULT NULL,
  `test_result` text NOT NULL,
  `notes` text NOT NULL,
  `test_date` date DEFAULT NULL,
  `priority` enum('normal','urgent','stat') DEFAULT 'normal',
  `base_cost` decimal(10,2) DEFAULT 0.00,
  `priority_fee` decimal(10,2) DEFAULT 0.00,
  `tax_amount` decimal(10,2) DEFAULT 0.00,
  `total_cost` decimal(10,2) DEFAULT 0.00,
  `discount_percentage` decimal(5,2) DEFAULT 0.00,
  `discount_amount` decimal(10,2) DEFAULT 0.00,
  `final_amount` decimal(10,2) DEFAULT 0.00,
  `payment_method` enum('cash','card','insurance','credit') DEFAULT 'cash',
  `amount_paid` decimal(10,2) DEFAULT 0.00,
  `result_status` enum('pending','in_progress','completed','abnormal','critical') DEFAULT 'pending',
  `doctor_id` int(11) DEFAULT NULL,
  `sample_type` varchar(100) DEFAULT NULL,
  `method` varchar(100) DEFAULT NULL,
  `reference_range` varchar(200) DEFAULT NULL,
  `report_days` int(11) DEFAULT 1 COMMENT 'Days to complete test',
  `verification_status` enum('verified','unverified','skipped') DEFAULT 'unverified',
  `verification_score` int(11) DEFAULT NULL,
  `verification_quality` varchar(50) DEFAULT NULL,
  `verification_method` varchar(100) DEFAULT NULL COMMENT 'Verification method used',
  `tested_by` int(11) DEFAULT 1,
  `created_at` datetime NOT NULL,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `category_name` varchar(100) DEFAULT NULL COMMENT 'Test category name',
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `idx_test_id` (`test_id`),
  KEY `idx_category_id` (`category_id`),
  KEY `idx_doctor_id` (`doctor_id`),
  KEY `idx_test_date` (`test_date`),
  KEY `idx_result_status` (`result_status`),
  KEY `idx_verification_status` (`verification_status`),
  KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `laboratory` (`id`, `patient_id`, `test_id`, `category_id`, `test_name`, `short_name`, `test_result`, `notes`, `test_date`, `priority`, `base_cost`, `priority_fee`, `tax_amount`, `total_cost`, `discount_percentage`, `discount_amount`, `final_amount`, `payment_method`, `amount_paid`, `result_status`, `doctor_id`, `sample_type`, `method`, `reference_range`, `report_days`, `verification_status`, `verification_score`, `verification_quality`, `verification_method`, `tested_by`, `created_at`, `updated_at`, `category_name`) VALUES (1, 43, NULL, NULL, 'Test Lab', NULL, 'Test', '', '2025-06-29', 'normal', '1000.00', '0.00', '0.00', '1160.00', '0.00', '0.00', '1160.00', 'cash', '0.00', 'completed', NULL, NULL, NULL, NULL, 1, 'verified', NULL, NULL, NULL, 1, '2025-06-29 07:30:16', '2025-06-29 10:01:11', NULL);
INSERT INTO `laboratory` (`id`, `patient_id`, `test_id`, `category_id`, `test_name`, `short_name`, `test_result`, `notes`, `test_date`, `priority`, `base_cost`, `priority_fee`, `tax_amount`, `total_cost`, `discount_percentage`, `discount_amount`, `final_amount`, `payment_method`, `amount_paid`, `result_status`, `doctor_id`, `sample_type`, `method`, `reference_range`, `report_days`, `verification_status`, `verification_score`, `verification_quality`, `verification_method`, `tested_by`, `created_at`, `updated_at`, `category_name`) VALUES (2, 36, NULL, NULL, 'Complete Blood Count (CBC)', NULL, 'Pending', '', NULL, 'normal', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', 'cash', '0.00', 'pending', NULL, NULL, NULL, NULL, 1, 'verified', 0, '', '', 1, '2025-06-29 16:43:40', NULL, NULL);
INSERT INTO `laboratory` (`id`, `patient_id`, `test_id`, `category_id`, `test_name`, `short_name`, `test_result`, `notes`, `test_date`, `priority`, `base_cost`, `priority_fee`, `tax_amount`, `total_cost`, `discount_percentage`, `discount_amount`, `final_amount`, `payment_method`, `amount_paid`, `result_status`, `doctor_id`, `sample_type`, `method`, `reference_range`, `report_days`, `verification_status`, `verification_score`, `verification_quality`, `verification_method`, `tested_by`, `created_at`, `updated_at`, `category_name`) VALUES (7, 55, 0, NULL, 'Complete Blood Count (CBC)', 'COMBLOCOU(', '', '', '2025-07-01', 'normal', '1200.00', '0.00', '192.00', '1200.00', '0.00', '0.00', '1392.00', 'cash', '0.00', 'pending', NULL, NULL, NULL, NULL, 1, 'verified', NULL, NULL, NULL, 1, '2025-07-01 08:19:35', '2025-07-01 08:33:56', 'Hematology');
INSERT INTO `laboratory` (`id`, `patient_id`, `test_id`, `category_id`, `test_name`, `short_name`, `test_result`, `notes`, `test_date`, `priority`, `base_cost`, `priority_fee`, `tax_amount`, `total_cost`, `discount_percentage`, `discount_amount`, `final_amount`, `payment_method`, `amount_paid`, `result_status`, `doctor_id`, `sample_type`, `method`, `reference_range`, `report_days`, `verification_status`, `verification_score`, `verification_quality`, `verification_method`, `tested_by`, `created_at`, `updated_at`, `category_name`) VALUES (8, 40, 209, NULL, 'Anti CCP', 'ANTCCP', '', 'none', '2025-07-01', 'normal', '5000.00', '0.00', '0.00', '5000.00', '0.00', '0.00', '5000.00', 'cash', '0.00', 'pending', 3, 'Serum', 'ELISA', NULL, 1, 'unverified', NULL, NULL, NULL, 1, '2025-07-01 16:19:10', NULL, NULL);
INSERT INTO `laboratory` (`id`, `patient_id`, `test_id`, `category_id`, `test_name`, `short_name`, `test_result`, `notes`, `test_date`, `priority`, `base_cost`, `priority_fee`, `tax_amount`, `total_cost`, `discount_percentage`, `discount_amount`, `final_amount`, `payment_method`, `amount_paid`, `result_status`, `doctor_id`, `sample_type`, `method`, `reference_range`, `report_days`, `verification_status`, `verification_score`, `verification_quality`, `verification_method`, `tested_by`, `created_at`, `updated_at`, `category_name`) VALUES (9, 54, 204, NULL, 'P ANCA', 'ANC', '', 'Noe', '2025-07-01', 'normal', '5500.00', '0.00', '0.00', '5500.00', '0.00', '0.00', '5500.00', 'cash', '0.00', 'pending', 3, NULL, NULL, NULL, 1, 'unverified', NULL, NULL, NULL, 1, '2025-07-01 16:28:33', NULL, NULL);
INSERT INTO `laboratory` (`id`, `patient_id`, `test_id`, `category_id`, `test_name`, `short_name`, `test_result`, `notes`, `test_date`, `priority`, `base_cost`, `priority_fee`, `tax_amount`, `total_cost`, `discount_percentage`, `discount_amount`, `final_amount`, `payment_method`, `amount_paid`, `result_status`, `doctor_id`, `sample_type`, `method`, `reference_range`, `report_days`, `verification_status`, `verification_score`, `verification_quality`, `verification_method`, `tested_by`, `created_at`, `updated_at`, `category_name`) VALUES (10, 28, 211, NULL, 'ASCITIC TAP', 'ASCTAP', '', '', '2025-07-01', 'urgent', '3000.00', '0.00', '0.00', '3000.00', '0.00', '0.00', '3000.00', 'cash', '0.00', 'pending', 3, NULL, NULL, NULL, 1, 'unverified', NULL, NULL, NULL, 1, '2025-07-01 18:51:37', NULL, NULL);
INSERT INTO `laboratory` (`id`, `patient_id`, `test_id`, `category_id`, `test_name`, `short_name`, `test_result`, `notes`, `test_date`, `priority`, `base_cost`, `priority_fee`, `tax_amount`, `total_cost`, `discount_percentage`, `discount_amount`, `final_amount`, `payment_method`, `amount_paid`, `result_status`, `doctor_id`, `sample_type`, `method`, `reference_range`, `report_days`, `verification_status`, `verification_score`, `verification_quality`, `verification_method`, `tested_by`, `created_at`, `updated_at`, `category_name`) VALUES (11, 56, 137, NULL, 'Blood Culture', 'BLOCUL', '', '', '2025-07-03', 'normal', '6000.00', '0.00', '0.00', '6000.00', '0.00', '0.00', '6000.00', 'cash', '0.00', 'pending', 3, NULL, NULL, NULL, 1, 'unverified', NULL, NULL, NULL, 1, '2025-07-03 13:44:27', NULL, NULL);
INSERT INTO `laboratory` (`id`, `patient_id`, `test_id`, `category_id`, `test_name`, `short_name`, `test_result`, `notes`, `test_date`, `priority`, `base_cost`, `priority_fee`, `tax_amount`, `total_cost`, `discount_percentage`, `discount_amount`, `final_amount`, `payment_method`, `amount_paid`, `result_status`, `doctor_id`, `sample_type`, `method`, `reference_range`, `report_days`, `verification_status`, `verification_score`, `verification_quality`, `verification_method`, `tested_by`, `created_at`, `updated_at`, `category_name`) VALUES (12, 56, 0, NULL, 'Complete Blood Count (CBC)', 'COMBLOCOU(', '', '', '2025-07-03', 'normal', '1200.00', '0.00', '192.00', '1200.00', '0.00', '0.00', '1392.00', 'cash', '0.00', 'pending', 3, NULL, NULL, NULL, 1, 'verified', NULL, NULL, NULL, 1, '2025-07-03 13:46:00', '2025-07-03 12:48:27', 'Hematology');
INSERT INTO `laboratory` (`id`, `patient_id`, `test_id`, `category_id`, `test_name`, `short_name`, `test_result`, `notes`, `test_date`, `priority`, `base_cost`, `priority_fee`, `tax_amount`, `total_cost`, `discount_percentage`, `discount_amount`, `final_amount`, `payment_method`, `amount_paid`, `result_status`, `doctor_id`, `sample_type`, `method`, `reference_range`, `report_days`, `verification_status`, `verification_score`, `verification_quality`, `verification_method`, `tested_by`, `created_at`, `updated_at`, `category_name`) VALUES (13, 57, 205, NULL, 'AAFB test', 'AAFTES', '', '1 test only', '2025-07-04', 'normal', '1000.00', '0.00', '0.00', '1000.00', '0.00', '0.00', '1000.00', 'cash', '0.00', 'pending', 4, NULL, NULL, NULL, 1, 'unverified', NULL, NULL, NULL, 1, '2025-07-04 05:04:16', NULL, NULL);
INSERT INTO `laboratory` (`id`, `patient_id`, `test_id`, `category_id`, `test_name`, `short_name`, `test_result`, `notes`, `test_date`, `priority`, `base_cost`, `priority_fee`, `tax_amount`, `total_cost`, `discount_percentage`, `discount_amount`, `final_amount`, `payment_method`, `amount_paid`, `result_status`, `doctor_id`, `sample_type`, `method`, `reference_range`, `report_days`, `verification_status`, `verification_score`, `verification_quality`, `verification_method`, `tested_by`, `created_at`, `updated_at`, `category_name`) VALUES (14, 57, 0, NULL, 'Blood Culture', 'BLOCUL', '', 'none', '2025-07-04', 'urgent', '6000.00', '3000.00', '1440.00', '9000.00', '0.00', '0.00', '10440.00', 'cash', '0.00', 'pending', 4, NULL, NULL, NULL, 1, 'unverified', NULL, NULL, NULL, 1, '2025-07-04 05:14:24', '2025-07-04 10:05:45', 'Hematology');
INSERT INTO `laboratory` (`id`, `patient_id`, `test_id`, `category_id`, `test_name`, `short_name`, `test_result`, `notes`, `test_date`, `priority`, `base_cost`, `priority_fee`, `tax_amount`, `total_cost`, `discount_percentage`, `discount_amount`, `final_amount`, `payment_method`, `amount_paid`, `result_status`, `doctor_id`, `sample_type`, `method`, `reference_range`, `report_days`, `verification_status`, `verification_score`, `verification_quality`, `verification_method`, `tested_by`, `created_at`, `updated_at`, `category_name`) VALUES (15, 56, 0, NULL, 'ESR', 'ESR', '', '', '2025-07-05', 'normal', '500.00', '0.00', '80.00', '500.00', '0.00', '0.00', '580.00', 'cash', '0.00', 'pending', 3, NULL, NULL, NULL, 1, 'unverified', NULL, NULL, NULL, 1, '2025-07-05 18:26:43', NULL, 'Hematology');
INSERT INTO `laboratory` (`id`, `patient_id`, `test_id`, `category_id`, `test_name`, `short_name`, `test_result`, `notes`, `test_date`, `priority`, `base_cost`, `priority_fee`, `tax_amount`, `total_cost`, `discount_percentage`, `discount_amount`, `final_amount`, `payment_method`, `amount_paid`, `result_status`, `doctor_id`, `sample_type`, `method`, `reference_range`, `report_days`, `verification_status`, `verification_score`, `verification_quality`, `verification_method`, `tested_by`, `created_at`, `updated_at`, `category_name`) VALUES (16, 102, 206, NULL, 'ACR- Albumin Creatinine Ratio', 'ACRALBCRER', '', '', '2025-07-06', 'normal', '3200.00', '0.00', '0.00', '3200.00', '0.00', '0.00', '3200.00', 'cash', '0.00', 'pending', 2, NULL, NULL, NULL, 1, 'verified', NULL, NULL, NULL, 1, '2025-07-06 08:47:05', '2025-07-06 07:50:27', NULL);
INSERT INTO `laboratory` (`id`, `patient_id`, `test_id`, `category_id`, `test_name`, `short_name`, `test_result`, `notes`, `test_date`, `priority`, `base_cost`, `priority_fee`, `tax_amount`, `total_cost`, `discount_percentage`, `discount_amount`, `final_amount`, `payment_method`, `amount_paid`, `result_status`, `doctor_id`, `sample_type`, `method`, `reference_range`, `report_days`, `verification_status`, `verification_score`, `verification_quality`, `verification_method`, `tested_by`, `created_at`, `updated_at`, `category_name`) VALUES (17, 102, 211, NULL, 'ASCITIC TAP', 'ASCTAP', '', '', '2025-07-06', 'normal', '3000.00', '0.00', '0.00', '3000.00', '0.00', '0.00', '3000.00', 'cash', '0.00', 'pending', 2, NULL, NULL, NULL, 1, 'unverified', NULL, NULL, NULL, 1, '2025-07-06 08:47:05', NULL, NULL);
INSERT INTO `laboratory` (`id`, `patient_id`, `test_id`, `category_id`, `test_name`, `short_name`, `test_result`, `notes`, `test_date`, `priority`, `base_cost`, `priority_fee`, `tax_amount`, `total_cost`, `discount_percentage`, `discount_amount`, `final_amount`, `payment_method`, `amount_paid`, `result_status`, `doctor_id`, `sample_type`, `method`, `reference_range`, `report_days`, `verification_status`, `verification_score`, `verification_quality`, `verification_method`, `tested_by`, `created_at`, `updated_at`, `category_name`) VALUES (18, 133, 0, NULL, 'Complete Blood Count (CBC)', 'COMBLOCOU(', '', '', '2025-07-06', 'normal', '1200.00', '0.00', '192.00', '1200.00', '0.00', '0.00', '1392.00', 'cash', '0.00', 'pending', 3, NULL, NULL, NULL, 1, 'verified', NULL, NULL, NULL, 1, '2025-07-06 15:11:03', '2025-07-06 14:12:05', 'Hematology');
INSERT INTO `laboratory` (`id`, `patient_id`, `test_id`, `category_id`, `test_name`, `short_name`, `test_result`, `notes`, `test_date`, `priority`, `base_cost`, `priority_fee`, `tax_amount`, `total_cost`, `discount_percentage`, `discount_amount`, `final_amount`, `payment_method`, `amount_paid`, `result_status`, `doctor_id`, `sample_type`, `method`, `reference_range`, `report_days`, `verification_status`, `verification_score`, `verification_quality`, `verification_method`, `tested_by`, `created_at`, `updated_at`, `category_name`) VALUES (19, 131, 0, NULL, 'Complete Blood Count (CBC)', 'COMBLOCOU(', '', '', '2025-07-08', '', '1200.00', '0.00', '0.00', '1200.00', NULL, '0.00', '1200.00', 'cash', '0.00', 'pending', NULL, NULL, NULL, NULL, 1, 'unverified', NULL, NULL, NULL, 1, '2025-07-08 16:09:41', NULL, 'Hematology');
INSERT INTO `laboratory` (`id`, `patient_id`, `test_id`, `category_id`, `test_name`, `short_name`, `test_result`, `notes`, `test_date`, `priority`, `base_cost`, `priority_fee`, `tax_amount`, `total_cost`, `discount_percentage`, `discount_amount`, `final_amount`, `payment_method`, `amount_paid`, `result_status`, `doctor_id`, `sample_type`, `method`, `reference_range`, `report_days`, `verification_status`, `verification_score`, `verification_quality`, `verification_method`, `tested_by`, `created_at`, `updated_at`, `category_name`) VALUES (20, 133, 0, NULL, 'T3', '', '', '', '2025-07-09', 'normal', '1800.00', '0.00', '288.00', '1800.00', '0.00', '0.00', '2088.00', 'cash', '0.00', 'pending', 3, NULL, NULL, NULL, 1, 'unverified', NULL, NULL, NULL, 1, '2025-07-09 06:13:30', NULL, 'General Tests');


#
# TABLE STRUCTURE FOR: laboratory_detailed_view
#

DROP TABLE IF EXISTS `laboratory_detailed_view`;

CREATE TABLE `laboratory_detailed_view` (
  `id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `patient_name` varchar(100) DEFAULT NULL,
  `patient_phone` varchar(100) DEFAULT NULL,
  `patient_age` int(11) DEFAULT NULL,
  `patient_gender` varchar(100) DEFAULT NULL,
  `test_id` int(11) DEFAULT NULL,
  `test_name` varchar(255) DEFAULT NULL,
  `short_name` varchar(50) DEFAULT NULL,
  `standard_cost` decimal(10,2) DEFAULT NULL,
  `base_cost` decimal(10,2) DEFAULT NULL,
  `priority` enum('normal','urgent','stat') DEFAULT NULL,
  `priority_fee` decimal(10,2) DEFAULT NULL,
  `tax_amount` decimal(10,2) DEFAULT NULL,
  `total_cost` decimal(10,2) DEFAULT NULL,
  `discount_percentage` decimal(5,2) DEFAULT NULL,
  `discount_amount` decimal(10,2) DEFAULT NULL,
  `final_amount` decimal(10,2) DEFAULT NULL,
  `payment_method` enum('cash','card','insurance','credit') DEFAULT NULL,
  `amount_paid` decimal(10,2) DEFAULT NULL,
  `balance_due` decimal(11,2) DEFAULT NULL,
  `test_result` text DEFAULT NULL,
  `result_status` enum('pending','in_progress','completed','abnormal','critical') DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `test_date` date DEFAULT NULL,
  `verification_status` enum('verified','unverified','skipped') DEFAULT NULL,
  `verification_score` int(11) DEFAULT NULL,
  `verification_quality` varchar(50) DEFAULT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `doctor_name` varchar(401) DEFAULT NULL,
  `tested_by` int(11) DEFAULT NULL,
  `technician_name` varchar(401) DEFAULT NULL,
  `sample_type` varchar(100) DEFAULT NULL,
  `method` varchar(100) DEFAULT NULL,
  `reference_range` varchar(200) DEFAULT NULL,
  `category_name` varchar(100) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `short_code` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_rtl` varchar(10) NOT NULL DEFAULT 'no',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `index_language` (`language`),
  KEY `index_short_code` (`short_code`),
  KEY `index_country_code` (`country_code`),
  KEY `index_is_deleted` (`is_deleted`),
  KEY `index_is_rtl` (`is_rtl`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'az', 'az', 'no', 'no', 'no', '2021-09-28 11:51:22', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'sq', 'al', 'no', 'no', 'no', '2021-09-28 12:08:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'am', 'am', 'no', 'no', 'no', '2021-09-28 11:50:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'en', 'us', 'no', 'no', 'no', '2021-09-16 07:20:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'ar', 'sa', 'no', 'no', 'no', '2021-09-28 11:50:48', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'Afrikaans', 'af', 'af', 'no', 'no', 'no', '2021-09-28 12:51:19', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Basque', 'eu', 'es', 'no', 'no', 'no', '2021-09-24 08:58:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Bengali', 'bn', 'in', 'no', 'no', 'no', '2021-09-24 08:58:25', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'Bosnian', 'bs', 'bs', 'no', 'no', 'no', '2021-09-24 08:58:28', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'Welsh', 'cy', 'cy', 'no', 'no', 'no', '2021-09-24 08:58:31', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Hungarian', 'hu', 'hu', 'no', 'no', 'no', '2021-09-24 08:58:35', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'Vietnamese', 'vi', 'vi', 'no', 'no', 'no', '2021-09-24 08:58:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Haitian', 'ht', 'ht', 'no', 'no', 'no', '2021-09-24 08:58:43', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Galician', 'gl', 'gl', 'no', 'no', 'no', '2021-09-24 08:58:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Dutch', 'nl', 'nl', 'no', 'no', 'no', '2021-09-24 08:58:51', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Greek', 'el', 'gr', 'no', 'no', 'no', '2021-09-24 08:58:53', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Georgian', 'ka', 'ge', 'no', 'no', 'no', '2021-09-24 08:58:56', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Gujarati', 'gu', 'in', 'no', 'no', 'no', '2021-09-24 08:58:59', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Danish', 'da', 'dk', 'no', 'no', 'no', '2021-09-24 08:59:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (20, 'Hebrew', 'he', 'il', 'no', 'no', 'no', '2021-09-24 08:59:04', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Yiddish', 'yi', 'il', 'no', 'no', 'no', '2021-09-24 08:59:07', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Indonesian', 'id', 'id', 'no', 'no', 'no', '2021-09-24 08:59:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Irish', 'ga', 'ga', 'no', 'no', 'no', '2021-09-24 08:59:14', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Italian', 'it', 'it', 'no', 'no', 'no', '2021-09-24 08:59:17', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Icelandic', 'is', 'is', 'no', 'no', 'no', '2021-09-24 08:59:20', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Spanish', 'es', 'es', 'no', 'no', 'no', '2021-09-24 08:59:29', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Kannada', 'kn', 'kn', 'no', 'no', 'no', '2021-09-24 08:59:32', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Catalan', 'ca', 'ca', 'no', 'no', 'no', '2021-09-24 08:59:34', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Chinese', 'zh', 'cn', 'no', 'no', 'no', '2021-09-24 08:59:36', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Korean', 'ko', 'kr', 'no', 'no', 'no', '2021-09-24 08:59:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Xhosa', 'xh', 'ls', 'no', 'no', 'no', '2021-09-24 08:59:42', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (32, 'Latin', 'la', 'la', 'no', 'no', 'no', '2021-09-24 08:59:45', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Latvian', 'lv', 'lv', 'no', 'no', 'no', '2021-09-24 08:59:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Lithuanian', 'lt', 'lt', 'no', 'no', 'no', '2021-09-24 08:59:50', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (35, 'Malagasy', 'mg', 'mg', 'no', 'no', 'no', '2021-09-24 08:59:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Malay', 'ms', 'ms', 'no', 'no', 'no', '2021-09-24 09:00:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Malayalam', 'ml', 'ml', 'no', 'no', 'no', '2021-09-24 09:00:05', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Maltese', 'mt', 'mt', 'no', 'no', 'no', '2021-09-24 09:00:26', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Macedonian', 'mk', 'mk', 'no', 'no', 'no', '2021-09-24 09:00:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Maori', 'mi', 'nz', 'no', 'no', 'no', '2021-09-24 09:00:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Marathi', 'mr', 'in', 'no', 'no', 'no', '2021-09-24 09:00:51', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (42, 'Mongolian', 'mn', 'mn', 'no', 'no', 'no', '2021-09-24 09:01:15', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'German', 'de', 'de', 'no', 'no', 'no', '2021-09-24 09:01:18', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Nepali', 'ne', 'ne', 'no', 'no', 'no', '2021-09-24 09:01:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Norwegian', 'no', 'no', 'no', 'no', 'no', '2021-09-24 09:01:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Punjabi', 'pa', 'in', 'no', 'no', 'no', '2021-09-24 09:01:43', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Persian', 'fa', 'ir', 'no', 'no', 'no', '2021-09-24 09:01:49', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Portuguese', 'pt', 'pt', 'no', 'no', 'no', '2021-09-24 09:01:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Romanian', 'ro', 'ro', 'no', 'no', 'no', '2021-09-24 09:01:56', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (50, 'Russian', 'ru', 'ru', 'no', 'no', 'no', '2021-09-24 09:01:59', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Cebuano', 'ceb', 'ph', 'no', 'no', 'no', '2021-09-24 09:02:02', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'Sinhala', 'si', 'si', 'no', 'no', 'no', '2021-09-24 09:02:04', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Slovakian', 'sk', 'sk', 'no', 'no', 'no', '2021-09-24 09:02:07', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Slovenian', 'sl', 'sl', 'no', 'no', 'no', '2021-09-24 09:02:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Swahili', 'sw', 'ke', 'no', 'no', 'no', '2021-09-24 09:02:12', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (56, 'Sundanese', 'su', 'sd', 'no', 'no', 'no', '2021-09-24 09:02:15', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Thai', 'th', 'th', 'no', 'no', 'no', '2021-09-24 09:02:18', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (58, 'Tagalog', 'tl', 'tl', 'no', 'no', 'no', '2021-09-24 09:02:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Tamil', 'ta', 'in', 'no', 'no', 'no', '2021-09-24 09:02:23', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Telugu', 'te', 'in', 'no', 'no', 'no', '2021-09-24 09:02:26', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Turkish', 'tr', 'tr', 'no', 'no', 'no', '2021-09-24 09:02:29', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Uzbek', 'uz', 'uz', 'no', 'no', 'no', '2021-09-24 09:02:31', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (63, 'Urdu', 'ur', 'pk', 'no', 'no', 'no', '2021-09-24 09:02:34', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Finnish', 'fi', 'fi', 'no', 'no', 'no', '2021-09-24 09:02:37', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'French', 'fr', 'fr', 'no', 'no', 'no', '2021-09-24 09:02:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Hindi', 'hi', 'in', 'no', 'no', 'no', '2021-09-24 09:02:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Czech', 'cs', 'cz', 'no', 'no', 'no', '2021-09-24 09:02:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Swedish', 'sv', 'sv', 'no', 'no', 'no', '2021-09-24 09:02:46', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (69, 'Scottish', 'gd', 'gd', 'no', 'no', 'no', '2021-09-24 09:02:49', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Estonian', 'et', 'et', 'no', 'no', 'no', '2021-09-24 09:02:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Esperanto', 'eo', 'br', 'no', 'no', 'no', '2021-09-24 09:02:55', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Javanese', 'jv', 'id', 'no', 'no', 'no', '2021-09-24 09:02:58', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (73, 'Japanese', 'ja', 'jp', 'no', 'no', 'no', '2021-09-24 09:03:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Polish', 'pl', 'pl', 'no', 'no', 'no', '2021-09-28 08:39:06', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Croatia', 'hr', 'hr', 'no', 'no', 'no', '2021-10-25 09:56:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (76, 'Kurdish', 'ku', 'iq', 'no', 'no', 'no', '2021-10-25 09:56:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Lao', 'lo', 'la', 'no', 'no', 'no', '2021-10-25 09:56:47', NULL);


#
# TABLE STRUCTURE FOR: leave_types
#

DROP TABLE IF EXISTS `leave_types`;

CREATE TABLE `leave_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: logs
#

DROP TABLE IF EXISTS `logs`;

CREATE TABLE `logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `record_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `action` varchar(50) NOT NULL,
  `ip_address` varchar(50) NOT NULL,
  `platform` varchar(50) NOT NULL,
  `agent` varchar(50) NOT NULL,
  `time` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=382 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1, 'Record updated On Settings id 1', 1, 0, 'Update', '41.90.186.112', 'Mac OS X', 'Firefox 138.0', '2025-05-14 17:23:40', '2025-05-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2, 'Record updated On Settings id 1', 1, 0, 'Update', '41.90.186.112', 'Mac OS X', 'Firefox 138.0', '2025-05-14 17:23:57', '2025-05-14');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (3, 'Record updated On Settings id 1', 1, 0, 'Update', '41.90.176.246', 'Windows 10', 'Firefox 136.0', '2025-05-19 09:46:30', '2025-05-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (4, 'Record updated On Settings id 1', 1, 0, 'Update', '41.90.176.246', 'Windows 10', 'Firefox 136.0', '2025-05-19 09:46:36', '2025-05-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (5, 'Record updated On Settings id 1', 1, 0, 'Update', '41.90.176.246', 'Windows 10', 'Firefox 136.0', '2025-05-19 09:46:58', '2025-05-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (6, 'Record updated On Settings id 1', 1, 0, 'Update', '41.90.176.246', 'Windows 10', 'Firefox 136.0', '2025-05-19 09:47:48', '2025-05-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (7, 'New Record inserted On Patient id 1', 1, 0, 'Insert', '41.90.176.246', 'Windows 10', 'Firefox 136.0', '2025-05-19 13:46:06', '2025-05-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (8, 'Record updated On Patient id 1', 1, 0, 'Update', '41.90.176.246', 'Windows 10', 'Firefox 136.0', '2025-05-19 13:46:06', '2025-05-19');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (9, 'New Record inserted On Patient id 2', 2, 0, 'Insert', '41.90.217.213', 'Windows 10', 'Firefox 136.0', '2025-05-20 06:39:01', '2025-05-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (10, 'Record updated On Patient id 2', 2, 0, 'Update', '41.90.217.213', 'Windows 10', 'Firefox 136.0', '2025-05-20 06:39:01', '2025-05-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (11, 'Record updated For Staff id 2', 2, 0, 'Update', '41.90.217.213', 'Windows 10', 'Firefox 136.0', '2025-05-20 06:41:18', '2025-05-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (12, 'Record updated Change Password For Staff id 2', 2, 0, 'Update', '41.90.217.213', 'Windows 10', 'Firefox 136.0', '2025-05-20 06:41:45', '2025-05-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (13, 'Record updated On Email Config id 1', 1, 0, 'Update', '41.90.217.213', 'Windows 10', 'Firefox 136.0', '2025-05-20 06:47:16', '2025-05-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (14, 'Record updated For Staff id 2', 2, 0, 'Update', '41.90.217.213', 'Windows 10', 'Firefox 136.0', '2025-05-20 06:47:56', '2025-05-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (15, 'Record updated For Staff id 2', 2, 0, 'Update', '41.90.217.213', 'Windows 10', 'Firefox 136.0', '2025-05-20 06:47:56', '2025-05-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (16, 'Record updated For Staff id 3', 3, 0, 'Update', '41.90.217.213', 'Windows 10', 'Firefox 136.0', '2025-05-20 06:48:38', '2025-05-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (17, 'Record updated For Staff id 4', 4, 0, 'Update', '41.90.217.213', 'Windows 10', 'Firefox 136.0', '2025-05-20 06:51:06', '2025-05-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (18, 'Record updated Change Password For Staff id 4', 4, 0, 'Update', '41.90.217.213', 'Windows 10', 'Firefox 136.0', '2025-05-20 06:54:15', '2025-05-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (19, 'New Record inserted On Patient id 3', 3, 0, 'Insert', '154.159.252.227', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 05:49:11', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (20, 'Record updated On Patient id 3', 3, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 05:49:11', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (21, 'New Record inserted On Patient id 4', 4, 0, 'Insert', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 10:29:05', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (22, 'Record updated On Patient id 4', 4, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 10:29:05', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (23, 'New Record inserted On Patient id 5', 5, 0, 'Insert', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 10:34:27', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (24, 'Record updated On Patient id 5', 5, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 10:34:27', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (25, 'New Record inserted On Patient id 6', 6, 0, 'Insert', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 13:38:28', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (26, 'Record updated On Patient id 6', 6, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 13:38:28', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (27, 'New Record inserted On Patient id 7', 7, 0, 'Insert', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 13:48:00', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (28, 'Record updated On Patient id 7', 7, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 13:48:00', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (29, 'Record updated On Patient id 6', 6, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 13:53:53', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (30, 'Record updated On Patient id 6', 6, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 13:53:53', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (31, 'Record updated On Patient id 7', 7, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 13:56:30', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (32, 'Record updated On Patient id 7', 7, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 13:56:30', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (33, 'Record updated On Patient id 7', 7, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 14:05:57', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (34, 'Record updated On Patient id 7', 7, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 14:05:57', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (35, 'New Record inserted On Patient id 8', 8, 0, 'Insert', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 14:07:58', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (36, 'Record updated On Patient id 8', 8, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 14:07:58', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (37, 'New Record inserted On Patient id 9', 9, 0, 'Insert', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 14:11:06', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (38, 'Record updated On Patient id 9', 9, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 14:11:06', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (39, 'New Record inserted On Patient id 10', 10, 0, 'Insert', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 14:14:42', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (40, 'Record updated On Patient id 10', 10, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 14:14:42', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (41, 'New Record inserted On Patient id 11', 11, 0, 'Insert', '154.159.252.227', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 14:20:24', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (42, 'Record updated On Patient id 11', 11, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 14:20:24', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (43, 'New Record inserted On Patient id 12', 12, 0, 'Insert', '154.159.252.227', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 14:21:38', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (44, 'Record updated On Patient id 12', 12, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 14:21:38', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (45, 'New Record inserted On Patient id 13', 13, 0, 'Insert', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 14:39:10', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (46, 'Record updated On Patient id 13', 13, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 14:39:10', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (47, 'New Record inserted On Patient id 14', 14, 0, 'Insert', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 14:40:46', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (48, 'Record updated On Patient id 14', 14, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-29 14:40:46', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (49, 'Record updated For Staff id 1', 1, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 15:13:21', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (50, 'Record updated For Staff id 1', 1, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 15:13:21', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (51, 'Record updated For Staff id 1', 1, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 15:13:21', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (52, 'Record updated On Patient id 13', 13, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 15:15:31', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (53, 'Record updated On Patient id 13', 13, 0, 'Update', '154.159.252.227', 'Windows 10', 'Chrome 136.0.0.0', '2025-05-29 15:15:31', '2025-05-29');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (54, 'New Record inserted On Patient id 15', 15, 0, 'Insert', '41.81.49.11', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-31 06:01:39', '2025-05-31');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (55, 'Record updated On Patient id 15', 15, 0, 'Update', '41.81.49.11', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-31 06:01:39', '2025-05-31');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (56, 'New Record inserted On Patient id 16', 16, 0, 'Insert', '41.81.49.11', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-31 06:06:55', '2025-05-31');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (57, 'Record updated On Patient id 16', 16, 0, 'Update', '41.81.49.11', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-31 06:06:55', '2025-05-31');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (58, 'New Record inserted On Patient id 17', 17, 0, 'Insert', '41.81.49.11', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-31 06:08:53', '2025-05-31');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (59, 'Record updated On Patient id 17', 17, 0, 'Update', '41.81.49.11', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-31 06:08:53', '2025-05-31');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (60, 'New Record inserted On Patient id 18', 18, 0, 'Insert', '41.81.49.11', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-31 06:09:57', '2025-05-31');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (61, 'Record updated On Patient id 18', 18, 0, 'Update', '41.81.49.11', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-31 06:09:57', '2025-05-31');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (62, 'New Record inserted On Patient id 19', 19, 0, 'Insert', '197.248.33.254', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-31 08:14:33', '2025-05-31');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (63, 'Record updated On Patient id 19', 19, 0, 'Update', '197.248.33.254', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-31 08:14:33', '2025-05-31');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (64, 'New Record inserted On Patient id 20', 20, 0, 'Insert', '197.248.33.254', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-31 08:19:11', '2025-05-31');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (65, 'Record updated On Patient id 20', 20, 0, 'Update', '197.248.33.254', 'Windows 10', 'Chrome 137.0.0.0', '2025-05-31 08:19:11', '2025-05-31');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (66, 'New Record inserted On Global Shift id 1', 1, 0, 'Insert', '41.90.188.143', 'Windows 10', 'Firefox 139.0', '2025-06-06 10:22:37', '2025-06-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (67, 'New Record inserted On Charge Categories id 1', 1, 0, 'Insert', '41.90.188.143', 'Windows 10', 'Firefox 139.0', '2025-06-06 10:27:53', '2025-06-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (68, 'New Record inserted On Charge Units id 1', 1, 0, 'Insert', '41.90.188.143', 'Windows 10', 'Firefox 139.0', '2025-06-06 10:28:26', '2025-06-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (69, 'New Record inserted On Tax Category id 1', 1, 0, 'Insert', '41.90.188.143', 'Windows 10', 'Firefox 139.0', '2025-06-06 10:28:57', '2025-06-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (70, 'New Record inserted On Tax Category id 2', 2, 0, 'Insert', '41.90.188.143', 'Windows 10', 'Firefox 139.0', '2025-06-06 10:29:07', '2025-06-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (71, 'New Record inserted On Shift Details id 1', 1, 0, 'Insert', '41.90.188.143', 'Windows 10', 'Firefox 139.0', '2025-06-06 10:31:04', '2025-06-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (72, 'New Record inserted On Appointment Created 1', 1, 0, 'Insert', '41.90.188.143', 'Windows 10', 'Firefox 139.0', '2025-06-06 10:32:18', '2025-06-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (73, 'New Record inserted On Patient id 21', 21, 0, 'Insert', '102.5.178.164', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-09 09:29:51', '2025-06-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (74, 'Record updated On Patient id 21', 21, 0, 'Update', '102.5.178.164', 'Windows 10', 'Chrome 136.0.0.0', '2025-06-09 09:29:51', '2025-06-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (75, 'New Record inserted On Patient id 22', 22, 0, 'Insert', '102.5.178.164', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-09 10:43:28', '2025-06-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (76, 'Record updated On Patient id 22', 22, 0, 'Update', '102.5.178.164', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-09 10:43:28', '2025-06-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (77, 'New Record inserted On Patient id 23', 23, 0, 'Insert', '102.5.178.164', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-09 11:58:11', '2025-06-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (78, 'Record updated On Patient id 23', 23, 0, 'Update', '102.5.178.164', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-09 11:58:11', '2025-06-09');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (79, 'New Record inserted On Patient id 24', 24, 0, 'Insert', '41.90.188.42', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-10 04:37:35', '2025-06-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (80, 'Record updated On Patient id 24', 24, 0, 'Update', '41.90.188.42', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-10 04:37:35', '2025-06-10');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (81, 'New Record inserted On Patient id 25', 25, 0, 'Insert', '197.248.33.254', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:14:15', '2025-06-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (82, 'Record updated On Patient id 25', 25, 0, 'Update', '197.248.33.254', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:14:15', '2025-06-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (83, 'New Record inserted On Patient id 26', 26, 0, 'Insert', '197.248.33.254', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:18:43', '2025-06-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (84, 'Record updated On Patient id 26', 26, 0, 'Update', '197.248.33.254', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-13 04:18:43', '2025-06-13');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (85, 'Record updatedOn Appointment Updated 1', 1, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:42:45', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (86, 'Record updated On Print Setting id 2', 2, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:45:18', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (87, 'Record updated On Print Setting id 2', 2, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:56:01', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (88, 'Record updated On Print Setting id 2', 2, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:56:01', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (89, 'Record updated On Print Setting id 20', 20, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:56:26', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (90, 'Record updated On Print Setting id 20', 20, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:56:26', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (91, 'Record updated On Print Setting id 1', 1, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:56:48', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (92, 'Record updated On Print Setting id 1', 1, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:56:48', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (93, 'Record updated On Print Setting id 3', 3, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:57:13', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (94, 'Record updated On Print Setting id 3', 3, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:57:13', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (95, 'Record updated On Print Setting id 4', 4, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:57:39', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (96, 'Record updated On Print Setting id 4', 4, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:57:39', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (97, 'Record updated On Print Setting id 4', 4, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:57:53', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (98, 'Record updated On Print Setting id 5', 5, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:58:14', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (99, 'Record updated On Print Setting id 5', 5, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:58:14', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (100, 'Record updated On Print Setting id 6', 6, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:58:33', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (101, 'Record updated On Print Setting id 6', 6, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:58:33', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (102, 'Record updated On Print Setting id 7', 7, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:58:55', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (103, 'Record updated On Print Setting id 7', 7, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:58:55', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (104, 'Record updated On Print Setting id 8', 8, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:59:18', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (105, 'Record updated On Print Setting id 8', 8, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:59:18', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (106, 'Record updated On Print Setting id 9', 9, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:59:38', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (107, 'Record updated On Print Setting id 9', 9, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:59:38', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (108, 'Record updated On Print Setting id 10', 10, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:59:58', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (109, 'Record updated On Print Setting id 10', 10, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 10:59:58', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (110, 'Record updated On Print Setting id 10', 10, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:00:28', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (111, 'Record updated On Print Setting id 11', 11, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:00:55', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (112, 'Record updated On Print Setting id 11', 11, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:00:55', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (113, 'Record updated On Print Setting id 12', 12, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:01:41', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (114, 'Record updated On Print Setting id 12', 12, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:01:41', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (115, 'Record updated On Print Setting id 13', 13, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:02:02', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (116, 'Record updated On Print Setting id 13', 13, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:02:02', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (117, 'Record updated On Print Setting id 14', 14, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:02:26', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (118, 'Record updated On Print Setting id 14', 14, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:02:26', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (119, 'Record updated On Print Setting id 15', 15, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:02:49', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (120, 'Record updated On Print Setting id 15', 15, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:02:49', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (121, 'Record updated On Print Setting id 16', 16, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:03:10', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (122, 'Record updated On Print Setting id 16', 16, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:03:10', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (123, 'Record updated On Print Setting id 18', 18, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:03:33', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (124, 'Record updated On Print Setting id 18', 18, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:03:33', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (125, 'Record updated On Print Setting id 17', 17, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:04:01', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (126, 'Record updated On Print Setting id 17', 17, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:04:01', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (127, 'Record updated On Print Setting id 19', 19, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:04:25', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (128, 'Record updated On Print Setting id 19', 19, 0, 'Update', '41.90.180.79', 'Windows 10', 'Firefox 139.0', '2025-06-17 11:04:25', '2025-06-17');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (129, 'New Record inserted On Patient id 27', 27, 0, 'Insert', '197.248.33.254', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-18 04:29:15', '2025-06-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (130, 'Record updated On Patient id 27', 27, 0, 'Update', '197.248.33.254', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-18 04:29:15', '2025-06-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (131, 'New Record inserted On Patient id 28', 28, 0, 'Insert', '197.248.33.254', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-18 04:34:30', '2025-06-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (132, 'Record updated On Patient id 28', 28, 0, 'Update', '197.248.33.254', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-18 04:34:30', '2025-06-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (133, 'Record updated On Patient id 28', 28, 0, 'Update', '197.248.33.254', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-18 04:36:16', '2025-06-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (134, 'Record updated On Patient id 28', 28, 0, 'Update', '197.248.33.254', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-18 04:36:16', '2025-06-18');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (135, 'New Record inserted For Organisation id 1', 1, 0, 'Insert', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-21 16:11:03', '2025-06-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (136, 'New Record inserted For Organisation id 2', 2, 0, 'Insert', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-21 16:11:24', '2025-06-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (137, 'New Record inserted On Patient id 29', 29, 0, 'Insert', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-21 17:03:45', '2025-06-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (138, 'Record updated On Patient id 29', 29, 0, 'Update', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-21 17:03:45', '2025-06-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (139, 'New Record inserted On Patient id 30', 30, 0, 'Insert', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-21 18:34:11', '2025-06-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (140, 'Record updated On Patient id 30', 30, 0, 'Update', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-21 18:34:11', '2025-06-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (141, 'New Record inserted On Patient id 31', 31, 0, 'Insert', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-21 18:48:54', '2025-06-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (142, 'Record updated On Patient id 31', 31, 0, 'Update', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-21 18:48:54', '2025-06-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (143, 'New Record inserted On Patient id 32', 32, 0, 'Insert', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-22 04:18:25', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (144, 'Record updated On Patient id 32', 32, 0, 'Update', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-22 04:18:25', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (145, 'New Record inserted On Patient id 33', 33, 0, 'Insert', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-22 04:21:03', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (146, 'Record updated On Patient id 33', 33, 0, 'Update', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-22 04:21:03', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (147, 'Record updated On Transactions id 1', 1, 0, 'Update', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-22 09:38:59', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (148, 'Record updated On Visit Details id 1', 1, 0, 'Update', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-22 09:38:59', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (149, 'New Record inserted On Patient id 34', 34, 0, 'Insert', '41.90.184.197', 'Windows 10', 'Firefox 139.0', '2025-06-22 15:50:51', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (150, 'Record updated On Patient id 34', 34, 0, 'Update', '41.90.184.197', 'Windows 10', 'Firefox 139.0', '2025-06-22 15:50:51', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (151, 'New Record inserted On Patient id 35', 35, 0, 'Insert', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-22 16:41:44', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (152, 'Record updated On Patient id 35', 35, 0, 'Update', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-22 16:41:44', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (153, 'New Record inserted On Patient id 36', 36, 0, 'Insert', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-22 18:04:05', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (154, 'Record updated On Patient id 36', 36, 0, 'Update', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-22 18:04:05', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (155, 'Record updated On Patient id 36', 36, 0, 'Update', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-22 18:04:05', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (156, 'New Record inserted On Patient id 37', 37, 0, 'Insert', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-22 18:15:32', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (157, 'New Record inserted On Patient id 38', 38, 0, 'Insert', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-22 18:15:32', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (158, 'New Record inserted On Patient id 40', 40, 0, 'Insert', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-22 18:16:49', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (159, 'Record updated On Patient id 40', 40, 0, 'Update', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-22 18:16:49', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (160, 'Record updated On Patient id 40', 40, 0, 'Update', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-22 18:16:49', '2025-06-22');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (161, 'New Record inserted On Patient id 41', 41, 0, 'Insert', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-23 12:08:08', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (162, 'Record updated On Patient id 41', 41, 0, 'Update', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-23 12:08:08', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (163, 'New Record inserted On Patient id 42', 42, 0, 'Insert', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-23 12:17:05', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (164, 'Record updated On Patient id 42', 42, 0, 'Update', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-23 12:17:05', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (165, 'New Record inserted On Patient id 43', 43, 0, 'Insert', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 14:51:29', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (166, 'Record updated On Patient id 43', 43, 0, 'Update', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 14:51:29', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (167, 'Record updated On Patient id 43', 43, 0, 'Update', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 14:51:29', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (168, 'New Record inserted On Patient id 44', 44, 0, 'Insert', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 20:01:14', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (169, 'Record updated On Patient id 44', 44, 0, 'Update', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 20:01:14', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (170, 'Record updated On Patient id 44', 44, 0, 'Update', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 20:01:14', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (171, 'New Record inserted On Patient id 45', 45, 0, 'Insert', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 20:08:39', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (172, 'Record updated On Patient id 45', 45, 0, 'Update', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 20:08:39', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (173, 'Record updated On Patient id 45', 45, 0, 'Update', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 20:08:39', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (174, 'New Record inserted On Patient id 46', 46, 0, 'Insert', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 20:15:37', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (175, 'Record updated On Patient id 46', 46, 0, 'Update', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 20:15:37', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (176, 'Record updated On Patient id 46', 46, 0, 'Update', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 20:15:37', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (177, 'New Record inserted On Patient id 47', 47, 0, 'Insert', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 20:19:50', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (178, 'Record updated On Patient id 47', 47, 0, 'Update', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 20:19:50', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (179, 'Record updated On Patient id 47', 47, 0, 'Update', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 20:19:50', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (180, 'New Record inserted On Patient id 48', 48, 0, 'Insert', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 20:48:03', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (181, 'Record updated On Patient id 48', 48, 0, 'Update', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 20:48:03', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (182, 'Record updated On Patient id 48', 48, 0, 'Update', '154.159.237.202', 'Windows 10', 'Firefox 139.0', '2025-06-23 20:48:03', '2025-06-23');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (183, 'New Record inserted On Patient id 49', 49, 0, 'Insert', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-24 15:13:57', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (184, 'Record updated On Patient id 49', 49, 0, 'Update', '41.90.185.246', 'Mac OS X', 'Firefox 139.0', '2025-06-24 15:13:57', '2025-06-24');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (185, 'New Record inserted On Patient id 50', 50, 0, 'Insert', '41.90.185.246', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 07:34:41', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (186, 'Record updated On Patient id 50', 50, 0, 'Update', '41.90.185.246', 'Windows 10', 'Chrome 137.0.0.0', '2025-06-25 07:34:41', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (187, 'New Record inserted On Patient id 51', 51, 0, 'Insert', '41.90.185.246', 'Windows 10', 'Firefox 140.0', '2025-06-25 07:43:36', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (188, 'Record updated On Patient id 51', 51, 0, 'Update', '41.90.185.246', 'Windows 10', 'Firefox 140.0', '2025-06-25 07:43:36', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (189, 'Record updated On Patient id 51', 51, 0, 'Update', '41.90.185.246', 'Windows 10', 'Firefox 140.0', '2025-06-25 07:43:36', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (190, 'New Record inserted On Patient id 52', 52, 0, 'Insert', '41.90.185.246', 'Windows 10', 'Firefox 140.0', '2025-06-25 08:20:32', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (191, 'Record updated On Patient id 52', 52, 0, 'Update', '41.90.185.246', 'Windows 10', 'Firefox 140.0', '2025-06-25 08:20:32', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (192, 'Record updated On Patient id 52', 52, 0, 'Update', '41.90.185.246', 'Windows 10', 'Firefox 140.0', '2025-06-25 08:20:32', '2025-06-25');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (193, 'New Record inserted On Patient id 53', 53, 0, 'Insert', '41.139.240.249', 'Windows 10', 'Firefox 140.0', '2025-06-30 04:48:08', '2025-06-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (194, 'Record updated On Patient id 53', 53, 0, 'Update', '41.139.240.249', 'Windows 10', 'Firefox 140.0', '2025-06-30 04:48:08', '2025-06-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (195, 'Record updated On Patient id 53', 53, 0, 'Update', '41.139.240.249', 'Windows 10', 'Firefox 140.0', '2025-06-30 04:48:08', '2025-06-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (197, 'New Record inserted On Patient id 54', 54, 0, 'Insert', '41.90.187.196', 'Mac OS X', 'Firefox 140.0', '2025-06-30 12:11:13', '2025-06-30');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (198, 'New Record inserted On Patient id 55', 55, 0, 'Insert', '41.90.187.196', 'Mac OS X', 'Firefox 140.0', '2025-07-01 05:43:24', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (199, 'Record updated On Patient id 55', 55, 0, 'Update', '41.90.187.196', 'Mac OS X', 'Firefox 140.0', '2025-07-01 05:43:24', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (200, 'Record updated On Patient id 55', 55, 0, 'Update', '41.90.187.196', 'Mac OS X', 'Firefox 140.0', '2025-07-01 05:43:24', '2025-07-01');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (201, 'New Record inserted On Patient id 56', 56, 0, 'Insert', '41.90.187.196', 'Windows 10', 'Firefox 140.0', '2025-07-03 12:35:42', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (202, 'Record updated On Patient id 56', 56, 0, 'Update', '41.90.187.196', 'Windows 10', 'Firefox 140.0', '2025-07-03 12:35:42', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (203, 'Record updated On Patient id 56', 56, 0, 'Update', '41.90.187.196', 'Windows 10', 'Firefox 140.0', '2025-07-03 12:35:42', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (204, 'Record updated For Staff id 5', 5, 0, 'Update', '154.152.87.175', 'Windows 10', 'Chrome 137.0.0.0', '2025-07-03 12:46:56', '2025-07-03');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (205, 'Record updated For Staff id 6', 6, 0, 'Update', '197.237.10.53', 'Windows 10', 'Firefox 140.0', '2025-07-04 03:28:12', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (206, 'Record updated For Staff id 6', 6, 0, 'Update', '197.237.10.53', 'Windows 10', 'Firefox 140.0', '2025-07-04 03:28:12', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (207, 'New Record inserted On Patient id 57', 57, 0, 'Insert', '197.237.10.53', 'Windows 10', 'Firefox 140.0', '2025-07-04 03:39:54', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (208, 'Record updated On Patient id 57', 57, 0, 'Update', '197.237.10.53', 'Windows 10', 'Firefox 140.0', '2025-07-04 03:39:54', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (209, 'Record updated On Patient id 57', 57, 0, 'Update', '197.237.10.53', 'Windows 10', 'Firefox 140.0', '2025-07-04 03:39:54', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (210, 'New Record inserted For Organisation id 3', 3, 0, 'Insert', '197.237.10.53', 'Windows 10', 'Firefox 140.0', '2025-07-04 05:52:01', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (211, 'Record updated On Organisation id 2', 2, 0, 'Update', '197.237.10.53', 'Windows 10', 'Firefox 140.0', '2025-07-04 05:52:53', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (212, 'New Record inserted On Staff id card id 2', 2, 0, 'Insert', '197.237.10.53', 'Windows 10', 'Firefox 140.0', '2025-07-04 06:16:30', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (213, 'Record updated On Staff id card id 2', 2, 0, 'Update', '197.237.10.53', 'Windows 10', 'Firefox 140.0', '2025-07-04 06:16:30', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (214, 'Record updated On Staff id card id 2', 2, 0, 'Update', '197.237.10.53', 'Windows 10', 'Firefox 140.0', '2025-07-04 06:17:48', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (215, 'New Record inserted On Patient id 58', 58, 0, 'Insert', '197.237.10.53', 'Windows 10', 'Firefox 140.0', '2025-07-04 06:35:26', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (216, 'Record updated On Patient id 58', 58, 0, 'Update', '197.237.10.53', 'Windows 10', 'Firefox 140.0', '2025-07-04 06:35:26', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (217, 'New Record inserted On Patient Timeline id 1', 1, 0, 'Insert', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-04 16:30:22', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (218, 'Record updated Change Password For Staff id 5', 5, 0, 'Update', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-04 16:33:54', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (219, 'Record updated Change Password For Staff id 3', 3, 0, 'Update', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-04 17:37:45', '2025-07-04');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (220, 'New Record inserted On Messages Send SMS id 1', 1, 0, 'Insert', '197.237.10.53', 'Windows 10', 'Firefox 140.0', '2025-07-05 06:26:13', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (226, 'Record updated For Staff id 7', 7, 0, 'Update', '105.231.247.253', 'Windows 10', 'Firefox 140.0', '2025-07-05 09:30:29', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (227, 'Record updated For Staff id 7', 7, 0, 'Update', '105.231.247.253', 'Windows 10', 'Firefox 140.0', '2025-07-05 09:30:29', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (231, 'Record updated For Staff id 6', 6, 0, 'Update', '105.231.247.253', 'Windows 10', 'Firefox 140.0', '2025-07-05 09:41:40', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (232, 'Record updated For Staff id 6', 6, 0, 'Update', '105.231.247.253', 'Windows 10', 'Firefox 140.0', '2025-07-05 09:41:40', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (233, 'New Record inserted On Patient id 60', 60, 0, 'Insert', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 09:45:59', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (234, 'New Record inserted On Patient id 61', 61, 0, 'Insert', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 09:55:40', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (235, 'Record updated Change Password For Staff id 5', 5, 0, 'Update', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 11:05:09', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (236, 'Record updated Change Password For Staff id 6', 6, 0, 'Update', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 11:05:47', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (237, 'New Record inserted On Roles id 10', 10, 0, 'Insert', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 11:16:15', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (238, 'Record deleted On roles Permissions where Role id  9', 9, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 11:17:55', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (239, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 11:20:04', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (240, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 11:21:53', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (241, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 11:22:19', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (242, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 11:27:26', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (243, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 11:29:11', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (244, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 11:30:30', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (245, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 11:31:33', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (246, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 11:31:49', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (247, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 11:32:45', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (248, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 140.0', '2025-07-05 13:28:45', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (249, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 140.0', '2025-07-05 13:30:25', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (250, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 140.0', '2025-07-05 13:30:43', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (251, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 140.0', '2025-07-05 13:31:18', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (252, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 140.0', '2025-07-05 13:36:22', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (253, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 140.0', '2025-07-05 13:38:24', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (254, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 140.0', '2025-07-05 13:49:40', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (255, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 140.0', '2025-07-05 13:51:51', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (274, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 140.0', '2025-07-05 15:46:29', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (275, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 140.0', '2025-07-05 15:46:41', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (276, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 140.0', '2025-07-05 15:47:01', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (277, 'Record deleted On roles Permissions where Role id  8', 8, 0, 'Delete', '105.231.247.253', 'Windows 10', 'Firefox 140.0', '2025-07-05 15:47:30', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (284, 'New Record inserted On Patient id 78', 78, 0, 'Insert', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 16:05:51', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (285, 'Record updated On Patient id 78', 78, 0, 'Update', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 16:05:51', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (286, 'Record updated On Patient id 78', 78, 0, 'Update', '105.231.247.253', 'Windows 10', 'Firefox 139.0', '2025-07-05 16:05:51', '2025-07-05');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (317, 'New Record inserted On Patient id 99', 99, 0, 'Insert', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 04:04:04', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (318, 'Record updated On Patient id 99', 99, 0, 'Update', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 04:04:04', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (322, 'New Record inserted On Patient id 104', 104, 0, 'Insert', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 07:55:38', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (323, 'Record updated On Patient id 104', 104, 0, 'Update', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 07:55:38', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (324, 'New Record inserted On Patient id 105', 105, 0, 'Insert', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 07:57:56', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (325, 'Record updated On Patient id 105', 105, 0, 'Update', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 07:57:56', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (326, 'New Record inserted On Patient id 108', 108, 0, 'Insert', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 08:14:33', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (327, 'Record updated On Patient id 108', 108, 0, 'Update', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 08:14:33', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (346, 'New Record inserted On Patient id 127', 127, 0, 'Insert', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 09:07:20', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (348, 'New Record inserted On Patient id 128', 128, 0, 'Insert', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 09:24:30', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (349, 'Record updated On Patient id 128', 128, 0, 'Update', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 09:24:30', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (350, 'New Record inserted On Patient id 129', 129, 0, 'Insert', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 09:57:46', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (351, 'Record updated On Patient id 129', 129, 0, 'Update', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 09:57:46', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (352, 'New Record inserted On Patient id 130', 130, 0, 'Insert', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 10:09:23', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (353, 'Record updated On Patient id 130', 130, 0, 'Update', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 10:09:23', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (354, 'New Record inserted On Patient id 131', 131, 0, 'Insert', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 10:49:08', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (355, 'Record updated On Patient id 131', 131, 0, 'Update', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 10:49:08', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (356, 'New Record inserted On Patient id 132', 132, 0, 'Insert', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 13:30:59', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (357, 'Record updated On Patient id 132', 132, 0, 'Update', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 13:30:59', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (358, 'Record updated On Patient id 132', 132, 0, 'Update', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 13:30:59', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (359, 'New Record inserted On Patient id 133', 133, 0, 'Insert', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 14:05:04', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (360, 'Record updated On Patient id 133', 133, 0, 'Update', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 14:05:04', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (361, 'Record updated On Patient id 133', 133, 0, 'Update', '41.90.187.196', 'Windows 10', 'Firefox 139.0', '2025-07-06 14:05:04', '2025-07-06');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (362, 'New Record inserted On Patient id 1', 1, 0, 'Insert', '197.248.33.254', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-20 12:14:19', '2025-07-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (363, 'Record updated On Patient id 1', 1, 0, 'Update', '197.248.33.254', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-20 12:14:19', '2025-07-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (364, 'Record updated On Patient id 1', 1, 0, 'Update', '197.248.33.254', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-20 12:14:20', '2025-07-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (365, 'New Record inserted On Patient id 2', 2, 0, 'Insert', '197.248.33.254', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-20 12:17:25', '2025-07-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (366, 'Record updated On Patient id 2', 2, 0, 'Update', '197.248.33.254', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-20 12:17:25', '2025-07-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (367, 'Record updated On Patient id 2', 2, 0, 'Update', '197.248.33.254', 'Windows 10', 'Chrome 138.0.0.0', '2025-07-20 12:17:25', '2025-07-20');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (368, 'Record updated On Email Config id 1', 1, 0, 'Update', '41.90.176.241', 'Windows 10', 'Firefox 139.0', '2025-07-21 11:50:47', '2025-07-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (369, 'Record updated On Email Config id 1', 1, 0, 'Update', '41.90.176.241', 'Windows 10', 'Firefox 139.0', '2025-07-21 11:50:58', '2025-07-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (370, 'Record updated On Settings id 1', 1, 0, 'Update', '41.90.176.241', 'Windows 10', 'Firefox 139.0', '2025-07-21 11:51:30', '2025-07-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (371, 'Record updated For Staff id 8', 8, 0, 'Update', '197.248.33.254', 'Windows 10', 'Chrome 100.0.4896.75', '2025-07-21 12:09:31', '2025-07-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (372, 'New Record inserted On Roles id 11', 11, 0, 'Insert', '197.248.33.254', 'Windows 10', 'Chrome 100.0.4896.75', '2025-07-21 12:10:41', '2025-07-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (373, 'Record deleted On Roles id 11', 11, 0, 'Delete', '197.248.33.254', 'Windows 10', 'Chrome 100.0.4896.75', '2025-07-21 12:10:47', '2025-07-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (374, 'Record updated Change Password For Staff id 8', 8, 0, 'Update', '197.248.33.254', 'Windows 10', 'Chrome 100.0.4896.75', '2025-07-21 12:13:24', '2025-07-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (375, 'Record updated On Roles id 10', 10, 0, 'Update', '41.90.176.241', 'Windows 10', 'Firefox 139.0', '2025-07-21 12:14:27', '2025-07-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (376, 'Record updated Change Password For Staff id 8', 8, 0, 'Update', '41.90.176.241', 'Windows 10', 'Firefox 139.0', '2025-07-21 12:16:04', '2025-07-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (377, 'Record updated For Staff id 9', 9, 0, 'Update', '41.90.176.241', 'Mac OS X', 'Firefox 140.0', '2025-07-21 12:20:48', '2025-07-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (378, 'Record updated Change Password For Staff id 9', 9, 0, 'Update', '41.90.176.241', 'Mac OS X', 'Firefox 140.0', '2025-07-21 12:21:06', '2025-07-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (379, 'Record deleted On roles Permissions where Role id  6', 6, 0, 'Delete', '197.248.33.254', 'Windows 10', 'Chrome 100.0.4896.75', '2025-07-21 12:25:47', '2025-07-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (380, 'Record deleted On roles Permissions where Role id  6', 6, 0, 'Delete', '197.248.33.254', 'Windows 10', 'Chrome 100.0.4896.75', '2025-07-21 12:28:33', '2025-07-21');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (381, 'Record updated On Email Config id 1', 1, 0, 'Update', '41.90.176.241', 'Mac OS X', 'Firefox 140.0', '2025-07-21 14:49:26', '2025-07-21');


#
# TABLE STRUCTURE FOR: loyalty_program_settings
#

DROP TABLE IF EXISTS `loyalty_program_settings`;

CREATE TABLE `loyalty_program_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_name` varchar(100) NOT NULL,
  `setting_value` text NOT NULL,
  `description` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_setting_name` (`setting_name`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `loyalty_program_settings` (`id`, `setting_name`, `setting_value`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'points_per_1000_kes', '1', 'Number of points earned per 1000 KES spent', 1, '2025-07-03 06:53:41', '2025-07-03 06:53:41');
INSERT INTO `loyalty_program_settings` (`id`, `setting_name`, `setting_value`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'minimum_redemption_points', '10', 'Minimum points required for redemption', 1, '2025-07-03 06:53:41', '2025-07-03 06:53:41');
INSERT INTO `loyalty_program_settings` (`id`, `setting_name`, `setting_value`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'points_expiry_months', '12', 'Months after which points expire (0 = never expire)', 1, '2025-07-03 06:53:41', '2025-07-03 06:53:41');
INSERT INTO `loyalty_program_settings` (`id`, `setting_name`, `setting_value`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'redemption_services', 'consultation,laboratory,pharmacy,radiology', 'Services that can be paid using points', 1, '2025-07-03 06:53:41', '2025-07-03 06:53:41');
INSERT INTO `loyalty_program_settings` (`id`, `setting_name`, `setting_value`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'point_value_kes', '50', 'Value of 1 point in KES when redeeming', 1, '2025-07-03 06:53:41', '2025-07-03 06:53:41');
INSERT INTO `loyalty_program_settings` (`id`, `setting_name`, `setting_value`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'max_points_per_transaction', '100', 'Maximum points that can be earned in single transaction', 1, '2025-07-03 06:53:41', '2025-07-03 06:53:41');
INSERT INTO `loyalty_program_settings` (`id`, `setting_name`, `setting_value`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'enable_expiry', '1', 'Whether points expire (1=yes, 0=no)', 1, '2025-07-03 06:53:41', '2025-07-03 06:53:41');
INSERT INTO `loyalty_program_settings` (`id`, `setting_name`, `setting_value`, `description`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'enable_program', '1', 'Whether loyalty program is active', 1, '2025-07-03 06:53:41', '2025-07-03 06:53:41');


#
# TABLE STRUCTURE FOR: medication_report
#

DROP TABLE IF EXISTS `medication_report`;

CREATE TABLE `medication_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_dosage_id` int(11) DEFAULT NULL,
  `pharmacy_id` int(11) DEFAULT NULL,
  `opd_details_id` int(11) DEFAULT NULL,
  `ipd_id` int(11) DEFAULT NULL,
  `date` date NOT NULL,
  `time` time NOT NULL,
  `remark` text DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `generated_by` (`generated_by`),
  KEY `pharmacy_id` (`pharmacy_id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `medicine_dosage_id` (`medicine_dosage_id`),
  KEY `opd_details_id` (`opd_details_id`),
  KEY `index_date` (`date`),
  KEY `index_time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: medicine_bad_stock
#

DROP TABLE IF EXISTS `medicine_bad_stock`;

CREATE TABLE `medicine_bad_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_batch_details_id` int(11) DEFAULT NULL,
  `pharmacy_id` int(11) DEFAULT NULL,
  `outward_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `batch_no` varchar(100) NOT NULL,
  `quantity` varchar(20) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `pharmacy_id` (`pharmacy_id`),
  KEY `medicine_batch_details_id` (`medicine_batch_details_id`),
  KEY `index_outward_date` (`outward_date`),
  KEY `index_expiry_date` (`expiry_date`),
  KEY `index_batch_no` (`batch_no`),
  KEY `index_quantity` (`quantity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: medicine_batch_details
#

DROP TABLE IF EXISTS `medicine_batch_details`;

CREATE TABLE `medicine_batch_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_bill_basic_id` int(11) DEFAULT NULL,
  `pharmacy_id` int(11) DEFAULT NULL,
  `inward_date` datetime NOT NULL,
  `expiry` date NOT NULL,
  `batch_no` varchar(100) NOT NULL,
  `packing_qty` varchar(100) NOT NULL,
  `purchase_rate_packing` varchar(100) NOT NULL,
  `quantity` varchar(200) NOT NULL,
  `mrp` float(10,2) DEFAULT 0.00,
  `purchase_price` float(10,2) DEFAULT 0.00,
  `tax` float(10,2) DEFAULT 0.00,
  `sale_rate` float(10,2) DEFAULT 0.00,
  `batch_amount` float(10,2) DEFAULT 0.00,
  `amount` float(10,2) DEFAULT 0.00,
  `available_quantity` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `supplier_bill_basic_id` (`supplier_bill_basic_id`),
  KEY `pharmacy_id` (`pharmacy_id`),
  KEY `index_inward_date` (`inward_date`),
  KEY `index_expiry` (`expiry`),
  KEY `index_batch_no` (`batch_no`),
  KEY `index_packing_qty` (`packing_qty`),
  KEY `index_purchase_rate_packing` (`purchase_rate_packing`),
  KEY `index_quantity` (`quantity`),
  KEY `index_mrp` (`mrp`),
  KEY `index_purchase_price` (`purchase_price`),
  KEY `index_tax` (`tax`),
  KEY `index_sale_rate` (`sale_rate`),
  KEY `index_batch_amount` (`batch_amount`),
  KEY `index_amount` (`amount`),
  KEY `index_available_quantity` (`available_quantity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: medicine_category
#

DROP TABLE IF EXISTS `medicine_category`;

CREATE TABLE `medicine_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_category` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_medicine_category` (`medicine_category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: medicine_dosage
#

DROP TABLE IF EXISTS `medicine_dosage`;

CREATE TABLE `medicine_dosage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_category_id` int(11) DEFAULT NULL,
  `dosage` varchar(100) NOT NULL,
  `units_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `medicine_category_id` (`medicine_category_id`),
  KEY `charge_units_id` (`units_id`),
  KEY `index_dosage` (`dosage`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: medicine_group
#

DROP TABLE IF EXISTS `medicine_group`;

CREATE TABLE `medicine_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_group_name` (`group_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: medicine_supplier
#

DROP TABLE IF EXISTS `medicine_supplier`;

CREATE TABLE `medicine_supplier` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier` varchar(200) NOT NULL,
  `contact` varchar(200) NOT NULL,
  `supplier_person` varchar(200) NOT NULL,
  `supplier_person_contact` varchar(200) NOT NULL,
  `supplier_drug_licence` varchar(200) NOT NULL,
  `address` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_supplier` (`supplier`),
  KEY `index_contact` (`contact`),
  KEY `index_supplier_person` (`supplier_person`),
  KEY `index_supplier_person_contact` (`supplier_person_contact`),
  KEY `index_supplier_drug_licence` (`supplier_drug_licence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: menu_items
#

DROP TABLE IF EXISTS `menu_items`;

CREATE TABLE `menu_items` (
  `menu_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT NULL,
  `menu_name` varchar(100) NOT NULL,
  `menu_url` varchar(255) DEFAULT NULL,
  `menu_icon` varchar(100) DEFAULT 'ri-circle-line',
  `menu_order` int(11) DEFAULT 0,
  `menu_level` tinyint(4) DEFAULT 1,
  `permission_key` varchar(100) DEFAULT NULL,
  `module_name` varchar(50) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `is_system` tinyint(1) DEFAULT 0,
  `description` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`menu_id`),
  KEY `idx_parent_id` (`parent_id`),
  KEY `idx_menu_order` (`menu_order`),
  KEY `idx_is_active` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: messages
#

DROP TABLE IF EXISTS `messages`;

CREATE TABLE `messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) DEFAULT NULL,
  `template_id` varchar(100) NOT NULL,
  `message` text DEFAULT NULL,
  `send_mail` varchar(10) DEFAULT '0',
  `send_sms` varchar(10) DEFAULT '0',
  `is_group` varchar(10) DEFAULT '0',
  `is_individual` varchar(10) DEFAULT '0',
  `file` varchar(200) NOT NULL,
  `group_list` text DEFAULT NULL,
  `user_list` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_title` (`title`),
  KEY `index_send_mail` (`send_mail`),
  KEY `index_send_sms` (`send_sms`),
  KEY `index_is_group` (`is_group`),
  KEY `index_is_individual` (`is_individual`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `messages` (`id`, `title`, `template_id`, `message`, `send_mail`, `send_sms`, `is_group`, `is_individual`, `file`, `group_list`, `user_list`, `created_at`) VALUES (1, 'vgfxfk,', '', 'v,;gdrrw5', '0', '1', '0', '1', '', NULL, '[{\"category\":\"Patient\",\"user_id\":\"53\",\"email\":\"karuga@cityhealth.co.ke\",\"mobileno\":\"+254720456900\",\"app_key\":\"\"}]', '2025-07-05 09:26:13');


#
# TABLE STRUCTURE FOR: migration_log
#

DROP TABLE IF EXISTS `migration_log`;

CREATE TABLE `migration_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `migration_name` varchar(255) NOT NULL,
  `executed_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `migration_log` (`id`, `migration_name`, `executed_at`) VALUES (1, 'phlebotomy_module_migration', '2025-07-20 16:13:55');


#
# TABLE STRUCTURE FOR: migrations
#

DROP TABLE IF EXISTS `migrations`;

CREATE TABLE `migrations` (
  `version` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: notification_roles
#

DROP TABLE IF EXISTS `notification_roles`;

CREATE TABLE `notification_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `send_notification_id` int(11) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `send_notification_id` (`send_notification_id`),
  KEY `role_id` (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `notification_roles` (`id`, `send_notification_id`, `role_id`, `is_active`, `created_at`) VALUES (1, 1, 1, 0, '2025-07-04 09:08:08');
INSERT INTO `notification_roles` (`id`, `send_notification_id`, `role_id`, `is_active`, `created_at`) VALUES (2, 1, 2, 0, '2025-07-04 09:08:08');
INSERT INTO `notification_roles` (`id`, `send_notification_id`, `role_id`, `is_active`, `created_at`) VALUES (3, 1, 3, 0, '2025-07-04 09:08:08');
INSERT INTO `notification_roles` (`id`, `send_notification_id`, `role_id`, `is_active`, `created_at`) VALUES (4, 1, 7, 0, '2025-07-04 09:08:08');


#
# TABLE STRUCTURE FOR: notification_setting
#

DROP TABLE IF EXISTS `notification_setting`;

CREATE TABLE `notification_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT NULL,
  `is_mail` int(11) DEFAULT 0,
  `is_sms` int(11) DEFAULT 0,
  `is_mobileapp` int(11) NOT NULL,
  `is_notification` int(11) NOT NULL,
  `display_notification` int(11) NOT NULL,
  `display_sms` int(11) NOT NULL,
  `template` longtext DEFAULT NULL,
  `template_id` varchar(100) NOT NULL,
  `subject` text DEFAULT NULL,
  `variables` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_type` (`type`),
  KEY `index_is_mail` (`is_mail`),
  KEY `index_is_sms` (`is_sms`),
  KEY `index_is_mobileapp` (`is_mobileapp`),
  KEY `index_is_notification` (`is_notification`),
  KEY `index_display_notification` (`display_notification`),
  KEY `index_display_sms` (`display_sms`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (1, 'opd_patient_registration', 1, 0, 1, 1, 1, 1, 'Dear {{patient_name}} your OPD Registration at Smart Hospital is successful on date {{appointment_date}} with Patient Id {{patient_id}} and OPD No {{opdno}}', '', 'OPD Patient', '{{patient_name}} {{appointment_date}} {{patient_id}} {{opdno}}', '2021-10-22 07:57:53');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (2, 'ipd_patient_registration', 1, 0, 0, 0, 1, 1, 'Dear {{patient_name}} your IPD Registration at Smart Hospital is successful  with Patient Id {{patient_id}} and IPD No {{ipd_no}}', '', 'IPD Patient Registration', '{{patient_name}} {{patient_id}} {{ipd_no}}', '2021-10-22 07:59:33');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (3, 'ipd_patient_discharged', 1, 0, 0, 0, 1, 1, 'IPD Patient {{patient_name}} is now discharged from Smart Hospital\nTotal bill amount is {{currency_symbol}}{{total_amount}}\nTotal paid amount is {{currency_symbol}}{{paid_amount}}\nTotal balance bill amount is {{currency_symbol}}{{balance_amount}}', '', 'IPD Patient Discharge', '{{patient_name}} {{currency_symbol}} {{total_amount}} {{paid_amount}} {balance_amount}}', '2021-10-25 04:32:35');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (5, 'login_credential', 1, 0, 0, 0, 0, 1, 'Hello {{display_name}} your Smart Hospital login details are Url: {{url}} Username: {{username}} Password: {{password}}', '', 'Smart Hospital Login Credential', '{{display_name}} {{url}} {{username}} {{password}}', '2021-10-22 08:18:21');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (6, 'appointment_approved', 1, 0, 0, 0, 1, 1, 'Dear {{patient_name}} your appointment with {{staff_name}} {{staff_surname}} is confirmed on {{date}} with appointment no: {{appointment_no}}', '', 'Appointment Approved', '{{patient_name}} {{staff_name}}\n{{staff_surname}}  {{date}} {{appointment_no}}', '2021-10-23 01:56:24');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (7, 'live_meeting', 1, 0, 0, 0, 0, 1, 'Dear staff, your live meeting {{title}} has been scheduled on {{date}} for the duration of {{duration}} minute.', '', 'Live Meeting', '{{title}} {{date}} {{duration}}', '2021-10-23 01:54:58');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (8, 'live_consult', 1, 0, 0, 0, 1, 1, 'Dear patient, your live consultation {{title}} has been scheduled on {{date}} for the duration of {{duration}} minute.', '', 'Live Consultation', '{{title}} {{date}} {{duration}}', '2021-10-22 08:28:26');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (9, 'opd_patient_discharged', 1, 0, 0, 0, 1, 1, 'OPD No {{opd_no}}  {{patient_name}} is now discharged from Smart Hospital.\r\n\r\nTotal bill amount was {{currency_symbol}}  {{total_amount}} \r\nTotal paid amount was {{currency_symbol}}{{paid_amount}}  \r\nTotal balance amount is {{currency_symbol}}{{balance_amount}}', '', 'OPD Patient Discharged', '{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{opd_no}}{{currency_symbol}} {{billing_amount}}', '2021-10-22 08:25:06');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `template_id`, `subject`, `variables`, `created_at`) VALUES (10, 'forgot_password', 1, 0, 0, 0, 0, 0, 'Dear  {{display_name}}, recently a request was submitted to reset password for your account with email: {{email}}. If you didn\'t make the request, just ignore this email, otherwise you can reset your password using this link <a href=\'{{resetpasslink}}\'>click here to reset your password</a>, if you\'re having trouble clicking the password reset link, copy and paste below URL  into your web browser. {{resetpasslink}} <br> Regards,  <br>\r\nSmart Hospital', '', 'Reset Password Request', '{{display_name}}  {{email}}  {{resetpasslink}', '2021-10-22 08:34:34');


#
# TABLE STRUCTURE FOR: nurse_note
#

DROP TABLE IF EXISTS `nurse_note`;

CREATE TABLE `nurse_note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `ipd_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `comment` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `staff_id` (`staff_id`),
  KEY `index_date` (`date`),
  KEY `idx_patient_id` (`patient_id`),
  KEY `idx_ipd_id` (`ipd_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `nurse_note` (`id`, `date`, `ipd_id`, `patient_id`, `staff_id`, `note`, `comment`, `created_by`, `updated_at`, `created_at`) VALUES (11, '2025-07-04 11:05:27', NULL, 56, 1, 'DEBUG TEST NOTE - 2025-07-04 11:05:27', 'This is a test insertion', 1, '0000-00-00 00:00:00', '2025-07-04 10:05:27');
INSERT INTO `nurse_note` (`id`, `date`, `ipd_id`, `patient_id`, `staff_id`, `note`, `comment`, `created_by`, `updated_at`, `created_at`) VALUES (12, '2025-07-04 11:09:40', NULL, 56, 1, 'Test note for OPD patient (no IPD required)', 'This should work now', 1, '0000-00-00 00:00:00', '2025-07-04 10:09:40');


#
# TABLE STRUCTURE FOR: nurse_notes_comment
#

DROP TABLE IF EXISTS `nurse_notes_comment`;

CREATE TABLE `nurse_notes_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nurse_note_id` int(11) DEFAULT NULL,
  `comment_staffid` int(11) DEFAULT NULL,
  `comment_staff` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `nurse_note_id` (`nurse_note_id`),
  KEY `comment_staffid` (`comment_staffid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: nursing_assessments
#

DROP TABLE IF EXISTS `nursing_assessments`;

CREATE TABLE `nursing_assessments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) DEFAULT NULL,
  `assessment_type` varchar(100) NOT NULL,
  `assessment_data` text DEFAULT NULL,
  `findings` text DEFAULT NULL,
  `recommendations` text DEFAULT NULL,
  `risk_level` enum('low','medium','high','critical') DEFAULT 'low',
  `follow_up_required` tinyint(1) DEFAULT 0,
  `follow_up_date` date DEFAULT NULL,
  `assessed_by` int(11) NOT NULL,
  `assessment_date` timestamp NULL DEFAULT current_timestamp(),
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_patient_id` (`patient_id`),
  KEY `idx_assessment_type` (`assessment_type`),
  KEY `idx_risk_level` (`risk_level`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `nursing_assessments` (`id`, `patient_id`, `ipd_id`, `assessment_type`, `assessment_data`, `findings`, `recommendations`, `risk_level`, `follow_up_required`, `follow_up_date`, `assessed_by`, `assessment_date`, `created_at`) VALUES (1, 56, NULL, 'pain', NULL, 'test', 'rest', 'low', 0, NULL, 1, '2025-07-04 08:39:02', '2025-07-04 11:39:02');


#
# TABLE STRUCTURE FOR: nursing_care_plans
#

DROP TABLE IF EXISTS `nursing_care_plans`;

CREATE TABLE `nursing_care_plans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) DEFAULT NULL,
  `plan_name` varchar(255) NOT NULL,
  `nursing_diagnosis` text DEFAULT NULL,
  `goals` text NOT NULL,
  `interventions` text DEFAULT NULL,
  `evaluations` text DEFAULT NULL,
  `priority` enum('low','medium','high','urgent') DEFAULT 'medium',
  `status` enum('active','completed','discontinued','on_hold') DEFAULT 'active',
  `start_date` date NOT NULL,
  `target_date` date DEFAULT NULL,
  `completion_date` date DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `assigned_to` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_patient_id` (`patient_id`),
  KEY `idx_status` (`status`),
  KEY `idx_priority` (`priority`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `nursing_care_plans` (`id`, `patient_id`, `ipd_id`, `plan_name`, `nursing_diagnosis`, `goals`, `interventions`, `evaluations`, `priority`, `status`, `start_date`, `target_date`, `completion_date`, `created_by`, `assigned_to`, `created_at`, `updated_at`) VALUES (1, 56, NULL, 'Test', 'Test', 'Test', 'Test', NULL, 'low', 'active', '2025-07-04', '2025-07-06', NULL, 1, NULL, '2025-07-04 08:41:13', '2025-07-04 11:41:13');


#
# TABLE STRUCTURE FOR: nursing_procedure_templates
#

DROP TABLE IF EXISTS `nursing_procedure_templates`;

CREATE TABLE `nursing_procedure_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `procedure_name` varchar(255) NOT NULL,
  `procedure_type` varchar(100) NOT NULL,
  `procedure_code` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `pre_procedure_checklist` text DEFAULT NULL,
  `post_procedure_checklist` text DEFAULT NULL,
  `estimated_duration` int(11) DEFAULT NULL,
  `required_supplies` text DEFAULT NULL,
  `skill_level_required` enum('basic','intermediate','advanced') DEFAULT 'basic',
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_procedure_type` (`procedure_type`),
  KEY `idx_is_active` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `nursing_procedure_templates` (`id`, `procedure_name`, `procedure_type`, `procedure_code`, `description`, `pre_procedure_checklist`, `post_procedure_checklist`, `estimated_duration`, `required_supplies`, `skill_level_required`, `is_active`, `created_at`) VALUES (1, 'Blood Pressure Monitoring', 'vital_signs', 'VS001', 'Routine blood pressure measurement and monitoring', 'Check equipment, ensure patient comfort, verify patient identity', 'Record readings, clean equipment, document any abnormalities', 5, 'BP cuff, stethoscope, documentation sheet', 'basic', 1, '2025-07-02 16:02:22');
INSERT INTO `nursing_procedure_templates` (`id`, `procedure_name`, `procedure_type`, `procedure_code`, `description`, `pre_procedure_checklist`, `post_procedure_checklist`, `estimated_duration`, `required_supplies`, `skill_level_required`, `is_active`, `created_at`) VALUES (2, 'Wound Dressing Change', 'wound_care', 'WC001', 'Sterile wound dressing change and assessment', 'Gather supplies, hand hygiene, patient positioning', 'Dispose of materials, document wound status, patient education', 15, 'Sterile gloves, gauze, tape, antiseptic, disposal bag', 'intermediate', 1, '2025-07-02 16:02:22');
INSERT INTO `nursing_procedure_templates` (`id`, `procedure_name`, `procedure_type`, `procedure_code`, `description`, `pre_procedure_checklist`, `post_procedure_checklist`, `estimated_duration`, `required_supplies`, `skill_level_required`, `is_active`, `created_at`) VALUES (3, 'Medication Administration', 'medication', 'MED001', 'Safe medication administration following 5 rights', 'Verify order, check allergies, confirm patient identity', 'Document administration, monitor for reactions, proper disposal', 10, 'Medication, administration supplies, documentation', 'intermediate', 1, '2025-07-02 16:02:22');
INSERT INTO `nursing_procedure_templates` (`id`, `procedure_name`, `procedure_type`, `procedure_code`, `description`, `pre_procedure_checklist`, `post_procedure_checklist`, `estimated_duration`, `required_supplies`, `skill_level_required`, `is_active`, `created_at`) VALUES (4, 'Catheter Care', 'catheter_care', 'CC001', 'Urinary catheter maintenance and care', 'Hand hygiene, gather supplies, privacy measures', 'Document output, check for complications, patient comfort', 20, 'Sterile gloves, cleansing solution, catheter care kit', 'intermediate', 1, '2025-07-02 16:02:22');


#
# TABLE STRUCTURE FOR: nursing_procedures
#

DROP TABLE IF EXISTS `nursing_procedures`;

CREATE TABLE `nursing_procedures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) DEFAULT NULL,
  `procedure_type` varchar(100) NOT NULL,
  `procedure_name` varchar(255) NOT NULL,
  `procedure_code` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `pre_procedure_notes` text DEFAULT NULL,
  `post_procedure_notes` text DEFAULT NULL,
  `complications` text DEFAULT NULL,
  `outcome` enum('successful','partial','failed','complications') DEFAULT 'successful',
  `status` enum('scheduled','in_progress','completed','cancelled') DEFAULT 'scheduled',
  `performed_by` int(11) NOT NULL,
  `assisted_by` varchar(255) DEFAULT NULL,
  `performed_at` timestamp NULL DEFAULT NULL,
  `duration_minutes` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_patient_id` (`patient_id`),
  KEY `idx_ipd_id` (`ipd_id`),
  KEY `idx_procedure_type` (`procedure_type`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `nursing_procedures` (`id`, `patient_id`, `ipd_id`, `procedure_type`, `procedure_name`, `procedure_code`, `description`, `pre_procedure_notes`, `post_procedure_notes`, `complications`, `outcome`, `status`, `performed_by`, `assisted_by`, `performed_at`, `duration_minutes`, `created_at`, `updated_at`) VALUES (1, 56, NULL, 'preventive', 'Test', NULL, NULL, NULL, NULL, NULL, 'successful', 'scheduled', 1, NULL, NULL, 15, '2025-07-04 05:49:43', '2025-07-04 08:49:43');
INSERT INTO `nursing_procedures` (`id`, `patient_id`, `ipd_id`, `procedure_type`, `procedure_name`, `procedure_code`, `description`, `pre_procedure_notes`, `post_procedure_notes`, `complications`, `outcome`, `status`, `performed_by`, `assisted_by`, `performed_at`, `duration_minutes`, `created_at`, `updated_at`) VALUES (2, 56, NULL, 'preventive', 'Rest', NULL, 'Test', NULL, 'Test', NULL, 'successful', 'scheduled', 1, NULL, NULL, 15, '2025-07-04 08:42:25', '2025-07-04 11:42:25');


#
# TABLE STRUCTURE FOR: nursing_vital_signs
#

DROP TABLE IF EXISTS `nursing_vital_signs`;

CREATE TABLE `nursing_vital_signs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) DEFAULT NULL,
  `temperature` decimal(4,2) DEFAULT NULL,
  `temperature_unit` enum('C','F') DEFAULT 'C',
  `systolic_bp` int(11) DEFAULT NULL,
  `diastolic_bp` int(11) DEFAULT NULL,
  `pulse_rate` int(11) DEFAULT NULL,
  `respiratory_rate` int(11) DEFAULT NULL,
  `oxygen_saturation` int(11) DEFAULT NULL,
  `pain_scale` int(11) DEFAULT NULL,
  `weight` decimal(5,2) DEFAULT NULL,
  `height` decimal(5,2) DEFAULT NULL,
  `bmi` decimal(4,2) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `recorded_by` int(11) NOT NULL,
  `recorded_at` timestamp NULL DEFAULT current_timestamp(),
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_patient_id` (`patient_id`),
  KEY `idx_ipd_id` (`ipd_id`),
  KEY `idx_recorded_at` (`recorded_at`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `nursing_vital_signs` (`id`, `patient_id`, `ipd_id`, `temperature`, `temperature_unit`, `systolic_bp`, `diastolic_bp`, `pulse_rate`, `respiratory_rate`, `oxygen_saturation`, `pain_scale`, `weight`, `height`, `bmi`, `notes`, `recorded_by`, `recorded_at`, `created_at`) VALUES (1, 56, 0, '36.80', 'C', 120, 80, 80, 16, 98, 0, '75.00', '170.00', '25.95', 'test', 1, '2025-07-03 19:13:11', '2025-07-03 22:13:11');
INSERT INTO `nursing_vital_signs` (`id`, `patient_id`, `ipd_id`, `temperature`, `temperature_unit`, `systolic_bp`, `diastolic_bp`, `pulse_rate`, `respiratory_rate`, `oxygen_saturation`, `pain_scale`, `weight`, `height`, `bmi`, `notes`, `recorded_by`, `recorded_at`, `created_at`) VALUES (2, 56, 0, '36.50', 'C', 120, 81, 81, 17, 98, 0, '75.00', '172.00', '25.35', 'testing', 1, '2025-07-04 02:45:06', '2025-07-04 05:45:06');
INSERT INTO `nursing_vital_signs` (`id`, `patient_id`, `ipd_id`, `temperature`, `temperature_unit`, `systolic_bp`, `diastolic_bp`, `pulse_rate`, `respiratory_rate`, `oxygen_saturation`, `pain_scale`, `weight`, `height`, `bmi`, `notes`, `recorded_by`, `recorded_at`, `created_at`) VALUES (3, 57, NULL, '38.00', 'C', 120, 75, 70, 60, 70, NULL, NULL, NULL, NULL, NULL, 1, '2025-07-04 11:21:52', '2025-07-04 14:21:52');


#
# TABLE STRUCTURE FOR: obstetric_history
#

DROP TABLE IF EXISTS `obstetric_history`;

CREATE TABLE `obstetric_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `place_of_delivery` varchar(250) NOT NULL,
  `pregnancy_duration` varchar(250) NOT NULL,
  `pregnancy_complications` varchar(250) NOT NULL,
  `birth_weight` varchar(250) NOT NULL,
  `gender` varchar(100) NOT NULL,
  `infant_feeding` varchar(250) NOT NULL,
  `alive_dead` varchar(50) NOT NULL,
  `date` date DEFAULT NULL,
  `death_cause` varchar(250) NOT NULL,
  `previous_medical_history` text NOT NULL,
  `special_instruction` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_place_of_delivery` (`place_of_delivery`),
  KEY `index_pregnancy_duration` (`pregnancy_duration`),
  KEY `index_pregnancy_complications` (`pregnancy_complications`),
  KEY `index_birth_weight` (`birth_weight`),
  KEY `index_gender` (`gender`),
  KEY `index_infant_feeding` (`infant_feeding`),
  KEY `index_alive_dead` (`alive_dead`),
  KEY `index_date` (`date`),
  KEY `index_death_cause` (`death_cause`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: opd_details
#

DROP TABLE IF EXISTS `opd_details`;

CREATE TABLE `opd_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `case_reference_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `is_ipd_moved` int(11) NOT NULL DEFAULT 0,
  `discharged` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `payment_status` varchar(20) DEFAULT 'pending',
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `generated_by` (`generated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `opd_details` (`id`, `case_reference_id`, `patient_id`, `generated_by`, `is_ipd_moved`, `discharged`, `created_at`, `payment_status`) VALUES (1, 1, 8, 1, 0, 'no', '2025-06-06 13:32:18', 'pending');


#
# TABLE STRUCTURE FOR: opd_details_partitioned
#

DROP TABLE IF EXISTS `opd_details_partitioned`;

CREATE TABLE `opd_details_partitioned` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) NOT NULL,
  `appointment_date` datetime NOT NULL,
  `case_type` varchar(50) DEFAULT NULL,
  `symptoms` text DEFAULT NULL,
  `cons_doctor` int(11) DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `payment_mode` varchar(20) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`,`appointment_date`),
  KEY `idx_patient` (`patient_id`),
  KEY `idx_doctor` (`cons_doctor`),
  KEY `idx_amount` (`amount`),
  KEY `idx_payment_mode` (`payment_mode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci
 PARTITION BY RANGE (year(`appointment_date`))
(PARTITION `p2023` VALUES LESS THAN (2024) ENGINE = InnoDB,
 PARTITION `p2024` VALUES LESS THAN (2025) ENGINE = InnoDB,
 PARTITION `p2025` VALUES LESS THAN (2026) ENGINE = InnoDB,
 PARTITION `p_future` VALUES LESS THAN MAXVALUE ENGINE = InnoDB);

#
# TABLE STRUCTURE FOR: operation
#

DROP TABLE IF EXISTS `operation`;

CREATE TABLE `operation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `operation` varchar(250) NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `index_operation` (`operation`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: operation_category
#

DROP TABLE IF EXISTS `operation_category`;

CREATE TABLE `operation_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(250) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `index_category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: operation_theatre
#

DROP TABLE IF EXISTS `operation_theatre`;

CREATE TABLE `operation_theatre` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `opd_details_id` int(11) DEFAULT NULL,
  `ipd_details_id` int(11) DEFAULT NULL,
  `customer_type` varchar(50) DEFAULT NULL,
  `operation_id` int(11) NOT NULL,
  `date` datetime DEFAULT NULL,
  `operation_type` varchar(100) DEFAULT NULL,
  `consultant_doctor` int(11) DEFAULT NULL,
  `ass_consultant_1` varchar(50) DEFAULT NULL,
  `ass_consultant_2` varchar(50) DEFAULT NULL,
  `anesthetist` varchar(50) DEFAULT NULL,
  `anaethesia_type` varchar(50) DEFAULT NULL,
  `ot_technician` varchar(100) DEFAULT NULL,
  `ot_assistant` varchar(100) DEFAULT NULL,
  `result` text DEFAULT NULL,
  `remark` text DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `opd_details_id` (`opd_details_id`),
  KEY `ipd_details_id` (`ipd_details_id`),
  KEY `consultant_doctor` (`consultant_doctor`),
  KEY `generated_by` (`generated_by`),
  KEY `operation_id` (`operation_id`),
  KEY `index_date` (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: organisation
#

DROP TABLE IF EXISTS `organisation`;

CREATE TABLE `organisation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `organisation_name` varchar(200) NOT NULL,
  `code` varchar(50) NOT NULL,
  `contact_no` varchar(20) NOT NULL,
  `address` varchar(300) NOT NULL,
  `contact_person_name` varchar(200) NOT NULL,
  `contact_person_phone` varchar(20) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_organisation_name` (`organisation_name`),
  KEY `index_code` (`code`),
  KEY `index_contact_no` (`contact_no`),
  KEY `index_address` (`address`),
  KEY `index_contact_person_name` (`contact_person_name`),
  KEY `index_contact_person_phone` (`contact_person_phone`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `organisation` (`id`, `organisation_name`, `code`, `contact_no`, `address`, `contact_person_name`, `contact_person_phone`, `created_at`) VALUES (1, 'Madison Insurance', 'MAD001', '0700112233', '', '', '', '2025-06-21 19:11:03');
INSERT INTO `organisation` (`id`, `organisation_name`, `code`, `contact_no`, `address`, `contact_person_name`, `contact_person_phone`, `created_at`) VALUES (2, 'AAR Insurance', 'AAR001', '0711223344', '', 'Peter Mkuu', '071122352', '2025-06-21 19:11:24');
INSERT INTO `organisation` (`id`, `organisation_name`, `code`, `contact_no`, `address`, `contact_person_name`, `contact_person_phone`, `created_at`) VALUES (3, 'Britam Insurance', 'BB015', '012354780', 'Upperhill', 'Andrew', '021545230', '2025-07-04 08:52:01');


#
# TABLE STRUCTURE FOR: organisations_charges
#

DROP TABLE IF EXISTS `organisations_charges`;

CREATE TABLE `organisations_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `org_charge` float(10,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`),
  KEY `charge_id` (`charge_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: pathology
#

DROP TABLE IF EXISTS `pathology`;

CREATE TABLE `pathology` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_name` varchar(100) DEFAULT NULL,
  `short_name` varchar(100) DEFAULT NULL,
  `test_type` varchar(100) DEFAULT NULL,
  `pathology_category_id` int(11) DEFAULT NULL,
  `unit` varchar(50) NOT NULL,
  `sub_category` varchar(50) NOT NULL,
  `report_days` varchar(50) NOT NULL,
  `method` varchar(50) NOT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `cost` decimal(10,2) NOT NULL DEFAULT 0.00,
  `sample_type` varchar(100) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `pathology_category_id` (`pathology_category_id`),
  KEY `charge_id` (`charge_id`),
  KEY `index_test_name` (`test_name`),
  KEY `index_short_name` (`short_name`),
  KEY `index_test_type` (`test_type`),
  KEY `index_unit` (`unit`),
  KEY `index_sub_category` (`sub_category`),
  KEY `index_report_days` (`report_days`),
  KEY `index_method` (`method`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (1, 'Complete Blood Count', 'CBC', 'Hematology', 1, 'cells/μL', 'Blood Count', '1', 'Automated Cell Counter', NULL, '2025-06-29 13:32:07', '800.00', 'Blood', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (2, 'Full Blood Count', 'FBC', 'Hematology', 1, 'cells/μL', 'Blood Count', '1', 'Automated Cell Counter', NULL, '2025-06-29 13:32:07', '800.00', 'Blood', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (3, 'Malaria Parasite', 'MPS', 'Parasitology', 1, '+/-', 'Malaria', '1', 'Microscopy', NULL, '2025-06-29 13:32:07', '300.00', 'Blood', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (4, 'Random Blood Sugar', 'RBS', 'Chemistry', 2, 'mg/dL', 'Glucose', '1', 'Glucose Oxidase', NULL, '2025-06-29 13:32:07', '200.00', 'Blood', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (5, 'Fasting Blood Sugar', 'FBS', 'Chemistry', 2, 'mg/dL', 'Glucose', '1', 'Glucose Oxidase', NULL, '2025-06-29 13:32:07', '250.00', 'Blood', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (6, 'Liver Function Tests', 'LFT', 'Chemistry', 2, 'IU/L', 'Liver', '1', 'Spectrophotometry', NULL, '2025-06-29 13:32:07', '1200.00', 'Serum', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (7, 'Kidney Function Tests', 'KFT', 'Chemistry', 2, 'mg/dL', 'Kidney', '1', 'Spectrophotometry', NULL, '2025-06-29 13:32:07', '1000.00', 'Serum', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (8, 'Lipid Profile', 'LIPIDS', 'Chemistry', 2, 'mg/dL', 'Lipids', '1', 'Spectrophotometry', NULL, '2025-06-29 13:32:07', '1500.00', 'Serum', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (9, 'Urine Culture', 'UC', 'Microbiology', 3, 'CFU/mL', 'Culture', '3', 'Culture & Sensitivity', NULL, '2025-06-29 13:32:07', '800.00', 'Urine', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (10, 'Blood Culture', 'BC', 'Microbiology', 3, 'CFU/mL', 'Culture', '3', 'Culture & Sensitivity', NULL, '2025-06-29 13:32:07', '1200.00', 'Blood', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (11, 'Stool Culture', 'SC', 'Microbiology', 3, 'CFU/g', 'Culture', '3', 'Culture & Sensitivity', NULL, '2025-06-29 13:32:07', '600.00', 'Stool', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (12, 'HIV Test', 'HIV', 'Serology', 4, '+/-', 'Viral', '1', 'ELISA', NULL, '2025-06-29 13:32:07', '500.00', 'Blood', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (13, 'Hepatitis B Surface Antigen', 'HBsAg', 'Serology', 4, '+/-', 'Viral', '1', 'ELISA', NULL, '2025-06-29 13:32:07', '600.00', 'Serum', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (14, 'Hepatitis C Antibody', 'HCV', 'Serology', 4, '+/-', 'Viral', '1', 'ELISA', NULL, '2025-06-29 13:32:07', '700.00', 'Serum', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (15, 'Thyroid Function Tests', 'TFT', 'Endocrinology', 5, 'μIU/mL', 'Hormones', '2', 'ELISA', NULL, '2025-06-29 13:32:07', '1800.00', 'Serum', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (16, 'Widal Test', 'WIDAL', 'Serology', 4, 'Titre', 'Bacterial', '1', 'Agglutination', NULL, '2025-06-29 13:32:07', '400.00', 'Serum', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (17, 'Urinalysis', 'U/A', 'Urinanalysis', 6, 'Various', 'Routine', '1', 'Dipstick & Microscopy', NULL, '2025-06-29 13:32:07', '300.00', 'Urine', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (18, 'Pregnancy Test', 'βHCG', 'Endocrinology', 5, 'mIU/mL', 'Hormones', '1', 'Immunoassay', NULL, '2025-06-29 13:32:07', '400.00', 'Urine', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (19, 'HbA1c', 'HbA1c', 'Chemistry', 2, '%', 'Glucose', '1', 'HPLC', NULL, '2025-06-29 13:32:07', '1200.00', 'Blood', 1);
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`, `cost`, `sample_type`, `is_active`) VALUES (20, 'Erythrocyte Sedimentation Rate', 'ESR', 'Hematology', 1, 'mm/hr', 'Inflammatory', '1', 'Westergren Method', NULL, '2025-06-29 13:32:07', '200.00', 'Blood', 1);


#
# TABLE STRUCTURE FOR: pathology_billing
#

DROP TABLE IF EXISTS `pathology_billing`;

CREATE TABLE `pathology_billing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `case_reference_id` int(11) DEFAULT NULL,
  `ipd_prescription_basic_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `doctor_name` varchar(100) NOT NULL,
  `total` float(10,2) DEFAULT 0.00,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `discount` float(10,2) DEFAULT 0.00,
  `tax_percentage` float(10,2) DEFAULT 0.00,
  `tax` float(10,2) DEFAULT 0.00,
  `net_amount` float(10,2) DEFAULT 0.00,
  `transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `organisation_id` int(11) DEFAULT NULL,
  `insurance_validity` date DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  `insurance_id` varchar(250) DEFAULT NULL,
  `payment_status` varchar(20) DEFAULT 'pending',
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `doctor_id` (`doctor_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `transaction_id` (`transaction_id`),
  KEY `generated_by` (`generated_by`),
  KEY `ipd_prescription_basic_id` (`ipd_prescription_basic_id`),
  KEY `index_date` (`date`),
  KEY `index_doctor_name` (`doctor_name`),
  KEY `index_total` (`total`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_discount` (`discount`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_tax` (`tax`),
  KEY `index_net_amount` (`net_amount`),
  KEY `organisation_id` (`organisation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: pathology_category
#

DROP TABLE IF EXISTS `pathology_category`;

CREATE TABLE `pathology_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_category_name` (`category_name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `pathology_category` (`id`, `category_name`, `created_at`) VALUES (1, 'Hematology', '2025-06-29 13:31:24');
INSERT INTO `pathology_category` (`id`, `category_name`, `created_at`) VALUES (2, 'Clinical Chemistry', '2025-06-29 13:31:24');
INSERT INTO `pathology_category` (`id`, `category_name`, `created_at`) VALUES (3, 'Microbiology', '2025-06-29 13:31:24');
INSERT INTO `pathology_category` (`id`, `category_name`, `created_at`) VALUES (4, 'Immunology & Serology', '2025-06-29 13:31:24');
INSERT INTO `pathology_category` (`id`, `category_name`, `created_at`) VALUES (5, 'Endocrinology', '2025-06-29 13:31:24');
INSERT INTO `pathology_category` (`id`, `category_name`, `created_at`) VALUES (6, 'Urinanalysis', '2025-06-29 13:31:24');
INSERT INTO `pathology_category` (`id`, `category_name`, `created_at`) VALUES (7, 'Parasitology', '2025-06-29 13:31:24');
INSERT INTO `pathology_category` (`id`, `category_name`, `created_at`) VALUES (8, 'Histopathology', '2025-06-29 13:31:24');
INSERT INTO `pathology_category` (`id`, `category_name`, `created_at`) VALUES (9, 'Molecular Biology', '2025-06-29 13:31:24');
INSERT INTO `pathology_category` (`id`, `category_name`, `created_at`) VALUES (10, 'Blood Bank', '2025-06-29 13:31:24');


#
# TABLE STRUCTURE FOR: pathology_parameter
#

DROP TABLE IF EXISTS `pathology_parameter`;

CREATE TABLE `pathology_parameter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parameter_name` varchar(100) NOT NULL,
  `test_value` varchar(100) NOT NULL,
  `reference_range` varchar(100) NOT NULL,
  `range_from` varchar(500) DEFAULT NULL,
  `range_to` varchar(500) DEFAULT NULL,
  `gender` varchar(100) NOT NULL,
  `unit` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `unit` (`unit`),
  KEY `index_parameter_name` (`parameter_name`),
  KEY `index_test_value` (`test_value`),
  KEY `index_reference_range` (`reference_range`),
  KEY `index_range_from` (`range_from`),
  KEY `index_range_to` (`range_to`),
  KEY `index_gender` (`gender`),
  KEY `index_unit` (`unit`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: pathology_parameterdetails
#

DROP TABLE IF EXISTS `pathology_parameterdetails`;

CREATE TABLE `pathology_parameterdetails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pathology_id` int(11) DEFAULT NULL,
  `pathology_parameter_id` int(11) DEFAULT NULL,
  `created_id` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `pathology_id` (`pathology_id`),
  KEY `pathology_parameter_id` (`pathology_parameter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: pathology_report
#

DROP TABLE IF EXISTS `pathology_report`;

CREATE TABLE `pathology_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pathology_bill_id` int(11) DEFAULT NULL,
  `pathology_id` int(11) DEFAULT NULL,
  `customer_type` varchar(50) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `reporting_date` date DEFAULT NULL,
  `parameter_update` date DEFAULT NULL,
  `tax_percentage` float(10,2) NOT NULL DEFAULT 0.00,
  `apply_charge` float(10,2) NOT NULL,
  `collection_date` date DEFAULT NULL,
  `collection_specialist` int(11) DEFAULT NULL,
  `pathology_center` varchar(250) DEFAULT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `patient_name` varchar(100) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `pathology_report` varchar(255) DEFAULT NULL,
  `report_name` text DEFAULT NULL,
  `pathology_result` text DEFAULT NULL COMMENT 'test result',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `pathology_bill_id` (`pathology_bill_id`),
  KEY `pathology_id` (`pathology_id`),
  KEY `collection_specialist` (`collection_specialist`),
  KEY `approved_by` (`approved_by`),
  KEY `index_reporting_date` (`reporting_date`),
  KEY `index_parameter_update` (`parameter_update`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_apply_charge` (`apply_charge`),
  KEY `index_collection_date` (`collection_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: pathology_report_parameterdetails
#

DROP TABLE IF EXISTS `pathology_report_parameterdetails`;

CREATE TABLE `pathology_report_parameterdetails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pathology_report_id` int(11) DEFAULT NULL,
  `pathology_parameterdetail_id` int(11) DEFAULT NULL,
  `pathology_report_value` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `pathology_report_id` (`pathology_report_id`),
  KEY `pathology_parameterdetail_id` (`pathology_parameterdetail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: patient_activity_log
#

DROP TABLE IF EXISTS `patient_activity_log`;

CREATE TABLE `patient_activity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `activity_type` enum('consultation','laboratory','pharmacy','radiology','payment') NOT NULL,
  `activity_id` int(11) NOT NULL,
  `amount` decimal(15,2) DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_patient_activity` (`patient_id`,`created_at`),
  KEY `idx_activity_type` (`activity_type`),
  KEY `staff_id` (`staff_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: patient_bed_history
#

DROP TABLE IF EXISTS `patient_bed_history`;

CREATE TABLE `patient_bed_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `case_reference_id` int(11) DEFAULT NULL,
  `bed_group_id` int(11) DEFAULT NULL,
  `bed_id` int(11) DEFAULT NULL,
  `revert_reason` text DEFAULT NULL,
  `from_date` datetime DEFAULT NULL,
  `to_date` datetime DEFAULT NULL,
  `is_active` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `bed_group_id` (`bed_group_id`),
  KEY `bed_id` (`bed_id`),
  KEY `index_from_date` (`from_date`),
  KEY `index_to_date` (`to_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: patient_billing_summary
#

DROP TABLE IF EXISTS `patient_billing_summary`;

CREATE TABLE `patient_billing_summary` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `consultation_total` decimal(15,2) DEFAULT 0.00,
  `laboratory_total` decimal(15,2) DEFAULT 0.00,
  `pharmacy_total` decimal(15,2) DEFAULT 0.00,
  `radiology_total` decimal(15,2) DEFAULT 0.00,
  `grand_total` decimal(15,2) DEFAULT 0.00,
  `last_visit` date DEFAULT NULL,
  `last_updated` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `patient_id` (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: patient_charges
#

DROP TABLE IF EXISTS `patient_charges`;

CREATE TABLE `patient_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime DEFAULT NULL,
  `ipd_id` int(11) DEFAULT NULL,
  `opd_id` int(11) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `standard_charge` float(10,2) DEFAULT 0.00,
  `tpa_charge` float(10,2) DEFAULT 0.00,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `tax` float(10,2) DEFAULT 0.00,
  `apply_charge` float(10,2) DEFAULT 0.00,
  `amount` float(10,2) DEFAULT 0.00,
  `note` text DEFAULT NULL,
  `organisation_id` int(11) DEFAULT NULL,
  `insurance_validity` date DEFAULT NULL,
  `insurance_id` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `opd_id` (`opd_id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `charge_id` (`charge_id`),
  KEY `organisation_id` (`organisation_id`),
  KEY `index_qty` (`qty`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_tpa_charge` (`tpa_charge`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_tax` (`tax`),
  KEY `index_apply_charge` (`apply_charge`),
  KEY `index_amount` (`amount`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `patient_charges` (`id`, `date`, `ipd_id`, `opd_id`, `qty`, `charge_id`, `standard_charge`, `tpa_charge`, `discount_percentage`, `tax`, `apply_charge`, `amount`, `note`, `organisation_id`, `insurance_validity`, `insurance_id`, `created_at`) VALUES (1, '2025-06-06 11:32:18', NULL, 1, 1, 1, '2500.00', '0.00', '0.00', '0.00', '2500.00', '0.00', NULL, NULL, NULL, NULL, '2025-06-06 10:32:18');


#
# TABLE STRUCTURE FOR: patient_id_card
#

DROP TABLE IF EXISTS `patient_id_card`;

CREATE TABLE `patient_id_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `hospital_name` varchar(100) NOT NULL,
  `hospital_address` varchar(500) NOT NULL,
  `background` text NOT NULL,
  `logo` text NOT NULL,
  `sign_image` text NOT NULL,
  `header_color` varchar(100) NOT NULL,
  `enable_patient_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_guardian_name` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_patient_unique_id` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_address` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_phone` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_dob` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_blood_group` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `status` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `enable_barcode` tinyint(1) NOT NULL COMMENT '0=disable,1=enable',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_title` (`title`),
  KEY `index_hospital_name` (`hospital_name`),
  KEY `index_hospital_address` (`hospital_address`),
  KEY `index_header_color` (`header_color`),
  KEY `index_enable_patient_name` (`enable_patient_name`),
  KEY `index_enable_guardian_name` (`enable_guardian_name`),
  KEY `index_enable_patient_unique_id` (`enable_patient_unique_id`),
  KEY `index_enable_address` (`enable_address`),
  KEY `index_enable_phone` (`enable_phone`),
  KEY `index_enable_dob` (`enable_dob`),
  KEY `index_enable_blood_group` (`enable_blood_group`),
  KEY `index_status` (`status`),
  KEY `index_enable_barcode` (`enable_barcode`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `patient_id_card` (`id`, `title`, `hospital_name`, `hospital_address`, `background`, `logo`, `sign_image`, `header_color`, `enable_patient_name`, `enable_guardian_name`, `enable_patient_unique_id`, `enable_address`, `enable_phone`, `enable_dob`, `enable_blood_group`, `status`, `enable_barcode`, `created_at`) VALUES (1, 'Sample Patient Id Card', 'Royal Hospital', 'Nr Loyala Ashram, A 69, Shahpura Rd, Manisha Market, Sector  Bhopal', 'background.jpg', 'logo.jpg', 'signature.png', '#0796f5', 1, 1, 1, 1, 1, 1, 1, 1, 0, '2021-10-19 09:06:02');


#
# TABLE STRUCTURE FOR: patient_journey
#

DROP TABLE IF EXISTS `patient_journey`;

CREATE TABLE `patient_journey` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) NOT NULL,
  `patient_type_id` int(11) NOT NULL,
  `current_step` varchar(100) NOT NULL,
  `step_order` int(11) NOT NULL,
  `status` enum('pending','in_progress','completed','skipped','cancelled') DEFAULT 'pending',
  `started_at` timestamp NULL DEFAULT NULL,
  `completed_at` timestamp NULL DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `patient_type_id` (`patient_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: patient_lab_reports
#

DROP TABLE IF EXISTS `patient_lab_reports`;

CREATE TABLE `patient_lab_reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `report_type` enum('lab_report','imaging','document','other') NOT NULL DEFAULT 'lab_report',
  `report_title` varchar(255) NOT NULL,
  `report_description` text DEFAULT NULL,
  `file_name` varchar(255) NOT NULL,
  `file_path` varchar(500) NOT NULL,
  `file_size` int(11) DEFAULT NULL COMMENT 'File size in bytes',
  `file_type` varchar(50) DEFAULT NULL COMMENT 'MIME type',
  `original_filename` varchar(255) DEFAULT NULL,
  `report_date` date NOT NULL,
  `test_names` text DEFAULT NULL COMMENT 'Comma-separated list of tests',
  `lab_technician` int(11) DEFAULT NULL COMMENT 'Staff ID of lab technician',
  `doctor_id` int(11) DEFAULT NULL COMMENT 'Ordering doctor',
  `department` varchar(100) DEFAULT 'laboratory',
  `case_reference_id` int(11) DEFAULT NULL,
  `opd_id` int(11) DEFAULT NULL,
  `ipd_id` int(11) DEFAULT NULL,
  `consultation_id` int(11) DEFAULT NULL,
  `status` enum('pending','completed','verified','cancelled') DEFAULT 'pending',
  `is_critical` tinyint(1) DEFAULT 0 COMMENT 'Critical results flag',
  `notes` text DEFAULT NULL,
  `uploaded_by` int(11) NOT NULL COMMENT 'Staff ID who uploaded',
  `verified_by` int(11) DEFAULT NULL COMMENT 'Staff ID who verified',
  `verified_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_patient_id` (`patient_id`),
  KEY `idx_report_date` (`report_date`),
  KEY `idx_report_type` (`report_type`),
  KEY `idx_status` (`status`),
  KEY `idx_case_reference` (`case_reference_id`),
  KEY `idx_department` (`department`),
  KEY `fk_lab_reports_uploaded_by` (`uploaded_by`),
  KEY `fk_lab_reports_verified_by` (`verified_by`),
  KEY `fk_lab_reports_technician` (`lab_technician`),
  KEY `fk_lab_reports_doctor` (`doctor_id`),
  KEY `idx_lab_reports_patient_date` (`patient_id`,`report_date`),
  KEY `idx_lab_reports_status_type` (`status`,`report_type`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `patient_lab_reports` (`id`, `patient_id`, `report_type`, `report_title`, `report_description`, `file_name`, `file_path`, `file_size`, `file_type`, `original_filename`, `report_date`, `test_names`, `lab_technician`, `doctor_id`, `department`, `case_reference_id`, `opd_id`, `ipd_id`, `consultation_id`, `status`, `is_critical`, `notes`, `uploaded_by`, `verified_by`, `verified_at`, `created_at`, `updated_at`) VALUES (1, 55, 'lab_report', 'Test', '', 'lab_report_20250703104934_6866603e2d56c.pdf', './uploads/lab_reports/2025/07/lab_report_20250703104934_6866603e2d56c.pdf', 109059, 'application/pdf', 'MediSure360 System Process Flow.pdf', '2025-07-03', '', NULL, NULL, 'laboratory', NULL, NULL, NULL, NULL, 'verified', 0, 'Report verified by staff', 1, 1, '2025-07-03 09:49:53', '2025-07-03 09:49:34', '2025-07-03 09:49:53');
INSERT INTO `patient_lab_reports` (`id`, `patient_id`, `report_type`, `report_title`, `report_description`, `file_name`, `file_path`, `file_size`, `file_type`, `original_filename`, `report_date`, `test_names`, `lab_technician`, `doctor_id`, `department`, `case_reference_id`, `opd_id`, `ipd_id`, `consultation_id`, `status`, `is_critical`, `notes`, `uploaded_by`, `verified_by`, `verified_at`, `created_at`, `updated_at`) VALUES (2, 56, 'lab_report', 'CBC', '', 'lab_report_20250703135548_68668be466ecb.jpg', './uploads/lab_reports/2025/07/lab_report_20250703135548_68668be466ecb.jpg', 430437, 'image/jpeg', 'Income Statement.jpg', '2025-07-03', '', NULL, NULL, 'laboratory', NULL, NULL, NULL, NULL, 'verified', 0, 'Report verified by staff', 1, 1, '2025-07-03 12:56:06', '2025-07-03 12:55:48', '2025-07-03 12:56:06');
INSERT INTO `patient_lab_reports` (`id`, `patient_id`, `report_type`, `report_title`, `report_description`, `file_name`, `file_path`, `file_size`, `file_type`, `original_filename`, `report_date`, `test_names`, `lab_technician`, `doctor_id`, `department`, `case_reference_id`, `opd_id`, `ipd_id`, `consultation_id`, `status`, `is_critical`, `notes`, `uploaded_by`, `verified_by`, `verified_at`, `created_at`, `updated_at`) VALUES (3, 57, 'lab_report', 'blood culture', 'ok, normal readings', 'lab_report_20250704051908_6867644c34672.jpeg', './uploads/lab_reports/2025/07/lab_report_20250704051908_6867644c34672.jpeg', 105638, 'image/jpeg', 'WhatsApp Image 2025-06-24 at 13.22.09.jpeg', '2025-07-04', 'blood culture', NULL, NULL, 'laboratory', NULL, NULL, NULL, NULL, 'verified', 0, 'Report verified by staff', 1, 1, '2025-07-04 04:19:35', '2025-07-04 04:19:08', '2025-07-04 04:19:35');
INSERT INTO `patient_lab_reports` (`id`, `patient_id`, `report_type`, `report_title`, `report_description`, `file_name`, `file_path`, `file_size`, `file_type`, `original_filename`, `report_date`, `test_names`, `lab_technician`, `doctor_id`, `department`, `case_reference_id`, `opd_id`, `ipd_id`, `consultation_id`, `status`, `is_critical`, `notes`, `uploaded_by`, `verified_by`, `verified_at`, `created_at`, `updated_at`) VALUES (4, 56, 'imaging', 'Blood count', '', 'lab_report_20250705183430_6869703688fe6.jpg', './uploads/lab_reports/2025/07/lab_report_20250705183430_6869703688fe6.jpg', 430437, 'image/jpeg', 'Income Statement.jpg', '2025-07-05', '', NULL, NULL, 'laboratory', NULL, NULL, NULL, NULL, 'pending', 1, 'Bla bla', 1, NULL, NULL, '2025-07-05 17:34:30', '2025-07-05 17:34:30');
INSERT INTO `patient_lab_reports` (`id`, `patient_id`, `report_type`, `report_title`, `report_description`, `file_name`, `file_path`, `file_size`, `file_type`, `original_filename`, `report_date`, `test_names`, `lab_technician`, `doctor_id`, `department`, `case_reference_id`, `opd_id`, `ipd_id`, `consultation_id`, `status`, `is_critical`, `notes`, `uploaded_by`, `verified_by`, `verified_at`, `created_at`, `updated_at`) VALUES (5, 102, 'imaging', 'iopokvfdrsxc', 'fdtioplkcd', 'lab_report_20250706104312_686a53403a58f.pdf', './uploads/lab_reports/2025/07/lab_report_20250706104312_686a53403a58f.pdf', 106333, 'application/pdf', 'X-RAY PRICES.pdf', '2025-07-06', '', NULL, NULL, 'radiology', NULL, NULL, NULL, NULL, 'verified', 0, 'Report verified by staff', 1, 1, '2025-07-06 09:43:40', '2025-07-06 09:43:12', '2025-07-06 09:43:40');
INSERT INTO `patient_lab_reports` (`id`, `patient_id`, `report_type`, `report_title`, `report_description`, `file_name`, `file_path`, `file_size`, `file_type`, `original_filename`, `report_date`, `test_names`, `lab_technician`, `doctor_id`, `department`, `case_reference_id`, `opd_id`, `ipd_id`, `consultation_id`, `status`, `is_critical`, `notes`, `uploaded_by`, `verified_by`, `verified_at`, `created_at`, `updated_at`) VALUES (6, 133, 'lab_report', 'John J Test', '', 'lab_report_20250706151324_686a92946656e.docx', './uploads/lab_reports/2025/07/lab_report_20250706151324_686a92946656e.docx', 53251, 'application/vnd.openxmlformats-officedocument.word', 'IC-Change-Request-Form-Example_WORD.docx', '2025-07-06', '', NULL, NULL, 'laboratory', NULL, NULL, NULL, NULL, 'verified', 1, 'Report verified by staff', 1, 1, '2025-07-06 14:13:51', '2025-07-06 14:13:24', '2025-07-06 14:13:51');


#
# TABLE STRUCTURE FOR: patient_loyalty_points
#

DROP TABLE IF EXISTS `patient_loyalty_points`;

CREATE TABLE `patient_loyalty_points` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `transaction_type` enum('earned','redeemed','expired','adjusted') NOT NULL,
  `points` int(11) NOT NULL COMMENT 'Positive for earned, negative for redeemed',
  `amount_spent` decimal(10,2) DEFAULT NULL COMMENT 'Amount that generated points (KES)',
  `conversion_rate` decimal(5,2) DEFAULT 0.00 COMMENT 'Points per shilling (1 point per 1000 KES)',
  `description` varchar(255) NOT NULL,
  `reference_type` enum('opd','ipd','pharmacy','laboratory','radiology','general') DEFAULT NULL,
  `reference_id` int(11) DEFAULT NULL COMMENT 'ID of the transaction that generated points',
  `transaction_date` date NOT NULL,
  `expiry_date` date DEFAULT NULL COMMENT 'When points expire (if applicable)',
  `redeemed_service` varchar(255) DEFAULT NULL COMMENT 'Service redeemed using points',
  `redeemed_value` decimal(10,2) DEFAULT NULL COMMENT 'Value of redeemed service',
  `staff_id` int(11) DEFAULT NULL COMMENT 'Staff who processed the transaction',
  `is_active` tinyint(1) DEFAULT 1,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_patient_id` (`patient_id`),
  KEY `idx_transaction_type` (`transaction_type`),
  KEY `idx_transaction_date` (`transaction_date`),
  KEY `idx_expiry_date` (`expiry_date`),
  KEY `idx_reference` (`reference_type`,`reference_id`),
  KEY `fk_loyalty_staff` (`staff_id`),
  KEY `idx_loyalty_points_patient_active` (`patient_id`,`is_active`,`transaction_date`),
  KEY `idx_loyalty_expiry` (`expiry_date`,`transaction_type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `patient_loyalty_points` (`id`, `patient_id`, `transaction_type`, `points`, `amount_spent`, `conversion_rate`, `description`, `reference_type`, `reference_id`, `transaction_date`, `expiry_date`, `redeemed_service`, `redeemed_value`, `staff_id`, `is_active`, `notes`, `created_at`, `updated_at`) VALUES (1, 36, 'earned', 5, NULL, '0.00', 'Good payer', 'general', 0, '2025-07-03', NULL, NULL, NULL, 1, 1, NULL, '2025-07-03 09:51:58', '2025-07-03 12:51:58');
INSERT INTO `patient_loyalty_points` (`id`, `patient_id`, `transaction_type`, `points`, `amount_spent`, `conversion_rate`, `description`, `reference_type`, `reference_id`, `transaction_date`, `expiry_date`, `redeemed_service`, `redeemed_value`, `staff_id`, `is_active`, `notes`, `created_at`, `updated_at`) VALUES (2, 57, 'earned', 10, NULL, '0.00', 'regular customer', 'opd', 57, '2025-07-04', NULL, NULL, NULL, 1, 1, NULL, '2025-07-04 06:29:50', '2025-07-04 09:29:50');


#
# TABLE STRUCTURE FOR: patient_queue
#

DROP TABLE IF EXISTS `patient_queue`;

CREATE TABLE `patient_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) NOT NULL,
  `queue_number` varchar(20) NOT NULL,
  `department` varchar(50) NOT NULL,
  `status` enum('waiting','in_progress','completed','skipped','cancelled') DEFAULT 'waiting',
  `priority` enum('urgent','high','normal','low') DEFAULT 'normal',
  `queue_type` enum('registration','triage','consultation','laboratory','radiology','pharmacy','ipd','emergency') DEFAULT 'registration',
  `estimated_wait_time` int(11) DEFAULT NULL COMMENT 'in minutes',
  `actual_wait_time` int(11) DEFAULT NULL COMMENT 'in minutes',
  `called_at` timestamp NULL DEFAULT NULL,
  `served_at` timestamp NULL DEFAULT NULL,
  `completed_at` timestamp NULL DEFAULT NULL,
  `served_by` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `next_queue` varchar(50) DEFAULT NULL COMMENT 'Next department queue',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_patient_queue` (`patient_id`,`department`,`status`),
  KEY `idx_queue_number` (`queue_number`),
  KEY `idx_department` (`department`),
  KEY `idx_status` (`status`),
  KEY `idx_priority` (`priority`),
  KEY `idx_queue_type` (`queue_type`),
  KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: patient_routing
#

DROP TABLE IF EXISTS `patient_routing`;

CREATE TABLE `patient_routing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(50) NOT NULL,
  `triage_id` int(11) DEFAULT NULL,
  `from_department` varchar(100) DEFAULT 'triage',
  `to_department` varchar(100) NOT NULL,
  `priority` enum('urgent','high','normal','low') DEFAULT 'normal',
  `status` enum('pending','in_progress','completed','cancelled') DEFAULT 'pending',
  `routing_notes` text DEFAULT NULL,
  `routed_by` int(11) NOT NULL,
  `routed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `completed_at` timestamp NULL DEFAULT NULL,
  `completed_by` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `triage_id` (`triage_id`),
  KEY `to_department` (`to_department`),
  KEY `status` (`status`),
  KEY `routed_at` (`routed_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (1, '28', 3, 'triage', 'emergency', 'urgent', 'pending', 'Chief Complaint: Chest pains\n\nAssessment Notes: ', 1, '2025-06-18 17:20:32', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (2, '8', 4, 'triage', 'consultation', 'normal', 'pending', 'Chief Complaint: test\n\nAssessment Notes: ', 1, '2025-06-18 17:52:09', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (3, '8', 5, 'triage', 'consultation', 'normal', 'pending', 'Chief Complaint: test\n\nAssessment Notes: ', 1, '2025-06-18 17:52:13', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (4, '53', 11, 'triage', 'consultation', 'low', 'pending', 'Chief Complaint: None\n\nAssessment Notes: ', 1, '2025-06-30 04:53:11', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (5, '53', 12, 'triage', 'consultation', 'low', 'pending', 'Chief Complaint: General checkup\n\nAssessment Notes: None', 1, '2025-06-30 04:53:37', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (6, '28', 13, 'triage', 'emergency', 'high', 'pending', 'Chief Complaint: headache\n\nAssessment Notes: nrmal', 1, '2025-07-01 17:44:59', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (7, '56', 14, 'triage', 'consultation', '', 'pending', 'Chief Complaint: None\n\nAssessment Notes: None', 1, '2025-07-03 12:39:25', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (8, '56', 15, 'triage', 'consultation', '', 'pending', 'Chief Complaint: Good medical condition\n\nAssessment Notes: None', 1, '2025-07-03 12:39:56', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (9, '56', 16, 'triage', 'consultation', '', 'pending', 'Chief Complaint: Good medical condition\n\nAssessment Notes: None', 1, '2025-07-03 12:41:34', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (10, '56', 17, 'triage', 'consultation', '', 'pending', 'Chief Complaint: Good medical condition\n\nAssessment Notes: None', 1, '2025-07-03 12:41:39', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (11, '56', 18, 'triage', 'consultation', '', 'pending', 'Chief Complaint: Good medical condition\n\nAssessment Notes: None', 1, '2025-07-03 12:41:44', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (12, '56', 19, 'triage', 'consultation', '', 'pending', 'Chief Complaint: Test\n\nAssessment Notes: ', 1, '2025-07-03 16:26:32', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (13, '56', 20, 'triage', 'consultation', '', 'pending', 'Chief Complaint: Test\n\nAssessment Notes: ', 1, '2025-07-03 16:26:51', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (14, '56', 21, 'triage', 'consultation', '', 'pending', 'Chief Complaint: Test\n\nAssessment Notes: ', 1, '2025-07-03 16:36:19', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (15, '57', 22, 'triage', 'consultation', 'low', 'pending', 'Chief Complaint: abdominal pain cramps\n\nAssessment Notes: ', 1, '2025-07-04 03:48:14', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (16, '27', 23, 'triage', 'consultation', 'normal', 'pending', 'Chief Complaint: Mild Migraines\n\nAssessment Notes: Migraines', 1, '2025-07-04 09:46:58', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (17, '56', 24, 'triage', 'laboratory', 'low', 'pending', 'Chief Complaint: Migraine\n\nAssessment Notes: ', 1, '2025-07-05 17:13:52', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (18, '102', 25, 'triage', 'consultation', 'low', 'pending', 'Chief Complaint: Abdominal pain\n\nAssessment Notes: ', 1, '2025-07-06 07:44:02', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (19, '133', 26, 'triage', 'consultation', 'low', 'pending', 'Chief Complaint: Headache\n\nAssessment Notes: ', 1, '2025-07-06 14:07:29', NULL, NULL, NULL);
INSERT INTO `patient_routing` (`id`, `patient_id`, `triage_id`, `from_department`, `to_department`, `priority`, `status`, `routing_notes`, `routed_by`, `routed_at`, `completed_at`, `completed_by`, `updated_at`) VALUES (20, '134', 27, 'triage', 'consultation', 'normal', 'pending', 'Chief Complaint: Periodic Headaches\n\nAssessment Notes: None', 1, '2025-07-07 12:13:15', NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: patient_timeline
#

DROP TABLE IF EXISTS `patient_timeline`;

CREATE TABLE `patient_timeline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `title` varchar(200) NOT NULL,
  `timeline_date` datetime DEFAULT NULL,
  `description` text DEFAULT NULL,
  `document` varchar(255) NOT NULL,
  `status` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `generated_users_type` varchar(100) NOT NULL,
  `generated_users_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `generated_users_id` (`generated_users_id`),
  KEY `index_title` (`title`),
  KEY `index_date` (`date`),
  KEY `index_timeline_date` (`timeline_date`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `patient_timeline` (`id`, `patient_id`, `title`, `timeline_date`, `description`, `document`, `status`, `date`, `generated_users_type`, `generated_users_id`, `created_at`) VALUES (1, 56, 'Test', '2025-07-04 17:29:00', 'Test', '', 'yes', '2025-07-04 00:00:00', 'staff', 1, '2025-07-04 19:30:22');


#
# TABLE STRUCTURE FOR: patient_types
#

DROP TABLE IF EXISTS `patient_types`;

CREATE TABLE `patient_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type_name` varchar(100) NOT NULL,
  `type_code` varchar(20) NOT NULL,
  `base_fee` decimal(10,2) DEFAULT 0.00,
  `requires_fingerprint` tinyint(1) DEFAULT 0,
  `requires_photo` tinyint(1) DEFAULT 0,
  `workflow_steps` text NOT NULL,
  `description` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `type_code` (`type_code`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `patient_types` (`id`, `type_name`, `type_code`, `base_fee`, `requires_fingerprint`, `requires_photo`, `workflow_steps`, `description`, `is_active`, `created_at`) VALUES (1, 'GCC Process', 'GCC', '10500.00', 1, 1, 'registration,triage_optional,laboratory,radiology,consultation,end', 'Gulf Cooperation Council medical examination process with fingerprint and photo capture', 1, '2025-06-21 11:47:39');
INSERT INTO `patient_types` (`id`, `type_name`, `type_code`, `base_fee`, `requires_fingerprint`, `requires_photo`, `workflow_steps`, `description`, `is_active`, `created_at`) VALUES (2, 'General Process', 'GENERAL', '900.00', 0, 0, 'registration,triage_optional,consultation_optional,lab_optional,radiology_optional,pharmacy_optional,booking_optional', 'Standard outpatient care without biometric requirements', 1, '2025-06-21 11:47:39');
INSERT INTO `patient_types` (`id`, `type_name`, `type_code`, `base_fee`, `requires_fingerprint`, `requires_photo`, `workflow_steps`, `description`, `is_active`, `created_at`) VALUES (3, 'Specialized Medical Process', 'SPECIALIZED', '1500.00', 0, 0, 'registration,triage_required,consultation_required,lab_optional,pharmacy_optional,radiology_optional,end', 'Specialized medical consultation with mandatory triage and doctor consultation', 1, '2025-06-21 11:47:39');


#
# TABLE STRUCTURE FOR: patient_verifications
#

DROP TABLE IF EXISTS `patient_verifications`;

CREATE TABLE `patient_verifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `verification_method` enum('fingerprint','photo','manual','card') NOT NULL,
  `verification_result` enum('success','failed','manual_override') NOT NULL,
  `match_score` decimal(5,3) DEFAULT NULL,
  `department` varchar(50) NOT NULL,
  `verified_by` int(11) NOT NULL,
  `verification_timestamp` datetime NOT NULL,
  `device_info` text DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `session_id` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_patient` (`patient_id`),
  KEY `idx_department` (`department`),
  KEY `idx_timestamp` (`verification_timestamp`),
  KEY `idx_verified_by` (`verified_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: patients
#

DROP TABLE IF EXISTS `patients`;

CREATE TABLE `patients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_type_id` int(11) DEFAULT 2,
  `lang_id` int(11) DEFAULT NULL,
  `patient_name` varchar(100) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `age` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `day` int(11) NOT NULL,
  `as_of_date` date DEFAULT NULL,
  `image` text DEFAULT NULL,
  `mobileno` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `gender` varchar(100) DEFAULT NULL,
  `blood_group_id` int(11) DEFAULT NULL,
  `marital_status` varchar(100) NOT NULL,
  `blood_group` varchar(200) NOT NULL,
  `blood_bank_product_id` int(11) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `guardian_name` varchar(100) DEFAULT NULL,
  `patient_type` varchar(200) NOT NULL,
  `identification_number` varchar(60) NOT NULL,
  `known_allergies` varchar(200) NOT NULL,
  `note` varchar(255) DEFAULT NULL,
  `is_ipd` varchar(200) NOT NULL,
  `app_key` varchar(200) NOT NULL,
  `organisation_id` int(11) DEFAULT NULL,
  `insurance_id` varchar(250) DEFAULT NULL,
  `insurance_validity` date DEFAULT NULL,
  `is_dead` varchar(255) NOT NULL DEFAULT 'no',
  `is_antenatal` int(11) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `disable_at` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `fingerprint_template` text DEFAULT NULL,
  `fingerprint_image` longtext DEFAULT NULL,
  `fingerprint_updated_at` datetime DEFAULT NULL,
  `fingerprint_updated_by` int(11) DEFAULT NULL,
  `workflow_status` enum('not_started','in_progress','completed','cancelled') DEFAULT 'not_started',
  `total_fee_paid` decimal(10,2) DEFAULT 0.00,
  `payment_status` enum('pending','partial','paid','refunded') DEFAULT 'pending',
  `patient_workflow` enum('gcc','general','specialized') DEFAULT 'general',
  `current_workflow_step` varchar(100) DEFAULT NULL,
  `gcc_fee_paid` decimal(10,2) DEFAULT 0.00,
  `gcc_comprehensive_fee` decimal(10,2) DEFAULT 10500.00,
  `fingerprint_verified` tinyint(1) DEFAULT 0,
  `requires_triage` tinyint(1) DEFAULT 1,
  `skip_ic10_diagnosis` tinyint(1) DEFAULT 0,
  `is_triage` enum('pending','completed','skipped','not_required') DEFAULT 'pending',
  `is_consultation` enum('pending','completed','skipped','not_required') DEFAULT 'pending',
  `is_laboratory` enum('pending','completed','skipped','not_required') DEFAULT 'pending',
  `is_radiology` enum('pending','completed','skipped','not_required') DEFAULT 'pending',
  `triage_completed_at` timestamp NULL DEFAULT NULL,
  `consultation_completed_at` timestamp NULL DEFAULT NULL,
  `laboratory_completed_at` timestamp NULL DEFAULT NULL,
  `radiology_completed_at` timestamp NULL DEFAULT NULL,
  `workflow_restrictions` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`workflow_restrictions`)),
  `last_workflow_update` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `fingerprint_quality` int(11) DEFAULT 0 COMMENT 'Fingerprint quality percentage (0-100)',
  `chief_complaint` text DEFAULT NULL,
  `patient_unique_id` varchar(100) DEFAULT NULL COMMENT 'Unique patient identifier',
  `workflow_type` varchar(50) DEFAULT 'general' COMMENT 'Patient workflow type',
  PRIMARY KEY (`id`),
  UNIQUE KEY `patient_unique_id` (`patient_unique_id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  KEY `idx_patient_name` (`patient_name`),
  KEY `idx_dob` (`dob`),
  KEY `idx_age` (`age`),
  KEY `idx_month` (`month`),
  KEY `idx_mobileno` (`mobileno`),
  KEY `idx_email` (`email`),
  KEY `idx_gender` (`gender`),
  KEY `idx_marital_status` (`marital_status`),
  KEY `idx_address` (`address`(500)),
  KEY `idx_guardian_name` (`guardian_name`),
  KEY `organisation_id` (`organisation_id`),
  KEY `patient_type_id` (`patient_type_id`),
  KEY `idx_patients_active` (`is_active`),
  KEY `idx_patients_name` (`patient_name`),
  KEY `idx_patients_blood_group` (`blood_group_id`),
  KEY `idx_patients_workflow_tracking` (`patient_workflow`,`is_triage`,`is_consultation`,`is_laboratory`,`is_radiology`),
  KEY `idx_patients_workflow_completion` (`patient_workflow`,`triage_completed_at`,`consultation_completed_at`,`laboratory_completed_at`,`radiology_completed_at`),
  KEY `idx_patient_workflow` (`patient_workflow`),
  KEY `idx_workflow_status` (`workflow_status`),
  KEY `idx_fingerprint_verified` (`fingerprint_verified`),
  KEY `idx_requires_triage` (`requires_triage`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `patients` (`id`, `patient_type_id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `blood_group_id`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`, `fingerprint_template`, `fingerprint_image`, `fingerprint_updated_at`, `fingerprint_updated_by`, `workflow_status`, `total_fee_paid`, `payment_status`, `patient_workflow`, `current_workflow_step`, `gcc_fee_paid`, `gcc_comprehensive_fee`, `fingerprint_verified`, `requires_triage`, `skip_ic10_diagnosis`, `is_triage`, `is_consultation`, `is_laboratory`, `is_radiology`, `triage_completed_at`, `consultation_completed_at`, `laboratory_completed_at`, `radiology_completed_at`, `workflow_restrictions`, `last_workflow_update`, `fingerprint_quality`, `chief_complaint`, `patient_unique_id`, `workflow_type`) VALUES (1, 2, NULL, 'JOHN KARIUKI', '0000-00-00', 32, 11, 17, '2025-07-20', 'uploads/patient_images/1.jpg', '0725243322', 'johnk@gmail.com', 'Male', NULL, 'Married', '', NULL, 'syokimau ', 'samuel ', '', '25243311', 'None', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-20 11:14:19', 'Rk1SACAyMAAAAADqAAABLAGQAMUAxQEAAABUIkCCACoVAECUAEAUAEBTAEMYAEB8AEqUAICnAFYHAEBoAGAXAICyAISQAEClAJYRAEBEAKqdAEDfAKyHAEDIAL8HAIB4AMMUAIDXAM2EAICbAOAQAEEUAPv4AECYAQsUAECkARURAECZAR+aAEAaASWhAIDJASYKAECJAS0XAEDLAS6UAIDUATIJAEEJATpsAECzAT0aAED1AT17AECoAU0VAEC1AU4aAEDQAU8KAECxAVKUAID/AV9eAEC4AWQbAEDnAWrbAEDkAW61AAAA', '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', '2025-07-20 09:13:35', NULL, '', '0.00', 'pending', 'gcc', NULL, '0.00', '10500.00', 1, 1, 1, 'pending', 'pending', 'pending', 'pending', NULL, NULL, NULL, NULL, NULL, '2025-07-20 11:14:19', 0, NULL, NULL, 'general');
INSERT INTO `patients` (`id`, `patient_type_id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `blood_group_id`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`, `fingerprint_template`, `fingerprint_image`, `fingerprint_updated_at`, `fingerprint_updated_by`, `workflow_status`, `total_fee_paid`, `payment_status`, `patient_workflow`, `current_workflow_step`, `gcc_fee_paid`, `gcc_comprehensive_fee`, `fingerprint_verified`, `requires_triage`, `skip_ic10_diagnosis`, `is_triage`, `is_consultation`, `is_laboratory`, `is_radiology`, `triage_completed_at`, `consultation_completed_at`, `laboratory_completed_at`, `radiology_completed_at`, `workflow_restrictions`, `last_workflow_update`, `fingerprint_quality`, `chief_complaint`, `patient_unique_id`, `workflow_type`) VALUES (2, 2, NULL, 'CLINTON ONDITI', '0001-00-20', 25, 5, 21, '2025-07-20', 'uploads/patient_images/2.jpg', '0714911635', 'Onditi1234@gmaiil.com', 'Male', NULL, 'Single', '', NULL, '30101-00100', '', '', '37184426', 'None', '', '', '', NULL, '', NULL, 'no', 0, 'yes', NULL, '2025-07-20 11:17:25', 'Rk1SACAyMAAAAAEIAAABLAGQAMUAxQEAAABcJ0CbABMDAEBzABkcAIC9ACD1AECiACWKAEDeACx1AECBADadAEBeAD0fAEB8AEMbAIDDAHODAEDaAH3xAECrAIMHAEEAAJ5lAIBAAKMoAEC/AKb1AEBPAL+qAED6AMDhAIDkAMXdAICcAMoaAIBCAPirAEENAQHaAIBAAQSvAEDrAQXHAIBkAQq9AIBKAQq/AICSARhDAIB3ARrUAEEXARzRAECzARw6AICjASgaAIEKASrFAECQAS1oAECNATT+AED1ATazAIBqAUTUAEC5AUiHAICMAUv4AEBYAU/NAIDvAWoYAEC+AXMNAAAA', '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', '2025-07-20 09:17:14', NULL, '', '0.00', 'pending', 'gcc', NULL, '0.00', '10500.00', 1, 1, 1, 'pending', 'pending', 'pending', 'pending', NULL, NULL, NULL, NULL, NULL, '2025-07-20 11:17:25', 0, NULL, NULL, 'general');
INSERT INTO `patients` (`id`, `patient_type_id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `blood_group_id`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`, `fingerprint_template`, `fingerprint_image`, `fingerprint_updated_at`, `fingerprint_updated_by`, `workflow_status`, `total_fee_paid`, `payment_status`, `patient_workflow`, `current_workflow_step`, `gcc_fee_paid`, `gcc_comprehensive_fee`, `fingerprint_verified`, `requires_triage`, `skip_ic10_diagnosis`, `is_triage`, `is_consultation`, `is_laboratory`, `is_radiology`, `triage_completed_at`, `consultation_completed_at`, `laboratory_completed_at`, `radiology_completed_at`, `workflow_restrictions`, `last_workflow_update`, `fingerprint_quality`, `chief_complaint`, `patient_unique_id`, `workflow_type`) VALUES (3, 2, NULL, 'clinton kebori', '2000-07-20', 25, 0, 0, '2025-07-20', NULL, '0714911635', 'onditi1234@gmail.com', 'Male', NULL, '', '', NULL, '31010-00100', '', 'General', '', '', '', 'no', '', NULL, NULL, NULL, 'no', 0, 'yes', NULL, '2025-07-20 12:21:26', NULL, NULL, NULL, NULL, 'in_progress', '0.00', 'pending', 'general', 'registration', '0.00', '10500.00', 0, 0, 0, 'not_required', 'pending', 'pending', 'pending', NULL, NULL, NULL, NULL, NULL, '2025-07-20 12:21:26', 0, NULL, NULL, 'general');
INSERT INTO `patients` (`id`, `patient_type_id`, `lang_id`, `patient_name`, `dob`, `age`, `month`, `day`, `as_of_date`, `image`, `mobileno`, `email`, `gender`, `blood_group_id`, `marital_status`, `blood_group`, `blood_bank_product_id`, `address`, `guardian_name`, `patient_type`, `identification_number`, `known_allergies`, `note`, `is_ipd`, `app_key`, `organisation_id`, `insurance_id`, `insurance_validity`, `is_dead`, `is_antenatal`, `is_active`, `disable_at`, `created_at`, `fingerprint_template`, `fingerprint_image`, `fingerprint_updated_at`, `fingerprint_updated_by`, `workflow_status`, `total_fee_paid`, `payment_status`, `patient_workflow`, `current_workflow_step`, `gcc_fee_paid`, `gcc_comprehensive_fee`, `fingerprint_verified`, `requires_triage`, `skip_ic10_diagnosis`, `is_triage`, `is_consultation`, `is_laboratory`, `is_radiology`, `triage_completed_at`, `consultation_completed_at`, `laboratory_completed_at`, `radiology_completed_at`, `workflow_restrictions`, `last_workflow_update`, `fingerprint_quality`, `chief_complaint`, `patient_unique_id`, `workflow_type`) VALUES (4, 2, NULL, 'kebori clinton', '2000-07-20', 25, 0, 0, '2025-07-20', NULL, '0714911635', 'onditi1234@gmail.com', 'Male', NULL, '', '', NULL, '30101-40200', '', 'Specialized', '', '', '', 'no', '', NULL, NULL, NULL, 'no', 0, 'yes', NULL, '2025-07-20 12:24:47', NULL, NULL, NULL, NULL, 'in_progress', '0.00', 'pending', 'specialized', 'registration', '0.00', '10500.00', 0, 1, 0, 'pending', 'pending', 'pending', 'pending', NULL, NULL, NULL, NULL, NULL, '2025-07-20 12:24:47', 0, 'KNEE FRACTURE ', NULL, 'general');


#
# TABLE STRUCTURE FOR: patients_backup
#

DROP TABLE IF EXISTS `patients_backup`;

CREATE TABLE `patients_backup` (
  `id` int(11) NOT NULL DEFAULT 0,
  `lang_id` int(11) DEFAULT NULL,
  `patient_name` varchar(100) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `age` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `day` int(11) NOT NULL,
  `as_of_date` date DEFAULT NULL,
  `image` text DEFAULT NULL,
  `mobileno` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `gender` varchar(100) DEFAULT NULL,
  `marital_status` varchar(100) NOT NULL,
  `blood_group` varchar(200) NOT NULL,
  `blood_bank_product_id` int(11) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `guardian_name` varchar(100) DEFAULT NULL,
  `patient_type` varchar(200) NOT NULL,
  `identification_number` varchar(60) NOT NULL,
  `known_allergies` varchar(200) NOT NULL,
  `note` varchar(200) NOT NULL,
  `is_ipd` varchar(200) NOT NULL,
  `app_key` varchar(200) NOT NULL,
  `organisation_id` int(11) DEFAULT NULL,
  `insurance_id` varchar(250) DEFAULT NULL,
  `insurance_validity` date DEFAULT NULL,
  `is_dead` varchar(255) NOT NULL DEFAULT 'no',
  `is_antenatal` int(11) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `disable_at` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `fingerprint_template` text DEFAULT NULL,
  `fingerprint_image` longtext DEFAULT NULL,
  `fingerprint_updated_at` datetime DEFAULT NULL,
  `fingerprint_updated_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: patients_vitals
#

DROP TABLE IF EXISTS `patients_vitals`;

CREATE TABLE `patients_vitals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `vital_id` int(11) NOT NULL,
  `reference_range` varchar(100) NOT NULL,
  `messure_date` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `index_reference_range` (`reference_range`),
  KEY `index_messure_date` (`messure_date`),
  KEY `vital_id` (`vital_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `patients_vitals` (`id`, `patient_id`, `vital_id`, `reference_range`, `messure_date`, `created_at`) VALUES (1, 56, 1, '170', '2025-07-04 06:45:00', '2025-07-04 05:46:20');
INSERT INTO `patients_vitals` (`id`, `patient_id`, `vital_id`, `reference_range`, `messure_date`, `created_at`) VALUES (2, 56, 2, '78', '2025-07-04 06:45:00', '2025-07-04 05:46:20');
INSERT INTO `patients_vitals` (`id`, `patient_id`, `vital_id`, `reference_range`, `messure_date`, `created_at`) VALUES (3, 56, 3, '72', '2025-07-04 06:46:00', '2025-07-04 05:46:20');
INSERT INTO `patients_vitals` (`id`, `patient_id`, `vital_id`, `reference_range`, `messure_date`, `created_at`) VALUES (4, 56, 5, '100/80', '2025-07-04 06:46:00', '2025-07-04 05:46:20');


#
# TABLE STRUCTURE FOR: payment_schedule
#

DROP TABLE IF EXISTS `payment_schedule`;

CREATE TABLE `payment_schedule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `scheduled_date` date NOT NULL,
  `payment_method` enum('cash','cheque','bank_transfer','eft','online') NOT NULL DEFAULT 'bank_transfer',
  `notes` text DEFAULT NULL,
  `status` enum('scheduled','processing','completed','cancelled','failed') DEFAULT 'scheduled',
  `actual_payment_date` datetime DEFAULT NULL,
  `reference_number` varchar(100) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `approved_date` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_supplier_id` (`supplier_id`),
  KEY `idx_scheduled_date` (`scheduled_date`),
  KEY `idx_status` (`status`),
  KEY `fk_payment_schedule_created_by` (`created_by`),
  KEY `idx_payment_schedule_date_status` (`scheduled_date`,`status`),
  KEY `idx_payment_schedule_supplier_status` (`supplier_id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: payment_settings
#

DROP TABLE IF EXISTS `payment_settings`;

CREATE TABLE `payment_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_type` varchar(200) NOT NULL,
  `api_username` varchar(200) DEFAULT NULL,
  `api_secret_key` varchar(200) NOT NULL,
  `salt` varchar(200) NOT NULL,
  `api_publishable_key` varchar(200) NOT NULL,
  `paytm_website` varchar(255) NOT NULL,
  `paytm_industrytype` varchar(255) NOT NULL,
  `api_password` varchar(200) DEFAULT NULL,
  `api_signature` varchar(200) DEFAULT NULL,
  `api_email` varchar(200) DEFAULT NULL,
  `paypal_demo` varchar(100) NOT NULL,
  `account_no` varchar(200) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_payment_type` (`payment_type`),
  KEY `index_api_username` (`api_username`),
  KEY `index_api_secret_key` (`api_secret_key`),
  KEY `index_salt` (`salt`),
  KEY `index_api_publishable_key` (`api_publishable_key`),
  KEY `index_paytm_website` (`paytm_website`),
  KEY `index_paytm_industrytype` (`paytm_industrytype`),
  KEY `index_api_password` (`api_password`),
  KEY `index_api_signature` (`api_signature`),
  KEY `index_api_email` (`api_email`),
  KEY `index_paypal_demo` (`paypal_demo`),
  KEY `index_account_no` (`account_no`),
  KEY `index_is_active` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: payment_transactions
#

DROP TABLE IF EXISTS `payment_transactions`;

CREATE TABLE `payment_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transaction_no` varchar(50) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `order_id` int(11) DEFAULT NULL COMMENT 'Radiology/Lab order ID',
  `order_type` enum('radiology','laboratory','consultation','pharmacy','other') NOT NULL,
  `payment_method` enum('cash','card','mobile_money','bank_transfer','insurance','other') NOT NULL,
  `payment_reference` varchar(100) DEFAULT NULL COMMENT 'External payment reference',
  `amount` decimal(10,2) NOT NULL,
  `currency` varchar(3) DEFAULT 'KES',
  `exchange_rate` decimal(10,4) DEFAULT 1.0000,
  `status` enum('pending','completed','failed','cancelled','refunded') DEFAULT 'pending',
  `processed_at` datetime DEFAULT NULL,
  `processed_by` int(11) DEFAULT NULL,
  `journal_id` int(11) DEFAULT NULL COMMENT 'Link to accounting journal',
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_transaction_no` (`transaction_no`),
  KEY `idx_patient_id` (`patient_id`),
  KEY `idx_order_id_type` (`order_id`,`order_type`),
  KEY `idx_payment_method` (`payment_method`),
  KEY `idx_status` (`status`),
  KEY `idx_processed_at` (`processed_at`),
  KEY `idx_journal_id` (`journal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: payslip_allowance
#

DROP TABLE IF EXISTS `payslip_allowance`;

CREATE TABLE `payslip_allowance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_payslip_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `allowance_type` varchar(200) NOT NULL,
  `amount` float NOT NULL,
  `cal_type` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `staff_payslip_id` (`staff_payslip_id`),
  KEY `index_allowance_type` (`allowance_type`),
  KEY `index_amount` (`amount`),
  KEY `index_cal_type` (`cal_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: permission_category
#

DROP TABLE IF EXISTS `permission_category`;

CREATE TABLE `permission_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `perm_group_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `short_code` varchar(100) DEFAULT NULL,
  `enable_view` int(11) DEFAULT 0,
  `enable_add` int(11) DEFAULT 0,
  `enable_edit` int(11) DEFAULT 0,
  `enable_delete` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=422 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (9, 3, 'Income', 'income', 1, 1, 1, 1, '2018-06-22 01:23:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (10, 3, 'Income Head', 'income_head', 1, 1, 1, 1, '2018-06-22 01:22:44');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (12, 4, 'Expense', 'expense', 1, 1, 1, 1, '2018-06-22 01:24:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (13, 4, 'Expense Head', 'expense_head', 1, 1, 1, 1, '2018-06-22 01:23:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (27, 8, 'Content Type', 'content_type', 1, 1, 1, 1, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (31, 10, 'Issue Item', 'issue_item', 1, 1, 0, 1, '2018-12-17 00:55:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (32, 10, 'Item Stock', 'item_stock', 1, 1, 1, 1, '2018-06-22 01:35:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (33, 10, 'Item', 'item', 1, 1, 1, 1, '2018-06-22 01:35:40');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (34, 10, 'Store', 'store', 1, 1, 1, 1, '2018-06-22 01:36:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (35, 10, 'Supplier', 'supplier', 1, 1, 1, 1, '2018-06-22 01:36:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (43, 13, 'Notice Board', 'notice_board', 1, 1, 1, 1, '2018-06-22 01:41:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (44, 13, 'Email / SMS', 'email_sms', 1, 0, 0, 0, '2018-06-22 01:40:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (48, 14, 'OPD Report', 'opd_report', 1, 0, 0, 0, '2018-12-17 23:59:18');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (53, 15, 'Languages', 'languages', 1, 1, 0, 0, '2021-09-13 00:56:36');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (54, 15, 'General Setting', 'general_setting', 1, 0, 1, 0, '2018-07-05 00:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (56, 15, 'Notification Setting', 'notification_setting', 1, 0, 1, 0, '2018-07-05 00:08:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (57, 15, 'SMS Setting', 'sms_setting', 1, 0, 1, 0, '2018-07-05 00:08:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (58, 15, 'Email Setting', 'email_setting', 1, 0, 1, 0, '2018-07-05 00:08:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (59, 15, 'Front CMS Setting', 'front_cms_setting', 1, 0, 1, 0, '2018-07-05 00:08:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (60, 15, 'Payment Methods', 'payment_methods', 1, 0, 1, 0, '2018-07-05 00:08:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (61, 16, 'Menus', 'menus', 1, 1, 0, 1, '2018-07-08 18:50:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (62, 16, 'Media Manager', 'media_manager', 1, 1, 0, 1, '2018-07-08 18:50:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (63, 16, 'Banner Images', 'banner_images', 1, 1, 0, 1, '2018-06-22 01:46:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (64, 16, 'Pages', 'pages', 1, 1, 1, 1, '2018-06-22 01:46:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (65, 16, 'Gallery', 'gallery', 1, 1, 1, 1, '2018-06-22 01:47:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (66, 16, 'Event', 'event', 1, 1, 1, 1, '2018-06-22 01:47:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (67, 16, 'News', 'notice', 1, 1, 1, 1, '2018-07-02 23:39:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (80, 17, 'Visitor Book', 'visitor_book', 1, 1, 1, 1, '2018-06-22 01:48:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (81, 17, 'Phone Call Log', 'phone_call_log', 1, 1, 1, 1, '2018-06-22 01:50:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (82, 17, 'Postal Dispatch', 'postal_dispatch', 1, 1, 1, 1, '2018-06-22 01:50:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (83, 17, 'Postal Receive', 'postal_receive', 1, 1, 1, 1, '2018-06-22 01:50:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (84, 17, 'Complain', 'complain', 1, 1, 1, 1, '2018-12-19 00:11:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (85, 17, 'Setup Front Office', 'setup_front_office', 1, 1, 1, 1, '2018-11-14 15:49:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (86, 18, 'Staff', 'staff', 1, 1, 1, 1, '2018-06-22 01:53:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (87, 18, 'Disable Staff', 'disable_staff', 1, 0, 0, 0, '2018-06-22 01:53:12');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (88, 18, 'Staff Attendance', 'staff_attendance', 1, 1, 1, 0, '2018-06-22 01:53:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (89, 14, 'Staff Attendance Report', 'staff_attendance_report', 1, 0, 0, 0, '2021-09-13 04:12:50');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (90, 18, 'Staff Payroll', 'staff_payroll', 1, 1, 1, 1, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (91, 14, 'Payroll Report', 'payroll_report', 1, 0, 0, 0, '2021-09-13 04:13:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (102, 21, 'Calendar To Do List', 'calendar_to_do_list', 1, 1, 1, 1, '2018-06-22 01:54:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (104, 10, 'Item Category', 'item_category', 1, 1, 1, 1, '2018-06-22 01:34:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (108, 18, ' Approve Leave Request', 'approve_leave_request', 1, 1, 1, 1, '2018-07-02 01:17:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (109, 18, 'Apply Leave', 'apply_leave', 1, 1, 0, 1, '2020-08-24 16:48:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (110, 18, 'LeaveTypes', 'leave_types', 1, 1, 1, 1, '2021-10-26 13:54:30');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (111, 18, 'Department', 'department', 1, 1, 1, 1, '2018-06-25 18:57:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (112, 18, 'Designation', 'designation', 1, 1, 1, 1, '2018-06-25 18:57:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (118, 22, 'Staff Role Count Widget', 'staff_role_count_widget', 1, 0, 0, 0, '2018-07-02 22:13:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (126, 15, 'Users', 'users', 1, 0, 0, 0, '2021-09-21 21:43:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (127, 18, 'Can See Other Users Profile', 'can_see_other_users_profile', 1, 0, 0, 0, '2018-07-02 23:42:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (129, 18, 'Staff Timeline', 'staff_timeline', 0, 1, 0, 1, '2018-07-04 23:08:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (130, 15, 'Backup', 'backup', 1, 1, 0, 1, '2018-07-08 19:17:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (131, 15, 'Restore', 'restore', 1, 0, 0, 0, '2018-07-08 19:17:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (132, 23, 'OPD Patient', 'opd_patient', 1, 1, 1, 1, '2018-12-20 00:37:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (134, 23, 'Prescription', 'prescription', 1, 1, 1, 1, '2018-10-10 16:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (135, 23, 'Visit', 'visit', 1, 1, 1, 1, '2021-09-16 22:39:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (137, 23, 'OPD Timeline', 'opd_timeline', 1, 1, 1, 1, '2021-02-24 03:02:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (138, 24, 'IPD Patients', 'ipd_patient', 1, 1, 1, 1, '2018-10-10 22:14:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (139, 24, 'Discharged Patients', 'discharged_patients', 1, 1, 1, 1, '2021-02-24 03:27:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (140, 24, 'Consultant Register', 'consultant_register', 1, 1, 1, 1, '2021-02-24 03:37:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (142, 24, 'IPD Timeline', 'ipd_timeline', 1, 1, 1, 1, '2021-02-25 03:30:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (143, 24, 'Charges', 'charges', 1, 1, 1, 1, '2018-10-10 16:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (144, 24, 'Payment', 'payment', 1, 1, 1, 1, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (146, 25, 'Medicine', 'medicine', 1, 1, 1, 1, '2018-10-10 16:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (148, 25, 'Pharmacy Bill', 'pharmacy_bill', 1, 1, 1, 1, '2021-02-25 03:33:40');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (149, 26, 'Pathology Test', 'pathology_test', 1, 1, 1, 1, '2021-02-25 03:36:32');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (152, 27, 'Radiology Test', 'radiology_test', 1, 1, 1, 1, '2021-02-25 03:45:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (153, 27, 'Radiology  Bill', 'radiology_bill', 1, 1, 1, 1, '2021-09-16 20:16:48');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (155, 22, 'IPD Income Widget', 'ipd_income_widget', 1, 0, 0, 0, '2018-12-20 00:08:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (156, 22, 'OPD Income Widget', 'opd_income_widget', 1, 0, 0, 0, '2018-12-20 00:08:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (157, 22, 'Pharmacy Income Widget', 'pharmacy_income_widget', 1, 0, 0, 0, '2018-12-20 00:08:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (158, 22, 'Pathology Income Widget', 'pathology_income_widget', 1, 0, 0, 0, '2018-12-20 00:08:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (159, 22, 'Radiology Income Widget', 'radiology_income_widget', 1, 0, 0, 0, '2018-12-20 00:08:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (161, 22, 'Blood Bank Income Widget', 'blood_bank_income_widget', 1, 0, 0, 0, '2018-12-20 00:09:13');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (162, 22, 'Ambulance Income Widget', 'ambulance_income_widget', 1, 0, 0, 0, '2018-12-20 00:09:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (165, 29, 'Ambulance Call', 'ambulance_call', 1, 1, 1, 1, '2018-10-26 18:37:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (166, 29, 'Ambulance', 'ambulance', 1, 1, 1, 1, '2018-10-26 18:37:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (168, 30, 'Blood Issue', 'blood_issue', 1, 1, 1, 1, '2018-10-26 19:20:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (169, 30, 'Blood Donor', 'blood_donor', 1, 1, 1, 1, '2018-10-26 19:20:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (170, 25, 'Medicine Category', 'medicine_category', 1, 1, 1, 1, '2018-10-24 21:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (171, 27, 'Radiology Category', 'radiology_category', 1, 1, 1, 1, '2021-02-25 03:52:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (173, 31, 'Organisation', 'organisation', 1, 1, 1, 1, '2018-10-24 21:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (175, 26, 'Pathology Category', 'pathology_category', 1, 1, 1, 1, '2018-10-24 21:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (176, 32, 'Hospital Charges', 'hospital_charges', 1, 1, 1, 1, '2021-09-12 22:29:30');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (178, 14, 'IPD Report', 'ipd_report', 1, 0, 0, 0, '2018-12-12 01:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (179, 14, 'Pharmacy Bill Report', 'pharmacy_bill_report', 1, 0, 0, 0, '2018-12-12 01:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (180, 14, 'Pathology Patient Report', 'pathology_patient_report', 1, 0, 0, 0, '2018-12-12 01:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (181, 14, 'Radiology Patient Report', 'radiology_patient_report', 1, 0, 0, 0, '2018-12-12 01:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (182, 14, 'OT Report', 'ot_report', 1, 0, 0, 0, '2019-03-07 21:56:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (183, 14, 'Blood Donor Report', 'blood_donor_report', 1, 0, 0, 0, '2019-03-07 21:56:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (184, 14, 'Payroll Month Report', 'payroll_month_report', 1, 0, 0, 0, '2019-03-07 21:57:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (185, 14, 'Payroll Report', 'payroll_report', 1, 0, 0, 0, '2019-03-07 21:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (187, 14, 'User Log', 'user_log', 1, 0, 0, 0, '2018-12-12 01:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (188, 14, 'Patient Login Credential', 'patient_login_credential', 1, 0, 0, 0, '2018-12-12 01:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (189, 14, 'Email / SMS Log', 'email_sms_log', 1, 0, 0, 0, '2018-12-12 01:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (190, 22, 'Yearly Income & Expense Chart', 'yearly_income_expense_chart', 1, 0, 0, 0, '2018-12-12 01:22:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (191, 22, 'Monthly Income & Expense Chart', 'monthly_income_expense_chart', 1, 0, 0, 0, '2018-12-12 01:25:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (192, 23, 'OPD Prescription Print Header Footer ', 'opd_prescription_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (196, 24, 'Bed', 'bed', 1, 1, 1, 1, '2018-12-12 01:46:01');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (197, 24, 'IPD Prescription Print Header Footer', 'ipd_prescription_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (198, 24, 'Bed Status', 'bed_status', 1, 0, 0, 0, '2018-12-12 01:39:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (200, 25, 'Medicine Bad Stock', 'medicine_bad_stock', 1, 1, 0, 1, '2018-12-17 16:12:46');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (201, 25, 'Pharmacy Bill print Header Footer', 'pharmacy_bill_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (202, 30, 'Blood Stock', 'blood_stock', 1, 1, 0, 1, '2021-09-11 00:49:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (203, 32, 'Charge Category', 'charge_category', 1, 1, 1, 1, '2018-12-12 02:19:38');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (206, 14, 'TPA Report', 'tpa_report', 1, 0, 0, 0, '2019-03-07 21:49:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (207, 14, 'Ambulance Report', 'ambulance_report', 1, 0, 0, 0, '2019-03-07 21:49:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (208, 14, 'Discharge Patient Report', 'discharge_patient_report', 1, 0, 0, 0, '2019-03-07 21:49:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (209, 14, 'Appointment Report', 'appointment_report', 1, 0, 0, 0, '2019-03-07 21:50:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (210, 14, 'Transaction Report', 'transaction_report', 1, 0, 0, 0, '2019-03-07 21:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (211, 14, 'Blood Issue Report', 'blood_issue_report', 1, 0, 0, 0, '2019-03-07 21:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (212, 14, 'Income Report', 'income_report', 1, 0, 0, 0, '2019-03-07 21:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (213, 14, 'Expense Report', 'expense_report', 1, 0, 0, 0, '2019-03-07 21:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (214, 34, 'Birth Record', 'birth_record', 1, 1, 1, 1, '2018-06-22 01:36:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (215, 34, 'Death Record', 'death_record', 1, 1, 1, 1, '2018-06-22 01:36:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (218, 23, 'Move Patient in IPD', 'opd_move_patient_in_ipd', 1, 0, 0, 0, '2021-09-16 23:00:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (219, 23, 'Manual Prescription', 'manual_prescription', 1, 0, 0, 0, '2019-09-22 19:52:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (220, 24, 'Prescription ', 'ipd_prescription', 1, 1, 1, 1, '2019-09-23 15:59:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (221, 23, 'Charges', 'opd_charges', 1, 1, 1, 1, '2019-09-22 19:58:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (222, 23, 'Payment', 'opd_payment', 1, 1, 1, 1, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (224, 25, 'Import Medicine', 'import_medicine', 1, 0, 0, 0, '2019-09-22 20:03:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (225, 25, 'Medicine Purchase', 'medicine_purchase', 1, 1, 0, 1, '2021-10-02 06:59:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (226, 25, 'Medicine Supplier', 'medicine_supplier', 1, 1, 1, 1, '2019-09-22 20:09:36');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (227, 25, 'Medicine Dosage', 'medicine_dosage', 1, 1, 1, 1, '2019-09-22 20:17:16');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (236, 36, 'Patient', 'patient', 1, 1, 1, 1, '2021-09-21 23:29:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (237, 36, 'Enabled/Disabled', 'enabled_disabled', 1, 0, 0, 0, '2019-09-22 21:25:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (238, 22, 'Notification Center', 'notification_center', 1, 0, 0, 0, '2019-09-23 18:48:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (239, 36, 'Import', 'patient_import', 1, 0, 0, 0, '2019-10-03 16:20:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (240, 34, 'Birth Print Header Footer', 'birth_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (242, 34, 'Death Print Header Footer', 'death_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (243, 26, 'Print Header Footer', 'pathology_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (244, 27, 'Print Header Footer', 'radiology_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (246, 30, 'Print Header Footer', 'bloodbank_print_header_footer', 1, 0, 0, 0, '2021-10-07 06:06:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (247, 29, 'Print Header Footer', 'ambulance_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (248, 24, 'IPD Bill Print Header Footer', 'ipd_bill_print_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (249, 18, 'Print Payslip Header Footer', 'print_payslip_header_footer', 1, 0, 0, 0, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (250, 14, 'Income Group Report', 'income_group_report', 1, 0, 0, 0, '2020-08-11 20:52:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (251, 14, 'Expense Group Report', 'expense_group_report', 1, 0, 0, 0, '2019-10-03 19:15:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (253, 14, 'Inventory Stock Report', 'inventory_stock_report', 1, 0, 0, 0, '2019-10-03 20:20:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (254, 14, 'Inventory Item Report', 'add_item_report', 1, 0, 0, 0, '2019-10-03 20:23:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (255, 14, 'Inventory Issue Report', 'issue_inventory_report', 1, 0, 0, 0, '2019-10-03 20:24:40');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (256, 14, 'Expiry Medicine Report', 'expiry_medicine_report', 1, 0, 0, 0, '2019-10-03 21:00:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (257, 26, 'Pathology Bill', 'pathology_bill', 1, 1, 1, 1, '2021-02-25 03:58:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (258, 14, 'Birth Report', 'birth_report', 1, 0, 0, 0, '2019-10-13 18:12:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (259, 14, 'Death Report', 'death_report', 1, 0, 0, 0, '2019-10-13 18:13:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (260, 26, 'Pathology Unit', 'pathology_unit', 1, 1, 1, 1, '2020-07-21 16:13:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (261, 27, 'Radiology Unit', 'radiology_unit', 1, 1, 1, 1, '2020-07-21 16:14:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (262, 27, 'Radiology Parameter', 'radiology_parameter', 1, 1, 1, 1, '2020-07-21 16:20:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (263, 26, 'Pathology Parameter', 'pathology_parameter', 1, 1, 1, 1, '2020-07-21 16:20:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (264, 32, 'Charge Type', 'charge_type', 1, 1, 1, 1, '2024-08-21 11:29:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (265, 14, 'OPD Balance Report', 'opd_balance_report', 1, 0, 0, 0, '2020-07-27 17:03:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (266, 14, 'IPD Balance Report', 'ipd_balance_report', 1, 0, 0, 0, '2020-07-27 17:03:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (267, 15, 'Symptoms Type', 'symptoms_type', 1, 1, 1, 1, '2021-09-13 23:36:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (269, 37, 'Live Consultation', 'live_consultation', 1, 1, 0, 1, '2020-08-12 21:19:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (270, 37, 'Live Meeting', 'live_meeting', 1, 1, 0, 1, '2020-08-12 21:19:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (271, 14, 'Live Consultation Report', 'live_consultation_report', 1, 0, 0, 0, '2021-09-13 04:11:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (272, 14, 'Live Meeting Report', 'live_meeting_report', 1, 0, 0, 0, '2021-09-13 04:11:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (273, 37, 'Setting', 'setting', 1, 0, 1, 0, '2020-08-12 22:03:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (274, 15, 'Language Switcher', 'language_switcher', 1, 0, 0, 0, '2020-08-20 19:48:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (279, 15, 'Symptoms Head', 'symptoms_head', 1, 1, 1, 1, '2021-09-13 23:36:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (280, 18, 'Specialist', 'specialist', 1, 1, 1, 1, '2019-10-03 12:01:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (281, 22, 'General Income Widget', 'general_income_widget', 1, 0, 0, 0, '2018-12-19 18:38:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (282, 22, 'Expenses Widget', 'expenses_widget', 1, 0, 0, 0, '2018-12-19 18:38:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (283, 38, 'Referral Category', 'referral_category', 1, 1, 1, 1, '2021-06-11 04:54:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (284, 38, 'Referral Commission', 'referral_commission', 1, 1, 1, 1, '2021-06-11 04:54:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (285, 38, 'Referral Person', 'referral_person', 1, 1, 1, 1, '2021-06-11 04:55:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (286, 38, 'Referral Payment', 'referral_payment', 1, 1, 1, 1, '2021-06-11 04:55:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (287, 15, 'Prefix Setting', 'prefix_setting', 1, 0, 1, 0, '2021-06-11 22:46:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (288, 15, 'Captcha Setting', 'captcha_setting', 1, 0, 1, 0, '2021-06-11 23:43:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (289, 32, 'Tax Category', 'tax_category', 1, 1, 1, 1, '2021-06-12 00:16:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (290, 32, 'Unit Type', 'unit_type', 1, 1, 1, 1, '2021-06-12 00:16:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (291, 25, 'Dosage Interval', 'dosage_interval', 1, 1, 1, 1, '2021-06-12 02:15:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (292, 25, 'Dosage Duration', 'dosage_duration', 1, 1, 1, 1, '2021-06-12 02:15:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (293, 30, 'Blood Bank Product', 'blood_bank_product', 1, 1, 1, 1, '2021-06-12 02:51:23');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (294, 39, 'Slot', 'online_appointment_slot', 1, 1, 1, 1, '2021-09-14 03:04:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (295, 39, 'Doctor Shift', 'online_appointment_doctor_shift', 1, 0, 1, 0, '2021-06-12 03:43:48');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (296, 39, 'Shift', 'online_appointment_shift', 1, 1, 1, 1, '2021-06-12 03:24:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (297, 39, 'Doctor Wise Appointment', 'doctor_wise_appointment', 1, 0, 0, 0, '2021-10-07 03:45:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (298, 39, 'Patient Queue', 'patient_queue', 1, 0, 0, 0, '2021-10-07 03:45:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (299, 23, 'OPD Medication', 'opd_medication', 1, 1, 1, 1, '2021-06-14 22:00:12');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (300, 24, 'IPD Medication', 'ipd_medication', 1, 1, 1, 1, '2021-06-14 22:00:12');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (301, 24, 'Bed History', 'bed_history', 1, 0, 0, 0, '2021-06-14 22:00:12');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (302, 30, 'Blood Bank Components', 'blood_bank_components', 1, 1, 0, 1, '2021-06-15 02:46:48');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (303, 23, 'Operation Theatre', 'opd_operation_theatre', 1, 1, 1, 1, '2021-09-08 00:49:13');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (304, 23, 'Lab Investigation', 'opd_lab_investigation', 1, 0, 0, 0, '2021-09-06 21:36:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (305, 23, 'Patient Discharge', 'opd_patient_discharge', 1, 0, 1, 0, '2021-09-06 21:39:16');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (306, 23, 'Patient Discharge Revert', 'opd_patient_discharge_revert', 1, 0, 0, 0, '2021-09-06 21:39:38');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (307, 23, 'Treatment History', 'opd_treatment_history', 1, 0, 0, 0, '2021-09-06 21:49:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (308, 24, 'Lab Investigation', 'ipd_lab_investigation', 1, 0, 0, 0, '2021-09-06 22:45:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (309, 24, 'Patient Discharge', 'ipd_patient_discharge', 1, 0, 1, 0, '2021-09-07 00:08:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (310, 24, 'Patient Discharge Revert', 'ipd_patient_discharge_revert', 1, 0, 0, 0, '2021-09-07 00:14:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (311, 30, 'Issue Component', 'issue_component', 1, 1, 1, 1, '2021-09-07 00:21:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (312, 26, '	Add/Edit Collection Person', 'pathology_add_edit_collection_person', 1, 0, 1, 0, '2021-09-16 22:06:13');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (313, 25, 'Partial Payment', 'pharmacy_partial_payment', 1, 1, 0, 1, '2021-09-07 03:10:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (314, 26, 'Partial Payment', 'pathology_partial_payment', 1, 1, 0, 1, '2021-09-07 04:34:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (315, 27, 'Partial Payment', 'radiology_partial_payment', 1, 1, 0, 1, '2021-09-07 04:38:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (316, 28, 'Partial Payment', 'radiology_partial_payment', 1, 1, 0, 1, '2021-09-07 04:39:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (317, 30, 'Partial Payment', 'blood_bank_partial_payment', 1, 1, 0, 1, '2021-09-07 04:47:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (318, 29, 'Partial Payment', 'ambulance_partial_payment', 1, 1, 0, 1, '2021-09-07 04:48:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (319, 23, 'Checkup', 'checkup', 1, 1, 1, 1, '2021-09-16 22:40:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (320, 23, 'Print Bill', 'opd_print_bill', 1, 0, 0, 0, '2021-09-08 01:09:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (321, 23, 'Live Consult', 'opd_live_consult', 1, 0, 0, 0, '2021-09-08 02:53:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (322, 24, 'Nurse Note', 'nurse_note', 1, 1, 1, 1, '2021-09-08 03:20:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (323, 24, 'Bed Type', 'bed_type', 1, 1, 1, 1, '2021-09-08 22:06:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (324, 24, 'Bed Group', 'bed_group', 1, 1, 1, 1, '2021-09-08 22:07:08');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (325, 24, 'Floor', 'floor', 1, 1, 1, 1, '2021-09-08 22:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (326, 24, 'Operation Theatre', 'ipd_operation_theatre', 1, 1, 1, 1, '2021-09-09 00:38:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (327, 24, 'Live Consult', 'ipd_live_consultation', 1, 0, 0, 0, '2021-09-09 01:05:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (329, 24, 'Treatment History', 'ipd_treatment_history', 1, 0, 0, 0, '2021-09-06 22:45:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (330, 41, 'OPD Billing', 'opd_billing', 1, 0, 0, 0, '2021-09-09 02:33:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (331, 41, 'OPD Billing Payment', 'opd_billing_payment', 1, 1, 0, 0, '2021-09-09 03:10:36');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (332, 41, 'IPD Billing', 'ipd_billing', 1, 0, 0, 0, '2021-09-09 02:52:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (333, 41, 'IPD Billing Payment', 'ipd_billing_payment', 1, 1, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (334, 41, 'Pharmacy Billing', 'pharmacy_billing', 1, 0, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (335, 41, 'Pharmacy Billing Payment', 'pharmacy_billing_payment', 1, 1, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (336, 41, 'Pathology Billing', 'pathology_billing', 1, 0, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (337, 41, 'Pathology Billing Payment', 'pathology_billing_payment', 1, 1, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (338, 41, 'Radiology Billing', 'radiology_billing', 1, 0, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (339, 41, 'Radiology Billing Payment', 'radiology_billing_payment', 1, 1, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (340, 41, 'Blood Bank Billing', 'blood_bank_billing', 1, 0, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (341, 41, 'Blood Bank Billing Payment', 'blood_bank_billing_payment', 1, 1, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (342, 41, 'Ambulance Billing', 'ambulance_billing', 1, 0, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (343, 41, 'Ambulance Billing Payment', 'ambulance_billing_payment', 1, 1, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (344, 41, 'Generate Bill', 'generate_bill', 1, 0, 0, 0, '2021-09-09 22:36:09');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (345, 41, 'Generate Discharge Card', 'generate_discharge_card', 1, 0, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (346, 40, 'Online Appointment', 'online_appointment', 1, 0, 0, 0, '2021-09-09 04:15:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (347, 31, 'TPA Charges ', 'tpa_charges', 1, 0, 1, 1, '2018-10-24 21:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (348, 15, 'System Notification Setting', 'system_notification_setting', 1, 0, 1, 0, '2018-07-05 00:08:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (349, 14, 'All Transaction Report', 'all_transaction_report', 1, 0, 0, 0, '2021-09-13 04:29:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (350, 14, 'Patient Visit Report', 'patient_visit_report', 1, 0, 0, 0, '2019-10-03 20:23:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (351, 14, 'Patient Bill Report', 'patient_bill_report', 1, 0, 0, 0, '2019-10-03 19:15:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (352, 14, 'Referral Report', 'referral_report', 1, 0, 0, 0, '2019-10-03 19:15:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (353, 27, 'Add/Edit Collection Person', 'radiology_add_edit_collection_person', 1, 0, 1, 0, '2021-09-16 22:06:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (354, 27, 'Add/Edit  Report', 'radiology_add_edit_report', 1, 0, 1, 0, '2021-09-16 22:06:50');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (355, 26, 'Add/Edit Report', 'pathology_add_edit_report', 1, 0, 1, 0, '2021-09-16 22:06:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (362, 42, 'Generate Certificate', 'generate_certificate', 1, 0, 0, 0, '2021-09-20 18:48:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (363, 42, 'Certificate', 'certificate', 1, 1, 1, 1, '2021-09-20 18:48:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (364, 42, 'Generate Staff ID Card', 'generate_staff_id_card', 1, 0, 0, 0, '2021-09-20 18:56:38');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (365, 42, 'Staff ID Card', 'staff_id_card', 1, 1, 1, 1, '2021-09-20 18:56:09');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (366, 42, 'Generate Patient ID Card', 'generate_patient_id_card', 1, 0, 0, 0, '2021-09-21 01:13:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (367, 42, 'Patient ID Card', 'patient_id_card', 1, 1, 1, 1, '2021-09-20 18:54:38');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (369, 14, 'Component Issue Report', 'component_issue_report', 1, 0, 0, 0, '2019-03-07 21:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (370, 14, 'Audit Trail Report', 'audit_trail_report', 1, 0, 0, 0, '2021-09-28 03:08:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (371, 43, 'Chat', 'chat', 1, 0, 0, 0, '2021-10-07 07:05:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (372, 15, 'Custom Fields', 'custom_fields', 1, 0, 0, 0, '2021-10-29 09:41:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (373, 14, 'Daily Transaction Report', 'daily_transaction_report', 1, 0, 0, 0, '2021-10-29 09:42:08');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (374, 15, 'Operation', 'operation', 1, 1, 1, 1, '2021-10-29 09:45:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (375, 15, 'Operation Category', 'operation_category', 1, 1, 1, 1, '2021-10-29 09:45:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (386, 39, 'Appointment', 'appointment', 1, 1, 0, 1, '2021-12-24 11:36:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (387, 39, 'Reschedule', 'reschedule', 1, 0, 0, 0, '2021-12-24 11:36:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (388, 15, 'Finding', 'finding', 1, 1, 1, 1, '2021-10-29 09:45:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (389, 15, 'Finding Category', 'finding_category', 1, 1, 1, 1, '2021-10-29 09:45:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (390, 41, 'Appointment Billing', 'appointment_billing', 1, 0, 0, 0, '2021-09-09 02:53:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (391, 15, 'Vital', 'vital', 1, 1, 1, 1, '2021-10-29 09:45:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (392, 23, 'OPD Vitals', 'opd_vitals', 1, 1, 1, 1, '2018-12-20 00:37:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (393, 24, 'IPD Vitals', 'ipd_vitals', 1, 1, 1, 1, '2021-02-25 03:30:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (394, 24, 'Previous Obstetric History', 'ipd_previous_obstetric_history', 1, 1, 1, 1, '2021-02-25 03:30:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (395, 24, 'Postnatal History', 'ipd_postnatal_history', 1, 1, 1, 1, '2021-02-25 03:30:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (396, 24, 'Antenatal', 'ipd_antenatal', 1, 1, 1, 1, '2021-02-25 03:30:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (397, 39, 'Print Appointment Header Footer', 'print_appointment_header_footer', 1, 0, 0, 0, '2024-02-29 11:05:48');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (398, 23, 'Antenatal', 'opd_antenatal', 1, 1, 1, 1, '2024-03-11 13:24:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (399, 41, 'Payment Receipt Header Footer', 'payment_receipt_header_footer', 1, 0, 0, 0, '2024-02-29 12:44:39');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (400, 13, 'Send Credential', 'send_credential', 1, 0, 0, 0, '2024-02-29 12:44:43');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (401, 24, 'IPD Antenatal Finding Print Header Footer', 'ipd_antenatal_finding_print_header_footer', 1, 0, 0, 0, '2024-02-29 12:44:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (402, 23, 'OPD Antenatal Finding Print Header Footer ', 'opd_antenatal_finding_print_header_footer', 1, 0, 0, 0, '2024-02-29 12:44:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (403, 24, 'Discharge Summary Print Header Footer', 'discharge_summary_print_header_footer', 1, 0, 0, 0, '2024-02-29 12:44:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (404, 24, 'IPD Obstetric History Print Header Footer', 'ipd_obstetric_history_print_header_footer', 1, 0, 0, 0, '2024-02-29 12:44:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (405, 39, 'Appointment Priority', 'appointment_priority', 1, 1, 1, 1, '2021-06-12 03:24:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (406, 25, 'Unit', 'medicine_unit', 1, 1, 1, 1, '2018-10-24 21:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (407, 25, 'Company', 'medicine_company', 1, 1, 1, 1, '2018-10-24 21:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (408, 25, 'Medicine Group', 'medicine_group', 1, 1, 1, 1, '2018-10-24 21:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (409, 8, 'Content Share List', 'content_share_list', 1, 0, 0, 1, '2024-04-20 08:05:46');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (410, 8, 'Upload/Share Content', 'upload_share_content', 1, 1, 0, 1, '2024-04-20 08:41:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (411, 8, 'Generate URL', 'generate_url', 1, 0, 0, 0, '2024-04-20 08:41:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (412, 8, 'Share', 'share_content', 1, 0, 0, 0, '2024-04-20 08:41:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (413, 23, 'OPD Bill Print Header Footer', 'opd_bill_print_header_footer', 1, 0, 1, 0, '2024-05-01 14:39:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (414, 15, 'Attendance Setting', 'attendance_setting', 1, 0, 1, 0, '2018-07-05 00:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (415, 44, 'Duty Roster', 'duty_roster', 1, 0, 0, 0, '2018-07-05 00:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (416, 44, 'Shift', 'roster_shift', 1, 1, 1, 1, '2024-08-08 11:03:23');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (417, 44, 'Roster List', 'roster_list', 1, 1, 1, 1, '2018-07-05 00:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (418, 44, 'Roster Assign', 'roster_assign', 1, 1, 1, 1, '2018-07-05 00:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (419, 45, 'Annual Calendar', 'annual_calendar', 1, 1, 1, 1, '2018-07-05 00:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (420, NULL, 'Consultation', 'consultation', 0, 0, 0, 0, '2025-06-06 19:24:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (421, 1, 'Consultation', 'consultation', 1, 1, 1, 1, '2025-06-07 13:51:35');


#
# TABLE STRUCTURE FOR: permission_group
#

DROP TABLE IF EXISTS `permission_group`;

CREATE TABLE `permission_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `short_code` varchar(100) NOT NULL,
  `is_active` int(11) DEFAULT 0,
  `system` int(11) NOT NULL,
  `sort_order` decimal(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_short_code` (`short_code`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (3, 'Income', 'income', 1, 0, '15.00', '2021-10-22 02:07:50');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (4, 'Expense', 'expense', 1, 0, '16.00', '2021-10-22 02:07:55');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (8, 'Download Center', 'download_center', 1, 0, '19.00', '2021-10-22 02:13:38');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (10, 'Inventory', 'inventory', 1, 0, '18.00', '2021-10-22 02:13:22');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (13, 'Messaging', 'communicate', 1, 0, '17.00', '2021-10-22 02:13:08');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (14, 'Reports', 'reports', 1, 1, '23.00', '2021-10-22 02:14:35');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (15, 'System Settings', 'system_settings', 1, 1, '24.00', '2021-10-22 02:16:02');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (16, 'Front CMS', 'front_cms', 1, 0, '21.00', '2021-10-22 02:14:07');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (17, 'Front Office', 'front_office', 1, 0, '10.00', '2021-10-22 02:05:56');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (18, 'Human Resource', 'human_resource', 1, 1, '12.00', '2021-10-22 02:06:27');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (21, 'Calendar To Do List', 'calendar_to_do_list', 1, 0, '28.00', '2021-10-22 02:22:27');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (22, 'Dashboard and Widgets', 'dashboard_and_widgets', 1, 1, '0.01', '2021-10-22 02:18:00');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (23, 'OPD', 'opd', 1, 0, '3.00', '2021-10-22 02:04:29');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (24, 'IPD', 'ipd', 1, 0, '4.00', '2021-10-22 02:04:38');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (25, 'Pharmacy', 'pharmacy', 1, 0, '5.00', '2021-10-22 02:04:47');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (26, 'Pathology', 'pathology', 1, 0, '6.00', '2021-10-22 02:04:59');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (27, 'Radiology', 'radiology', 1, 0, '7.00', '2021-10-22 02:05:09');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (29, 'Ambulance', 'ambulance', 1, 0, '9.00', '2025-07-05 16:47:24');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (30, 'Blood Bank', 'blood_bank', 1, 0, '8.00', '2021-10-22 02:05:21');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (31, 'TPA Management', 'tpa_management', 1, 0, '14.00', '2021-10-22 02:06:58');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (32, 'Hospital Charges', 'hospital_charges', 1, 1, '26.00', '2021-10-22 02:19:04');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (34, 'Birth Death Record', 'birth_death_report', 1, 0, '11.00', '2021-10-22 02:06:10');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (36, 'Patient', 'patient', 1, 0, '25.00', '2021-10-22 02:18:46');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (37, 'Live Consultation', 'live_consultation', 1, 0, '22.00', '2021-10-22 02:14:21');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (38, 'Referral', 'referral', 1, 0, '13.00', '2021-10-22 02:06:48');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (39, 'Appointment', 'appointment', 1, 0, '2.00', '2021-10-22 02:04:15');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (41, 'Billing', 'bill', 1, 0, '1.00', '2024-08-21 11:29:55');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (42, 'Certificate', 'certificate', 1, 0, '20.00', '2021-10-04 05:36:58');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (43, 'Chat', 'chat', 1, 0, '27.00', '2021-10-22 02:22:19');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (44, 'Duty Roster', 'duty_roster', 1, 0, '12.10', '2024-08-09 12:37:56');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (45, 'Annual Calendar', 'annual_calendar', 1, 0, '12.20', '2024-08-17 08:32:13');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (46, 'Patient Billing', 'patient_billing', 1, 0, '26.00', '2025-07-01 19:23:47');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (47, 'Patient Billing', 'patient_billing', 1, 0, '26.00', '2025-07-01 19:36:24');


#
# TABLE STRUCTURE FOR: permission_patient
#

DROP TABLE IF EXISTS `permission_patient`;

CREATE TABLE `permission_patient` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permission_group_short_code` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `short_code` varchar(100) NOT NULL,
  `is_active` int(11) DEFAULT NULL,
  `system` int(11) NOT NULL,
  `sort_order` decimal(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_permission_group_short_code` (`permission_group_short_code`),
  KEY `index_name` (`name`),
  KEY `index_short_code` (`short_code`),
  KEY `index_is_active` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (1, 'appointment', 'My Appointments', 'my_appointments', 1, 0, '1.00', '2021-09-27 15:17:05');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (2, 'opd', 'OPD', 'opd', 1, 0, '2.00', '2021-09-27 15:17:21');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (3, 'ipd', 'IPD', 'ipd', 1, 0, '3.00', '2021-09-25 11:33:07');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (4, 'pharmacy', 'Pharmacy', 'pharmacy', 1, 0, '4.00', '2021-09-25 08:03:29');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (5, 'pathology', 'Pathology', 'pathology', 1, 0, '5.00', '2021-09-27 15:15:45');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (6, 'radiology', 'Radiology', 'radiology', 1, 0, '6.00', '2021-09-27 15:15:47');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (7, 'ambulance', 'Ambulance', 'ambulance', 1, 0, '7.00', '2025-07-05 16:47:24');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (8, 'blood_bank', 'Blood Bank', 'blood_bank', 1, 0, '8.00', '2021-09-24 09:40:59');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (9, 'live_consultation', 'Live Consultation', 'live_consultation', 1, 0, '9.00', '2021-09-27 15:16:49');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (10, 'calendar_to_do_list', 'Calendar To Do List', 'calendar_to_do_list', 1, 0, '11.00', '2021-10-04 11:07:25');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (11, 'chat', 'Chat', 'chat', 1, 0, '11.00', '2021-10-04 09:34:59');
INSERT INTO `permission_patient` (`id`, `permission_group_short_code`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (12, 'download_center', 'Download Center', 'download_center', 1, 0, '12.00', '2024-06-26 14:29:50');


#
# TABLE STRUCTURE FOR: petty_cash_transactions
#

DROP TABLE IF EXISTS `petty_cash_transactions`;

CREATE TABLE `petty_cash_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amount` decimal(10,2) NOT NULL,
  `transaction_type` enum('expense','replenishment') NOT NULL,
  `category` varchar(100) DEFAULT NULL,
  `description` text NOT NULL,
  `receipt_no` varchar(50) DEFAULT NULL,
  `staff_id` int(11) NOT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `journal_id` int(11) DEFAULT NULL COMMENT 'Link to auto-generated journal entry',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `transaction_type` (`transaction_type`),
  KEY `category` (`category`),
  KEY `staff_id` (`staff_id`),
  KEY `approved_by` (`approved_by`),
  KEY `journal_id` (`journal_id`),
  KEY `created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: pharmacy
#

DROP TABLE IF EXISTS `pharmacy`;

CREATE TABLE `pharmacy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_name` varchar(200) DEFAULT NULL,
  `medicine_category_id` int(11) DEFAULT NULL,
  `medicine_image` text NOT NULL,
  `medicine_company` varchar(100) DEFAULT NULL,
  `medicine_composition` varchar(100) DEFAULT NULL,
  `medicine_group` varchar(100) DEFAULT NULL,
  `unit` varchar(50) DEFAULT NULL,
  `min_level` varchar(50) DEFAULT NULL,
  `reorder_level` varchar(50) DEFAULT NULL,
  `vat` float DEFAULT NULL,
  `unit_packing` varchar(50) DEFAULT NULL,
  `vat_ac` varchar(50) DEFAULT NULL,
  `rack_number` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `medicine_category_id` (`medicine_category_id`),
  KEY `idx_medicine_name` (`medicine_name`),
  KEY `index_medicine_name` (`medicine_name`),
  KEY `index_medicine_company` (`medicine_company`),
  KEY `index_medicine_composition` (`medicine_composition`),
  KEY `index_medicine_group` (`medicine_group`),
  KEY `index_unit` (`unit`),
  KEY `index_min_level` (`min_level`),
  KEY `index_reorder_level` (`reorder_level`),
  KEY `index_vat` (`vat`),
  KEY `index_unit_packing` (`unit_packing`),
  KEY `index_vat_ac` (`vat_ac`),
  KEY `index_rack_number` (`rack_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: pharmacy_bill_basic
#

DROP TABLE IF EXISTS `pharmacy_bill_basic`;

CREATE TABLE `pharmacy_bill_basic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `ipd_prescription_basic_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `customer_type` varchar(50) DEFAULT NULL,
  `doctor_name` varchar(50) DEFAULT NULL,
  `file` varchar(200) NOT NULL,
  `total` float(10,2) DEFAULT 0.00,
  `discount_percentage` float(10,2) DEFAULT 0.00,
  `discount` float(10,2) DEFAULT 0.00,
  `tax_percentage` float(10,2) DEFAULT 0.00,
  `tax` float(10,2) DEFAULT 0.00,
  `net_amount` float(10,2) DEFAULT 0.00,
  `note` text DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `payment_status` varchar(20) DEFAULT 'pending',
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `generated_by` (`generated_by`),
  KEY `ipd_prescription_basic_id` (`ipd_prescription_basic_id`),
  KEY `index_customer_name` (`customer_name`),
  KEY `index_customer_type` (`customer_type`),
  KEY `index_doctor_name` (`doctor_name`),
  KEY `index_total` (`total`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_discount` (`discount`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_tax` (`tax`),
  KEY `index_net_amount` (`net_amount`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: pharmacy_bill_detail
#

DROP TABLE IF EXISTS `pharmacy_bill_detail`;

CREATE TABLE `pharmacy_bill_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pharmacy_bill_basic_id` int(11) DEFAULT NULL,
  `medicine_batch_detail_id` int(11) DEFAULT NULL,
  `quantity` varchar(100) NOT NULL,
  `sale_price` float(10,2) NOT NULL,
  `amount` float(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `pharmacy_bill_basic_id` (`pharmacy_bill_basic_id`),
  KEY `medicine_batch_detail_id` (`medicine_batch_detail_id`),
  KEY `index_quantity` (`quantity`),
  KEY `index_sale_price` (`sale_price`),
  KEY `index_amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: pharmacy_company
#

DROP TABLE IF EXISTS `pharmacy_company`;

CREATE TABLE `pharmacy_company` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_company_name` (`company_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: phlebotomy
#

DROP TABLE IF EXISTS `phlebotomy`;

CREATE TABLE `phlebotomy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `barcode` varchar(50) NOT NULL,
  `sample_type` varchar(100) NOT NULL,
  `collection_date` datetime NOT NULL,
  `collected_by` int(11) NOT NULL,
  `status` enum('pending','collected','processing','completed') NOT NULL DEFAULT 'pending',
  `notes` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `collected_by` (`collected_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: phlebotomy_audit_trail
#

DROP TABLE IF EXISTS `phlebotomy_audit_trail`;

CREATE TABLE `phlebotomy_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `sample_id` int(11) DEFAULT NULL,
  `action_type` varchar(50) DEFAULT NULL,
  `action_description` text DEFAULT NULL,
  `old_values` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`old_values`)),
  `new_values` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`new_values`)),
  `performed_by` int(11) DEFAULT NULL,
  `action_timestamp` datetime DEFAULT current_timestamp(),
  `module` varchar(50) DEFAULT 'phlebotomy',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: phlebotomy_barcodes
#

DROP TABLE IF EXISTS `phlebotomy_barcodes`;

CREATE TABLE `phlebotomy_barcodes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sample_id` int(11) NOT NULL,
  `barcode` varchar(100) NOT NULL,
  `generated_at` datetime DEFAULT current_timestamp(),
  `generated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `barcode` (`barcode`),
  KEY `sample_id` (`sample_id`),
  CONSTRAINT `phlebotomy_barcodes_ibfk_1` FOREIGN KEY (`sample_id`) REFERENCES `phlebotomy_samples` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: phlebotomy_completion
#

DROP TABLE IF EXISTS `phlebotomy_completion`;

CREATE TABLE `phlebotomy_completion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `total_samples_collected` int(11) NOT NULL DEFAULT 0,
  `sample_types` text DEFAULT NULL,
  `completion_notes` text DEFAULT NULL,
  `next_department` varchar(100) DEFAULT 'laboratory',
  `completed_by` int(11) NOT NULL,
  `completion_date` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `completion_date` (`completion_date`),
  KEY `completed_by` (`completed_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: phlebotomy_process_completion
#

DROP TABLE IF EXISTS `phlebotomy_process_completion`;

CREATE TABLE `phlebotomy_process_completion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `collected_samples` text DEFAULT NULL,
  `generated_barcodes` text DEFAULT NULL,
  `completion_summary` text DEFAULT NULL,
  `completed_by` int(11) NOT NULL,
  `completion_date` datetime NOT NULL,
  `status` enum('completed','partially_completed','cancelled') DEFAULT 'completed',
  `next_step` varchar(100) DEFAULT 'radiology',
  `notes` text DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `completion_date` (`completion_date`),
  KEY `completed_by` (`completed_by`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: phlebotomy_rejected_samples
#

DROP TABLE IF EXISTS `phlebotomy_rejected_samples`;

CREATE TABLE `phlebotomy_rejected_samples` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sample_id` int(11) NOT NULL,
  `reason` text DEFAULT NULL,
  `rejected_by` int(11) DEFAULT NULL,
  `rejected_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `sample_id` (`sample_id`),
  CONSTRAINT `phlebotomy_rejected_samples_ibfk_1` FOREIGN KEY (`sample_id`) REFERENCES `phlebotomy_samples` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: phlebotomy_samples
#

DROP TABLE IF EXISTS `phlebotomy_samples`;

CREATE TABLE `phlebotomy_samples` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `sample_type` varchar(50) NOT NULL,
  `collection_date` datetime NOT NULL,
  `status` enum('pending','collected','rejected','processed') DEFAULT 'pending',
  `collected_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: phlebotomy_test_orders
#

DROP TABLE IF EXISTS `phlebotomy_test_orders`;

CREATE TABLE `phlebotomy_test_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sample_id` int(11) NOT NULL,
  `test_name` varchar(100) NOT NULL,
  `test_code` varchar(50) DEFAULT NULL,
  `priority` enum('routine','urgent') DEFAULT 'routine',
  `ordered_by` int(11) DEFAULT NULL,
  `status` enum('ordered','in-progress','completed') DEFAULT 'ordered',
  `order_date` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `sample_id` (`sample_id`),
  CONSTRAINT `phlebotomy_test_orders_ibfk_1` FOREIGN KEY (`sample_id`) REFERENCES `phlebotomy_samples` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: phlebotomy_test_results
#

DROP TABLE IF EXISTS `phlebotomy_test_results`;

CREATE TABLE `phlebotomy_test_results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_order_id` int(11) NOT NULL,
  `result_value` varchar(255) DEFAULT NULL,
  `result_date` datetime DEFAULT current_timestamp(),
  `reviewed_by` int(11) DEFAULT NULL,
  `remarks` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `test_order_id` (`test_order_id`),
  CONSTRAINT `phlebotomy_test_results_ibfk_1` FOREIGN KEY (`test_order_id`) REFERENCES `phlebotomy_test_orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: phlebotomy_verification_logs
#

DROP TABLE IF EXISTS `phlebotomy_verification_logs`;

CREATE TABLE `phlebotomy_verification_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `verification_method` enum('fingerprint','manual','photo','biometric') NOT NULL,
  `attempted_by` int(11) NOT NULL,
  `attempt_time` datetime NOT NULL,
  `verification_status` enum('pending','success','failed','error') DEFAULT 'pending',
  `verification_result` text DEFAULT NULL,
  `match_score` decimal(5,2) DEFAULT NULL,
  `completed_at` datetime DEFAULT NULL,
  `module` varchar(50) DEFAULT 'phlebotomy',
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `attempted_by` (`attempted_by`),
  KEY `attempt_time` (`attempt_time`),
  KEY `verification_status` (`verification_status`),
  KEY `module` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: postnatal_examine
#

DROP TABLE IF EXISTS `postnatal_examine`;

CREATE TABLE `postnatal_examine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `labor_time` datetime NOT NULL,
  `delivery_time` datetime NOT NULL,
  `routine_question` text NOT NULL,
  `general_remark` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `index_labor_time` (`labor_time`),
  KEY `index_delivery_time` (`delivery_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: prefixes
#

DROP TABLE IF EXISTS `prefixes`;

CREATE TABLE `prefixes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT NULL,
  `prefix` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_type` (`type`),
  KEY `index_prefix` (`prefix`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (1, 'ipd_no', 'IPDN', '2021-06-30 19:40:23');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (2, 'opd_no', 'OPDN', '2021-02-22 15:38:01');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (3, 'ipd_prescription', 'IPDP', '2021-02-12 20:42:07');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (4, 'opd_prescription', 'OPDP', '2021-02-12 20:42:17');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (5, 'appointment', 'APPN', '2021-10-22 07:37:43');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (6, 'pharmacy_billing', 'PHAB', '2021-10-22 07:37:43');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (7, 'operation_theater_reference_no', 'OTRN', '2021-10-22 07:37:43');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (8, 'blood_bank_billing', 'BLBB', '2021-10-22 07:40:38');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (9, 'ambulance_call_billing', 'AMCB', '2021-10-22 07:40:38');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (10, 'radiology_billing', 'RADB', '2021-10-22 07:40:38');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (11, 'pathology_billing', 'PATB', '2021-10-22 07:40:38');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (12, 'checkup_id', 'OCID', '2021-10-22 07:44:25');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (13, 'purchase_no', 'PHPN', '2021-10-22 07:44:25');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (14, 'transaction_id', 'TRID', '2021-10-22 07:44:25');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (15, 'birth_record_reference_no', 'BRRN', '2021-10-22 07:44:25');
INSERT INTO `prefixes` (`id`, `type`, `prefix`, `created_at`) VALUES (16, 'death_record_reference_no', 'DRRN', '2021-10-22 07:44:25');


#
# TABLE STRUCTURE FOR: primary_examine
#

DROP TABLE IF EXISTS `primary_examine`;

CREATE TABLE `primary_examine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipdid` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `bleeding` varchar(250) DEFAULT NULL,
  `headache` varchar(250) DEFAULT NULL,
  `pain` varchar(250) DEFAULT NULL,
  `constipation` varchar(250) DEFAULT NULL,
  `urinary_symptoms` varchar(250) NOT NULL,
  `vomiting` varchar(250) DEFAULT NULL,
  `cough` varchar(250) DEFAULT NULL,
  `vaginal` varchar(250) DEFAULT NULL,
  `discharge` varchar(250) DEFAULT NULL,
  `oedema` varchar(250) DEFAULT NULL,
  `haemoroids` varchar(250) DEFAULT NULL,
  `weight` varchar(250) NOT NULL,
  `height` varchar(11) NOT NULL,
  `date` datetime DEFAULT NULL,
  `general_condition` text NOT NULL,
  `finding_remark` varchar(250) NOT NULL,
  `pelvic_examination` text NOT NULL,
  `sp` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `ipdid` (`ipdid`),
  KEY `index_bleeding` (`bleeding`),
  KEY `index_headache` (`headache`),
  KEY `index_pain` (`pain`),
  KEY `index_constipation` (`constipation`),
  KEY `index_urinary_symptoms` (`urinary_symptoms`),
  KEY `index_vomiting` (`vomiting`),
  KEY `index_cough` (`cough`),
  KEY `index_vaginal` (`vaginal`),
  KEY `index_discharge` (`discharge`),
  KEY `index_oedema` (`oedema`),
  KEY `index_haemoroids` (`haemoroids`),
  KEY `index_weight` (`weight`),
  KEY `index_height` (`height`),
  KEY `index_date` (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: print_setting
#

DROP TABLE IF EXISTS `print_setting`;

CREATE TABLE `print_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `print_header` text NOT NULL,
  `print_footer` text NOT NULL,
  `setting_for` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (1, 'uploads/printing/1.png', '', 'opdpre', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (2, 'uploads/printing/2.png', '', 'opd', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (3, 'uploads/printing/3.png', '', 'ipdpres', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (4, 'uploads/printing/4.png', '', 'ipd', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (5, 'uploads/printing/5.png', '', 'bill', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (6, 'uploads/printing/6.png', '', 'pharmacy', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (7, 'uploads/printing/7.png', '', 'payslip', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (8, 'uploads/printing/8.png', '', 'paymentreceipt', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (9, 'uploads/printing/9.png', '', 'birth', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (10, 'uploads/printing/10.png', '', 'death', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (11, 'uploads/printing/11.png', '', 'pathology', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (12, 'uploads/printing/12.png', '', 'radiology', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (13, 'uploads/printing/13.png', '', 'ot', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (14, 'uploads/printing/14.png', '', 'bloodbank', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (15, 'uploads/printing/15.png', '', 'ambulance', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (16, 'uploads/printing/16.png', '', 'discharge_card', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (17, 'uploads/printing/17.png', '', 'obstetric_history', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (18, 'uploads/printing/18.png', '', 'opd_antenatal_finding', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (19, 'uploads/printing/19.png', '', 'ipd_antenatal_finding', 'yes', '2021-09-25 08:44:20');
INSERT INTO `print_setting` (`id`, `print_header`, `print_footer`, `setting_for`, `is_active`, `created_at`) VALUES (20, 'uploads/printing/20.png', '', 'appointment', 'yes', '2021-09-25 08:44:20');


#
# TABLE STRUCTURE FOR: procurement_approvals
#

DROP TABLE IF EXISTS `procurement_approvals`;

CREATE TABLE `procurement_approvals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `document_type` enum('requisition','purchase_order','grn') NOT NULL,
  `document_id` int(11) NOT NULL,
  `approval_level` int(11) NOT NULL DEFAULT 1,
  `approver_id` int(11) NOT NULL,
  `approval_status` enum('pending','approved','rejected','returned') NOT NULL,
  `approval_date` datetime DEFAULT NULL,
  `comments` text DEFAULT NULL,
  `next_approver_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fk_approver` (`approver_id`),
  KEY `fk_next_approver` (`next_approver_id`),
  KEY `idx_document_type_id` (`document_type`,`document_id`),
  KEY `idx_approval_status` (`approval_status`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `procurement_approvals` (`id`, `document_type`, `document_id`, `approval_level`, `approver_id`, `approval_status`, `approval_date`, `comments`, `next_approver_id`, `created_at`) VALUES (1, 'requisition', 1, 1, 1, 'approved', '2025-06-26 07:47:42', 'Approved', NULL, '2025-06-26 09:47:42');
INSERT INTO `procurement_approvals` (`id`, `document_type`, `document_id`, `approval_level`, `approver_id`, `approval_status`, `approval_date`, `comments`, `next_approver_id`, `created_at`) VALUES (2, 'requisition', 2, 1, 1, 'approved', '2025-07-04 06:55:03', 'Approved', NULL, '2025-07-04 08:55:03');
INSERT INTO `procurement_approvals` (`id`, `document_type`, `document_id`, `approval_level`, `approver_id`, `approval_status`, `approval_date`, `comments`, `next_approver_id`, `created_at`) VALUES (3, 'requisition', 3, 1, 1, 'approved', '2025-07-05 15:09:58', 'Approved', NULL, '2025-07-05 17:09:58');


#
# TABLE STRUCTURE FOR: procurement_budgets
#

DROP TABLE IF EXISTS `procurement_budgets`;

CREATE TABLE `procurement_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_id` int(11) NOT NULL,
  `budget_year` year(4) NOT NULL,
  `budget_category` varchar(100) NOT NULL,
  `allocated_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `committed_amount` decimal(15,2) DEFAULT 0.00,
  `spent_amount` decimal(15,2) DEFAULT 0.00,
  `available_amount` decimal(15,2) GENERATED ALWAYS AS (`allocated_amount` - `committed_amount` - `spent_amount`) STORED,
  `is_active` enum('yes','no') DEFAULT 'yes',
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_dept_year_category` (`department_id`,`budget_year`,`budget_category`),
  KEY `fk_budget_department` (`department_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: purchase_order_items
#

DROP TABLE IF EXISTS `purchase_order_items`;

CREATE TABLE `purchase_order_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purchase_order_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `quantity_ordered` int(11) NOT NULL,
  `unit_cost` decimal(10,2) NOT NULL,
  `total_cost` decimal(15,2) NOT NULL,
  `quantity_received` int(11) DEFAULT 0,
  `quantity_remaining` int(11) DEFAULT 0,
  `specifications` text DEFAULT NULL,
  `delivery_notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fk_po_item` (`purchase_order_id`),
  KEY `fk_order_item` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: purchase_orders
#

DROP TABLE IF EXISTS `purchase_orders`;

CREATE TABLE `purchase_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lpo_number` varchar(50) NOT NULL,
  `supplier_id` int(11) NOT NULL,
  `requisition_id` int(11) DEFAULT NULL,
  `order_date` date NOT NULL,
  `expected_delivery_date` date DEFAULT NULL,
  `delivery_address` text DEFAULT NULL,
  `payment_terms` varchar(100) DEFAULT NULL,
  `subtotal` decimal(15,2) DEFAULT 0.00,
  `tax_amount` decimal(15,2) DEFAULT 0.00,
  `discount_amount` decimal(15,2) DEFAULT 0.00,
  `total_amount` decimal(15,2) DEFAULT 0.00,
  `currency` varchar(10) DEFAULT 'KES',
  `status` enum('draft','sent','confirmed','partially_received','fully_received','cancelled','dispute') DEFAULT 'draft',
  `notes` text DEFAULT NULL,
  `terms_conditions` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `approved_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `lpo_number` (`lpo_number`),
  UNIQUE KEY `unique_lpo_number` (`lpo_number`),
  KEY `fk_po_supplier` (`supplier_id`),
  KEY `fk_po_requisition` (`requisition_id`),
  KEY `fk_po_created_by` (`created_by`),
  KEY `fk_po_approved_by` (`approved_by`),
  KEY `idx_po_status` (`status`),
  KEY `idx_order_date` (`order_date`),
  KEY `idx_po_status_date` (`status`,`order_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: purchase_requisition_items
#

DROP TABLE IF EXISTS `purchase_requisition_items`;

CREATE TABLE `purchase_requisition_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `requisition_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `quantity_requested` int(11) NOT NULL,
  `unit_cost_estimated` decimal(10,2) DEFAULT 0.00,
  `total_cost_estimated` decimal(15,2) DEFAULT 0.00,
  `quantity_approved` int(11) DEFAULT NULL,
  `quantity_fulfilled` int(11) DEFAULT 0,
  `urgency_notes` text DEFAULT NULL,
  `specifications` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `fk_requisition_item` (`requisition_id`),
  KEY `fk_item` (`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `purchase_requisition_items` (`id`, `requisition_id`, `item_id`, `quantity_requested`, `unit_cost_estimated`, `total_cost_estimated`, `quantity_approved`, `quantity_fulfilled`, `urgency_notes`, `specifications`, `created_at`) VALUES (1, 1, 4, 200, '8.00', '1600.00', NULL, 0, '', '', '2025-06-26 09:45:29');
INSERT INTO `purchase_requisition_items` (`id`, `requisition_id`, `item_id`, `quantity_requested`, `unit_cost_estimated`, `total_cost_estimated`, `quantity_approved`, `quantity_fulfilled`, `urgency_notes`, `specifications`, `created_at`) VALUES (2, 2, 3, 50, '2.50', '125.00', NULL, 0, '', '', '2025-07-02 16:09:18');
INSERT INTO `purchase_requisition_items` (`id`, `requisition_id`, `item_id`, `quantity_requested`, `unit_cost_estimated`, `total_cost_estimated`, `quantity_approved`, `quantity_fulfilled`, `urgency_notes`, `specifications`, `created_at`) VALUES (3, 3, 1, 1200, '15.00', '18000.00', NULL, 0, '', 'silver stainless', '2025-07-04 08:57:46');


#
# TABLE STRUCTURE FOR: purchase_requisitions
#

DROP TABLE IF EXISTS `purchase_requisitions`;

CREATE TABLE `purchase_requisitions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `requisition_no` varchar(50) NOT NULL,
  `requesting_department_id` int(11) NOT NULL,
  `requested_by` int(11) NOT NULL,
  `request_date` date NOT NULL,
  `required_date` date DEFAULT NULL,
  `priority` enum('low','medium','high','urgent') DEFAULT 'medium',
  `purpose` text DEFAULT NULL,
  `justification` text DEFAULT NULL,
  `total_estimated_cost` decimal(15,2) DEFAULT 0.00,
  `status` enum('draft','pending_approval','approved','rejected','partially_fulfilled','fulfilled','cancelled') DEFAULT 'draft',
  `approved_by` int(11) DEFAULT NULL,
  `approved_date` datetime DEFAULT NULL,
  `approval_comments` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `requisition_no` (`requisition_no`),
  UNIQUE KEY `unique_requisition_no` (`requisition_no`),
  KEY `fk_req_department` (`requesting_department_id`),
  KEY `fk_requested_by` (`requested_by`),
  KEY `fk_approved_by` (`approved_by`),
  KEY `idx_status` (`status`),
  KEY `idx_request_date` (`request_date`),
  KEY `idx_requisition_status_date` (`status`,`request_date`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `purchase_requisitions` (`id`, `requisition_no`, `requesting_department_id`, `requested_by`, `request_date`, `required_date`, `priority`, `purpose`, `justification`, `total_estimated_cost`, `status`, `approved_by`, `approved_date`, `approval_comments`, `created_at`, `updated_at`, `created_by`) VALUES (1, 'REQ2025060001', 6, 1, '2025-06-26', '2025-07-21', 'medium', 'Sttock update', 'We had enough but it is finished', '1600.00', 'approved', 1, '2025-06-26 07:47:42', 'Approved', '2025-06-26 09:45:29', '2025-06-26 09:47:42', 1);
INSERT INTO `purchase_requisitions` (`id`, `requisition_no`, `requesting_department_id`, `requested_by`, `request_date`, `required_date`, `priority`, `purpose`, `justification`, `total_estimated_cost`, `status`, `approved_by`, `approved_date`, `approval_comments`, `created_at`, `updated_at`, `created_by`) VALUES (2, 'REQ2025070001', 2, 1, '2025-07-02', '2025-07-02', 'medium', 'low stock level', '', '125.00', 'approved', 1, '2025-07-04 06:55:03', 'Approved', '2025-07-02 16:09:18', '2025-07-04 08:55:03', 1);
INSERT INTO `purchase_requisitions` (`id`, `requisition_no`, `requesting_department_id`, `requested_by`, `request_date`, `required_date`, `priority`, `purpose`, `justification`, `total_estimated_cost`, `status`, `approved_by`, `approved_date`, `approval_comments`, `created_at`, `updated_at`, `created_by`) VALUES (3, 'REQ2025070002', 2, 1, '2025-07-04', '2025-07-24', 'medium', 'low stock level', 'for lab purposes', '18000.00', 'approved', 1, '2025-07-05 15:09:58', 'Approved', '2025-07-04 08:57:46', '2025-07-05 17:09:58', 1);


#
# TABLE STRUCTURE FOR: queue_config
#

DROP TABLE IF EXISTS `queue_config`;

CREATE TABLE `queue_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department` varchar(50) NOT NULL,
  `queue_prefix` varchar(10) NOT NULL,
  `counter_start` int(11) DEFAULT 1,
  `counter_current` int(11) DEFAULT 1,
  `is_active` tinyint(1) DEFAULT 1,
  `working_hours_start` time DEFAULT '08:00:00',
  `working_hours_end` time DEFAULT '17:00:00',
  `max_queue_size` int(11) DEFAULT 100,
  `average_service_time` int(11) DEFAULT 15 COMMENT 'in minutes',
  `auto_call_next` tinyint(1) DEFAULT 0,
  `allow_priority_queue` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `department` (`department`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: queue_display_settings
#

DROP TABLE IF EXISTS `queue_display_settings`;

CREATE TABLE `queue_display_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department` varchar(50) NOT NULL,
  `display_name` varchar(100) NOT NULL,
  `show_current_serving` tinyint(1) DEFAULT 1,
  `show_next_in_queue` tinyint(1) DEFAULT 1,
  `show_queue_count` tinyint(1) DEFAULT 1,
  `show_estimated_wait` tinyint(1) DEFAULT 1,
  `auto_refresh_seconds` int(11) DEFAULT 30,
  `announcement_enabled` tinyint(1) DEFAULT 1,
  `announcement_language` varchar(10) DEFAULT 'en',
  `theme_color` varchar(7) DEFAULT '#007bff',
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `department` (`department`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `queue_display_settings` (`id`, `department`, `display_name`, `show_current_serving`, `show_next_in_queue`, `show_queue_count`, `show_estimated_wait`, `auto_refresh_seconds`, `announcement_enabled`, `announcement_language`, `theme_color`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'registration', 'Registration Counter', 1, 1, 1, 1, 30, 1, 'en', '#28a745', 1, '2025-07-20 16:11:30', NULL);
INSERT INTO `queue_display_settings` (`id`, `department`, `display_name`, `show_current_serving`, `show_next_in_queue`, `show_queue_count`, `show_estimated_wait`, `auto_refresh_seconds`, `announcement_enabled`, `announcement_language`, `theme_color`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'triage', 'Triage Department', 1, 1, 1, 1, 30, 1, 'en', '#ffc107', 1, '2025-07-20 16:11:30', NULL);
INSERT INTO `queue_display_settings` (`id`, `department`, `display_name`, `show_current_serving`, `show_next_in_queue`, `show_queue_count`, `show_estimated_wait`, `auto_refresh_seconds`, `announcement_enabled`, `announcement_language`, `theme_color`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'consultation', 'Consultation Rooms', 1, 1, 1, 1, 30, 1, 'en', '#007bff', 1, '2025-07-20 16:11:30', NULL);
INSERT INTO `queue_display_settings` (`id`, `department`, `display_name`, `show_current_serving`, `show_next_in_queue`, `show_queue_count`, `show_estimated_wait`, `auto_refresh_seconds`, `announcement_enabled`, `announcement_language`, `theme_color`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'laboratory', 'Laboratory Services', 1, 1, 1, 1, 30, 1, 'en', '#6f42c1', 1, '2025-07-20 16:11:30', NULL);
INSERT INTO `queue_display_settings` (`id`, `department`, `display_name`, `show_current_serving`, `show_next_in_queue`, `show_queue_count`, `show_estimated_wait`, `auto_refresh_seconds`, `announcement_enabled`, `announcement_language`, `theme_color`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'radiology', 'Radiology Department', 1, 1, 1, 1, 30, 1, 'en', '#fd7e14', 1, '2025-07-20 16:11:30', NULL);
INSERT INTO `queue_display_settings` (`id`, `department`, `display_name`, `show_current_serving`, `show_next_in_queue`, `show_queue_count`, `show_estimated_wait`, `auto_refresh_seconds`, `announcement_enabled`, `announcement_language`, `theme_color`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'pharmacy', 'Pharmacy Counter', 1, 1, 1, 1, 30, 1, 'en', '#20c997', 1, '2025-07-20 16:11:30', NULL);
INSERT INTO `queue_display_settings` (`id`, `department`, `display_name`, `show_current_serving`, `show_next_in_queue`, `show_queue_count`, `show_estimated_wait`, `auto_refresh_seconds`, `announcement_enabled`, `announcement_language`, `theme_color`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'emergency', 'Emergency Department', 1, 1, 1, 1, 30, 1, 'en', '#dc3545', 1, '2025-07-20 16:11:30', NULL);
INSERT INTO `queue_display_settings` (`id`, `department`, `display_name`, `show_current_serving`, `show_next_in_queue`, `show_queue_count`, `show_estimated_wait`, `auto_refresh_seconds`, `announcement_enabled`, `announcement_language`, `theme_color`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'ipd', 'In-Patient Department', 1, 1, 1, 1, 30, 1, 'en', '#6c757d', 1, '2025-07-20 16:11:30', NULL);


#
# TABLE STRUCTURE FOR: queue_flow_rules
#

DROP TABLE IF EXISTS `queue_flow_rules`;

CREATE TABLE `queue_flow_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from_department` varchar(50) NOT NULL,
  `to_department` varchar(50) NOT NULL,
  `condition_type` enum('automatic','conditional','manual') DEFAULT 'automatic',
  `conditions` text DEFAULT NULL,
  `priority_adjustment` int(2) DEFAULT 0 COMMENT '-2 to +2',
  `is_active` tinyint(1) DEFAULT 1,
  `workflow_type` enum('gcc','general','specialized') DEFAULT 'general',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_from_department` (`from_department`),
  KEY `idx_to_department` (`to_department`),
  KEY `idx_workflow_type` (`workflow_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: radio
#

DROP TABLE IF EXISTS `radio`;

CREATE TABLE `radio` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_name` varchar(255) DEFAULT NULL,
  `short_name` varchar(100) DEFAULT NULL,
  `test_type` varchar(100) DEFAULT NULL,
  `radiology_category_id` int(11) DEFAULT NULL,
  `sub_category` varchar(50) NOT NULL,
  `report_days` varchar(50) NOT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `charge_id` (`charge_id`),
  KEY `index_test_name` (`test_name`),
  KEY `index_short_name` (`short_name`),
  KEY `index_test_type` (`test_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: radiology_activity_log
#

DROP TABLE IF EXISTS `radiology_activity_log`;

CREATE TABLE `radiology_activity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `activity_type` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `timestamp` datetime NOT NULL,
  `department` varchar(50) DEFAULT 'radiology',
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `additional_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`additional_data`)),
  PRIMARY KEY (`id`),
  KEY `idx_patient` (`patient_id`),
  KEY `idx_staff` (`staff_id`),
  KEY `idx_order` (`order_id`),
  KEY `idx_activity_type` (`activity_type`),
  KEY `idx_timestamp` (`timestamp`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `radiology_activity_log` (`id`, `patient_id`, `staff_id`, `order_id`, `activity_type`, `description`, `timestamp`, `department`, `ip_address`, `user_agent`, `additional_data`) VALUES (1, 55, 1, NULL, 'order_created', 'Radiology order #4 created with 1 tests', '2025-07-01 11:46:07', 'radiology', NULL, NULL, NULL);
INSERT INTO `radiology_activity_log` (`id`, `patient_id`, `staff_id`, `order_id`, `activity_type`, `description`, `timestamp`, `department`, `ip_address`, `user_agent`, `additional_data`) VALUES (2, 55, 1, NULL, 'order_created', 'Radiology order #5 created with 1 tests', '2025-07-01 11:53:40', 'radiology', NULL, NULL, NULL);
INSERT INTO `radiology_activity_log` (`id`, `patient_id`, `staff_id`, `order_id`, `activity_type`, `description`, `timestamp`, `department`, `ip_address`, `user_agent`, `additional_data`) VALUES (3, 52, 1, NULL, 'order_created', 'Radiology order #6 created with 1 tests', '2025-07-01 12:27:52', 'radiology', NULL, NULL, NULL);
INSERT INTO `radiology_activity_log` (`id`, `patient_id`, `staff_id`, `order_id`, `activity_type`, `description`, `timestamp`, `department`, `ip_address`, `user_agent`, `additional_data`) VALUES (4, 55, 1, NULL, 'order_created', 'Radiology order #7 created with 1 tests', '2025-07-01 19:01:03', 'radiology', NULL, NULL, NULL);
INSERT INTO `radiology_activity_log` (`id`, `patient_id`, `staff_id`, `order_id`, `activity_type`, `description`, `timestamp`, `department`, `ip_address`, `user_agent`, `additional_data`) VALUES (5, 56, 1, NULL, 'order_created', 'Radiology order #8 created with 1 tests', '2025-07-03 13:50:38', 'radiology', NULL, NULL, NULL);
INSERT INTO `radiology_activity_log` (`id`, `patient_id`, `staff_id`, `order_id`, `activity_type`, `description`, `timestamp`, `department`, `ip_address`, `user_agent`, `additional_data`) VALUES (6, 57, 1, NULL, 'order_created', 'Radiology order #9 created with 1 tests', '2025-07-04 06:24:42', 'radiology', NULL, NULL, NULL);
INSERT INTO `radiology_activity_log` (`id`, `patient_id`, `staff_id`, `order_id`, `activity_type`, `description`, `timestamp`, `department`, `ip_address`, `user_agent`, `additional_data`) VALUES (7, 57, 1, NULL, 'order_created', 'Radiology order #10 created with 1 tests', '2025-07-05 06:32:44', 'radiology', NULL, NULL, NULL);
INSERT INTO `radiology_activity_log` (`id`, `patient_id`, `staff_id`, `order_id`, `activity_type`, `description`, `timestamp`, `department`, `ip_address`, `user_agent`, `additional_data`) VALUES (8, 102, 1, NULL, 'order_created', 'Radiology order #11 created with 2 tests', '2025-07-06 10:39:50', 'radiology', NULL, NULL, NULL);
INSERT INTO `radiology_activity_log` (`id`, `patient_id`, `staff_id`, `order_id`, `activity_type`, `description`, `timestamp`, `department`, `ip_address`, `user_agent`, `additional_data`) VALUES (9, 130, 1, NULL, 'order_created', 'Radiology order #12 created with 3 tests', '2025-07-06 11:26:03', 'radiology', NULL, NULL, NULL);
INSERT INTO `radiology_activity_log` (`id`, `patient_id`, `staff_id`, `order_id`, `activity_type`, `description`, `timestamp`, `department`, `ip_address`, `user_agent`, `additional_data`) VALUES (10, 131, 1, NULL, 'order_created', 'Radiology order #13 created with 1 tests', '2025-07-06 14:53:22', 'radiology', NULL, NULL, NULL);
INSERT INTO `radiology_activity_log` (`id`, `patient_id`, `staff_id`, `order_id`, `activity_type`, `description`, `timestamp`, `department`, `ip_address`, `user_agent`, `additional_data`) VALUES (11, 133, 1, NULL, 'order_created', 'Radiology order #14 created with 1 tests', '2025-07-06 15:16:27', 'radiology', NULL, NULL, NULL);
INSERT INTO `radiology_activity_log` (`id`, `patient_id`, `staff_id`, `order_id`, `activity_type`, `description`, `timestamp`, `department`, `ip_address`, `user_agent`, `additional_data`) VALUES (12, 133, 1, NULL, 'order_created', 'Radiology order #15 created with 1 tests', '2025-07-07 19:37:38', 'radiology', NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: radiology_activity_logs
#

DROP TABLE IF EXISTS `radiology_activity_logs`;

CREATE TABLE `radiology_activity_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `action` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `timestamp` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `test_id` (`test_id`),
  KEY `patient_id` (`patient_id`),
  KEY `order_id` (`order_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `radiology_activity_logs` (`id`, `test_id`, `patient_id`, `order_id`, `action`, `description`, `user_id`, `ip_address`, `user_agent`, `timestamp`) VALUES (1, 1, NULL, NULL, 'test_updated', 'Radiology test updated', 1, '41.90.187.95', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:139.0) Gecko/20100101 Firefox/139.0', '2025-07-10 04:19:35');
INSERT INTO `radiology_activity_logs` (`id`, `test_id`, `patient_id`, `order_id`, `action`, `description`, `user_id`, `ip_address`, `user_agent`, `timestamp`) VALUES (2, 2, NULL, NULL, 'gcc_status_changed', 'Test unmarked as GCC test', 1, '41.90.187.95', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:139.0) Gecko/20100101 Firefox/139.0', '2025-07-10 04:46:04');
INSERT INTO `radiology_activity_logs` (`id`, `test_id`, `patient_id`, `order_id`, `action`, `description`, `user_id`, `ip_address`, `user_agent`, `timestamp`) VALUES (3, 3, NULL, NULL, 'gcc_status_changed', 'Test unmarked as GCC test', 1, '41.90.187.95', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:139.0) Gecko/20100101 Firefox/139.0', '2025-07-10 04:46:10');
INSERT INTO `radiology_activity_logs` (`id`, `test_id`, `patient_id`, `order_id`, `action`, `description`, `user_id`, `ip_address`, `user_agent`, `timestamp`) VALUES (4, 7, NULL, NULL, 'gcc_status_changed', 'Test unmarked as GCC test', 1, '41.90.187.95', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:139.0) Gecko/20100101 Firefox/139.0', '2025-07-10 04:46:14');
INSERT INTO `radiology_activity_logs` (`id`, `test_id`, `patient_id`, `order_id`, `action`, `description`, `user_id`, `ip_address`, `user_agent`, `timestamp`) VALUES (5, 11, NULL, NULL, 'test_created', 'Radiology test \"Radiology Test\" created', 1, '41.90.187.95', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:139.0) Gecko/20100101 Firefox/139.0', '2025-07-10 05:03:20');
INSERT INTO `radiology_activity_logs` (`id`, `test_id`, `patient_id`, `order_id`, `action`, `description`, `user_id`, `ip_address`, `user_agent`, `timestamp`) VALUES (6, 11, NULL, NULL, 'test_deleted', 'Radiology test \"Radiology Test\" deleted', 1, '41.90.187.95', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:139.0) Gecko/20100101 Firefox/139.0', '2025-07-10 05:03:32');


#
# TABLE STRUCTURE FOR: radiology_billing
#

DROP TABLE IF EXISTS `radiology_billing`;

CREATE TABLE `radiology_billing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `ipd_prescription_basic_id` int(11) DEFAULT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `doctor_name` varchar(100) NOT NULL,
  `total` float(10,2) NOT NULL,
  `discount_percentage` float(10,2) NOT NULL,
  `discount` float(10,2) NOT NULL,
  `tax_percentage` float(10,2) NOT NULL,
  `tax` float(10,2) NOT NULL,
  `net_amount` float(10,2) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `organisation_id` int(11) DEFAULT NULL,
  `insurance_validity` date DEFAULT NULL,
  `insurance_id` varchar(250) DEFAULT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  `payment_status` varchar(20) DEFAULT 'pending',
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `doctor_id` (`doctor_id`),
  KEY `transaction_id` (`transaction_id`),
  KEY `generated_by` (`generated_by`),
  KEY `ipd_prescription_basic_id` (`ipd_prescription_basic_id`),
  KEY `index_date` (`date`),
  KEY `index_doctor_name` (`doctor_name`),
  KEY `index_total` (`total`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_discount` (`discount`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_tax` (`tax`),
  KEY `index_net_amount` (`net_amount`),
  KEY `index_transaction_id` (`transaction_id`),
  KEY `index_organisation_id` (`organisation_id`),
  KEY `index_insurance_validity` (`insurance_validity`),
  KEY `index_insurance_id` (`insurance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: radiology_contrast_agents
#

DROP TABLE IF EXISTS `radiology_contrast_agents`;

CREATE TABLE `radiology_contrast_agents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `agent_name` varchar(200) NOT NULL,
  `agent_type` enum('iodinated','gadolinium','barium','other') NOT NULL,
  `concentration` varchar(50) DEFAULT NULL,
  `manufacturer` varchar(100) DEFAULT NULL,
  `lot_number` varchar(100) DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  `side_effects` text DEFAULT NULL,
  `contraindications` text DEFAULT NULL,
  `dosage_adult` varchar(100) DEFAULT NULL,
  `dosage_pediatric` varchar(100) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_agent_type` (`agent_type`),
  KEY `idx_active` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: radiology_equipment
#

DROP TABLE IF EXISTS `radiology_equipment`;

CREATE TABLE `radiology_equipment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `equipment_name` varchar(200) NOT NULL,
  `equipment_type` varchar(100) NOT NULL,
  `manufacturer` varchar(100) DEFAULT NULL,
  `model` varchar(100) DEFAULT NULL,
  `serial_number` varchar(100) DEFAULT NULL,
  `location` varchar(200) DEFAULT NULL,
  `status` enum('active','maintenance','offline','retired') DEFAULT 'active',
  `installation_date` date DEFAULT NULL,
  `last_maintenance` date DEFAULT NULL,
  `next_maintenance` date DEFAULT NULL,
  `maintenance_notes` text DEFAULT NULL,
  `supported_tests` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_type` (`equipment_type`),
  KEY `idx_status` (`status`),
  KEY `idx_active` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `radiology_equipment` (`id`, `equipment_name`, `equipment_type`, `manufacturer`, `model`, `serial_number`, `location`, `status`, `installation_date`, `last_maintenance`, `next_maintenance`, `maintenance_notes`, `supported_tests`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'X-Ray Machine 1', 'X-Ray', 'Siemens', 'MOBILETT Elara Max', NULL, 'Room 101', 'active', NULL, NULL, NULL, NULL, 'XRAY_CHEST,XRAY_ABD', 1, '2025-07-01 13:19:10', '2025-07-01 13:19:10');
INSERT INTO `radiology_equipment` (`id`, `equipment_name`, `equipment_type`, `manufacturer`, `model`, `serial_number`, `location`, `status`, `installation_date`, `last_maintenance`, `next_maintenance`, `maintenance_notes`, `supported_tests`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'CT Scanner 1', 'CT Scanner', 'GE Healthcare', 'Revolution CT', NULL, 'Room 201', 'active', NULL, NULL, NULL, NULL, 'CT_HEAD,CT_ABD', 1, '2025-07-01 13:19:10', '2025-07-01 13:19:10');
INSERT INTO `radiology_equipment` (`id`, `equipment_name`, `equipment_type`, `manufacturer`, `model`, `serial_number`, `location`, `status`, `installation_date`, `last_maintenance`, `next_maintenance`, `maintenance_notes`, `supported_tests`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'MRI Scanner 1', 'MRI', 'Philips', 'Ingenia 1.5T', NULL, 'Room 301', 'active', NULL, NULL, NULL, NULL, 'MRI_BRAIN,MRI_SPINE', 1, '2025-07-01 13:19:10', '2025-07-01 13:19:10');
INSERT INTO `radiology_equipment` (`id`, `equipment_name`, `equipment_type`, `manufacturer`, `model`, `serial_number`, `location`, `status`, `installation_date`, `last_maintenance`, `next_maintenance`, `maintenance_notes`, `supported_tests`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'Ultrasound Machine 1', 'Ultrasound', 'Mindray', 'DC-8', NULL, 'Room 102', 'active', NULL, NULL, NULL, NULL, 'US_ABD,US_PELVIS', 1, '2025-07-01 13:19:10', '2025-07-01 13:19:10');
INSERT INTO `radiology_equipment` (`id`, `equipment_name`, `equipment_type`, `manufacturer`, `model`, `serial_number`, `location`, `status`, `installation_date`, `last_maintenance`, `next_maintenance`, `maintenance_notes`, `supported_tests`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Mammography Unit', 'Mammography', 'Hologic', 'Selenia Dimensions', NULL, 'Room 103', 'active', NULL, NULL, NULL, NULL, 'MAMMO', 1, '2025-07-01 13:19:10', '2025-07-01 13:19:10');


#
# TABLE STRUCTURE FOR: radiology_images
#

DROP TABLE IF EXISTS `radiology_images`;

CREATE TABLE `radiology_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `radiology_order_id` int(11) NOT NULL,
  `test_id` int(11) NOT NULL,
  `image_series` varchar(100) DEFAULT NULL,
  `image_number` int(11) DEFAULT 1,
  `image_type` varchar(50) DEFAULT NULL,
  `file_path` varchar(500) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `file_size` bigint(20) DEFAULT 0,
  `file_format` varchar(20) DEFAULT NULL,
  `image_width` int(11) DEFAULT NULL,
  `image_height` int(11) DEFAULT NULL,
  `dicom_study_id` varchar(100) DEFAULT NULL,
  `dicom_series_id` varchar(100) DEFAULT NULL,
  `dicom_instance_id` varchar(100) DEFAULT NULL,
  `acquisition_date` datetime DEFAULT NULL,
  `view_position` varchar(50) DEFAULT NULL,
  `body_part` varchar(100) DEFAULT NULL,
  `is_primary` tinyint(1) DEFAULT 0,
  `is_annotated` tinyint(1) DEFAULT 0,
  `annotations` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_order` (`radiology_order_id`),
  KEY `idx_test` (`test_id`),
  KEY `idx_primary` (`is_primary`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: radiology_order_tests
#

DROP TABLE IF EXISTS `radiology_order_tests`;

CREATE TABLE `radiology_order_tests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `radiology_order_id` int(11) NOT NULL,
  `test_id` int(11) NOT NULL,
  `status` enum('pending','in_progress','completed','cancelled') DEFAULT 'pending',
  `scheduled_date` date DEFAULT NULL,
  `scheduled_time` time DEFAULT NULL,
  `started_at` datetime DEFAULT NULL,
  `completed_at` datetime DEFAULT NULL,
  `test_result` text DEFAULT NULL,
  `abnormal_findings` text DEFAULT NULL,
  `contrast_used` tinyint(1) DEFAULT 0,
  `contrast_type` varchar(100) DEFAULT NULL,
  `radiation_dose` varchar(50) DEFAULT NULL,
  `image_count` int(11) DEFAULT 0,
  `technician_notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_order` (`radiology_order_id`),
  KEY `idx_test` (`test_id`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (4, 4, 1, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-01 10:46:07', '2025-07-01 13:46:07');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (5, 5, 4, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-01 10:53:40', '2025-07-01 13:53:40');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (6, 6, 5, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-01 11:27:52', '2025-07-01 14:27:52');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (7, 7, 3, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-01 18:01:03', '2025-07-01 21:01:03');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (8, 8, 2, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-03 12:50:38', '2025-07-03 15:50:38');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (9, 9, 4, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-04 05:24:42', '2025-07-04 08:24:42');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (10, 10, 6, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-05 05:32:44', '2025-07-05 08:32:44');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (11, 11, 3, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-06 09:39:50', '2025-07-06 12:39:50');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (12, 11, 6, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-06 09:39:50', '2025-07-06 12:39:50');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (13, 12, 9, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-06 10:26:03', '2025-07-06 13:26:03');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (14, 12, 2, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-06 10:26:03', '2025-07-06 13:26:03');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (15, 12, 1, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-06 10:26:03', '2025-07-06 13:26:03');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (16, 13, 1, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-06 13:53:22', '2025-07-06 16:53:22');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (17, 14, 1, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-06 14:16:27', '2025-07-06 17:16:27');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (18, 15, 1, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-07 18:37:38', '2025-07-07 21:37:38');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (19, 16, 7, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-08 06:16:47', '2025-07-08 06:16:47');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (20, 16, 8, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-08 06:16:47', '2025-07-08 06:16:47');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (21, 17, 7, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-08 06:18:30', '2025-07-08 06:18:30');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (22, 17, 8, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-08 06:18:30', '2025-07-08 06:18:30');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (23, 18, 4, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-10 19:34:24', '2025-07-10 19:34:24');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (24, 19, 1, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-11 03:05:14', '2025-07-11 03:05:14');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (25, 20, 1, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-11 03:07:34', '2025-07-11 03:07:34');
INSERT INTO `radiology_order_tests` (`id`, `radiology_order_id`, `test_id`, `status`, `scheduled_date`, `scheduled_time`, `started_at`, `completed_at`, `test_result`, `abnormal_findings`, `contrast_used`, `contrast_type`, `radiation_dose`, `image_count`, `technician_notes`, `created_at`, `updated_at`) VALUES (27, 22, 1, 'pending', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, '2025-07-11 03:15:34', '2025-07-11 03:15:34');


#
# TABLE STRUCTURE FOR: radiology_orders
#

DROP TABLE IF EXISTS `radiology_orders`;

CREATE TABLE `radiology_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `referring_doctor_id` int(11) DEFAULT NULL,
  `technician_id` int(11) DEFAULT NULL,
  `radiologist_id` int(11) DEFAULT NULL,
  `order_date` datetime NOT NULL,
  `scheduled_date` date DEFAULT NULL,
  `scheduled_time` time DEFAULT NULL,
  `priority` enum('routine','urgent','stat') DEFAULT 'routine',
  `status` enum('pending','scheduled','in_progress','completed','cancelled','reported') DEFAULT 'pending',
  `clinical_notes` text DEFAULT NULL,
  `technician_notes` text DEFAULT NULL,
  `verification_required` tinyint(1) DEFAULT 1,
  `verification_status` enum('pending','verified','failed','manual') DEFAULT 'pending',
  `verification_timestamp` datetime DEFAULT NULL,
  `verified_by` int(11) DEFAULT NULL,
  `started_at` datetime DEFAULT NULL,
  `completed_at` datetime DEFAULT NULL,
  `reported_at` datetime DEFAULT NULL,
  `total_amount` decimal(10,2) DEFAULT 0.00,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `verification_method` varchar(50) DEFAULT NULL COMMENT 'Method used for patient verification',
  `verification_score` decimal(5,2) DEFAULT NULL COMMENT 'Verification match score',
  `journal_id` int(11) DEFAULT NULL COMMENT 'Reference to journal entry',
  `payment_status` enum('pending','partial','completed','refunded') DEFAULT 'pending',
  `paid_amount` decimal(10,2) DEFAULT 0.00,
  `payment_date` datetime DEFAULT NULL,
  `refund_amount` decimal(10,2) DEFAULT 0.00,
  `refund_date` datetime DEFAULT NULL,
  `refund_reason` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_patient` (`patient_id`),
  KEY `idx_doctor` (`referring_doctor_id`),
  KEY `idx_status` (`status`),
  KEY `idx_priority` (`priority`),
  KEY `idx_date` (`order_date`),
  KEY `idx_scheduled` (`scheduled_date`),
  KEY `fk_radiology_technician` (`technician_id`),
  KEY `fk_radiology_radiologist` (`radiologist_id`),
  KEY `idx_journal_id` (`journal_id`),
  KEY `idx_payment_status` (`payment_status`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (4, 55, 3, NULL, NULL, '2025-07-01 11:46:07', NULL, NULL, 'routine', 'pending', '', NULL, 1, 'pending', NULL, NULL, NULL, NULL, NULL, '0.00', 1, '2025-07-01 13:46:07', '2025-07-01 13:46:07', NULL, NULL, NULL, 'pending', '0.00', NULL, '0.00', NULL, NULL);
INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (5, 55, 3, NULL, NULL, '2025-07-01 11:53:40', NULL, NULL, 'routine', 'pending', '', NULL, 1, 'pending', NULL, NULL, NULL, NULL, NULL, '0.00', 1, '2025-07-01 13:53:40', '2025-07-01 13:53:40', NULL, NULL, NULL, 'pending', '0.00', NULL, '0.00', NULL, NULL);
INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (6, 52, 2, NULL, NULL, '2025-07-01 12:27:52', NULL, NULL, 'routine', 'pending', '', NULL, 1, 'pending', NULL, NULL, NULL, NULL, NULL, '0.00', 1, '2025-07-01 14:27:52', '2025-07-01 14:27:52', NULL, NULL, NULL, 'pending', '0.00', NULL, '0.00', NULL, NULL);
INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (7, 55, 3, NULL, NULL, '2025-07-01 19:01:03', NULL, NULL, 'routine', 'pending', '', NULL, 1, 'pending', NULL, NULL, NULL, NULL, NULL, '0.00', 1, '2025-07-01 21:01:03', '2025-07-01 21:01:03', NULL, NULL, NULL, 'pending', '0.00', NULL, '0.00', NULL, NULL);
INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (8, 56, 3, NULL, NULL, '2025-07-03 13:50:38', NULL, NULL, 'routine', 'pending', '', NULL, 1, 'pending', NULL, NULL, NULL, NULL, NULL, '0.00', 1, '2025-07-03 15:50:38', '2025-07-03 15:50:38', NULL, NULL, NULL, 'pending', '0.00', NULL, '0.00', NULL, NULL);
INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (9, 57, 4, NULL, NULL, '2025-07-04 06:24:42', NULL, NULL, 'routine', 'pending', '', NULL, 1, 'pending', NULL, NULL, NULL, NULL, NULL, '0.00', 1, '2025-07-04 08:24:42', '2025-07-04 08:24:42', NULL, NULL, NULL, 'pending', '0.00', NULL, '0.00', NULL, NULL);
INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (10, 57, 3, NULL, NULL, '2025-07-05 06:32:44', NULL, NULL, 'urgent', 'pending', '', NULL, 1, 'pending', NULL, NULL, NULL, NULL, NULL, '0.00', 1, '2025-07-05 08:32:44', '2025-07-05 08:32:44', NULL, NULL, NULL, 'pending', '0.00', NULL, '0.00', NULL, NULL);
INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (11, 102, 2, NULL, NULL, '2025-07-06 10:39:50', NULL, NULL, 'routine', 'pending', '', NULL, 1, 'pending', NULL, NULL, NULL, NULL, NULL, '0.00', 1, '2025-07-06 12:39:50', '2025-07-06 12:39:50', NULL, NULL, NULL, 'pending', '0.00', NULL, '0.00', NULL, NULL);
INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (12, 130, 3, NULL, NULL, '2025-07-06 11:26:03', NULL, NULL, 'routine', 'pending', '', NULL, 1, 'pending', NULL, NULL, NULL, NULL, NULL, '0.00', 1, '2025-07-06 13:26:03', '2025-07-06 13:26:03', NULL, NULL, NULL, 'pending', '0.00', NULL, '0.00', NULL, NULL);
INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (13, 131, 3, NULL, NULL, '2025-07-06 14:53:22', NULL, NULL, 'routine', 'pending', '', NULL, 1, 'pending', NULL, NULL, NULL, NULL, NULL, '0.00', 1, '2025-07-06 16:53:22', '2025-07-06 16:53:22', NULL, NULL, NULL, 'pending', '0.00', NULL, '0.00', NULL, NULL);
INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (14, 133, 3, NULL, NULL, '2025-07-06 15:16:27', NULL, NULL, 'routine', 'pending', '', NULL, 1, 'pending', NULL, NULL, NULL, NULL, NULL, '0.00', 1, '2025-07-06 17:16:27', '2025-07-06 17:16:27', NULL, NULL, NULL, 'pending', '0.00', NULL, '0.00', NULL, NULL);
INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (15, 133, 3, NULL, NULL, '2025-07-07 19:37:38', NULL, NULL, 'routine', 'pending', '', NULL, 1, 'pending', NULL, NULL, NULL, NULL, NULL, '0.00', 1, '2025-07-07 21:37:38', '2025-07-07 21:37:38', NULL, NULL, NULL, 'pending', '0.00', NULL, '0.00', NULL, NULL);
INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (16, 131, 3, NULL, NULL, '2025-07-08 07:16:47', NULL, NULL, 'routine', 'pending', '', NULL, 1, 'pending', NULL, NULL, NULL, NULL, NULL, '197.20', 1, '2025-07-08 06:16:47', '2025-07-08 06:16:47', NULL, NULL, NULL, 'pending', '0.00', NULL, '0.00', NULL, NULL);
INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (17, 131, 3, NULL, NULL, '2025-07-08 07:18:30', NULL, NULL, 'routine', 'pending', '', NULL, 1, 'pending', NULL, NULL, NULL, NULL, NULL, '197.20', 1, '2025-07-08 06:18:30', '2025-07-08 06:18:30', NULL, NULL, NULL, 'pending', '0.00', NULL, '0.00', NULL, NULL);
INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (18, 134, 3, NULL, NULL, '2025-07-10 20:34:24', NULL, NULL, 'routine', 'pending', '', NULL, 1, '', NULL, NULL, NULL, NULL, NULL, '464.00', 1, '2025-07-10 19:34:24', '2025-07-10 19:34:24', 'workflow_bypass', NULL, NULL, 'pending', '0.00', NULL, '0.00', NULL, NULL);
INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (19, 133, 3, NULL, NULL, '2025-07-11 04:05:14', NULL, NULL, 'routine', 'pending', '', NULL, 1, '', NULL, NULL, NULL, NULL, NULL, '5800.00', 1, '2025-07-11 03:05:14', '2025-07-11 03:05:14', 'secugen_biometric', '182.00', NULL, 'pending', '0.00', NULL, '0.00', NULL, NULL);
INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (20, 133, 2, 1, NULL, '2025-07-11 04:07:34', '2025-07-18', NULL, 'routine', 'in_progress', '', NULL, 1, '', NULL, NULL, '2025-07-11 05:09:36', NULL, NULL, '5800.00', 1, '2025-07-11 03:07:34', '2025-07-11 04:09:36', 'secugen_biometric', '199.00', NULL, 'pending', '0.00', NULL, '0.00', NULL, NULL);
INSERT INTO `radiology_orders` (`id`, `patient_id`, `referring_doctor_id`, `technician_id`, `radiologist_id`, `order_date`, `scheduled_date`, `scheduled_time`, `priority`, `status`, `clinical_notes`, `technician_notes`, `verification_required`, `verification_status`, `verification_timestamp`, `verified_by`, `started_at`, `completed_at`, `reported_at`, `total_amount`, `created_by`, `created_at`, `updated_at`, `verification_method`, `verification_score`, `journal_id`, `payment_status`, `paid_amount`, `payment_date`, `refund_amount`, `refund_date`, `refund_reason`) VALUES (22, 133, 3, 1, NULL, '2025-07-11 04:15:34', '2025-07-12', '10:00:00', 'routine', 'in_progress', 'Testing', NULL, 1, '', NULL, NULL, '2025-07-11 05:01:21', NULL, NULL, '5800.00', 1, '2025-07-11 03:15:34', '2025-07-11 04:01:21', 'manual_override', NULL, 4, 'pending', '0.00', NULL, '0.00', NULL, NULL);


#
# TABLE STRUCTURE FOR: radiology_parameter
#

DROP TABLE IF EXISTS `radiology_parameter`;

CREATE TABLE `radiology_parameter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parameter_name` varchar(100) NOT NULL,
  `test_value` varchar(100) NOT NULL,
  `reference_range` varchar(100) NOT NULL,
  `range_from` varchar(500) DEFAULT NULL,
  `range_to` varchar(500) DEFAULT NULL,
  `gender` varchar(100) NOT NULL,
  `unit` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_parameter_name` (`parameter_name`),
  KEY `index_test_value` (`test_value`),
  KEY `index_reference_range` (`reference_range`),
  KEY `index_range_from` (`range_from`),
  KEY `index_range_to` (`range_to`),
  KEY `index_gender` (`gender`),
  KEY `index_unit` (`unit`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `radiology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `range_from`, `range_to`, `gender`, `unit`, `description`, `created_at`) VALUES (1, 'Findings', '', 'Normal', NULL, NULL, 'Both', '1', 'Radiological findings', '2025-06-28 19:37:12');
INSERT INTO `radiology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `range_from`, `range_to`, `gender`, `unit`, `description`, `created_at`) VALUES (2, 'Impression', '', 'Normal', NULL, NULL, 'Both', '1', 'Radiologist impression', '2025-06-28 19:37:12');
INSERT INTO `radiology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `range_from`, `range_to`, `gender`, `unit`, `description`, `created_at`) VALUES (3, 'Recommendation', '', 'As needed', NULL, NULL, 'Both', '1', 'Recommended follow-up', '2025-06-28 19:37:12');


#
# TABLE STRUCTURE FOR: radiology_parameterdetails
#

DROP TABLE IF EXISTS `radiology_parameterdetails`;

CREATE TABLE `radiology_parameterdetails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `radiology_id` int(11) DEFAULT NULL,
  `radiology_parameter_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `radiology_id` (`radiology_id`),
  KEY `radiology_parameter_id` (`radiology_parameter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: radiology_quality_metrics
#

DROP TABLE IF EXISTS `radiology_quality_metrics`;

CREATE TABLE `radiology_quality_metrics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `equipment_id` int(11) DEFAULT NULL,
  `technician_id` int(11) DEFAULT NULL,
  `image_quality_score` int(11) DEFAULT NULL,
  `positioning_score` int(11) DEFAULT NULL,
  `artifact_present` tinyint(1) DEFAULT 0,
  `artifact_type` varchar(100) DEFAULT NULL,
  `repeat_required` tinyint(1) DEFAULT 0,
  `repeat_reason` varchar(200) DEFAULT NULL,
  `radiation_dose` varchar(50) DEFAULT NULL,
  `contrast_volume` varchar(50) DEFAULT NULL,
  `patient_cooperation` enum('excellent','good','fair','poor') DEFAULT 'good',
  `technical_factors` text DEFAULT NULL,
  `quality_notes` text DEFAULT NULL,
  `reviewed_by` int(11) DEFAULT NULL,
  `review_date` datetime DEFAULT NULL,
  `approved` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_order` (`order_id`),
  KEY `idx_equipment` (`equipment_id`),
  KEY `idx_technician` (`technician_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: radiology_report
#

DROP TABLE IF EXISTS `radiology_report`;

CREATE TABLE `radiology_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `radiology_bill_id` int(11) DEFAULT NULL,
  `radiology_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `customer_type` varchar(50) DEFAULT NULL,
  `patient_name` varchar(100) DEFAULT NULL,
  `consultant_doctor` varchar(10) NOT NULL,
  `reporting_date` date DEFAULT NULL,
  `parameter_update` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `radiology_report` text DEFAULT NULL,
  `report_name` text DEFAULT NULL,
  `radiology_result` text DEFAULT NULL COMMENT 'test result',
  `tax_percentage` float(10,2) NOT NULL DEFAULT 0.00,
  `apply_charge` float(10,2) NOT NULL DEFAULT 0.00,
  `radiology_center` varchar(250) NOT NULL,
  `generated_by` int(11) DEFAULT NULL,
  `collection_specialist` int(11) DEFAULT NULL,
  `collection_date` date DEFAULT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `radiology_id` (`radiology_id`),
  KEY `radiology_bill_id` (`radiology_bill_id`),
  KEY `patient_id` (`patient_id`),
  KEY `generated_by` (`generated_by`),
  KEY `collection_specialist` (`collection_specialist`),
  KEY `approved_by` (`approved_by`),
  KEY `index_customer_type` (`customer_type`),
  KEY `index_patient_name` (`patient_name`),
  KEY `index_consultant_doctor` (`consultant_doctor`),
  KEY `index_reporting_date` (`reporting_date`),
  KEY `index_parameter_update` (`parameter_update`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_apply_charge` (`apply_charge`),
  KEY `index_radiology_center` (`radiology_center`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: radiology_report_parameterdetails
#

DROP TABLE IF EXISTS `radiology_report_parameterdetails`;

CREATE TABLE `radiology_report_parameterdetails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `radiology_report_id` int(11) DEFAULT NULL,
  `radiology_parameterdetail_id` int(11) DEFAULT NULL,
  `radiology_report_value` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `radiology_report_id` (`radiology_report_id`),
  KEY `radiology_parameterdetail_id` (`radiology_parameterdetail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: radiology_reports
#

DROP TABLE IF EXISTS `radiology_reports`;

CREATE TABLE `radiology_reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `radiology_order_id` int(11) NOT NULL,
  `radiologist_id` int(11) NOT NULL,
  `report_template_id` int(11) DEFAULT NULL,
  `clinical_history` text DEFAULT NULL,
  `technique` text DEFAULT NULL,
  `findings` text NOT NULL,
  `impression` text NOT NULL,
  `recommendations` text DEFAULT NULL,
  `report_status` enum('draft','preliminary','final','amended') DEFAULT 'draft',
  `dictated_at` datetime DEFAULT NULL,
  `transcribed_at` datetime DEFAULT NULL,
  `verified_at` datetime DEFAULT NULL,
  `report_date` datetime DEFAULT NULL,
  `priority` enum('routine','urgent','stat') DEFAULT 'routine',
  `critical_result` tinyint(1) DEFAULT 0,
  `critical_notified` tinyint(1) DEFAULT 0,
  `critical_notification_time` datetime DEFAULT NULL,
  `word_count` int(11) DEFAULT 0,
  `report_attachments` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_order` (`radiology_order_id`),
  KEY `idx_radiologist` (`radiologist_id`),
  KEY `idx_status` (`report_status`),
  KEY `idx_critical` (`critical_result`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: radiology_scheduling
#

DROP TABLE IF EXISTS `radiology_scheduling`;

CREATE TABLE `radiology_scheduling` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `equipment_id` int(11) DEFAULT NULL,
  `technician_id` int(11) DEFAULT NULL,
  `scheduled_date` date NOT NULL,
  `scheduled_time` time NOT NULL,
  `estimated_duration` int(11) DEFAULT 30,
  `appointment_type` enum('routine','urgent','stat','follow_up') DEFAULT 'routine',
  `status` enum('scheduled','confirmed','in_progress','completed','cancelled','no_show') DEFAULT 'scheduled',
  `prep_time` int(11) DEFAULT 15,
  `patient_arrived_at` datetime DEFAULT NULL,
  `exam_started_at` datetime DEFAULT NULL,
  `exam_completed_at` datetime DEFAULT NULL,
  `delay_reason` varchar(200) DEFAULT NULL,
  `scheduling_notes` text DEFAULT NULL,
  `patient_instructions` text DEFAULT NULL,
  `reminder_sent` tinyint(1) DEFAULT 0,
  `reminder_sent_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_schedule` (`equipment_id`,`scheduled_date`,`scheduled_time`),
  KEY `idx_order` (`order_id`),
  KEY `idx_equipment` (`equipment_id`),
  KEY `idx_technician` (`technician_id`),
  KEY `idx_date_time` (`scheduled_date`,`scheduled_time`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: radiology_templates
#

DROP TABLE IF EXISTS `radiology_templates`;

CREATE TABLE `radiology_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_name` varchar(200) NOT NULL,
  `test_type` varchar(100) NOT NULL,
  `body_part` varchar(100) DEFAULT NULL,
  `template_content` text NOT NULL,
  `findings_template` text DEFAULT NULL,
  `impression_template` text DEFAULT NULL,
  `recommendations_template` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_test_type` (`test_type`),
  KEY `idx_body_part` (`body_part`),
  KEY `idx_active` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `radiology_templates` (`id`, `template_name`, `test_type`, `body_part`, `template_content`, `findings_template`, `impression_template`, `recommendations_template`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (1, 'Chest X-Ray Normal', 'X-Ray', 'Chest', 'Standard chest radiograph in PA and lateral views', 'The lungs are clear bilaterally. Heart size is normal. No pleural effusion or pneumothorax.', 'Normal chest radiograph.', NULL, 1, NULL, '2025-07-01 13:20:12', '2025-07-01 13:20:12');
INSERT INTO `radiology_templates` (`id`, `template_name`, `test_type`, `body_part`, `template_content`, `findings_template`, `impression_template`, `recommendations_template`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (2, 'CT Head Normal', 'CT Scan', 'Head', 'Non-contrast CT scan of the head', 'No acute intracranial abnormality. Normal brain parenchyma. No mass effect or midline shift.', 'Normal non-contrast CT head.', NULL, 1, NULL, '2025-07-01 13:20:12', '2025-07-01 13:20:12');
INSERT INTO `radiology_templates` (`id`, `template_name`, `test_type`, `body_part`, `template_content`, `findings_template`, `impression_template`, `recommendations_template`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (3, 'Abdominal Ultrasound', 'Ultrasound', 'Abdomen', 'Real-time ultrasound examination of the abdomen', 'Liver, gallbladder, pancreas, spleen, and kidneys appear normal in size and echogenicity.', 'Normal abdominal ultrasound.', NULL, 1, NULL, '2025-07-01 13:20:12', '2025-07-01 13:20:12');
INSERT INTO `radiology_templates` (`id`, `template_name`, `test_type`, `body_part`, `template_content`, `findings_template`, `impression_template`, `recommendations_template`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (4, 'Chest X-Ray Normal', 'X-Ray', 'Chest', 'Standard chest radiograph in PA and lateral views', 'The lungs are clear bilaterally. Heart size is normal. No pleural effusion or pneumothorax.', 'Normal chest radiograph.', NULL, 1, NULL, '2025-07-01 13:21:08', '2025-07-01 13:21:08');
INSERT INTO `radiology_templates` (`id`, `template_name`, `test_type`, `body_part`, `template_content`, `findings_template`, `impression_template`, `recommendations_template`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (5, 'CT Head Normal', 'CT Scan', 'Head', 'Non-contrast CT scan of the head', 'No acute intracranial abnormality. Normal brain parenchyma. No mass effect or midline shift.', 'Normal non-contrast CT head.', NULL, 1, NULL, '2025-07-01 13:21:08', '2025-07-01 13:21:08');
INSERT INTO `radiology_templates` (`id`, `template_name`, `test_type`, `body_part`, `template_content`, `findings_template`, `impression_template`, `recommendations_template`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (6, 'Abdominal Ultrasound', 'Ultrasound', 'Abdomen', 'Real-time ultrasound examination of the abdomen', 'Liver, gallbladder, pancreas, spleen, and kidneys appear normal in size and echogenicity.', 'Normal abdominal ultrasound.', NULL, 1, NULL, '2025-07-01 13:21:08', '2025-07-01 13:21:08');
INSERT INTO `radiology_templates` (`id`, `template_name`, `test_type`, `body_part`, `template_content`, `findings_template`, `impression_template`, `recommendations_template`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (7, 'Chest X-Ray Normal', 'X-Ray', 'Chest', 'Standard chest radiograph in PA and lateral views', 'The lungs are clear bilaterally. Heart size is normal. No pleural effusion or pneumothorax.', 'Normal chest radiograph.', NULL, 1, NULL, '2025-07-01 13:21:25', '2025-07-01 13:21:25');
INSERT INTO `radiology_templates` (`id`, `template_name`, `test_type`, `body_part`, `template_content`, `findings_template`, `impression_template`, `recommendations_template`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (8, 'CT Head Normal', 'CT Scan', 'Head', 'Non-contrast CT scan of the head', 'No acute intracranial abnormality. Normal brain parenchyma. No mass effect or midline shift.', 'Normal non-contrast CT head.', NULL, 1, NULL, '2025-07-01 13:21:25', '2025-07-01 13:21:25');
INSERT INTO `radiology_templates` (`id`, `template_name`, `test_type`, `body_part`, `template_content`, `findings_template`, `impression_template`, `recommendations_template`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (9, 'Abdominal Ultrasound', 'Ultrasound', 'Abdomen', 'Real-time ultrasound examination of the abdomen', 'Liver, gallbladder, pancreas, spleen, and kidneys appear normal in size and echogenicity.', 'Normal abdominal ultrasound.', NULL, 1, NULL, '2025-07-01 13:21:25', '2025-07-01 13:21:25');
INSERT INTO `radiology_templates` (`id`, `template_name`, `test_type`, `body_part`, `template_content`, `findings_template`, `impression_template`, `recommendations_template`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (10, 'Chest X-Ray Normal', 'X-Ray', 'Chest', 'Standard chest radiograph in PA and lateral views', 'The lungs are clear bilaterally. Heart size is normal. No pleural effusion or pneumothorax.', 'Normal chest radiograph.', NULL, 1, NULL, '2025-07-01 13:21:41', '2025-07-01 13:21:41');
INSERT INTO `radiology_templates` (`id`, `template_name`, `test_type`, `body_part`, `template_content`, `findings_template`, `impression_template`, `recommendations_template`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (11, 'CT Head Normal', 'CT Scan', 'Head', 'Non-contrast CT scan of the head', 'No acute intracranial abnormality. Normal brain parenchyma. No mass effect or midline shift.', 'Normal non-contrast CT head.', NULL, 1, NULL, '2025-07-01 13:21:41', '2025-07-01 13:21:41');
INSERT INTO `radiology_templates` (`id`, `template_name`, `test_type`, `body_part`, `template_content`, `findings_template`, `impression_template`, `recommendations_template`, `is_active`, `created_by`, `created_at`, `updated_at`) VALUES (12, 'Abdominal Ultrasound', 'Ultrasound', 'Abdomen', 'Real-time ultrasound examination of the abdomen', 'Liver, gallbladder, pancreas, spleen, and kidneys appear normal in size and echogenicity.', 'Normal abdominal ultrasound.', NULL, 1, NULL, '2025-07-01 13:21:41', '2025-07-01 13:21:41');


#
# TABLE STRUCTURE FOR: radiology_tests
#

DROP TABLE IF EXISTS `radiology_tests`;

CREATE TABLE `radiology_tests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_name` varchar(200) NOT NULL,
  `test_code` varchar(50) NOT NULL,
  `category` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `preparation_instructions` text DEFAULT NULL,
  `estimated_duration` int(11) DEFAULT 30,
  `price` decimal(10,2) DEFAULT 0.00,
  `is_active` tinyint(1) DEFAULT 1,
  `is_gcc` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Flag for GCC workflow tests (1=GCC, 0=Regular)',
  `requires_contrast` tinyint(1) DEFAULT 0,
  `requires_fasting` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `test_code` (`test_code`),
  KEY `idx_category` (`category`),
  KEY `idx_active` (`is_active`),
  KEY `idx_is_gcc` (`is_gcc`),
  KEY `idx_active_gcc` (`is_active`,`is_gcc`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `radiology_tests` (`id`, `test_name`, `test_code`, `category`, `description`, `preparation_instructions`, `estimated_duration`, `price`, `is_active`, `is_gcc`, `requires_contrast`, `requires_fasting`, `created_at`, `updated_at`) VALUES (1, 'Chest X-Ray', 'XRAY_CHEST', 'X-Ray', 'Standard chest radiograph', 'Remove all metal objects and jewelry from chest area', 15, '5000.00', 1, 1, 0, 0, '2025-07-01 13:19:10', '2025-07-10 06:32:55');
INSERT INTO `radiology_tests` (`id`, `test_name`, `test_code`, `category`, `description`, `preparation_instructions`, `estimated_duration`, `price`, `is_active`, `is_gcc`, `requires_contrast`, `requires_fasting`, `created_at`, `updated_at`) VALUES (2, 'Abdominal X-Ray', 'XRAY_ABD', 'X-Ray', 'Abdominal radiograph', 'No special preparation required', 15, '60.00', 1, 0, 0, 0, '2025-07-01 13:19:10', '2025-07-10 03:46:04');
INSERT INTO `radiology_tests` (`id`, `test_name`, `test_code`, `category`, `description`, `preparation_instructions`, `estimated_duration`, `price`, `is_active`, `is_gcc`, `requires_contrast`, `requires_fasting`, `created_at`, `updated_at`) VALUES (3, 'CT Scan Head', 'CT_HEAD', 'CT Scan', 'Computed tomography of head', 'Remove all metal objects', 30, '300.00', 1, 0, 0, 0, '2025-07-01 13:19:10', '2025-07-10 03:46:10');
INSERT INTO `radiology_tests` (`id`, `test_name`, `test_code`, `category`, `description`, `preparation_instructions`, `estimated_duration`, `price`, `is_active`, `is_gcc`, `requires_contrast`, `requires_fasting`, `created_at`, `updated_at`) VALUES (4, 'CT Scan Abdomen', 'CT_ABD', 'CT Scan', 'Abdominal CT scan', 'Fast for 4 hours before exam', 45, '400.00', 1, 0, 1, 1, '2025-07-01 13:19:10', '2025-07-01 13:19:10');
INSERT INTO `radiology_tests` (`id`, `test_name`, `test_code`, `category`, `description`, `preparation_instructions`, `estimated_duration`, `price`, `is_active`, `is_gcc`, `requires_contrast`, `requires_fasting`, `created_at`, `updated_at`) VALUES (5, 'MRI Brain', 'MRI_BRAIN', 'MRI', 'Magnetic resonance imaging of brain', 'Remove all metal objects, inform about implants', 60, '600.00', 1, 0, 0, 0, '2025-07-01 13:19:10', '2025-07-01 13:19:10');
INSERT INTO `radiology_tests` (`id`, `test_name`, `test_code`, `category`, `description`, `preparation_instructions`, `estimated_duration`, `price`, `is_active`, `is_gcc`, `requires_contrast`, `requires_fasting`, `created_at`, `updated_at`) VALUES (6, 'MRI Spine', 'MRI_SPINE', 'MRI', 'Spinal MRI scan', 'Remove all metal objects, comfortable clothing', 45, '650.00', 1, 0, 0, 0, '2025-07-01 13:19:10', '2025-07-01 13:19:10');
INSERT INTO `radiology_tests` (`id`, `test_name`, `test_code`, `category`, `description`, `preparation_instructions`, `estimated_duration`, `price`, `is_active`, `is_gcc`, `requires_contrast`, `requires_fasting`, `created_at`, `updated_at`) VALUES (7, 'Ultrasound Abdomen', 'US_ABD', 'Ultrasound', 'Abdominal ultrasonography', 'Fast for 6-8 hours, full bladder', 30, '80.00', 1, 0, 0, 1, '2025-07-01 13:19:10', '2025-07-10 03:46:14');
INSERT INTO `radiology_tests` (`id`, `test_name`, `test_code`, `category`, `description`, `preparation_instructions`, `estimated_duration`, `price`, `is_active`, `is_gcc`, `requires_contrast`, `requires_fasting`, `created_at`, `updated_at`) VALUES (8, 'Ultrasound Pelvis', 'US_PELVIS', 'Ultrasound', 'Pelvic ultrasound', 'Full bladder required', 25, '90.00', 1, 0, 0, 0, '2025-07-01 13:19:10', '2025-07-01 13:19:10');
INSERT INTO `radiology_tests` (`id`, `test_name`, `test_code`, `category`, `description`, `preparation_instructions`, `estimated_duration`, `price`, `is_active`, `is_gcc`, `requires_contrast`, `requires_fasting`, `created_at`, `updated_at`) VALUES (9, 'Mammography', 'MAMMO', 'Mammography', 'Breast imaging', 'No deodorant, powder, or lotion on chest area', 20, '120.00', 1, 0, 0, 0, '2025-07-01 13:19:10', '2025-07-01 13:19:10');
INSERT INTO `radiology_tests` (`id`, `test_name`, `test_code`, `category`, `description`, `preparation_instructions`, `estimated_duration`, `price`, `is_active`, `is_gcc`, `requires_contrast`, `requires_fasting`, `created_at`, `updated_at`) VALUES (10, 'Bone Density Scan', 'DEXA', 'Special', 'DEXA scan for bone density', 'No calcium supplements 24 hours before', 30, '100.00', 1, 0, 0, 0, '2025-07-01 13:19:10', '2025-07-01 13:19:10');


#
# TABLE STRUCTURE FOR: read_notification
#

DROP TABLE IF EXISTS `read_notification`;

CREATE TABLE `read_notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `notification_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `read_notification` (`id`, `staff_id`, `notification_id`, `is_active`, `created_at`) VALUES (1, 1, 1, 'no', '2025-07-04 09:09:53');


#
# TABLE STRUCTURE FOR: read_systemnotification
#

DROP TABLE IF EXISTS `read_systemnotification`;

CREATE TABLE `read_systemnotification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `notification_id` int(11) DEFAULT NULL,
  `receiver_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `notification_id` (`notification_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: recurring_journal_entries
#

DROP TABLE IF EXISTS `recurring_journal_entries`;

CREATE TABLE `recurring_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_prefix` varchar(20) NOT NULL,
  `description` text NOT NULL,
  `frequency` enum('daily','weekly','monthly','quarterly','yearly') NOT NULL,
  `next_run_date` date NOT NULL,
  `last_run_date` date DEFAULT NULL,
  `run_count` int(11) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `next_run_date` (`next_run_date`),
  KEY `is_active` (`is_active`),
  KEY `frequency` (`frequency`),
  KEY `fk_recurring_creator` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: recurring_journal_lines
#

DROP TABLE IF EXISTS `recurring_journal_lines`;

CREATE TABLE `recurring_journal_lines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `recurring_entry_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `debit_amount` decimal(15,2) DEFAULT 0.00,
  `credit_amount` decimal(15,2) DEFAULT 0.00,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recurring_entry_id` (`recurring_entry_id`),
  KEY `account_id` (`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: referral_category
#

DROP TABLE IF EXISTS `referral_category`;

CREATE TABLE `referral_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `is_active` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: referral_commission
#

DROP TABLE IF EXISTS `referral_commission`;

CREATE TABLE `referral_commission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `referral_category_id` int(11) DEFAULT NULL,
  `referral_type_id` int(11) DEFAULT NULL,
  `commission` float DEFAULT NULL,
  `is_active` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `referral_category_id` (`referral_category_id`),
  KEY `referral_type_id` (`referral_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: referral_payment
#

DROP TABLE IF EXISTS `referral_payment`;

CREATE TABLE `referral_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `referral_person_id` int(11) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `referral_type` int(11) DEFAULT NULL,
  `billing_id` int(11) NOT NULL,
  `bill_amount` float(10,2) DEFAULT 0.00,
  `percentage` float(10,2) DEFAULT 0.00,
  `amount` float(10,2) DEFAULT 0.00,
  `date` datetime NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `referral_person_id` (`referral_person_id`),
  KEY `referral_type` (`referral_type`),
  KEY `index_bill_amount` (`bill_amount`),
  KEY `index_percentage` (`percentage`),
  KEY `index_amount` (`amount`),
  KEY `index_date` (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: referral_person
#

DROP TABLE IF EXISTS `referral_person`;

CREATE TABLE `referral_person` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `contact` varchar(20) DEFAULT NULL,
  `person_name` varchar(100) DEFAULT NULL,
  `person_phone` varchar(50) DEFAULT NULL,
  `standard_commission` float(10,2) NOT NULL DEFAULT 0.00,
  `address` varchar(100) DEFAULT NULL,
  `is_active` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `referral_category` (`category_id`),
  KEY `index_name` (`name`),
  KEY `index_contact` (`contact`),
  KEY `index_person_name` (`person_name`),
  KEY `index_person_phone` (`person_phone`),
  KEY `index_standard_commission` (`standard_commission`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: referral_person_commission
#

DROP TABLE IF EXISTS `referral_person_commission`;

CREATE TABLE `referral_person_commission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `referral_person_id` int(11) DEFAULT NULL,
  `referral_type_id` int(11) DEFAULT NULL,
  `commission` float(10,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `referral_person_id` (`referral_person_id`),
  KEY `referral_type_id` (`referral_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: referral_type
#

DROP TABLE IF EXISTS `referral_type`;

CREATE TABLE `referral_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `prefixes_type` varchar(100) NOT NULL,
  `is_active` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `index_name` (`name`),
  KEY `index_prefixes_type` (`prefixes_type`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (1, 'opd', 'opd_no', 1, '2021-09-17 04:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (2, 'ipd', 'ipd_no', 1, '2021-09-17 04:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (3, 'pharmacy', 'pharmacy_billing', 1, '2021-09-17 04:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (4, 'pathology', 'pathology_billing', 1, '2021-09-17 04:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (5, 'radiology', 'radiology_billing', 1, '2021-09-17 04:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (6, 'blood_bank', 'blood_bank_billing', 1, '2021-09-17 04:07:51');
INSERT INTO `referral_type` (`id`, `name`, `prefixes_type`, `is_active`, `created_at`) VALUES (7, 'ambulance', 'ambulance_call_billing', 1, '2021-09-17 04:07:51');


#
# TABLE STRUCTURE FOR: roles
#

DROP TABLE IF EXISTS `roles`;

CREATE TABLE `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `slug` varchar(150) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `is_system` int(11) NOT NULL DEFAULT 0,
  `is_superadmin` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (1, 'Admin', NULL, 0, 1, 0, '2018-12-25 08:19:43');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (2, 'Accountant', NULL, 0, 1, 0, '2018-12-25 08:19:38');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (3, 'Doctor', NULL, 0, 1, 0, '2018-07-21 07:07:36');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (4, 'Pharmacist', NULL, 0, 1, 0, '2018-07-21 07:08:26');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (5, 'Pathologist', NULL, 0, 1, 0, '2018-12-25 08:19:59');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (6, 'Radiologist', NULL, 0, 1, 0, '2018-12-25 08:20:27');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (7, 'Super Admin', NULL, 0, 1, 1, '2018-12-25 08:22:24');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (8, 'Receptionist', NULL, 0, 1, 0, '2018-12-25 08:20:22');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (9, 'Nurse', NULL, 0, 1, 0, '2020-12-23 03:58:58');
INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`) VALUES (10, 'Lab Tech', NULL, 0, 1, 0, '2025-07-21 14:19:15');


#
# TABLE STRUCTURE FOR: roles_permissions
#

DROP TABLE IF EXISTS `roles_permissions`;

CREATE TABLE `roles_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) DEFAULT NULL,
  `perm_cat_id` int(11) DEFAULT NULL,
  `can_view` int(11) DEFAULT NULL,
  `can_add` int(11) DEFAULT NULL,
  `can_edit` int(11) DEFAULT NULL,
  `can_delete` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `index_can_view` (`can_view`),
  KEY `index_can_add` (`can_add`),
  KEY `index_can_edit` (`can_edit`),
  KEY `index_can_delete` (`can_delete`),
  KEY `role_id` (`role_id`),
  KEY `perm_cat_id` (`perm_cat_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2396 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (1, 1, 346, 1, 0, 0, 0, '2021-09-15 04:19:21');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (2, 1, 80, 1, 1, 1, 1, '2021-09-15 04:31:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (3, 1, 81, 1, 1, 1, 1, '2021-09-15 04:31:34');
INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES (4, 1, 82, 1, 1, 1, 1, '2021-09-15 04:31:34');
INSERT INTO `roles_permissions` (`id`, `role_id