<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-heartbeat"></i> Wellness Visit Details <small><?php echo $visit->visit_reference; ?></small></h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url('admin/wellness'); ?>">Wellness</a></li>
            <li class="active">Visit Details</li>
        </ol>
    </section>

    <section class="content">
        <?php echo $this->session->flashdata('msg'); ?>
        
        <div class="row">
            <!-- Patient Information -->
            <div class="col-md-8">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-user"></i> Patient Information</h3>
                        <div class="box-tools pull-right">
                            <span class="label label-primary"><?php echo $visit->visit_reference; ?></span>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-striped">
                                    <tr><th>Name:</th><td><?php echo $visit->patient_name; ?></td></tr>
                                    <tr><th>Age:</th><td><?php echo $visit->age ?: 'N/A'; ?></td></tr>
                                    <tr><th>Gender:</th><td><?php echo ucfirst($visit->gender); ?></td></tr>
                                    <tr><th>Phone:</th><td><?php echo $visit->phone_number ?: 'N/A'; ?></td></tr>
                                    <tr><th>National ID:</th><td><?php echo $visit->national_id ?: 'N/A'; ?></td></tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-striped">
                                    <tr><th>Location:</th><td><?php echo $visit->location; ?></td></tr>
                                    <tr><th>County:</th><td><?php echo $visit->county ?: 'N/A'; ?></td></tr>
                                    <tr><th>Sub County:</th><td><?php echo $visit->sub_county ?: 'N/A'; ?></td></tr>
                                    <tr><th>Village:</th><td><?php echo $visit->village ?: 'N/A'; ?></td></tr>
                                    <tr><th>Insurance:</th><td><?php echo strtoupper($visit->insurance_type); ?></td></tr>
                                </table>
                            </div>
                        </div>
                        
                        <?php if ($visit->chief_complaint): ?>
                        <div class="row">
                            <div class="col-md-12">
                                <h4>Chief Complaint:</h4>
                                <p class="well"><?php echo nl2br(htmlspecialchars($visit->chief_complaint)); ?></p>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Visit Summary -->
            <div class="col-md-4">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-money"></i> Visit Summary</h3>
                    </div>
                    <div class="box-body">
                        <table class="table">
                            <tr>
                                <th>Total Amount:</th>
                                <td>KSh <?php echo number_format($visit->total_amount, 2); ?></td>
                            </tr>
                            <tr>
                                <th>Amount Paid:</th>
                                <td>KSh <?php echo number_format($visit->amount_paid, 2); ?></td>
                            </tr>
                            <tr>
                                <th>Balance:</th>
                                <td class="<?php echo $visit->balance > 0 ? 'text-red' : 'text-green'; ?>">
                                    KSh <?php echo number_format($visit->balance, 2); ?>
                                </td>
                            </tr>
                            <tr>
                                <th>Payment Status:</th>
                                <td>
                                    <?php
                                    $status_class = array(
                                        'paid' => 'label-success',
                                        'partial' => 'label-warning',
                                        'pending' => 'label-danger'
                                    );
                                    ?>
                                    <span class="label <?php echo $status_class[$visit->payment_status]; ?>">
                                        <?php echo ucfirst($visit->payment_status); ?>
                                    </span>
                                </td>
                            </tr>
                        </table>
                        
                        <?php if ($visit->balance > 0): ?>
                        <button class="btn btn-success btn-block" data-toggle="modal" data-target="#payment-modal">
                            <i class="fa fa-money"></i> Process Payment
                        </button>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-info"></i> Visit Info</h3>
                    </div>
                    <div class="box-body">
                        <table class="table table-condensed">
                            <tr><th>Date:</th><td><?php echo date('Y-m-d', strtotime($visit->visit_date)); ?></td></tr>
                            <tr><th>Time:</th><td><?php echo date('H:i', strtotime($visit->visit_time)); ?></td></tr>
                            <tr><th>Served By:</th><td><?php echo $visit->served_by_name ?: 'N/A'; ?></td></tr>
                            <?php if ($visit->receipt_number): ?>
                            <tr><th>Receipt:</th><td><?php echo $visit->receipt_number; ?></td></tr>
                            <?php endif; ?>
                        </table>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-cogs"></i> Quick Actions</h3>
                    </div>
                    <div class="box-body">
                        <button class="btn btn-primary btn-block" onclick="printVisitSummary()">
                            <i class="fa fa-print"></i> Print Visit Summary
                        </button>
                        <button class="btn btn-info btn-block" onclick="generateReceipt()">
                            <i class="fa fa-file-text"></i> Generate Receipt
                        </button>
                        <button class="btn btn-warning btn-block" data-toggle="modal" data-target="#edit-visit-modal">
                            <i class="fa fa-edit"></i> Edit Visit Details
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Services Section -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-stethoscope"></i> Services Provided</h3>
                        <div class="box-tools pull-right">
                            <button class="btn btn-sm btn-primary" data-toggle="modal" data-target="#add-service-modal">
                                <i class="fa fa-plus"></i> Add Service
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (count($services) > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Service</th>
                                        <th>Type</th>
                                        <th>Quantity</th>
                                        <th>Unit Price</th>
                                        <th>Discount</th>
                                        <th>Tax</th>
                                        <th>Final Amount</th>
                                        <th>Provider</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($services as $service): ?>
                                    <tr>
                                        <td>
                                            <strong><?php echo $service->service_name; ?></strong>
                                            <?php if ($service->service_code): ?>
                                                <br><small class="text-muted"><?php echo $service->service_code; ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td><span class="label label-info"><?php echo ucfirst($service->service_type); ?></span></td>
                                        <td><?php echo $service->quantity; ?></td>
                                        <td>KSh <?php echo number_format($service->unit_price, 2); ?></td>
                                        <td>
                                            <?php if ($service->discount_amount > 0): ?>
                                                <?php echo $service->discount_percentage; ?>% 
                                                (KSh <?php echo number_format($service->discount_amount, 2); ?>)
                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ($service->tax_amount > 0): ?>
                                                <?php echo $service->tax_percentage; ?>% 
                                                (KSh <?php echo number_format($service->tax_amount, 2); ?>)
                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td><strong>KSh <?php echo number_format($service->final_amount, 2); ?></strong></td>
                                        <td><?php echo $service->provider_name ?: 'N/A'; ?></td>
                                        <td>
                                            <?php
                                            $service_status_class = array(
                                                'completed' => 'label-success',
                                                'pending' => 'label-warning',
                                                'cancelled' => 'label-danger'
                                            );
                                            ?>
                                            <span class="label <?php echo $service_status_class[$service->status]; ?>">
                                                <?php echo ucfirst($service->status); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-xs">
                                                <?php if ($service->status == 'pending'): ?>
                                                <button class="btn btn-success" onclick="updateServiceStatus(<?php echo $service->id; ?>, 'completed')" 
                                                        title="Mark as Completed">
                                                    <i class="fa fa-check"></i>
                                                </button>
                                                <?php endif; ?>
                                                
                                                <button class="btn btn-info" onclick="editService(<?php echo $service->id; ?>)" 
                                                        title="Edit Service">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                                
                                                <?php if ($service->status != 'completed'): ?>
                                                <button class="btn btn-danger" onclick="deleteService(<?php echo $service->id; ?>)" 
                                                        title="Delete Service">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php if ($service->notes): ?>
                                    <tr class="bg-gray">
                                        <td colspan="10">
                                            <small><i class="fa fa-comment"></i> <strong>Notes:</strong> <?php echo nl2br(htmlspecialchars($service->notes)); ?></small>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                    <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                    <tr class="bg-light-blue">
                                        <th colspan="6" class="text-right">TOTAL:</th>
                                        <th>KSh <?php echo number_format(array_sum(array_column($services, 'final_amount')), 2); ?></th>
                                        <th colspan="3"></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <?php else: ?>
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No services have been added to this visit yet.
                            <button class="btn btn-sm btn-primary pull-right" data-toggle="modal" data-target="#add-service-modal">
                                <i class="fa fa-plus"></i> Add First Service
                            </button>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Visit History -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-default collapsed-box">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-history"></i> Visit Timeline</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-plus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="timeline" id="visit-timeline">
                            <!-- Timeline will be populated by JavaScript -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Service Modal -->
<div class="modal fade" id="add-service-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
                <h4 class="modal-title"><i class="fa fa-plus"></i> Add Service</h4>
            </div>
            <?php echo form_open('admin/wellness/add_service'); ?>
            <input type="hidden" name="visit_id" value="<?php echo $visit->id; ?>">
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Service Type <span class="text-danger">*</span></label>
                            <select class="form-control" name="service_type" id="service_type" required>
                                <option value="">Select Service Type</option>
                                <option value="consultation">Consultation</option>
                                <option value="dental">Dental</option>
                                <option value="laboratory">Laboratory</option>
                                <option value="pharmacy">Pharmacy</option>
                                <option value="radiology">Radiology</option>
                                <option value="optical">Optical</option>
                                <option value="specialized">Specialized</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Service <span class="text-danger">*</span></label>
                            <select class="form-control" name="service_code" id="service_code" required>
                                <option value="">Select Service</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Service Name</label>
                            <input type="text" class="form-control" name="service_name" id="service_name" readonly>
                            <small class="text-muted">Auto-filled from service catalog or enter manually</small>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Quantity</label>
                            <input type="number" class="form-control" name="quantity" id="quantity" value="1" min="1">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Unit Price <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" name="unit_price" id="unit_price" step="0.01" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Discount %</label>
                            <input type="number" class="form-control" name="discount_percentage" id="discount_percentage" min="0" max="100" step="0.01">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Tax %</label>
                            <input type="number" class="form-control" name="tax_percentage" id="tax_percentage" min="0" max="100" step="0.01">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Provider</label>
                            <select class="form-control" name="provider_staff_id">
                                <option value="">Select Provider</option>
                                <?php foreach($staff as $staff_member): ?>
                                    <option value="<?php echo $staff_member['id']; ?>">
                                        <?php echo $staff_member['name'] . ' ' . $staff_member['surname']; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Status</label>
                            <select class="form-control" name="status">
                                <option value="pending">Pending</option>
                                <option value="completed">Completed</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label>Notes</label>
                    <textarea class="form-control" name="notes" rows="2" placeholder="Additional notes about this service"></textarea>
                </div>

                <!-- Calculation Preview -->
                <div class="alert alert-info" id="calculation-preview" style="display: none;">
                    <h5><i class="fa fa-calculator"></i> Calculation Preview:</h5>
                    <div id="calculation-details"></div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary">
                    <i class="fa fa-save"></i> Add Service
                </button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<!-- Payment Modal -->
<div class="modal fade" id="payment-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
                <h4 class="modal-title"><i class="fa fa-money"></i> Process Payment</h4>
            </div>
            <?php echo form_open('admin/wellness/process_payment'); ?>
            <input type="hidden" name="visit_id" value="<?php echo $visit->id; ?>">
            <div class="modal-body">
                <div class="alert alert-info">
                    <strong>Outstanding Balance:</strong> KSh <?php echo number_format($visit->balance, 2); ?>
                </div>

                <div class="form-group">
                    <label>Payment Amount <span class="text-danger">*</span></label>
                    <input type="number" class="form-control" name="amount" step="0.01" 
                           max="<?php echo $visit->balance; ?>" value="<?php echo $visit->balance; ?>" required>
                    <small class="text-muted">Maximum: KSh <?php echo number_format($visit->balance, 2); ?></small>
                </div>

                <div class="form-group">
                    <label>Payment Method <span class="text-danger">*</span></label>
                    <select class="form-control" name="payment_method" required>
                        <option value="cash">Cash</option>
                        <option value="mpesa">M-Pesa</option>
                        <option value="card">Card</option>
                        <option value="bank_transfer">Bank Transfer</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Receipt Number</label>
                    <input type="text" class="form-control" name="receipt_number" 
                           placeholder="Auto-generated if left blank">
                    <small class="text-muted">Leave blank to auto-generate</small>
                </div>

                <div class="form-group">
                    <label>Payment Notes</label>
                    <textarea class="form-control" name="payment_notes" rows="2" 
                              placeholder="Additional payment information"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-success">
                    <i class="fa fa-money"></i> Process Payment
                </button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<!-- Edit Visit Modal -->
<div class="modal fade" id="edit-visit-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
                <h4 class="modal-title"><i class="fa fa-edit"></i> Edit Visit Details</h4>
            </div>
            <?php echo form_open('admin/wellness/update_visit'); ?>
            <input type="hidden" name="visit_id" value="<?php echo $visit->id; ?>">
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Patient Name</label>
                            <input type="text" class="form-control" name="patient_name" value="<?php echo $visit->patient_name; ?>" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Age</label>
                            <input type="number" class="form-control" name="age" value="<?php echo $visit->age; ?>" min="0" max="150">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Gender</label>
                            <select class="form-control" name="gender" required>
                                <option value="male" <?php echo ($visit->gender == 'male') ? 'selected' : ''; ?>>Male</option>
                                <option value="female" <?php echo ($visit->gender == 'female') ? 'selected' : ''; ?>>Female</option>
                                <option value="other" <?php echo ($visit->gender == 'other') ? 'selected' : ''; ?>>Other</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Phone Number</label>
                            <input type="text" class="form-control" name="phone_number" value="<?php echo $visit->phone_number; ?>">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>National ID</label>
                            <input type="text" class="form-control" name="national_id" value="<?php echo $visit->national_id; ?>">
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label>Chief Complaint</label>
                    <textarea class="form-control" name="chief_complaint" rows="3"><?php echo $visit->chief_complaint; ?></textarea>
                </div>

                <div class="form-group">
                    <label>Notes</label>
                    <textarea class="form-control" name="notes" rows="2"><?php echo $visit->notes; ?></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-warning">
                    <i class="fa fa-save"></i> Update Visit
                </button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Load visit timeline
    loadVisitTimeline();
    
    // Service type change handler
    $('#service_type').change(function() {
        var serviceType = $(this).val();
        if (serviceType) {
            loadServices(serviceType);
        } else {
            $('#service_code').empty().append('<option value="">Select Service</option>');
            $('#service_name').val('');
            $('#unit_price').val('');
        }
    });

    // Service selection change handler
    $('#service_code').change(function() {
        var serviceCode = $(this).val();
        if (serviceCode) {
            loadServicePrice(serviceCode);
        }
    });

    // Calculate preview when values change
    $('#quantity, #unit_price, #discount_percentage, #tax_percentage').on('input', function() {
        calculateServiceTotal();
    });
});

function loadServices(serviceType) {
    $.ajax({
        url: '<?php echo base_url("admin/wellness/get_services_by_type"); ?>',
        type: 'GET',
        data: { service_type: serviceType },
        dataType: 'json',
        success: function(data) {
            var select = $('#service_code');
            select.empty().append('<option value="">Select Service</option>');
            
            $.each(data, function(index, service) {
                select.append('<option value="' + service.service_code + '" data-name="' + service.service_name + '">' + 
                            service.service_name + ' (KSh ' + parseFloat(service.standard_price).toLocaleString() + ')</option>');
            });
        },
        error: function() {
            alert('Error loading services');
        }
    });
}

function loadServicePrice(serviceCode) {
    $.ajax({
        url: '<?php echo base_url("admin/wellness/get_service_price"); ?>',
        type: 'GET',
        data: { service_code: serviceCode },
        dataType: 'json',
        success: function(data) {
            if (data.success) {
                $('#unit_price').val(data.price);
                $('#service_name').val(data.name);
                calculateServiceTotal();
            }
        },
        error: function() {
            alert('Error loading service price');
        }
    });
}

function calculateServiceTotal() {
    var quantity = parseFloat($('#quantity').val()) || 1;
    var unitPrice = parseFloat($('#unit_price').val()) || 0;
    var discountPercentage = parseFloat($('#discount_percentage').val()) || 0;
    var taxPercentage = parseFloat($('#tax_percentage').val()) || 0;
    
    var totalPrice = quantity * unitPrice;
    var discountAmount = (totalPrice * discountPercentage) / 100;
    var taxableAmount = totalPrice - discountAmount;
    var taxAmount = (taxableAmount * taxPercentage) / 100;
    var finalAmount = taxableAmount + taxAmount;
    
    var previewHtml = 
        '<div class="row">' +
        '<div class="col-md-3"><strong>Subtotal:</strong><br>KSh ' + totalPrice.toLocaleString('en', {minimumFractionDigits: 2}) + '</div>' +
        '<div class="col-md-3"><strong>Discount:</strong><br>KSh ' + discountAmount.toLocaleString('en', {minimumFractionDigits: 2}) + '</div>' +
        '<div class="col-md-3"><strong>Tax:</strong><br>KSh ' + taxAmount.toLocaleString('en', {minimumFractionDigits: 2}) + '</div>' +
        '<div class="col-md-3"><strong>Final Total:</strong><br><span class="text-green">KSh ' + finalAmount.toLocaleString('en', {minimumFractionDigits: 2}) + '</span></div>' +
        '</div>';
    
    $('#calculation-details').html(previewHtml);
    $('#calculation-preview').show();
}

function updateServiceStatus(serviceId, status) {
    if (confirm('Are you sure you want to mark this service as ' + status + '?')) {
        $.ajax({
            url: '<?php echo base_url("admin/wellness/update_service_status"); ?>',
            type: 'POST',
            data: { 
                service_id: serviceId, 
                status: status 
            },
            dataType: 'json',
            success: function(data) {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Error updating service status');
                }
            },
            error: function() {
                alert('Error updating service status');
            }
        });
    }
}

function editService(serviceId) {
    // Implementation for editing service
    alert('Edit service functionality - to be implemented');
}

function deleteService(serviceId) {
    if (confirm('Are you sure you want to delete this service? This action cannot be undone.')) {
        $.ajax({
            url: '<?php echo base_url("admin/wellness/delete_service"); ?>',
            type: 'POST',
            data: { service_id: serviceId },
            dataType: 'json',
            success: function(data) {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Error deleting service: ' + (data.message || 'Unknown error'));
                }
            },
            error: function() {
                alert('Error deleting service');
            }
        });
    }
}

function loadVisitTimeline() {
    $.ajax({
        url: '<?php echo base_url("admin/wellness/get_visit_timeline"); ?>',
        type: 'GET',
        data: { visit_id: <?php echo $visit->id; ?> },
        dataType: 'json',
        success: function(data) {
            var timeline = $('#visit-timeline');
            timeline.empty();
            
            if (data.length > 0) {
                $.each(data, function(index, event) {
                    var timelineItem = 
                        '<div class="timeline-item">' +
                        '<time class="timeline-time">' + event.time + '</time>' +
                        '<div class="timeline-icon ' + getEventIconClass(event.type) + '">' +
                        '<i class="fa ' + getEventIcon(event.type) + '"></i>' +
                        '</div>' +
                        '<div class="timeline-body">' +
                        '<h4>' + event.title + '</h4>' +
                        '<p>' + event.description + '</p>' +
                        '</div>' +
                        '</div>';
                    timeline.append(timelineItem);
                });
            } else {
                timeline.html('<div class="alert alert-info">No timeline events yet.</div>');
            }
        },
        error: function() {
            console.log('Error loading timeline');
        }
    });
}

function getEventIconClass(eventType) {
    switch(eventType) {
        case 'visit_created': return 'bg-blue';
        case 'service_added': return 'bg-green';
        case 'payment_processed': return 'bg-yellow';
        case 'visit_updated': return 'bg-orange';
        case 'service_completed': return 'bg-green';
        default: return 'bg-gray';
    }
}

function getEventIcon(eventType) {
    switch(eventType) {
        case 'visit_created': return 'fa-plus';
        case 'service_added': return 'fa-stethoscope';
        case 'payment_processed': return 'fa-money';
        case 'visit_updated': return 'fa-edit';
        case 'service_completed': return 'fa-check';
        default: return 'fa-info';
    }
}

function printVisitSummary() {
    var printWindow = window.open('<?php echo base_url("admin/wellness/print_visit_summary/" . $visit->id); ?>', '_blank');
    printWindow.focus();
}

function generateReceipt() {
    if (<?php echo ($visit->amount_paid > 0) ? 'true' : 'false'; ?>) {
        var receiptWindow = window.open('<?php echo base_url("admin/wellness/generate_receipt/" . $visit->id); ?>', '_blank');
        receiptWindow.focus();
    } else {
        alert('No payments have been made for this visit yet.');
    }
}

// Auto-refresh visit data every 30 seconds
setInterval(function() {
    // Refresh payment status and service status
    refreshVisitData();
}, 30000);

function refreshVisitData() {
    $.ajax({
        url: '<?php echo base_url("admin/wellness/get_visit_status"); ?>',
        type: 'GET',
        data: { visit_id: <?php echo $visit->id; ?> },
        dataType: 'json',
        success: function(data) {
            if (data.payment_status !== '<?php echo $visit->payment_status; ?>') {
                // Payment status changed, reload page
                location.reload();
            }
        }
    });
}

// Form validation
$('#add-service-modal form').on('submit', function(e) {
    var serviceType = $('#service_type').val();
    var unitPrice = $('#unit_price').val();
    
    if (!serviceType) {
        e.preventDefault();
        alert('Please select a service type');
        return false;
    }
    
    if (!unitPrice || parseFloat(unitPrice) <= 0) {
        e.preventDefault();
        alert('Please enter a valid unit price');
        return false;
    }
    
    return true;
});

$('#payment-modal form').on('submit', function(e) {
    var amount = parseFloat($('input[name="amount"]').val());
    var balance = <?php echo $visit->balance; ?>;
    
    if (amount <= 0) {
        e.preventDefault();
        alert('Please enter a valid payment amount');
        return false;
    }
    
    if (amount > balance) {
        e.preventDefault();
        alert('Payment amount cannot exceed the outstanding balance');
        return false;
    }
    
    return true;
});

// Reset modal forms when closed
$('.modal').on('hidden.bs.modal', function() {
    $(this).find('form')[0].reset();
    $('#calculation-preview').hide();
    $('#service_code').empty().append('<option value="">Select Service</option>');
    $('#service_name').val('');
});

// Initialize tooltips
$('[title]').tooltip();

// Format currency inputs
$('input[name="amount"], input[name="unit_price"]').on('blur', function() {
    var value = parseFloat($(this).val());
    if (!isNaN(value)) {
        $(this).val(value.toFixed(2));
    }
});
</script>

<style>
/* Custom styles for visit details page */
.timeline {
    position: relative;
    padding-left: 30px;
}

.timeline-item {
    position: relative;
    margin-bottom: 20px;
    padding-left: 40px;
}

.timeline-time {
    position: absolute;
    left: -120px;
    top: 0;
    font-size: 12px;
    color: #999;
    width: 100px;
    text-align: right;
}

.timeline-icon {
    position: absolute;
    left: -20px;
    top: 0;
    width: 30px;
    height: 30px;
    border-radius: 50%;
    text-align: center;
    line-height: 30px;
    color: white;
}

.timeline-body {
    background: #f9f9f9;
    padding: 15px;
    border-left: 3px solid #ddd;
}

.timeline-body h4 {
    margin-top: 0;
    margin-bottom: 5px;
    font-size: 14px;
}

.timeline-body p {
    margin-bottom: 0;
    font-size: 13px;
    color: #666;
}

.service-row:hover {
    background-color: #f5f5f5;
}

.calculation-preview {
    border: 1px solid #d2d6de;
    border-radius: 3px;
    padding: 10px;
    margin-top: 10px;
    background-color: #f9f9f9;
}

.btn-group-xs > .btn {
    padding: 1px 5px;
    font-size: 11px;
    line-height: 1.5;
    border-radius: 3px;
}

@media (max-width: 768px) {
    .timeline-time {
        position: static;
        display: block;
        margin-bottom: 5px;
        text-align: left;
        width: auto;
    }
    
    .timeline-item {
        padding-left: 20px;
    }
    
    .timeline-icon {
        left: -10px;
        width: 20px;
        height: 20px;
        line-height: 20px;
    }
}

/* Print styles */
@media print {
    .box-tools,
    .btn,
    .modal,
    .timeline {
        display: none !important;
    }
    
    .content-wrapper {
        margin: 0 !important;
        padding: 0 !important;
    }
    
    .box {
        border: none !important;
        box-shadow: none !important;
    }
}
</style>