<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-list-alt"></i> Service Catalog <small>Manage Wellness Services</small></h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url('admin/wellness'); ?>">Wellness</a></li>
            <li class="active">Service Catalog</li>
        </ol>
    </section>

    <section class="content">
        <?php echo $this->session->flashdata('msg'); ?>
        
        <div class="row">
            <!-- Add New Service -->
            <div class="col-md-4">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-plus"></i> Add New Service</h3>
                    </div>
                    <?php echo form_open('admin/wellness/add_service_catalog', array('id' => 'service-form')); ?>
                    <div class="box-body">
                        <div class="form-group">
                            <label>Service Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="service_name" required 
                                   placeholder="e.g., General Consultation">
                        </div>

                        <div class="form-group">
                            <label>Service Code <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="service_code" required 
                                   placeholder="e.g., WV-CONS-001" maxlength="50">
                            <small class="text-muted">Unique identifier for this service</small>
                        </div>

                        <div class="form-group">
                            <label>Service Type <span class="text-danger">*</span></label>
                            <select class="form-control" name="service_type" required id="service-type-select">
                                <option value="">Select Service Type</option>
                                <option value="consultation">Consultation</option>
                                <option value="dental">Dental</option>
                                <option value="laboratory">Laboratory</option>
                                <option value="pharmacy">Pharmacy</option>
                                <option value="radiology">Radiology</option>
                                <option value="optical">Optical</option>
                                <option value="specialized">Specialized</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Category</label>
                            <input type="text" class="form-control" name="category" 
                                   placeholder="e.g., General, Emergency, Preventive">
                        </div>

                        <div class="form-group">
                            <label>Description</label>
                            <textarea class="form-control" name="description" rows="3" 
                                      placeholder="Brief description of the service"></textarea>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Standard Price (KSh) <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control" name="standard_price" 
                                           step="0.01" min="0" required placeholder="0.00">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Minimum Price (KSh)</label>
                                    <input type="number" class="form-control" name="minimum_price" 
                                           step="0.01" min="0" placeholder="0.00">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Duration (minutes)</label>
                                    <input type="number" class="form-control" name="duration_minutes" 
                                           value="30" min="1" max="480">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Requires Specialist</label>
                                    <select class="form-control" name="requires_specialist">
                                        <option value="0">No</option>
                                        <option value="1">Yes</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-save"></i> Add Service
                        </button>
                        <button type="reset" class="btn btn-default">
                            <i class="fa fa-refresh"></i> Reset
                        </button>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>

            <!-- Services List -->
            <div class="col-md-8">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-list"></i> Service Catalog</h3>
                        <div class="box-tools pull-right">
                            <div class="input-group input-group-sm" style="width: 200px;">
                                <select class="form-control" id="filter-service-type">
                                    <option value="">All Service Types</option>
                                    <option value="consultation">Consultation</option>
                                    <option value="dental">Dental</option>
                                    <option value="laboratory">Laboratory</option>
                                    <option value="pharmacy">Pharmacy</option>
                                    <option value="radiology">Radiology</option>
                                    <option value="optical">Optical</option>
                                    <option value="specialized">Specialized</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (isset($service_catalog) && !empty($service_catalog)): ?>
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered" id="services-table">
                                <thead>
                                    <tr>
                                        <th>Code</th>
                                        <th>Service Name</th>
                                        <th>Type</th>
                                        <th>Category</th>
                                        <th>Standard Price</th>
                                        <th>Duration</th>
                                        <th>Specialist</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($service_catalog as $service): ?>
                                    <tr data-service-type="<?php echo $service->service_type; ?>">
                                        <td><code><?php echo $service->service_code; ?></code></td>
                                        <td>
                                            <strong><?php echo $service->service_name; ?></strong>
                                            <?php if ($service->description): ?>
                                                <br><small class="text-muted"><?php echo substr($service->description, 0, 50) . '...'; ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php
                                            $type_colors = array(
                                                'consultation' => 'label-primary',
                                                'dental' => 'label-success',
                                                'laboratory' => 'label-warning',
                                                'pharmacy' => 'label-info',
                                                'radiology' => 'label-danger',
                                                'optical' => 'label-default',
                                                'specialized' => 'label-purple'
                                            );
                                            $color = isset($type_colors[$service->service_type]) ? $type_colors[$service->service_type] : 'label-default';
                                            ?>
                                            <span class="label <?php echo $color; ?>"><?php echo ucfirst($service->service_type); ?></span>
                                        </td>
                                        <td><?php echo $service->category ?: '-'; ?></td>
                                        <td>
                                            <strong>KSh <?php echo number_format($service->standard_price, 2); ?></strong>
                                            <?php if ($service->minimum_price && $service->minimum_price != $service->standard_price): ?>
                                                <br><small class="text-muted">Min: KSh <?php echo number_format($service->minimum_price, 2); ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo $service->duration_minutes; ?> min</td>
                                        <td>
                                            <?php if ($service->requires_specialist): ?>
                                                <span class="label label-warning">Required</span>
                                            <?php else: ?>
                                                <span class="label label-success">Not Required</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ($service->is_active): ?>
                                                <span class="label label-success">Active</span>
                                            <?php else: ?>
                                                <span class="label label-danger">Inactive</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-xs">
                                                <button class="btn btn-info" onclick="editService(<?php echo $service->id; ?>)" 
                                                        title="Edit Service">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                                <button class="btn btn-warning" onclick="toggleServiceStatus(<?php echo $service->id; ?>, <?php echo $service->is_active; ?>)" 
                                                        title="<?php echo $service->is_active ? 'Deactivate' : 'Activate'; ?>">
                                                    <i class="fa fa-<?php echo $service->is_active ? 'pause' : 'play'; ?>"></i>
                                                </button>
                                                <button class="btn btn-danger" onclick="deleteService(<?php echo $service->id; ?>)" 
                                                        title="Delete Service">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <?php else: ?>
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No services have been added to the catalog yet. Add your first service using the form on the left.
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Service Statistics -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-pie-chart"></i> Service Catalog Statistics</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-2">
                                <div class="info-box bg-aqua">
                                    <span class="info-box-icon"><i class="fa fa-list"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Total Services</span>
                                        <span class="info-box-number"><?php echo isset($service_catalog) ? count($service_catalog) : 0; ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="info-box bg-green">
                                    <span class="info-box-icon"><i class="fa fa-check"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Active Services</span>
                                        <span class="info-box-number">
                                            <?php 
                                            $active_count = 0;
                                            if (isset($service_catalog)) {
                                                foreach ($service_catalog as $service) {
                                                    if ($service->is_active) $active_count++;
                                                }
                                            }
                                            echo $active_count;
                                            ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="info-box bg-yellow">
                                    <span class="info-box-icon"><i class="fa fa-user-md"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Consultations</span>
                                        <span class="info-box-number" id="consultation-count">0</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="info-box bg-red">
                                    <span class="info-box-icon"><i class="fa fa-tooth"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Dental</span>
                                        <span class="info-box-number" id="dental-count">0</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="info-box bg-purple">
                                    <span class="info-box-icon"><i class="fa fa-flask"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Laboratory</span>
                                        <span class="info-box-number" id="lab-count">0</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="info-box bg-navy">
                                    <span class="info-box-icon"><i class="fa fa-eye"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Other Services</span>
                                        <span class="info-box-number" id="other-count">0</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bulk Actions -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-cogs"></i> Bulk Actions</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-3">
                                <button class="btn btn-success btn-block" onclick="bulkActivateServices()">
                                    <i class="fa fa-play"></i> Activate All Services
                                </button>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-warning btn-block" onclick="bulkDeactivateServices()">
                                    <i class="fa fa-pause"></i> Deactivate All Services
                                </button>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-info btn-block" onclick="exportServiceCatalog()">
                                    <i class="fa fa-download"></i> Export Catalog
                                </button>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-primary btn-block" onclick="importServiceCatalog()">
                                    <i class="fa fa-upload"></i> Import Services
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Edit Service Modal -->
<div class="modal fade" id="edit-service-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
                <h4 class="modal-title"><i class="fa fa-edit"></i> Edit Service</h4>
            </div>
            <?php echo form_open('admin/wellness/update_service_catalog'); ?>
            <input type="hidden" name="service_id" id="edit-service-id">
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Service Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="service_name" id="edit-service-name" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Service Code <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="service_code" id="edit-service-code" required readonly>
                            <small class="text-muted">Service code cannot be changed</small>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Service Type <span class="text-danger">*</span></label>
                            <select class="form-control" name="service_type" id="edit-service-type" required>
                                <option value="">Select Service Type</option>
                                <option value="consultation">Consultation</option>
                                <option value="dental">Dental</option>
                                <option value="laboratory">Laboratory</option>
                                <option value="pharmacy">Pharmacy</option>
                                <option value="radiology">Radiology</option>
                                <option value="optical">Optical</option>
                                <option value="specialized">Specialized</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Category</label>
                            <input type="text" class="form-control" name="category" id="edit-category">
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label>Description</label>
                    <textarea class="form-control" name="description" id="edit-description" rows="3"></textarea>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Standard Price (KSh) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" name="standard_price" id="edit-standard-price" 
                                   step="0.01" min="0" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Minimum Price (KSh)</label>
                            <input type="number" class="form-control" name="minimum_price" id="edit-minimum-price" 
                                   step="0.01" min="0">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Duration (minutes)</label>
                            <input type="number" class="form-control" name="duration_minutes" id="edit-duration" 
                                   min="1" max="480">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Requires Specialist</label>
                            <select class="form-control" name="requires_specialist" id="edit-requires-specialist">
                                <option value="0">No</option>
                                <option value="1">Yes</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary">
                    <i class="fa fa-save"></i> Update Service
                </button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#services-table').DataTable({
        "paging": true,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "pageLength": 15,
        "order": [[ 1, "asc" ]]
    });

    // Load service type statistics
    loadServiceTypeStats();

    // Filter by service type
    $('#filter-service-type').change(function() {
        var filterType = $(this).val().toLowerCase();
        var table = $('#services-table').DataTable();
        
        if (filterType === '') {
            table.search('').draw();
        } else {
            table.column(2).search(filterType, true, false).draw();
        }
    });

    // Auto-generate service code
    $('#service-type-select').change(function() {
        generateServiceCode($(this).val());
    });

    // Form validation
    $('#service-form').on('submit', function(e) {
        var standardPrice = parseFloat($('input[name="standard_price"]').val());
        var minimumPrice = parseFloat($('input[name="minimum_price"]').val());
        
        if (minimumPrice && minimumPrice > standardPrice) {
            e.preventDefault();
            alert('Minimum price cannot be greater than standard price');
            return false;
        }
    });
});

function loadServiceTypeStats() {
    var stats = {
        consultation: 0,
        dental: 0,
        laboratory: 0,
        other: 0
    };

    <?php if (isset($service_catalog)): ?>
    <?php foreach ($service_catalog as $service): ?>
        <?php if ($service->is_active): ?>
            switch('<?php echo $service->service_type; ?>') {
                case 'consultation':
                    stats.consultation++;
                    break;
                case 'dental':
                    stats.dental++;
                    break;
                case 'laboratory':
                    stats.laboratory++;
                    break;
                default:
                    stats.other++;
                    break;
            }
        <?php endif; ?>
    <?php endforeach; ?>
    <?php endif; ?>

    $('#consultation-count').text(stats.consultation);
    $('#dental-count').text(stats.dental);
    $('#lab-count').text(stats.laboratory);
    $('#other-count').text(stats.other);
}

function generateServiceCode(serviceType) {
    if (!serviceType) return;
    
    $.ajax({
        url: '<?php echo base_url("admin/wellness/generate_service_code"); ?>',
        type: 'GET',
        data: { service_type: serviceType },
        dataType: 'json',
        success: function(data) {
            if (data.success) {
                $('input[name="service_code"]').val(data.code);
            }
        }
    });
}

function editService(serviceId) {
    $.ajax({
        url: '<?php echo base_url("admin/wellness/get_service"); ?>',
        type: 'GET',
        data: { service_id: serviceId },
        dataType: 'json',
        success: function(data) {
            if (data.success) {
                var service = data.service;
                $('#edit-service-id').val(service.id);
                $('#edit-service-name').val(service.service_name);
                $('#edit-service-code').val(service.service_code);
                $('#edit-service-type').val(service.service_type);
                $('#edit-category').val(service.category);
                $('#edit-description').val(service.description);
                $('#edit-standard-price').val(service.standard_price);
                $('#edit-minimum-price').val(service.minimum_price);
                $('#edit-duration').val(service.duration_minutes);
                $('#edit-requires-specialist').val(service.requires_specialist);
                
                $('#edit-service-modal').modal('show');
            } else {
                alert('Error loading service data');
            }
        },
        error: function() {
            alert('Error loading service data');
        }
    });
}

function toggleServiceStatus(serviceId, currentStatus) {
    var action = currentStatus ? 'deactivate' : 'activate';
    var newStatus = currentStatus ? 0 : 1;
    
    if (confirm('Are you sure you want to ' + action + ' this service?')) {
        $.ajax({
            url: '<?php echo base_url("admin/wellness/toggle_service_status"); ?>',
            type: 'POST',
            data: { 
                service_id: serviceId, 
                status: newStatus 
            },
            dataType: 'json',
            success: function(data) {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Error updating service status');
                }
            },
            error: function() {
                alert('Error updating service status');
            }
        });
    }
}

function deleteService(serviceId) {
    if (confirm('Are you sure you want to delete this service? This action cannot be undone.\n\nNote: You can only delete services that have not been used in any visits.')) {
        $.ajax({
            url: '<?php echo base_url("admin/wellness/delete_service_catalog"); ?>',
            type: 'POST',
            data: { service_id: serviceId },
            dataType: 'json',
            success: function(data) {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Error deleting service: ' + (data.message || 'Service may be in use'));
                }
            },
            error: function() {
                alert('Error deleting service');
            }
        });
    }
}

function bulkActivateServices() {
    if (confirm('Are you sure you want to activate all services?')) {
        $.ajax({
            url: '<?php echo base_url("admin/wellness/bulk_activate_services"); ?>',
            type: 'POST',
            dataType: 'json',
            success: function(data) {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Error activating services');
                }
            },
            error: function() {
                alert('Error activating services');
            }
        });
    }
}

function bulkDeactivateServices() {
    if (confirm('Are you sure you want to deactivate all services? This will prevent them from being used in new visits.')) {
        $.ajax({
            url: '<?php echo base_url("admin/wellness/bulk_deactivate_services"); ?>',
            type: 'POST',
            dataType: 'json',
            success: function(data) {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Error deactivating services');
                }
            },
            error: function() {
                alert('Error deactivating services');
            }
        });
    }
}

function exportServiceCatalog() {
    window.open('<?php echo base_url("admin/wellness/export_service_catalog"); ?>', '_blank');
}

function importServiceCatalog() {
    // Create file input dynamically
    var fileInput = $('<input type="file" accept=".csv,.xlsx" style="display:none;">');
    
    fileInput.on('change', function(e) {
        var file = e.target.files[0];
        if (file) {
            var formData = new FormData();
            formData.append('import_file', file);
            
            $.ajax({
                url: '<?php echo base_url("admin/wellness/import_service_catalog"); ?>',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                dataType: 'json',
                success: function(data) {
                    if (data.success) {
                        alert('Services imported successfully! ' + data.imported_count + ' services added.');
                        location.reload();
                    } else {
                        alert('Error importing services: ' + data.message);
                    }
                },
                error: function() {
                    alert('Error importing services');
                }
            });
        }
    });
    
    fileInput.click();
}

// Price formatting
$('input[name="standard_price"], input[name="minimum_price"], #edit-standard-price, #edit-minimum-price').on('blur', function() {
    var value = parseFloat($(this).val());
    if (!isNaN(value)) {
        $(this).val(value.toFixed(2));
    }
});

// Service code validation
$('input[name="service_code"]').on('blur', function() {
    var code = $(this).val().toUpperCase();
    $(this).val(code);
    
    if (code && !validateServiceCode(code)) {
        alert('Service code should follow format: WV-TYPE-001 (e.g., WV-CONS-001)');
        $(this).focus();
    }
});

function validateServiceCode(code) {
    var pattern = /^WV-[A-Z]{4}-\d{3}$/;
    return pattern.test(code);
}

// Auto-suggest categories based on service type
$('#service-type-select, #edit-service-type').change(function() {
    var serviceType = $(this).val();
    var categoryInput = $(this).closest('.modal-body, .box-body').find('input[name="category"]');
    
    var suggestions = {
        'consultation': ['General', 'Specialist', 'Follow-up', 'Emergency'],
        'dental': ['General', 'Surgery', 'Orthodontics', 'Preventive', 'Cosmetic'],
        'laboratory': ['Hematology', 'Chemistry', 'Microbiology', 'Urology', 'Immunology'],
        'pharmacy': ['Dispensing', 'Consultation', 'OTC'],
        'radiology': ['X-Ray', 'Ultrasound', 'CT Scan', 'MRI'],
        'optical': ['Examination', 'Fitting', 'Surgery', 'Screening'],
        'specialized': ['Cardiology', 'Dermatology', 'Gynecology', 'Pediatrics']
    };
    
    if (suggestions[serviceType]) {
        categoryInput.attr('placeholder', 'e.g., ' + suggestions[serviceType].join(', '));
    }
});

// Auto-format service name
$('input[name="service_name"], #edit-service-name').on('blur', function() {
    var name = $(this).val();
    if (name) {
        // Capitalize first letter of each word
        name = name.replace(/\w\S*/g, function(txt) {
            return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
        });
        $(this).val(name);
    }
});
</script>

<style>
.info-box {
    display: block;
    min-height: 90px;
    background: #fff;
    width: 100%;
    box-shadow: 0 1px 1px rgba(0,0,0,0.1);
    border-radius: 2px;
    margin-bottom: 15px;
}

.info-box-icon {
    border-top-left-radius: 2px;
    border-top-right-radius: 0;
    border-bottom-right-radius: 0;
    border-bottom-left-radius: 2px;
    display: block;
    float: left;
    height: 90px;
    width: 90px;
    text-align: center;
    font-size: 45px;
    line-height: 90px;
    background: rgba(0,0,0,0.2);
    color: white;
}

.info-box-content {
    padding: 5px 10px;
    margin-left: 90px;
}

.info-box-number {
    display: block;
    font-weight: bold;
    font-size: 18px;
}

.info-box-text {
    display: block;
    font-size: 14px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.bg-aqua { background-color: #00c0ef !important; }
.bg-green { background-color: #00a65a !important; }
.bg-yellow { background-color: #f39c12 !important; }
.bg-red { background-color: #dd4b39 !important; }
.bg-purple { background-color: #605ca8 !important; }
.bg-navy { background-color: #001f3f !important; }

.label-purple {
    background-color: #605ca8;
}

/* Service type color coding */
.service-type-consultation { border-left: 4px solid #337ab7; }
.service-type-dental { border-left: 4px solid #5cb85c; }
.service-type-laboratory { border-left: 4px solid #f0ad4e; }
.service-type-pharmacy { border-left: 4px solid #5bc0de; }
.service-type-radiology { border-left: 4px solid #d9534f; }
.service-type-optical { border-left: 4px solid #777; }
.service-type-specialized { border-left: 4px solid #605ca8; }

/* Responsive adjustments */
@media (max-width: 768px) {
    .info-box-content {
        margin-left: 0;
        padding-top: 10px;
    }
    
    .info-box-icon {
        float: none;
        width: 100%;
        height: 60px;
        line-height: 60px;
        font-size: 30px;
    }
}
</style>