<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <div class="header-icon">
            <i class="fa fa-stethoscope"></i>
        </div>
        <div class="header-title">
            <h1><?php echo $title; ?></h1>
            <small>Manage dental, optical and other specialized services</small>
        </div>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-list"></i> Specialized Services
                        </h3>
                        <div class="box-tools pull-right">
                            <!-- Filter by Category Type -->
                            <div class="btn-group" style="margin-right: 10px;">
                                <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown">
                                    <i class="fa fa-filter"></i> Filter by Type <span class="caret"></span>
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a href="#" onclick="filterByType('')">All Services</a></li>
                                    <li><a href="#" onclick="filterByType('dental')"><i class="fa fa-tooth"></i> Dental</a></li>
                                    <li><a href="#" onclick="filterByType('optical')"><i class="fa fa-eye"></i> Optical</a></li>
                                    <li><a href="#" onclick="filterByType('physiotherapy')"><i class="fa fa-heartbeat"></i> Physiotherapy</a></li>
                                    <li><a href="#" onclick="filterByType('orthopedic')"><i class="fa fa-wheelchair"></i> Orthopedic</a></li>
                                    <li><a href="#" onclick="filterByType('cardiology')"><i class="fa fa-heart"></i> Cardiology</a></li>
                                    <li><a href="#" onclick="filterByType('neurology')"><i class="fa fa-brain"></i> Neurology</a></li>
                                    <li><a href="#" onclick="filterByType('other')"><i class="fa fa-stethoscope"></i> Other</a></li>
                                </ul>
                            </div>
                            
                            <!-- Filter by Specialist Requirement -->
                            <div class="btn-group" style="margin-right: 10px;">
                                <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown">
                                    <i class="fa fa-user-md"></i> Specialist <span class="caret"></span>
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a href="#" onclick="filterBySpecialist('')">All Services</a></li>
                                    <li><a href="#" onclick="filterBySpecialist('1')">Specialist Required</a></li>
                                    <li><a href="#" onclick="filterBySpecialist('0')">General Staff</a></li>
                                </ul>
                            </div>
                            
                            <?php if ($this->rbac->hasPrivilege('specialized_services', 'can_add')): ?>
                                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addServiceModal">
                                    <i class="fa fa-plus"></i> Add Service
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table id="servicesTable" class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>Service Name</th>
                                        <th>Service Code</th>
                                        <th>Category</th>
                                        <th>Type</th>
                                        <th>Price</th>
                                        <th>Duration</th>
                                        <th>Specialist Required</th>
                                        <th>Status</th>
                                        <th class="text-right">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Data loaded via DataTables -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Service Modal -->
<div class="modal fade" id="addServiceModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-plus"></i> Add Specialized Service
                </h4>
            </div>
            <form id="addServiceForm" method="post" role="form">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="form-group">
                                <label for="service_name">Service Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="service_name" name="service_name" placeholder="Enter service name" required>
                                <span class="text-danger" id="service_name_error"></span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="service_code">Service Code</label>
                                <input type="text" class="form-control" id="service_code" name="service_code" placeholder="e.g., DENT001">
                                <span class="text-danger" id="service_code_error"></span>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="category_id">Category <span class="text-danger">*</span></label>
                                <select class="form-control" id="category_id" name="category_id" required>
                                    <option value="">Select Category</option>
                                    <?php foreach ($categories as $category): ?>
                                        <option value="<?php echo $category['id']; ?>" data-type="<?php echo $category['category_type']; ?>">
                                            <?php echo $category['category_name']; ?> (<?php echo ucfirst($category['category_type']); ?>)
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                                <span class="text-danger" id="category_id_error"></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="service_type">Service Type <span class="text-danger">*</span></label>
                                <select class="form-control" id="service_type" name="service_type" required>
                                    <option value="">Select Type</option>
                                    <option value="consultation">Consultation</option>
                                    <option value="procedure">Procedure</option>
                                    <option value="treatment">Treatment</option>
                                    <option value="diagnostic">Diagnostic</option>
                                    <option value="preventive">Preventive</option>
                                    <option value="cosmetic">Cosmetic</option>
                                </select>
                                <span class="text-danger" id="service_type_error"></span>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="cash_price">Cash Price <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-addon"><?php echo $currency_symbol; ?></span>
                                    <input type="number" class="form-control" id="cash_price" name="cash_price" step="0.01" min="0" placeholder="0.00" required>
                                </div>
                                <span class="text-danger" id="cash_price_error"></span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="insurance_price">Insurance Price</label>
                                <div class="input-group">
                                    <span class="input-group-addon"><?php echo $currency_symbol; ?></span>
                                    <input type="number" class="form-control" id="insurance_price" name="insurance_price" step="0.01" min="0" placeholder="0.00">
                                </div>
                                <span class="text-danger" id="insurance_price_error"></span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="duration_minutes">Duration (Minutes)</label>
                                <input type="number" class="form-control" id="duration_minutes" name="duration_minutes" min="1" max="480" placeholder="30">
                                <span class="text-danger" id="duration_minutes_error"></span>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="billing_code">Billing Code</label>
                                <input type="text" class="form-control" id="billing_code" name="billing_code" placeholder="e.g., D0150">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="complications_risk_level">Risk Level</label>
                                <select class="form-control" id="complications_risk_level" name="complications_risk_level">
                                    <option value="low">Low Risk</option>
                                    <option value="medium">Medium Risk</option>
                                    <option value="high">High Risk</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="age_restrictions">Age Restrictions</label>
                                <input type="text" class="form-control" id="age_restrictions" name="age_restrictions" placeholder="e.g., 18+ years">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="checkbox">
                                <label>
                                    <input type="checkbox" id="requires_specialist" name="requires_specialist" value="1" checked>
                                    Requires Specialist
                                </label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="checkbox">
                                <label>
                                    <input type="checkbox" id="requires_equipment" name="requires_equipment" value="1">
                                    Requires Special Equipment
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="description">Description</label>
                                <textarea class="form-control" id="description" name="description" rows="3" placeholder="Service description"></textarea>
                            </div>
                        </div>
                    </div>

                    <!-- Equipment List (shown when requires_equipment is checked) -->
                    <div class="row" id="equipment_section" style="display: none;">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="equipment_list">Required Equipment</label>
                                <textarea class="form-control" id="equipment_list" name="equipment_list" rows="2" placeholder="List required equipment..."></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="pre_procedure_requirements">Pre-Procedure Requirements</label>
                                <textarea class="form-control" id="pre_procedure_requirements" name="pre_procedure_requirements" rows="3" placeholder="What patient needs to do before the procedure..."></textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="post_procedure_instructions">Post-Procedure Instructions</label>
                                <textarea class="form-control" id="post_procedure_instructions" name="post_procedure_instructions" rows="3" placeholder="Instructions for patient after the procedure..."></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="contraindications">Contraindications</label>
                                <textarea class="form-control" id="contraindications" name="contraindications" rows="2" placeholder="When this service should not be performed..."></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">
                        Cancel
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> Save Service
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Service Modal -->
<div class="modal fade" id="editServiceModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-edit"></i> Edit Specialized Service
                </h4>
            </div>
            <div id="editServiceModalContent">
                <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>
</div>

<!-- View Service Modal -->
<div class="modal fade" id="viewServiceModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-eye"></i> Service Details
                </h4>
            </div>
            <div id="viewServiceModalContent">
                <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>
</div>

<!-- Include SweetAlert2 -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.32/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.32/dist/sweetalert2.all.min.js"></script>

<script>
$(document).ready(function() {
    console.log('Initializing Specialized Services DataTable...');
    
    // Initialize DataTable
    var servicesTable = $('#servicesTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: base_url + 'admin/specialized_services/get_services_datatable',
            type: 'POST',
            error: function(xhr, error, thrown) {
                console.error('DataTable Error:', xhr.responseText);
                
                Swal.fire({
                    icon: 'error',
                    title: 'Data Loading Error',
                    html: `
                        <p>Failed to load specialized services data.</p>
                        <small class="text-muted">Status: ${xhr.status} - ${xhr.statusText}</small>
                    `,
                    confirmButtonText: 'OK',
                    confirmButtonColor: '#d33',
                    footer: '<a href="#" onclick="testServicesEndpoint()">Test Connection</a>'
                });
            }
        },
        columns: [
            { data: 0, title: 'Service Name' },
            { data: 1, title: 'Service Code' },
            { data: 2, title: 'Category' },
            { data: 3, title: 'Type' },
            { data: 4, title: 'Price', className: 'text-right' },
            { data: 5, title: 'Duration', className: 'text-center' },
            { data: 6, title: 'Specialist Required', className: 'text-center' },
            { data: 7, title: 'Status', className: 'text-center' },
            { data: 8, title: 'Actions', orderable: false, searchable: false, className: 'text-right' }
        ],
        order: [[0, 'asc']],
        pageLength: 25,
        responsive: true,
        language: {
            processing: '<i class="fa fa-spinner fa-spin"></i> Loading services...',
            emptyTable: 'No services found. <a href="#" onclick="showAddServiceModal()">Add your first service</a>'
        },
        drawCallback: function(settings) {
            $('[data-toggle="tooltip"]').tooltip();
        }
    });
    
    // Store table reference
    window.servicesTable = servicesTable;
    
    // Show/hide equipment section based on checkbox
    $('#requires_equipment').change(function() {
        if ($(this).is(':checked')) {
            $('#equipment_section').slideDown();
        } else {
            $('#equipment_section').slideUp();
            $('#equipment_list').val('');
        }
    });
    
    // Auto-generate service code from service name
    $('#service_name').on('input', function() {
        var serviceName = $(this).val();
        var serviceCode = generateServiceCode(serviceName);
        $('#service_code').val(serviceCode);
    });
    
    console.log('Specialized Services DataTable initialized');
});

// Enhanced form submission with SweetAlert2
$('#addServiceForm').on('submit', function(e) {
    e.preventDefault();
    
    console.log('Service form submission started');
    
    var $form = $(this);
    var $submitBtn = $form.find('button[type="submit"]');
    var formData = $form.serialize();
    
    // Show loading state
    $submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
    
    // Clear previous errors
    $('.text-danger').text('');
    
    // Show loading SweetAlert
    Swal.fire({
        title: 'Saving Service...',
        html: 'Please wait while we save your specialized service.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    $.ajax({
        url: base_url + 'admin/specialized_services/add_service',
        type: 'POST',
        data: formData,
        dataType: 'json',
        timeout: 15000,
        success: function(response) {
            console.log('Add service response:', response);
            
            if (response.status === 'success') {
                $('#addServiceModal').modal('hide');
                $form[0].reset();
                $('#equipment_section').hide(); // Hide equipment section
                
                // Reload the DataTable
                if (window.servicesTable) {
                    window.servicesTable.ajax.reload(null, false);
                }
                
                // Success SweetAlert
                Swal.fire({
                    icon: 'success',
                    title: 'Service Added Successfully!',
                    html: response.message,
                    confirmButtonColor: '#28a745',
                    timer: 3000,
                    timerProgressBar: true
                });
            } else {
                // Handle validation errors
                if (response.error && typeof response.error === 'object') {
                    let errorList = '<ul class="text-left">';
                    $.each(response.error, function(field, error) {
                        $('#' + field + '_error').text(error);
                        errorList += '<li>' + error + '</li>';
                    });
                    errorList += '</ul>';
                    
                    Swal.fire({
                        icon: 'error',
                        title: 'Validation Errors',
                        html: errorList,
                        confirmButtonColor: '#dc3545'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error Adding Service',
                        html: response.message,
                        confirmButtonColor: '#dc3545'
                    });
                }
            }
        },
        error: function(xhr, status, error) {
            console.error('Add service AJAX error:', xhr.responseText);
            
            let errorMessage = 'An unexpected error occurred while saving the service.';
            
            if (xhr.status === 404) {
                errorMessage = 'The server endpoint was not found. Please check your configuration.';
            } else if (xhr.status === 500) {
                errorMessage = 'A server error occurred. Please contact your administrator.';
            } else if (xhr.status === 0) {
                errorMessage = 'Network connection error. Please check your internet connection.';
            }
            
            Swal.fire({
                icon: 'error',
                title: 'Connection Error',
                html: errorMessage,
                confirmButtonColor: '#dc3545',
                footer: '<small>Check the browser console for more details</small>'
            });
        },
        complete: function() {
            // Reset button state
            $submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Service');
        }
    });
    
    return false;
});

// Function to view a service
function viewService(id) {
    console.log('Viewing service ID:', id);
    
    Swal.fire({
        title: 'Loading Service Details...',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    $.ajax({
        url: base_url + 'admin/specialized_services/view_service/' + id,
        type: 'GET',
        timeout: 10000,
        success: function(response) {
            Swal.close();
            $('#viewServiceModalContent').html(response);
            $('#viewServiceModal').modal('show');
        },
        error: function(xhr, status, error) {
            console.error('View service error:', error);
            Swal.fire({
                icon: 'error',
                title: 'Failed to Load Service Details',
                html: 'Unable to retrieve service information. Please try again.',
                confirmButtonColor: '#dc3545'
            });
        }
    });
}

// Function to edit a service
function editService(id) {
    console.log('Editing service ID:', id);
    
    Swal.fire({
        title: 'Loading Service for Editing...',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    $.ajax({
        url: base_url + 'admin/specialized_services/edit_service/' + id,
        type: 'GET',
        timeout: 10000,
        success: function(response) {
            Swal.close();
            $('#editServiceModalContent').html(response);
            $('#editServiceModal').modal('show');
        },
        error: function(xhr, status, error) {
            console.error('Edit service error:', error);
            Swal.fire({
                icon: 'error',
                title: 'Failed to Load Service for Editing',
                html: 'Unable to retrieve service information for editing. Please try again.',
                confirmButtonColor: '#dc3545'
            });
        }
    });
}

// Function to delete a service
function deleteService(id) {
    console.log('Deleting service ID:', id);
    
    Swal.fire({
        title: 'Delete Specialized Service?',
        html: `
            <p>Are you sure you want to delete this specialized service?</p>
            <div class="alert alert-warning mt-3">
                <i class="fa fa-exclamation-triangle"></i>
                <strong>Warning:</strong> This action cannot be undone!
            </div>
        `,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#dc3545',
        cancelButtonColor: '#6c757d',
        confirmButtonText: '<i class="fa fa-trash"></i> Yes, Delete It!',
        cancelButtonText: '<i class="fa fa-times"></i> Cancel',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'Deleting Service...',
                html: 'Please wait while we delete the specialized service.',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
            
            $.ajax({
                url: base_url + 'admin/specialized_services/delete_service/' + id,
                type: 'POST',
                dataType: 'json',
                timeout: 10000,
                success: function(response) {
                    if (response.status === 'success') {
                        if (window.servicesTable) {
                            window.servicesTable.ajax.reload(null, false);
                        }
                        
                        Swal.fire({
                            icon: 'success',
                            title: 'Service Deleted!',
                            html: response.message,
                            confirmButtonColor: '#28a745',
                            timer: 3000,
                            timerProgressBar: true
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Delete Failed',
                            html: response.message,
                            confirmButtonColor: '#dc3545'
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Delete service error:', error);
                    Swal.fire({
                        icon: 'error',
                        title: 'Delete Failed',
                        html: 'An error occurred while deleting the service. Please try again.',
                        confirmButtonColor: '#dc3545'
                    });
                }
            });
        }
    });
}

// Function to toggle specialist requirement
function toggleSpecialist(serviceId, currentStatus) {
    console.log('Toggling specialist requirement for service ID:', serviceId, 'Current status:', currentStatus);
    
    var newStatus = currentStatus == 1 ? 0 : 1;
    var actionText = newStatus == 1 ? 'require specialist' : 'remove specialist requirement';
    var iconHtml = newStatus == 1 ? 
        '<i class="fa fa-user-md" style="color: #f39c12; font-size: 2em;"></i>' : 
        '<i class="fa fa-user" style="color: #95a5a6; font-size: 2em;"></i>';
    
    Swal.fire({
        title: 'Change Specialist Requirement?',
        html: `
            <div class="text-center mb-3">
                ${iconHtml}
            </div>
            <p>Are you sure you want to <strong>${actionText}</strong> for this service?</p>
            <div class="alert alert-info mt-3">
                <i class="fa fa-info-circle"></i>
                <strong>Note:</strong> This will affect how this service is scheduled and assigned.
            </div>
        `,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: newStatus == 1 ? '#f39c12' : '#95a5a6',
        cancelButtonColor: '#6c757d',
        confirmButtonText: newStatus == 1 ? 
            '<i class="fa fa-user-md"></i> Require Specialist' : 
            '<i class="fa fa-user"></i> Remove Requirement',
        cancelButtonText: '<i class="fa fa-times"></i> Cancel',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'Updating Specialist Requirement...',
                html: 'Please wait while we update the specialist requirement.',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
            
            $.ajax({
                url: base_url + 'admin/specialized_services/toggle_specialist_requirement',
                type: 'POST',
                data: {
                    service_id: serviceId,
                    requires_specialist: newStatus
                },
                dataType: 'json',
                timeout: 10000,
                success: function(response) {
                    if (response.status === 'success') {
                        if (window.servicesTable) {
                            window.servicesTable.ajax.reload(null, false);
                        }
                        
                        const successIcon = newStatus == 1 ? 'fa-user-md' : 'fa-user';
                        const successColor = newStatus == 1 ? '#f39c12' : '#95a5a6';
                        
                        Swal.fire({
                            icon: 'success',
                            title: 'Requirement Updated!',
                            html: `
                                <div class="text-center mb-3">
                                    <i class="fa ${successIcon}" style="color: ${successColor}; font-size: 2em;"></i>
                                </div>
                                <p>${response.message}</p>
                            `,
                            confirmButtonColor: '#28a745',
                            timer: 3000,
                            timerProgressBar: true
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Update Failed',
                            html: response.message,
                            confirmButtonColor: '#dc3545'
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Toggle specialist error:', error);
                    Swal.fire({
                        icon: 'error',
                        title: 'Update Failed',
                        html: 'An error occurred while updating the specialist requirement. Please try again.',
                        confirmButtonColor: '#dc3545'
                    });
                }
            });
        }
    });
}

// Filter functions
function filterByType(categoryType) {
    console.log('Filtering by category type:', categoryType);
    
    if (!window.servicesTable) {
        Swal.fire({
            icon: 'error',
            title: 'Filter Error',
            html: 'DataTable not initialized. Please refresh the page.',
            confirmButtonColor: '#dc3545'
        });
        return;
    }
    
    let filterText = categoryType ? `${categoryType} services` : 'all services';
    
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 2000,
        timerProgressBar: true
    });
    
    Toast.fire({
        icon: 'info',
        title: `Filtering: ${filterText}`
    });
    
    if (categoryType === '') {
        window.servicesTable.column(2).search('').draw();
    } else {
        window.servicesTable.column(2).search(categoryType, true, false).draw();
    }
}

function filterBySpecialist(specialistStatus) {
    console.log('Filtering by specialist status:', specialistStatus);
    
    if (!window.servicesTable) {
        Swal.fire({
            icon: 'error',
            title: 'Filter Error',
            html: 'DataTable not initialized. Please refresh the page.',
            confirmButtonColor: '#dc3545'
        });
        return;
    }
    
    let filterText = '';
    switch(specialistStatus) {
        case '':
            filterText = 'all services';
            break;
        case '1':
            filterText = 'specialist required services';
            break;
        case '0':
            filterText = 'general staff services';
            break;
    }
    
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 2000,
        timerProgressBar: true
    });
    
    Toast.fire({
        icon: 'info',
        title: `Filtering: ${filterText}`
    });
    
    if (specialistStatus === '') {
        window.servicesTable.column(6).search('').draw();
    } else if (specialistStatus === '1') {
        window.servicesTable.column(6).search('Specialist', true, false).draw();
    } else if (specialistStatus === '0') {
        window.servicesTable.column(6).search('General', true, false).draw();
    }
}

// Utility functions
function generateServiceCode(serviceName) {
    if (!serviceName) return '';
    
    // Get category type from selected category
    var categoryType = $('#category_id option:selected').data('type') || 'GEN';
    var prefix = '';
    
    switch(categoryType) {
        case 'dental':
            prefix = 'DENT';
            break;
        case 'optical':
            prefix = 'OPT';
            break;
        case 'physiotherapy':
            prefix = 'PHYS';
            break;
        case 'orthopedic':
            prefix = 'ORTH';
            break;
        case 'cardiology':
            prefix = 'CARD';
            break;
        case 'neurology':
            prefix = 'NEUR';
            break;
        default:
            prefix = 'SPEC';
    }
    
    // Generate a random number
    var randomNum = Math.floor(Math.random() * 999) + 1;
    var paddedNum = randomNum.toString().padStart(3, '0');
    
    return prefix + paddedNum;
}

function showAddServiceModal() {
    $('#addServiceModal').modal('show');
}

// Test function
function testServicesEndpoint() {
    Swal.fire({
        title: 'Testing Services Connection...',
        html: 'Checking if the specialized services endpoint is working properly.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    $.ajax({
        url: base_url + 'admin/specialized_services/test_endpoint',
        type: 'GET',
        success: function(response) {
            console.log('Services endpoint test success:', response);
            
            let resultHtml = `
                <div class="text-left">
                    <p><strong>Status:</strong> <span class="text-success">Success</span></p>
                    <p><strong>Controller:</strong> Working</p>
                    <p><strong>Tables:</strong> ${response.tables_exist.specialized_services ? '✓' : '✗'} Services, ${response.tables_exist.specialized_service_categories ? '✓' : '✗'} Categories</p>
                </div>
            `;
            
            Swal.fire({
                icon: 'success',
                title: 'Connection Test Successful!',
                html: resultHtml,
                confirmButtonColor: '#28a745'
            });
        },
        error: function(xhr, status, error) {
            console.error('Services endpoint test error:', xhr.responseText);
            
            let errorHtml = `
                <div class="text-left">
                    <p><strong>Status:</strong> <span class="text-danger">Failed</span></p>
                    <p><strong>HTTP Status:</strong> ${xhr.status}</p>
                    <p><strong>Error:</strong> ${error}</p>
                </div>
            `;
            
            Swal.fire({
                icon: 'error',
                title: 'Connection Test Failed',
                html: errorHtml,
                confirmButtonColor: '#dc3545'
            });
        }
    });
}

console.log('Specialized Services JavaScript loaded successfully');
</script>
<?php
// Helper functions for the view
function getCategoryIcon($category_type) {
    $icons = array(
        'dental' => 'fa-tooth',
        'optical' => 'fa-eye',
        'physiotherapy' => 'fa-heartbeat',
        'orthopedic' => 'fa-wheelchair',
        'cardiology' => 'fa-heart',
        'neurology' => 'fa-brain',
        'other' => 'fa-stethoscope'
    );
    return isset($icons[$category_type]) ? $icons[$category_type] : 'fa-stethoscope';
}

function getCategoryColor($category_type) {
    $colors = array(
        'dental' => '#2E86AB',
        'optical' => '#1B998B',
        'physiotherapy' => '#FF6B35',
        'orthopedic' => '#A23B72',
        'cardiology' => '#F18F01',
        'neurology' => '#C73E1D',
        'other' => '#6C757D'
    );
    return isset($colors[$category_type]) ? $colors[$category_type] : '#6C757D';
}
?>