<!-- Edit Service Modal Content - save as: views/admin/specialized_services/edit_service_modal.php -->
<form id="editServiceForm" method="post" role="form">
    <div class="modal-body">
        <input type="hidden" name="service_id" value="<?php echo $service->id; ?>">
        
        <div class="row">
            <div class="col-md-8">
                <div class="form-group">
                    <label for="edit_service_name">Service Name <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="edit_service_name" name="service_name" 
                           value="<?php echo htmlspecialchars($service->service_name); ?>" required>
                    <span class="text-danger" id="edit_service_name_error"></span>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="edit_service_code">Service Code</label>
                    <input type="text" class="form-control" id="edit_service_code" name="service_code" 
                           value="<?php echo htmlspecialchars($service->service_code); ?>">
                    <span class="text-danger" id="edit_service_code_error"></span>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="edit_category_id">Category <span class="text-danger">*</span></label>
                    <select class="form-control" id="edit_category_id" name="category_id" required>
                        <option value="">Select Category</option>
                        <?php foreach ($categories as $category): ?>
                            <option value="<?php echo $category['id']; ?>" 
                                    data-type="<?php echo $category['category_type']; ?>"
                                    <?php echo ($category['id'] == $service->category_id) ? 'selected' : ''; ?>>
                                <?php echo $category['category_name']; ?> (<?php echo ucfirst($category['category_type']); ?>)
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <span class="text-danger" id="edit_category_id_error"></span>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="edit_service_type">Service Type <span class="text-danger">*</span></label>
                    <select class="form-control" id="edit_service_type" name="service_type" required>
                        <option value="">Select Type</option>
                        <option value="consultation" <?php echo ($service->service_type == 'consultation') ? 'selected' : ''; ?>>Consultation</option>
                        <option value="procedure" <?php echo ($service->service_type == 'procedure') ? 'selected' : ''; ?>>Procedure</option>
                        <option value="treatment" <?php echo ($service->service_type == 'treatment') ? 'selected' : ''; ?>>Treatment</option>
                        <option value="diagnostic" <?php echo ($service->service_type == 'diagnostic') ? 'selected' : ''; ?>>Diagnostic</option>
                        <option value="preventive" <?php echo ($service->service_type == 'preventive') ? 'selected' : ''; ?>>Preventive</option>
                        <option value="cosmetic" <?php echo ($service->service_type == 'cosmetic') ? 'selected' : ''; ?>>Cosmetic</option>
                    </select>
                    <span class="text-danger" id="edit_service_type_error"></span>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label for="edit_cash_price">Cash Price <span class="text-danger">*</span></label>
                    <div class="input-group">
                        <span class="input-group-addon"><?php echo $currency_symbol; ?></span>
                        <input type="number" class="form-control" id="edit_cash_price" name="cash_price" 
                               step="0.01" min="0" value="<?php echo $service->cash_price; ?>" required>
                    </div>
                    <span class="text-danger" id="edit_cash_price_error"></span>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="edit_insurance_price">Insurance Price</label>
                    <div class="input-group">
                        <span class="input-group-addon"><?php echo $currency_symbol; ?></span>
                        <input type="number" class="form-control" id="edit_insurance_price" name="insurance_price" 
                               step="0.01" min="0" value="<?php echo $service->insurance_price; ?>">
                    </div>
                    <span class="text-danger" id="edit_insurance_price_error"></span>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="edit_duration_minutes">Duration (Minutes)</label>
                    <input type="number" class="form-control" id="edit_duration_minutes" name="duration_minutes" 
                           min="1" max="480" value="<?php echo $service->duration_minutes; ?>">
                    <span class="text-danger" id="edit_duration_minutes_error"></span>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label for="edit_billing_code">Billing Code</label>
                    <input type="text" class="form-control" id="edit_billing_code" name="billing_code" 
                           value="<?php echo htmlspecialchars($service->billing_code); ?>">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="edit_complications_risk_level">Risk Level</label>
                    <select class="form-control" id="edit_complications_risk_level" name="complications_risk_level">
                        <option value="low" <?php echo ($service->complications_risk_level == 'low') ? 'selected' : ''; ?>>Low Risk</option>
                        <option value="medium" <?php echo ($service->complications_risk_level == 'medium') ? 'selected' : ''; ?>>Medium Risk</option>
                        <option value="high" <?php echo ($service->complications_risk_level == 'high') ? 'selected' : ''; ?>>High Risk</option>
                    </select>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="edit_age_restrictions">Age Restrictions</label>
                    <input type="text" class="form-control" id="edit_age_restrictions" name="age_restrictions" 
                           value="<?php echo htmlspecialchars($service->age_restrictions); ?>" placeholder="e.g., 18+ years">
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="checkbox">
                    <label>
                        <input type="checkbox" id="edit_requires_specialist" name="requires_specialist" value="1" 
                               <?php echo ($service->requires_specialist == 1) ? 'checked' : ''; ?>>
                        Requires Specialist
                    </label>
                </div>
            </div>
            <div class="col-md-6">
                <div class="checkbox">
                    <label>
                        <input type="checkbox" id="edit_requires_equipment" name="requires_equipment" value="1" 
                               <?php echo ($service->requires_equipment == 1) ? 'checked' : ''; ?>>
                        Requires Special Equipment
                    </label>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label for="edit_description">Description</label>
                    <textarea class="form-control" id="edit_description" name="description" rows="3"><?php echo htmlspecialchars($service->description); ?></textarea>
                </div>
            </div>
        </div>

        <!-- Equipment List (shown when requires_equipment is checked) -->
        <div class="row" id="edit_equipment_section" style="<?php echo ($service->requires_equipment == 1) ? 'display: block;' : 'display: none;'; ?>">
            <div class="col-md-12">
                <div class="form-group">
                    <label for="edit_equipment_list">Required Equipment</label>
                    <textarea class="form-control" id="edit_equipment_list" name="equipment_list" rows="2"><?php echo htmlspecialchars($service->equipment_list); ?></textarea>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="edit_pre_procedure_requirements">Pre-Procedure Requirements</label>
                    <textarea class="form-control" id="edit_pre_procedure_requirements" name="pre_procedure_requirements" rows="3"><?php echo htmlspecialchars($service->pre_procedure_requirements); ?></textarea>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="edit_post_procedure_instructions">Post-Procedure Instructions</label>
                    <textarea class="form-control" id="edit_post_procedure_instructions" name="post_procedure_instructions" rows="3"><?php echo htmlspecialchars($service->post_procedure_instructions); ?></textarea>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label for="edit_contraindications">Contraindications</label>
                    <textarea class="form-control" id="edit_contraindications" name="contraindications" rows="2"><?php echo htmlspecialchars($service->contraindications); ?></textarea>
                </div>
            </div>
        </div>
    </div>
    
    <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">
            Cancel
        </button>
        <button type="submit" class="btn btn-primary">
            <i class="fa fa-save"></i> Update Service
        </button>
    </div>
</form>

<script>
$(document).ready(function() {
    // Show/hide equipment section based on checkbox
    $('#edit_requires_equipment').change(function() {
        if ($(this).is(':checked')) {
            $('#edit_equipment_section').slideDown();
        } else {
            $('#edit_equipment_section').slideUp();
            $('#edit_equipment_list').val('');
        }
    });
});

$('#editServiceForm').on('submit', function(e) {
    e.preventDefault();
    
    var $form = $(this);
    var $submitBtn = $form.find('button[type="submit"]');
    var formData = $form.serialize();
    var serviceId = $form.find('input[name="service_id"]').val();
    
    $submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Updating...');
    
    // Clear previous errors
    $('.text-danger').text('');
    
    // Show loading SweetAlert
    Swal.fire({
        title: 'Updating Service...',
        html: 'Please wait while we update the service.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    $.ajax({
        url: base_url + 'admin/specialized_services/edit_service/' + serviceId,
        type: 'POST',
        data: formData,
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                $('#editServiceModal').modal('hide');
                if (window.servicesTable) {
                    window.servicesTable.ajax.reload(null, false);
                }
                
                Swal.fire({
                    icon: 'success',
                    title: 'Service Updated!',
                    html: response.message,
                    confirmButtonColor: '#28a745',
                    timer: 3000,
                    timerProgressBar: true
                });
            } else {
                if (response.error && typeof response.error === 'object') {
                    let errorList = '<ul class="text-left">';
                    $.each(response.error, function(field, error) {
                        $('#edit_' + field + '_error').text(error);
                        errorList += '<li>' + error + '</li>';
                    });
                    errorList += '</ul>';
                    
                    Swal.fire({
                        icon: 'error',
                        title: 'Validation Errors',
                        html: errorList,
                        confirmButtonColor: '#dc3545'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Update Failed',
                        html: response.message,
                        confirmButtonColor: '#dc3545'
                    });
                }
            }
        },
        error: function() {
            Swal.fire({
                icon: 'error',
                title: 'Update Failed',
                html: 'An error occurred while updating the service.',
                confirmButtonColor: '#dc3545'
            });
        },
        complete: function() {
            $submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Update Service');
        }
    });
    
    return false;
});
</script>