<!-- application/views/admin/radiology/verify_order.php -->
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title><?php echo $title; ?> - Patient Verification</title>
    <style>
        .content-wrapper {
            background: #f8f9fa;
            min-height: 100vh;
            padding: 20px;
        }
        
        .page-header {
            background: white;
            border-bottom: 3px solid #ffc107;
            padding: 25px 30px;
            margin-bottom: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        
        .page-title {
            color: #2c3e50;
            margin: 0;
            font-size: 32px;
            font-weight: 700;
        }
        
        .page-subtitle {
            color: #6c757d;
            margin: 8px 0 0 0;
            font-size: 16px;
        }
        
        .info-panel {
            background: white;
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 30px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        
        .info-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
        }
        
        .info-item {
            margin-bottom: 15px;
        }
        
        .info-label {
            font-weight: 600;
            color: #495057;
            margin-bottom: 5px;
        }
        
        .info-value {
            color: #2c3e50;
            font-size: 16px;
        }
        
        .workflow-badge {
            display: inline-block;
            padding: 6px 16px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .workflow-gcc {
            background: #007bff;
            color: white;
        }
        
        .workflow-general {
            background: #28a745;
            color: white;
        }
        
        .priority-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 15px;
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
        }
        
        .priority-routine { background: #17a2b8; color: white; }
        .priority-urgent { background: #ffc107; color: white; }
        .priority-stat { background: #dc3545; color: white; }
        
        .verification-panel {
            background: white;
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 30px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        
        .workflow-notice {
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
        }
        
        .notice-gcc {
            background: #e3f2fd;
            border: 1px solid #bbdefb;
            color: #1976d2;
        }
        
        .notice-general {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
        }
        
        .verification-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
            margin-top: 20px;
        }
        
        .fingerprint-status {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
        }
        
        .status-available {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
        }
        
        .status-missing {
            background: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
        }
        
        .fingerprint-capture {
            text-align: center;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 8px;
            border: 2px dashed #dee2e6;
            margin-bottom: 15px;
        }
        
        .fingerprint-image {
            max-width: 200px;
            max-height: 150px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        
        .secugen-status {
            background: #e9ecef;
            border: 1px solid #ced4da;
            border-radius: 6px;
            padding: 15px;
            margin: 15px 0;
            text-align: center;
        }
        
        .secugen-active {
            background: #d4edda;
            border-color: #c3e6cb;
            color: #155724;
        }
        
        .secugen-inactive {
            background: #f8d7da;
            border-color: #f5c6cb;
            color: #721c24;
        }
        
        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
            text-align: center;
            transition: all 0.3s ease;
            margin: 5px;
        }
        
        .btn:hover {
            transform: translateY(-1px);
        }
        
        .btn:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
        
        .btn-primary { background: #007bff; color: white; }
        .btn-success { background: #28a745; color: white; }
        .btn-warning { background: #ffc107; color: white; }
        .btn-secondary { background: #6c757d; color: white; }
        .btn-info { background: #17a2b8; color: white; }
        
        .test-list {
            display: grid;
            gap: 15px;
            margin-top: 15px;
        }
        
        .test-item {
            border: 1px solid #e9ecef;
            border-radius: 8px;
            padding: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .test-name {
            font-weight: 600;
            color: #2c3e50;
            margin-bottom: 5px;
        }
        
        .test-status {
            color: #6c757d;
            font-size: 14px;
        }
        
        .test-price {
            font-weight: 600;
            color: #28a745;
            text-align: right;
        }
        
        .alert {
            border-radius: 6px;
            padding: 15px 20px;
            margin: 15px 0;
        }
        
        .alert-success {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
        }
        
        .alert-warning {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            color: #856404;
        }
        
        .alert-danger {
            background: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
        }
        
        .alert-info {
            background: #e3f2fd;
            border: 1px solid #bbdefb;
            color: #1976d2;
        }
        
        .action-buttons {
            display: flex;
            gap: 15px;
            justify-content: center;
            margin-top: 30px;
        }
        
        .spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid #f3f3f3;
            border-top: 2px solid #007bff;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .history-panel {
            background: #f8f9fa;
            border-radius: 6px;
            padding: 15px;
            color: #6c757d;
            text-align: center;
            margin-top: 20px;
        }
        
        @media (max-width: 768px) {
            .content-wrapper { padding: 10px; }
            .info-grid { grid-template-columns: 1fr; gap: 15px; }
            .verification-grid { grid-template-columns: 1fr; gap: 15px; }
            .page-title { font-size: 24px; }
            .action-buttons { flex-direction: column; }
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <!-- Page Header -->
        <div class="page-header">
            <h1 class="page-title">
                <i class="fa fa-fingerprint"></i> Verify Patient for Order #<?php echo $order['id']; ?>
            </h1>
            <p class="page-subtitle">Complete patient verification to proceed with radiology services</p>
        </div>

        <!-- Order Information -->
        <div class="info-panel">
            <h3 style="color: #495057; margin: 0 0 20px 0; font-size: 20px; font-weight: 600;">
                <i class="fa fa-info-circle"></i> Order Information
            </h3>
            
            <div class="info-grid">
                <div>
                    <div class="info-item">
                        <div class="info-label">Patient Name:</div>
                        <div class="info-value" style="font-size: 18px; font-weight: 600;">
                            <?php echo $order['patient_name']; ?>
                        </div>
                    </div>
                    
                    <div class="info-item">
                        <div class="info-label">Patient ID:</div>
                        <div class="info-value"><?php echo $order['patient_unique_id']; ?></div>
                    </div>
                    
                    <div class="info-item">
                        <div class="info-label">Mobile Number:</div>
                        <div class="info-value"><?php echo $order['mobileno'] ?: 'Not provided'; ?></div>
                    </div>
                    
                    <div class="info-item">
                        <div class="info-label">Patient Type:</div>
                        <div class="info-value">
                            <?php 
                            $patient_type = $order['patient_type'] ?? 'GENERAL';
                            $workflow_class = $patient_type === 'GCC' ? 'workflow-gcc' : 'workflow-general';
                            ?>
                            <span class="workflow-badge <?php echo $workflow_class; ?>">
                                <?php echo $patient_type; ?> WORKFLOW
                            </span>
                        </div>
                    </div>
                </div>
                
                <div>
                    <div class="info-item">
                        <div class="info-label">Referring Doctor:</div>
                        <div class="info-value"><?php echo $order['doctor_name'] ?: 'Not assigned'; ?></div>
                    </div>
                    
                    <div class="info-item">
                        <div class="info-label">Order Date:</div>
                        <div class="info-value"><?php echo date('M j, Y g:i A', strtotime($order['order_date'])); ?></div>
                    </div>
                    
                    <div class="info-item">
                        <div class="info-label">Priority:</div>
                        <div class="info-value">
                            <span class="priority-badge priority-<?php echo $order['priority']; ?>">
                                <?php echo strtoupper($order['priority']); ?>
                            </span>
                        </div>
                    </div>
                    
                    <div class="info-item">
                        <div class="info-label">Total Amount:</div>
                        <div class="info-value" style="font-size: 18px; color: #28a745; font-weight: 600;">
                            KES <?php echo number_format($order['total_amount'], 2); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Ordered Tests -->
        <?php if (!empty($order_tests)): ?>
        <div class="info-panel">
            <h3 style="color: #495057; margin: 0 0 20px 0; font-size: 20px; font-weight: 600;">
                <i class="fa fa-list"></i> Ordered Tests (<?php echo count($order_tests); ?>)
            </h3>
            
            <div class="test-list">
                <?php foreach ($order_tests as $test): ?>
                    <div class="test-item">
                        <div>
                            <div class="test-name"><?php echo $test['test_name'] ?: 'Test #' . $test['test_id']; ?></div>
                            <div class="test-status">
                                Status: <span style="text-transform: capitalize; color: #ffc107; font-weight: 500;">
                                    <?php echo $test['status']; ?>
                                </span>
                            </div>
                        </div>
                        <div class="test-price">
                            KES <?php echo number_format($test['price'] ?? 0, 2); ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Verification Panel -->
        <div class="verification-panel">
            <h3 style="color: #495057; margin: 0 0 20px 0; font-size: 20px; font-weight: 600;">
                <i class="fa fa-shield"></i> Patient Identity Verification
            </h3>
            
            <?php if ($order['patient_type'] === 'GCC'): ?>
                <!-- GCC Workflow - Fingerprint Required -->
                <div class="workflow-notice notice-gcc">
                    <h4 style="margin: 0 0 10px 0;">
                        <i class="fa fa-exclamation-triangle"></i> GCC Workflow - Biometric Verification Required
                    </h4>
                    <p style="margin: 0;">
                        This patient follows the GCC workflow. Fingerprint verification is mandatory before proceeding with radiology services.
                    </p>
                </div>
                
                <!-- Fingerprint Verification Section -->
                <div class="verification-grid">
                    <div>
                        <h4 style="color: #495057; margin: 0 0 15px 0;">Fingerprint Status</h4>
                        <div id="fingerprintStatus" class="fingerprint-status">
                            <?php if (!empty($order['fingerprint_template'])): ?>
                                <div class="status-available">
                                    <i class="fa fa-check-circle"></i> <strong>Fingerprint Available</strong><br>
                                    <small>Stored template ready for verification</small>
                                </div>
                            <?php else: ?>
                                <div class="status-missing">
                                    <i class="fa fa-times-circle"></i> <strong>No Fingerprint Template</strong><br>
                                    <small>Patient must be registered with fingerprint first</small>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <h4 style="color: #495057; margin: 20px 0 15px 0;">Verification History</h4>
                        <div id="verificationHistory" class="history-panel">
                            <i class="fa fa-history"></i><br>
                            <small>Loading verification history...</small>
                        </div>
                    </div>
                    
                    <div>
                        <h4 style="color: #495057; margin: 0 0 15px 0;">Live Fingerprint Capture</h4>
                        
                        <!-- SecuGen Status -->
                        <div id="secugenStatus" class="secugen-status">
                            <div class="spinner"></div> Initializing SecuGen WebAPI...
                        </div>
                        
                        <!-- Fingerprint Display -->
                        <div class="fingerprint-capture">
                            <img id="liveFingerprintDisplay" 
                                 src="<?php echo base_url(); ?>Images/PlaceFinger.bmp" 
                                 alt="Live Fingerprint" 
                                 class="fingerprint-image">
                            <div id="fingerprintCapture" style="margin-top: 15px; color: #6c757d;">
                                <small>Place finger on scanner</small>
                            </div>
                        </div>
                        
                        <!-- Verification Controls -->
                        <div style="display: flex; gap: 10px; justify-content: center; flex-wrap: wrap;">
                            <button type="button" id="captureBtn" onclick="captureFingerprint()" class="btn btn-primary">
                                <i class="fa fa-hand-paper-o"></i> Capture Fingerprint
                            </button>
                            
                            <button type="button" id="verifyBtn" onclick="verifyFingerprint()" disabled class="btn btn-success">
                                <i class="fa fa-check-circle"></i> Verify Identity
                            </button>
                            
                            <button type="button" onclick="manualOverride()" class="btn btn-secondary">
                                <i class="fa fa-user-check"></i> Manual Override
                            </button>
                        </div>
                    </div>
                </div>
                
            <?php else: ?>
                <!-- General/Specialized Workflow - Verification Optional -->
                <div class="workflow-notice notice-general">
                    <h4 style="margin: 0 0 10px 0;">
                        <i class="fa fa-check-circle"></i> General Workflow - Verification Optional
                    </h4>
                    <p style="margin: 0 0 15px 0;">
                        This patient follows the General workflow. Fingerprint verification is optional but recommended for security.
                    </p>
                    
                    <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                        <button onclick="proceedWithoutVerification()" class="btn btn-success">
                            <i class="fa fa-arrow-right"></i> Proceed Without Verification
                        </button>
                        
                        <button onclick="performOptionalVerification()" class="btn btn-info">
                            <i class="fa fa-fingerprint"></i> Verify with Fingerprint
                        </button>
                    </div>
                </div>
            <?php endif; ?>
            
            <!-- Verification Result -->
            <div id="verificationResult"></div>
        </div>

        <!-- Action Buttons -->
        <div class="action-buttons">
            <a href="<?php echo base_url(); ?>admin/radiology/orders" class="btn btn-secondary">
                <i class="fa fa-arrow-left"></i> Back to Orders
            </a>
            
            <a href="<?php echo base_url(); ?>admin/radiology/view_order/<?php echo $order['id']; ?>" class="btn btn-info">
                <i class="fa fa-eye"></i> View Order Details
            </a>
        </div>
    </div>

    <!-- Hidden Form for Verification Data -->
    <form id="verificationForm" style="display: none;">
        <input type="hidden" id="orderId" value="<?php echo $order['id']; ?>">
        <input type="hidden" id="patientId" value="<?php echo $order['patient_id']; ?>">
        <input type="hidden" id="liveTemplate" name="live_template">
        <input type="hidden" id="verificationMethod" name="verification_method">
        <input type="hidden" id="matchScore" name="match_score">
    </form>

    <script>
        // Global state for verification
        const verificationState = {
            orderId: <?php echo $order['id']; ?>,
            patientId: <?php echo $order['patient_id']; ?>,
            hasStoredTemplate: <?php echo !empty($order['fingerprint_template']) ? 'true' : 'false'; ?>,
            patientType: '<?php echo $order['patient_type'] ?? 'GENERAL'; ?>',
            liveTemplate: null,
            secugenActive: false
        };

        // Initialize when document is ready
        document.addEventListener('DOMContentLoaded', function() {
            console.log('Order verification page loaded');
            console.log('Verification state:', verificationState);
            
            // Initialize based on patient type
            if (verificationState.patientType === 'GCC') {
                initializeSecuGenForGCC();
            } else {
                initializeGeneralWorkflow();
            }
            
            // Load verification history
            loadVerificationHistory();
        });

        function initializeSecuGenForGCC() {
            console.log('Initializing SecuGen for GCC patient...');
            
            if (!verificationState.hasStoredTemplate) {
                showFingerprintError('No stored fingerprint template found. Patient must be registered first.');
                return;
            }
            
            // Initialize SecuGen connection
            detectSecuGenService();
        }

        function initializeGeneralWorkflow() {
            console.log('General workflow - fingerprint verification optional');
            // No special initialization needed for general workflow
        }

        function detectSecuGenService() {
            updateSecuGenStatus('checking', 'Detecting SecuGen WebAPI...');
            
            const testUrls = [
                'https://localhost:8443/SGIFPGetInfo',
                'http://localhost:8000/SGIFPGetInfo'
            ];
            
            let urlIndex = 0;
            
            function tryNextUrl() {
                if (urlIndex >= testUrls.length) {
                    updateSecuGenStatus('inactive', 'SecuGen WebAPI not detected. Please ensure it is running.');
                    return;
                }
                
                const url = testUrls[urlIndex];
                
                fetch(url, { method: 'GET', signal: AbortSignal.timeout(3000) })
                    .then(response => response.json())
                    .then(data => {
                        verificationState.secugenActive = true;
                        updateSecuGenStatus('active', 'SecuGen WebAPI connected successfully');
                        enableCaptureButton();
                    })
                    .catch(error => {
                        urlIndex++;
                        setTimeout(tryNextUrl, 1000);
                    });
            }
            
            tryNextUrl();
        }

        function updateSecuGenStatus(status, message) {
            const statusDiv = document.getElementById('secugenStatus');
            statusDiv.className = 'secugen-status';
            
            switch (status) {
                case 'checking':
                    statusDiv.innerHTML = `<div><div class="spinner"></div> ${message}</div>`;
                    break;
                case 'active':
                    statusDiv.classList.add('secugen-active');
                    statusDiv.innerHTML = `<i class="fa fa-check-circle"></i> ${message}`;
                    break;
                case 'inactive':
                    statusDiv.classList.add('secugen-inactive');
                    statusDiv.innerHTML = `<i class="fa fa-exclamation-triangle"></i> ${message}`;
                    break;
            }
        }

        function enableCaptureButton() {
            const captureBtn = document.getElementById('captureBtn');
            captureBtn.disabled = false;
            captureBtn.style.opacity = '1';
        }

        function captureFingerprint() {
            if (!verificationState.secugenActive) {
                alert('SecuGen service not available. Please ensure the WebAPI is running.');
                return;
            }
            
            console.log('Starting fingerprint capture...');
            
            const captureDiv = document.getElementById('fingerprintCapture');
            captureDiv.innerHTML = '<div><div class="spinner"></div> <strong>Capturing fingerprint...</strong><br><small>Place finger firmly on scanner</small></div>';
            
            const captureBtn = document.getElementById('captureBtn');
            captureBtn.disabled = true;
            captureBtn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Scanning...';
            
            // Call SecuGen capture
            fetch('https://localhost:8443/SGIFPCapture', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'Quality=50&Timeout=20000&WSQCompression=2.25'
            })
            .then(response => response.json())
            .then(result => handleCaptureResult(result))
            .catch(error => {
                console.error('Capture error:', error);
                showCaptureError('Failed to capture fingerprint: ' + error.message);
            })
            .finally(() => {
                captureBtn.disabled = false;
                captureBtn.innerHTML = '<i class="fa fa-hand-paper-o"></i> Capture Fingerprint';
            });
        }

        function handleCaptureResult(data) {
            if (data.ErrorCode === 0) {
                // Success
                if (data.BMPBase64) {
                    document.getElementById('liveFingerprintDisplay').src = 'data:image/bmp;base64,' + data.BMPBase64;
                }
                
                if (data.TemplateBase64) {
                    verificationState.liveTemplate = data.TemplateBase64;
                    document.getElementById('liveTemplate').value = data.TemplateBase64;
                }
                
                const quality = data.Quality || 50;
                document.getElementById('fingerprintCapture').innerHTML = `
                    <div style="color: #28a745;">
                        <i class="fa fa-check-circle"></i> <strong>Fingerprint captured successfully!</strong><br>
                        <small>Quality: ${quality}% | Ready for verification</small>
                    </div>
                `;
                
                // Enable verify button
                const verifyBtn = document.getElementById('verifyBtn');
                verifyBtn.disabled = false;
                verifyBtn.style.opacity = '1';
                
            } else {
                const errorMsg = getSecuGenErrorMessage(data.ErrorCode);
                showCaptureError(`Capture failed: ${errorMsg} (Code: ${data.ErrorCode})`);
            }
        }

        function showCaptureError(message) {
            document.getElementById('fingerprintCapture').innerHTML = `
                <div style="color: #dc3545;">
                    <i class="fa fa-times-circle"></i> <strong>Capture Failed</strong><br>
                    <small>${message}</small>
                    <div style="margin-top: 10px;">
                        <button onclick="captureFingerprint()" class="btn btn-warning" style="font-size: 12px; padding: 5px 10px;">
                            <i class="fa fa-refresh"></i> Try Again
                        </button>
                    </div>
                </div>
            `;
        }

        function verifyFingerprint() {
            if (!verificationState.liveTemplate) {
                alert('Please capture fingerprint first');
                return;
            }
            
            console.log('Starting fingerprint verification...');
            
            showVerificationResult('info', 'Verifying patient identity...', 'Comparing live fingerprint with stored template');
            
            // Submit verification to backend
            fetch('<?php echo base_url(); ?>admin/radiology/process_order_verification', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    order_id: verificationState.orderId,
                    patient_id: verificationState.patientId,
                    verification_method: 'biometric',
                    live_template: verificationState.liveTemplate
                })
            })
            .then(response => response.json())
            .then(result => handleVerificationResult(result))
            .catch(error => {
                showVerificationResult('danger', 'Verification Error', 'Failed to verify: ' + error.message);
            });
        }

        function handleVerificationResult(response) {
            if (response.success && response.verification_result === 'success') {
                showVerificationResult('success', 'Verification Successful!', 
                    `Patient identity confirmed. Order #${verificationState.orderId} is ready for processing.`,
                    '<button onclick="proceedToExam()" class="btn btn-success"><i class="fa fa-arrow-right"></i> Proceed to Examination</button>'
                );
            } else {
                showVerificationResult('danger', 'Verification Failed', 
                    response.message || 'Fingerprint does not match stored template.',
                    `<button onclick="captureFingerprint()" class="btn btn-warning"><i class="fa fa-refresh"></i> Try Again</button>
                     <button onclick="manualOverride()" class="btn btn-secondary"><i class="fa fa-user-check"></i> Manual Override</button>`
                );
            }
        }

        function showVerificationResult(type, title, message, buttons = '') {
            document.getElementById('verificationResult').innerHTML = `
                <div class="alert alert-${type}">
                    <h4 style="margin: 0 0 10px 0;"><i class="fa fa-${type === 'success' ? 'check-circle' : type === 'danger' ? 'times-circle' : 'info-circle'}"></i> ${title}</h4>
                    <p style="margin: ${buttons ? '0 0 15px 0' : '0'};">${message}</p>
                    ${buttons}
                </div>
            `;
        }

        function manualOverride() {
            const reason = prompt('Manual override reason (required):');
            
            if (!reason || reason.trim() === '') {
                alert('Reason is required for manual override');
                return;
            }
            
            console.log('Processing manual override...');
            
            fetch('<?php echo base_url(); ?>admin/radiology/process_order_verification', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    order_id: verificationState.orderId,
                    patient_id: verificationState.patientId,
                    verification_method: 'manual_override',
                    verification_result: 'success',
                    override_reason: reason.trim()
                })
            })
            .then(response => response.json())
            .then(result => {
                showVerificationResult('warning', 'Manual Override Completed', 
                    `<strong>Reason:</strong> ${reason}<br>Patient verified by authorized staff override.`,
                    '<button onclick="proceedToExam()" class="btn btn-success"><i class="fa fa-arrow-right"></i> Proceed to Examination</button>'
                );
            })
            .catch(error => {
                alert('Failed to process manual override');
            });
        }

        function proceedWithoutVerification() {
            console.log('Proceeding without verification for General workflow...');
            
            fetch('<?php echo base_url(); ?>admin/radiology/process_order_verification', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    order_id: verificationState.orderId,
                    patient_id: verificationState.patientId,
                    verification_method: 'workflow_bypass',
                    verification_result: 'success'
                })
            })
            .then(response => response.json())
            .then(result => {
                showVerificationResult('success', 'Verification Bypassed', 
                    'General workflow allows proceeding without biometric verification.',
                    '<button onclick="proceedToExam()" class="btn btn-success"><i class="fa fa-arrow-right"></i> Proceed to Examination</button>'
                );
            })
            .catch(error => {
                alert('Failed to process workflow bypass');
            });
        }

        function performOptionalVerification() {
            alert('Optional fingerprint verification for General workflow - feature coming soon');
        }

        function proceedToExam() {
            if (confirm('Proceed to start examination for this order?')) {
                window.location.href = '<?php echo base_url(); ?>admin/radiology/start_exam/<?php echo $order['id']; ?>';
            }
        }

        function loadVerificationHistory() {
            setTimeout(function() {
                document.getElementById('verificationHistory').innerHTML = `
                    <div style="font-size: 12px; color: #6c757d;">
                        <div style="padding: 8px 0; border-bottom: 1px solid #e9ecef;">
                            <strong>Last verified:</strong> Never
                        </div>
                        <div style="padding: 8px 0;">
                            <strong>Total verifications:</strong> 0
                        </div>
                    </div>
                `;
            }, 1000);
        }

        function getSecuGenErrorMessage(errorCode) {
            const errorMessages = {
                1: 'Device not found',
                2: 'Function failed',
                3: 'Invalid parameters',
                51: 'Scan timeout',
                52: 'Poor image quality',
                53: 'Finger not properly placed',
                54: 'Timeout occurred',
                55: 'Device not responding'
            };
            
            return errorMessages[errorCode] || 'Unknown error';
        }

        function showFingerprintError(message) {
            document.getElementById('fingerprintStatus').innerHTML = `
                <div class="status-missing">
                    <i class="fa fa-times-circle"></i> <strong>Fingerprint Error</strong><br>
                    <small>${message}</small>
                </div>
            `;
        }
    </script>
</body>
</html>