<div class="modal-body">
    <div class="row">
        <div class="col-md-12">
            <table class="table table-striped table-bordered">
                <tbody>
                    <tr>
                        <th width="30%"><?php echo $this->lang->line('test_name'); ?></th>
                        <td><?php echo htmlspecialchars($test->test_name); ?></td>
                    </tr>
                    <tr>
                        <th><?php echo $this->lang->line('test_code'); ?></th>
                        <td><code><?php echo htmlspecialchars($test->test_code); ?></code></td>
                    </tr>
                    <tr>
                        <th><?php echo $this->lang->line('category'); ?></th>
                        <td>
                            <span class="label label-primary"><?php echo htmlspecialchars($test->category); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <th><?php echo $this->lang->line('estimated_duration'); ?></th>
                        <td><?php echo $test->estimated_duration; ?> minutes</td>
                    </tr>
                    <tr>
                        <th><?php echo $this->lang->line('price'); ?></th>
                        <td>
                            <strong class="text-success">Ksh. <?php echo number_format($test->price, 2); ?></strong>
                        </td>
                    </tr>
                    <tr>
                        <th><?php echo $this->lang->line('requires_contrast'); ?></th>
                        <td>
                            <?php if ($test->requires_contrast == 1): ?>
                                <span class="label label-warning">Yes</span>
                            <?php else: ?>
                                <span class="label label-default">No</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <th><?php echo $this->lang->line('requires_fasting'); ?></th>
                        <td>
                            <?php if ($test->requires_fasting == 1): ?>
                                <span class="label label-info">Yes</span>
                            <?php else: ?>
                                <span class="label label-default">No</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <th><i class="fa fa-star text-warning"></i> GCC Test</th>
                        <td>
                            <?php if ($test->is_gcc == 1): ?>
                                <span class="label label-success"><i class="fa fa-star"></i> Yes - GCC Test</span>
                                <small class="help-block">This test is part of the GCC medical examination workflow</small>
                            <?php else: ?>
                                <span class="label label-default">No - Regular Test</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <th><?php echo $this->lang->line('status'); ?></th>
                        <td>
                            <?php if ($test->is_active == 1): ?>
                                <span class="label label-success">Active</span>
                            <?php else: ?>
                                <span class="label label-danger">Inactive</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php if (!empty($test->description)): ?>
                    <tr>
                        <th><?php echo $this->lang->line('description'); ?></th>
                        <td><?php echo nl2br(htmlspecialchars($test->description)); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if (!empty($test->preparation_instructions)): ?>
                    <tr>
                        <th><?php echo $this->lang->line('preparation_instructions'); ?></th>
                        <td>
                            <div class="well well-sm">
                                <?php echo nl2br(htmlspecialchars($test->preparation_instructions)); ?>
                            </div>
                        </td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <th><?php echo $this->lang->line('created_at'); ?></th>
                        <td><?php echo date('d M Y, H:i A', strtotime($test->created_at)); ?></td>
                    </tr>
                    <tr>
                        <th><?php echo $this->lang->line('updated_at'); ?></th>
                        <td><?php echo date('d M Y, H:i A', strtotime($test->updated_at)); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-default" data-dismiss="modal">
        <?php echo $this->lang->line('close'); ?>
    </button>
    <?php if (method_exists($this, 'checkPermission') ? $this->checkPermission('can_edit') : true): ?>
        <button type="button" class="btn btn-primary" onclick="editRadiologyTest(<?php echo $test->id; ?>); $('#viewRadiologyTestModal').modal('hide');">
            <i class="fa fa-edit"></i> <?php echo $this->lang->line('edit'); ?>
        </button>
    <?php endif; ?>
</div>