<form id="editRadiologyTestForm" method="post" role="form">
    <div class="modal-body">
        <input type="hidden" name="test_id" value="<?php echo $test->id; ?>">
        
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="edit_test_name"><?php echo $this->lang->line('test_name'); ?> <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="edit_test_name" name="test_name" value="<?php echo htmlspecialchars($test->test_name); ?>" required>
                    <span class="text-danger" id="edit_test_name_error"></span>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="edit_test_code"><?php echo $this->lang->line('test_code'); ?> <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="edit_test_code" name="test_code" value="<?php echo htmlspecialchars($test->test_code); ?>" required>
                    <span class="text-danger" id="edit_test_code_error"></span>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="edit_category"><?php echo $this->lang->line('category'); ?> <span class="text-danger">*</span></label>
                    <select class="form-control" id="edit_category" name="category" required>
                        <option value=""><?php echo $this->lang->line('select_category'); ?></option>
                        <?php foreach ($categories as $key => $category): ?>
                            <option value="<?php echo $key; ?>" <?php echo ($test->category == $key) ? 'selected' : ''; ?>><?php echo $category; ?></option>
                        <?php endforeach; ?>
                    </select>
                    <span class="text-danger" id="edit_category_error"></span>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="edit_estimated_duration"><?php echo $this->lang->line('estimated_duration'); ?> (minutes)</label>
                    <input type="number" class="form-control" id="edit_estimated_duration" name="estimated_duration" min="5" max="180" value="<?php echo $test->estimated_duration; ?>">
                    <span class="text-danger" id="edit_estimated_duration_error"></span>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label for="edit_price"><?php echo $this->lang->line('price'); ?> <span class="text-danger">*</span></label>
                    <div class="input-group">
                        <span class="input-group-addon">Ksh.</span>
                        <input type="number" class="form-control" id="edit_price" name="price" step="0.01" min="0" value="<?php echo $test->price; ?>" required>
                    </div>
                    <span class="text-danger" id="edit_price_error"></span>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="edit_requires_contrast"><?php echo $this->lang->line('requires_contrast'); ?></label>
                    <select class="form-control" id="edit_requires_contrast" name="requires_contrast">
                        <option value="0" <?php echo ($test->requires_contrast == 0) ? 'selected' : ''; ?>>No</option>
                        <option value="1" <?php echo ($test->requires_contrast == 1) ? 'selected' : ''; ?>>Yes</option>
                    </select>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="edit_requires_fasting"><?php echo $this->lang->line('requires_fasting'); ?></label>
                    <select class="form-control" id="edit_requires_fasting" name="requires_fasting">
                        <option value="0" <?php echo ($test->requires_fasting == 0) ? 'selected' : ''; ?>>No</option>
                        <option value="1" <?php echo ($test->requires_fasting == 1) ? 'selected' : ''; ?>>Yes</option>
                    </select>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label for="edit_description"><?php echo $this->lang->line('description'); ?></label>
                    <textarea class="form-control" id="edit_description" name="description" rows="3"><?php echo htmlspecialchars($test->description); ?></textarea>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label for="edit_preparation_instructions"><?php echo $this->lang->line('preparation_instructions'); ?></label>
                    <textarea class="form-control" id="edit_preparation_instructions" name="preparation_instructions" rows="3"><?php echo htmlspecialchars($test->preparation_instructions); ?></textarea>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">
            <?php echo $this->lang->line('cancel'); ?>
        </button>
        <button type="submit" class="btn btn-primary">
            <i class="fa fa-save"></i> <?php echo $this->lang->line('update'); ?>
        </button>
    </div>
</form>

<script>
$(document).ready(function() {
    $('#editRadiologyTestForm').on('submit', function(e) {
        e.preventDefault();
        
        var $form = $(this);
        var $submitBtn = $form.find('button[type="submit"]');
        var formData = $form.serialize();
        
        // Debug: Log form data
        console.log('Edit form data:', formData);
        console.log('Form fields:', {
            test_id: $form.find('input[name="test_id"]').val(),
            test_name: $form.find('input[name="test_name"]').val(),
            test_code: $form.find('input[name="test_code"]').val(),
            category: $form.find('select[name="category"]').val(),
            price: $form.find('input[name="price"]').val()
        });
        
        $submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Updating...');
        
        // Clear previous errors
        $('.text-danger').text('');
        
        $.ajax({
            url: base_url + 'admin/radiology-setup/update-test',
            type: 'POST',
            data: formData,
            dataType: 'json',
            beforeSend: function() {
                console.log('Sending update request...');
            },
            success: function(response) {
                console.log('Update response:', response);
                
                if (response.status === 'success') {
                    $('#editRadiologyTestModal').modal('hide');
                    $('#radiologyTestsTable').DataTable().ajax.reload();
                    showMessage(response.message, 'success');
                } else {
                    // Handle validation errors
                    if (response.error && typeof response.error === 'object') {
                        $.each(response.error, function(field, error) {
                            $('#edit_' + field + '_error').text(error);
                        });
                    }
                    if (response.message) {
                        showMessage(response.message, 'error');
                    }
                    
                    // Log debug info if available
                    if (response.debug) {
                        console.error('Debug info:', response.debug);
                    }
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error Details:', {
                    status: xhr.status,
                    statusText: xhr.statusText,
                    responseText: xhr.responseText,
                    error: error
                });
                
                let errorMessage = 'An error occurred while updating the test.';
                
                // Try to parse error response
                try {
                    const errorResponse = JSON.parse(xhr.responseText);
                    if (errorResponse.message) {
                        errorMessage = errorResponse.message;
                    }
                } catch (e) {
                    if (xhr.status === 404) {
                        errorMessage = 'Update endpoint not found. Check routes configuration.';
                    } else if (xhr.status === 500) {
                        errorMessage = 'Server error occurred. Check server logs.';
                    } else if (xhr.status === 0) {
                        errorMessage = 'Network error. Please check your connection.';
                    }
                }
                
                showMessage(errorMessage, 'error');
            },
            complete: function() {
                $submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Update');
                console.log('Update request completed');
            }
        });
        
        return false;
    });
    
    // Validate required fields on change
    $('#edit_test_name, #edit_test_code, #edit_category, #edit_price').on('blur', function() {
        var $field = $(this);
        var value = $field.val().trim();
        var fieldName = $field.attr('name');
        
        if (!value && $field.prop('required')) {
            $('#edit_' + fieldName + '_error').text('This field is required');
            $field.addClass('is-invalid');
        } else {
            $('#edit_' + fieldName + '_error').text('');
            $field.removeClass('is-invalid');
        }
    });
});

// Test function to verify the endpoint
function testUpdateEndpoint() {
    console.log('Testing update endpoint...');
    console.log('URL:', base_url + 'admin/radiology-setup/update-test');
    
    $.ajax({
        url: base_url + 'admin/radiology-setup/update-test',
        type: 'POST',
        data: { test: 'connection' },
        success: function(response) {
            console.log('Endpoint accessible:', response);
        },
        error: function(xhr) {
            console.log('Endpoint error:', xhr.status, xhr.responseText);
        }
    });
}
</script>