<!-- application/views/admin/radiology/schedule.php -->
<div class="content-wrapper" style="background: #f8f9fa; min-height: 100vh; padding: 20px;">
    <!-- Page Header -->
    <div class="dashboard-header" style="background: white; border-bottom: 3px solid #17a2b8; padding: 25px 30px; margin-bottom: 30px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
        <h1 style="color: #2c3e50; margin: 0; font-size: 32px; font-weight: 700;">
            <i class="fa fa-calendar-check-o"></i> Radiology Scheduling
        </h1>
        <p style="color: #6c757d; margin: 8px 0 0 0; font-size: 16px;">Manage appointments and equipment scheduling</p>
    </div>

    <!-- Week Navigation -->
    <div style="background: white; border-radius: 12px; padding: 20px; margin-bottom: 20px; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
        <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap;">
            <div style="display: flex; align-items: center; gap: 15px;">
                <button onclick="previousWeek()" style="background: #6c757d; color: white; border: none; padding: 8px 12px; border-radius: 6px; cursor: pointer;">
                    <i class="fa fa-chevron-left"></i> Previous Week
                </button>
                
                <h4 style="margin: 0; color: #2c3e50;">
                    Week of <?php echo date('M j, Y', strtotime($week_start)); ?>
                </h4>
                
                <button onclick="nextWeek()" style="background: #6c757d; color: white; border: none; padding: 8px 12px; border-radius: 6px; cursor: pointer;">
                    Next Week <i class="fa fa-chevron-right"></i>
                </button>
                
                <button onclick="goToToday()" style="background: #007bff; color: white; border: none; padding: 8px 12px; border-radius: 6px; cursor: pointer;">
                    <i class="fa fa-calendar"></i> Today
                </button>
            </div>
            
            <div>
                <button onclick="openScheduleModal()" style="background: #28a745; color: white; border: none; padding: 10px 20px; border-radius: 6px; cursor: pointer;">
                    <i class="fa fa-plus"></i> Schedule Appointment
                </button>
            </div>
        </div>
    </div>

    <!-- Equipment Status -->
    <div style="background: white; border-radius: 12px; padding: 20px; margin-bottom: 20px; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
        <h3 style="color: #495057; margin: 0 0 15px 0; font-size: 18px; font-weight: 600;">
            <i class="fa fa-cogs"></i> Equipment Status
        </h3>
        
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px;">
            <?php if (isset($equipment_list) && !empty($equipment_list)): ?>
                <?php foreach ($equipment_list as $equipment): ?>
                    <div style="border: 2px solid #e9ecef; border-radius: 8px; padding: 15px; text-align: center;">
                        <div style="font-weight: 600; color: #2c3e50; margin-bottom: 5px;">
                            <?php echo $equipment['equipment_name']; ?>
                        </div>
                        <div style="font-size: 12px; color: #6c757d; margin-bottom: 10px;">
                            <?php echo $equipment['location']; ?>
                        </div>
                        <div>
                            <?php if (isset($equipment['status']) && $equipment['status'] === 'maintenance'): ?>
                                <span style="background: #ffc107; color: white; padding: 4px 8px; border-radius: 4px; font-size: 11px;">
                                    <i class="fa fa-wrench"></i> Maintenance
                                </span>
                            <?php else: ?>
                                <span style="background: #28a745; color: white; padding: 4px 8px; border-radius: 4px; font-size: 11px;">
                                    <i class="fa fa-check"></i> Available
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div style="grid-column: 1 / -1; text-align: center; color: #6c757d; padding: 20px;">
                    <i class="fa fa-cogs" style="font-size: 24px; opacity: 0.5;"></i>
                    <p>No equipment configured</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Weekly Calendar -->
    <div style="background: white; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); overflow: hidden;">
        <div style="background: #f8f9fa; border-bottom: 2px solid #dee2e6; padding: 20px;">
            <h3 style="color: #495057; margin: 0; font-size: 18px; font-weight: 600;">
                <i class="fa fa-calendar"></i> Weekly Schedule
            </h3>
        </div>
        
        <div style="overflow-x: auto;">
            <table style="width: 100%; border-collapse: collapse; min-width: 800px;">
                <thead style="background: #f8f9fa;">
                    <tr>
                        <th style="padding: 15px; text-align: left; border-bottom: 1px solid #dee2e6; font-weight: 600; width: 100px;">Time</th>
                        <?php 
                        $days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
                        for ($i = 0; $i < 7; $i++): 
                            $current_date = date('Y-m-d', strtotime($week_start . " +$i days"));
                            $day_name = $days[$i];
                            $is_today = $current_date === date('Y-m-d');
                        ?>
                            <th style="padding: 15px; text-align: center; border-bottom: 1px solid #dee2e6; font-weight: 600; <?php echo $is_today ? 'background: #e3f2fd;' : ''; ?>">
                                <?php echo $day_name; ?><br>
                                <small style="font-weight: normal; color: #6c757d;">
                                    <?php echo date('M j', strtotime($current_date)); ?>
                                </small>
                            </th>
                        <?php endfor; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $time_slots = isset($time_slots) ? $time_slots : [
                        '08:00' => '08:00 AM', '09:00' => '09:00 AM', '10:00' => '10:00 AM',
                        '11:00' => '11:00 AM', '12:00' => '12:00 PM', '14:00' => '02:00 PM',
                        '15:00' => '03:00 PM', '16:00' => '04:00 PM', '17:00' => '05:00 PM'
                    ];
                    
                    foreach ($time_slots as $time => $time_display): ?>
                        <tr style="border-bottom: 1px solid #f1f3f4;">
                            <td style="padding: 15px; font-weight: 600; color: #495057; background: #f8f9fa;">
                                <?php echo $time_display; ?>
                            </td>
                            
                            <?php for ($i = 0; $i < 7; $i++): 
                                $current_date = date('Y-m-d', strtotime($week_start . " +$i days"));
                                $is_today = $current_date === date('Y-m-d');
                                
                                // Find appointments for this date and time
                                $slot_appointments = [];
                                if (isset($appointments) && is_array($appointments)) {
                                    foreach ($appointments as $appointment) {
                                        if (date('Y-m-d', strtotime($appointment['scheduled_date'])) === $current_date && 
                                            date('H:i', strtotime($appointment['scheduled_time'])) === $time) {
                                            $slot_appointments[] = $appointment;
                                        }
                                    }
                                }
                            ?>
                                <td style="padding: 8px; text-align: center; vertical-align: top; <?php echo $is_today ? 'background: #f8f9ff;' : ''; ?> cursor: pointer;" 
                                    onclick="scheduleAppointment('<?php echo $current_date; ?>', '<?php echo $time; ?>')">
                                    
                                    <?php if (!empty($slot_appointments)): ?>
                                        <?php foreach ($slot_appointments as $appointment): ?>
                                            <div style="background: #007bff; color: white; border-radius: 4px; padding: 4px 6px; margin-bottom: 2px; font-size: 11px; cursor: pointer;"
                                                 onclick="event.stopPropagation(); viewAppointment(<?php echo $appointment['order_id']; ?>)">
                                                <div style="font-weight: 600;"><?php echo $appointment['patient_name']; ?></div>
                                                <div style="opacity: 0.8;">Order #<?php echo $appointment['order_id']; ?></div>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <div style="color: #6c757d; font-size: 12px; padding: 10px;">
                                            <i class="fa fa-plus-circle"></i><br>
                                            Available
                                        </div>
                                    <?php endif; ?>
                                </td>
                            <?php endfor; ?>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Appointments List -->
    <div style="background: white; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); margin-top: 20px; overflow: hidden;">
        <div style="background: #f8f9fa; border-bottom: 2px solid #dee2e6; padding: 20px;">
            <h3 style="color: #495057; margin: 0; font-size: 18px; font-weight: 600;">
                <i class="fa fa-list"></i> This Week's Appointments
            </h3>
        </div>
        
        <div style="padding: 20px;">
            <?php if (empty($appointments)): ?>
                <div style="text-align: center; color: #6c757d; padding: 40px;">
                    <i class="fa fa-calendar-o" style="font-size: 48px; opacity: 0.5; margin-bottom: 15px; display: block;"></i>
                    <h5>No Appointments This Week</h5>
                    <p>Click on any time slot above to schedule an appointment.</p>
                </div>
            <?php else: ?>
                <div style="display: grid; gap: 15px;">
                    <?php foreach ($appointments as $appointment): ?>
                        <div style="border: 1px solid #e9ecef; border-radius: 8px; padding: 15px; transition: all 0.3s ease;"
                             onmouseover="this.style.borderColor='#007bff'; this.style.boxShadow='0 2px 8px rgba(0,123,255,0.15)'"
                             onmouseout="this.style.borderColor='#e9ecef'; this.style.boxShadow='none'">
                            
                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                <div>
                                    <div style="font-weight: 600; color: #2c3e50; font-size: 16px;">
                                        <?php echo $appointment['patient_name']; ?>
                                    </div>
                                    <div style="color: #6c757d; font-size: 14px; margin: 5px 0;">
                                        Order #<?php echo $appointment['order_id']; ?> | 
                                        ID: <?php echo $appointment['patient_unique_id']; ?>
                                    </div>
                                    <div style="color: #17a2b8; font-weight: 600;">
                                        <?php echo date('l, M j, Y', strtotime($appointment['scheduled_date'] ?? date('Y-m-d'))); ?> at 
                                        <?php echo date('g:i A', strtotime($appointment['scheduled_time'] ?? '09:00')); ?>
                                    </div>
                                </div>
                                
                                <div style="display: flex; gap: 8px;">
                                    <?php 
                                    $status_colors = [
                                        'pending' => '#ffc107',
                                        'in_progress' => '#17a2b8', 
                                        'completed' => '#28a745'
                                    ];
                                    $status_color = $status_colors[$appointment['status']] ?? '#6c757d';
                                    ?>
                                    <span style="background: <?php echo $status_color; ?>; color: white; padding: 4px 10px; border-radius: 15px; font-size: 11px; font-weight: 600; text-transform: uppercase;">
                                        <?php echo str_replace('_', ' ', $appointment['status']); ?>
                                    </span>
                                    
                                    <button onclick="viewAppointment(<?php echo $appointment['order_id']; ?>)" 
                                            style="background: #007bff; color: white; border: none; padding: 5px 10px; border-radius: 4px; cursor: pointer; font-size: 12px;">
                                        <i class="fa fa-eye"></i>
                                    </button>
                                    
                                    <button onclick="editAppointment(<?php echo $appointment['order_id']; ?>)" 
                                            style="background: #ffc107; color: white; border: none; padding: 5px 10px; border-radius: 4px; cursor: pointer; font-size: 12px;">
                                        <i class="fa fa-edit"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Schedule Appointment Modal -->
<div id="scheduleModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 9999;">
    <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; border-radius: 12px; padding: 30px; width: 90%; max-width: 500px; max-height: 90vh; overflow-y: auto;">
        <h3 style="margin: 0 0 20px 0; color: #2c3e50;">
            <i class="fa fa-calendar-plus-o"></i> Schedule Appointment
        </h3>
        
        <form id="scheduleForm">
            <div style="margin-bottom: 15px;">
                <label style="display: block; margin-bottom: 5px; font-weight: 600;">Date:</label>
                <input type="date" id="appointmentDate" style="width: 100%; padding: 10px; border: 2px solid #e9ecef; border-radius: 6px;" required>
            </div>
            
            <div style="margin-bottom: 15px;">
                <label style="display: block; margin-bottom: 5px; font-weight: 600;">Time:</label>
                <select id="appointmentTime" style="width: 100%; padding: 10px; border: 2px solid #e9ecef; border-radius: 6px;" required>
                    <option value="">Select time</option>
                    <?php foreach ($time_slots as $time => $time_display): ?>
                        <option value="<?php echo $time; ?>"><?php echo $time_display; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div style="margin-bottom: 15px;">
                <label style="display: block; margin-bottom: 5px; font-weight: 600;">Equipment:</label>
                <select id="appointmentEquipment" style="width: 100%; padding: 10px; border: 2px solid #e9ecef; border-radius: 6px;" required>
                    <option value="">Select equipment</option>
                    <?php if (isset($equipment_list)): ?>
                        <?php foreach ($equipment_list as $equipment): ?>
                            <option value="<?php echo $equipment['id']; ?>"><?php echo $equipment['equipment_name']; ?> - <?php echo $equipment['location']; ?></option>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </select>
            </div>
            
            <div style="margin-bottom: 20px;">
                <label style="display: block; margin-bottom: 5px; font-weight: 600;">Patient Search:</label>
                <input type="text" id="patientSearch" placeholder="Search patient by name or ID..." 
                       style="width: 100%; padding: 10px; border: 2px solid #e9ecef; border-radius: 6px;">
                <div id="patientResults" style="margin-top: 10px;"></div>
            </div>
            
            <div style="display: flex; gap: 10px; justify-content: flex-end;">
                <button type="button" onclick="closeScheduleModal()" 
                        style="background: #6c757d; color: white; border: none; padding: 10px 20px; border-radius: 6px; cursor: pointer;">
                    Cancel
                </button>
                <button type="submit" 
                        style="background: #28a745; color: white; border: none; padding: 10px 20px; border-radius: 6px; cursor: pointer;">
                    <i class="fa fa-save"></i> Schedule
                </button>
            </div>
        </form>
    </div>
</div>

<script>
let currentWeek = '<?php echo $week_start; ?>';

function previousWeek() {
    const prevWeek = new Date(currentWeek);
    prevWeek.setDate(prevWeek.getDate() - 7);
    const weekStr = prevWeek.toISOString().split('T')[0];
    window.location.href = '<?php echo base_url(); ?>admin/radiology/schedule?week=' + weekStr;
}

function nextWeek() {
    const nextWeek = new Date(currentWeek);
    nextWeek.setDate(nextWeek.getDate() + 7);
    const weekStr = nextWeek.toISOString().split('T')[0];
    window.location.href = '<?php echo base_url(); ?>admin/radiology/schedule?week=' + weekStr;
}

function goToToday() {
    const today = new Date();
    const monday = new Date(today.setDate(today.getDate() - today.getDay() + 1));
    const weekStr = monday.toISOString().split('T')[0];
    window.location.href = '<?php echo base_url(); ?>admin/radiology/schedule?week=' + weekStr;
}

function scheduleAppointment(date, time) {
    document.getElementById('appointmentDate').value = date;
    document.getElementById('appointmentTime').value = time;
    openScheduleModal();
}

function openScheduleModal() {
    document.getElementById('scheduleModal').style.display = 'block';
}

function closeScheduleModal() {
    document.getElementById('scheduleModal').style.display = 'none';
    document.getElementById('scheduleForm').reset();
    document.getElementById('patientResults').innerHTML = '';
}

function viewAppointment(orderId) {
    window.location.href = '<?php echo base_url(); ?>admin/radiology/view_order/' + orderId;
}

function editAppointment(orderId) {
    // Implement edit functionality
    alert('Edit appointment functionality - Order #' + orderId);
}

// Patient search functionality
let searchTimeout;
document.getElementById('patientSearch').addEventListener('input', function() {
    clearTimeout(searchTimeout);
    const searchTerm = this.value.trim();
    
    if (searchTerm.length >= 2) {
        searchTimeout = setTimeout(function() {
            searchPatients(searchTerm);
        }, 500);
    } else {
        document.getElementById('patientResults').innerHTML = '';
    }
});

function searchPatients(searchTerm) {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/radiology/get_patients',
        type: 'GET',
        data: { search: searchTerm },
        dataType: 'json',
        success: function(patients) {
            displayPatientResults(patients);
        },
        error: function() {
            document.getElementById('patientResults').innerHTML = 
                '<div style="color: #dc3545; padding: 10px;">Error searching patients</div>';
        }
    });
}

function displayPatientResults(patients) {
    const resultsDiv = document.getElementById('patientResults');
    
    if (patients.length === 0) {
        resultsDiv.innerHTML = '<div style="color: #6c757d; padding: 10px;">No patients found</div>';
        return;
    }
    
    let html = '<div style="max-height: 200px; overflow-y: auto; border: 1px solid #e9ecef; border-radius: 6px;">';
    patients.forEach(function(patient) {
        html += `
            <div style="padding: 10px; border-bottom: 1px solid #f1f3f4; cursor: pointer; transition: background-color 0.3s ease;"
                 onmouseover="this.style.backgroundColor='#f8f9fa'"
                 onmouseout="this.style.backgroundColor='white'"
                 onclick="selectPatient(${patient.id}, '${patient.patient_name}')">
                <div style="font-weight: 600;">${patient.patient_name}</div>
                <div style="font-size: 12px; color: #6c757d;">
                    ID: ${patient.patient_unique_id} | Mobile: ${patient.mobileno || 'N/A'}
                </div>
            </div>
        `;
    });
    html += '</div>';
    
    resultsDiv.innerHTML = html;
}

function selectPatient(patientId, patientName) {
    document.getElementById('patientSearch').value = patientName;
    document.getElementById('patientSearch').setAttribute('data-patient-id', patientId);
    document.getElementById('patientResults').innerHTML = '';
}

// Handle schedule form submission
document.getElementById('scheduleForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const patientId = document.getElementById('patientSearch').getAttribute('data-patient-id');
    if (!patientId) {
        alert('Please select a patient');
        return;
    }
    
    const formData = {
        patient_id: patientId,
        appointment_date: document.getElementById('appointmentDate').value,
        appointment_time: document.getElementById('appointmentTime').value,
        equipment_id: document.getElementById('appointmentEquipment').value
    };
    
    // Submit to create appointment
    $.ajax({
        url: '<?php echo base_url(); ?>admin/radiology/create_appointment',
        type: 'POST',
        data: formData,
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                alert('Appointment scheduled successfully');
                closeScheduleModal();
                location.reload();
            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function() {
            alert('Failed to schedule appointment');
        }
    });
});

// Close modal when clicking outside
document.getElementById('scheduleModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeScheduleModal();
    }
});

// Keyboard shortcuts
$(document).keydown(function(e) {
    if (e.ctrlKey) {
        switch(e.which) {
            case 78: // Ctrl+N for New Appointment
                e.preventDefault();
                openScheduleModal();
                break;
            case 84: // Ctrl+T for Today
                e.preventDefault();
                goToToday();
                break;
        }
    }
    
    // Escape to close modal
    if (e.which === 27) {
        closeScheduleModal();
    }
});
</script>