<!-- application/views/admin/radiology/orders.php -->
<div class="content-wrapper" style="background: #f8f9fa; min-height: 100vh; padding: 20px;">
    <!-- Page Header -->
    <div class="dashboard-header" style="background: white; border-bottom: 3px solid #17a2b8; padding: 25px 30px; margin-bottom: 30px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
        <h1 style="color: #2c3e50; margin: 0; font-size: 32px; font-weight: 700;">
            <i class="fa fa-list-alt"></i> Radiology Orders Management
        </h1>
        <p style="color: #6c757d; margin: 8px 0 0 0; font-size: 16px;">Manage and track all radiology orders</p>
    </div>

    <!-- Statistics Cards -->
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin-bottom: 30px;">
        <div style="background: white; border-radius: 12px; padding: 20px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); border-left: 4px solid #ffc107;">
            <h3 style="font-size: 28px; font-weight: 700; color: #2c3e50; margin: 0;">
                <?php echo isset($order_stats['total_orders']) ? $order_stats['total_orders'] : 0; ?>
            </h3>
            <p style="color: #6c757d; font-size: 14px; margin: 5px 0 0 0;">Total Orders</p>
        </div>
        
        <div style="background: white; border-radius: 12px; padding: 20px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); border-left: 4px solid #dc3545;">
            <h3 style="font-size: 28px; font-weight: 700; color: #2c3e50; margin: 0;">
                <?php echo isset($order_stats['pending_orders']) ? $order_stats['pending_orders'] : 0; ?>
            </h3>
            <p style="color: #6c757d; font-size: 14px; margin: 5px 0 0 0;">Pending Orders</p>
        </div>
        
        <div style="background: white; border-radius: 12px; padding: 20px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); border-left: 4px solid #28a745;">
            <h3 style="font-size: 28px; font-weight: 700; color: #2c3e50; margin: 0;">
                <?php echo isset($order_stats['completed_orders']) ? $order_stats['completed_orders'] : 0; ?>
            </h3>
            <p style="color: #6c757d; font-size: 14px; margin: 5px 0 0 0;">Completed Orders</p>
        </div>
        
        <div style="background: white; border-radius: 12px; padding: 20px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); border-left: 4px solid #17a2b8;">
            <h3 style="font-size: 24px; font-weight: 700; color: #2c3e50; margin: 0;">
                KES <?php echo isset($order_stats['total_revenue']) ? number_format($order_stats['total_revenue'], 0) : 0; ?>
            </h3>
            <p style="color: #6c757d; font-size: 14px; margin: 5px 0 0 0;">Total Revenue</p>
        </div>
    </div>

    <!-- Filters and Actions -->
    <div style="background: white; border-radius: 12px; padding: 20px; margin-bottom: 20px; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
        <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px;">
            <div style="display: flex; gap: 15px; align-items: center; flex-wrap: wrap;">
                <select id="statusFilter" style="padding: 8px 12px; border: 2px solid #e9ecef; border-radius: 6px;">
                    <option value="all" <?php echo ($status_filter === 'all' || !$status_filter) ? 'selected' : ''; ?>>All Status</option>
                    <option value="pending" <?php echo $status_filter === 'pending' ? 'selected' : ''; ?>>Pending</option>
                    <option value="in_progress" <?php echo $status_filter === 'in_progress' ? 'selected' : ''; ?>>In Progress</option>
                    <option value="completed" <?php echo $status_filter === 'completed' ? 'selected' : ''; ?>>Completed</option>
                    <option value="cancelled" <?php echo $status_filter === 'cancelled' ? 'selected' : ''; ?>>Cancelled</option>
                </select>
                
                <input type="date" id="dateFilter" value="<?php echo $date_filter; ?>" 
                       style="padding: 8px 12px; border: 2px solid #e9ecef; border-radius: 6px;">
                
                <button onclick="applyFilters()" style="background: #007bff; color: white; border: none; padding: 8px 16px; border-radius: 6px; cursor: pointer;">
                    <i class="fa fa-filter"></i> Apply Filters
                </button>
                
                <button onclick="clearFilters()" style="background: #6c757d; color: white; border: none; padding: 8px 16px; border-radius: 6px; cursor: pointer;">
                    <i class="fa fa-times"></i> Clear
                </button>
            </div>
            
            <div>
                <a href="<?php echo base_url(); ?>admin/radiology/patient_verification" 
                   style="background: #28a745; color: white; text-decoration: none; padding: 10px 20px; border-radius: 6px; display: inline-block;">
                    <i class="fa fa-plus"></i> New Order
                </a>
            </div>
        </div>
    </div>

    <!-- Orders Table -->
    <div style="background: white; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); overflow: hidden;">
        <div style="background: #f8f9fa; border-bottom: 2px solid #dee2e6; padding: 20px;">
            <h3 style="color: #495057; margin: 0; font-size: 18px; font-weight: 600;">
                <i class="fa fa-list"></i> Orders List
            </h3>
        </div>
        
        <div style="overflow-x: auto;">
            <table style="width: 100%; border-collapse: collapse;">
                <thead style="background: #f8f9fa;">
                    <tr>
                        <th style="padding: 15px; text-align: left; border-bottom: 1px solid #dee2e6; font-weight: 600;">Order #</th>
                        <th style="padding: 15px; text-align: left; border-bottom: 1px solid #dee2e6; font-weight: 600;">Patient</th>
                        <th style="padding: 15px; text-align: left; border-bottom: 1px solid #dee2e6; font-weight: 600;">Doctor</th>
                        <th style="padding: 15px; text-align: left; border-bottom: 1px solid #dee2e6; font-weight: 600;">Tests</th>
                        <th style="padding: 15px; text-align: left; border-bottom: 1px solid #dee2e6; font-weight: 600;">Amount</th>
                        <th style="padding: 15px; text-align: left; border-bottom: 1px solid #dee2e6; font-weight: 600;">Status</th>
                        <th style="padding: 15px; text-align: left; border-bottom: 1px solid #dee2e6; font-weight: 600;">Date</th>
                        <th style="padding: 15px; text-align: left; border-bottom: 1px solid #dee2e6; font-weight: 600;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($orders)): ?>
                        <tr>
                            <td colspan="8" style="padding: 40px; text-align: center; color: #6c757d;">
                                <i class="fa fa-inbox" style="font-size: 48px; opacity: 0.5; margin-bottom: 15px; display: block;"></i>
                                <h5>No Orders Found</h5>
                                <p>No radiology orders match your current filters.</p>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($orders as $order): ?>
                            <tr style="border-bottom: 1px solid #f1f3f4; transition: background-color 0.3s ease;" 
                                onmouseover="this.style.backgroundColor='#f8f9fa'" 
                                onmouseout="this.style.backgroundColor='white'">
                                
                                <td style="padding: 15px; font-weight: 600; color: #007bff;">
                                    #<?php echo $order['id']; ?>
                                </td>
                                
                                <td style="padding: 15px;">
                                    <div style="font-weight: 600; color: #2c3e50;"><?php echo $order['patient_name']; ?></div>
                                    <div style="font-size: 12px; color: #6c757d;">
                                        ID: <?php echo $order['patient_unique_id']; ?>
                                        <?php if (!empty($order['mobileno'])): ?>
                                            | <?php echo $order['mobileno']; ?>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                
                                <td style="padding: 15px; color: #495057;">
                                    <?php echo $order['doctor_name'] ?: 'Not assigned'; ?>
                                </td>
                                
                                <td style="padding: 15px;">
                                    <span style="background: #e9ecef; padding: 4px 8px; border-radius: 4px; font-size: 12px;">
                                        <?php echo isset($order['test_count']) ? $order['test_count'] : 0; ?> tests
                                    </span>
                                </td>
                                
                                <td style="padding: 15px; font-weight: 600; color: #28a745;">
                                    KES <?php echo number_format($order['total_amount'], 2); ?>
                                </td>
                                
                                <td style="padding: 15px;">
                                    <?php 
                                    $status_colors = [
                                        'pending' => '#ffc107',
                                        'in_progress' => '#17a2b8', 
                                        'completed' => '#28a745',
                                        'cancelled' => '#dc3545'
                                    ];
                                    $status_color = $status_colors[$order['status']] ?? '#6c757d';
                                    ?>
                                    <span style="background: <?php echo $status_color; ?>; color: white; padding: 4px 10px; border-radius: 15px; font-size: 11px; font-weight: 600; text-transform: uppercase;">
                                        <?php echo str_replace('_', ' ', $order['status']); ?>
                                    </span>
                                </td>
                                
                                <td style="padding: 15px; color: #6c757d; font-size: 13px;">
                                    <?php echo date('M j, Y', strtotime($order['order_date'])); ?>
                                    <br>
                                    <small><?php echo date('H:i', strtotime($order['order_date'])); ?></small>
                                </td>
                                
                                <td style="padding: 15px;">
                                    <div style="display: flex; gap: 5px;">
                                        <button onclick="viewOrder(<?php echo $order['id']; ?>)" 
                                                style="background: #007bff; color: white; border: none; padding: 5px 10px; border-radius: 4px; cursor: pointer; font-size: 12px;">
                                            <i class="fa fa-eye"></i>
                                        </button>
                                        
                                        <?php if ($order['status'] === 'pending'): ?>
                                            <button onclick="verifyOrder(<?php echo $order['id']; ?>)" 
                                                    style="background: #ffc107; color: white; border: none; padding: 5px 10px; border-radius: 4px; cursor: pointer; font-size: 12px;">
                                                <i class="fa fa-fingerprint"></i>
                                            </button>
                                            
                                            <button onclick="startExam(<?php echo $order['id']; ?>)" 
                                                    style="background: #28a745; color: white; border: none; padding: 5px 10px; border-radius: 4px; cursor: pointer; font-size: 12px;">
                                                <i class="fa fa-play"></i>
                                            </button>
                                        <?php endif; ?>
                                        
                                        <button onclick="printOrder(<?php echo $order['id']; ?>)" 
                                                style="background: #6c757d; color: white; border: none; padding: 5px 10px; border-radius: 4px; cursor: pointer; font-size: 12px;">
                                            <i class="fa fa-print"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
function applyFilters() {
    const status = document.getElementById('statusFilter').value;
    const date = document.getElementById('dateFilter').value;
    
    let url = '<?php echo base_url(); ?>admin/radiology/orders?';
    const params = [];
    
    if (status && status !== 'all') {
        params.push('status=' + status);
    }
    
    if (date) {
        params.push('date=' + date);
    }
    
    if (params.length > 0) {
        url += params.join('&');
    }
    
    window.location.href = url;
}

function clearFilters() {
    window.location.href = '<?php echo base_url(); ?>admin/radiology/orders';
}

function viewOrder(orderId) {
    window.location.href = '<?php echo base_url(); ?>admin/radiology/view_order/' + orderId;
}

function verifyOrder(orderId) {
    window.location.href = '<?php echo base_url(); ?>admin/radiology/verify_order/' + orderId;
}

function startExam(orderId) {
    if (confirm('Start examination for this order?')) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/radiology/start_exam/' + orderId,
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    alert('Examination started successfully');
                    location.reload();
                } else {
                    alert('Error: ' + response.message);
                }
            },
            error: function() {
                alert('Failed to start examination');
            }
        });
    }
}

function printOrder(orderId) {
    window.open('<?php echo base_url(); ?>admin/radiology/print_order/' + orderId, '_blank');
}

// Keyboard shortcuts
$(document).keydown(function(e) {
    if (e.ctrlKey) {
        switch(e.which) {
            case 78: // Ctrl+N for New Order
                e.preventDefault();
                window.location.href = '<?php echo base_url(); ?>admin/radiology/patient_verification';
                break;
            case 70: // Ctrl+F for Filter
                e.preventDefault();
                document.getElementById('statusFilter').focus();
                break;
        }
    }
});
</script>