<!-- Queue Management Dashboard -->
<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-users"></i> Queue Management Dashboard
            <small>Real-time queue monitoring</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Queue Management</li>
        </ol>
    </section>

    <section class="content">
        <!-- Quick Stats Row -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3 id="total-waiting">0</h3>
                        <p>Total Waiting</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-clock-o"></i>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3 id="total-served">0</h3>
                        <p>Served Today</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-check"></i>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3 id="avg-wait-time">0</h3>
                        <p>Avg Wait (min)</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-timer"></i>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3 id="active-departments">0</h3>
                        <p>Active Departments</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-building"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Department Queues Overview -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-hospital-o"></i> Department Queues Overview
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-sm btn-default" onclick="refreshDashboard()">
                                <i class="fa fa-refresh"></i> Refresh
                            </button>
                            <button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#bulkActionsModal">
                                <i class="fa fa-cogs"></i> Bulk Actions
                            </button>
                        </div>
                    </div>
                    
                    <div class="box-body">
                        <div class="row" id="departments-grid">
                            <!-- Department cards will be loaded here -->
                            <?php if (isset($queues_overview) && !empty($queues_overview)): ?>
                                <?php foreach ($queues_overview as $dept): ?>
                                    <div class="col-lg-4 col-md-6 col-sm-12">
                                        <div class="info-box department-card" data-department="<?php echo $dept['department']; ?>">
                                            <span class="info-box-icon" style="background-color: <?php echo $dept['theme_color']; ?>">
                                                <i class="fa fa-hospital-o text-white"></i>
                                            </span>

                                            <div class="info-box-content">
                                                <span class="info-box-text"><?php echo $dept['display_name']; ?></span>
                                                <span class="info-box-number waiting-count">
                                                    <?php echo $dept['statistics']['waiting_count']; ?>
                                                    <small class="text-muted">waiting</small>
                                                </span>

                                                <div class="progress">
                                                    <div class="progress-bar" style="width: <?php 
                                                        $percentage = $dept['statistics']['today_total'] > 0 
                                                            ? ($dept['statistics']['completed_today'] / $dept['statistics']['today_total']) * 100 
                                                            : 0;
                                                        echo $percentage; 
                                                    ?>%; background-color: <?php echo $dept['theme_color']; ?>"></div>
                                                </div>
                                                
                                                <span class="progress-description">
                                                    <span class="completed-count"><?php echo $dept['statistics']['completed_today']; ?></span> 
                                                    of 
                                                    <span class="total-count"><?php echo $dept['statistics']['today_total']; ?></span> 
                                                    completed today
                                                    <?php if ($dept['statistics']['avg_wait_time'] > 0): ?>
                                                        <br><small class="text-muted">Avg wait: <?php echo $dept['statistics']['avg_wait_time']; ?> min</small>
                                                    <?php endif; ?>
                                                </span>

                                                <div class="mt-2">
                                                    <a href="<?php echo base_url('admin/queue/department/' . $dept['department']); ?>" 
                                                       class="btn btn-sm btn-primary">
                                                        <i class="fa fa-eye"></i> Manage Queue
                                                    </a>
                                                    <a href="<?php echo base_url('admin/queue/display/' . $dept['department']); ?>" 
                                                       class="btn btn-sm btn-info" target="_blank">
                                                        <i class="fa fa-tv"></i> Display
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <div class="col-md-12">
                                    <div class="alert alert-info">
                                        <i class="fa fa-info-circle"></i> No queue data available. Please ensure the queue system is properly configured.
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Activity -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-history"></i> Recent Queue Activity
                        </h3>
                    </div>
                    
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="recent-activity-table">
                                <thead>
                                    <tr>
                                        <th>Time</th>
                                        <th>Queue #</th>
                                        <th>Patient</th>
                                        <th>Department</th>
                                        <th>Status</th>
                                        <th>Wait Time</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody id="recent-activity-body">
                                    <!-- Recent activities will be loaded here -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Bulk Actions Modal -->
<div class="modal fade" id="bulkActionsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-cogs"></i> Bulk Queue Actions
                </h4>
            </div>
            
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <button type="button" class="btn btn-warning btn-block" onclick="resetAllCounters()">
                            <i class="fa fa-refresh"></i> Reset All Counters
                        </button>
                    </div>
                    <div class="col-md-6">
                        <button type="button" class="btn btn-danger btn-block" onclick="clearOldQueues()">
                            <i class="fa fa-trash"></i> Clear Old Queues
                        </button>
                    </div>
                </div>
                
                <hr>
                
                <div class="row">
                    <div class="col-md-12">
                        <h5>Export Queue Data</h5>
                        <form id="exportForm">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>From Date:</label>
                                        <input type="date" class="form-control" name="date_from" 
                                               value="<?php echo date('Y-m-d', strtotime('-30 days')); ?>">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>To Date:</label>
                                        <input type="date" class="form-control" name="date_to" 
                                               value="<?php echo date('Y-m-d'); ?>">
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Department (optional):</label>
                                <select class="form-control" name="department">
                                    <option value="">All Departments</option>
                                    <?php if (isset($queues_overview)): ?>
                                        <?php foreach ($queues_overview as $dept): ?>
                                            <option value="<?php echo $dept['department']; ?>">
                                                <?php echo $dept['display_name']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-success btn-block">
                                <i class="fa fa-download"></i> Export CSV
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<?php $this->load->view('admin/queue/sound_notifications'); ?>
<script>
$(document).ready(function() {
    // Auto-refresh dashboard every 30 seconds
    setInterval(refreshDashboard, 30000);
    
    // Load recent activity
    loadRecentActivity();
    
    // Export form handler
    $('#exportForm').on('submit', function(e) {
        e.preventDefault();
        const formData = $(this).serialize();
        window.open('<?php echo base_url("admin/queue/export_queue_data"); ?>?' + formData);
        $('#bulkActionsModal').modal('hide');
    });
});

function refreshDashboard() {
    $.ajax({
        url: '<?php echo base_url("admin/queue/get_all_queues"); ?>',
        method: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                updateDashboardStats(response.data);
                updateDepartmentCards(response.data);
            }
        },
        error: function() {
            console.error('Failed to refresh dashboard');
        }
    });
}

function updateDashboardStats(data) {
    let totalWaiting = 0;
    let totalServed = 0;
    let totalWaitTime = 0;
    let activeDepartments = 0;
    let deptCount = 0;

    data.forEach(function(dept) {
        totalWaiting += dept.statistics.waiting_count;
        totalServed += dept.statistics.completed_today;
        totalWaitTime += dept.statistics.avg_wait_time;
        if (dept.statistics.waiting_count > 0) activeDepartments++;
        deptCount++;
    });

    $('#total-waiting').text(totalWaiting);
    $('#total-served').text(totalServed);
    $('#avg-wait-time').text(deptCount > 0 ? Math.round(totalWaitTime / deptCount) : 0);
    $('#active-departments').text(activeDepartments);
}

function updateDepartmentCards(data) {
    data.forEach(function(dept) {
        const card = $(`[data-department="${dept.department}"]`);
        if (card.length) {
            card.find('.waiting-count').html(dept.statistics.waiting_count + ' <small class="text-muted">waiting</small>');
            card.find('.completed-count').text(dept.statistics.completed_today);
            card.find('.total-count').text(dept.statistics.today_total);
            
            const percentage = dept.statistics.today_total > 0 
                ? (dept.statistics.completed_today / dept.statistics.today_total) * 100 
                : 0;
            card.find('.progress-bar').css('width', percentage + '%');
        }
    });
}

function loadRecentActivity() {
    // This would load recent queue activities
    // For now, showing placeholder
    const tbody = $('#recent-activity-body');
    tbody.html('<tr><td colspan="7" class="text-center text-muted">Loading recent activity...</td></tr>');
}

function resetAllCounters() {
    if (confirm('Are you sure you want to reset all queue counters? This will reset the numbering for all departments.')) {
        $.ajax({
            url: '<?php echo base_url("admin/queue/reset_counters"); ?>',
            method: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    showAlert('success', response.message);
                    refreshDashboard();
                } else {
                    showAlert('error', response.message);
                }
            },
            error: function() {
                showAlert('error', 'Failed to reset counters');
            }
        });
        $('#bulkActionsModal').modal('hide');
    }
}

function clearOldQueues() {
    const days = prompt('Clear queues older than how many days?', '7');
    if (days && !isNaN(days)) {
        $.ajax({
            url: '<?php echo base_url("admin/queue/clear_old_queues"); ?>',
            method: 'POST',
            data: { days_old: days },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    showAlert('success', response.message);
                    refreshDashboard();
                } else {
                    showAlert('error', response.message);
                }
            },
            error: function() {
                showAlert('error', 'Failed to clear old queues');
            }
        });
        $('#bulkActionsModal').modal('hide');
    }
}

function showAlert(type, message) {
    const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    const alertHtml = `<div class="alert ${alertClass} alert-dismissible">
        <button type="button" class="close" data-dismiss="alert">&times;</button>
        ${message}
    </div>`;
    
    $('.content').prepend(alertHtml);
    
    // Auto remove after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut();
    }, 5000);
}
</script>

<style>
.department-card {
    cursor: pointer;
    transition: all 0.3s ease;
}

.department-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.info-box-content .btn {
    margin: 2px;
}

.progress {
    margin: 10px 0 5px 0;
}

.small-box h3 {
    font-size: 2.2em;
    font-weight: 700;
    margin: 0 0 10px 0;
    white-space: nowrap;
    padding: 0;
}

.recent-activity-status {
    padding: 2px 8px;
    border-radius: 3px;
    font-size: 11px;
    font-weight: bold;
}

.status-waiting { background-color: #f39c12; color: white; }
.status-in-progress { background-color: #3c8dbc; color: white; }
.status-completed { background-color: #00a65a; color: white; }
.status-skipped { background-color: #dd4b39; color: white; }
</style>