<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-users"></i> Suppliers Management
            <small>Manage hospital suppliers and vendors</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/procurement"><i class="fa fa-shopping-cart"></i> Procurement</a></li>
            <li class="active">Suppliers</li>
        </ol>
    </section>

    <section class="content">
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">
                    <i class="fa fa-users"></i> Suppliers List
                </h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#newSupplierModal">
                        <i class="fa fa-plus"></i> New Supplier
                    </button>
                </div>
            </div>
            <div class="box-body">
                <div class="table-responsive">
                    <table id="suppliersTable" class="table table-striped table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>Code</th>
                                <th>Supplier Name</th>
                                <th>Contact Person</th>
                                <th>Email</th>
                                <th>Phone</th>
                                <th>City</th>
                                <th>Category</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Data loaded via AJAX -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- New Supplier Modal -->
<div class="modal fade" id="newSupplierModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <form id="supplierForm" method="post">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">
                        <i class="fa fa-plus"></i> Add New Supplier
                    </h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Supplier Name <span class="text-red">*</span></label>
                                <input type="text" name="supplier_name" class="form-control" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Supplier Code</label>
                                <input type="text" name="supplier_code" class="form-control" placeholder="Auto-generated if empty">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Contact Person</label>
                                <input type="text" name="contact_person" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Category</label>
                                <select name="supplier_category" class="form-control">
                                    <option value="general">General</option>
                                    <option value="medical">Medical</option>
                                    <option value="pharmaceutical">Pharmaceutical</option>
                                    <option value="equipment">Equipment</option>
                                    <option value="services">Services</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Email</label>
                                <input type="email" name="email" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Phone</label>
                                <input type="text" name="phone" class="form-control">
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>Address</label>
                        <textarea name="address" class="form-control" rows="3"></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>City</label>
                                <input type="text" name="city" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>State/County</label>
                                <input type="text" name="state" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Postal Code</label>
                                <input type="text" name="postal_code" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> Save Supplier
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#suppliersTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '<?php echo base_url("admin/procurement/getSuppliersList"); ?>',
            type: 'POST'
        },
        columns: [
            { data: 'supplier_code' },
            { data: 'supplier_name' },
            { data: 'contact_person' },
            { data: 'email' },
            { data: 'phone' },
            { data: 'city' },
            { data: 'supplier_category' },
            { 
                data: 'is_active',
                render: function(data, type, row) {
                    return data === 'yes' ? '<span class="label label-success">Active</span>' : 
                           '<span class="label label-danger">Inactive</span>';
                }
            },
            { 
                data: 'id',
                render: function(data, type, row) {
                    return '<div class="btn-group">' +
                           '<button class="btn btn-xs btn-info" onclick="viewSupplier(' + data + ')"><i class="fa fa-eye"></i></button>' +
                           '<button class="btn btn-xs btn-warning" onclick="editSupplier(' + data + ')"><i class="fa fa-edit"></i></button>' +
                           '</div>';
                }
            }
        ],
        order: [[1, 'asc']],
        responsive: true
    });

    // Form submission
    $('#supplierForm').on('submit', function(e) {
        e.preventDefault();
        
        $.ajax({
            url: '<?php echo base_url("admin/procurement/saveSupplier"); ?>',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#newSupplierModal').modal('hide');
                    $('#suppliersTable').DataTable().ajax.reload();
                    showMessage(response.message, 'success');
                    $('#supplierForm')[0].reset();
                } else {
                    showMessage(response.message, 'error');
                }
            }
        });
    });
});

function showMessage(message, type) {
    var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    var alertHtml = '<div class="alert ' + alertClass + ' alert-dismissible">';
    alertHtml += '<button type="button" class="close" data-dismiss="alert">&times;</button>';
    alertHtml += message + '</div>';
    $('section.content').prepend(alertHtml);
    setTimeout(function() { $('.alert').fadeOut(); }, 5000);
}
</script>