<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-file-text-o"></i> Purchase Requisitions
            <small>Manage purchase requisitions</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/procurement"><i class="fa fa-shopping-cart"></i> Procurement</a></li>
            <li class="active">Requisitions</li>
        </ol>
    </section>

    <section class="content">
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">
                    <i class="fa fa-file-text-o"></i> Purchase Requisitions
                </h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#newRequisitionModal">
                        <i class="fa fa-plus"></i> New Requisition
                    </button>
                </div>
            </div>
            <div class="box-body">
                <div class="table-responsive">
                    <table id="requisitionsTable" class="table table-striped table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>Req. No.</th>
                                <th>Department</th>
                                <th>Requested By</th>
                                <th>Date</th>
                                <th>Required Date</th>
                                <th>Priority</th>
                                <th>Est. Cost</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Data loaded via AJAX -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- New Requisition Modal -->
<div class="modal fade" id="newRequisitionModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <form id="requisitionForm" method="post">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">
                        <i class="fa fa-plus"></i> Create New Purchase Requisition
                    </h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Department <span class="text-red">*</span></label>
                                <select name="department_id" class="form-control" required>
                                    <option value="">Select Department</option>
                                    <?php if (!empty($departments)): ?>
                                        <?php foreach ($departments as $dept): ?>
                                            <option value="<?php echo $dept['id']; ?>">
                                                <?php echo $dept['department_name']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Required Date <span class="text-red">*</span></label>
                                <input type="date" name="required_date" class="form-control" required min="<?php echo date('Y-m-d'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Priority</label>
                                <select name="priority" class="form-control">
                                    <option value="low">Low</option>
                                    <option value="medium" selected>Medium</option>
                                    <option value="high">High</option>
                                    <option value="urgent">Urgent</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Purpose <span class="text-red">*</span></label>
                                <input type="text" name="purpose" class="form-control" placeholder="Purpose of requisition" required>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Justification</label>
                        <textarea name="justification" class="form-control" rows="3" placeholder="Provide justification for this requisition"></textarea>
                    </div>

                    <!-- Items Section -->
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h5 class="panel-title">
                                <i class="fa fa-list"></i> Requisition Items
                                <button type="button" class="btn btn-xs btn-success pull-right" onclick="addRequisitionItem()">
                                    <i class="fa fa-plus"></i> Add Item
                                </button>
                            </h5>
                        </div>
                        <div class="panel-body">
                            <div id="requisitionItems">
                                <!-- Items will be added dynamically -->
                            </div>
                            <div class="text-right">
                                <strong>Total Estimated Cost: KES <span id="totalCost">0.00</span></strong>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> Save Requisition
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Requisition Item Template -->
<script type="text/template" id="requisitionItemTemplate">
    <div class="requisition-item panel panel-info">
        <div class="panel-body">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Item</label>
                        <select name="items[{index}][item_id]" class="form-control item-select" required onchange="updateItemDetails(this, {index})">
                            <option value="">Select Item</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>Quantity</label>
                        <input type="number" name="items[{index}][quantity]" class="form-control quantity-input" min="1" required onchange="calculateItemTotal({index})">
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>Est. Unit Cost</label>
                        <input type="number" name="items[{index}][estimated_cost]" class="form-control cost-input" step="0.01" min="0" required onchange="calculateItemTotal({index})">
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>Total</label>
                        <input type="text" class="form-control item-total" readonly>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <button type="button" class="btn btn-danger btn-block" onclick="removeRequisitionItem(this)">
                            <i class="fa fa-trash"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Specifications</label>
                        <input type="text" name="items[{index}][specifications]" class="form-control" placeholder="Item specifications">
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Notes</label>
                        <input type="text" name="items[{index}][notes]" class="form-control" placeholder="Additional notes">
                    </div>
                </div>
            </div>
        </div>
    </div>
</script>

<!-- JavaScript for Requisitions -->
<script>
$(document).ready(function() {
    // Initialize DataTable
    var requisitionsTable = $('#requisitionsTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '<?php echo base_url("admin/procurement/getRequisitionsList"); ?>',
            type: 'POST',
            error: function(xhr, error, thrown) {
                console.error('DataTable Error:', error, thrown);
                showMessage('Error loading requisitions data', 'error');
            }
        },
        columns: [
            { 
                data: 'requisition_no',
                defaultContent: 'N/A'
            },
            { 
                data: 'department_name',
                defaultContent: 'N/A'
            },
            { 
                data: 'requested_by_name',
                defaultContent: 'N/A'
            },
            { 
                data: 'request_date',
                defaultContent: 'N/A',
                render: function(data, type, row) {
                    if (data && data != 'N/A') {
                        return new Date(data).toLocaleDateString();
                    }
                    return 'N/A';
                }
            },
            { 
                data: 'required_date',
                defaultContent: 'N/A',
                render: function(data, type, row) {
                    if (data && data != 'N/A') {
                        return new Date(data).toLocaleDateString();
                    }
                    return 'N/A';
                }
            },
            { 
                data: 'priority',
                defaultContent: 'medium',
                render: function(data, type, row) {
                    var badgeClass = {
                        'low': 'label-default',
                        'medium': 'label-info',
                        'high': 'label-warning',
                        'urgent': 'label-danger'
                    };
                    var priority = data || 'medium';
                    return '<span class="label ' + (badgeClass[priority] || 'label-default') + '">' + 
                           priority.charAt(0).toUpperCase() + priority.slice(1) + '</span>';
                }
            },
            { 
                data: 'total_estimated_cost',
                defaultContent: '0',
                render: function(data, type, row) {
                    var amount = parseFloat(data || 0);
                    return 'KES ' + amount.toLocaleString('en-US', {minimumFractionDigits: 2});
                }
            },
            { 
                data: 'status',
                defaultContent: 'draft',
                render: function(data, type, row) {
                    var badgeClass = {
                        'draft': 'label-default',
                        'pending_approval': 'label-warning',
                        'approved': 'label-success',
                        'rejected': 'label-danger',
                        'partially_fulfilled': 'label-info',
                        'fulfilled': 'label-success'
                    };
                    var status = data || 'draft';
                    return '<span class="label ' + (badgeClass[status] || 'label-default') + '">' + 
                           status.replace(/_/g, ' ').toUpperCase() + '</span>';
                }
            },
            { 
                data: 'id',
                defaultContent: '0',
                render: function(data, type, row) {
                    var actions = '<div class="btn-group">';
                    actions += '<button type="button" class="btn btn-xs btn-info" onclick="viewRequisition(' + (data || 0) + ')" title="View">';
                    actions += '<i class="fa fa-eye"></i></button>';
                    
                    if ((row.status || 'draft') === 'pending_approval') {
                        actions += '<button type="button" class="btn btn-xs btn-success" onclick="approveRequisition(' + (data || 0) + ')" title="Approve">';
                        actions += '<i class="fa fa-check"></i></button>';
                        actions += '<button type="button" class="btn btn-xs btn-danger" onclick="rejectRequisition(' + (data || 0) + ')" title="Reject">';
                        actions += '<i class="fa fa-times"></i></button>';
                    }
                    
                    if ((row.status || 'draft') === 'approved') {
                        actions += '<button type="button" class="btn btn-xs btn-primary" onclick="createPOFromRequisition(' + (data || 0) + ')" title="Create PO">';
                        actions += '<i class="fa fa-shopping-cart"></i></button>';
                    }
                    
                    actions += '</div>';
                    return actions;
                }
            }
        ],
        order: [[0, 'desc']],
        responsive: true,
        language: {
            emptyTable: "No requisitions found. Click 'New Requisition' to create one.",
            zeroRecords: "No matching requisitions found.",
            loadingRecords: "Loading requisitions..."
        }
    });

    // Form submission
    $('#requisitionForm').on('submit', function(e) {
        e.preventDefault();
        
        // Validate that at least one item is added
        if ($('#requisitionItems .requisition-item').length === 0) {
            showMessage('Please add at least one item to the requisition', 'error');
            return;
        }
        
        var formData = $(this).serialize();
        
        // Show loading
        var submitBtn = $(this).find('button[type="submit"]');
        var originalText = submitBtn.html();
        submitBtn.html('<i class="fa fa-spinner fa-spin"></i> Saving...').prop('disabled', true);
        
        $.ajax({
            url: '<?php echo base_url("admin/procurement/saveRequisition"); ?>',
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#newRequisitionModal').modal('hide');
                    requisitionsTable.ajax.reload();
                    showMessage(response.message, 'success');
                    $('#requisitionForm')[0].reset();
                    $('#requisitionItems').empty();
                    $('#totalCost').text('0.00');
                    itemIndex = 0;
                } else {
                    showMessage(response.message || 'Failed to save requisition', 'error');
                }
            },
            error: function(xhr, status, error) {
                console.error('Save Error:', error);
                showMessage('An error occurred while saving the requisition', 'error');
            },
            complete: function() {
                // Restore button
                submitBtn.html(originalText).prop('disabled', false);
            }
        });
    });

    // Load items on modal show
    $('#newRequisitionModal').on('shown.bs.modal', function() {
        if ($('#requisitionItems').children().length === 0) {
            addRequisitionItem();
        }
    });
    
    // Reset form when modal is hidden
    $('#newRequisitionModal').on('hidden.bs.modal', function() {
        $('#requisitionForm')[0].reset();
        $('#requisitionItems').empty();
        $('#totalCost').text('0.00');
        itemIndex = 0;
    });
});

var itemIndex = 0;

function addRequisitionItem() {
    var template = $('#requisitionItemTemplate').html();
    var html = template.replace(/{index}/g, itemIndex);
    $('#requisitionItems').append(html);
    
    // Load items for the new select
    loadItemsForSelect($('#requisitionItems .item-select').last());
    
    itemIndex++;
}

function removeRequisitionItem(button) {
    if ($('#requisitionItems .requisition-item').length <= 1) {
        showMessage('At least one item is required', 'warning');
        return;
    }
    
    $(button).closest('.requisition-item').remove();
    calculateTotalCost();
}

function loadItemsForSelect(selectElement) {
    $.ajax({
        url: '<?php echo base_url("admin/procurement/getItemsForSelect"); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success' && response.items) {
                selectElement.empty().append('<option value="">Select Item</option>');
                $.each(response.items, function(index, item) {
                    selectElement.append('<option value="' + item.id + '" data-cost="' + (item.unit_cost || 0) + '" data-unit="' + (item.unit_of_measure || 'pieces') + '">' + 
                                       (item.item_code || 'N/A') + ' - ' + (item.item_name || 'Unknown Item') + '</option>');
                });
            } else {
                selectElement.empty().append('<option value="">No items available</option>');
                console.error('Failed to load items:', response.message || 'Unknown error');
            }
        },
        error: function(xhr, status, error) {
            console.error('Error loading items:', error);
            selectElement.empty().append('<option value="">Error loading items</option>');
        }
    });
}

function updateItemDetails(selectElement, index) {
    var selectedOption = $(selectElement).find('option:selected');
    var estimatedCost = selectedOption.data('cost') || 0;
    var unit = selectedOption.data('unit') || 'pieces';
    
    $('input[name="items[' + index + '][estimated_cost]"]').val(estimatedCost);
    
    // Update quantity placeholder to show unit
    var quantityInput = $('input[name="items[' + index + '][quantity]"]');
    quantityInput.attr('placeholder', 'Qty in ' + unit);
    
    calculateItemTotal(index);
}

function calculateItemTotal(index) {
    var quantity = parseInt($('input[name="items[' + index + '][quantity]"]').val()) || 0;
    var cost = parseFloat($('input[name="items[' + index + '][estimated_cost]"]').val()) || 0;
    var total = quantity * cost;
    
    $('.requisition-item').eq(index).find('.item-total').val(total.toFixed(2));
    
    calculateTotalCost();
}

function calculateTotalCost() {
    var total = 0;
    $('.item-total').each(function() {
        total += parseFloat($(this).val()) || 0;
    });
    $('#totalCost').text(total.toFixed(2));
}

function viewRequisition(requisitionId) {
    if (!requisitionId || requisitionId == 0) {
        showMessage('Invalid requisition ID', 'error');
        return;
    }
    window.open('<?php echo base_url("admin/procurement/viewRequisition/"); ?>' + requisitionId, '_blank');
}

function approveRequisition(requisitionId) {
    if (!requisitionId || requisitionId == 0) {
        showMessage('Invalid requisition ID', 'error');
        return;
    }
    
    if (confirm('Are you sure you want to approve this requisition?')) {
        $.ajax({
            url: '<?php echo base_url("admin/procurement/approveRequisition"); ?>',
            type: 'POST',
            data: {
                requisition_id: requisitionId,
                action: 'approve',
                comments: 'Approved'
            },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#requisitionsTable').DataTable().ajax.reload();
                    showMessage(response.message, 'success');
                } else {
                    showMessage(response.message || 'Failed to approve requisition', 'error');
                }
            },
            error: function() {
                showMessage('Error approving requisition', 'error');
            }
        });
    }
}

function rejectRequisition(requisitionId) {
    if (!requisitionId || requisitionId == 0) {
        showMessage('Invalid requisition ID', 'error');
        return;
    }
    
    var reason = prompt('Please provide reason for rejection:');
    if (reason && reason.trim() !== '') {
        $.ajax({
            url: '<?php echo base_url("admin/procurement/approveRequisition"); ?>',
            type: 'POST',
            data: {
                requisition_id: requisitionId,
                action: 'reject',
                comments: reason
            },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#requisitionsTable').DataTable().ajax.reload();
                    showMessage(response.message, 'success');
                } else {
                    showMessage(response.message || 'Failed to reject requisition', 'error');
                }
            },
            error: function() {
                showMessage('Error rejecting requisition', 'error');
            }
        });
    }
}

function createPOFromRequisition(requisitionId) {
    if (!requisitionId || requisitionId == 0) {
        showMessage('Invalid requisition ID', 'error');
        return;
    }
    window.location.href = '<?php echo base_url("admin/procurement/purchaseOrders?requisition_id="); ?>' + requisitionId;
}

function showMessage(message, type) {
    var alertClass = type === 'success' ? 'alert-success' : 
                    type === 'warning' ? 'alert-warning' : 'alert-danger';
    var alertHtml = '<div class="alert ' + alertClass + ' alert-dismissible">';
    alertHtml += '<button type="button" class="close" data-dismiss="alert">&times;</button>';
    alertHtml += message + '</div>';
    
    $('section.content').prepend(alertHtml);
    
    setTimeout(function() {
        $('.alert').fadeOut();
    }, 5000);
}
</script>