<!DOCTYPE html>
<html>
<head>
    <title>Requisition - <?php echo $requisition['requisition_no'] ?? 'N/A'; ?></title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        .header { text-align: center; margin-bottom: 20px; }
        .info-table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        .info-table td, .info-table th { padding: 5px; border: 1px solid #ddd; }
        .items-table { width: 100%; border-collapse: collapse; }
        .items-table td, .items-table th { padding: 8px; border: 1px solid #ddd; text-align: left; }
        .items-table th { background-color: #f5f5f5; }
        .total-row { font-weight: bold; background-color: #f0f0f0; }
        .signatures { margin-top: 40px; }
        .signature-box { width: 30%; float: left; margin-right: 5%; border-top: 1px solid #000; padding-top: 5px; text-align: center; }
        @media print { .no-print { display: none; } }
    </style>
</head>
<body>
    <div class="no-print" style="text-align: right; margin-bottom: 10px;">
        <button onclick="window.print()">Print</button>
        <button onclick="window.close()">Close</button>
    </div>

    <div class="header">
        <h2><?php echo $hospital['name'] ?? 'Hospital Name'; ?></h2>
        <h3>PURCHASE REQUISITION</h3>
        <p><strong>Requisition No: <?php echo $requisition['requisition_no'] ?? 'N/A'; ?></strong></p>
    </div>

    <table class="info-table">
        <tr>
            <td><strong>Department:</strong></td>
            <td><?php echo $requisition['department_name'] ?? 'N/A'; ?></td>
            <td><strong>Request Date:</strong></td>
            <td><?php echo isset($requisition['request_date']) ? date('M d, Y', strtotime($requisition['request_date'])) : 'N/A'; ?></td>
        </tr>
        <tr>
            <td><strong>Requested By:</strong></td>
            <td><?php echo $requisition['requested_by_name'] ?? 'N/A'; ?></td>
            <td><strong>Required Date:</strong></td>
            <td><?php echo isset($requisition['required_date']) ? date('M d, Y', strtotime($requisition['required_date'])) : 'N/A'; ?></td>
        </tr>
        <tr>
            <td><strong>Priority:</strong></td>
            <td><?php echo ucfirst($requisition['priority'] ?? 'medium'); ?></td>
            <td><strong>Status:</strong></td>
            <td><?php echo ucfirst(str_replace('_', ' ', $requisition['status'] ?? 'draft')); ?></td>
        </tr>
        <tr>
            <td><strong>Purpose:</strong></td>
            <td colspan="3"><?php echo $requisition['purpose'] ?? 'N/A'; ?></td>
        </tr>
    </table>

    <h4>Items Requested:</h4>
    <table class="items-table">
        <thead>
            <tr>
                <th>#</th>
                <th>Item Code</th>
                <th>Item Name</th>
                <th>Quantity</th>
                <th>Unit</th>
                <th>Unit Cost</th>
                <th>Total Cost</th>
                <th>Specifications</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($requisition_items)): ?>
                <?php $grand_total = 0; ?>
                <?php foreach ($requisition_items as $index => $item): ?>
                    <?php 
                    $total_cost = ($item['quantity_requested'] ?? 0) * ($item['unit_cost_estimated'] ?? 0);
                    $grand_total += $total_cost;
                    ?>
                    <tr>
                        <td><?php echo $index + 1; ?></td>
                        <td><?php echo $item['item_code'] ?? 'N/A'; ?></td>
                        <td><?php echo $item['item_name'] ?? 'N/A'; ?></td>
                        <td><?php echo $item['quantity_requested'] ?? 0; ?></td>
                        <td><?php echo $item['unit_of_measure'] ?? 'pieces'; ?></td>
                        <td><?php echo number_format($item['unit_cost_estimated'] ?? 0, 2); ?></td>
                        <td><?php echo number_format($total_cost, 2); ?></td>
                        <td><?php echo $item['specifications'] ?? '-'; ?></td>
                    </tr>
                <?php endforeach; ?>
                <tr class="total-row">
                    <td colspan="6" style="text-align: right;"><strong>TOTAL:</strong></td>
                    <td><strong>KES <?php echo number_format($grand_total, 2); ?></strong></td>
                    <td></td>
                </tr>
            <?php else: ?>
                <tr>
                    <td colspan="8" style="text-align: center;">No items found</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <?php if (!empty($requisition['justification'])): ?>
        <h4>Justification:</h4>
        <p><?php echo nl2br(htmlspecialchars($requisition['justification'])); ?></p>
    <?php endif; ?>

    <div class="signatures">
        <div class="signature-box">
            <strong>Requested By</strong><br>
            Date: _______________
        </div>
        <div class="signature-box">
            <strong>Department Head</strong><br>
            Date: _______________
        </div>
        <div class="signature-box">
            <strong>Procurement Officer</strong><br>
            Date: _______________
        </div>
        <div style="clear: both;"></div>
    </div>

    <script>
        // Auto print when opened
        window.onload = function() {
            setTimeout(function() {
                window.print();
            }, 500);
        };
    </script>
</body>
</html>