<?php $currency_symbol = $this->customlib->getHospitalCurrencyFormat(); ?>
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title titlefix"><?php echo $this->lang->line('medicines_stock'); ?></h3>
                        <div class="box-tools pull-right">
                            <!-- Patient Search Section -->
                            <div class="btn-group" style="margin-right: 10px;">
                                <button type="button" class="btn btn-success btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fa fa-user"></i> <?php echo $this->lang->line('patient_actions'); ?> <span class="caret"></span>
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a href="#" onclick="searchPatient()"><i class="fa fa-search"></i> <?php echo $this->lang->line('search_patient'); ?></a></li>
                                    <li><a href="#" onclick="createPharmacyBill()"><i class="fa fa-plus"></i> <?php echo $this->lang->line('create_bill'); ?></a></li>
                                    <li><a href="<?php echo base_url(); ?>admin/pharmacy/billreport"><i class="fa fa-file-text"></i> <?php echo $this->lang->line('pharmacy_bills'); ?></a></li>
                                </ul>
                            </div>
                            
                            <?php if ($this->rbac->hasPrivilege('import_medicine', 'can_view')) { ?>                
                                <a data-toggle="modal" href="<?php echo base_url(); ?>admin/pharmacy/import" class="btn btn-primary btn-sm"><i class="fa fa-upload"></i> <?php echo $this->lang->line('import_medicine'); ?>
                                </a>
                            <?php } ?>
                            <?php if ($this->rbac->hasPrivilege('medicine', 'can_add')) { ?>
                                <a data-toggle="modal" onclick="holdModal('myModal')" class="btn btn-primary btn-sm addmedicine"><i class="fa fa-plus"></i> <?php echo $this->lang->line('add_medicine'); ?></a> 
                            <?php } ?>
                            <?php if ($this->rbac->hasPrivilege('medicine_purchase', 'can_view')) { ?>
                                <a href="<?php echo base_url(); ?>admin/pharmacy/purchase" class="btn btn-primary btn-sm"><i class="fa fa-reorder"></i> <?php echo $this->lang->line('purchase'); ?></a>
                            <?php } ?>
                        </div>
                    </div><!-- /.box-header -->
                    <div class="box-body">
                        <!-- Patient Search Bar -->
                        <div class="row" id="patient-search-section" style="display: none; margin-bottom: 15px;">
                            <div class="col-md-12">
                                <div class="alert alert-info">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('search_patient'); ?></label>
                                                <input type="text" id="patient_search" class="form-control" placeholder="<?php echo $this->lang->line('patient_name_id_phone'); ?>" autocomplete="off">
                                                <div id="patient_search_results" class="search-results"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('selected_patient'); ?></label>
                                                <div id="selected_patient_info" class="selected-patient-info">
                                                    <span class="text-muted"><?php echo $this->lang->line('no_patient_selected'); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>&nbsp;</label><br>
                                                <button type="button" class="btn btn-success btn-sm" id="create_bill_btn" disabled onclick="createBillForPatient()">
                                                    <i class="fa fa-plus"></i> <?php echo $this->lang->line('create_bill'); ?>
                                                </button>
                                                <button type="button" class="btn btn-info btn-sm" id="view_bills_btn" disabled onclick="viewPatientBills()">
                                                    <i class="fa fa-eye"></i> <?php echo $this->lang->line('view_bills'); ?>
                                                </button>
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label>&nbsp;</label><br>
                                                <button type="button" class="btn btn-default btn-sm" onclick="hidePatientSearch()">
                                                    <i class="fa fa-times"></i> <?php echo $this->lang->line('close'); ?>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="download_label"><?php echo $this->lang->line('medicines_stock'); ?></div>                       
                        <?php if ($this->rbac->hasPrivilege('medicine', 'can_delete')) { ?>
                            <button type="button" class="btn btn-primary pull-right btn-sm mt10 delete_selected" id="load" data-loading-text="<i class='fa fa-spinner fa-spin '></i> <?php echo $this->lang->line('please_wait'); ?>"><i class="fa fa-trash"></i> <?php echo $this->lang->line('delete_selected'); ?>
                            </button>
                        <?php } ?>                       
                        <div class="table-responsive-mobile">   
                        <table class="table table-striped table-bordered table-hover ajaxlist " cellspacing="0" width="100%" data-export-title="<?php echo $this->lang->line('medicines_stock'); ?>">
                            <thead>
                                <tr>
                                    <th class="noExport"><input type="checkbox" name="checkAll"> #</th>
                                    <th><?php echo $this->lang->line('medicine_name'); ?></th>
                                    <th><?php echo $this->lang->line('medicine_company'); ?></th>
                                    <th><?php echo $this->lang->line('medicine_composition'); ?></th>
                                    <th><?php echo $this->lang->line('medicine_category'); ?></th> 
                                    <th><?php echo $this->lang->line('medicine_group'); ?></th>
                                    <th><?php echo $this->lang->line('unit'); ?></th>
                                    <th><?php echo $this->lang->line('available_qty'); ?></th>
                                    <th class="noExport"><?php echo $this->lang->line('action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>                            
                      </div>
                    </div>
                </div>                                                    
            </div>                                                                                                                                          
        </div>  
    </section>
</div>

<!-- Patient Selection Modal -->
<div class="modal fade" id="patientModal" role="dialog" aria-labelledby="patientModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content mx-2">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('select_patient'); ?></h4> 
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('search_patient'); ?></label>
                            <input type="text" id="modal_patient_search" class="form-control" placeholder="<?php echo $this->lang->line('enter_patient_name_id_phone'); ?>">
                        </div>
                        <div id="patient_list" class="patient-list">
                            <!-- Patient search results will be loaded here -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>    
</div>

<!-- Quick Bill Creation Modal -->
<div class="modal fade" id="quickBillModal" role="dialog" aria-labelledby="quickBillModalLabel">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content modal-media-content mx-2">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('pharmacy_bill'); ?></h4> 
            </div>
            <div class="modal-body" id="quick_bill_content">
                <!-- Bill creation content will be loaded here -->
            </div>
        </div>
    </div>    
</div>

<!-- Patient Bills Modal -->
<div class="modal fade" id="patientBillsModal" role="dialog" aria-labelledby="patientBillsModalLabel">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content modal-media-content mx-2">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line('patient_pharmacy_bills'); ?></h4> 
            </div>
            <div class="modal-body" id="patient_bills_content">
                <!-- Patient bills will be loaded here -->
            </div>
        </div>
    </div>    
</div>

<!-- Existing Modals (Keep all existing modals from original code) -->
<div class="modal fade" id="myModal" role="dialog" aria-labelledby="myModalLabel">
    <!-- Original medicine add modal content -->
</div>

<div class="modal fade" id="myModaledit" role="dialog" aria-labelledby="myModalLabel">
    <!-- Original medicine edit modal content -->
</div>

<div class="modal fade" id="viewModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <!-- Original view modal content -->
</div>

<div class="modal fade" id="addBulkModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <!-- Original bulk add modal content -->
</div>

<div class="modal fade" id="addBadStockModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <!-- Original bad stock modal content -->
</div>

<style>
.search-results {
    position: absolute;
    z-index: 1000;
    background: white;
    border: 1px solid #ddd;
    border-top: none;
    max-height: 200px;
    overflow-y: auto;
    width: 100%;
    display: none;
}

.search-results .search-item {
    padding: 10px;
    border-bottom: 1px solid #eee;
    cursor: pointer;
}

.search-results .search-item:hover {
    background-color: #f5f5f5;
}

.selected-patient-info {
    padding: 8px;
    background: #f9f9f9;
    border: 1px solid #ddd;
    border-radius: 4px;
}

.patient-list {
    max-height: 400px;
    overflow-y: auto;
}

.patient-item {
    padding: 15px;
    border: 1px solid #eee;
    margin-bottom: 10px;
    cursor: pointer;
    border-radius: 4px;
}

.patient-item:hover {
    background-color: #f5f5f5;
}

.patient-item.selected {
    background-color: #d4edda;
    border-color: #c3e6cb;
}

.dropdown-menu > li > a:hover {
    background-color: #f5f5f5;
}
</style>

<script type="text/javascript">
    var selectedPatientId = null;
    var selectedPatientData = null;

    // Show patient search section
    function searchPatient() {
        $('#patient-search-section').slideDown();
        $('#patient_search').focus();
    }

    // Hide patient search section
    function hidePatientSearch() {
        $('#patient-search-section').slideUp();
        clearPatientSelection();
    }

    // Clear patient selection
    function clearPatientSelection() {
        selectedPatientId = null;
        selectedPatientData = null;
        $('#patient_search').val('');
        $('#selected_patient_info').html('<span class="text-muted"><?php echo $this->lang->line('no_patient_selected'); ?></span>');
        $('#create_bill_btn, #view_bills_btn').prop('disabled', true);
        $('#patient_search_results').hide();
    }

    // Patient search functionality
    $('#patient_search').on('input', function() {
        var searchTerm = $(this).val();
        if (searchTerm.length >= 2) {
            searchPatients(searchTerm);
        } else {
            $('#patient_search_results').hide();
        }
    });

    // Search patients via AJAX
    function searchPatients(searchTerm) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/searchPatients',
            type: 'POST',
            data: { search_term: searchTerm },
            dataType: 'json',
            success: function(response) {
                if (response.status && response.patients.length > 0) {
                    displaySearchResults(response.patients);
                } else {
                    $('#patient_search_results').hide();
                }
            },
            error: function() {
                $('#patient_search_results').hide();
            }
        });
    }

    // Display search results
    function displaySearchResults(patients) {
        var html = '';
        $.each(patients, function(index, patient) {
            html += '<div class="search-item" onclick="selectPatient(' + patient.id + ', \'' + 
                    patient.patient_name + '\', \'' + patient.patient_unique_id + '\')">';
            html += '<strong>' + patient.patient_name + '</strong><br>';
            html += '<small>ID: ' + patient.patient_unique_id + ' | Phone: ' + (patient.mobileno || 'N/A') + '</small>';
            html += '</div>';
        });
        $('#patient_search_results').html(html).show();
    }

    // Select a patient
    function selectPatient(patientId, patientName, patientUniqueId) {
        selectedPatientId = patientId;
        selectedPatientData = {
            id: patientId,
            name: patientName,
            unique_id: patientUniqueId
        };
        
        $('#patient_search').val(patientName);
        $('#selected_patient_info').html(
            '<strong>' + patientName + '</strong><br>' +
            '<small>ID: ' + patientUniqueId + '</small>'
        );
        $('#patient_search_results').hide();
        $('#create_bill_btn, #view_bills_btn').prop('disabled', false);
    }

    // Create pharmacy bill
    function createPharmacyBill() {
        $('#patientModal').modal('show');
    }

    // Create bill for selected patient
    function createBillForPatient() {
        if (!selectedPatientId) {
            alert('<?php echo $this->lang->line('please_select_patient'); ?>');
            return;
        }

        $.ajax({
            url: '<?php echo base_url(); ?>admin/pharmacy/createBill',
            type: 'POST',
            data: { patient_id: selectedPatientId },
            dataType: 'json',
            success: function(response) {
                if (response.status) {
                    $('#quick_bill_content').html(response.page);
                    $('#quickBillModal').modal('show');
                    
                    // Pre-select the patient in the bill form
                    if (response.bill_no) {
                        // Set bill number and patient data
                        $('#bill_no').val(response.bill_no);
                        $('#patient_id').val(selectedPatientId).trigger('change');
                    }
                } else {
                    alert('<?php echo $this->lang->line('error_creating_bill'); ?>');
                }
            },
            error: function() {
                alert('<?php echo $this->lang->line('something_went_wrong'); ?>');
            }
        });
    }

    // View patient bills
    function viewPatientBills() {
        if (!selectedPatientId) {
            alert('<?php echo $this->lang->line('please_select_patient'); ?>');
            return;
        }

        $.ajax({
            url: '<?php echo base_url(); ?>admin/pharmacy/getPatientBills',
            type: 'POST',
            data: { patient_id: selectedPatientId },
            dataType: 'json',
            success: function(response) {
                if (response.status) {
                    $('#patient_bills_content').html(response.page);
                    $('#patientBillsModal').modal('show');
                } else {
                    alert('<?php echo $this->lang->line('no_bills_found'); ?>');
                }
            },
            error: function() {
                alert('<?php echo $this->lang->line('something_went_wrong'); ?>');
            }
        });
    }

    // Hide search results when clicking outside
    $(document).click(function(e) {
        if (!$(e.target).closest('#patient_search, #patient_search_results').length) {
            $('#patient_search_results').hide();
        }
    });

    // Original medicine functionality (keep all existing JavaScript)
    $(function () {
        $('.select2').select2()
    });
    
    $(function () {
        $('#easySelectable').easySelectable();
    });

    // Add quick dispense functionality to medicine actions
    function quickDispense(medicineId, medicineName) {
        if (!selectedPatientId) {
            alert('<?php echo $this->lang->line('please_select_patient_first'); ?>');
            searchPatient();
            return;
        }

        // Create a quick bill with this medicine
        $.ajax({
            url: '<?php echo base_url(); ?>admin/pharmacy/quickDispense',
            type: 'POST',
            data: { 
                patient_id: selectedPatientId,
                medicine_id: medicineId
            },
            dataType: 'json',
            success: function(response) {
                if (response.status) {
                    $('#quick_bill_content').html(response.page);
                    $('#quickBillModal').modal('show');
                } else {
                    alert(response.message || '<?php echo $this->lang->line('error_creating_bill'); ?>');
                }
            },
            error: function() {
                alert('<?php echo $this->lang->line('something_went_wrong'); ?>');
            }
        });
    }
</script>

<script type="text/javascript">
            $(document).ready(function (e) {
                $("#formadd").on('submit', (function (e) {
                    e.preventDefault();
                    $("#formaddbtn").button('loading');
                    $.ajax({
                        url: '<?php echo base_url(); ?>admin/pharmacy/add',
                        type: "POST",
                        data: new FormData(this),
                        dataType: 'json',
                        contentType: false,
                        cache: false,
                        processData: false,
                        success: function (data) {
                            if (data.status == "fail") {
                                var message = "";
                                $.each(data.error, function (index, value) {
                                    message += value;
                                });
                                errorMsg(message);
                            } else {
                                successMsg(data.message);
                                window.location.reload(true);
                            }
                            $("#formaddbtn").button('reset');
                        },
                        error: function () {
                           
                        }
                    });
                }));
            });

            $(document).ready(function (e) {
                $("#formstock").on('submit', (function (e) {
                    e.preventDefault();
                    $("#formstockbtn").button('loading');
                    $.ajax({
                        url: '<?php echo base_url(); ?>admin/pharmacy/addBadStock',
                        type: "POST",
                        data: new FormData(this),
                        dataType: 'json',
                        contentType: false,
                        cache: false,
                        processData: false,
                        success: function (data) {
                            if (data.status == "fail") {
                                var message = "";
                                $.each(data.error, function (index, value) {
                                    message += value;
                                });
                                errorMsg(message);
                            } else {
                                successMsg(data.message);
                                window.location.reload(true);
                            }
                            $("#formstockbtn").button('reset');
                        },
                        error: function () {

                        }
                    });
                }));
            });
			
            $(document).ready(function (e) {
                $("#formedit").on('submit', (function (e) {
                    e.preventDefault();
                    $("#formeditbtn").button('loading');
                    $.ajax({
                        url: '<?php echo base_url(); ?>admin/pharmacy/update',
                        type: "POST",
                        data: new FormData(this),
                        dataType: 'json',
                        contentType: false,
                        cache: false,
                        processData: false,
                        success: function (data) {
                            if (data.status == "fail") {
                                var message = "";
                                $.each(data.error, function (index, value) {
                                    message += value;
                                });
                                errorMsg(message);
                            } else {
                                successMsg(data.message);
                                window.location.reload(true);
                            }
                            $("#formeditbtn").button('reset');
                        },
                        error: function () {

                        }
                    });
                }));
            });
			
            $(document).ready(function (e) {
                $('#batch_expire,#stockexpiry_date').datepicker({
                    format: "M/yyyy",
                    viewMode: "months",
                    minViewMode: "months",
                    autoclose: true
                });
            });
			
            function getRecord(id) {
                $.ajax({
                    url: '<?php echo base_url(); ?>admin/pharmacy/getDetails',
                    type: "POST",
                    data: {pharmacy_id: id},
                    dataType: 'json',
                    success: function (data) {
                        $("#id").val(data.id);
                        $("#medicines_name").val(data.medicine_name);
                        $("#medicines_category_id").val(data.medicine_category_id);
                        $("#medicine_company").val(data.medicine_company);
                        $("#medicine_composition").val(data.medicine_composition);
                        $("#medicine_group").val(data.medicine_group);
                        $("#unit").val(data.unit);
                        $("#min_level").val(data.min_level);
                        $("#reorder_level").val(data.reorder_level);
                        $("#vat").val(data.vat); 
                        $("#unit_packing").val(data.unit_packing); 
                        $("#pre_medicine_image").val(data.pre_medicine_image);
                        $("#vat_ac").val(data.vat_ac);
                        $("#rack_number").val(data.rack_number);
                        $("#edit_note").val(data.note);
                        $("#updateid").val(id);
                        $("#viewModal").modal('hide');
                        $(".select2").select2().select2('val', data.medicine_category_id);
                        holdModal('myModaledit');
                    },
                });
            }
			
            function viewDetail(id) {
               
                $.ajax({
                    url: '<?php echo base_url(); ?>admin/pharmacy/getDetails',
                    type: "POST",
                    data: {pharmacy_id: id},
                    dataType: 'json',
                    success: function (data) {
                        $.ajax({
                            url: '<?php echo base_url(); ?>admin/pharmacy/getMedicineBatch',
                            type: "POST",
                            data: {pharmacy_id: id},
                            success: function (data) {
                                $('#tabledata').html(data);
                            },
                        });
                        if (data.medicine_image != "") {
                            $("#medicine_image").attr('src', '<?php echo base_url() ?>' + data.medicine_image+'<?php echo img_time(); ?>');
                        } else {
                            $("#medicine_image").attr('src', '<?php echo base_url() ?>uploads/patient_images/no_image.png<?php echo img_time(); ?>');
                        }

                        $("#medicine_names").html(data.medicine_name);
                        $("#medicine_category_ids").html(data.medicine_category);
                        $("#medicine_companys").html(data.company_name);
                        $("#medicine_compositions").html(data.medicine_composition);
                        $("#medicine_groups").html(data.group_name);
                        $("#units").html(data.unit_name);
                        $("#min_levels").html(data.min_level);
                        $("#reorder_levels").html(data.reorder_level);
                        $("#vats").html(data.vat);
                        $("#unit_packings").html(data.unit_packing);
                        $("#suppliers").html(data.supplier);
                        $("#vat_acs").html(data.vat_ac);
                        $("#rack_number_v").html(data.rack_number);
                        $("#medicine_note").html(data.note);						
                        $('#edit_delete').html("<?php if ($this->rbac->hasPrivilege('medicine', 'can_edit')) { ?><a href='#'' onclick='getRecord(" + id + ")' data-toggle='tooltip' data-placement='bottom' data-original-title='<?php echo $this->lang->line('edit'); ?>'><i class='fa fa-pencil'></i></a><?php } if ($this->rbac->hasPrivilege('medicine', 'can_delete')) { ?><a onclick='delete_record(" + id + ")'  href='#' data-placement='bottom'  data-toggle='tooltip'  data-original-title='<?php echo $this->lang->line('delete'); ?>'><i class='fa fa-trash'></i></a><?php } ?>");
                        holdModal('viewModal');
                    },
                });
            }
			
            function addBulk(id) {
                $.ajax({
                    url: '<?php echo base_url(); ?>admin/pharmacy/getPharmacy',
                    type: "POST",
                    data: {pharmacy_id: id},
                    dataType: 'json',
                    success: function (data) {
                        $("#pharm_id").val(id);
                        holdModal('addBulkModal');
                    },
                })
            }
			
            $(document).ready(function (e) {
                $("#formbatch").on('submit', (function (e) {
                    e.preventDefault();
                    $("#formbatchbtn").button("loading");
                    $.ajax({
                        url: '<?php echo base_url(); ?>admin/pharmacy/medicineBatch',
                        type: "POST",
                        data: new FormData(this),
                        dataType: 'json',
                        contentType: false,
                        cache: false,
                        processData: false,
                        success: function (data) {
                            if (data.status == "fail") {
                                var message = "";
                                $.each(data.error, function (index, value) {
                                    message += value;
                                });
                                errorMsg(message);
                            } else {
                                successMsg(data.message);
                                window.location.reload(true);
                            }
                            $("#formbatchbtn").button('reset');
                        },
                        error: function () {
                            
                        }
                    });
                }));
            });
			
            function delete_record(id) {
                if (confirm('<?php echo $this->lang->line('are_you_sure'); ?>')) {
                    $.ajax({
                        url: '<?php echo base_url(); ?>admin/pharmacy/delete/' + id,
                        type: "POST",
                        data: {opdid: ''},
                        dataType: 'json',
                        success: function (data) {
                            if (data.status == "fail") {
                                var message = "";
                                $.each(data.error, function (index, value) {
                                    message += value;
                                });
                                errorMsg(message);
                            } else {
                                successMsg(data.message);
                                window.location.reload(true);
                            }
                        }
                    })
                }
            }
			
            function holdModal(modalId) {
                $('#' + modalId).modal({
                    backdrop: 'static',
                    keyboard: false,
                    show: true
                });
            }

            function addbadstock(id) {
                $("#pharmacy_stock_id").val(id);
                getbatchnolist(id);
                holdModal('addBadStockModal');
            }
 
            function getbatchnolist(id, selectid = '') {
                var div_data = "";
                $("#batch_stock_no").html("<option value=''><?php echo $this->lang->line('select') ?></option>");
                $.ajax({
                    type: "POST",
                    url: base_url + "admin/pharmacy/getBatchNoList",
                    data: {'pharmacy_id': id},
                    dataType: 'json',
                    success: function (res) {
                        console.log(res);
                        $.each(res, function (i, obj)
                        {
                            var sel = "";
                            if (obj.batch_no == selectid) {
                                sel = "selected";
                            }
                            div_data += "<option " + sel + " value='" + obj.batch_no + "'>" + obj.batch_no + "</option>";
                        });
                        $('#batch_stock_no').append(div_data);
                    }
                });
            }

            function getExpire(batch_no) {               
               if(batch_no==""){
                 $("#batch_expire").val('');
               }else{
                    $.ajax({
                        type: "POST",
                        url: base_url + "admin/pharmacy/getExpireDate",
                        data: {'batch_no': batch_no},
                        dataType: 'json',
                        success: function (data) {
                            if (data != null) {
                                $('#batch_expire').val(data.expiry);
                                $('#batch_available_qty').val(data.available_quantity);
                                $('#medicine_batch_id').val(data.id);
                            }
                        }
                    });
               }                
            }

    $(document).on('click','.delete_selected',function(){       
		var $this = $(this);     
		let obj =  [];       
		$('input:checkbox.enable_delete').each(function () {
		(this.checked ? obj.push($(this).val()) : "");
 });

 if (obj.length === 0) {  errorMsg('<?php echo $this->lang->line('no_record_selected'); ?>');  }else{
if (confirm('<?php echo $this->lang->line('are_you_sure_you_want_to_delete_this'); ?>')) {
      $.ajax({
          url: base_url+'admin/pharmacy/bulk_delete',          
          type: "POST",
          dataType: 'json',
          data:{'delete_id':obj},
          beforeSend: function() {
            $this.button('loading');
               
          },
          success: function(res) {     
            if(res.status == 0){
                var message = "";
                $.each(res.error, function (index, value) {
                    message += value;
                });
                errorMsg(message);
            }else{
                successMsg(res.message);
            }
          $this.button('reset');
         
         if(res.status){
            table.ajax.reload();
         }
          },
          error: function(xhr) { // if error occured
             alert("Error occured.please try again");
             $this.button('reset');                
      },
      complete: function() {
            $this.button('reset');              
      }
      });
  }
 }
  
  });

    $('.close_btn').click(function(){
        $('#formstock')[0].reset();
    });
</script>

<script type="text/javascript">

	$('#myModal').on('hidden.bs.modal', function () {
		$(".filestyle").next(".dropify-clear").trigger("click");
		$(".medicine_category_id").select2("val", "");
		$('#formadd').find('input:text, input:password, input:file, textarea').val('');
		$('#formadd').find('select option:selected').removeAttr('selected');
		$('#formadd').find('input:checkbox, input:radio').removeAttr('checked');
	});

$("input[name='checkAll']").click(function () {
    $("input[name='pharmacy[]']").not(this).prop('checked', this.checked);
});
</script>
<!-- //========datatable start===== -->
<script type="text/javascript">
( function ( $ ) {
    'use strict';
    $(document).ready(function () {
        initDatatable('ajaxlist','admin/pharmacy/getpharmacyDatatable',[],[],100,[
          { 'bSortable': false, 'aTargets': [ 0,-1 ] }
       ]);
    });
} ( jQuery ) )
</script>