<?php
// File: admin/pharmacy/_patientBills.php
?>
<div class="row">
    <div class="col-md-12">
        <div class="patient-info-header" style="margin-bottom: 20px; padding: 15px; background: #f8f9fa; border-radius: 5px;">
            <h4><i class="fa fa-user"></i> <?php echo $patient->patient_name; ?></h4>
            <p class="text-muted">
                <strong><?php echo $this->lang->line('patient_id'); ?>:</strong> <?php echo $patient->patient_unique_id; ?> | 
                <strong><?php echo $this->lang->line('phone'); ?>:</strong> <?php echo $patient->mobileno ?: 'N/A'; ?> |
                <strong><?php echo $this->lang->line('age'); ?>:</strong> <?php echo $patient->age ?: 'N/A'; ?>
            </p>
        </div>

        <?php if (!empty($bills)) { ?>
            <div class="table-responsive">
                <table class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th><?php echo $this->lang->line('bill_no'); ?></th>
                            <th><?php echo $this->lang->line('date'); ?></th>
                            <th><?php echo $this->lang->line('total'); ?> (<?php echo $currency_symbol; ?>)</th>
                            <th><?php echo $this->lang->line('paid'); ?> (<?php echo $currency_symbol; ?>)</th>
                            <th><?php echo $this->lang->line('balance'); ?> (<?php echo $currency_symbol; ?>)</th>
                            <th><?php echo $this->lang->line('status'); ?></th>
                            <th><?php echo $this->lang->line('action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($bills as $bill) { ?>
                            <tr>
                                <td>
                                    <?php echo $this->customlib->getSessionPrefixByType('pharmacy_billing') . $bill->id; ?>
                                </td>
                                <td>
                                    <?php echo $this->customlib->YYYYMMDDHisTodateFormat($bill->date, $this->customlib->getHospitalTimeFormat()); ?>
                                </td>
                                <td class="text-right">
                                    <?php echo $currency_symbol . amountFormat($bill->net_amount); ?>
                                </td>
                                <td class="text-right">
                                    <?php echo $currency_symbol . amountFormat($bill->paid_amount); ?>
                                </td>
                                <td class="text-right">
                                    <?php 
                                    $balance = $bill->balance;
                                    $balance_class = $balance > 0 ? 'text-danger' : ($balance < 0 ? 'text-success' : 'text-muted');
                                    ?>
                                    <span class="<?php echo $balance_class; ?>">
                                        <?php echo $currency_symbol . amountFormat(abs($balance)); ?>
                                    </span>
                                </td>
                                <td>
                                    <?php if ($balance > 0) { ?>
                                        <span class="label label-warning"><?php echo $this->lang->line('pending'); ?></span>
                                    <?php } elseif ($balance < 0) { ?>
                                        <span class="label label-success"><?php echo $this->lang->line('refund_due'); ?></span>
                                    <?php } else { ?>
                                        <span class="label label-success"><?php echo $this->lang->line('paid'); ?></span>
                                    <?php } ?>
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="#" onclick="viewBillDetails(<?php echo $bill->id; ?>)" 
                                           class="btn btn-default btn-xs" data-toggle="tooltip" 
                                           title="<?php echo $this->lang->line('view'); ?>">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                        <a href="#" onclick="printBill(<?php echo $bill->id; ?>)" 
                                           class="btn btn-default btn-xs" data-toggle="tooltip" 
                                           title="<?php echo $this->lang->line('print'); ?>">
                                            <i class="fa fa-print"></i>
                                        </a>
                                        <?php if ($balance > 0) { ?>
                                            <a href="#" onclick="addPayment(<?php echo $bill->id; ?>)" 
                                               class="btn btn-success btn-xs" data-toggle="tooltip" 
                                               title="<?php echo $this->lang->line('add_payment'); ?>">
                                                <i class="fa fa-money"></i>
                                            </a>
                                        <?php } ?>
                                    </div>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>

            <!-- Summary Card -->
            <div class="row" style="margin-top: 20px;">
                <div class="col-md-12">
                    <div class="info-box bg-blue">
                        <span class="info-box-icon"><i class="fa fa-shopping-cart"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text"><?php echo $this->lang->line('total_bills'); ?></span>
                            <span class="info-box-number"><?php echo count($bills); ?></span>
                            <div class="progress">
                                <div class="progress-bar" style="width: 100%"></div>
                            </div>
                            <span class="progress-description">
                                <?php 
                                $total_amount = array_sum(array_column($bills, 'net_amount'));
                                $total_paid = array_sum(array_column($bills, 'paid_amount'));
                                echo $this->lang->line('total') . ': ' . $currency_symbol . amountFormat($total_amount) . ' | ';
                                echo $this->lang->line('paid') . ': ' . $currency_symbol . amountFormat($total_paid);
                                ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        <?php } else { ?>
            <div class="alert alert-info text-center">
                <i class="fa fa-info-circle"></i>
                <?php echo $this->lang->line('no_pharmacy_bills_found'); ?>
                <br><br>
                <button type="button" class="btn btn-success" onclick="createNewBill(<?php echo $patient->id; ?>)">
                    <i class="fa fa-plus"></i> <?php echo $this->lang->line('create_first_bill'); ?>
                </button>
            </div>
        <?php } ?>
    </div>
</div>

<script>
function viewBillDetails(billId) {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/pharmacy/getBillDetails',
        type: 'POST',
        data: { id: billId },
        success: function(response) {
            if (response.status) {
                // Handle bill details display
                // You can open another modal or redirect
                window.open('<?php echo base_url(); ?>admin/pharmacy/bill/' + billId, '_blank');
            }
        }
    });
}

function printBill(billId) {
    window.open('<?php echo base_url(); ?>admin/pharmacy/printBill/' + billId, '_blank');
}

function addPayment(billId) {
    // Open payment modal
    $.ajax({
        url: '<?php echo base_url(); ?>admin/pharmacy/getPharmacyTransaction',
        type: 'POST',
        data: { id: billId },
        success: function(response) {
            if (response.status) {
                // Display payment form in a modal
                // Implementation depends on your existing payment modal
            }
        }
    });
}

function createNewBill(patientId) {
    $('#patientBillsModal').modal('hide');
    setTimeout(function() {
        createBillForPatient();
    }, 500);
}
</script>