<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>General Patient Registration with Insurance & Queue Management</title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/font-awesome.min.css">
    <!-- AdminLTE Theme -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/skins/_all-skins.min.css">
    
    <style>
        .content-wrapper {
            background-color: #ecf0f5;
        }
        
        .general-header {
            background: linear-gradient(135deg, #3c8dbc 0%, #00c0ef 100%);
            color: white;
            padding: 20px;
            border-radius: 3px;
            margin-bottom: 20px;
        }
        
        .insurance-section {
            background: #e8f4fd;
            border: 1px solid #bee5eb;
            border-radius: 5px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .copay-calculation-box {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 5px;
            padding: 15px;
            margin: 15px 0;
        }
        
        .payment-summary {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            border-radius: 5px;
            padding: 15px;
            margin: 15px 0;
        }
        
        .queue-info-box {
            background: #f0f8ff;
            border: 1px solid #87ceeb;
            border-radius: 5px;
            padding: 15px;
            margin: 15px 0;
        }
        
        .service-checkbox {
            background: white;
            border: 1px solid #ddd;
            border-radius: 3px;
            padding: 12px;
            margin: 8px 0;
            transition: all 0.3s ease;
        }
        
        .service-checkbox:hover {
            border-color: #3c8dbc;
            background-color: #f8f9fa;
        }
        
        .service-checkbox input[type="checkbox"]:checked + label {
            font-weight: bold;
            color: #3c8dbc;
        }
        
        .payment-method-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 10px;
            margin: 15px 0;
        }
        
        .payment-method {
            border: 2px solid #ddd;
            border-radius: 5px;
            padding: 15px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .payment-method:hover {
            border-color: #3c8dbc;
            background-color: #f8f9fa;
        }
        
        .payment-method.selected {
            border-color: #3c8dbc;
            background-color: #e8f4fd;
        }
        
        .required {
            color: #dd4b39;
        }
        
        .btn-general {
            background-color: #3c8dbc;
            border-color: #3c8dbc;
            color: white;
        }
        
        .btn-general:hover {
            background-color: #367fa9;
            border-color: #367fa9;
            color: white;
        }
        
        .cost-display {
            background: rgba(255,255,255,0.2);
            border: 1px solid rgba(255,255,255,0.3);
            color: white;
            padding: 8px 15px;
            border-radius: 15px;
            font-weight: bold;
            text-align: center;
        }
        
        .verification-badge {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 11px;
            font-weight: bold;
            text-transform: uppercase;
        }
        
        .verification-verified { background: #d4edda; color: #155724; }
        .verification-pending { background: #fff3cd; color: #856404; }
        .verification-expired { background: #f8d7da; color: #721c24; }
        
        .amount-breakdown {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 8px 0;
            border-bottom: 1px solid #eee;
        }
        
        .amount-breakdown:last-child {
            border-bottom: 2px solid #3c8dbc;
            font-weight: bold;
        }
        
        .age-display {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 4px;
            padding: 8px 12px;
            margin-top: 5px;
            font-weight: bold;
            color: #495057;
        }
    </style>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                General Patient Registration
                <small>Complete Registration with Insurance, Copay & Queue Management</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                <li><a href="#">Patient</a></li>
                <li class="active">General Registration</li>
            </ol>
        </section>

        <section class="content">
            <!-- General Header -->
            <div class="general-header">
                <div class="row">
                    <div class="col-md-8">
                        <h3><i class="fa fa-users"></i> General Patient Registration</h3>
                        <p class="margin-bottom-none">Complete registration with insurance support, copay calculation & automatic queue management</p>
                    </div>
                    <div class="col-md-4 text-right">
                        <div class="cost-display">
                            <i class="fa fa-money"></i> Base Registration: KES 900
                        </div>
                    </div>
                </div>
            </div>

            <!-- Registration Form -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-edit"></i> Patient Information & Insurance Details</h3>
                </div>
                
                <form id="generalForm" action="<?php echo base_url(); ?>admin/patient/addpatient" method="post" enctype="multipart/form-data">
                    <!-- Hidden fields for workflow -->
                    <input type="hidden" name="workflow_type" value="general">
                    <input type="hidden" name="patient_type" value="General">
                    <input type="hidden" name="is_ipd" value="no">
                    <input type="hidden" name="app_key" value="">
                    <input type="hidden" name="is_antenatal" value="0">
                    <input type="hidden" name="is_active" value="yes">
                    
                    <div class="box-body">
                        <!-- Basic Information -->
                        <h4><i class="fa fa-user"></i> Basic Information</h4>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Patient Name <span class="required">*</span></label>
                                    <input type="text" name="name" class="form-control" placeholder="Enter full name" required>
                                </div>
                                
                                <div class="form-group">
                                    <label>Date of Birth <span class="required">*</span></label>
                                    <input type="date" name="dob" id="date_of_birth" class="form-control" required max="<?php echo date('Y-m-d'); ?>">
                                    <small class="text-muted">Age will be calculated automatically</small>
                                    
                                    <!-- Age Display (Auto-calculated) -->
                                    <div id="age_display" class="age-display" style="display: none;">
                                        <i class="fa fa-birthday-cake"></i> Age: <span id="calculated_age"></span>
                                    </div>
                                    
                                    <!-- Hidden age fields for form submission -->
                                    <input type="hidden" name="age[year]" id="age_year">
                                    <input type="hidden" name="age[month]" id="age_month">
                                    <input type="hidden" name="age[day]" id="age_day">
                                </div>
                                
                                <div class="form-group">
                                    <label>Gender</label>
                                    <select name="gender" class="form-control">
                                        <option value="">Select Gender</option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                                
                                <div class="form-group">
                                    <label>Mobile Number</label>
                                    <input type="tel" name="mobileno" class="form-control" placeholder="+254 700 000 000">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Email Address</label>
                                    <input type="email" name="email" class="form-control" placeholder="patient@example.com">
                                </div>
                                
                                <div class="form-group">
                                    <label>Guardian/Next of Kin</label>
                                    <input type="text" name="guardian_name" class="form-control" placeholder="Guardian name">
                                </div>
                                
                                <div class="form-group">
                                    <label>Blood Group</label>
                                    <select name="blood_group" class="form-control">
                                        <option value="">Select Blood Group</option>
                                        <option value="A+">A+</option>
                                        <option value="A-">A-</option>
                                        <option value="B+">B+</option>
                                        <option value="B-">B-</option>
                                        <option value="AB+">AB+</option>
                                        <option value="AB-">AB-</option>
                                        <option value="O+">O+</option>
                                        <option value="O-">O-</option>
                                    </select>
                                </div>
                                
                                <div class="form-group">
                                    <label>Known Allergies</label>
                                    <input type="text" name="known_allergies" class="form-control" placeholder="Known allergies (optional)">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Address</label>
                                    <textarea name="address" class="form-control" rows="3" placeholder="Patient residential address"></textarea>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- Insurance & TPA Information -->
                        <h4><i class="fa fa-shield"></i> Insurance & Coverage Options</h4>
                        
                        <!-- Coverage Type Selection -->
                        <div class="form-group">
                            <label><strong>Coverage Type</strong></label>
                            <div class="coverage-options" style="margin-top: 10px;">
                                <div class="radio" style="margin-bottom: 10px;">
                                    <label>
                                        <input type="radio" id="no_coverage" name="coverage_type" value="none" checked>
                                        <strong>No Coverage</strong> - Full payment by patient
                                    </label>
                                </div>
                                <div class="radio" style="margin-bottom: 10px;">
                                    <label>
                                        <input type="radio" id="has_insurance" name="coverage_type" value="insurance">
                                        <strong>Insurance/TPA Coverage</strong> - Private or corporate insurance
                                    </label>
                                </div>
                                <div class="radio" style="margin-bottom: 10px;">
                                    <label>
                                        <input type="radio" id="has_community_card" name="coverage_type" value="community_card">
                                        <strong>City Health Community Card</strong> - Microinsurance (1-year renewable)
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="insurance-section" id="insurance-details" style="display: none;">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Insurance Company/TPA <span class="required">*</span></label>
                                        <select class="form-control" name="organisation_id" id="organisation_id">
                                            <option value="">Select Insurance Provider</option>
                                            <option value="1" data-coverage="70">Madison Insurance</option>
                                            <option value="2" data-coverage="80">AAR Insurance</option>
                                            <option value="3" data-coverage="75">Britam Insurance</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Member Number <span class="required">*</span></label>
                                        <input type="text" class="form-control" name="insurance_id" id="insurance_id" placeholder="Member Number">
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Insurance Validity Date <small class="text-muted">(Optional)</small></label>
                                        <input type="date" class="form-control" name="validity" id="insurance_validity" min="<?php echo date('Y-m-d'); ?>">
                                        <small class="help-block">Leave blank if no validity period applies</small>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Insurance Scheme</label>
                                        <select class="form-control" name="insurance_scheme" id="insurance_scheme">
                                            <option value="">Select Scheme</option>
                                            <option value="comprehensive">Comprehensive Cover</option>
                                            <option value="basic">Basic Cover</option>
                                            <option value="outpatient">Outpatient Only</option>
                                            <option value="inpatient">Inpatient Only</option>
                                            <option value="maternity">Maternity Cover</option>
                                            <option value="chronic">Chronic Disease Cover</option>
                                            <option value="emergency">Emergency Cover</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Coverage Percentage</label>
                                        <select class="form-control" name="insurance_coverage_percentage" id="coverage_percentage">
                                            <option value="70">70% Coverage (30% Copay)</option>
                                            <option value="80">80% Coverage (20% Copay)</option>
                                            <option value="90">90% Coverage (10% Copay)</option>
                                            <option value="100">100% Coverage (No Copay)</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Insurance Verification -->
                            <div class="row">
                                <div class="col-md-12">
                                    <button type="button" class="btn btn-info" id="verify-insurance">
                                        <i class="fa fa-check-circle"></i> Verify Insurance Coverage
                                    </button>
                                    <span id="verification-status" class="verification-badge verification-pending" style="display: none;">
                                        Pending Verification
                                    </span>
                                </div>
                            </div>
                        </div>

                        <!-- City Health Community Card Section -->
                        <div class="insurance-section" id="community-card-details" style="display: none; background: #f0f8ed; border: 1px solid #d4edda; border-radius: 5px;">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="alert alert-info" style="margin-bottom: 15px;">
                                        <h5><i class="fa fa-info-circle"></i> City Health Community Card</h5>
                                        <p><strong>Microinsurance Benefits:</strong> 60% coverage for basic services, 1-year validity, renewable annually. Covers consultations, basic lab tests, and essential medications.</p>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Community Card Number <span class="required">*</span></label>
                                        <input type="text" class="form-control" name="community_card_number" id="community_card_number" placeholder="CHC-XXXX-XXXX-XXXX">
                                        <small class="help-block">Format: CHC-XXXX-XXXX-XXXX</small>
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Issue Date</label>
                                        <input type="date" class="form-control" name="community_card_issue_date" id="community_card_issue_date" readonly>
                                        <small class="help-block">Auto-filled upon verification</small>
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Expiry Date</label>
                                        <input type="date" class="form-control" name="community_card_expiry" id="community_card_expiry" readonly>
                                        <small class="help-block">1 year from issue date</small>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Card Status</label>
                                        <input type="text" class="form-control" name="community_card_status" id="community_card_status" readonly placeholder="Status will be verified">
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Coverage Level</label>
                                        <select class="form-control" name="community_card_coverage" id="community_card_coverage" disabled>
                                            <option value="basic">Basic - 60% Coverage (40% Copay)</option>
                                            <option value="plus">Plus - 70% Coverage (30% Copay)</option>
                                            <option value="premium">Premium - 80% Coverage (20% Copay)</option>
                                        </select>
                                        <small class="help-block">Coverage level determined by card type</small>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Community Card Verification -->
                            <div class="row">
                                <div class="col-md-12">
                                    <button type="button" class="btn btn-success" id="verify-community-card">
                                        <i class="fa fa-search"></i> Verify Community Card
                                    </button>
                                    <button type="button" class="btn btn-warning" id="renew-community-card" style="display: none;">
                                        <i class="fa fa-refresh"></i> Renew Card
                                    </button>
                                    <span id="community-verification-status" class="verification-badge verification-pending" style="display: none;">
                                        Pending Verification
                                    </span>
                                </div>
                            </div>
                            
                            <div class="row" id="community-card-benefits" style="display: none; margin-top: 15px;">
                                <div class="col-md-12">
                                    <div class="alert alert-success">
                                        <h6><i class="fa fa-check"></i> Community Card Benefits Active</h6>
                                        <ul class="list-unstyled" style="margin-bottom: 0;">
                                            <li>✓ <strong>General Consultation:</strong> 60% covered</li>
                                            <li>✓ <strong>Basic Lab Tests:</strong> 60% covered</li>
                                            <li>✓ <strong>Essential Medications:</strong> 60% covered</li>
                                            <li>✓ <strong>Preventive Services:</strong> 70% covered</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- Service Selection with Pricing -->
                        <h4><i class="fa fa-list-check"></i> Service Selection & Pricing</h4>
                        <p class="text-muted">Select the services this patient may require. Pricing will adjust based on insurance coverage.</p>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="service-checkbox">
                                    <input type="checkbox" name="services[]" value="consultation" id="general_consultation" data-price="1500">
                                    <label for="general_consultation">
                                        <strong><i class="fa fa-user-md"></i> Doctor Consultation</strong>
                                        <span class="pull-right text-primary"><strong>KES 1,500</strong></span>
                                        <br><small class="text-muted">General practitioner consultation</small>
                                    </label>
                                </div>
                                
                                <div class="service-checkbox">
                                    <input type="checkbox" name="services[]" value="laboratory" id="general_lab" data-price="2500">
                                    <label for="general_lab">
                                        <strong><i class="fa fa-flask"></i> Laboratory Tests</strong>
                                        <span class="pull-right text-primary"><strong>KES 2,500</strong></span>
                                        <br><small class="text-muted">Blood tests, urine analysis, etc.</small>
                                    </label>
                                </div>
                                
                                <div class="service-checkbox">
                                    <input type="checkbox" name="services[]" value="radiology" id="general_radiology" data-price="3000">
                                    <label for="general_radiology">
                                        <strong><i class="fa fa-camera"></i> Radiology/Imaging</strong>
                                        <span class="pull-right text-primary"><strong>KES 3,000</strong></span>
                                        <br><small class="text-muted">X-rays, ultrasound, CT scans</small>
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="service-checkbox">
                                    <input type="checkbox" name="services[]" value="pharmacy" id="general_pharmacy" data-price="1000">
                                    <label for="general_pharmacy">
                                        <strong><i class="fa fa-pills"></i> Pharmacy Services</strong>
                                        <span class="pull-right text-primary"><strong>KES 1,000</strong></span>
                                        <br><small class="text-muted">Medication dispensing and counseling</small>
                                    </label>
                                </div>
                                
                                <div class="service-checkbox">
                                    <input type="checkbox" name="services[]" value="triage" id="general_triage" data-price="500">
                                    <label for="general_triage">
                                        <strong><i class="fa fa-stethoscope"></i> Triage Assessment</strong>
                                        <span class="pull-right text-primary"><strong>KES 500</strong></span>
                                        <br><small class="text-muted">Initial health screening and vital signs</small>
                                    </label>
                                </div>
                                
                                <div class="service-checkbox">
                                    <input type="checkbox" name="services[]" value="booking" id="general_booking" data-price="200">
                                    <label for="general_booking">
                                        <strong><i class="fa fa-calendar-check-o"></i> Follow-up Booking</strong>
                                        <span class="pull-right text-primary"><strong>KES 200</strong></span>
                                        <br><small class="text-muted">Schedule follow-up appointments</small>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- Copay Calculation -->
                        <div class="copay-calculation-box" id="copay-calculation" style="display: none;">
                            <h5><i class="fa fa-calculator"></i> Payment Calculation</h5>
                            <div id="payment-breakdown">
                                <div class="amount-breakdown">
                                    <span>Registration Fee:</span>
                                    <span id="registration-fee">KES 900.00</span>
                                </div>
                                <div class="amount-breakdown">
                                    <span>Selected Services Total:</span>
                                    <span id="services-total">KES 0.00</span>
                                </div>
                                <div class="amount-breakdown">
                                    <span>Subtotal:</span>
                                    <span id="subtotal">KES 900.00</span>
                                </div>
                                <div class="amount-breakdown">
                                    <span>Insurance Coverage (<span id="coverage-percent">0</span>%):</span>
                                    <span id="insurance-amount">KES 0.00</span>
                                </div>
                                <div class="amount-breakdown">
                                    <span><strong>Patient Copay Amount:</strong></span>
                                    <span id="copay-amount"><strong>KES 900.00</strong></span>
                                </div>
                            </div>
                        </div>

                        <!-- Payment Method Selection -->
                        <div class="payment-summary" id="payment-section" style="display: none;">
                            <h5><i class="fa fa-credit-card"></i> Payment Method</h5>
                            <p class="text-muted">Select how the copay amount will be collected:</p>
                            
                            <div class="payment-method-grid">
                                <div class="payment-method" data-method="cash">
                                    <i class="fa fa-money fa-2x text-success"></i>
                                    <br><strong>Cash</strong>
                                    <input type="radio" name="payment_method" value="cash" style="display: none;">
                                </div>
                                <div class="payment-method" data-method="card">
                                    <i class="fa fa-credit-card fa-2x text-info"></i>
                                    <br><strong>Card</strong>
                                    <input type="radio" name="payment_method" value="card" style="display: none;">
                                </div>
                                <div class="payment-method" data-method="mobile_money">
                                    <i class="fa fa-mobile fa-2x text-warning"></i>
                                    <br><strong>M-Pesa</strong>
                                    <input type="radio" name="payment_method" value="mobile_money" style="display: none;">
                                </div>
                                <div class="payment-method" data-method="cheque">
                                    <i class="fa fa-file-text fa-2x text-primary"></i>
                                    <br><strong>Cheque</strong>
                                    <input type="radio" name="payment_method" value="cheque" style="display: none;">
                                </div>
                            </div>

                            <!-- Hidden fields for copay tracking -->
                            <input type="hidden" name="copay_amount" id="hidden_copay_amount" value="0">
                            <input type="hidden" name="insurance_amount" id="hidden_insurance_amount" value="0">
                            <input type="hidden" name="total_service_amount" id="hidden_total_amount" value="900">
                            <input type="hidden" name="copay_percentage" id="hidden_copay_percentage" value="100">
                        </div>

                        <!-- Queue Information -->
                        <div class="queue-info-box" id="queue-info" style="display: none;">
                            <h5><i class="fa fa-users"></i> Queue Information</h5>
                            <p class="text-muted">Patient will be automatically added to the appropriate queue after registration.</p>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Initial Department Queue</label>
                                        <select class="form-control" name="initial_queue_department" id="initial_queue_department">
                                            <option value="registration">Registration (Default)</option>
                                            <option value="triage">Triage</option>
                                            <option value="consultation">Consultation</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Priority Level</label>
                                        <select class="form-control" name="queue_priority" id="queue_priority">
                                            <option value="normal">Normal</option>
                                            <option value="high">High</option>
                                            <option value="urgent">Urgent</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- Additional Information -->
                        <h4><i class="fa fa-info-circle"></i> Additional Information</h4>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Additional Notes</label>
                                    <textarea name="note" class="form-control" rows="3" placeholder="Any additional notes or special instructions"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="box-footer">
                        <div class="row">
                            <div class="col-md-6">
                                <a href="<?php echo base_url(); ?>admin/patient" class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> Back to Patient List
                                </a>
                            </div>
                            <div class="col-md-6 text-right">
                                <button type="submit" class="btn btn-general btn-lg" id="submit-btn">
                                    <i class="fa fa-save"></i> Register Patient & Add to Queue
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Navigation Links -->
            <div class="box box-default">
                <div class="box-header">
                    <h3 class="box-title">Other Registration Types</h3>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <a href="<?php echo base_url(); ?>admin/patient/gcc_registration" class="btn btn-success btn-block btn-lg">
                                <i class="fa fa-globe"></i> GCC Process<br>
                                <small>KES 10,500</small>
                            </a>
                        </div>
                        <div class="col-md-4">
                            <a href="<?php echo base_url(); ?>admin/patient/specialized_registration" class="btn btn-danger btn-block btn-lg">
                                <i class="fa fa-user-md"></i> Specialized Process<br>
                                <small>KES 1,500</small>
                            </a>
                        </div>
                        <div class="col-md-4">
                            <a href="<?php echo base_url(); ?>admin/queue" class="btn btn-info btn-block btn-lg">
                                <i class="fa fa-users"></i> Queue Management<br>
                                <small>View All Queues</small>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>

<!-- jQuery -->
<script src="<?php echo base_url(); ?>backend/plugins/jQuery/jquery.min.js"></script>
<!-- Bootstrap -->
<script src="<?php echo base_url(); ?>backend/bootstrap/js/bootstrap.min.js"></script>
<!-- AdminLTE App -->
<script src="<?php echo base_url(); ?>backend/dist/js/adminlte.min.js"></script>
<script src="<?php echo base_url(); ?>backend/dist/js/queue_notifications.js"></script>
<script>
$(document).ready(function() {
    let baseRegistrationFee = 900;
    
    // Auto-calculate age from date of birth
    $('#date_of_birth').on('change', function() {
        const dob = new Date($(this).val());
        const today = new Date();
        
        if (dob && dob <= today) {
            const age = calculateAge(dob, today);
            
            // Update hidden fields
            $('#age_year').val(age.years);
            $('#age_month').val(age.months);
            $('#age_day').val(age.days);
            
            // Display calculated age
            const ageText = `${age.years} years, ${age.months} months, ${age.days} days`;
            $('#calculated_age').text(ageText);
            $('#age_display').show();
        } else {
            $('#age_display').hide();
            $('#age_year, #age_month, #age_day').val('');
        }
    });
    
    function calculateAge(birthDate, currentDate) {
        let years = currentDate.getFullYear() - birthDate.getFullYear();
        let months = currentDate.getMonth() - birthDate.getMonth();
        let days = currentDate.getDate() - birthDate.getDate();
        
        if (days < 0) {
            months--;
            days += new Date(currentDate.getFullYear(), currentDate.getMonth(), 0).getDate();
        }
        
        if (months < 0) {
            years--;
            months += 12;
        }
        
        return { years: years, months: months, days: days };
    }
    
    // Handle coverage type selection
    $('input[name="coverage_type"]').on('change', function() {
        const selectedType = $(this).val();
        
        // Hide all coverage sections first
        $('#insurance-details').slideUp();
        $('#community-card-details').slideUp();
        $('#copay-calculation').hide();
        $('#payment-section').hide();
        
        // Show appropriate section based on selection
        if (selectedType === 'insurance') {
            $('#insurance-details').slideDown();
            $('#queue-info').show();
            calculatePayment();
        } else if (selectedType === 'community_card') {
            $('#community-card-details').slideDown();
            $('#queue-info').show();
            calculatePaymentCommunityCard();
        } else {
            // No coverage selected
            $('#queue-info').hide();
            resetPaymentCalculation();
        }
    });

    // Service selection tracking
    $('input[name="services[]"]').on('change', function() {
        calculatePayment();
        $('#queue-info').show();
    });

    // Coverage percentage change
    $('#coverage_percentage').on('change', function() {
        calculatePayment();
    });

    // Payment method selection
    $('.payment-method').on('click', function() {
        $('.payment-method').removeClass('selected');
        $(this).addClass('selected');
        const method = $(this).data('method');
        $('input[name="payment_method"]').prop('checked', false);
        $(this).find('input[name="payment_method"]').prop('checked', true);
    });

    // Insurance verification
    $('#verify-insurance').on('click', function() {
        const btn = $(this);
        const originalText = btn.html();
        btn.html('<i class="fa fa-spinner fa-spin"></i> Verifying...').prop('disabled', true);
        
        // Simulate insurance verification
        setTimeout(function() {
            $('#verification-status').show().removeClass('verification-pending')
                .addClass('verification-verified').text('Verified');
            btn.html(originalText).prop('disabled', false);
        }, 2000);
    });

    // Community Card verification
    $('#verify-community-card').on('click', function() {
        const btn = $(this);
        const originalText = btn.html();
        const cardNumber = $('#community_card_number').val().trim();
        
        if (!cardNumber) {
            alert('Please enter community card number');
            $('#community_card_number').focus();
            return;
        }
        
        if (!/^CHC-\d{4}-\d{4}-\d{4}$/.test(cardNumber)) {
            alert('Invalid card number format. Use: CHC-XXXX-XXXX-XXXX');
            $('#community_card_number').focus();
            return;
        }
        
        btn.html('<i class="fa fa-spinner fa-spin"></i> Verifying...').prop('disabled', true);
        
        // Real community card verification via AJAX
        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/verify_community_card',
            type: 'POST',
            data: { card_number: cardNumber },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    const card = response.card;
                    
                    // Fill in card details
                    $('#community_card_issue_date').val(card.issue_date);
                    $('#community_card_expiry').val(card.expiry_date);
                    $('#community_card_status').val(card.status).removeClass('text-danger').addClass('text-success');
                    $('#community_card_coverage').val(card.coverage_level).prop('disabled', false);
                    
                    if (card.status === 'expired') {
                        $('#community_card_status').removeClass('text-success').addClass('text-danger');
                        $('#community-verification-status').show().removeClass('verification-pending verification-verified')
                            .addClass('verification-expired').text('Card Expired');
                        $('#renew-community-card').show();
                    } else {
                        $('#community-verification-status').show().removeClass('verification-pending')
                            .addClass('verification-verified').text('Verified - ' + card.holder_name);
                        $('#community-card-benefits').slideDown();
                        
                        calculatePaymentCommunityCard();
                    }
                } else {
                    $('#community_card_status').val('Not Found').removeClass('text-success').addClass('text-danger');
                    $('#community-verification-status').show().removeClass('verification-pending verification-verified')
                        .addClass('verification-expired').text('Not Found');
                    alert('Card verification failed: ' + response.message);
                }
                
                btn.html(originalText).prop('disabled', false);
            },
            error: function(xhr) {
                $('#community_card_status').val('Verification Error').removeClass('text-success').addClass('text-danger');
                $('#community-verification-status').show().removeClass('verification-pending verification-verified')
                    .addClass('verification-expired').text('Error');
                alert('Verification failed. Please try again.');
                btn.html(originalText).prop('disabled', false);
            }
        });
    });

    // Community Card renewal
    $('#renew-community-card').on('click', function() {
        const btn = $(this);
        const originalText = btn.html();
        const cardNumber = $('#community_card_number').val().trim();
        
        if (!cardNumber) {
            alert('Card number is required for renewal');
            return;
        }
        
        if (!confirm('Are you sure you want to renew this community card? A renewal fee may apply.')) {
            return;
        }
        
        btn.html('<i class="fa fa-spinner fa-spin"></i> Processing Renewal...').prop('disabled', true);
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/renew_community_card',
            type: 'POST',
            data: { card_number: cardNumber },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    const card = response.card;
                    
                    // Update card details
                    $('#community_card_issue_date').val(card.issue_date);
                    $('#community_card_expiry').val(card.expiry_date);
                    $('#community_card_status').val('Active - Renewed').removeClass('text-danger').addClass('text-success');
                    
                    $('#community-verification-status').removeClass('verification-expired')
                        .addClass('verification-verified').text('Renewed & Verified - ' + card.holder_name);
                    $('#community-card-benefits').slideDown();
                    btn.hide();
                    
                    alert(response.message + '\nNew expiry: ' + new Date(card.expiry_date).toLocaleDateString());
                    calculatePaymentCommunityCard();
                } else {
                    alert('Renewal failed: ' + response.message);
                }
                
                btn.html(originalText).prop('disabled', false);
            },
            error: function(xhr) {
                alert('Renewal failed. Please try again or contact support.');
                btn.html(originalText).prop('disabled', false);
            }
        });
    });

    function calculatePaymentCommunityCard() {
        const selectedServices = [];
        $('input[name="services[]"]:checked').each(function() {
            selectedServices.push($(this).data('service'));
        });
        
        const baseRegistrationFee = 900; // Base registration fee
        let servicesTotal = selectedServices.reduce((total, service) => total + service.price, 0);
        
        const subtotal = baseRegistrationFee + servicesTotal;
        let coveragePercentage = 60; // Default community card coverage
        
        // Adjust coverage based on card type
        const cardType = $('#community_card_coverage').val();
        if (cardType === 'plus') coveragePercentage = 70;
        if (cardType === 'premium') coveragePercentage = 80;
        
        const insuranceAmount = (subtotal * coveragePercentage) / 100;
        const copayAmount = subtotal - insuranceAmount;
        
        // Update display
        $('#services-total').text('KES ' + servicesTotal.toFixed(2));
        $('#subtotal').text('KES ' + subtotal.toFixed(2));
        $('#coverage-percent').text(coveragePercentage);
        $('#insurance-amount').text('KES ' + insuranceAmount.toFixed(2));
        $('#copay-amount').text('KES ' + copayAmount.toFixed(2));
        
        // Update hidden fields
        $('#hidden_copay_amount').val(copayAmount.toFixed(2));
        $('#hidden_insurance_amount').val(insuranceAmount.toFixed(2));
        $('#hidden_total_amount').val(subtotal.toFixed(2));
        $('#hidden_copay_percentage').val((100 - coveragePercentage).toFixed(2));
        
        // Show calculation sections
        $('#copay-calculation').show();
        $('#payment-section').show();
        
        console.log('Community Card Payment Calculation:', {
            servicesTotal: servicesTotal,
            subtotal: subtotal,
            coveragePercentage: coveragePercentage,
            insuranceAmount: insuranceAmount,
            copayAmount: copayAmount,
            cardType: cardType
        });
    }

    function calculatePayment() {
        let servicesTotal = 0;
        let selectedServices = [];
        
        // Calculate selected services total
        $('input[name="services[]"]:checked').each(function() {
            const price = parseFloat($(this).data('price')) || 0;
            servicesTotal += price;
            selectedServices.push($(this).val());
        });
        
        const subtotal = baseRegistrationFee + servicesTotal;
        let coveragePercentage = 0;
        let insuranceAmount = 0;
        let copayAmount = subtotal;
        
        // Check coverage type and calculate accordingly
        const coverageType = $('input[name="coverage_type"]:checked').val();
        
        if (coverageType === 'insurance' && $('#coverage_percentage').val()) {
            coveragePercentage = parseFloat($('#coverage_percentage').val()) || 0;
            insuranceAmount = (subtotal * coveragePercentage) / 100;
            copayAmount = subtotal - insuranceAmount;
        } else if (coverageType === 'community_card' && $('#community_card_coverage').val()) {
            // Community card coverage rates
            const cardType = $('#community_card_coverage').val();
            if (cardType === 'basic') coveragePercentage = 60;
            if (cardType === 'plus') coveragePercentage = 70;
            if (cardType === 'premium') coveragePercentage = 80;
            
            insuranceAmount = (subtotal * coveragePercentage) / 100;
            copayAmount = subtotal - insuranceAmount;
        }
        
        // Update display
        $('#services-total').text('KES ' + servicesTotal.toFixed(2));
        $('#subtotal').text('KES ' + subtotal.toFixed(2));
        $('#coverage-percent').text(coveragePercentage);
        $('#insurance-amount').text('KES ' + insuranceAmount.toFixed(2));
        $('#copay-amount').text('KES ' + copayAmount.toFixed(2));
        
        // Update hidden fields
        $('#hidden_copay_amount').val(copayAmount.toFixed(2));
        $('#hidden_insurance_amount').val(insuranceAmount.toFixed(2));
        $('#hidden_total_amount').val(subtotal.toFixed(2));
        $('#hidden_copay_percentage').val((100 - coveragePercentage).toFixed(2));
        
        // Show calculation and payment sections if there are services or insurance
        if (selectedServices.length > 0 || $('#has_insurance').is(':checked')) {
            $('#copay-calculation').show();
            $('#payment-section').show();
        } else {
            $('#copay-calculation').hide();
            $('#payment-section').hide();
        }
        
        console.log('Payment calculation:', {
            services: selectedServices,
            servicesTotal: servicesTotal,
            subtotal: subtotal,
            coveragePercentage: coveragePercentage,
            insuranceAmount: insuranceAmount,
            copayAmount: copayAmount
        });
    }
    
    function resetPaymentCalculation() {
        $('#services-total').text('KES 0.00');
        $('#subtotal').text('KES ' + baseRegistrationFee.toFixed(2));
        $('#coverage-percent').text('0');
        $('#insurance-amount').text('KES 0.00');
        $('#copay-amount').text('KES ' + baseRegistrationFee.toFixed(2));
        
        $('#hidden_copay_amount').val(baseRegistrationFee);
        $('#hidden_insurance_amount').val('0');
        $('#hidden_total_amount').val(baseRegistrationFee);
        $('#hidden_copay_percentage').val('100');
    }

    // Form submission handler
    $('#generalForm').on('submit', function(e) {
        e.preventDefault();
        
        // Validate required fields
        if (!validateForm()) {
            return;
        }
        
        // Show loading state
        const submitBtn = $('#submit-btn');
        const originalText = submitBtn.html();
        submitBtn.html('<i class="fa fa-spinner fa-spin"></i> Registering...').prop('disabled', true);
        
        // Submit form via AJAX
        const formData = new FormData(this);
        
        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(data) {
                try {
                    const response = typeof data === 'string' ? JSON.parse(data) : data;
                    
                    if (response.status === 'success') {
                        // Get selected services and queue info
                        const selectedServices = [];
                        $('input[name="services[]"]:checked').each(function() {
                            selectedServices.push($(this).val());
                        });
                        
                        const queueDepartment = $('#initial_queue_department').val() || 'registration';
                        const queuePriority = $('#queue_priority').val() || 'normal';
                        
                        let message = 'Patient registered successfully!\n';
                        message += 'Patient ID: ' + response.patient_id + '\n';
                        message += 'Workflow: ' + response.workflow_type + '\n';
                        message += 'Queue: ' + queueDepartment + ' (' + queuePriority + ' priority)\n';
                        
                        if (selectedServices.length > 0) {
                            message += 'Selected Services: ' + selectedServices.join(', ') + '\n';
                        }
                        
                        if ($('#has_insurance').is(':checked')) {
                            message += 'Insurance: ' + $('#organisation_id option:selected').text() + '\n';
                            message += 'Copay Amount: KES ' + $('#hidden_copay_amount').val();
                        }
                        
                        alert(message);
                        
                        // Auto-add to queue
                        addPatientToQueue(response.patient_id, queueDepartment, queuePriority, 'general');
                        
                        // Reset form
                        resetForm();
                        
                    } else {
                        let errorMsg = 'Registration failed:\n';
                        if (response.error) {
                            for (let field in response.error) {
                                if (response.error[field]) {
                                    errorMsg += '- ' + response.error[field] + '\n';
                                }
                            }
                        }
                        alert(errorMsg);
                    }
                } catch (e) {
                    console.error('Error parsing response:', e);
                    alert('An unexpected error occurred during registration.');
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', error);
                alert('An error occurred during registration. Please try again.');
            },
            complete: function() {
                submitBtn.html(originalText).prop('disabled', false);
            }
        });
    });
    
    function validateForm() {
        const name = $('input[name="name"]').val().trim();
        const dob = $('#date_of_birth').val();
        
        if (!name) {
            alert('Patient name is required');
            $('input[name="name"]').focus();
            return false;
        }
        
        if (!dob) {
            alert('Date of birth is required');
            $('#date_of_birth').focus();
            return false;
        }
        
        // Validate coverage-specific fields based on selected coverage type
        const coverageType = $('input[name="coverage_type"]:checked').val();
        
        if (coverageType === 'insurance') {
            const organisationId = $('#organisation_id').val();
            const insuranceId = $('#insurance_id').val().trim();
            const validity = $('#insurance_validity').val();
            
            if (!organisationId) {
                alert('Please select an insurance company');
                $('#organisation_id').focus();
                return false;
            }
            
            if (!insuranceId) {
                alert('Member number is required');
                $('#insurance_id').focus();
                return false;
            }
            
            // Validity date is now optional - only validate if provided
            if (validity) {
                // Check if validity date is in the future (only if provided)
                const validityDate = new Date(validity);
                const today = new Date();
                
                if (validityDate <= today) {
                    alert('Insurance validity date must be in the future (or leave blank if not applicable)');
                    $('#insurance_validity').focus();
                    return false;
                }
            }
        } else if (coverageType === 'community_card') {
            const cardNumber = $('#community_card_number').val().trim();
            const cardStatus = $('#community_card_status').val();
            
            if (!cardNumber) {
                alert('Community card number is required');
                $('#community_card_number').focus();
                return false;
            }
            
            if (!/^CHC-\d{4}-\d{4}-\d{4}$/.test(cardNumber)) {
                alert('Invalid card number format. Use: CHC-XXXX-XXXX-XXXX');
                $('#community_card_number').focus();
                return false;
            }
            
            if (!cardStatus || cardStatus === 'Expired') {
                alert('Please verify your community card or renew if expired');
                $('#verify-community-card').focus();
                return false;
            }
        }
        
        return true;
    }
    
    function addPatientToQueue(patientId, department, priority, workflowType) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/queue/add_to_queue',
            type: 'POST',
            data: {
                patient_id: patientId,
                department: department,
                priority: priority,
                workflow_type: workflowType
            },
            success: function(response) {
                if (response.status === 'success') {
                    console.log('Patient added to queue:', response.queue_number);
                    
                    // Show queue ticket option
                    if (confirm('Patient added to ' + department + ' queue successfully!\nQueue Number: ' + response.queue_number + '\n\nWould you like to print the queue ticket?')) {
                        window.open('<?php echo base_url(); ?>admin/queue/print_queue_ticket?patient_id=' + patientId, '_blank');
                    }
                } else {
                    console.error('Failed to add patient to queue:', response.message);
                }
            },
            error: function(xhr, status, error) {
                console.error('Queue addition error:', error);
            }
        });
    }
    
    function resetForm() {
        $('#generalForm')[0].reset();
        $('#age_display').hide();
        $('#insurance-details').hide();
        $('#copay-calculation').hide();
        $('#payment-section').hide();
        $('#queue-info').hide();
        $('.payment-method').removeClass('selected');
        $('#verification-status').hide();
        resetPaymentCalculation();
    }

    // Initialize tooltips and other UI enhancements
    $('[data-toggle="tooltip"]').tooltip();
    
    // Auto-show queue info when services are selected
    $('input[name="services[]"]').on('change', function() {
        if ($('input[name="services[]"]:checked').length > 0) {
            $('#queue-info').show();
        } else if (!$('#has_insurance').is(':checked')) {
            $('#queue-info').hide();
        }
    });
    
    // Real-time validation feedback
    $('input[name="name"]').on('blur', function() {
        if ($(this).val().trim().length < 2) {
            $(this).addClass('form-control-danger');
        } else {
            $(this).removeClass('form-control-danger');
        }
    });
    
    $('#insurance_id').on('blur', function() {
        if ($('#has_insurance').is(':checked') && $(this).val().trim().length < 3) {
            $(this).addClass('form-control-danger');
        } else {
            $(this).removeClass('form-control-danger');
        }
    });
});
</script>

</body>
</html>