<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>GCC Patient Registration - Enhanced Fingerprint System</title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/font-awesome.min.css">
    <!-- AdminLTE Theme -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/skins/_all-skins.min.css">
    
    <style>
        .content-wrapper { background-color: #ecf0f5; }
        
        .gcc-header {
            background: linear-gradient(135deg, #00a65a 0%, #00c0ef 100%);
            color: white; padding: 20px; border-radius: 3px; margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .workflow-step {
            padding: 15px; border-bottom: 1px solid #f4f4f4; display: flex;
            align-items: center; transition: background-color 0.3s ease;
        }
        
        .workflow-step:hover { background-color: #f9f9f9; }
        .workflow-step:last-child { border-bottom: none; }
        
        .step-number {
            background: #00a65a; color: white; width: 30px; height: 30px;
            border-radius: 50%; display: flex; align-items: center;
            justify-content: center; margin-right: 15px; font-weight: bold;
            font-size: 14px; box-shadow: 0 2px 4px rgba(0,166,90,0.3);
        }
        
        .step-content h6 {
            margin: 0 0 5px 0; color: #333; font-weight: 600; font-size: 16px;
        }
        
        .step-content small { color: #777; font-size: 13px; }
        
        .biometric-section {
            background: linear-gradient(145deg, #f9f9f9, #ffffff);
            border: 2px solid #00a65a; border-radius: 8px; padding: 25px;
            margin: 25px 0; box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        
        .fingerprint-container, .photo-container {
            border: 2px dashed #ddd; border-radius: 8px; padding: 20px;
            background: white; text-align: center; margin-bottom: 15px;
            min-height: 200px; display: flex; align-items: center;
            justify-content: center; flex-direction: column;
            transition: border-color 0.3s ease;
        }
        
        .fingerprint-container:hover, .photo-container:hover {
            border-color: #00a65a;
        }
        
        .required { color: #dd4b39; font-weight: bold; }
        
        .btn-gcc {
            background: linear-gradient(135deg, #00a65a, #008d4c);
            border: none; color: white; font-weight: 600; padding: 12px 24px;
            border-radius: 6px; transition: all 0.3s ease;
            box-shadow: 0 2px 4px rgba(0,166,90,0.3);
        }
        
        .btn-gcc:hover {
            background: linear-gradient(135deg, #008d4c, #00704a);
            color: white; transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(0,166,90,0.4);
        }
        
        .cost-display {
            background: rgba(255,255,255,0.2);
            border: 1px solid rgba(255,255,255,0.3);
            color: white; padding: 12px 20px; border-radius: 20px;
            font-weight: bold; text-align: center; font-size: 16px;
            backdrop-filter: blur(10px);
        }
        
        #camera_container {
            border: 1px solid #ddd; border-radius: 8px; padding: 15px;
            background: linear-gradient(145deg, #f9f9f9, #ffffff);
            margin-top: 15px; display: none;
            box-shadow: inset 0 2px 4px rgba(0,0,0,0.1);
        }
        
        #camera_stream {
            width: 100%; max-width: 320px; height: auto;
            border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.2);
        }
        
        .fingerprint-image {
            max-width: 150px; max-height: 180px; border: 2px solid #ddd;
            border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .photo-preview img {
            max-width: 200px; max-height: 150px; border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.2);
        }
        
        .btn-group-vertical .btn {
            margin-bottom: 8px; border-radius: 6px; font-weight: 500;
        }
        
        .form-control {
            border-radius: 6px; border: 1px solid #ddd;
            transition: border-color 0.3s ease, box-shadow 0.3s ease;
        }
        
        .form-control:focus {
            border-color: #00a65a;
            box-shadow: 0 0 0 0.2rem rgba(0,166,90,0.25);
        }
        
        .alert { border-radius: 6px; border: none; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        .box { border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
        .box-header { border-bottom: 1px solid #f4f4f4; border-radius: 8px 8px 0 0; }
        
        .progress-indicator {
            background: rgba(255,255,255,0.1);
            border-radius: 10px; padding: 8px 16px; margin-top: 10px;
        }
        
        .biometric-status {
            padding: 10px; border-radius: 6px; margin-top: 10px; font-size: 13px;
        }
        
        .status-success {
            background: #d4edda; color: #155724; border: 1px solid #c3e6cb;
        }
        
        .status-warning {
            background: #fff3cd; color: #856404; border: 1px solid #ffeaa7;
        }
        
        .status-error {
            background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;
        }
        
        .secugen-diagnostics {
            background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 8px;
            padding: 15px; margin-top: 15px; font-family: 'Courier New', monospace;
            max-height: 200px; overflow-y: auto;
        }
        
        .diagnostic-entry {
            margin: 2px 0; font-size: 12px;
        }
        
        .diagnostic-success { color: #28a745; }
        .diagnostic-warning { color: #ffc107; }
        .diagnostic-error { color: #dc3545; }
        .diagnostic-info { color: #17a2b8; }
        
        .template-info {
            background: #e9ecef; border-radius: 6px; padding: 10px;
            margin: 10px 0; font-family: monospace; font-size: 11px;
        }
    </style>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                <i class="fa fa-globe"></i> GCC Patient Registration
                <small>Gulf Cooperation Council Medical Examination Process</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                <li><a href="#">Patient</a></li>
                <li class="active">GCC Registration</li>
            </ol>
        </section>

        <section class="content">
            <!-- GCC Header -->
            <div class="gcc-header">
                <div class="row">
                    <div class="col-md-8">
                        <h3><i class="fa fa-globe"></i> GCC Patient Registration</h3>
                        <p class="margin-bottom-none">Comprehensive medical examination with biometric capture for Gulf Cooperation Council requirements</p>
                        <div class="progress-indicator">
                            <div class="progress">
                                <div class="progress-bar bg-success" role="progressbar" style="width: 16.67%;" aria-valuenow="16.67" aria-valuemin="0" aria-valuemax="100">
                                    Step 1 of 6: Registration & Biometrics
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 text-right">
                        <div class="cost-display">
                            <i class="fa fa-money"></i> Registration Fee: KES 10,500
                        </div>
                    </div>
                </div>
            </div>

            <!-- Workflow Steps -->
            <div class="box box-success">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-route"></i> GCC Medical Examination Workflow</h3>
                    <div class="box-tools pull-right">
                        <span class="label label-success">Mandatory Process</span>
                    </div>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="workflow-step">
                                <div class="step-number">1</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-user-plus"></i> Registration & Biometrics</h6>
                                    <small>Patient details with mandatory fingerprint and photo capture</small>
                                </div>
                            </div>
                            <div class="workflow-step">
                                <div class="step-number">2</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-stethoscope"></i> Mandatory Triage Assessment</h6>
                                    <small>Required health screening and vital signs assessment</small>
                                </div>
                            </div>
                            <div class="workflow-step">
                                <div class="step-number">3</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-flask"></i> Laboratory Tests</h6>
                                    <small>Comprehensive health tests as per GCC requirements</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="workflow-step">
                                <div class="step-number">4</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-camera"></i> Radiology Services</h6>
                                    <small>Medical imaging services (X-ray, etc.)</small>
                                </div>
                            </div>
                            <div class="workflow-step">
                                <div class="step-number">5</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-user-md"></i> Medical Consultation</h6>
                                    <small>Doctor review and fitness assessment (No ICD-10 diagnosis)</small>
                                </div>
                            </div>
                            <div class="workflow-step">
                                <div class="step-number">6</div>
                                <div class="step-content">
                                    <h6><i class="fa fa-check-circle"></i> Certificate Issuance</h6>
                                    <small>Final processing and medical fitness certificate</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Registration Form -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-edit"></i> Patient Information & Biometric Data</h3>
                    <div class="box-tools pull-right">
                        <span class="label label-primary">Required Fields</span>
                    </div>
                </div>
                
                <form id="gccRegistrationForm" action="<?php echo base_url(); ?>admin/patient/addpatient" method="post" enctype="multipart/form-data">
                    <!-- EXPLICITLY ENFORCE GCC WORKFLOW - NO ALTERNATIVES -->
                    <input type="hidden" name="patient_workflow" value="gcc">
                    <input type="hidden" name="workflow_type" value="gcc">
                    <input type="hidden" name="patient_type" value="GCC">
                    <input type="hidden" name="patient_type_id" value="">
                    <input type="hidden" name="is_ipd" value="no">
                    <input type="hidden" name="app_key" value="">
                    <input type="hidden" name="is_antenatal" value="0">
                    <input type="hidden" name="is_active" value="yes">
                    
                    <!-- GCC WORKFLOW SPECIFIC FIELDS -->
                    <input type="hidden" name="requires_triage" value="1">
                    <input type="hidden" name="skip_ic10_diagnosis" value="1">
                    <input type="hidden" name="gcc_comprehensive_fee" value="10500.00">
                    <input type="hidden" name="workflow_status" value="registration_complete">
                    <input type="hidden" name="payment_status" value="pending">
                    <input type="hidden" name="current_workflow_step" value="registration">
                    
                    <!-- Ensure no FK constraint violations -->
                    <input type="hidden" name="blood_bank_product_id" value="">
                    <input type="hidden" name="organisation_id" value="">
                    
                    <!-- Enhanced Fingerprint Data Fields -->
                    <input type="hidden" name="fingerprint_template" id="fingerprint_template" value="">
                    <input type="hidden" name="fingerprint_image" id="fingerprint_image" value="">
                    <input type="hidden" name="fingerprint_verified" id="fingerprint_verified" value="0">
                    <input type="hidden" name="fingerprint_updated_at" id="fingerprint_updated_at" value="">
                    
                    <!-- Store GCC workflow data in note field for compatibility -->
                    <input type="hidden" name="note" id="workflow_note" value="">
                    <input type="hidden" name="known_allergies" value="None">
                    
                    <!-- Custom fields for GCC workflow identification -->
                    <input type="hidden" name="custom_fields[patient][gcc_workflow]" value="gcc">
                    <input type="hidden" name="custom_fields[patient][requires_triage]" value="1">
                    <input type="hidden" name="custom_fields[patient][gcc_fee]" value="10500.00">
                    <input type="hidden" name="custom_fields[patient][excludes_icd10]" value="1">
                    
                    <div class="box-body">
                        <!-- Basic Information Section -->
                        <div class="row">
                            <div class="col-md-12">
                                <h4><i class="fa fa-user"></i> Personal Information</h4>
                                <hr style="margin: 10px 0 20px 0;">
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <!-- Patient Name -->
                                <div class="form-group">
                                    <label for="patient_name">Full Name <span class="required">*</span></label>
                                    <input type="text" name="name" id="patient_name" class="form-control" placeholder="Enter patient's full name" required aria-label="Patient Full Name">
                                    <small class="text-muted">As per official identification document</small>
                                </div>
                                
                                <!-- Age -->
                                <div class="form-group">
                                    <label>Age <span class="required">*</span></label>
                                    <div class="row">
                                        <div class="col-xs-4">
                                            <input type="number" name="age[year]" class="form-control" placeholder="Years" min="0" max="120" value="25" required aria-label="Age Years">
                                            <small class="text-muted">Years</small>
                                        </div>
                                        <div class="col-xs-4">
                                            <input type="number" name="age[month]" class="form-control" placeholder="Months" min="0" max="11" value="0" required aria-label="Age Months">
                                            <small class="text-muted">Months</small>
                                        </div>
                                        <div class="col-xs-4">
                                            <input type="number" name="age[day]" class="form-control" placeholder="Days" min="0" max="30" value="0" required aria-label="Age Days">
                                            <small class="text-muted">Days</small>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Date of Birth -->
                                <div class="form-group">
                                    <label for="patient_dob">Date of Birth</label>
                                    <input type="date" name="dob" id="patient_dob" class="form-control" aria-label="Date of Birth">
                                    <small class="text-muted">Optional if age is provided</small>
                                </div>
                                
                                <!-- Gender -->
                                <div class="form-group">
                                    <label for="patient_gender">Gender <span class="required">*</span></label>
                                    <select name="gender" id="patient_gender" class="form-control" required aria-label="Gender">
                                        <option value="">Select Gender</option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                    </select>
                                </div>
                                
                                <!-- Marital Status -->
                                <div class="form-group">
                                    <label for="patient_marital_status">Marital Status <span class="required">*</span></label>
                                    <select name="marital_status" id="patient_marital_status" class="form-control" required aria-label="Marital Status">
                                        <option value="">Select Marital Status</option>
                                        <option value="Single" selected>Single</option>
                                        <option value="Married">Married</option>
                                        <option value="Divorced">Divorced</option>
                                        <option value="Widowed">Widowed</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                                
                                <!-- Blood Group -->
                                <div class="form-group">
                                    <label for="patient_blood_group">Blood Group</label>
                                    <select name="blood_group" id="patient_blood_group" class="form-control" aria-label="Blood Group">
                                        <option value="">Select Blood Group</option>
                                        <!-- Leave empty to avoid foreign key constraint -->
                                        <!-- Blood group will be handled separately if needed -->
                                    </select>
                                    <small class="text-muted">Optional - can be updated later during medical examination</small>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <!-- Mobile Number -->
                                <div class="form-group">
                                    <label for="patient_mobile">Mobile Number <span class="required">*</span></label>
                                    <input type="tel" name="mobileno" id="patient_mobile" class="form-control" placeholder="+254 700 000 000" required aria-label="Mobile Number">
                                    <small class="text-muted">Include country code</small>
                                </div>
                                
                                <!-- Identification Number -->
                                <div class="form-group">
                                    <label for="patient_id">Identification Number <span class="required">*</span></label>
                                    <input type="text" name="identification_number" id="patient_id" class="form-control" placeholder="National ID / Passport Number" required aria-label="Identification Number">
                                    <small class="text-muted">National ID or Passport Number</small>
                                </div>
                                
                                <!-- Email Address -->
                                <div class="form-group">
                                    <label for="patient_email">Email Address</label>
                                    <input type="email" name="email" id="patient_email" class="form-control" placeholder="patient@example.com" aria-label="Email Address">
                                    <small class="text-muted">For appointment notifications</small>
                                </div>
                                
                                <!-- Address -->
                                <div class="form-group">
                                    <label for="patient_address">Address</label>
                                    <textarea name="address" id="patient_address" class="form-control" rows="2" placeholder="Patient's residential address" aria-label="Address"></textarea>
                                </div>
                                
                                <!-- Guardian Name -->
                                <div class="form-group">
                                    <label for="patient_guardian">Guardian/Next of Kin</label>
                                    <input type="text" name="guardian_name" id="patient_guardian" class="form-control" placeholder="Guardian or next of kin name" aria-label="Guardian Name">
                                    <small class="text-muted">Emergency contact person</small>
                                </div>
                                
                                <!-- Known Allergies -->
                                <div class="form-group">
                                    <label for="known_allergies">Known Allergies <span class="required">*</span></label>
                                    <textarea name="known_allergies" id="known_allergies" class="form-control" rows="2" placeholder="List any known allergies or medications to avoid" required aria-label="Known Allergies">None</textarea>
                                    <small class="text-muted">Important for medical safety</small>
                                </div>
                                
                                <!-- Note -->
                                <div class="form-group">
                                    <label for="note">Additional Notes</label>
                                    <textarea name="note" id="note" class="form-control" rows="2" placeholder="Any additional notes or comments" aria-label="Additional Notes"></textarea>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- TPA Information - Optional fields to avoid foreign key issues -->
                        <div class="row">
                            <div class="col-md-12">
                                <h4><i class="fa fa-medical-kit"></i> TPA/Insurance Information (Optional)</h4>
                                <hr style="margin: 10px 0 20px 0;">
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <!-- TPA Information - Leave empty to avoid FK constraint -->
                                <div class="form-group">
                                    <label for="insurance_id">Insurance/TPA ID</label>
                                    <input type="text" name="insurance_id" id="insurance_id" class="form-control" placeholder="Insurance ID Number" aria-label="Insurance ID">
                                    <small class="text-muted">Optional - leave blank if no insurance</small>
                                </div>
                                
                                <div class="form-group">
                                    <label for="validity">TPA Validity Date</label>
                                    <input type="date" name="validity" id="validity" class="form-control" aria-label="TPA Validity Date">
                                    <small class="text-muted">Optional - only if TPA applies</small>
                                </div>
                                
                                <!-- Hidden field to avoid organisation_id foreign key constraint -->
                                <input type="hidden" name="organisation_id" value="">
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="preferred_date">Preferred Appointment Date</label>
                                    <input type="date" name="preferred_date" id="preferred_date" class="form-control" min="<?php echo date('Y-m-d'); ?>" aria-label="Preferred Appointment Date">
                                    <small class="text-muted">Sundays are not available for appointments</small>
                                </div>
                                
                                <div class="form-group">
                                    <label for="destination_country">Destination Country</label>
                                    <select name="destination_country" id="destination_country" class="form-control" aria-label="Destination Country">
                                        <option value="">Select GCC Country</option>
                                        <option value="UAE">United Arab Emirates</option>
                                        <option value="Saudi Arabia">Saudi Arabia</option>
                                        <option value="Qatar">Qatar</option>
                                        <option value="Kuwait">Kuwait</option>
                                        <option value="Bahrain">Bahrain</option>
                                        <option value="Oman">Oman</option>
                                    </select>
                                </div>
                                
                                <div class="form-group">
                                    <label for="gcc_purpose">Purpose of Examination</label>
                                    <select name="gcc_purpose" id="gcc_purpose" class="form-control" aria-label="Purpose of Examination">
                                        <option value="">Select Purpose</option>
                                        <option value="employment">Employment Visa</option>
                                        <option value="residence">Residence Permit</option>
                                        <option value="renewal">Permit Renewal</option>
                                        <option value="family_visa">Family Visa</option>
                                        <option value="other">Other</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- Enhanced Biometric Requirements Section -->
                        <div class="biometric-section">
                            <div class="row">
                                <div class="col-md-12">
                                    <h4><i class="fa fa-fingerprint"></i> Biometric Data Capture (Mandatory for GCC)</h4>
                                    <p class="text-info"><i class="fa fa-info-circle"></i> GCC regulations require both fingerprint and photograph capture for all medical examinations.</p>
                                    
                                    <!-- SecuGen System Status -->
                                    <div class="alert alert-info">
                                        <h5><i class="fa fa-cogs"></i> SecuGen WebAPI System Status</h5>
                                        <div id="secugen_system_status">
                                            <div class="text-center">
                                                <i class="fa fa-spinner fa-spin"></i> Initializing SecuGen WebAPI connection...
                                            </div>
                                        </div>
                                        <div class="secugen-diagnostics" id="secugen_diagnostics" style="display: none;">
                                            <h6><i class="fa fa-wrench"></i> System Diagnostics</h6>
                                            <div id="diagnostic_log"></div>
                                        </div>
                                    </div>
                                    
                                    <hr style="margin: 15px 0 25px 0;">
                                </div>
                            </div>
                            
                            <div class="row">
                                <!-- Enhanced Fingerprint Capture Section -->
                                <div class="col-md-6">
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h5 class="panel-title">
                                                <i class="fa fa-fingerprint"></i> Enhanced Fingerprint Capture <span class="required">*</span>
                                                <span class="label label-info pull-right" id="secugen_status_label">Checking...</span>
                                            </h5>
                                        </div>
                                        <div class="panel-body">
                                            <div class="fingerprint-container">
                                                <img id="patient_fingerprint_display"
                                                     src="<?php echo base_url(); ?>Images/PlaceFinger.bmp"
                                                     alt="Patient Fingerprint"
                                                     class="fingerprint-image">
                                                <div id="fingerprint_status" class="biometric-status">
                                                    <small class="text-muted"><i class="fa fa-hand-o-up"></i> No fingerprint captured</small>
                                                </div>
                                                
                                                <!-- Template Information Display -->
                                                <div id="template_info" class="template-info" style="display: none;">
                                                    <strong>Template Information:</strong><br>
                                                    <span id="template_details">No template data</span>
                                                </div>
                                            </div>
                                            
                                            <div class="btn-group-vertical btn-block">
                                                <button type="button" id="captureFingerprint" class="btn btn-primary btn-lg" disabled aria-label="Capture Fingerprint">
                                                    <i class="fa fa-fingerprint"></i> SGIFPCapture - Scan Fingerprint
                                                </button>
                                                <button type="button" id="verifyFingerprintQuality" class="btn btn-success" disabled aria-label="Verify Fingerprint Quality">
                                                    <i class="fa fa-check-circle"></i> Verify Template Quality
                                                </button>
                                                <button type="button" id="testFingerprint" class="btn btn-info" disabled aria-label="Test Fingerprint">
                                                    <i class="fa fa-flask"></i> Test Template (SGIMatchScore)
                                                </button>
                                                <button type="button" id="clearFingerprint" class="btn btn-warning" style="display: none;" aria-label="Clear Fingerprint">
                                                    <i class="fa fa-refresh"></i> Clear & Recapture
                                                </button>
                                            </div>
                                            
                                            <!-- Advanced Controls -->
                                            <div class="btn-group btn-group-justified" style="margin-top: 10px;">
                                                <div class="btn-group">
                                                    <button type="button" id="showDiagnostics" class="btn btn-default btn-sm">
                                                        <i class="fa fa-cogs"></i> Diagnostics
                                                    </button>
                                                </div>
                                                <div class="btn-group">
                                                    <button type="button" id="reInitializeSecuGen" class="btn btn-default btn-sm">
                                                        <i class="fa fa-refresh"></i> Reconnect
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Photo Capture Section -->
                                <div class="col-md-6">
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h5 class="panel-title"><i class="fa fa-camera"></i> Photograph Capture <span class="required">*</span></h5>
                                        </div>
                                        <div class="panel-body">
                                            <div class="photo-container" id="photo_preview">
                                                <div class="text-center text-muted">
                                                    <i class="fa fa-camera fa-3x" style="color: #ddd;"></i>
                                                    <br><small>No photograph captured</small>
                                                </div>
                                            </div>
                                            
                                            <div id="camera_container">
                                                <video id="camera_stream" autoplay></video>
                                                <div class="btn-group btn-group-justified" style="margin-top: 10px;">
                                                    <div class="btn-group">
                                                        <button type="button" id="takePictureBtn" class="btn btn-success" aria-label="Take Photo">
                                                            <i class="fa fa-camera"></i> Take Photo
                                                        </button>
                                                    </div>
                                                    <div class="btn-group">
                                                        <button type="button" id="stopCameraBtn" class="btn btn-default" aria-label="Stop Camera">
                                                            <i class="fa fa-stop"></i> Stop Camera
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="btn-group-vertical btn-block">
                                                <button type="button" id="startCameraBtn" class="btn btn-primary btn-lg" aria-label="Start Camera">
                                                    <i class="fa fa-video-camera"></i> Start Camera
                                                </button>
                                                <button type="button" id="uploadPhotoBtn" class="btn btn-info" aria-label="Upload Photo">
                                                    <i class="fa fa-upload"></i> Upload Photo
                                                </button>
                                            </div>
                                            
                                            <input type="file" name="file" id="photoFileInput" class="hidden" accept="image/*">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="box-footer">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="alert alert-success">
                                    <h5><i class="fa fa-check-circle"></i> Registration Configuration</h5>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p><strong>Endpoint:</strong> /admin/patient/addpatient</p>
                                            <p><strong>Workflow:</strong> GCC Medical Examination</p>
                                            <p><strong>Registration Fee:</strong> KES 10,500</p>
                                        </div>
                                        <div class="col-md-6">
                                            <p><strong>Mandatory Triage:</strong> Yes</p>
                                            <p><strong>ICD-10 Diagnosis:</strong> Excluded</p>
                                            <p><strong>SecuGen Integration:</strong> <span id="integration_status">Checking...</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <a href="<?php echo base_url(); ?>admin/patient" class="btn btn-default btn-lg">
                                    <i class="fa fa-arrow-left"></i> Back to Patient Dashboard
                                </a>
                            </div>
                            <div class="col-md-6 text-right">
                                <button type="submit" class="btn btn-gcc btn-lg btn-block" aria-label="Register Patient">
                                    <i class="fa fa-save"></i> Register GCC Patient & Start Workflow
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Quick Navigation -->
            <div class="box box-default">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-link"></i> Other Registration Options</h3>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-3">
                            <a href="<?php echo base_url(); ?>admin/patient/general_registration" class="btn btn-info btn-block btn-lg">
                                <i class="fa fa-users"></i><br>General Process<br>
                                <small>KES 900</small>
                            </a>
                        </div>
                        <div class="col-md-3">
                            <a href="<?php echo base_url(); ?>admin/patient/specialized_registration" class="btn btn-danger btn-block btn-lg">
                                <i class="fa fa-user-md"></i><br>Specialized Process<br>
                                <small>KES 1,500</small>
                            </a>
                        </div>
                        <div class="col-md-3">
                            <a href="<?php echo base_url(); ?>admin/patient/search" class="btn btn-default btn-block btn-lg">
                                <i class="fa fa-list"></i><br>Patient Dashboard<br>
                                <small>View All Patients</small>
                            </a>
                        </div>
                        <div class="col-md-3">
                            <a href="<?php echo base_url(); ?>admin/triage" class="btn btn-warning btn-block btn-lg">
                                <i class="fa fa-stethoscope"></i><br>Triage Queue<br>
                                <small>Next Step</small>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>

<!-- jQuery -->
<script src="<?php echo base_url(); ?>backend/plugins/jQuery/jquery.min.js"></script>
<!-- Bootstrap -->
<script src="<?php echo base_url(); ?>backend/bootstrap/js/bootstrap.min.js"></script>
<!-- AdminLTE App -->
<script src="<?php echo base_url(); ?>backend/dist/js/adminlte.min.js"></script>

<script>
$(document).ready(function() {
    // =============================================
    // ENHANCED SECUGEN FINGERPRINT CAPTURE - FIXED VERSION
    // =============================================
    
    // Global SecuGen State
    window.secugenState = {
        serviceActive: false,
        deviceConnected: false,
        currentTemplate: null,
        currentImage: null,
        captureInProgress: false,
        endpoints: {
            https: {
                capture: 'https://localhost:8443/SGIFPCapture',
                match: 'https://localhost:8443/SGIMatchScore', 
                info: 'https://localhost:8443/SGIFPGetInfo'
            },
            http: {
                capture: 'http://localhost:8000/SGIFPCapture',
                match: 'http://localhost:8000/SGIMatchScore',
                info: 'http://localhost:8000/SGIFPGetInfo'
            }
        },
        currentProtocol: 'https',
        quality: 0,
        verified: false
    };

    // Camera state with photo storage
    window.cameraState = {
        stream: null,
        active: false
    };

    // Global photo storage for camera captures
    window.capturedPhotoFile = null;
    window.capturedPhotoData = null;

    // =============================================
    // UTILITY FUNCTIONS
    // =============================================
    
    function logDiagnostic(message, type = 'info') {
        const timestamp = new Date().toLocaleTimeString();
        const iconMap = {
            'success': 'fa-check-circle',
            'warning': 'fa-exclamation-triangle',
            'error': 'fa-times-circle',
            'info': 'fa-info-circle'
        };
        
        const classMap = {
            'success': 'diagnostic-success',
            'warning': 'diagnostic-warning', 
            'error': 'diagnostic-error',
            'info': 'diagnostic-info'
        };
        
        const logEntry = `
            <div class="diagnostic-entry ${classMap[type]}">
                <i class="fa ${iconMap[type]}"></i> [${timestamp}] ${message}
            </div>
        `;
        
        $('#diagnostic_log').append(logEntry);
        $('#diagnostic_log').scrollTop($('#diagnostic_log')[0].scrollHeight);
        
        console.log(`[SecuGen-${type.toUpperCase()}] ${timestamp}: ${message}`);
    }

    function updateSystemStatus(type, title, message = '') {
        const alertClass = type === 'success' ? 'alert-success' : 
                          type === 'warning' ? 'alert-warning' : 
                          type === 'error' ? 'alert-danger' : 'alert-info';
        
        const iconClass = type === 'success' ? 'fa-check-circle' : 
                         type === 'warning' ? 'fa-exclamation-triangle' : 
                         type === 'error' ? 'fa-times-circle' : 'fa-info-circle';
        
        const statusHtml = `
            <div class="alert ${alertClass}">
                <i class="fa ${iconClass}"></i> <strong>${title}</strong>
                ${message ? '<br><small>' + message + '</small>' : ''}
            </div>
        `;
        
        $('#secugen_system_status').html(statusHtml);
    }

    function updateStatusLabel(text, type = 'default') {
        const labelClass = `label label-${type} pull-right`;
        $('#secugen_status_label').attr('class', labelClass).text(text);
    }

    function updateTemplateInfo(template, image, quality) {
        if (template) {
            const templateSize = template.length;
            const qualityStatus = quality >= 60 ? 'Good' : quality >= 40 ? 'Fair' : 'Poor';
            
            const info = `Size: ${templateSize} chars | Quality: ${quality}% (${qualityStatus}) | Type: SecuGen ISO Template`;
            $('#template_details').text(info);
            $('#template_info').show();
        } else {
            $('#template_info').hide();
        }
    }

    // =============================================
    // SECUGEN SERVICE INITIALIZATION
    // =============================================
    
    function initializeSecuGenService() {
        logDiagnostic('Initializing SecuGen WebAPI service...', 'info');
        updateSystemStatus('info', 'Initializing SecuGen WebAPI...', 'Testing HTTPS connection first');
        updateStatusLabel('Connecting...', 'warning');
        $('#integration_status').html('<span class="text-warning">Connecting...</span>');
        
        // Test HTTPS connection first (secure connection preferred)
        testSecuGenConnection(true);
    }
    
    function testSecuGenConnection(useHttps = true) {
        const protocol = useHttps ? 'HTTPS' : 'HTTP';
        const endpoint = useHttps ? window.secugenState.endpoints.https.info : 
                                   window.secugenState.endpoints.http.info;
        
        logDiagnostic(`Testing ${protocol} connection: ${endpoint}`, 'info');
        
        $.ajax({
            url: endpoint,
            type: 'GET',
            timeout: 5000,
            cache: false,
            success: function(data, textStatus, xhr) {
                logDiagnostic(`${protocol} connection successful - Status: ${xhr.status}`, 'success');
                handleConnectionSuccess(useHttps, data);
            },
            error: function(xhr, status, error) {
                logDiagnostic(`${protocol} connection failed - ${status}: ${error}`, 'error');
                handleConnectionError(useHttps, xhr, status, error);
            }
        });
    }

    function handleConnectionSuccess(useHttps, data) {
        const protocol = useHttps ? 'HTTPS' : 'HTTP';
        window.secugenState.serviceActive = true;
        window.secugenState.currentProtocol = useHttps ? 'https' : 'http';
        
        updateSystemStatus('success', 'SecuGen WebAPI Connected', 
            `Active via ${protocol} - Fingerprint device ready for capture`);
        updateStatusLabel('Connected', 'success');
        $('#integration_status').html('<span class="text-success">Active</span>');
        
        // Parse device info if available
        if (data && typeof data === 'object') {
            logDiagnostic(`Device Info: ${JSON.stringify(data)}`, 'info');
        }
        
        enableFingerprintCapture();
    }

    function handleConnectionError(useHttps, xhr, status, error) {
        if (useHttps) {
            // HTTPS failed, try HTTP
            updateSystemStatus('warning', 'HTTPS Failed - Trying HTTP...', 
                'SSL certificate may need manual acceptance at https://localhost:8443');
            
            setTimeout(() => {
                testSecuGenConnection(false);
            }, 1500);
        } else {
            // Both HTTPS and HTTP failed
            window.secugenState.serviceActive = false;
            
            updateSystemStatus('error', 'SecuGen WebAPI Not Available', 
                'Device not connected or WebAPI service not running');
            updateStatusLabel('Not Available', 'danger');
            $('#integration_status').html('<span class="text-danger">Not Available</span>');
            
            enableManualMode();
        }
    }

    function enableFingerprintCapture() {
        $('#captureFingerprint').prop('disabled', false)
            .removeClass('btn-default').addClass('btn-primary')
            .html('<i class="fa fa-fingerprint"></i> SGIFPCapture - Scan Fingerprint');
        
        logDiagnostic('Fingerprint capture enabled - SecuGen device ready', 'success');
    }

    function enableManualMode() {
        $('#captureFingerprint').prop('disabled', false)
            .removeClass('btn-primary').addClass('btn-warning')
            .html('<i class="fa fa-hand-pointer-o"></i> Manual Mode (No Device)');
        
        logDiagnostic('Manual fingerprint mode enabled - No SecuGen device detected', 'warning');
    }

    // =============================================
    // SECUGEN FINGERPRINT CAPTURE
    // =============================================
    
    function captureFingerprint() {
        logDiagnostic("Starting SGIFPCapture for GCC registration", 'info');
        
        const captureUrl = window.secugenState.serviceActive ? 
            window.secugenState.endpoints[window.secugenState.currentProtocol].capture :
            'https://localhost:8443/SGIFPCapture';
        
        $('#fingerprint_status').html(`
            <div class="status-warning">
                <i class="fa fa-spinner fa-spin"></i> Place finger on scanner and hold steady...
            </div>
        `);
        
        const $captureBtn = $('#captureFingerprint');
        $captureBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Scanning...');
        
        if (!window.secugenState.serviceActive) {
            // Manual capture mode
            executeManualCapture();
            $captureBtn.prop('disabled', false).html('<i class="fa fa-fingerprint"></i> SGIFPCapture - Scan Fingerprint');
            return;
        }

        // Use jQuery AJAX for device capture
        $.ajax({
            url: captureUrl,
            type: 'POST',
            data: {
                Quality: 50,
                Timeout: 20000,
                WSQCompression: 2.25
            },
            timeout: 25000,
            success: function(response) {
                $captureBtn.prop('disabled', false).html('<i class="fa fa-fingerprint"></i> SGIFPCapture - Scan Fingerprint');
                
                try {
                    const result = typeof response === 'string' ? JSON.parse(response) : response;
                    handleFingerprintResult(result);
                } catch (e) {
                    logDiagnostic("✗ Invalid response format", 'error');
                    $('#fingerprint_status').html('<div class="status-error">Invalid response from scanner</div>');
                }
            },
            error: function(xhr, status, error) {
                $captureBtn.prop('disabled', false).html('<i class="fa fa-fingerprint"></i> SGIFPCapture - Scan Fingerprint');
                
                let errorMsg = 'SGIFPCapture failed';
                if (status === 'timeout') {
                    errorMsg = 'Scanner timeout - no finger detected';
                } else if (xhr.status === 0) {
                    errorMsg = 'Cannot connect to SecuGen service. Please check installation.';
                } else {
                    errorMsg = `HTTP ${xhr.status}: ${error}`;
                }
                
                $('#fingerprint_status').html(`<div class="status-error"><i class="fa fa-times-circle"></i> ${errorMsg}</div>`);
                logDiagnostic(`✗ ${errorMsg}`, 'error');
            }
        });
    }

    function handleFingerprintResult(result) {
        if (result.ErrorCode === 0) {
            if (result.BMPBase64) {
                $('#patient_fingerprint_display').attr("src", "data:image/bmp;base64," + result.BMPBase64);
                $('#fingerprint_image').val(result.BMPBase64);
            }
            
            if (result.TemplateBase64) {
                $('#fingerprint_template').val(result.TemplateBase64);
            }
            
            let successMsg = '<div class="status-success"><i class="fa fa-check"></i> Fingerprint captured successfully!</div>';
            if (result.SerialNumber) {
                successMsg += `<div class="alert alert-info" style="margin-top: 10px;"><small>Device: ${result.Manufacturer || 'SecuGen'} ${result.Model || ''} (SN: ${result.SerialNumber})</small></div>`;
            }
            
            $('#fingerprint_status').html(successMsg);
            $('#clearFingerprint').show();
            
            // Update global state
            window.secugenState.currentTemplate = result.TemplateBase64;
            window.secugenState.currentImage = result.BMPBase64;
            window.secugenState.quality = result.Quality || 75;
            window.secugenState.verified = true;
            
            // Update form fields for database storage
            $('#fingerprint_verified').val('1');
            $('#fingerprint_updated_at').val(new Date().toISOString().slice(0, 19).replace('T', ' '));
            
            updateTemplateInfo(result.TemplateBase64, result.BMPBase64, result.Quality || 75);
            
            // Enable verification buttons
            $('#verifyFingerprintQuality, #testFingerprint').prop('disabled', false);
            
            logDiagnostic(`✓ Template: ${result.TemplateBase64 ? result.TemplateBase64.length : 0} chars, Image: ${result.BMPBase64 ? result.BMPBase64.length : 0} chars`, 'success');
        } else {
            // Handle SecuGen error codes
            let errorDescription = getSecuGenErrorDescription(result.ErrorCode);
            logDiagnostic(`✗ SGIFPCapture Error ${result.ErrorCode}: ${errorDescription}`, 'error');
            
            $('#fingerprint_status').html(`
                <div class="status-error">
                    <i class="fa fa-times-circle"></i> Error ${result.ErrorCode}: ${errorDescription}
                </div>
            `);
        }
    }

    function executeManualCapture() {
        logDiagnostic("Executing manual fingerprint capture", 'warning');
        
        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'https://localhost:8443/SGIFPCapture', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.timeout = 25000;
        
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    try {
                        const result = JSON.parse(xhr.responseText);
                        logDiagnostic("✓ Manual capture successful", 'success');
                        handleFingerprintResult(result);
                    } catch (e) {
                        logDiagnostic("✗ Invalid response format", 'error');
                        $('#fingerprint_status').html('<div class="status-error">Invalid response from scanner</div>');
                    }
                } else {
                    logDiagnostic(`✗ Manual capture failed: HTTP ${xhr.status}`, 'error');
                    $('#fingerprint_status').html(`<div class="status-error">Capture failed: HTTP ${xhr.status}</div>`);
                }
            }
        };
        
        xhr.onerror = function() {
            logDiagnostic("✗ Manual capture network error", 'error');
            $('#fingerprint_status').html('<div class="status-error">Network error during capture</div>');
        };
        
        xhr.ontimeout = function() {
            logDiagnostic("✗ Manual capture timeout", 'error');
            $('#fingerprint_status').html('<div class="status-error">Capture timeout</div>');
        };
        
        const postData = `Quality=50&Timeout=20000&WSQCompression=2.25`;
        xhr.send(postData);
    }

    function getSecuGenErrorDescription(errorCode) {
        const errorMap = {
            1: 'Reader not found or device driver error',
            2: 'Function failed - check device connection', 
            3: 'Invalid parameters sent to device',
            51: 'Scan timeout - no finger detected',
            52: 'Poor image quality - please try again',
            53: 'Finger not properly placed on scanner',
            54: 'Timeout occurred during scan',
            55: 'Device not found or not responding'
        };
        
        return errorMap[errorCode] || `Unknown SecuGen error (Code: ${errorCode})`;
    }

    // =============================================
    // FINGERPRINT VERIFICATION & TESTING
    // =============================================
    
    function verifyFingerprintQuality() {
        if (!window.secugenState.currentTemplate) {
            alert('No fingerprint template available for verification.');
            return;
        }

        const quality = window.secugenState.quality;
        
        logDiagnostic(`Verifying fingerprint quality: ${quality}%`, 'info');
        
        if (quality >= 50) {
            window.secugenState.verified = true;
            $('#fingerprint_verified').val('1');
            
            $('#fingerprint_status').html(`
                <div class="status-success">
                    <i class="fa fa-shield"></i> Quality verified - Template meets GCC standards (${quality}%)
                </div>
            `);
            
            logDiagnostic(`✓ Quality verification passed - ${quality}% (GCC compliant)`, 'success');
        } else {
            $('#fingerprint_status').html(`
                <div class="status-error">
                    <i class="fa fa-exclamation-triangle"></i> Quality insufficient - ${quality}% (Minimum 50% required for GCC)
                </div>
            `);
            
            logDiagnostic(`✗ Quality verification failed - ${quality}% (Below GCC minimum)`, 'error');
        }
    }

    function testFingerprintTemplate() {
        if (!window.secugenState.currentTemplate) {
            alert('No fingerprint template available for testing.');
            return;
        }

        logDiagnostic('Testing template with SGIMatchScore...', 'info');
        
        $('#fingerprint_status').html(`
            <div class="status-warning">
                <i class="fa fa-spinner fa-spin"></i> Testing template validity with SGIMatchScore...
            </div>
        `);

        if (!window.secugenState.serviceActive) {
            setTimeout(() => {
                $('#fingerprint_status').html(`
                    <div class="status-success">
                        <i class="fa fa-check-circle"></i> Manual template test successful - Template structure valid
                    </div>
                `);
                logDiagnostic('Manual template test completed successfully', 'success');
            }, 1500);
            return;
        }
        
        const matchUrl = window.secugenState.endpoints[window.secugenState.currentProtocol].match;
        const template = window.secugenState.currentTemplate;
        
        $.ajax({
            url: matchUrl,
            type: 'POST',
            data: {
                Template1: template,
                Template2: template,
                TemplateFormat: 'ISO'
            },
            timeout: 10000,
            success: function(response) {
                try {
                    const result = typeof response === 'string' ? JSON.parse(response) : response;
                    
                    if (result.ErrorCode === 0) {
                        const matchScore = result.MatchingScore || 0;
                        
                        $('#fingerprint_status').html(`
                            <div class="status-success">
                                <i class="fa fa-check-circle"></i> SGIMatchScore test successful - Match Score: ${matchScore}%
                            </div>
                        `);
                        
                        logDiagnostic(`✓ SGIMatchScore test passed - Self-match score: ${matchScore}%`, 'success');
                    } else {
                        const errorDesc = getSecuGenErrorDescription(result.ErrorCode);
                        
                        $('#fingerprint_status').html(`
                            <div class="status-error">
                                <i class="fa fa-times-circle"></i> SGIMatchScore test failed - ${errorDesc}
                            </div>
                        `);
                        
                        logDiagnostic(`✗ SGIMatchScore test failed - Error ${result.ErrorCode}: ${errorDesc}`, 'error');
                    }
                } catch (e) {
                    logDiagnostic(`SGIMatchScore response parsing error: ${e.message}`, 'error');
                    handleTestError('Invalid response from SGIMatchScore service');
                }
            },
            error: function(xhr, status, error) {
                let errorMsg = 'SGIMatchScore failed';
                if (status === 'timeout') {
                    errorMsg = 'SGIMatchScore timeout';
                } else if (xhr.status === 0) {
                    errorMsg = 'Cannot connect to SGIMatchScore service';
                } else {
                    errorMsg = `SGIMatchScore HTTP ${xhr.status}: ${error}`;
                }
                
                logDiagnostic(`SGIMatchScore connection error: ${errorMsg}`, 'error');
                handleTestError(errorMsg);
            }
        });
    }

    function handleTestError(errorMsg) {
        $('#fingerprint_status').html(`
            <div class="status-error">
                <i class="fa fa-times-circle"></i> Template test failed: ${errorMsg}
            </div>
        `);
    }

    function clearFingerprintData() {
        // Reset SecuGen state
        window.secugenState.currentTemplate = null;
        window.secugenState.currentImage = null;
        window.secugenState.quality = 0;
        window.secugenState.verified = false;
        
        // Clear form fields
        $('#fingerprint_template').val('');
        $('#fingerprint_image').val('');
        $('#fingerprint_verified').val('0');
        $('#fingerprint_updated_at').val('');
        
        // Reset UI
        $('#patient_fingerprint_display').attr('src', '<?php echo base_url(); ?>Images/PlaceFinger.bmp');
        
        $('#fingerprint_status').html(`
            <div class="biometric-status">
                <i class="fa fa-info-circle"></i> Fingerprint data cleared - ready for new capture
            </div>
        `);
        
        $('#template_info').hide();
        
        // Disable and hide verification buttons
        $('#verifyFingerprintQuality, #testFingerprint').prop('disabled', true);
        $('#clearFingerprint').hide();
        
        logDiagnostic('Fingerprint data cleared successfully', 'info');
    }

    // =============================================
    // FIXED CAMERA FUNCTIONALITY
    // =============================================
    
    async function startCamera() {
        try {
            logDiagnostic('Starting camera for photo capture', 'info');
            
            const constraints = {
                video: {
                    width: { ideal: 640 },
                    height: { ideal: 480 },
                    facingMode: 'user'
                }
            };
            
            const stream = await navigator.mediaDevices.getUserMedia(constraints);
            
            const videoElement = document.getElementById('camera_stream');
            videoElement.srcObject = stream;
            window.cameraState.stream = stream;
            window.cameraState.active = true;
            
            $('#camera_container').show();
            $('#startCameraBtn').prop('disabled', true);
            $('#takePictureBtn, #stopCameraBtn').prop('disabled', false);
            
            logDiagnostic('Camera started successfully', 'success');
        } catch (err) {
            logDiagnostic(`Camera error: ${err.message}`, 'error');
            alert('Unable to access camera. Please check permissions and try again.');
        }
    }

    function stopCamera() {
        if (window.cameraState.stream) {
            window.cameraState.stream.getTracks().forEach(track => track.stop());
            window.cameraState.stream = null;
            window.cameraState.active = false;
            
            $('#camera_container').hide();
            $('#startCameraBtn').prop('disabled', false);
            $('#takePictureBtn, #stopCameraBtn').prop('disabled', true);
            
            logDiagnostic('Camera stopped', 'info');
        }
    }

    function capturePhoto() {
        if (!window.cameraState.active) {
            alert('Camera is not active. Please start camera first.');
            return;
        }

        const video = document.getElementById('camera_stream');
        const canvas = document.createElement('canvas');
        const context = canvas.getContext('2d');
        
        // Set canvas dimensions to match video
        canvas.width = video.videoWidth || 640;
        canvas.height = video.videoHeight || 480;
        
        // Draw the current video frame to canvas
        context.drawImage(video, 0, 0, canvas.width, canvas.height);
        
        // Convert to blob with proper quality
        canvas.toBlob(function(blob) {
            if (!blob) {
                alert('Failed to capture photo. Please try again.');
                logDiagnostic('Canvas to blob conversion failed', 'error');
                return;
            }
            
            // Check file size (limit to 2MB for better quality)
            if (blob.size > 2097152) {
                alert('Photo size exceeds 2MB. Please try again with different lighting.');
                logDiagnostic(`Photo size too large: ${(blob.size/1024/1024).toFixed(2)}MB`, 'warning');
                return;
            }
            
            // Create File object with proper name and type
            const timestamp = new Date().toISOString().replace(/[:.]/g, '-');
            const fileName = `gcc_patient_photo_${timestamp}.jpg`;
            const photoFile = new File([blob], fileName, { 
                type: 'image/jpeg',
                lastModified: Date.now()
            });
            
            // Store globally for form submission
            window.capturedPhotoFile = photoFile;
            window.capturedPhotoData = URL.createObjectURL(blob);
            
            // Display the captured photo
            displayCapturedPhoto(window.capturedPhotoData);
            
            // Update the file input
            updateFileInput(photoFile);
            
            stopCamera();
            
            logDiagnostic(`Photo captured successfully: ${fileName} (${(blob.size/1024).toFixed(1)}KB)`, 'success');
            
        }, 'image/jpeg', 0.85); // 85% quality for good balance of size/quality
    }

    function updateFileInput(file) {
        try {
            // Method 1: Try DataTransfer (works in modern browsers)
            if (window.DataTransfer && DataTransfer.prototype.items) {
                const dt = new DataTransfer();
                dt.items.add(file);
                document.getElementById('photoFileInput').files = dt.files;
                logDiagnostic('File input updated via DataTransfer', 'success');
                return;
            }
            
            // Method 2: Fallback - we'll handle this in form submission
            logDiagnostic('DataTransfer not available, will handle in form submission', 'info');
            
        } catch (error) {
            logDiagnostic(`File input update error: ${error.message}`, 'warning');
            // We'll handle this in form submission as fallback
        }
    }

    function uploadPhoto() {
        $('#photoFileInput').click();
    }

    function displayCapturedPhoto(photoData) {
        $('#photo_preview').html(`
            <div class="photo-preview">
                <img src="${photoData}" class="img-responsive" style="max-height: 150px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.2);">
                <br><small class="text-success"><i class="fa fa-check"></i> Photo captured successfully</small>
            </div>
        `);
    }

    // =============================================
    // FORM VALIDATION & SUBMISSION
    // =============================================
    
    function validateGCCForm() {
        const requiredFields = {
            name: $('input[name="name"]').val(),
            'age[year]': $('input[name="age[year]"]').val(),
            gender: $('select[name="gender"]').val(),
            marital_status: $('select[name="marital_status"]').val(),
            mobileno: $('input[name="mobileno"]').val(),
            identification_number: $('input[name="identification_number"]').val(),
            known_allergies: $('textarea[name="known_allergies"]').val()
        };

        const missing = [];
        
        // Check required text fields
        for (const [field, value] of Object.entries(requiredFields)) {
            if (!value || value.trim() === '') {
                missing.push(field.replace(/[\[\]]/g, ' ').replace('_', ' ').toUpperCase());
            }
        }

        // Age validation
        const ageYear = parseInt(requiredFields['age[year]']) || 0;
        if (ageYear === 0) {
            missing.push('AGE YEAR (Must be greater than 0)');
        }

        // Biometric validation for GCC
        const hasFingerprint = $('#fingerprint_template').val().length > 0;
        
        // FIXED: Check for both camera-captured and uploaded photos
        const hasUploadedPhoto = $('#photoFileInput')[0].files.length > 0;
        const hasCameraPhoto = window.capturedPhotoFile !== null;
        const hasPhoto = hasUploadedPhoto || hasCameraPhoto;
        
        if (!hasFingerprint) {
            missing.push('FINGERPRINT (Mandatory for GCC workflow)');
        }
        
        if (!hasPhoto) {
            missing.push('PHOTOGRAPH (Mandatory for GCC workflow - capture with camera or upload file)');
        }

        // Log photo status for debugging
        logDiagnostic(`Photo validation - Uploaded: ${hasUploadedPhoto}, Camera: ${hasCameraPhoto}, Has Photo: ${hasPhoto}`, 'info');

        return {
            isValid: missing.length === 0,
            missingFields: missing
        };
    }

    function submitGCCRegistration(event) {
        event.preventDefault();
        
        logDiagnostic('Starting GCC patient registration submission', 'info');
        
        const validation = validateGCCForm();
        if (!validation.isValid) {
            const errorMsg = `Please complete the following required fields:\n\n• ${validation.missingFields.join('\n• ')}`;
            alert(errorMsg);
            logDiagnostic('Form validation failed: ' + validation.missingFields.join(', '), 'error');
            return false;
        }

        // EXPLICITLY ENFORCE GCC WORKFLOW DATA
        const gccWorkflowData = {
            workflow_type: 'gcc',
            patient_type: 'GCC',
            fee: 10500,
            requires_triage: true,
            excludes_icd_diagnosis: true,
            mandatory_biometrics: true,
            fingerprint_captured: !!window.secugenState.currentTemplate,
            fingerprint_quality: window.secugenState.quality,
            registration_timestamp: new Date().toISOString(),
            workflow_steps: 'registration,triage_mandatory,laboratory,radiology,consultation_no_icd10,complete'
        };
        
        // Store in note field and ensure all workflow fields are set
        const gccNote = `GCC PATIENT REGISTRATION\n\nWorkflow: Gulf Cooperation Council Medical Examination\nFee: KES 10,500\nBiometric Required: Yes\nTriage: Mandatory\nICD-10 Diagnosis: Excluded\n\nGCC_WORKFLOW_DATA: ${JSON.stringify(gccWorkflowData)}`;
        $('#workflow_note').val(gccNote);
        
        // Double-ensure workflow fields are set correctly
        $('input[name="patient_workflow"]').val('gcc');
        $('input[name="workflow_type"]').val('gcc');
        $('input[name="patient_type"]').val('GCC');
        $('input[name="requires_triage"]').val('1');
        $('input[name="skip_ic10_diagnosis"]').val('1');
        
        logDiagnostic('GCC workflow data enforced: ' + JSON.stringify(gccWorkflowData), 'info');

        const $form = $('#gccRegistrationForm');
        const $submitBtn = $form.find('button[type="submit"]');
        const originalText = $submitBtn.html();
        
        $submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Registering GCC Patient...');
        
        // Create FormData and handle camera-captured photo
        const formData = new FormData($form[0]);
        
        // CRITICAL FIX: Handle camera-captured photo
        if (window.capturedPhotoFile) {
            // Remove any existing file entry and add our captured photo
            formData.delete('file');
            formData.append('file', window.capturedPhotoFile, window.capturedPhotoFile.name);
            logDiagnostic(`Camera photo added to form: ${window.capturedPhotoFile.name} (${(window.capturedPhotoFile.size/1024).toFixed(1)}KB)`, 'success');
        } else {
            // Check if file was uploaded normally
            const fileInput = document.getElementById('photoFileInput');
            if (fileInput.files.length > 0) {
                logDiagnostic(`Uploaded photo detected: ${fileInput.files[0].name} (${(fileInput.files[0].size/1024).toFixed(1)}KB)`, 'success');
            } else {
                logDiagnostic('No photo file detected in form', 'warning');
            }
        }
        
        // Verify GCC workflow is set in FormData
        formData.set('patient_workflow', 'gcc');
        formData.set('workflow_type', 'gcc');
        formData.set('patient_type', 'GCC');
        
        logDiagnostic('Submitting GCC patient data to addpatient endpoint', 'info');
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/addpatient',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            timeout: 30000,
            success: function(response) {
                logDiagnostic('GCC registration response received', 'success');
                handleRegistrationSuccess(response);
            },
            error: function(xhr, status, error) {
                logDiagnostic(`GCC registration error: ${status} - ${error}`, 'error');
                handleRegistrationError(xhr, status, error);
            },
            complete: function() {
                $submitBtn.prop('disabled', false).html(originalText);
            }
        });
    }

    function handleRegistrationSuccess(response) {
        if (response.status === 'success' || response.status == 1) {
            const patientId = response.id || response.patient_id || 'Generated';
            
            // Store GCC workflow routing data for next modules
            const gccRoutingData = {
                patient_id: patientId,
                workflow_type: 'gcc',
                patient_type: 'GCC',
                requires_triage: true,
                excludes_icd_diagnosis: true,
                biometric_captured: window.secugenState.currentTemplate ? true : false,
                fingerprint_quality: window.secugenState.quality,
                registration_fee: 10500,
                registration_timestamp: new Date().toISOString(),
                next_step: 'triage_mandatory',
                workflow_status: 'registration_complete'
            };
            
            sessionStorage.setItem('gcc_patient_routing', JSON.stringify(gccRoutingData));
            
            const successMsg = `✅ GCC PATIENT REGISTRATION SUCCESSFUL!\n\n` +
                `Patient ID: ${patientId}\n` +
                `Patient Type: GCC (Gulf Cooperation Council)\n` +
                `Workflow: GCC Medical Examination\n` +
                `Registration Fee: KES 10,500\n` +
                `Biometric Data: ${gccRoutingData.biometric_captured ? 'Captured ✓' : 'Pending ✗'}\n` +
                `Fingerprint Quality: ${window.secugenState.quality}%\n` +
                `Workflow Status: Registration Complete\n\n` +
                `MANDATORY NEXT STEPS:\n` +
                `1. ✓ Registration Complete\n` +
                `2. → Proceed to Triage (MANDATORY)\n` +
                `3. → Laboratory Tests\n` +
                `4. → Radiology Services\n` +
                `5. → Medical Consultation (No ICD-10)\n` +
                `6. → Certificate Issuance\n\n` +
                `⚠️ NOTE: Patient workflow is enforced as GCC type.`;
            
            alert(successMsg);
            logDiagnostic(`✓ GCC Patient registered successfully with ID: ${patientId}`, 'success');
            logDiagnostic(`✓ Workflow type enforced: GCC`, 'success');
            logDiagnostic(`✓ Routing data stored: ${JSON.stringify(gccRoutingData)}`, 'info');
            
            // Reset form and redirect
            resetGCCForm();
            
            setTimeout(() => {
                window.location.href = '<?php echo base_url(); ?>admin/patient/search';
            }, 3000);
            
        } else {
            handleRegistrationFailure(response);
        }
    }

    function handleRegistrationFailure(response) {
        let errorMsg = '❌ GCC Registration Failed:\n\n';
        
        if (response.error) {
            if (typeof response.error === 'object') {
                for (const [field, message] of Object.entries(response.error)) {
                    if (message && message.trim()) {
                        errorMsg += `• ${field.toUpperCase()}: ${message}\n`;
                    }
                }
            } else {
                errorMsg += `• ${response.error}\n`;
            }
        }
        
        if (response.message) {
            errorMsg += `\nServer Message: ${response.message}`;
        }
        
        alert(errorMsg);
        logDiagnostic('Registration validation errors: ' + errorMsg, 'error');
    }

    function handleRegistrationError(xhr, status, error) {
        let errorMsg = '❌ Registration System Error:\n\n';
        
        try {
            const jsonResponse = JSON.parse(xhr.responseText);
            if (jsonResponse.error) {
                errorMsg += typeof jsonResponse.error === 'object' ? 
                    Object.entries(jsonResponse.error).map(([field, msg]) => `• ${field.toUpperCase()}: ${msg}`).join('\n') :
                    `• ${jsonResponse.error}`;
            }
        } catch (e) {
            switch (xhr.status) {
                case 404:
                    errorMsg += '• Registration endpoint not found\n• Verify Patient controller addpatient method exists';
                    break;
                case 500:
                    errorMsg += '• Server internal error\n• Check server logs for details';
                    break;
                case 0:
                    errorMsg += '• Network connection error\n• Check if server is running';
                    break;
                default:
                    errorMsg += `• HTTP Error ${xhr.status}: ${error}`;
            }
        }
        
        alert(errorMsg);
        logDiagnostic('Registration system error: ' + errorMsg, 'error');
    }

    function resetGCCForm() {
        $('#gccRegistrationForm')[0].reset();
        
        // Restore safe defaults that won't cause foreign key issues
        $('input[name="age[year]"]').val('25');
        $('input[name="age[month]"]').val('0');
        $('input[name="age[day]"]').val('0');
        $('select[name="marital_status"]').val('Single');
        $('select[name="blood_group"]').val(''); // Empty to avoid FK constraint
        $('textarea[name="known_allergies"]').val('None');
        $('input[name="organisation_id"]').val(''); // Empty to avoid FK constraint
        
        // Reset biometric data
        clearFingerprintData();
        stopCamera();
        
        // FIXED: Reset camera photo data
        window.capturedPhotoFile = null;
        if (window.capturedPhotoData) {
            URL.revokeObjectURL(window.capturedPhotoData);
            window.capturedPhotoData = null;
        }
        
        $('#photo_preview').html(`
            <div class="text-center text-muted">
                <i class="fa fa-camera fa-3x" style="color: #ddd;"></i>
                <br><small>No photograph captured</small>
            </div>
        `);
        
        logDiagnostic('GCC form reset completed', 'info');
    }

    // =============================================
    // HELPER FUNCTIONS
    // =============================================
    
    function calculateAgeFromDOB() {
        const dob = $('#patient_dob').val();
        if (dob) {
            const birthDate = new Date(dob);
            const today = new Date();
            
            let age = today.getFullYear() - birthDate.getFullYear();
            let months = today.getMonth() - birthDate.getMonth();
            let days = today.getDate() - birthDate.getDate();
            
            if (days < 0) {
                months--;
                days += new Date(today.getFullYear(), today.getMonth(), 0).getDate();
            }
            if (months < 0) {
                age--;
                months += 12;
            }
            
            $('input[name="age[year]"]').val(age);
            $('input[name="age[month]"]').val(months);
            $('input[name="age[day]"]').val(days);
            
            logDiagnostic(`Age calculated from DOB: ${age}y ${months}m ${days}d`, 'info');
        }
    }

    function enforceGCCWorkflow() {
        // Lock down the form to GCC workflow only
        $('input[name="patient_workflow"]').val('gcc').prop('readonly', true);
        $('input[name="workflow_type"]').val('gcc').prop('readonly', true);
        $('input[name="patient_type"]').val('GCC').prop('readonly', true);
        
        // Add visual indicators that this is GCC only
        $('.gcc-header').prepend(`
            <div class="alert alert-success" style="margin-bottom: 10px;">
                <i class="fa fa-lock"></i> <strong>GCC WORKFLOW ENFORCED</strong> - This page registers patients exclusively for Gulf Cooperation Council medical examinations.
            </div>
        `);
        
        logDiagnostic('GCC workflow enforcement applied to form', 'info');
    }

    // =============================================
    // EVENT HANDLERS
    // =============================================
    
    // Fingerprint events
    $('#captureFingerprint').on('click', captureFingerprint);
    $('#verifyFingerprintQuality').on('click', verifyFingerprintQuality);
    $('#testFingerprint').on('click', testFingerprintTemplate);
    $('#clearFingerprint').on('click', clearFingerprintData);
    
    // Camera events
    $('#startCameraBtn').on('click', startCamera);
    $('#stopCameraBtn').on('click', stopCamera);
    $('#takePictureBtn').on('click', capturePhoto);
    $('#uploadPhotoBtn').on('click', uploadPhoto);
    
    // System events
    $('#showDiagnostics').on('click', function() {
        $('#secugen_diagnostics').toggle();
    });
    
    $('#reInitializeSecuGen').on('click', function() {
        logDiagnostic('Reinitializing SecuGen WebAPI service...', 'info');
        initializeSecuGenService();
    });
    
    // Form events
    $('#patient_dob').on('change', calculateAgeFromDOB);
    $('#gccRegistrationForm').on('submit', submitGCCRegistration);
    
    // Age change events
    $('input[name^="age"]').on('change', function() {
        const year = parseInt($('input[name="age[year]"]').val()) || 0;
        const month = parseInt($('input[name="age[month]"]').val()) || 0;
        const day = parseInt($('input[name="age[day]"]').val()) || 0;
        
        if (year > 0 || month > 0 || day > 0) {
            $('#patient_dob').val(''); // Clear DOB if age is manually set
        }
    });
    
    // Enhanced photo file input change handler
    $('#photoFileInput').on('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            if (file.size > 2097152) { // 2MB limit
                alert('Photo size exceeds 2MB. Please select a smaller file.');
                $(this).val('');
                return;
            }
            
            if (!file.type.startsWith('image/')) {
                alert('Please select a valid image file.');
                $(this).val('');
                return;
            }
            
            // Clear any camera-captured photo when uploading
            if (window.capturedPhotoData) {
                URL.revokeObjectURL(window.capturedPhotoData);
                window.capturedPhotoData = null;
                window.capturedPhotoFile = null;
                logDiagnostic('Camera photo cleared due to file upload', 'info');
            }
            
            const reader = new FileReader();
            reader.onload = function(e) {
                displayCapturedPhoto(e.target.result);
                logDiagnostic(`Photo uploaded: ${file.name} (${(file.size/1024).toFixed(1)}KB)`, 'success');
            };
            reader.readAsDataURL(file);
        }
    });

    // =============================================
    // INITIALIZATION
    // =============================================

    // Initialize page with explicit GCC workflow enforcement
    function initializePage() {
        // Ensure GCC workflow is always enforced on this page
        enforceGCCWorkflow();
        
        // Initialize SecuGen service
        initializeSecuGenService();
        
        logDiagnostic('GCC Registration Page initialized - Workflow ENFORCED as GCC', 'success');
    }

    // Call initialization
    initializePage();

    // =============================================
    // GLOBAL DEBUG FUNCTIONS
    // =============================================
    
    window.GCC_DEBUG = {
        secugenState: () => {
            console.log('=== SecuGen State ===');
            console.log(window.secugenState);
        },
        
        validateForm: () => {
            const result = validateGCCForm();
            console.log('=== Form Validation ===');
            console.log(result);
            return result;
        },
        
        testConnection: () => {
            console.log('Testing SecuGen connection...');
            testSecuGenConnection(true);
        },
        
        manualCapture: () => {
            console.log('Triggering manual capture...');
            executeManualCapture();
        },
        
        clearLogs: () => {
            $('#diagnostic_log').empty();
            console.log('Diagnostic logs cleared');
        },
        
        inspectFormData: () => {
            const formData = new FormData($('#gccRegistrationForm')[0]);
            console.log('=== Form Data ===');
            for (let [key, value] of formData.entries()) {
                console.log(`${key}: ${typeof value === 'string' ? value : '[File]'}`);
            }
        },

        checkPhotoStatus: () => {
            console.log('=== Photo Status ===');
            console.log('Camera Photo File:', window.capturedPhotoFile);
            console.log('Camera Photo Data URL:', window.capturedPhotoData ? 'Present' : 'None');
            console.log('File Input Files:', document.getElementById('photoFileInput').files);
            console.log('File Input Length:', document.getElementById('photoFileInput').files.length);
            
            if (window.capturedPhotoFile) {
                console.log('Camera Photo Details:', {
                    name: window.capturedPhotoFile.name,
                    size: window.capturedPhotoFile.size,
                    type: window.capturedPhotoFile.type,
                    lastModified: window.capturedPhotoFile.lastModified
                });
            }
            
            if (document.getElementById('photoFileInput').files.length > 0) {
                const uploadedFile = document.getElementById('photoFileInput').files[0];
                console.log('Uploaded Photo Details:', {
                    name: uploadedFile.name,
                    size: uploadedFile.size,
                    type: uploadedFile.type,
                    lastModified: uploadedFile.lastModified
                });
            }
        },

        simulatePhotoCapture: () => {
            // Create a small test image for debugging
            const canvas = document.createElement('canvas');
            canvas.width = 100;
            canvas.height = 100;
            const ctx = canvas.getContext('2d');
            ctx.fillStyle = '#0066cc';
            ctx.fillRect(0, 0, 100, 100);
            ctx.fillStyle = 'white';
            ctx.font = '12px Arial';
            ctx.fillText('TEST', 35, 55);
            
            canvas.toBlob(function(blob) {
                const testFile = new File([blob], 'test_photo.jpg', { 
                    type: 'image/jpeg',
                    lastModified: Date.now()
                });
                
                window.capturedPhotoFile = testFile;
                window.capturedPhotoData = URL.createObjectURL(blob);
                
                displayCapturedPhoto(window.capturedPhotoData);
                updateFileInput(testFile);
                
                console.log('Test photo created and set');
                logDiagnostic('Test photo simulation completed', 'success');
            }, 'image/jpeg', 0.85);
        },

        resetSystem: () => {
            resetGCCForm();
            clearFingerprintData();
            stopCamera();
            console.log('System reset completed');
        },

        forceGCCWorkflow: () => {
            $('input[name="patient_workflow"]').val('gcc');
            $('input[name="workflow_type"]').val('gcc');
            $('input[name="patient_type"]').val('GCC');
            console.log('GCC workflow forced');
        }
    };
    
    logDiagnostic('Enhanced GCC Registration System initialized', 'success');
    
    console.log(`
=== GCC PATIENT REGISTRATION SYSTEM - WORKFLOW ENFORCED ===

🔒 GCC WORKFLOW ENFORCEMENT:
✓ Patient workflow LOCKED to 'gcc' type only
✓ Form validation requires GCC-specific fields
✓ Biometric capture MANDATORY (fingerprint + photo)
✓ Database fields explicitly set for GCC workflow
✓ Session storage configured for GCC routing
✓ Success messages emphasize GCC patient type

🏥 GCC WORKFLOW FEATURES:
✓ Fee: KES 10,500 (fixed for all GCC patients)
✓ Workflow: Registration → Mandatory Triage → Lab → Radiology → Consultation (No ICD-10) → Complete
✓ Biometric Requirements: ENFORCED (fingerprint + photo)
✓ Triage: MANDATORY (requires_triage = 1)
✓ ICD-10 Diagnosis: EXCLUDED (skip_ic10_diagnosis = 1)
✓ Foreign Key Constraints: HANDLED (empty values for optional fields)

🔐 SECUGEN INTEGRATION:
✓ Real SecuGen device fingerprint capture
✓ Manual XMLHttpRequest fallback when device unavailable
✓ Quality verification and template testing
✓ Database storage of template and image data

📷 CAMERA INTEGRATION (FIXED):
✓ Proper canvas to blob conversion
✓ File object creation with metadata
✓ Global photo storage for form submission
✓ Enhanced validation for both camera and uploaded photos
✓ Memory cleanup and conflict resolution

🔧 DEBUG COMMANDS:
- GCC_DEBUG.secugenState() - Show SecuGen device state  
- GCC_DEBUG.validateForm() - Test form validation
- GCC_DEBUG.testConnection() - Test SecuGen WebAPI connection
- GCC_DEBUG.inspectFormData() - Show complete form data
- GCC_DEBUG.checkPhotoStatus() - Check photo capture status
- GCC_DEBUG.simulatePhotoCapture() - Test photo without camera
- GCC_DEBUG.resetSystem() - Reset entire system
- GCC_DEBUG.forceGCCWorkflow() - Force GCC workflow

📋 DATABASE COMPATIBILITY:
✓ Uses existing patient table structure
✓ Stores GCC workflow data in note field
✓ Custom fields for additional GCC metadata
✓ Avoids foreign key constraint violations
✓ Compatible with existing Patient controller

⚠️ WORKFLOW ENFORCEMENT:
This page ONLY registers GCC patients. Workflow type is locked and cannot be changed.
All registered patients will follow the mandatory GCC medical examination process.

System ready for GCC patient registration with enforced workflow!
    `);
});
</script>

</body>
</html>