<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-stethoscope"></i> Nursing Dashboard
            <small>Comprehensive Patient Care Management</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Nursing Dashboard</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        
        <!-- Alert Messages -->
        <?php if ($this->session->flashdata('msg')): ?>
            <?php echo $this->session->flashdata('msg'); ?>
        <?php endif; ?>

        <!-- Quick Statistics Row -->
        <div class="row">
            <!-- Active IPD Patients -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3><?php echo $stats['active_ipd_patients']; ?></h3>
                        <p>Active IPD Patients</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-bed"></i>
                    </div>
                    <a href="<?php echo base_url('admin/patient/ipdsearch'); ?>" class="small-box-footer">
                        View All Patients <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Pending Procedures -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3><?php echo $stats['pending_procedures']; ?></h3>
                        <p>Pending Procedures</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-tasks"></i>
                    </div>
                    <a href="#" onclick="showPendingProcedures()" class="small-box-footer">
                        View Details <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Today's Assessments -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3><?php echo $stats['todays_assessments']; ?></h3>
                        <p>Today's Assessments</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-clipboard"></i>
                    </div>
                    <a href="#" onclick="showTodayAssessments()" class="small-box-footer">
                        View Details <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Critical Alerts -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3><?php echo $stats['critical_alerts']; ?></h3>
                        <p>Critical Alerts</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-exclamation-triangle"></i>
                    </div>
                    <a href="#" onclick="showCriticalAlerts()" class="small-box-footer">
                        View Alerts <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Main Content Row -->
        <div class="row">
            <!-- Patient Search Panel -->
            <div class="col-md-8">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-search"></i> Patient Search for Nursing Care
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" onclick="clearAllSearches()">
                                <i class="fa fa-refresh"></i> Clear
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <!-- Search Form -->
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="searchType">Search By:</label>
                                    <select class="form-control" id="searchType">
                                        <option value="all">All Fields</option>
                                        <option value="name">Patient Name</option>
                                        <option value="id">Patient ID</option>
                                        <option value="phone">Phone Number</option>
                                        <option value="ipd">IPD Number</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group">
                                    <label for="patientSearch">Search Term:</label>
                                    <input type="text" class="form-control" id="patientSearch" 
                                           placeholder="Enter patient name, ID, phone, or IPD number..." 
                                           autocomplete="off">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>&nbsp;</label>
                                    <button class="btn btn-primary btn-block" id="searchBtn">
                                        <i class="fa fa-search"></i> Search
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Search Status -->
                        <div id="searchStatus" class="alert alert-info" style="display: none;">
                            <i class="fa fa-info-circle"></i> <span id="searchStatusText">Ready to search...</span>
                        </div>

                        <!-- Loading Indicator -->
                        <div id="loadingSpinner" class="text-center" style="display: none; padding: 20px;">
                            <i class="fa fa-spinner fa-spin fa-2x text-primary"></i>
                            <p class="text-muted">Searching patients...</p>
                        </div>

                        <!-- Search Results -->
                        <div id="searchResults" style="margin-top: 15px; max-height: 450px; overflow-y: auto;"></div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions and Info Panel -->
            <div class="col-md-4">
                <!-- Quick Actions -->
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-bolt"></i> Quick Actions
                        </h3>
                    </div>
                    <div class="box-body">
                                                <div class="btn-group-vertical btn-block" role="group">
                            <a href="<?php echo base_url('admin/nursing/reports'); ?>" class="btn btn-info btn-sm">
                                <i class="fa fa-chart-bar"></i> Nursing Reports
                            </a>
                            
                            <a href="<?php echo base_url('admin/patient'); ?>" class="btn btn-success btn-sm">
                                <i class="fa fa-user-plus"></i> New Patient Registration
                            </a>
                            
                            <button class="btn btn-warning btn-sm" onclick="showProcedureTemplates()">
                                <i class="fa fa-list"></i> Procedure Templates
                            </button>
                            
                            <button class="btn btn-default btn-sm" onclick="showShiftHandover()">
                                <i class="fa fa-exchange"></i> Shift Handover
                            </button>
                            
                            <button class="btn btn-primary btn-sm" onclick="showNursingStats()">
                                <i class="fa fa-bar-chart"></i> Today's Statistics
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Recent Activity -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-history"></i> Recent Nursing Activity
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" onclick="refreshRecentActivity()">
                                <i class="fa fa-refresh"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div id="recentActivity">
                            <div class="text-center text-muted">
                                <i class="fa fa-spinner fa-spin"></i> Loading recent activity...
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Today's Summary -->
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-calendar"></i> Today's Summary
                        </h3>
                    </div>
                    <div class="box-body">
                        <div id="todaySummary">
                            <div class="row">
                                <div class="col-xs-6">
                                    <div class="description-block border-right">
                                        <span class="description-percentage text-green">
                                            <i class="fa fa-stethoscope"></i>
                                        </span>
                                        <h5 class="description-header" id="todayVitals">0</h5>
                                        <span class="description-text">Vital Signs</span>
                                    </div>
                                </div>
                                <div class="col-xs-6">
                                    <div class="description-block">
                                        <span class="description-percentage text-blue">
                                            <i class="fa fa-edit"></i>
                                        </span>
                                        <h5 class="description-header" id="todayNotes">0</h5>
                                        <span class="description-text">Nursing Notes</span>
                                    </div>
                                </div>
                            </div>
                            <div class="row" style="margin-top: 10px;">
                                <div class="col-xs-6">
                                    <div class="description-block border-right">
                                        <span class="description-percentage text-yellow">
                                            <i class="fa fa-tasks"></i>
                                        </span>
                                        <h5 class="description-header" id="todayProcedures">0</h5>
                                        <span class="description-text">Procedures</span>
                                    </div>
                                </div>
                                <div class="col-xs-6">
                                    <div class="description-block">
                                        <span class="description-percentage text-red">
                                            <i class="fa fa-clipboard"></i>
                                        </span>
                                        <h5 class="description-header" id="todayAssessments">0</h5>
                                        <span class="description-text">Assessments</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recently Accessed Patients -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-users"></i> Recently Accessed Patients
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" onclick="clearRecentPatients()">
                                <i class="fa fa-trash"></i> Clear History
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div id="recentPatients">
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle"></i> 
                                No recent patients found. Search for a patient to begin nursing care.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Emergency Procedures Quick Access -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-danger collapsed-box">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-exclamation-triangle"></i> Emergency Procedures Quick Access
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-plus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-3">
                                <button class="btn btn-danger btn-block" onclick="emergencyProcedure('cpr')">
                                    <i class="fa fa-heartbeat"></i><br>CPR Protocol
                                </button>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-warning btn-block" onclick="emergencyProcedure('allergy')">
                                    <i class="fa fa-exclamation"></i><br>Allergic Reaction
                                </button>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-info btn-block" onclick="emergencyProcedure('choking')">
                                    <i class="fa fa-user-times"></i><br>Choking Response
                                </button>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-success btn-block" onclick="emergencyProcedure('code_blue')">
                                    <i class="fa fa-ambulance"></i><br>Code Blue
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<!-- Modals -->
<!-- Procedure Templates Modal -->
<div class="modal fade" id="procedureTemplatesModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-list"></i> Nursing Procedure Templates
                </h4>
            </div>
            <div class="modal-body">
                <div id="procedureTemplatesList">
                    <div class="text-center">
                        <i class="fa fa-spinner fa-spin fa-2x"></i>
                        <p>Loading procedure templates...</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Today's Statistics Modal -->
<div class="modal fade" id="statsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-bar-chart"></i> Today's Nursing Statistics
                </h4>
            </div>
            <div class="modal-body">
                <div id="detailedStats">
                    <div class="text-center">
                        <i class="fa fa-spinner fa-spin fa-2x"></i>
                        <p>Loading statistics...</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Custom CSS -->
<style>
/* Patient Card Styles */
.patient-card {
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    padding: 12px;
    margin-bottom: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
    background: white;
}

.patient-card:hover {
    border-color: #3c8dbc;
    box-shadow: 0 4px 12px rgba(60, 141, 188, 0.15);
    transform: translateY(-2px);
}

.patient-card:active {
    transform: translateY(0);
}

.patient-name {
    font-weight: bold;
    color: #333;
    margin-bottom: 5px;
    font-size: 14px;
}

.patient-info {
    color: #666;
    font-size: 12px;
    line-height: 1.4;
}

.patient-badges {
    margin-top: 5px;
}

.ipd-badge {
    background: #00a65a;
    color: white;
    padding: 2px 8px;
    border-radius: 12px;
    font-size: 10px;
    font-weight: 500;
    margin-right: 5px;
}

.opd-badge {
    background: #605ca8;
    color: white;
    padding: 2px 8px;
    border-radius: 12px;
    font-size: 10px;
    font-weight: 500;
    margin-right: 5px;
}

.priority-badge {
    padding: 2px 6px;
    border-radius: 10px;
    font-size: 10px;
    font-weight: 500;
}

.priority-high {
    background: #dd4b39;
    color: white;
}

.priority-medium {
    background: #f39c12;
    color: white;
}

.priority-low {
    background: #00a65a;
    color: white;
}

/* Activity Item Styles */
.activity-item {
    border-left: 3px solid #3c8dbc;
    padding-left: 10px;
    margin-bottom: 10px;
    padding-bottom: 5px;
}

.activity-time {
    font-size: 11px;
    color: #999;
}

.activity-text {
    font-size: 12px;
    color: #555;
    line-height: 1.3;
}

/* Search Results */
.search-result-header {
    background: #f4f4f4;
    padding: 8px 12px;
    border-radius: 4px;
    margin-bottom: 10px;
    font-weight: bold;
}

/* Emergency Button Styles */
.btn-emergency {
    height: 60px;
    margin-bottom: 10px;
}

/* Loading States */
.loading-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(255, 255, 255, 0.8);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 10;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .patient-card {
        margin-bottom: 5px;
        padding: 8px;
    }
    
    .btn-group-vertical .btn {
        margin-bottom: 5px;
    }
    
    .description-block {
        margin-bottom: 10px;
    }
}

/* Scrollbar styling for search results */
#searchResults::-webkit-scrollbar {
    width: 6px;
}

#searchResults::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 3px;
}

#searchResults::-webkit-scrollbar-thumb {
    background: #c1c1c1;
    border-radius: 3px;
}

#searchResults::-webkit-scrollbar-thumb:hover {
    background: #a8a8a8;
}

/* Animation for statistics */
.description-header {
    transition: all 0.3s ease;
}

.description-header.updated {
    color: #00a65a;
    transform: scale(1.1);
}

/* Status indicators */
.status-online {
    width: 8px;
    height: 8px;
    background: #00a65a;
    border-radius: 50%;
    display: inline-block;
    margin-right: 5px;
}

.status-busy {
    width: 8px;
    height: 8px;
    background: #f39c12;
    border-radius: 50%;
    display: inline-block;
    margin-right: 5px;
}

.status-offline {
    width: 8px;
    height: 8px;
    background: #dd4b39;
    border-radius: 50%;
    display: inline-block;
    margin-right: 5px;
}
</style>

<!-- JavaScript -->
<script>
$(document).ready(function() {
    // Initialize nursing dashboard
    initializeNursingDashboard();
    
    // Set up search functionality
    setupPatientSearch();
    
    // Load initial data
    loadInitialData();
    
    // Set up auto-refresh
    setupAutoRefresh();
});

// Initialize the complete nursing dashboard
function initializeNursingDashboard() {
    console.log('Initializing Nursing Dashboard...');
    
    // Load recent patients
    loadRecentPatients();
    
    // Load recent activity
    loadRecentActivity();
    
    // Load today's summary
    loadTodaySummary();
    
    // Set search status
    updateSearchStatus('Ready to search patients...', 'info');
    
    console.log('Nursing Dashboard initialized successfully');
}

// Set up patient search functionality
function setupPatientSearch() {
    // Real-time search as user types
    $('#patientSearch').on('input', function() {
        var searchTerm = $(this).val().trim();
        
        if (searchTerm.length >= 2) {
            clearTimeout(window.searchTimeout);
            window.searchTimeout = setTimeout(function() {
                performPatientSearch(searchTerm);
            }, 300); // Debounce search
        } else if (searchTerm.length === 0) {
            clearSearchResults();
            updateSearchStatus('Enter at least 2 characters to search...', 'info');
        }
    });
    
    // Search button click
    $('#searchBtn').click(function() {
        var searchTerm = $('#patientSearch').val().trim();
        if (searchTerm.length >= 2) {
            performPatientSearch(searchTerm);
        } else {
            showNotification('Please enter at least 2 characters to search', 'warning');
        }
    });
    
    // Enter key search
    $('#patientSearch').keypress(function(e) {
        if (e.which === 13) { // Enter key
            $('#searchBtn').click();
        }
    });
    
    // Search type change
    $('#searchType').change(function() {
        var searchTerm = $('#patientSearch').val().trim();
        if (searchTerm.length >= 2) {
            performPatientSearch(searchTerm);
        }
    });
}

// Perform patient search
function performPatientSearch(searchTerm) {
    var searchType = $('#searchType').val();
    
    // Show loading
    showSearchLoading(true);
    updateSearchStatus('Searching for patients...', 'info');
    
    $.ajax({
        url: '<?php echo base_url("admin/nursing/searchPatients"); ?>',
        type: 'POST',
        data: {
            search: searchTerm,
            search_type: searchType
        },
        dataType: 'json',
        success: function(response) {
            showSearchLoading(false);
            
            if (response.status === 'success') {
                displaySearchResults(response.patients);
                updateSearchStatus(`Found ${response.count} patient(s) matching "${searchTerm}"`, 'success');
            } else {
                updateSearchStatus(response.message, 'error');
                clearSearchResults();
            }
        },
        error: function(xhr, status, error) {
            showSearchLoading(false);
            updateSearchStatus('Search failed. Please try again.', 'error');
            console.error('Search error:', error);
        }
    });
}

// Display search results
function displaySearchResults(patients) {
    var resultsHtml = '';
    
    if (patients.length === 0) {
        resultsHtml = '<div class="alert alert-warning"><i class="fa fa-exclamation-triangle"></i> No patients found matching your search criteria.</div>';
    } else {
        resultsHtml += '<div class="search-result-header"><i class="fa fa-users"></i> Found ' + patients.length + ' patient(s)</div>';
        
        patients.forEach(function(patient) {
            var patientBadges = '';
            
            // IPD/OPD status
            if (patient.ipd_id) {
                patientBadges += '<span class="ipd-badge">IPD: ' + patient.ipd_no + '</span>';
            } else if (patient.opd_id) {
                patientBadges += '<span class="opd-badge">OPD: ' + patient.opd_no + '</span>';
            }
            
            // Additional info
            var patientAge = patient.age ? patient.age + ' years' : 'N/A';
            var patientPhone = patient.mobileno || 'No phone';
            var bloodGroup = patient.blood_group || 'Unknown';
            
            resultsHtml += '<div class="patient-card" onclick="openPatientProfile(' + patient.id + ', \'' + patient.patient_name + '\')">';
            resultsHtml += '<div class="patient-name">' + patient.patient_name + ' (' + patient.patient_unique_id + ')</div>';
            resultsHtml += '<div class="patient-info">';
            resultsHtml += '<i class="fa fa-phone"></i> ' + patientPhone + ' | ';
            resultsHtml += '<i class="fa fa-user"></i> ' + patient.gender + ', ' + patientAge + ' | ';
            resultsHtml += '<i class="fa fa-tint"></i> ' + bloodGroup;
            
            if (patient.bed_no) {
                resultsHtml += ' | <i class="fa fa-bed"></i> Bed: ' + patient.bed_no;
            }
            
            resultsHtml += '</div>';
            
            if (patientBadges) {
                resultsHtml += '<div class="patient-badges">' + patientBadges + '</div>';
            }
            
            resultsHtml += '</div>';
        });
    }
    
    $('#searchResults').html(resultsHtml);
}

// Clear search results
function clearSearchResults() {
    $('#searchResults').empty();
}

// Clear all searches
function clearAllSearches() {
    $('#patientSearch').val('');
    $('#searchType').val('all');
    clearSearchResults();
    updateSearchStatus('Search cleared. Ready to search...', 'info');
}

// Show/hide search loading
function showSearchLoading(show) {
    if (show) {
        $('#loadingSpinner').show();
        $('#searchResults').hide();
    } else {
        $('#loadingSpinner').hide();
        $('#searchResults').show();
    }
}

// Update search status
function updateSearchStatus(message, type) {
    var alertClass = 'alert-info';
    var icon = 'fa-info-circle';
    
    switch(type) {
        case 'success':
            alertClass = 'alert-success';
            icon = 'fa-check';
            break;
        case 'error':
            alertClass = 'alert-danger';
            icon = 'fa-exclamation-triangle';
            break;
        case 'warning':
            alertClass = 'alert-warning';
            icon = 'fa-warning';
            break;
    }
    
    $('#searchStatus').removeClass().addClass('alert ' + alertClass).show();
    $('#searchStatusText').html('<i class="fa ' + icon + '"></i> ' + message);
}

// Open patient nursing profile
function openPatientProfile(patientId, patientName) {
    // Add to recent patients
    addToRecentPatients(patientId, patientName);
    
    // Show loading notification
    showNotification('Opening nursing profile for ' + patientName + '...', 'info');
    
    // Navigate to patient profile
    window.location.href = '<?php echo base_url("admin/nursing/patient_profile/"); ?>' + patientId;
}

// Add patient to recent patients list
function addToRecentPatients(patientId, patientName) {
    var recentPatients = JSON.parse(localStorage.getItem('nursingRecentPatients') || '[]');
    
    // Create patient object
    var patient = {
        id: patientId,
        name: patientName,
        accessed_at: new Date().toISOString()
    };
    
    // Remove if already exists
    recentPatients = recentPatients.filter(function(p) {
        return p.id != patientId;
    });
    
    // Add to beginning
    recentPatients.unshift(patient);
    
    // Keep only last 10
    recentPatients = recentPatients.slice(0, 10);
    
    // Save to localStorage
    localStorage.setItem('nursingRecentPatients', JSON.stringify(recentPatients));
    
    // Refresh recent patients display
    loadRecentPatients();
}

// Load recent patients
function loadRecentPatients() {
    var recentPatients = JSON.parse(localStorage.getItem('nursingRecentPatients') || '[]');
    
    if (recentPatients.length === 0) {
        $('#recentPatients').html('<div class="alert alert-info"><i class="fa fa-info-circle"></i> No recent patients found. Search for a patient to begin nursing care.</div>');
        return;
    }
    
    var html = '<div class="row">';
    
    recentPatients.forEach(function(patient, index) {
        if (index < 8) { // Show only 8 recent patients
            html += '<div class="col-md-3 col-sm-4 col-xs-6">';
            html += '<div class="patient-card" onclick="openPatientProfile(' + patient.id + ', \'' + patient.name + '\')">';
            html += '<div class="patient-name">' + patient.name + '</div>';
            html += '<div class="patient-info">';
            html += '<i class="fa fa-clock-o"></i> ' + formatTimeAgo(patient.accessed_at);
            html += '<br><small class="text-muted">Click to open nursing profile</small>';
            html += '</div>';
            html += '</div>';
            html += '</div>';
        }
    });
    
    html += '</div>';
    
    $('#recentPatients').html(html);
}

// Clear recent patients
function clearRecentPatients() {
    if (confirm('Are you sure you want to clear recent patients history?')) {
        localStorage.removeItem('nursingRecentPatients');
        loadRecentPatients();
        showNotification('Recent patients history cleared', 'success');
    }
}

// Load recent nursing activity
function loadRecentActivity() {
    // Simulate loading recent activity
    setTimeout(function() {
        var activities = [
            {
                icon: 'fa-stethoscope',
                color: 'text-green',
                text: 'Vital signs recorded for Patient #' + Math.floor(Math.random() * 1000),
                time: '5 minutes ago'
            },
            {
                icon: 'fa-clipboard',
                color: 'text-blue',
                text: 'Nursing assessment completed for Patient #' + Math.floor(Math.random() * 1000),
                time: '12 minutes ago'
            },
            {
                icon: 'fa-tasks',
                color: 'text-orange',
                text: 'Wound dressing procedure completed',
                time: '25 minutes ago'
            },
            {
                icon: 'fa-edit',
                color: 'text-purple',
                text: 'Care plan updated for Patient #' + Math.floor(Math.random() * 1000),
                time: '35 minutes ago'
            }
        ];
        
        var html = '';
        activities.forEach(function(activity) {
            html += '<div class="activity-item">';
            html += '<div class="activity-text">';
            html += '<i class="fa ' + activity.icon + ' ' + activity.color + '"></i> ';
            html += activity.text;
            html += '</div>';
            html += '<div class="activity-time">' + activity.time + '</div>';
            html += '</div>';
        });
        
        $('#recentActivity').html(html);
    }, 1000);
}

// Refresh recent activity
function refreshRecentActivity() {
    $('#recentActivity').html('<div class="text-center text-muted"><i class="fa fa-spinner fa-spin"></i> Refreshing...</div>');
    loadRecentActivity();
}

// Load today's summary statistics
function loadTodaySummary() {
    $.ajax({
        url: '<?php echo base_url("admin/nursing/getDailyStats"); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                updateTodaysSummary(response.stats);
            }
        },
        error: function() {
            // Use placeholder data if API fails
            updateTodaysSummary({
                vital_signs: Math.floor(Math.random() * 50),
                nursing_notes: Math.floor(Math.random() * 30),
                procedures: Math.floor(Math.random() * 20),
                assessments: Math.floor(Math.random() * 15)
            });
        }
    });
}

// Update today's summary display
function updateTodaysSummary(stats) {
    $('#todayVitals').text(stats.vital_signs || 0).addClass('updated');
    $('#todayNotes').text(stats.nursing_notes || 0).addClass('updated');
    $('#todayProcedures').text(stats.procedures || 0).addClass('updated');
    $('#todayAssessments').text(stats.assessments || 0).addClass('updated');
    
    // Remove animation class after animation
    setTimeout(function() {
        $('.description-header').removeClass('updated');
    }, 1000);
}

// Load initial data
function loadInitialData() {
    // Focus on search input
    $('#patientSearch').focus();
    
    // Load any additional initial data
    console.log('Initial data loaded');
}

// Set up auto-refresh
function setupAutoRefresh() {
    // Refresh statistics every 5 minutes
    setInterval(function() {
        loadTodaySummary();
        
        // Refresh dashboard stats in background
        console.log('Auto-refreshing nursing dashboard statistics...');
    }, 300000); // 5 minutes
    
    // Refresh recent activity every 2 minutes
    setInterval(function() {
        refreshRecentActivity();
    }, 120000); // 2 minutes
}

// Quick action functions
function showProcedureTemplates() {
    $('#procedureTemplatesModal').modal('show');
    
    $.ajax({
        url: '<?php echo base_url("admin/nursing/get_procedure_templates"); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                displayProcedureTemplates(response.templates);
            } else {
                $('#procedureTemplatesList').html('<div class="alert alert-warning">No procedure templates found.</div>');
            }
        },
        error: function() {
            $('#procedureTemplatesList').html('<div class="alert alert-danger">Failed to load procedure templates.</div>');
        }
    });
}

function displayProcedureTemplates(templates) {
    var html = '';
    var currentType = '';
    
    if (templates.length === 0) {
        html = '<div class="alert alert-info">No procedure templates available. Templates will be created automatically.</div>';
    } else {
        templates.forEach(function(template) {
            if (template.procedure_type !== currentType) {
                if (currentType !== '') {
                    html += '</div></div>';
                }
                currentType = template.procedure_type;
                html += '<div class="panel panel-default">';
                html += '<div class="panel-heading"><h4>' + currentType.replace('_', ' ').toUpperCase() + '</h4></div>';
                html += '<div class="panel-body"><div class="row">';
            }
            
            html += '<div class="col-md-6">';
            html += '<div class="well well-sm">';
            html += '<h5><strong>' + template.procedure_name + '</strong></h5>';
            html += '<p class="text-muted small">' + (template.description || 'No description available') + '</p>';
            html += '<p><small>';
            html += '<i class="fa fa-clock-o"></i> ' + (template.estimated_duration || 'N/A') + ' min | ';
            html += '<i class="fa fa-star"></i> ' + (template.skill_level_required || 'basic');
            html += '</small></p>';
            html += '</div>';
            html += '</div>';
        });
        
        if (currentType !== '') {
            html += '</div></div></div>';
        }
    }
    
    $('#procedureTemplatesList').html(html);
}

function showShiftHandover() {
    showNotification('Shift handover functionality will be available soon!', 'info');
}

function showNursingStats() {
    $('#statsModal').modal('show');
    loadDetailedStats();
}

function loadDetailedStats() {
    // Simulate loading detailed statistics
    setTimeout(function() {
        var html = '<div class="row">';
        html += '<div class="col-md-6">';
        html += '<div class="info-box bg-aqua">';
        html += '<span class="info-box-icon"><i class="fa fa-stethoscope"></i></span>';
        html += '<div class="info-box-content">';
        html += '<span class="info-box-text">Vital Signs Today</span>';
        html += '<span class="info-box-number">' + $('#todayVitals').text() + '</span>';
        html += '<div class="progress"><div class="progress-bar" style="width: 70%"></div></div>';
        html += '<span class="progress-description">70% of daily target</span>';
        html += '</div></div></div>';
        
        html += '<div class="col-md-6">';
        html += '<div class="info-box bg-green">';
        html += '<span class="info-box-icon"><i class="fa fa-edit"></i></span>';
        html += '<div class="info-box-content">';
        html += '<span class="info-box-text">Nursing Notes</span>';
        html += '<span class="info-box-number">' + $('#todayNotes').text() + '</span>';
        html += '<div class="progress"><div class="progress-bar" style="width: 85%"></div></div>';
        html += '<span class="progress-description">85% documentation rate</span>';
        html += '</div></div></div>';
        html += '</div>';
        
        html += '<div class="row">';
        html += '<div class="col-md-6">';
        html += '<div class="info-box bg-yellow">';
        html += '<span class="info-box-icon"><i class="fa fa-tasks"></i></span>';
        html += '<div class="info-box-content">';
        html += '<span class="info-box-text">Procedures</span>';
        html += '<span class="info-box-number">' + $('#todayProcedures').text() + '</span>';
        html += '<div class="progress"><div class="progress-bar" style="width: 60%"></div></div>';
        html += '<span class="progress-description">60% completion rate</span>';
        html += '</div></div></div>';
        
        html += '<div class="col-md-6">';
        html += '<div class="info-box bg-red">';
        html += '<span class="info-box-icon"><i class="fa fa-clipboard"></i></span>';
        html += '<div class="info-box-content">';
        html += '<span class="info-box-text">Assessments</span>';
        html += '<span class="info-box-number">' + $('#todayAssessments').text() + '</span>';
        html += '<div class="progress"><div class="progress-bar" style="width: 90%"></div></div>';
        html += '<span class="progress-description">90% of scheduled</span>';
        html += '</div></div></div>';
        html += '</div>';
        
        $('#detailedStats').html(html);
    }, 500);
}

function showPendingProcedures() {
    showNotification('Loading pending procedures...', 'info');
    // This would typically load and display pending procedures
}

function showTodayAssessments() {
    showNotification('Loading today\'s assessments...', 'info');
    // This would typically load and display today's assessments
}

function showCriticalAlerts() {
    showNotification('Loading critical alerts...', 'info');
    // This would typically load and display critical alerts
}

// Emergency procedure functions
function emergencyProcedure(type) {
    var procedures = {
        'cpr': {
            title: 'CPR Protocol',
            message: 'Initiating CPR emergency protocol. Call emergency team immediately.',
            color: 'danger'
        },
        'allergy': {
            title: 'Allergic Reaction Response',
            message: 'Allergic reaction protocol activated. Prepare epinephrine if available.',
            color: 'warning'
        },
        'choking': {
            title: 'Choking Response',
            message: 'Choking emergency protocol. Begin Heimlich maneuver if conscious.',
            color: 'info'
        },
        'code_blue': {
            title: 'Code Blue',
            message: 'Code Blue activated. Emergency team has been notified.',
            color: 'primary'
        }
    };
    
    var procedure = procedures[type];
    if (procedure) {
        showNotification(procedure.title + ': ' + procedure.message, procedure.color);
        console.log('Emergency procedure activated:', type);
    }
}

// Utility functions
function formatTimeAgo(dateString) {
    var now = new Date();
    var date = new Date(dateString);
    var diffMs = now - date;
    var diffMins = Math.floor(diffMs / 60000);
    var diffHours = Math.floor(diffMins / 60);
    var diffDays = Math.floor(diffHours / 24);
    
    if (diffMins < 1) return 'Just now';
    if (diffMins < 60) return diffMins + ' min ago';
    if (diffHours < 24) return diffHours + ' hour' + (diffHours > 1 ? 's' : '') + ' ago';
    if (diffDays < 7) return diffDays + ' day' + (diffDays > 1 ? 's' : '') + ' ago';
    return date.toLocaleDateString();
}

function showNotification(message, type) {
    type = type || 'info';
    
    var alertClass = 'alert-info';
    var icon = 'fa-info-circle';
    
    switch(type) {
        case 'success':
            alertClass = 'alert-success';
            icon = 'fa-check';
            break;
        case 'error':
        case 'danger':
            alertClass = 'alert-danger';
            icon = 'fa-exclamation-triangle';
            break;
        case 'warning':
            alertClass = 'alert-warning';
            icon = 'fa-warning';
            break;
        case 'primary':
            alertClass = 'alert-info';
            icon = 'fa-info';
            break;
    }
    
    var alertHtml = '<div class="alert ' + alertClass + ' alert-dismissible nursing-notification" style="position: fixed; top: 70px; right: 20px; z-index: 9999; max-width: 400px; min-width: 300px;">';
    alertHtml += '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>';
    alertHtml += '<i class="fa ' + icon + '"></i> ' + message;
    alertHtml += '</div>';
    
    // Remove existing notifications
    $('.nursing-notification').remove();
    
    // Add new notification
    $('body').append(alertHtml);
    
    // Auto-dismiss after 5 seconds
    setTimeout(function() {
        $('.nursing-notification').fadeOut(function() {
            $(this).remove();
        });
    }, 5000);
}

// Debug and testing functions
function debugNursingDashboard() {
    console.log('=== Nursing Dashboard Debug Information ===');
    console.log('Search functionality:', $('#patientSearch').length > 0 ? 'Ready' : 'Not ready');
    console.log('Recent patients count:', JSON.parse(localStorage.getItem('nursingRecentPatients') || '[]').length);
    console.log('Statistics loaded:', $('#todayVitals').text() !== '0');
    console.log('Auto-refresh active:', window.refreshInterval !== undefined);
    
    // Test search functionality
    console.log('Testing search with "test"...');
    $('#patientSearch').val('test');
    performPatientSearch('test');
    
    console.log('Debug completed. Check network tab for API calls.');
}

// Keyboard shortcuts
$(document).keydown(function(e) {
    // Ctrl+F or Cmd+F for search focus
    if ((e.ctrlKey || e.metaKey) && e.keyCode === 70) {
        e.preventDefault();
        $('#patientSearch').focus().select();
        return false;
    }
    
    // Escape to clear search
    if (e.keyCode === 27) {
        clearAllSearches();
        $('#patientSearch').blur();
    }
});

// Page visibility change handling
document.addEventListener('visibilitychange', function() {
    if (!document.hidden) {
        // Page became visible, refresh data
        loadTodaySummary();
        refreshRecentActivity();
    }
});

// Make debug function available globally
window.debugNursingDashboard = debugNursingDashboard;

// Initialize tooltips for better UX
$(function () {
    $('[data-toggle="tooltip"]').tooltip();
});

// Console message for developers
console.log('%c🏥 Nursing Dashboard Loaded Successfully! 🏥', 'color: #00a65a; font-weight: bold; font-size: 16px;');
console.log('%cUse debugNursingDashboard() to test functionality', 'color: #3c8dbc; font-size: 12px;');
console.log('%cKeyboard shortcuts: Ctrl+F (focus search), Escape (clear search)', 'color: #f39c12; font-size: 10px;');
</script>

<!-- Additional features for enhanced functionality -->
<script>
// Advanced features that can be enabled

// Voice search functionality (if supported)
function enableVoiceSearch() {
    if ('webkitSpeechRecognition' in window) {
        var recognition = new webkitSpeechRecognition();
        recognition.continuous = false;
        recognition.interimResults = false;
        
        recognition.onresult = function(event) {
            var transcript = event.results[0][0].transcript;
            $('#patientSearch').val(transcript);
            performPatientSearch(transcript);
        };
        
        recognition.onerror = function(event) {
            showNotification('Voice search error: ' + event.error, 'error');
        };
        
        // Add voice search button (you can add this to the HTML)
        // <button onclick="startVoiceSearch()" class="btn btn-info"><i class="fa fa-microphone"></i></button>
        
        window.startVoiceSearch = function() {
            recognition.start();
            showNotification('Listening... speak now', 'info');
        };
    }
}

// Offline detection and handling
function handleOfflineMode() {
    window.addEventListener('online', function() {
        showNotification('Connection restored. Syncing data...', 'success');
        loadTodaySummary();
        refreshRecentActivity();
    });
    
    window.addEventListener('offline', function() {
        showNotification('Connection lost. Working in offline mode.', 'warning');
    });
}

// Export functionality for reports
function exportNursingData(format) {
    format = format || 'csv';
    showNotification('Preparing ' + format.toUpperCase() + ' export...', 'info');
    
    // This would typically make an API call to export data
    setTimeout(function() {
        showNotification('Export ready for download', 'success');
    }, 2000);
}

// Initialize advanced features
$(document).ready(function() {
    // Uncomment to enable advanced features
    // enableVoiceSearch();
    // handleOfflineMode();
});
</script>

</body>
</html>