<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-stethoscope"></i> Nursing Dashboard
            <small>Comprehensive Nursing Care Management System</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Nursing Dashboard</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Alert Container -->
        <div id="alertContainer"></div>

        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { 
            echo $this->session->flashdata('msg'); 
        } ?>

        <!-- Primary Statistics Row -->
        <div class="row">
            <!-- Active IPD Patients -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3 id="activeIPDCount"><?php echo $stats['active_ipd_patients'] ?? 0; ?></h3>
                        <p>Active IPD Patients</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-bed"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/patient/ipd" class="small-box-footer">
                        View IPD List <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Pending Procedures -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3 id="pendingProceduresCount"><?php echo $stats['pending_procedures'] ?? 0; ?></h3>
                        <p>Pending Procedures</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-tasks"></i>
                    </div>
                    <a href="#" onclick="showPendingProcedures()" class="small-box-footer">
                        View Procedures <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Today's Assessments -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3 id="todayAssessmentsCount"><?php echo $stats['todays_assessments'] ?? 0; ?></h3>
                        <p>Today's Assessments</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-clipboard"></i>
                    </div>
                    <a href="#" onclick="showTodayAssessments()" class="small-box-footer">
                        View Assessments <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Critical Alerts -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3 id="criticalAlertsCount"><?php echo $stats['critical_alerts'] ?? 0; ?></h3>
                        <p>Critical Alerts</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-exclamation-triangle"></i>
                    </div>
                    <a href="#" onclick="showCriticalAlerts()" class="small-box-footer">
                        View Alerts <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Secondary Statistics Row -->
        <div class="row">
            <!-- Vital Signs Today -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-red">
                        <i class="fa fa-heartbeat"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Vital Signs Today</span>
                        <span class="info-box-number" id="vitalsToday"><?php echo $stats['vitals_today'] ?? 0; ?></span>
                        <div class="progress">
                            <div class="progress-bar" style="width: <?php echo min(100, ($stats['vitals_today'] ?? 0) * 2); ?>%"></div>
                        </div>
                        <span class="progress-description">Recorded measurements</span>
                    </div>
                </div>
            </div>

            <!-- Medications Given -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-blue">
                        <i class="fa fa-medkit"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Medications Given</span>
                        <span class="info-box-number" id="medicationsToday"><?php echo $stats['medications_today'] ?? 0; ?></span>
                        <div class="progress">
                            <div class="progress-bar" style="width: <?php echo min(100, ($stats['medications_today'] ?? 0) * 3); ?>%"></div>
                        </div>
                        <span class="progress-description">Administered today</span>
                    </div>
                </div>
            </div>

            <!-- Nursing Notes -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-green">
                        <i class="fa fa-edit"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Nursing Cardex</span>
                        <span class="info-box-number" id="nursingNotesToday"><?php echo $stats['nursing_notes_today'] ?? 0; ?></span>
                        <div class="progress">
                            <div class="progress-bar" style="width: <?php echo min(100, ($stats['nursing_notes_today'] ?? 0) * 4); ?>%"></div>
                        </div>
                        <span class="progress-description">Documentation completed</span>
                    </div>
                </div>
            </div>

            <!-- Active Staff -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-yellow">
                        <i class="fa fa-users"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Active Staff</span>
                        <span class="info-box-number"><?php echo count($nursing_staff ?? []); ?></span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 85%"></div>
                        </div>
                        <span class="progress-description">Available for duty</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content Row -->
        <div class="row">
            <!-- Patient Search and Management -->
            <div class="col-md-8">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-search"></i> Patient Search & Nursing Care
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-box-tool" onclick="refreshPatientSearch()">
                                <i class="fa fa-refresh"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <!-- Search Form -->
                        <div class="row">
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label for="patientSearch">Search Patient</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" id="patientSearch" 
                                               placeholder="Enter patient name, ID, or phone number..." 
                                               onkeyup="debounceSearch()" autocomplete="off">
                                        <span class="input-group-btn">
                                            <button class="btn btn-default" type="button" onclick="clearSearch()">
                                                <i class="fa fa-times"></i>
                                            </button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="searchType">Search Type</label>
                                    <select class="form-control" id="searchType" onchange="onSearchTypeChange()">
                                        <option value="all">All Fields</option>
                                        <option value="name">Name</option>
                                        <option value="id">Patient ID</option>
                                        <option value="phone">Phone</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Search Results -->
                        <div id="searchResultsContainer" style="display: none;">
                            <div class="row">
                                <div class="col-md-12">
                                    <h4><i class="fa fa-list"></i> Search Results <span id="resultCount" class="badge bg-blue"></span></h4>
                                    <div class="table-responsive" style="max-height: 400px; overflow-y: auto;">
                                        <table class="table table-striped table-hover table-condensed">
                                            <thead>
                                                <tr>
                                                    <th width="15%">Patient ID</th>
                                                    <th width="25%">Name</th>
                                                    <th width="20%">Age/Gender</th>
                                                    <th width="20%">Contact</th>
                                                    <th width="10%">Status</th>
                                                    <th width="10%">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody id="searchResultsBody">
                                                <!-- Search results will be populated here -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Selected Patient Details -->
                        <div id="selectedPatientContainer" style="display: none;">
                            <hr>
                            <div class="row">
                                <div class="col-md-12">
                                    <h4><i class="fa fa-user"></i> Selected Patient 
                                        <button class="btn btn-sm btn-warning pull-right" onclick="clearSelectedPatient()">
                                            <i class="fa fa-times"></i> Clear Selection
                                        </button>
                                    </h4>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="patient-info-card">
                                        <h5><i class="fa fa-info-circle"></i> Patient Information</h5>
                                        <table class="table table-bordered table-condensed">
                                            <tr><td><strong>Name:</strong></td><td id="selectedPatientName">-</td></tr>
                                            <tr><td><strong>ID:</strong></td><td id="selectedPatientId">-</td></tr>
                                            <tr><td><strong>Age:</strong></td><td id="selectedPatientAge">-</td></tr>
                                            <tr><td><strong>Gender:</strong></td><td id="selectedPatientGender">-</td></tr>
                                            <tr><td><strong>Contact:</strong></td><td id="selectedPatientContact">-</td></tr>
                                            <tr><td><strong>Blood Group:</strong></td><td id="selectedPatientBloodGroup">-</td></tr>
                                        </table>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="patient-status-card">
                                        <h5><i class="fa fa-hospital-o"></i> Hospital Status</h5>
                                        <table class="table table-bordered table-condensed">
                                            <tr><td><strong>Status:</strong></td><td id="selectedPatientStatus">-</td></tr>
                                            <tr><td><strong>Bed No:</strong></td><td id="selectedPatientBed">-</td></tr>
                                            <tr><td><strong>Admission Date:</strong></td><td id="selectedPatientAdmissionDate">-</td></tr>
                                            <tr><td><strong>Doctor:</strong></td><td id="selectedPatientDoctor">-</td></tr>
                                            <tr><td><strong>Department:</strong></td><td id="selectedPatientDepartment">-</td></tr>
                                            <tr><td><strong>Case ID:</strong></td><td id="selectedPatientCaseId">-</td></tr>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <!-- Nursing Action Buttons -->
                            <div class="row" style="margin-top: 15px;">
                                <div class="col-md-12">
                                    <div class="btn-group-justified">
                                        <div class="btn-group">
                                            <button class="btn btn-info" onclick="recordVitalSigns()">
                                                <i class="fa fa-heartbeat"></i> Record Vital Signs
                                            </button>
                                        </div>
                                        <div class="btn-group">
                                            <button class="btn btn-warning" onclick="addNursingNote()">
                                                <i class="fa fa-edit"></i> Add Nursing Kardex
                                            </button>
                                        </div>
                                        <div class="btn-group">
                                            <button class="btn btn-success" onclick="viewMedications()">
                                                <i class="fa fa-medkit"></i> View Medications
                                            </button>
                                        </div>
                                        <div class="btn-group">
                                            <button class="btn btn-primary" onclick="viewFullProfile()">
                                                <i class="fa fa-user"></i> Full Profile
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Recent Activities -->
                            <div class="row" style="margin-top: 20px;">
                                <div class="col-md-12">
                                    <h5><i class="fa fa-clock-o"></i> Recent Nursing Activities</h5>
                                    <div id="recentActivitiesContainer" class="activities-container">
                                        <div class="text-center">
                                            <i class="fa fa-spinner fa-spin"></i> Loading recent activities...
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sidebar - Quick Actions and Information -->
            <div class="col-md-4">
                <!-- Quick Actions -->
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-bolt"></i> Quick Actions
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-xs-12">
                                <a href="<?php echo base_url(); ?>admin/nursing/reports" class="btn btn-block btn-default btn-sm">
                                    <i class="fa fa-file-text-o"></i> Nursing Reports
                                </a>
                            </div>
                        </div>
                         <div class="row">
                            <div class="col-xs-12">
                                <a href="<?php echo base_url(); ?>admin/nursing/all_vital_signs" class="btn btn-block btn-default btn-sm">
                                    <i class="fa fa-file-text-o"></i> All Vital Signs
                                </a>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 10px;">
                            <div class="col-xs-12">
                                <button class="btn btn-block btn-default btn-sm" onclick="showProcedureTemplates()">
                                    <i class="fa fa-tasks"></i> Procedure Templates
                                </button>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 10px;">
                            <div class="col-xs-12">
                                <button class="btn btn-block btn-default btn-sm" onclick="showStaffWorkload()">
                                    <i class="fa fa-users"></i> Staff Workload
                                </button>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 10px;">
                            <div class="col-xs-12">
                                <a href="<?php echo base_url(); ?>admin/nursing/setup" class="btn btn-block btn-default btn-sm">
                                    <i class="fa fa-cogs"></i> System Setup
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Today's Summary -->
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-calendar"></i> Today's Summary
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" onclick="refreshTodaySummary()">
                                <i class="fa fa-refresh"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="summary-item">
                            <span class="summary-label">Vital Signs Recorded:</span>
                            <span class="summary-value" id="summaryVitals"><?php echo $stats['vitals_today'] ?? 0; ?></span>
                        </div>
                        <div class="summary-item">
                            <span class="summary-label">Nursing Kardexs Added:</span>
                            <span class="summary-value" id="summaryNotes"><?php echo $stats['nursing_notes_today'] ?? 0; ?></span>
                        </div>
                        <div class="summary-item">
                            <span class="summary-label">Medications Given:</span>
                            <span class="summary-value" id="summaryMeds"><?php echo $stats['medications_today'] ?? 0; ?></span>
                        </div>
                        <div class="summary-item">
                            <span class="summary-label">Assessments Done:</span>
                            <span class="summary-value" id="summaryAssessments"><?php echo $stats['todays_assessments'] ?? 0; ?></span>
                        </div>
                        <hr>
                        <div class="summary-item">
                            <span class="summary-label">Active IPD Patients:</span>
                            <span class="summary-value" id="summaryIPD"><?php echo $stats['active_ipd_patients'] ?? 0; ?></span>
                        </div>
                        <div class="summary-item">
                            <span class="summary-label">Critical Alerts:</span>
                            <span class="summary-value text-red" id="summaryAlerts"><?php echo $stats['critical_alerts'] ?? 0; ?></span>
                        </div>
                    </div>
                </div>

                <!-- System Status -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-info-circle"></i> System Status
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="status-item">
                            <i class="fa fa-check-circle text-green"></i>
                            <span>Nursing Module: Active</span>
                        </div>
                        <div class="status-item">
                            <i class="fa fa-check-circle text-green"></i>
                            <span>Database: Connected</span>
                        </div>
                        <div class="status-item">
                            <i class="fa fa-check-circle text-green"></i>
                            <span>Patient Search: Ready</span>
                        </div>
                        <div class="status-item">
                            <i class="fa fa-check-circle text-green"></i>
                            <span>Vital Signs: Ready</span>
                        </div>
                        <div class="status-item">
                            <i class="fa fa-check-circle text-green"></i>
                            <span>Nursing Kardex: Ready</span>
                        </div>
                        <div class="status-item">
                            <i class="fa fa-info-circle text-blue"></i>
                            <span>Last Updated: <span id="lastUpdated"><?php echo date('H:i:s'); ?></span></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Hidden Form Fields -->
<input type="hidden" id="selectedPatientId" value="">
<input type="hidden" id="selectedPatientIPDId" value="">
<input type="hidden" id="selectedPatientOPDId" value="">

<!-- Vital Signs Modal -->
<div class="modal fade" id="vitalSignsModal" tabindex="-1" role="dialog" aria-labelledby="vitalSignsModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="vitalSignsModalLabel">
                    <i class="fa fa-heartbeat"></i> Record Vital Signs
                </h4>
            </div>
            <form id="vitalSignsForm" onsubmit="return submitVitalSigns(event)">
                <div class="modal-body">
                    <div class="alert alert-info">
                        <i class="fa fa-info-circle"></i> 
                        Recording vital signs for: <strong id="vitalSignsPatientName">-</strong>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="vs_temperature">Temperature (C) <span class="text-red">*</span></label>
                                <input type="number" class="form-control" id="vs_temperature" name="temperature" 
                                       step="0.1" min="30" max="50" placeholder="37.5" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="vs_pulse_rate">Pulse Rate (bpm) <span class="text-red">*</span></label>
                                <input type="number" class="form-control" id="vs_pulse_rate" name="pulse_rate" 
                                       min="30" max="200" placeholder="80" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="vs_systolic_bp">Systolic BP (mmHg) <span class="text-red">*</span></label>
                                <input type="number" class="form-control" id="vs_systolic_bp" name="systolic_bp" 
                                       min="60" max="250" placeholder="120" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="vs_diastolic_bp">Diastolic BP (mmHg) <span class="text-red">*</span></label>
                                <input type="number" class="form-control" id="vs_diastolic_bp" name="diastolic_bp" 
                                       min="30" max="150" placeholder="80" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="vs_respiratory_rate">Respiratory Rate (breaths/min) <span class="text-red">*</span></label>
                                <input type="number" class="form-control" id="vs_respiratory_rate" name="respiratory_rate" 
                                       min="8" max="60" placeholder="16" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="vs_oxygen_saturation">Oxygen Saturation (%)</label>
                                <input type="number" class="form-control" id="vs_oxygen_saturation" name="oxygen_saturation" 
                                       min="70" max="100" placeholder="98">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="vs_weight">Weight (kg)</label>
                                <input type="number" class="form-control" id="vs_weight" name="weight" 
                                       step="0.1" min="1" max="300" placeholder="70">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="vs_height">Height (cm)</label>
                                <input type="number" class="form-control" id="vs_height" name="height" 
                                       min="30" max="250" placeholder="170">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="vs_pain_scale">Pain Scale (0-10)</label>
                                <select class="form-control" id="vs_pain_scale" name="pain_scale">
                                    <option value="">Select Pain Level</option>
                                    <option value="0">0 - No Pain</option>
                                    <option value="1">1 - Mild</option>
                                    <option value="2">2 - Mild</option>
                                    <option value="3">3 - Moderate</option>
                                    <option value="4">4 - Moderate</option>
                                    <option value="5">5 - Moderate</option>
                                    <option value="6">6 - Severe</option>
                                    <option value="7">7 - Severe</option>
                                    <option value="8">8 - Very Severe</option>
                                    <option value="9">9 - Very Severe</option>
                                    <option value="10">10 - Worst Pain</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="vs_notes">Clinical Notes</label>
                        <textarea class="form-control" id="vs_notes" name="notes" rows="3" 
                                  placeholder="Additional observations, patient condition, or clinical notes..."></textarea>
                    </div>
                    
                    <input type="hidden" id="vs_patient_id" name="patient_id">
                    <input type="hidden" id="vs_ipd_id" name="ipd_id">
                    <input type="hidden" id="vs_opd_id" name="opd_id">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">
                        <i class="fa fa-times"></i> Cancel
                    </button>
                    <button type="submit" class="btn btn-primary" id="vitalSignsSubmitBtn">
                        <i class="fa fa-save"></i> Record Vital Signs
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Pending Procedures Modal -->
<div class="modal fade" id="pendingProceduresModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-tasks"></i> Pending Procedures
                </h4>
            </div>
            <div class="modal-body">
                <div id="pendingProceduresContent">
                    <div class="text-center">
                        <i class="fa fa-spinner fa-spin fa-2x"></i>
                        <p>Loading pending procedures...</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" onclick="refreshPendingProcedures()">
                    <i class="fa fa-refresh"></i> Refresh
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Today's Assessments Modal -->
<div class="modal fade" id="todayAssessmentsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-clipboard"></i> Today's Assessments
                </h4>
            </div>
            <div class="modal-body">
                <div id="todayAssessmentsContent">
                    <div class="text-center">
                        <i class="fa fa-spinner fa-spin fa-2x"></i>
                        <p>Loading today's assessments...</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" onclick="refreshTodayAssessments()">
                    <i class="fa fa-refresh"></i> Refresh
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Critical Alerts Modal -->
<div class="modal fade" id="criticalAlertsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-exclamation-triangle"></i> Critical Alerts
                </h4>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning">
                    <i class="fa fa-warning"></i> 
                    Critical alerts require immediate attention and should be addressed promptly.
                </div>
                <div id="criticalAlertsContent">
                    <div class="text-center">
                        <i class="fa fa-spinner fa-spin fa-2x"></i>
                        <p>Loading critical alerts...</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" onclick="refreshCriticalAlerts()">
                    <i class="fa fa-refresh"></i> Refresh
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Procedure Templates Modal -->
<div class="modal fade" id="procedureTemplatesModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-tasks"></i> Procedure Templates
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Filter by Category</label>
                            <select class="form-control" id="templateCategoryFilter" onchange="filterTemplates()">
                                <option value="">All Categories</option>
                                <option value="Basic Care">Basic Care</option>
                                <option value="Assessment">Assessment</option>
                                <option value="Medication">Medication</option>
                                <option value="Wound Care">Wound Care</option>
                                <option value="Emergency">Emergency</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Search Templates</label>
                            <input type="text" class="form-control" id="templateSearch" 
                                   placeholder="Search by name..." onkeyup="searchTemplates()">
                        </div>
                    </div>
                </div>
                <div id="procedureTemplatesContent">
                    <div class="text-center">
                        <i class="fa fa-spinner fa-spin fa-2x"></i>
                        <p>Loading procedure templates...</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-success" onclick="createNewTemplate()">
                    <i class="fa fa-plus"></i> Create New Template
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Nursing Note Modal -->
<div class="modal fade" id="nursingNoteModal" tabindex="-1" role="dialog" aria-labelledby="nursingNoteModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="nursingNoteModalLabel">
                    <i class="fa fa-edit"></i> Add Nursing Kardex
                </h4>
            </div>
            <form id="nursingNoteForm" onsubmit="return submitNursingNote(event)">
                <div class="modal-body">
                    <div class="alert alert-info">
                        <i class="fa fa-info-circle"></i> 
                        Adding nursing kardex for: <strong id="nursingNotePatientName">-</strong>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="note_category">Note Category <span class="text-red">*</span></label>
                                <select class="form-control" id="note_category" name="note_category" required>
                                    <option value="">Select Category</option>
                                    <option value="assessment">Assessment</option>
                                    <option value="intervention">Intervention</option>
                                    <option value="observation">Observation</option>
                                    <option value="education">Patient Education</option>
                                    <option value="discharge">Discharge Planning</option>
                                    <option value="medication">Medication Administration</option>
                                    <option value="communication">Communication</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="note_priority">Priority Level</label>
                                <select class="form-control" id="note_priority" name="note_priority">
                                    <option value="routine">Routine</option>
                                    <option value="important">Important</option>
                                    <option value="urgent">Urgent</option>
                                    <option value="critical">Critical</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="nursing_note_text">Nursing Kardex <span class="text-red">*</span></label>
                        <textarea class="form-control" id="nursing_note_text" name="note" rows="6" 
                                  placeholder="Enter detailed nursing note using SOAP format if applicable..." required></textarea>
                        <small class="text-muted">
                            <strong>SOAP Format:</strong> Subjective, Objective, Assessment, Plan
                        </small>
                    </div>
                    
                    <div class="form-group">
                        <label for="note_followup">Follow-up Required</label>
                        <textarea class="form-control" id="note_followup" name="comment" rows="3" 
                                  placeholder="Any follow-up actions required, patient education provided, or additional comments..."></textarea>
                    </div>
                    
                    <input type="hidden" id="nn_patient_id" name="patient_id">
                    <input type="hidden" id="nn_ipd_id" name="ipd_id">
                    <input type="hidden" id="nn_opd_id" name="opd_id">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">
                        <i class="fa fa-times"></i> Cancel
                    </button>
                    <button type="submit" class="btn btn-primary" id="nursingNoteSubmitBtn">
                        <i class="fa fa-save"></i> Save Note
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Loading Overlay -->
<div id="loadingOverlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 9999;">
    <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); text-align: center; color: white;">
        <i class="fa fa-spinner fa-spin fa-3x"></i>
        <div style="margin-top: 15px; font-size: 18px;">Processing...</div>
    </div>
</div>

<!-- Custom CSS -->
<style>
    .patient-info-card, .patient-status-card {
        background: #f9f9f9;
        padding: 15px;
        border-radius: 5px;
        margin-bottom: 15px;
        border: 1px solid #ddd;
    }
    
    .patient-info-card h5, .patient-status-card h5 {
        margin-top: 0;
        color: #333;
        border-bottom: 2px solid #3c8dbc;
        padding-bottom: 5px;
    }
    
    .activities-container {
        max-height: 300px;
        overflow-y: auto;
        border: 1px solid #ddd;
        border-radius: 5px;
        padding: 10px;
        background: #fafafa;
    }
    
    .activity-item {
        padding: 8px 0;
        border-bottom: 1px solid #eee;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    
    .activity-item:last-child {
        border-bottom: none;
    }
    
    .activity-item i {
        margin-right: 8px;
        width: 16px;
        text-align: center;
    }
    
    .activity-time {
        font-size: 12px;
        color: #666;
    }
    
    .summary-item {
        display: flex;
        justify-content: space-between;
        padding: 5px 0;
        border-bottom: 1px solid #f0f0f0;
    }
    
    .summary-item:last-child {
        border-bottom: none;
    }
    
    .summary-label {
        font-weight: 500;
        color: #333;
    }
    
    .summary-value {
        font-weight: bold;
        color: #3c8dbc;
    }
    
    .status-item {
        padding: 5px 0;
        display: flex;
        align-items: center;
    }
    
    .status-item i {
        margin-right: 10px;
        width: 16px;
        text-align: center;
    }
    
    .table-condensed td {
        padding: 6px;
        vertical-align: middle;
    }
    
    .btn-group-justified {
        display: flex;
        width: 100%;
    }
    
    .btn-group-justified .btn-group {
        flex: 1;
        margin-right: 5px;
    }
    
    .btn-group-justified .btn-group:last-child {
        margin-right: 0;
    }
    
    .btn-group-justified .btn {
        width: 100%;
    }
    
    .search-loading {
        text-align: center;
        padding: 20px;
        color: #666;
    }
    
    .search-no-results {
        text-align: center;
        padding: 20px;
        color: #999;
    }
    
    .modal-header {
        background: #f5f5f5;
        border-bottom: 1px solid #ddd;
    }
    
    .modal-title {
        color: #333;
        font-weight: 600;
    }
    
    .form-group label {
        font-weight: 600;
        color: #333;
    }
    
    .text-red {
        color: #dd4b39 !important;
    }
    
    .alert {
        margin-bottom: 15px;
    }
    
    .table-hover tbody tr:hover {
        background-color: #f5f5f5;
    }
    
    .badge {
        font-size: 11px;
        padding: 3px 6px;
    }
    
    .input-group-btn .btn {
        height: 34px;
    }
    
    #searchResultsContainer {
        animation: fadeIn 0.3s ease-in-out;
    }
    
    #selectedPatientContainer {
        animation: slideDown 0.3s ease-in-out;
    }
    
    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }
    
    @keyframes slideDown {
        from { 
            opacity: 0;
            transform: translateY(-10px);
        }
        to { 
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .small-box .inner h3 {
        font-size: 38px;
        font-weight: bold;
        margin: 0;
    }
    
    .info-box .info-box-number {
        font-size: 28px;
        font-weight: bold;
    }
    
    .progress {
        height: 10px;
        margin-bottom: 5px;
    }
    
    .progress-bar {
        transition: width 0.6s ease;
    }
    
    @media (max-width: 768px) {
        .btn-group-justified {
            flex-direction: column;
        }
        
        .btn-group-justified .btn-group {
            margin-right: 0;
            margin-bottom: 5px;
        }
        
        .btn-group-justified .btn-group:last-child {
            margin-bottom: 0;
        }
        
        .patient-info-card, .patient-status-card {
            margin-bottom: 10px;
        }
        
        .table-responsive {
            font-size: 12px;
        }
    }
</style>

<!-- JavaScript -->
<script>
$(document).ready(function() {
    initializeNursingDashboard();
});

// Global variables
let searchTimeout = null;
let selectedPatientData = null;
let isSearching = false;

// Initialize dashboard
function initializeNursingDashboard() {
    console.log('Initializing Nursing Dashboard...');
    
    // Set up periodic refresh
    setInterval(refreshDashboardStats, 300000); // 5 minutes
    
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    // Set focus on search input
    $('#patientSearch').focus();
    
    console.log('Nursing Dashboard initialized successfully');
}

// Debounced search function
function debounceSearch() {
    clearTimeout(searchTimeout);
    const searchTerm = $('#patientSearch').val().trim();
    
    if (searchTerm.length < 2) {
        hideSearchResults();
        return;
    }
    
    searchTimeout = setTimeout(() => {
        performPatientSearch(searchTerm);
    }, 300);
}

// Perform patient search
function performPatientSearch(searchTerm) {
    if (isSearching) return;
    
    isSearching = true;
    const searchType = $('#searchType').val();
    
    // Show loading state
    showSearchLoading();
    
    $.ajax({
        url: '<?php echo base_url("admin/nursing/searchPatients"); ?>',
        type: 'POST',
        data: {
            search: searchTerm,
            search_type: searchType
        },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                displaySearchResults(response.patients);
                $('#resultCount').text(response.count);
            } else {
                showSearchError(response.message);
            }
        },
        error: function(xhr, status, error) {
            console.error('Search error:', error);
            showSearchError('Search failed. Please try again.');
        },
        complete: function() {
            isSearching = false;
        }
    });
}

// Show search loading state
function showSearchLoading() {
    $('#searchResultsContainer').show();
    $('#searchResultsBody').html(`
        <tr>
            <td colspan="6" class="search-loading">
                <i class="fa fa-spinner fa-spin"></i> Searching patients...
            </td>
        </tr>
    `);
}

// Display search results
function displaySearchResults(patients) {
    if (!patients || patients.length === 0) {
        $('#searchResultsBody').html(`
            <tr>
                <td colspan="6" class="search-no-results">
                    <i class="fa fa-search"></i> No patients found matching your search criteria.
                </td>
            </tr>
        `);
        return;
    }
    
    let html = '';
    patients.forEach(patient => {
        const patientId = patient.patient_unique_id || patient.id;
        const patientName = patient.patient_name || 'N/A';
        const age = patient.age || 'N/A';
        const gender = patient.gender || 'N/A';
        const contact = patient.mobileno || 'N/A';
        const status = patient.is_ipd ? 
            '<span class="label label-success">IPD</span>' : 
            '<span class="label label-info">OPD</span>';
        
        html += `
            <tr class="patient-row" data-patient-id="${patient.id}">
                <td>${patientId}</td>
                <td><strong>${patientName}</strong></td>
                <td>${age} / ${gender}</td>
                <td>${contact}</td>
                <td>${status}</td>
                <td>
                    <button class="btn btn-sm btn-primary" onclick="selectPatient(${patient.id})">
                        <i class="fa fa-user"></i> Select
                    </button>
                </td>
            </tr>
        `;
    });
    
    $('#searchResultsBody').html(html);
    $('#searchResultsContainer').show();
}

// Show search error
function showSearchError(message) {
    $('#searchResultsBody').html(`
        <tr>
            <td colspan="6" class="text-center text-danger">
                <i class="fa fa-exclamation-triangle"></i> ${message}
            </td>
        </tr>
    `);
}

// Hide search results
function hideSearchResults() {
    $('#searchResultsContainer').hide();
    $('#searchResultsBody').empty();
}

// Select patient
function selectPatient(patientId) {
    showLoading();
    
    $.ajax({
        url: '<?php echo base_url("admin/nursing/getPatientDetails"); ?>',
        type: 'POST',
        data: { patient_id: patientId },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                selectedPatientData = response.patient;
                displaySelectedPatient(response.patient);
                loadRecentActivities(patientId);
                hideSearchResults();
                showSuccessAlert('Patient selected successfully');
            } else {
                showErrorAlert(response.message);
            }
        },
        error: function() {
            showErrorAlert('Failed to load patient details');
        },
        complete: function() {
            hideLoading();
        }
    });
}

// Display selected patient
function displaySelectedPatient(patient) {
    // Store patient data
    $('#selectedPatientId').val(patient.id);
    $('#selectedPatientIPDId').val(patient.ipd_id || '');
    $('#selectedPatientOPDId').val(patient.opd_id || '');
    
    // Update patient information
    $('#selectedPatientName').text(patient.patient_name || 'N/A');
    $('#selectedPatientId').text(patient.patient_unique_id || patient.id);
    $('#selectedPatientAge').text(patient.age_display || 'N/A');
    $('#selectedPatientGender').text(patient.gender || 'N/A');
    $('#selectedPatientContact').text(patient.mobileno || 'N/A');
    $('#selectedPatientBloodGroup').text(patient.blood_group || 'N/A');
    
    // Update hospital status
    if (patient.is_ipd) {
        $('#selectedPatientStatus').html('<span class="label label-success">IPD Patient</span>');
        $('#selectedPatientBed').text(patient.bed_no || 'N/A');
        $('#selectedPatientAdmissionDate').text(patient.admission_date || 'N/A');
        $('#selectedPatientDoctor').text(patient.doctor_name || 'N/A');
        $('#selectedPatientDepartment').text(patient.department || 'N/A');
        $('#selectedPatientCaseId').text(patient.case_reference_id || 'N/A');
    } else {
        $('#selectedPatientStatus').html('<span class="label label-info">OPD Patient</span>');
        $('#selectedPatientBed').text('N/A');
        $('#selectedPatientAdmissionDate').text('N/A');
        $('#selectedPatientDoctor').text(patient.doctor_name || 'N/A');
        $('#selectedPatientDepartment').text('OPD');
        $('#selectedPatientCaseId').text(patient.opd_no || 'N/A');
    }
    
    // Show selected patient container
    $('#selectedPatientContainer').show();
    
    // Clear search input
    $('#patientSearch').val('');
}

// Load recent activities
function loadRecentActivities(patientId) {
    $('#recentActivitiesContainer').html(`
        <div class="text-center">
            <i class="fa fa-spinner fa-spin"></i> Loading recent activities...
        </div>
    `);
    
    // Simulate loading recent activities
    setTimeout(() => {
        $('#recentActivitiesContainer').html(`
            <div class="activity-item">
                <div>
                    <i class="fa fa-info-circle text-blue"></i>
                    <span>Patient selected for nursing care</span>
                </div>
                <div class="activity-time">Just now</div>
            </div>
            <div class="activity-item">
                <div>
                    <i class="fa fa-user text-green"></i>
                    <span>Ready for vital signs recording</span>
                </div>
                <div class="activity-time">Now</div>
            </div>
            <div class="activity-item">
                <div>
                    <i class="fa fa-edit text-orange"></i>
                    <span>Ready for nursing documentation</span>
                </div>
                <div class="activity-time">Now</div>
            </div>
        `);
    }, 1000);
}

// Clear selected patient
function clearSelectedPatient() {
    selectedPatientData = null;
    $('#selectedPatientId').val('');
    $('#selectedPatientIPDId').val('');
    $('#selectedPatientOPDId').val('');
    $('#selectedPatientContainer').hide();
    $('#patientSearch').focus();
}

// Clear search
function clearSearch() {
    $('#patientSearch').val('');
    hideSearchResults();
    $('#patientSearch').focus();
}

// Refresh patient search
function refreshPatientSearch() {
    const searchTerm = $('#patientSearch').val().trim();
    if (searchTerm.length >= 2) {
        performPatientSearch(searchTerm);
    }
}

// Search type change handler
function onSearchTypeChange() {
    const searchTerm = $('#patientSearch').val().trim();
    if (searchTerm.length >= 2) {
        performPatientSearch(searchTerm);
    }
}

// Record vital signs
function recordVitalSigns() {
    if (!selectedPatientData) {
        showWarningAlert('Please select a patient first');
        return;
    }
    
    // Populate modal
    $('#vitalSignsPatientName').text(selectedPatientData.patient_name);
    $('#vs_patient_id').val(selectedPatientData.id);
    $('#vs_ipd_id').val(selectedPatientData.ipd_id || '');
    $('#vs_opd_id').val(selectedPatientData.opd_id || '');
    
    // Show modal
    $('#vitalSignsModal').modal('show');
}

// Submit vital signs
function submitVitalSigns(event) {
    event.preventDefault();
    
    const submitBtn = $('#vitalSignsSubmitBtn');
    const originalText = submitBtn.html();
    
    submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
    
    $.ajax({
        url: '<?php echo base_url("admin/nursing/add_vital_signs"); ?>',
        type: 'POST',
        data: $('#vitalSignsForm').serialize(),
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                showSuccessAlert('Vital signs recorded successfully');
                $('#vitalSignsModal').modal('hide');
                $('#vitalSignsForm')[0].reset();
                refreshDashboardStats();
                refreshTodaySummary();
                
                // Update recent activities
                if (selectedPatientData) {
                    loadRecentActivities(selectedPatientData.id);
                }
            } else {
                showErrorAlert(response.message);
            }
        },
        error: function() {
            showErrorAlert('Failed to record vital signs');
        },
        complete: function() {
            submitBtn.prop('disabled', false).html(originalText);
        }
    });
    
    return false;
}

// Add nursing note
function addNursingNote() {
    if (!selectedPatientData) {
        showWarningAlert('Please select a patient first');
        return;
    }
    
    // Populate modal
    $('#nursingNotePatientName').text(selectedPatientData.patient_name);
    $('#nn_patient_id').val(selectedPatientData.id);
    $('#nn_ipd_id').val(selectedPatientData.ipd_id || '');
    $('#nn_opd_id').val(selectedPatientData.opd_id || '');
    
    // Show modal
    $('#nursingNoteModal').modal('show');
}

// Submit nursing note
function submitNursingNote(event) {
    event.preventDefault();
    
    const submitBtn = $('#nursingNoteSubmitBtn');
    const originalText = submitBtn.html();
    
    submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
    
    $.ajax({
        url: '<?php echo base_url("admin/nursing/add_nurse_note"); ?>',
        type: 'POST',
        data: $('#nursingNoteForm').serialize(),
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                showSuccessAlert('Nursing Kardex added successfully');
                $('#nursingNoteModal').modal('hide');
                $('#nursingNoteForm')[0].reset();
                refreshDashboardStats();
                refreshTodaySummary();
                
                // Update recent activities
                if (selectedPatientData) {
                    loadRecentActivities(selectedPatientData.id);
                }
            } else {
                showErrorAlert(response.message);
            }
        },
        error: function() {
            showErrorAlert('Failed to add nursing kardex');
        },
        complete: function() {
            submitBtn.prop('disabled', false).html(originalText);
        }
    });
    
    return false;
}

// View vital signs for selected patient
function viewVitalSigns() {
    if (!selectedPatientData) {
        showWarningAlert('Please select a patient first');
        return;
    }
    
    window.location.href = '<?php echo base_url("admin/nursing/vital_signs/"); ?>' + selectedPatientData.id;
}

// View medications
function viewMedications() {
    if (!selectedPatientData) {
        showWarningAlert('Please select a patient first');
        return;
    }
    
    window.location.href = '<?php echo base_url("admin/patient/profile/"); ?>' + selectedPatientData.id;
}

// View full profile
function viewFullProfile() {
    if (!selectedPatientData) {
        showWarningAlert('Please select a patient first');
        return;
    }
    
    window.location.href = '<?php echo base_url("admin/nursing/patient_profile/"); ?>' + selectedPatientData.id;
}

// Quick action functions
function showPendingProcedures() {
    showInfoAlert('Pending procedures management will be available soon');
}

function showTodayAssessments() {
    showInfoAlert('Today\'s assessments report will be available soon');
}

function showCriticalAlerts() {
    showInfoAlert('Critical alerts monitoring will be available soon');
}

function showProcedureTemplates() {
    showInfoAlert('Procedure templates management will be available soon');
}

function showStaffWorkload() {
    showInfoAlert('Staff workload analysis will be available soon');
}

// Refresh functions
function refreshDashboardStats() {
    console.log('Refreshing dashboard statistics...');
    
    // Update last updated time
    $('#lastUpdated').text(new Date().toLocaleTimeString());
    
    // In a real implementation, this would fetch fresh data
    // For now, we'll just show a brief indicator
    $('.small-box, .info-box').addClass('pulse');
    setTimeout(() => {
        $('.small-box, .info-box').removeClass('pulse');
    }, 1000);
}

function refreshTodaySummary() {
    console.log('Refreshing today\'s summary...');
    
    // In a real implementation, this would fetch fresh summary data
    // For now, we'll just update the last updated time
    $('#lastUpdated').text(new Date().toLocaleTimeString());
}

// Loading functions
function showLoading() {
    $('#loadingOverlay').show();
}

function hideLoading() {
    $('#loadingOverlay').hide();
}

// Alert functions
function showSuccessAlert(message) {
    showAlert(message, 'success');
}

function showErrorAlert(message) {
    showAlert(message, 'danger');
}

function showWarningAlert(message) {
    showAlert(message, 'warning');
}

function showInfoAlert(message) {
    showAlert(message, 'info');
}

function showAlert(message, type) {
    const alertClass = `alert-${type}`;
    const iconClass = type === 'success' ? 'fa-check-circle' : 
                     type === 'danger' ? 'fa-exclamation-circle' : 
                     type === 'warning' ? 'fa-warning' : 'fa-info-circle';
    
    const alertHtml = `
        <div class="alert ${alertClass} alert-dismissible" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <i class="fa ${iconClass}"></i> ${message}
        </div>
    `;
    
    // Remove existing alerts
    $('#alertContainer .alert').remove();
    
    // Add new alert
    $('#alertContainer').html(alertHtml);
    
    // Auto-remove after 5 seconds for success and info
    if (type === 'success' || type === 'info') {
        setTimeout(() => {
            $('#alertContainer .alert').fadeOut();
        }, 5000);
    }
    
    // Scroll to top to show alert
    $('html, body').animate({ scrollTop: 0 }, 300);
}

// Add pulse animation CSS
$('<style>').prop('type', 'text/css').html(`
    .pulse {
        animation: pulse 1s ease-in-out;
    }
    
    @keyframes pulse {
        0% { transform: scale(1); }
        50% { transform: scale(1.05); }
        100% { transform: scale(1); }
    }
`).appendTo('head');
</script>