<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title><?php echo $report_title; ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            color: #333;
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #3c8dbc;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        .header h1 {
            color: #3c8dbc;
            margin: 0;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        .stats-section {
            display: flex;
            justify-content: space-around;
            margin-bottom: 30px;
            background: #f9f9f9;
            padding: 20px;
            border-radius: 5px;
        }
        .stat-box {
            text-align: center;
            padding: 15px;
            background: white;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            min-width: 120px;
        }
        .stat-number {
            font-size: 24px;
            font-weight: bold;
            color: #3c8dbc;
        }
        .stat-label {
            font-size: 12px;
            color: #666;
            margin-top: 5px;
        }
        .section {
            margin-bottom: 30px;
        }
        .section h2 {
            color: #3c8dbc;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .no-data {
            text-align: center;
            color: #999;
            font-style: italic;
            padding: 20px;
        }
        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 12px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 20px;
        }
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <!-- Report Header -->
    <div class="header">
        <h1><?php echo $report_title; ?></h1>
        <p>Generated on: <?php echo date('F j, Y \a\t g:i A'); ?></p>
        <p>Report Date: <?php echo date('F j, Y', strtotime($date)); ?></p>
    </div>

    <!-- Statistics Overview -->
    <div class="stats-section">
        <div class="stat-box">
            <div class="stat-number"><?php echo $stats['vital_signs'] ?? 0; ?></div>
            <div class="stat-label">Vital Signs Recorded</div>
        </div>
        <div class="stat-box">
            <div class="stat-number"><?php echo $stats['procedures'] ?? 0; ?></div>
            <div class="stat-label">Procedures Completed</div>
        </div>
        <div class="stat-box">
            <div class="stat-number"><?php echo $stats['nursing_notes'] ?? 0; ?></div>
            <div class="stat-label">Nursing Notes</div>
        </div>
        <div class="stat-box">
            <div class="stat-number"><?php echo $stats['assessments'] ?? 0; ?></div>
            <div class="stat-label">Assessments Done</div>
        </div>
    </div>

    <!-- Vital Signs Section -->
    <div class="section">
        <h2>Vital Signs Recorded</h2>
        <?php if (!empty($vital_signs)): ?>
            <table>
                <thead>
                    <tr>
                        <th>Time</th>
                        <th>Patient</th>
                        <th>Temperature</th>
                        <th>Blood Pressure</th>
                        <th>Pulse</th>
                        <th>Respiratory Rate</th>
                        <th>O2 Saturation</th>
                        <th>Recorded By</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($vital_signs as $vs): ?>
                        <tr>
                            <td><?php echo date('H:i', strtotime($vs['recorded_at'])); ?></td>
                            <td><?php echo $vs['patient_name'] . ' (' . $vs['patient_unique_id'] . ')'; ?></td>
                            <td><?php echo $vs['temperature'] ? $vs['temperature'] . '°C' : '-'; ?></td>
                            <td><?php echo ($vs['systolic_bp'] && $vs['diastolic_bp']) ? $vs['systolic_bp'] . '/' . $vs['diastolic_bp'] : '-'; ?></td>
                            <td><?php echo $vs['pulse_rate'] ? $vs['pulse_rate'] . ' bpm' : '-'; ?></td>
                            <td><?php echo $vs['respiratory_rate'] ? $vs['respiratory_rate'] . '/min' : '-'; ?></td>
                            <td><?php echo $vs['oxygen_saturation'] ? $vs['oxygen_saturation'] . '%' : '-'; ?></td>
                            <td><?php echo $vs['staff_name'] ?? 'Unknown'; ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="no-data">No vital signs recorded today</div>
        <?php endif; ?>
    </div>

    <!-- Nursing Notes Section -->
    <div class="section">
        <h2>Nursing Notes</h2>
        <?php if (!empty($nursing_notes)): ?>
            <table>
                <thead>
                    <tr>
                        <th>Time</th>
                        <th>Patient</th>
                        <th>Note</th>
                        <th>Follow-up</th>
                        <th>Staff</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($nursing_notes as $note): ?>
                        <tr>
                            <td><?php echo date('H:i', strtotime($note['date'])); ?></td>
                            <td><?php echo $note['patient_name'] . ' (' . $note['patient_unique_id'] . ')'; ?></td>
                            <td><?php echo substr($note['note'], 0, 100) . (strlen($note['note']) > 100 ? '...' : ''); ?></td>
                            <td><?php echo $note['comment'] ? substr($note['comment'], 0, 50) . (strlen($note['comment']) > 50 ? '...' : '') : '-'; ?></td>
                            <td><?php echo $note['staff_name'] ?? 'Unknown'; ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="no-data">No nursing notes recorded today</div>
        <?php endif; ?>
    </div>

    <!-- Procedures Section -->
    <div class="section">
        <h2>Procedures Completed</h2>
        <?php if (!empty($procedures)): ?>
            <table>
                <thead>
                    <tr>
                        <th>Time</th>
                        <th>Patient</th>
                        <th>Procedure</th>
                        <th>Type</th>
                        <th>Status</th>
                        <th>Duration</th>
                        <th>Performed By</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($procedures as $proc): ?>
                        <tr>
                            <td><?php echo date('H:i', strtotime($proc['performed_at'])); ?></td>
                            <td><?php echo $proc['patient_name'] . ' (' . $proc['patient_unique_id'] . ')'; ?></td>
                            <td><?php echo $proc['procedure_name']; ?></td>
                            <td><?php echo ucfirst(str_replace('_', ' ', $proc['procedure_type'])); ?></td>
                            <td><?php echo ucfirst(str_replace('_', ' ', $proc['status'])); ?></td>
                            <td><?php echo $proc['duration_minutes'] ? $proc['duration_minutes'] . ' min' : '-'; ?></td>
                            <td><?php echo $proc['staff_name'] ?? 'Unknown'; ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="no-data">No procedures completed today</div>
        <?php endif; ?>
    </div>

    <!-- Medications Section -->
    <div class="section">
        <h2>Medications Administered</h2>
        <?php if (!empty($medications)): ?>
            <table>
                <thead>
                    <tr>
                        <th>Time</th>
                        <th>Patient</th>
                        <th>Medication</th>
                        <th>Dosage</th>
                        <th>Route</th>
                        <th>Given By</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($medications as $med): ?>
                        <tr>
                            <td><?php echo date('H:i', strtotime($med['date'])); ?></td>
                            <td><?php echo $med['patient_name'] . ' (' . $med['patient_unique_id'] . ')'; ?></td>
                            <td><?php echo $med['medicine_name'] ?? 'N/A'; ?></td>
                            <td><?php echo $med['dosage'] ?? 'N/A'; ?></td>
                            <td><?php echo $med['route'] ?? 'N/A'; ?></td>
                            <td><?php echo $med['staff_name'] ?? 'Unknown'; ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="no-data">No medications administered today</div>
        <?php endif; ?>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p>This report was automatically generated by the Hospital Management System</p>
        <p>Nursing Module - Daily Activity Report</p>
        <div class="no-print" style="margin-top: 20px;">
            <button onclick="window.print()" style="padding: 10px 20px; background: #3c8dbc; color: white; border: none; border-radius: 3px; cursor: pointer;">
                Print Report
            </button>
            <button onclick="window.close()" style="padding: 10px 20px; background: #666; color: white; border: none; border-radius: 3px; cursor: pointer; margin-left: 10px;">
                Close
            </button>
        </div>
    </div>

    <script>
        // Auto-print when page loads (optional)
        // window.onload = function() { window.print(); };
    </script>
</body>
</html>