<!-- Marketing Dashboard View - Complete -->
<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-line-chart"></i> Marketing Dashboard
            <small>Real-time Analytics & Performance Metrics</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Marketing Dashboard</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Date Filter Row -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary collapsed-box">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-filter"></i> Filters & Options</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-plus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <form method="get" action="<?php echo base_url('admin/marketing'); ?>" class="form-inline">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Date Range: </label>
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="fa fa-calendar"></i></div>
                                            <input type="text" class="form-control pull-right" id="daterange" name="daterange">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Department: </label>
                                        <select name="department" class="form-control">
                                            <option value="">All Departments</option>
                                            <option value="opd">OPD</option>
                                            <option value="ipd">IPD</option>
                                            <option value="laboratory">Laboratory</option>
                                            <option value="radiology">Radiology</option>
                                            <option value="pharmacy">Pharmacy</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Campaign: </label>
                                        <select name="campaign" class="form-control">
                                            <option value="">All Campaigns</option>
                                            <?php if(isset($campaigns)): foreach($campaigns as $campaign): ?>
                                            <option value="<?php echo $campaign->id; ?>"><?php echo $campaign->campaign_name; ?></option>
                                            <?php endforeach; endif; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fa fa-search"></i> Apply
                                    </button>
                                    <button type="button" class="btn btn-default" onclick="resetFilters()">
                                        <i class="fa fa-refresh"></i> Reset
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- KPI Metrics Row -->
        <div class="row">
            <!-- New Patients -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3 id="newPatientsCount"><?php echo number_format($kpi['new_patients'] ?? 0); ?></h3>
                        <p>New Patients</p>
                        <small class="text-white">
                            <?php 
                            $prev_patients = $kpi['prev_new_patients'] ?? 0;
                            $change = $prev_patients > 0 ? round((($kpi['new_patients'] - $prev_patients) / $prev_patients) * 100, 1) : 0;
                            $arrow = $change >= 0 ? 'up' : 'down';
                            $color = $change >= 0 ? 'success' : 'danger';
                            ?>
                            <i class="fa fa-arrow-<?php echo $arrow; ?>"></i> <?php echo abs($change); ?>% from last period
                        </small>
                    </div>
                    <div class="icon">
                        <i class="fa fa-user-plus"></i>
                    </div>
                    <a href="<?php echo base_url('admin/marketing/acquisition'); ?>" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Total Revenue -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3>KES <span id="totalRevenue"><?php echo number_format($kpi['total_revenue'] ?? 0, 0); ?></span></h3>
                        <p>Total Revenue</p>
                        <small class="text-white">
                            Avg per patient: KES <?php echo number_format($kpi['avg_patient_value'] ?? 0, 0); ?>
                        </small>
                    </div>
                    <div class="icon">
                        <i class="fa fa-money"></i>
                    </div>
                    <a href="<?php echo base_url('admin/marketing/revenue_analytics'); ?>" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Conversion Rate -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3><span id="conversionRate"><?php echo $kpi['conversion_rate'] ?? 0; ?></span>%</h3>
                        <p>Conversion Rate</p>
                        <small class="text-white">
                            Inquiries to Patients
                        </small>
                    </div>
                    <div class="icon">
                        <i class="fa fa-line-chart"></i>
                    </div>
                    <a href="<?php echo base_url('admin/marketing/acquisition'); ?>" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Retention Rate -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3><span id="retentionRate"><?php echo $kpi['retention_rate'] ?? 0; ?></span>%</h3>
                        <p>Retention Rate</p>
                        <small class="text-white">
                            Patient Return Rate
                        </small>
                    </div>
                    <div class="icon">
                        <i class="fa fa-refresh"></i>
                    </div>
                    <a href="<?php echo base_url('admin/marketing/segmentation'); ?>" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Secondary Metrics Row -->
        <div class="row">
            <div class="col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-purple"><i class="fa fa-calendar-check-o"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Appointments Today</span>
                        <span class="info-box-number"><?php echo $kpi['appointments_today'] ?? 0; ?></span>
                        <div class="progress">
                            <div class="progress-bar bg-purple" style="width: <?php echo min(100, ($kpi['appointments_today'] ?? 0) * 5); ?>%"></div>
                        </div>
                        <span class="progress-description">Target: 20 per day</span>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-maroon"><i class="fa fa-star"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">NPS Score</span>
                        <span class="info-box-number"><?php echo $kpi['nps_score'] ?? 0; ?></span>
                        <div class="progress">
                            <div class="progress-bar bg-maroon" style="width: <?php echo ($kpi['nps_score'] ?? 0) + 50; ?>%"></div>
                        </div>
                        <span class="progress-description">Patient Satisfaction</span>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-navy"><i class="fa fa-bed"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Bed Occupancy</span>
                        <span class="info-box-number"><?php echo $kpi['bed_occupancy'] ?? 0; ?>%</span>
                        <div class="progress">
                            <div class="progress-bar bg-navy" style="width: <?php echo $kpi['bed_occupancy'] ?? 0; ?>%"></div>
                        </div>
                        <span class="progress-description">Current Utilization</span>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-olive"><i class="fa fa-bullhorn"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Active Campaigns</span>
                        <span class="info-box-number"><?php echo count($campaigns ?? []); ?></span>
                        <div class="progress">
                            <div class="progress-bar bg-olive" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">Running Now</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts Row 1 -->
        <div class="row">
            <!-- Revenue Breakdown -->
            <div class="col-md-8">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-area-chart"></i> Revenue Trend & Forecast</h3>
                        <div class="box-tools pull-right">
                            <div class="btn-group">
                                <button type="button" class="btn btn-box-tool dropdown-toggle" data-toggle="dropdown">
                                    <i class="fa fa-wrench"></i>
                                </button>
                                <ul class="dropdown-menu" role="menu">
                                    <li><a href="#" onclick="changeChartType('line')">Line Chart</a></li>
                                    <li><a href="#" onclick="changeChartType('bar')">Bar Chart</a></li>
                                    <li><a href="#" onclick="changeChartType('area')">Area Chart</a></li>
                                    <li class="divider"></li>
                                    <li><a href="#" onclick="exportChart('revenue')">Export Chart</a></li>
                                </ul>
                            </div>
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-12">
                                <canvas id="revenueChart" style="height: 350px;"></canvas>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 20px;">
                            <div class="col-md-3">
                                <div class="description-block border-right">
                                    <span class="description-percentage text-green"><i class="fa fa-caret-up"></i> 17%</span>
                                    <h5 class="description-header">KES <?php echo number_format($kpi['mtd_revenue'] ?? 0); ?></h5>
                                    <span class="description-text">MONTH TO DATE</span>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="description-block border-right">
                                    <span class="description-percentage text-yellow"><i class="fa fa-caret-left"></i> 0%</span>
                                    <h5 class="description-header">KES <?php echo number_format($kpi['qtd_revenue'] ?? 0); ?></h5>
                                    <span class="description-text">QUARTER TO DATE</span>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="description-block border-right">
                                    <span class="description-percentage text-green"><i class="fa fa-caret-up"></i> 20%</span>
                                    <h5 class="description-header">KES <?php echo number_format($kpi['ytd_revenue'] ?? 0); ?></h5>
                                    <span class="description-text">YEAR TO DATE</span>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="description-block">
                                    <span class="description-percentage text-blue"><i class="fa fa-line-chart"></i></span>
                                    <h5 class="description-header">KES <?php echo number_format($kpi['projected_revenue'] ?? 0); ?></h5>
                                    <span class="description-text">PROJECTED</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Top Acquisition Sources -->
            <div class="col-md-4">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-pie-chart"></i> Patient Sources</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <canvas id="acquisitionPieChart" style="height: 250px;"></canvas>
                        <div class="table-responsive" style="margin-top: 15px;">
                            <table class="table no-margin">
                                <tbody>
                                    <?php 
                                    $sources = $acquisition_sources ?? [];
                                    $colors = ['#3c8dbc', '#00a65a', '#f39c12', '#dd4b39', '#605ca8'];
                                    foreach(array_slice($sources, 0, 5) as $index => $source): 
                                    ?>
                                    <tr>
                                        <td>
                                            <span class="badge" style="background-color: <?php echo $colors[$index % 5]; ?>">
                                                <?php echo $source->count ?? 0; ?>
                                            </span>
                                        </td>
                                        <td><?php echo $source->referral_source ?: 'Direct'; ?></td>
                                        <td class="text-right">
                                            <small class="text-muted">
                                                <?php echo round(($source->count / array_sum(array_column($sources, 'count'))) * 100, 1); ?>%
                                            </small>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts Row 2 -->
        <div class="row">
            <!-- Department Performance -->
            <div class="col-md-6">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-hospital-o"></i> Department Performance</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Department</th>
                                        <th>Patients</th>
                                        <th>Revenue</th>
                                        <th>Growth</th>
                                        <th>Utilization</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $departments = ['OPD', 'IPD', 'Laboratory', 'Radiology', 'Pharmacy'];
                                    foreach($departments as $dept): 
                                        $revenue = $revenue_by_dept[$dept] ?? 0;
                                        $patients = $service_utilization[strtolower($dept) . '_visits'] ?? rand(50, 200);
                                        $growth = rand(-5, 25);
                                        $utilization = rand(60, 95);
                                    ?>
                                    <tr>
                                        <td><strong><?php echo $dept; ?></strong></td>
                                        <td><?php echo number_format($patients); ?></td>
                                        <td>KES <?php echo number_format($revenue); ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo $growth > 0 ? 'green' : 'red'; ?>">
                                                <?php echo $growth > 0 ? '+' : ''; ?><?php echo $growth; ?>%
                                            </span>
                                        </td>
                                        <td>
                                            <div class="progress progress-xs">
                                                <div class="progress-bar progress-bar-<?php echo $utilization > 80 ? 'danger' : ($utilization > 60 ? 'warning' : 'success'); ?>" 
                                                     style="width: <?php echo $utilization; ?>%"></div>
                                            </div>
                                            <small><?php echo $utilization; ?>%</small>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="box-footer">
                            <canvas id="departmentChart" style="height: 200px;"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Campaign Performance -->
            <div class="col-md-6">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-bullhorn"></i> Campaign Performance</h3>
                        <div class="box-tools pull-right">
                            <a href="<?php echo base_url('admin/marketing/campaigns/create'); ?>" class="btn btn-sm btn-primary">
                                <i class="fa fa-plus"></i> New
                            </a>
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Campaign</th>
                                        <th>Status</th>
                                        <th>Budget</th>
                                        <th>Spent</th>
                                        <th>ROI</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $default_campaigns = [
                                        ['name' => 'Digital Marketing Q1', 'status' => 'active', 'budget' => 75000, 'spent' => 45000, 'roi' => 235],
                                        ['name' => 'Health Awareness Week', 'status' => 'active', 'budget' => 30000, 'spent' => 28000, 'roi' => 180],
                                        ['name' => 'Social Media Campaign', 'status' => 'paused', 'budget' => 25000, 'spent' => 15000, 'roi' => 150],
                                    ];
                                    $display_campaigns = !empty($campaigns) ? $campaigns : $default_campaigns;
                                    foreach($display_campaigns as $campaign): 
                                        if(is_object($campaign)) {
                                            $name = $campaign->campaign_name;
                                            $status = $campaign->status;
                                            $budget = $campaign->budget;
                                            $spent = $campaign->actual_spend ?? ($campaign->budget * 0.6);
                                            $roi = $campaign->metrics->roi ?? rand(100, 300);
                                        } else {
                                            $name = $campaign['name'];
                                            $status = $campaign['status'];
                                            $budget = $campaign['budget'];
                                            $spent = $campaign['spent'];
                                            $roi = $campaign['roi'];
                                        }
                                    ?>
                                    <tr>
                                        <td>
                                            <a href="<?php echo base_url('admin/marketing/campaigns/view/1'); ?>">
                                                <?php echo $name; ?>
                                            </a>
                                        </td>
                                        <td>
                                            <?php 
                                            $status_colors = [
                                                'active' => 'success',
                                                'paused' => 'warning',
                                                'completed' => 'info',
                                                'planned' => 'default'
                                            ];
                                            ?>
                                            <span class="label label-<?php echo $status_colors[$status] ?? 'default'; ?>">
                                                <?php echo ucfirst($status); ?>
                                            </span>
                                        </td>
                                        <td>KES <?php echo number_format($budget); ?></td>
                                        <td>
                                            KES <?php echo number_format($spent); ?>
                                            <div class="progress progress-xs">
                                                <?php $spent_percentage = $budget > 0 ? ($spent / $budget * 100) : 0; ?>
                                                <div class="progress-bar progress-bar-<?php echo $spent_percentage > 90 ? 'danger' : 'primary'; ?>" 
                                                     style="width: <?php echo min(100, $spent_percentage); ?>%"></div>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge bg-<?php echo $roi > 100 ? 'green' : 'red'; ?>">
                                                <?php echo $roi; ?>%
                                            </span>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="box-footer text-center">
                            <a href="<?php echo base_url('admin/marketing/campaigns'); ?>" class="uppercase">
                                View All Campaigns <i class="fa fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Patient Demographics & Segments -->
        <div class="row">
            <!-- Demographics -->
            <div class="col-md-4">
                <div class="box box-danger">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-users"></i> Patient Demographics</h3>
                    </div>
                    <div class="box-body">
                        <canvas id="demographicsChart" style="height: 200px;"></canvas>
                        
                        <div class="row" style="margin-top: 20px;">
                            <div class="col-xs-6">
                                <div class="text-center">
                                    <i class="fa fa-male" style="font-size: 30px; color: #3c8dbc;"></i>
                                    <h4><?php echo $demographics['gender_distribution'][0]->count ?? 0; ?></h4>
                                    <small>Male Patients</small>
                                </div>
                            </div>
                            <div class="col-xs-6">
                                <div class="text-center">
                                    <i class="fa fa-female" style="font-size: 30px; color: #f56954;"></i>
                                    <h4><?php echo $demographics['gender_distribution'][1]->count ?? 0; ?></h4>
                                    <small>Female Patients</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Patient Segments -->
            <div class="col-md-4">
                <div class="box box-purple">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-filter"></i> Patient Segments</h3>
                    </div>
                    <div class="box-body">
                        <div class="info-box bg-purple">
                            <span class="info-box-icon"><i class="fa fa-star"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">VIP Patients</span>
                                <span class="info-box-number"><?php echo rand(50, 150); ?></span>
                                <span class="progress-description">High-value customers</span>
                            </div>
                        </div>
                        
                        <div class="info-box bg-green">
                            <span class="info-box-icon"><i class="fa fa-refresh"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Regular Patients</span>
                                <span class="info-box-number"><?php echo rand(200, 400); ?></span>
                                <span class="progress-description">Frequent visitors</span>
                            </div>
                        </div>
                        
                        <div class="info-box bg-yellow">
                            <span class="info-box-icon"><i class="fa fa-warning"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">At-Risk Patients</span>
                                <span class="info-box-number"><?php echo rand(30, 80); ?></span>
                                <span class="progress-description">Haven't visited in 3+ months</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Activities -->
            <div class="col-md-4">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-clock-o"></i> Recent Activities</h3>
                    </div>
                    <div class="box-body">
                        <ul class="timeline timeline-inverse">
                            <li class="time-label">
                                <span class="bg-red">Today</span>
                            </li>
                            <li>
                                <i class="fa fa-user-plus bg-blue"></i>
                                <div class="timeline-item">
                                    <span class="time"><i class="fa fa-clock-o"></i> 5 mins ago</span>
                                    <h3 class="timeline-header no-border">
                                        <a href="#">12 new patients</a> registered
                                    </h3>
                                </div>
                            </li>
                            <li>
                                <i class="fa fa-bullhorn bg-yellow"></i>
                                <div class="timeline-item">
                                    <span class="time"><i class="fa fa-clock-o"></i> 2 hours ago</span>
                                    <h3 class="timeline-header no-border">
                                        <a href="#">Facebook campaign</a> reached 1000 people
                                    </h3>
                                </div>
                            </li>
                            <li>
                                <i class="fa fa-money bg-green"></i>
                                <div class="timeline-item">
                                    <span class="time"><i class="fa fa-clock-o"></i> 3 hours ago</span>
                                    <h3 class="timeline-header no-border">
                                        Revenue target <a href="#">achieved</a> for the day
                                    </h3>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-solid bg-light-blue-gradient">
                    <div class="box-header">
                        <h3 class="box-title"><i class="fa fa-rocket"></i> Quick Actions</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-2 col-sm-4 col-xs-6">
                                <a href="<?php echo base_url('admin/marketing/campaigns/create'); ?>" class="btn btn-app">
                                    <i class="fa fa-bullhorn"></i> New Campaign
                                </a>
                            </div>
                            <div class="col-md-2 col-sm-4 col-xs-6">
                                <a href="<?php echo base_url('admin/marketing/reports'); ?>" class="btn btn-app">
                                    <i class="fa fa-file-text"></i> Generate Report
                                </a>
                            </div>
                            <div class="col-md-2 col-sm-4 col-xs-6">
                                <a href="<?php echo base_url('admin/marketing/email/campaigns/create'); ?>" class="btn btn-app">
                                    <i class="fa fa-envelope"></i> Email Blast
                                </a>
                            </div>
                            <div class="col-md-2 col-sm-4 col-xs-6">
                                <a href="<?php echo base_url('admin/marketing/leads/add'); ?>" class="btn btn-app">
                                    <span class="badge bg-red">3</span>
                                    <i class="fa fa-user"></i> Add Lead
                                </a>
                            </div>
                            <div class="col-md-2 col-sm-4 col-xs-6">
                                <a href="<?php echo base_url('admin/marketing/analytics'); ?>" class="btn btn-app">
                                    <i class="fa fa-bar-chart"></i> Analytics
                                </a>
                            </div>
                            <div class="col-md-2 col-sm-4 col-xs-6">
                                <a href="<?php echo base_url('admin/marketing/calendar'); ?>" class="btn btn-app">
                                    <span class="badge bg-yellow">5</span>
                                    <i class="fa fa-calendar"></i> Calendar
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Include Required Libraries -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
<script src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script>
// Initialize date range picker
$('#daterange').daterangepicker({
    startDate: moment().subtract(29, 'days'),
    endDate: moment(),
    ranges: {
        'Today': [moment(), moment()],
        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        'This Month': [moment().startOf('month'), moment().endOf('month')],
        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    },
    locale: {
        format: 'YYYY-MM-DD'
    }
});

// Revenue Trend Chart
var revenueCtx = document.getElementById('revenueChart').getContext('2d');
var revenueChart = new Chart(revenueCtx, {
    type: 'line',
    data: {
        labels: <?php echo json_encode(array_map(function($t) { return $t['month']; }, $monthly_trends ?? [])); ?>,
        datasets: [{
            label: 'Revenue',
            data: <?php echo json_encode(array_map(function($t) { return $t['revenue']; }, $monthly_trends ?? [])); ?>,
            borderColor: 'rgb(60, 141, 188)',
            backgroundColor: 'rgba(60, 141, 188, 0.1)',
            tension: 0.4,
            fill: true
        }, {
            label: 'Projected',
            data: <?php echo json_encode(array_map(function($t) { return $t['revenue'] * 1.1; }, $monthly_trends ?? [])); ?>,
            borderColor: 'rgba(210, 214, 222, 1)',
            backgroundColor: 'rgba(210, 214, 222, 0.1)',
            borderDash: [5, 5],
            tension: 0.4,
            fill: false
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                display: true,
                position: 'top'
            },
            tooltip: {
                mode: 'index',
                intersect: false,
                callbacks: {
                    label: function(context) {
                        return context.dataset.label + ': KES ' + context.parsed.y.toLocaleString();
                    }
                }
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return 'KES ' + value.toLocaleString();
                    }
                }
            }
        }
    }
});

// Acquisition Pie Chart
var acquisitionCtx = document.getElementById('acquisitionPieChart').getContext('2d');
var acquisitionChart = new Chart(acquisitionCtx, {
    type: 'doughnut',
    data: {
        labels: <?php echo json_encode(array_map(function($s) { return $s->referral_source ?: 'Direct'; }, array_slice($acquisition_sources ?? [], 0, 5))); ?>,
        datasets: [{
            data: <?php echo json_encode(array_map(function($s) { return $s->count; }, array_slice($acquisition_sources ?? [], 0, 5))); ?>,
            backgroundColor: ['#3c8dbc', '#00a65a', '#f39c12', '#dd4b39', '#605ca8']
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                display: false
            }
        }
    }
});

// Department Chart
var deptCtx = document.getElementById('departmentChart').getContext('2d');
var departmentChart = new Chart(deptCtx, {
    type: 'bar',
    data: {
        labels: ['OPD', 'IPD', 'Laboratory', 'Radiology', 'Pharmacy'],
        datasets: [{
            label: 'Revenue',
            data: <?php echo json_encode(array_values($revenue_by_dept ?? [])); ?>,
            backgroundColor: 'rgba(60, 141, 188, 0.8)'
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return 'KES ' + value.toLocaleString();
                    }
                }
            }
        }
    }
});

// Demographics Chart
var demoCtx = document.getElementById('demographicsChart').getContext('2d');
var demographicsChart = new Chart(demoCtx, {
    type: 'bar',
    data: {
        labels: ['0-17', '18-30', '31-45', '46-60', '60+'],
        datasets: [{
            label: 'Age Distribution',
            data: [45, 120, 180, 95, 60],
            backgroundColor: [
                'rgba(255, 99, 132, 0.8)',
                'rgba(54, 162, 235, 0.8)',
                'rgba(255, 206, 86, 0.8)',
                'rgba(75, 192, 192, 0.8)',
                'rgba(153, 102, 255, 0.8)'
            ]
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        indexAxis: 'y',
        plugins: {
            legend: {
                display: false
            }
        }
    }
});

// Real-time updates
setInterval(function() {
    updateDashboard();
}, 30000); // Update every 30 seconds

function updateDashboard() {
    $.ajax({
        url: '<?php echo base_url("admin/marketing/api/kpi"); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if(response.status === 'success') {
                // Update KPI values with animation
                animateValue('newPatientsCount', response.data.new_patients);
                animateValue('totalRevenue', response.data.total_revenue);
                animateValue('conversionRate', response.data.conversion_rate);
                animateValue('retentionRate', response.data.retention_rate);
            }
        }
    });
}

function animateValue(id, value) {
    var obj = document.getElementById(id);
    var current = parseInt(obj.innerHTML.replace(/,/g, ''));
    var increment = (value - current) / 20;
    var step = 0;
    
    var timer = setInterval(function() {
        current += increment;
        obj.innerHTML = Math.round(current).toLocaleString();
        step++;
        if(step >= 20) clearInterval(timer);
    }, 50);
}

function resetFilters() {
    window.location.href = '<?php echo base_url("admin/marketing"); ?>';
}

function changeChartType(type) {
    revenueChart.config.type = type;
    revenueChart.update();
}

function exportChart(chartName) {
    var canvas = document.getElementById(chartName + 'Chart');
    var url = canvas.toDataURL('image/png');
    var link = document.createElement('a');
    link.download = chartName + '_chart_' + Date.now() + '.png';
    link.href = url;
    link.click();
}
</script>