<?php
/**
 * Single Laboratory Result Print Template
 */
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Laboratory Result - <?php echo $test['test_name']; ?></title>
    <style>
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; }
        }
        
        body {
            font-family: 'Arial', sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            margin: 20px;
        }
        
        .header {
            text-align: center;
            border-bottom: 3px solid #2c3e50;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        
        .hospital-logo {
            max-height: 80px;
            margin-bottom: 10px;
        }
        
        .hospital-name {
            font-size: 24px;
            font-weight: bold;
            color: #2c3e50;
            margin: 10px 0 5px 0;
        }
        
        .hospital-details {
            font-size: 11px;
            color: #7f8c8d;
            line-height: 1.3;
        }
        
        .report-title {
            background: #3498db;
            color: white;
            padding: 15px;
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            margin: 20px 0;
            border-radius: 5px;
        }
        
        .patient-section, .test-section, .result-section {
            margin-bottom: 25px;
            border: 1px solid #bdc3c7;
            border-radius: 5px;
            overflow: hidden;
        }
        
        .section-header {
            background: #ecf0f1;
            padding: 10px 15px;
            font-weight: bold;
            color: #2c3e50;
            border-bottom: 1px solid #bdc3c7;
        }
        
        .section-content {
            padding: 15px;
        }
        
        .info-row {
            display: flex;
            margin-bottom: 8px;
            align-items: center;
        }
        
        .info-label {
            font-weight: bold;
            width: 150px;
            color: #34495e;
        }
        
        .info-value {
            flex: 1;
            color: #2c3e50;
        }
        
        .result-highlight {
            background: #f8f9fa;
            border: 2px solid #3498db;
            border-radius: 8px;
            padding: 20px;
            margin: 15px 0;
            text-align: center;
        }
        
        .result-value {
            font-size: 24px;
            font-weight: bold;
            color: #2c3e50;
            margin-bottom: 10px;
        }
        
        .reference-range {
            font-size: 11px;
            color: #7f8c8d;
            font-style: italic;
        }
        
        .status-badge {
            display: inline-block;
            padding: 5px 12px;
            border-radius: 15px;
            font-size: 10px;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .status-pending { background: #f39c12; color: white; }
        .status-completed { background: #27ae60; color: white; }
        .status-abnormal { background: #e74c3c; color: white; }
        .status-critical { background: #c0392b; color: white; }
        .status-in_progress { background: #3498db; color: white; }
        
        .verification-verified { background: #27ae60; color: white; }
        .verification-unverified { background: #f39c12; color: white; }
        .verification-skipped { background: #95a5a6; color: white; }
        
        .critical-warning {
            background: #ffe6e6;
            border: 2px solid #e74c3c;
            border-radius: 8px;
            padding: 15px;
            margin: 15px 0;
            color: #c0392b;
            font-weight: bold;
            text-align: center;
        }
        
        .footer {
            margin-top: 40px;
            border-top: 2px solid #ecf0f1;
            padding-top: 20px;
        }
        
        .signatures {
            display: flex;
            justify-content: space-between;
            margin-top: 50px;
        }
        
        .signature-block {
            text-align: center;
            width: 200px;
        }
        
        .signature-line {
            border-top: 1px solid #333;
            margin-bottom: 5px;
        }
        
        .signature-label {
            font-size: 10px;
            color: #7f8c8d;
        }
        
        .print-info {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px dotted #bdc3c7;
            font-size: 10px;
            color: #95a5a6;
            text-align: center;
        }
        
        .no-print {
            text-align: center;
            margin: 20px 0;
        }
        
        .notes-section {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 5px;
            padding: 15px;
            margin: 15px 0;
        }
        
        .notes-title {
            font-weight: bold;
            color: #856404;
            margin-bottom: 8px;
        }
        
        .watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 100px;
            color: rgba(231, 76, 60, 0.1);
            font-weight: bold;
            z-index: -1;
            pointer-events: none;
        }
        
        @media screen {
            body { max-width: 800px; margin: 20px auto; }
        }
    </style>
</head>
<body>
    <!-- Critical Result Watermark -->
    <?php if ($test['result_status'] === 'critical'): ?>
    <div class="watermark">CRITICAL</div>
    <?php endif; ?>

    <!-- Print Controls -->
    <div class="no-print">
        <button onclick="window.print()" style="background: #3498db; color: white; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer;">
            <i class="fa fa-print"></i> Print Report
        </button>
        <button onclick="window.close()" style="background: #95a5a6; color: white; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer; margin-left: 10px;">
            <i class="fa fa-times"></i> Close
        </button>
    </div>

    <!-- Header Section -->
    <div class="header">
        <?php if (!empty($hospital_info['logo'])): ?>
        <img src="<?php echo $hospital_info['logo']; ?>" alt="Hospital Logo" class="hospital-logo">
        <?php endif; ?>
        
        <div class="hospital-name"><?php echo $hospital_info['name']; ?></div>
        <div class="hospital-details">
            <?php echo nl2br($hospital_info['address']); ?><br>
            Tel: <?php echo $hospital_info['phone']; ?> | Email: <?php echo $hospital_info['email']; ?><br>
            <?php if (!empty($hospital_info['website'])): ?>
            Website: <?php echo $hospital_info['website']; ?><br>
            <?php endif; ?>
            License No: <?php echo $hospital_info['license_no']; ?> | Reg No: <?php echo $hospital_info['registration_no']; ?>
        </div>
    </div>

    <!-- Report Title -->
    <div class="report-title">
        LABORATORY TEST RESULT
    </div>

    <!-- Critical Warning -->
    <?php if ($test['result_status'] === 'critical'): ?>
    <div class="critical-warning">
        ⚠️ CRITICAL RESULT - IMMEDIATE ATTENTION REQUIRED ⚠️
    </div>
    <?php endif; ?>

    <!-- Patient Information Section -->
    <div class="patient-section">
        <div class="section-header">
            <i class="fa fa-user"></i> Patient Information
        </div>
        <div class="section-content">
            <div class="info-row">
                <div class="info-label">Patient Name:</div>
                <div class="info-value"><?php echo strtoupper($test['patient_name']); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Patient ID:</div>
                <div class="info-value"><?php echo $test['patient_unique_id'] ?: 'N/A'; ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Age / Gender:</div>
                <div class="info-value"><?php echo $test['age']; ?> years / <?php echo ucfirst($test['gender']); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Phone Number:</div>
                <div class="info-value"><?php echo $test['mobileno']; ?></div>
            </div>
            <?php if (!empty($test['address'])): ?>
            <div class="info-row">
                <div class="info-label">Address:</div>
                <div class="info-value"><?php echo $test['address']; ?></div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Test Information Section -->
    <div class="test-section">
        <div class="section-header">
            <i class="fa fa-flask"></i> Test Information
        </div>
        <div class="section-content">
            <div class="info-row">
                <div class="info-label">Test Name:</div>
                <div class="info-value"><strong><?php echo $test['test_name']; ?></strong></div>
            </div>
            <div class="info-row">
                <div class="info-label">Test Category:</div>
                <div class="info-value"><?php echo $test['category_name']; ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Test Date:</div>
                <div class="info-value"><?php echo date('d/m/Y H:i', strtotime($test['test_date'])); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Report Date:</div>
                <div class="info-value"><?php echo date('d/m/Y H:i', strtotime($print_date)); ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Requesting Doctor:</div>
                <div class="info-value"><?php echo $test['doctor_name'] ?: 'Not specified'; ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Technician:</div>
                <div class="info-value"><?php echo $test['technician_name'] ?: 'Not specified'; ?></div>
            </div>
            <div class="info-row">
                <div class="info-label">Lab ID:</div>
                <div class="info-value"><?php echo str_pad($test['id'], 6, '0', STR_PAD_LEFT); ?></div>
            </div>
        </div>
    </div>

    <!-- Test Result Section -->
    <div class="result-section">
        <div class="section-header">
            <i class="fa fa-clipboard-list"></i> Test Result
        </div>
        <div class="section-content">
            <?php if (!empty($test['test_result'])): ?>
            <div class="result-highlight">
                <div class="result-value"><?php echo $test['test_result']; ?></div>
                <?php if (!empty($test['reference_range'])): ?>
                <div class="reference-range">Reference Range: <?php echo $test['reference_range']; ?></div>
                <?php endif; ?>
            </div>
            <?php else: ?>
            <div class="result-highlight" style="border-color: #f39c12;">
                <div class="result-value" style="color: #f39c12;">RESULT PENDING</div>
                <div class="reference-range">Test result not yet available</div>
            </div>
            <?php endif; ?>
            
            <div class="info-row">
                <div class="info-label">Result Status:</div>
                <div class="info-value">
                    <span class="status-badge status-<?php echo $test['result_status']; ?>">
                        <?php echo ucwords(str_replace('_', ' ', $test['result_status'])); ?>
                    </span>
                </div>
            </div>
            
            <div class="info-row">
                <div class="info-label">Verification:</div>
                <div class="info-value">
                    <span class="status-badge verification-<?php echo $test['verification_status']; ?>">
                        <?php echo ucfirst($test['verification_status']); ?>
                    </span>
                    <?php if ($test['verification_status'] === 'verified' && !empty($test['verified_at'])): ?>
                    <small style="margin-left: 10px; color: #7f8c8d;">
                        Verified on <?php echo date('d/m/Y H:i', strtotime($test['verified_at'])); ?>
                    </small>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="info-row">
                <div class="info-label">Amount:</div>
                <div class="info-value"><strong>KSh <?php echo number_format($test['final_amount'], 2); ?></strong></div>
            </div>
        </div>
    </div>

    <!-- Notes Section -->
    <?php if (!empty($test['notes'])): ?>
    <div class="notes-section">
        <div class="notes-title">Additional Notes:</div>
        <div><?php echo nl2br(htmlspecialchars($test['notes'])); ?></div>
    </div>
    <?php endif; ?>

    <!-- Footer Section -->
    <div class="footer">
        <!-- Signatures -->
        <div class="signatures">
            <div class="signature-block">
                <div style="height: 40px;"></div>
                <div class="signature-line"></div>
                <div class="signature-label">Laboratory Technician</div>
                <div style="font-size: 10px; margin-top: 5px;">
                    <?php echo $test['technician_name'] ?: 'Not specified'; ?>
                </div>
            </div>
            
            <div class="signature-block">
                <div style="height: 40px;"></div>
                <div class="signature-line"></div>
                <div class="signature-label">Verified By</div>
                <div style="font-size: 10px; margin-top: 5px;">
                    <?php if ($test['verification_status'] === 'verified'): ?>
                    Verified Electronically
                    <?php else: ?>
                    Pending Verification
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="signature-block">
                <div style="height: 40px;"></div>
                <div class="signature-line"></div>
                <div class="signature-label">Pathologist/Doctor</div>
                <div style="font-size: 10px; margin-top: 5px;">
                    <?php echo $test['doctor_name'] ?: 'Not specified'; ?>
                </div>
            </div>
        </div>

        <!-- Print Information -->
        <div class="print-info">
            This report was generated electronically on <?php echo date('d/m/Y H:i:s', strtotime($print_date)); ?><br>
            <?php if ($test['result_status'] === 'critical'): ?>
            <strong style="color: #e74c3c;">CRITICAL RESULT - This report requires immediate medical attention</strong><br>
            <?php endif; ?>
            For any queries regarding this report, please contact the laboratory department.<br>
            Report ID: LAB-<?php echo str_pad($test['id'], 6, '0', STR_PAD_LEFT); ?>-<?php echo date('Ymd'); ?>
        </div>
    </div>

    <script>
        // Auto-print for PDF generation
        if (window.location.search.includes('format=pdf')) {
            window.onload = function() {
                window.print();
            };
        }
    </script>
</body>
</html>