<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <div class="header-icon">
            <i class="fa fa-list"></i>
        </div>
        <div class="header-title">
            <h1>Test Categories</h1>
            <small>Manage Laboratory Test Categories</small>
        </div>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-list"></i> Laboratory Test Categories
                        </h3>
                        <div class="box-tools pull-right">
                            <?php if ($this->rbac->hasPrivilege('lab_setup', 'can_add')): ?>
                                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addCategoryModal">
                                    <i class="fa fa-plus"></i> Add Category
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table id="categoriesTable" class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>Category Name</th>
                                        <th>Description</th>
                                        <th>Tests Count</th>
                                        <th>Status</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($categories)): ?>
                                        <?php foreach ($categories as $category): ?>
                                            <tr>
                                                <td><?php echo htmlspecialchars($category['category_name']); ?></td>
                                                <td><?php echo htmlspecialchars($category['description']); ?></td>
                                                <td>
                                                    <span class="badge bg-blue">
                                                        <?php echo isset($category['tests_count']) ? $category['tests_count'] : '0'; ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <?php if ($category['is_active']): ?>
                                                        <span class="label label-success">Active</span>
                                                    <?php else: ?>
                                                        <span class="label label-danger">Inactive</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-right">
                                                    <div class="btn-group">
                                                        <?php if ($this->rbac->hasPrivilege('lab_setup', 'can_edit')): ?>
                                                            <button type="button" class="btn btn-default btn-xs" 
                                                                    onclick="editCategory(<?php echo $category['id']; ?>)" 
                                                                    title="Edit">
                                                                <i class="fa fa-pencil"></i>
                                                            </button>
                                                        <?php endif; ?>
                                                        <?php if ($this->rbac->hasPrivilege('lab_setup', 'can_delete')): ?>
                                                            <button type="button" class="btn btn-default btn-xs" 
                                                                    onclick="deleteCategory(<?php echo $category['id']; ?>)" 
                                                                    title="Delete">
                                                                <i class="fa fa-trash"></i>
                                                            </button>
                                                        <?php endif; ?>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="5" class="text-center text-muted">
                                                No categories found. Click "Add Category" to create one.
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Category Modal -->
<div class="modal fade" id="addCategoryModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-plus"></i> Add Test Category
                </h4>
            </div>
            <form id="addCategoryForm" role="form">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="category_name">Category Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="category_name" name="category_name" 
                               placeholder="Enter category name" required>
                        <span class="text-danger" id="category_name_error"></span>
                    </div>
                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea class="form-control" id="description" name="description" rows="3" 
                                  placeholder="Enter category description"></textarea>
                        <span class="text-danger" id="description_error"></span>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> Save Category
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Category Modal -->
<div class="modal fade" id="editCategoryModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-edit"></i> Edit Test Category
                </h4>
            </div>
            <div id="editCategoryModalContent">
                <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#categoriesTable').DataTable({
        responsive: true,
        pageLength: 25,
        order: [[0, 'asc']]
    });

    // Add Category Form Submission
    $('#addCategoryForm').on('submit', function(e) {
        e.preventDefault();
        
        var formData = $(this).serialize();
        var $submitBtn = $(this).find('button[type="submit"]');
        
        $submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
        
        // Clear previous errors
        $('.text-danger').text('');
        
        $.ajax({
            url: base_url + 'admin/lab_setup/add_category',
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#addCategoryModal').modal('hide');
                    $('#addCategoryForm')[0].reset();
                    showMessage(response.message, 'success');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    if (response.error) {
                        $.each(response.error, function(field, error) {
                            $('#' + field + '_error').text(error);
                        });
                    }
                    if (response.message) {
                        showMessage(response.message, 'error');
                    }
                }
            },
            error: function() {
                showMessage('An error occurred. Please try again.', 'error');
            },
            complete: function() {
                $submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Category');
            }
        });
    });
});

// Edit Category Function
function editCategory(id) {
    $.ajax({
        url: base_url + 'admin/lab_setup/edit_category/' + id,
        type: 'GET',
        success: function(response) {
            $('#editCategoryModalContent').html(response);
            $('#editCategoryModal').modal('show');
        },
        error: function() {
            showMessage('Error loading category data.', 'error');
        }
    });
}

// Delete Category Function
function deleteCategory(id) {
    if (confirm('Are you sure you want to delete this category?')) {
        $.ajax({
            url: base_url + 'admin/lab_setup/delete_category/' + id,
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    showMessage(response.message, 'success');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    showMessage(response.message, 'error');
                }
            },
            error: function() {
                showMessage('An error occurred. Please try again.', 'error');
            }
        });
    }
}

// Show message function
function showMessage(message, type) {
    var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    var icon = type === 'success' ? 'fa-check' : 'fa-exclamation-triangle';
    
    var alert = '<div class="alert ' + alertClass + ' alert-dismissible">' +
                '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>' +
                '<h4><i class="icon fa ' + icon + '"></i> ' + 
                (type === 'success' ? 'Success!' : 'Error!') + '</h4>' +
                message + '</div>';
    
    $('.content-wrapper').prepend(alert);
    
    setTimeout(function() {
        $('.alert').fadeOut();
    }, 5000);
}
</script>