<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lab Report Results - City Health Hospital</title>
    <style>
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; }
            .report { box-shadow: none; margin: 0; }
        }
        
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background: #f5f5f5;
            line-height: 1.4;
        }
        
        .report {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            border-radius: 8px;
        }
        
        .header {
            text-align: center;
            border-bottom: 3px solid #2c3e50;
            padding-bottom: 20px;
            margin-bottom: 25px;
        }
        
        .hospital-name {
            font-size: 28px;
            font-weight: bold;
            color: #2c3e50;
            margin-bottom: 8px;
        }
        
        .hospital-details {
            color: #666;
            font-size: 14px;
            line-height: 1.6;
        }
        
        .report-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 8px;
            border-left: 5px solid #007bff;
        }
        
        .report-title {
            font-size: 22px;
            font-weight: bold;
            color: #2c3e50;
        }
        
        .report-number {
            font-size: 16px;
            color: #007bff;
            font-weight: bold;
        }
        
        .patient-info {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 25px;
            margin-bottom: 30px;
            padding: 20px;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            background: #f8f9fa;
        }
        
        .patient-section h3 {
            margin: 0 0 15px 0;
            color: #495057;
            font-size: 16px;
            border-bottom: 2px solid #007bff;
            padding-bottom: 8px;
        }
        
        .info-row {
            display: flex;
            margin-bottom: 10px;
        }
        
        .info-label {
            font-weight: bold;
            width: 130px;
            color: #495057;
        }
        
        .info-value {
            color: #333;
            flex: 1;
        }
        
        .critical-alert {
            background: linear-gradient(135deg, #ff6b6b, #ee5a52);
            color: white;
            padding: 15px 20px;
            border-radius: 8px;
            margin: 20px 0;
            font-weight: bold;
            text-align: center;
            box-shadow: 0 4px 15px rgba(255, 107, 107, 0.3);
        }
        
        .critical-alert i {
            margin-right: 10px;
            font-size: 18px;
        }
        
        .test-section {
            margin-bottom: 35px;
            border: 1px solid #e3e6f0;
            border-radius: 8px;
            overflow: hidden;
        }
        
        .test-section-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 20px;
            font-weight: bold;
            font-size: 18px;
            display: flex;
            align-items: center;
        }
        
        .test-section-header i {
            margin-right: 10px;
            font-size: 20px;
        }
        
        .test-results-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 20px;
            padding: 25px;
            background: #fafbfc;
        }
        
        .test-result-item {
            background: white;
            border: 1px solid #e8eaed;
            border-radius: 8px;
            padding: 15px;
            position: relative;
            transition: all 0.3s ease;
        }
        
        .test-result-item:hover {
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            transform: translateY(-2px);
        }
        
        .test-name {
            font-weight: bold;
            font-size: 14px;
            color: #2c3e50;
            margin-bottom: 8px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .test-value {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .test-range {
            font-size: 12px;
            color: #6c757d;
            margin-bottom: 8px;
        }
        
        .test-status {
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 11px;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .status-normal {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        
        .status-high {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        
        .status-low {
            background: #fff3cd;
            color: #856404;
            border: 1px solid #ffeaa7;
        }
        
        .status-critical {
            background: #f5c6cb;
            color: #721c24;
            border: 1px solid #f1b0b7;
            animation: pulse 2s infinite;
        }
        
        .status-positive {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        
        .status-negative {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.7; }
        }
        
        .clinical-notes {
            background: #fff8e1;
            border: 1px solid #ffecb3;
            border-radius: 8px;
            padding: 20px;
            margin: 25px 0;
        }
        
        .clinical-notes h4 {
            color: #ff6f00;
            margin: 0 0 15px 0;
            display: flex;
            align-items: center;
        }
        
        .clinical-notes h4 i {
            margin-right: 10px;
        }
        
        .clinical-notes p {
            color: #e65100;
            margin: 8px 0;
            font-size: 14px;
        }
        
        .summary-section {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 20px;
            margin: 25px 0;
            border-left: 5px solid #28a745;
        }
        
        .summary-title {
            font-size: 18px;
            font-weight: bold;
            color: #2c3e50;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
        }
        
        .summary-title i {
            margin-right: 10px;
            color: #28a745;
        }
        
        .summary-content {
            color: #495057;
            line-height: 1.6;
        }
        
        .footer-signatures {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr;
            gap: 30px;
            margin-top: 40px;
            padding-top: 25px;
            border-top: 2px solid #dee2e6;
        }
        
        .signature-block {
            text-align: center;
        }
        
        .signature-line {
            border-top: 1px solid #333;
            margin: 30px 0 8px 0;
            padding-top: 8px;
            font-size: 12px;
            color: #666;
            font-weight: bold;
        }
        
        .signature-role {
            font-size: 11px;
            color: #999;
        }
        
        .print-info {
            text-align: center;
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #dee2e6;
            font-size: 11px;
            color: #666;
        }
        
        .print-buttons {
            text-align: center;
            margin: 20px 0;
        }
        
        .btn {
            padding: 12px 24px;
            margin: 0 8px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s ease;
        }
        
        .btn-primary {
            background: #007bff;
            color: white;
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn:hover {
            opacity: 0.9;
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
        }
        
        @media (max-width: 768px) {
            .report {
                margin: 10px;
                padding: 20px;
            }
            
            .patient-info {
                grid-template-columns: 1fr;
                gap: 15px;
            }
            
            .test-results-grid {
                grid-template-columns: 1fr;
                gap: 15px;
                padding: 15px;
            }
            
            .footer-signatures {
                grid-template-columns: 1fr;
                gap: 20px;
            }
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
</head>
<body>
    <!-- Print Buttons -->
    <div class="print-buttons no-print">
        <button class="btn btn-primary" onclick="window.print()">
            <i class="fa fa-print"></i> Print Report
        </button>
        <button class="btn btn-secondary" onclick="window.history.back()">
            <i class="fa fa-arrow-left"></i> Back
        </button>
    </div>

    <div class="report">
        <!-- Hospital Header -->
        <div class="header">
            <div class="hospital-name">
                City Health Hospital
            </div>
            <div class="hospital-details">
                Odeon Building, Tom Mboya Street, Nairobi<br>
                P.O. Box 17725-00100, GPO Nairobi, Kenya<br>
                Phone: +254 20 4408298 | Email: lab@cityhealthke.com<br>
                <strong>LABORATORY SERVICES DEPARTMENT</strong>
            </div>
        </div>

        <!-- Report Header -->
        <div class="report-header">
            <div class="report-title">LABORATORY INVESTIGATION REPORT</div>
            <div class="report-number">
                Report #: <?php echo isset($report->id) ? 'LAB-' . date('Y') . '-' . str_pad($report->id, 6, '0', STR_PAD_LEFT) : 'LAB-PENDING'; ?>
            </div>
        </div>

        <!-- Critical Results Alert -->
        <div class="critical-alert" id="criticalAlert" style="<?php echo (isset($report->is_critical) && $report->is_critical == 1) ? 'display: block;' : 'display: none;'; ?>">
            <i class="fa fa-exclamation-triangle"></i>
            CRITICAL VALUES DETECTED - IMMEDIATE ATTENTION REQUIRED
        </div>

        <!-- Patient Information -->
        <div class="patient-info">
            <div class="patient-section">
                <h3><i class="fa fa-user"></i> Patient Information</h3>
                <div class="info-row">
                    <span class="info-label">Patient ID:</span>
                    <span class="info-value"><?php echo isset($patient->patient_unique_id) ? $patient->patient_unique_id : (isset($patient->id) ? 'PT-' . str_pad($patient->id, 6, '0', STR_PAD_LEFT) : 'N/A'); ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Name:</span>
                    <span class="info-value"><?php echo isset($patient->patient_name) ? $patient->patient_name : 'N/A'; ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Age/Gender:</span>
                    <span class="info-value">
                        <?php 
                            $age = isset($patient->age) ? $patient->age : 'N/A';
                            $gender = isset($patient->gender) ? $patient->gender : 'N/A';
                            echo $age . ' Years / ' . ucfirst($gender);
                        ?>
                    </span>
                </div>
                <div class="info-row">
                    <span class="info-label">Mobile:</span>
                    <span class="info-value"><?php echo isset($patient->mobileno) ? $patient->mobileno : 'N/A'; ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Address:</span>
                    <span class="info-value"><?php echo isset($patient->address) ? $patient->address : 'N/A'; ?></span>
                </div>
            </div>
            
            <div class="patient-section">
                <h3><i class="fa fa-clipboard"></i> Report Information</h3>
                <div class="info-row">
                    <span class="info-label">Sample Date:</span>
                    <span class="info-value">
                        <?php 
                            if (isset($report->report_date)) {
                                echo date('d-M-Y h:i A', strtotime($report->report_date));
                            } else {
                                echo 'N/A';
                            }
                        ?>
                    </span>
                </div>
                <div class="info-row">
                    <span class="info-label">Report Date:</span>
                    <span class="info-value">
                        <?php 
                            if (isset($report->created_at)) {
                                echo date('d-M-Y h:i A', strtotime($report->created_at));
                            } else {
                                echo date('d-M-Y h:i A');
                            }
                        ?>
                    </span>
                </div>
                <div class="info-row">
                    <span class="info-label">Referring Doctor:</span>
                    <span class="info-value"><?php echo isset($report->doctor_name) ? $report->doctor_name : 'N/A'; ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Department:</span>
                    <span class="info-value"><?php echo isset($report->department) ? ucfirst($report->department) : 'Laboratory'; ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Lab Technician:</span>
                    <span class="info-value"><?php echo isset($report->technician_name) ? $report->technician_name : 'N/A'; ?></span>
                </div>
            </div>
        </div>

        <!-- Test Results Sections -->
        <?php if (isset($test_results) && !empty($test_results)): ?>
            <?php 
                $test_data = is_string($test_results) ? json_decode($test_results, true) : $test_results;
                $interpretations = isset($test_interpretations) ? (is_string($test_interpretations) ? json_decode($test_interpretations, true) : $test_interpretations) : [];
            ?>
            
            <!-- Investigation GHC Section -->
            <?php 
                $investigation_tests = ['hiv', 'rbs', 'haemoglobin', 'vdrl', 'creatinine', 'hbsag', 'hcv_antibody', 'blood_group', 'pregnancy_test', 'bs_mps', 'stool_oc'];
                $has_investigation = false;
                foreach ($investigation_tests as $test) {
                    if (isset($test_data[$test]) && !empty($test_data[$test])) {
                        $has_investigation = true;
                        break;
                    }
                }
            ?>
            
            <?php if ($has_investigation): ?>
            <div class="test-section">
                <div class="test-section-header">
                    <i class="fa fa-heartbeat"></i>
                    Investigation GHC (General Health Check)
                </div>
                <div class="test-results-grid">
                    <?php if (isset($test_data['hiv']) && !empty($test_data['hiv'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">HIV Test</div>
                        <div class="test-value"><?php echo ucfirst($test_data['hiv']); ?></div>
                        <div class="test-range">Normal: Negative</div>
                        <div class="test-status <?php echo ($test_data['hiv'] == 'negative') ? 'status-negative' : 'status-positive'; ?>">
                            <?php echo strtoupper($test_data['hiv']); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['rbs']) && !empty($test_data['rbs'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">Random Blood Sugar</div>
                        <div class="test-value"><?php echo $test_data['rbs']; ?> mg/dL</div>
                        <div class="test-range">Normal: 70-140 mg/dL</div>
                        <div class="test-status <?php 
                            $rbs = floatval($test_data['rbs']);
                            if ($rbs < 70) echo 'status-low';
                            elseif ($rbs > 200) echo 'status-critical';
                            elseif ($rbs > 140) echo 'status-high';
                            else echo 'status-normal';
                        ?>">
                            <?php 
                                $rbs = floatval($test_data['rbs']);
                                if ($rbs < 70) echo 'LOW';
                                elseif ($rbs > 200) echo 'CRITICAL';
                                elseif ($rbs > 140) echo 'HIGH';
                                else echo 'NORMAL';
                            ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['haemoglobin']) && !empty($test_data['haemoglobin'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">Haemoglobin</div>
                        <div class="test-value"><?php echo $test_data['haemoglobin']; ?> g/dL</div>
                        <div class="test-range">
                            <?php 
                                $gender = isset($patient->gender) ? strtolower($patient->gender) : 'male';
                                echo ($gender == 'female') ? 'Normal: 12.0-15.5 g/dL (F)' : 'Normal: 13.5-17.5 g/dL (M)';
                            ?>
                        </div>
                        <div class="test-status <?php 
                            $hb = floatval($test_data['haemoglobin']);
                            $gender = isset($patient->gender) ? strtolower($patient->gender) : 'male';
                            $min = ($gender == 'female') ? 12.0 : 13.5;
                            $max = ($gender == 'female') ? 15.5 : 17.5;
                            if ($hb < $min) echo 'status-low';
                            elseif ($hb > $max) echo 'status-high';
                            else echo 'status-normal';
                        ?>">
                            <?php 
                                $hb = floatval($test_data['haemoglobin']);
                                $gender = isset($patient->gender) ? strtolower($patient->gender) : 'male';
                                $min = ($gender == 'female') ? 12.0 : 13.5;
                                $max = ($gender == 'female') ? 15.5 : 17.5;
                                if ($hb < $min) echo 'LOW';
                                elseif ($hb > $max) echo 'HIGH';
                                else echo 'NORMAL';
                            ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['vdrl']) && !empty($test_data['vdrl'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">VDRL Test</div>
                        <div class="test-value"><?php echo ucfirst($test_data['vdrl']); ?></div>
                        <div class="test-range">Normal: Negative</div>
                        <div class="test-status <?php echo ($test_data['vdrl'] == 'negative') ? 'status-negative' : 'status-positive'; ?>">
                            <?php echo strtoupper($test_data['vdrl']); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['creatinine']) && !empty($test_data['creatinine'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">Creatinine</div>
                        <div class="test-value"><?php echo $test_data['creatinine']; ?> mg/dL</div>
                        <div class="test-range">
                            <?php 
                                $gender = isset($patient->gender) ? strtolower($patient->gender) : 'male';
                                echo ($gender == 'female') ? 'Normal: 0.6-1.1 mg/dL (F)' : 'Normal: 0.7-1.3 mg/dL (M)';
                            ?>
                        </div>
                        <div class="test-status <?php 
                            $creat = floatval($test_data['creatinine']);
                            $gender = isset($patient->gender) ? strtolower($patient->gender) : 'male';
                            $min = ($gender == 'female') ? 0.6 : 0.7;
                            $max = ($gender == 'female') ? 1.1 : 1.3;
                            if ($creat < $min) echo 'status-low';
                            elseif ($creat > ($max * 2)) echo 'status-critical';
                            elseif ($creat > $max) echo 'status-high';
                            else echo 'status-normal';
                        ?>">
                            <?php 
                                $creat = floatval($test_data['creatinine']);
                                $gender = isset($patient->gender) ? strtolower($patient->gender) : 'male';
                                $min = ($gender == 'female') ? 0.6 : 0.7;
                                $max = ($gender == 'female') ? 1.1 : 1.3;
                                if ($creat < $min) echo 'LOW';
                                elseif ($creat > ($max * 2)) echo 'CRITICAL';
                                elseif ($creat > $max) echo 'HIGH';
                                else echo 'NORMAL';
                            ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['hbsag']) && !empty($test_data['hbsag'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">HBsAg</div>
                        <div class="test-value"><?php echo ucfirst($test_data['hbsag']); ?></div>
                        <div class="test-range">Normal: Negative</div>
                        <div class="test-status <?php echo ($test_data['hbsag'] == 'negative') ? 'status-negative' : 'status-positive'; ?>">
                            <?php echo strtoupper($test_data['hbsag']); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['hcv_antibody']) && !empty($test_data['hcv_antibody'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">Hepatitis C Antibody</div>
                        <div class="test-value"><?php echo ucfirst($test_data['hcv_antibody']); ?></div>
                        <div class="test-range">Normal: Negative</div>
                        <div class="test-status <?php echo ($test_data['hcv_antibody'] == 'negative') ? 'status-negative' : 'status-positive'; ?>">
                            <?php echo strtoupper($test_data['hcv_antibody']); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['blood_group']) && !empty($test_data['blood_group'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">Blood Group</div>
                        <div class="test-value"><?php echo $test_data['blood_group']; ?></div>
                        <div class="test-range">ABO & Rh Typing</div>
                        <div class="test-status status-normal">DETERMINED</div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['pregnancy_test']) && !empty($test_data['pregnancy_test'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">Pregnancy Test</div>
                        <div class="test-value"><?php echo ucfirst($test_data['pregnancy_test']); ?></div>
                        <div class="test-range">Normal: Negative (non-pregnant)</div>
                        <div class="test-status <?php echo ($test_data['pregnancy_test'] == 'negative') ? 'status-negative' : 'status-positive'; ?>">
                            <?php echo strtoupper($test_data['pregnancy_test']); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['bs_mps']) && !empty($test_data['bs_mps'])): ?>
                    <div class="test-result-item" style="grid-column: 1 / -1;">
                        <div class="test-name">Blood Smear for MPS</div>
                        <div class="test-value" style="font-size: 14px; line-height: 1.4;">
                            <?php echo nl2br(htmlspecialchars($test_data['bs_mps'])); ?>
                        </div>
                        <div class="test-range">Microscopic examination for malaria parasites</div>
                        <div class="test-status status-normal">EXAMINED</div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['stool_oc']) && !empty($test_data['stool_oc'])): ?>
                    <div class="test-result-item" style="grid-column: 1 / -1;">
                        <div class="test-name">Stool Ova & Cysts</div>
                        <div class="test-value" style="font-size: 14px; line-height: 1.4;">
                            <?php echo nl2br(htmlspecialchars($test_data['stool_oc'])); ?>
                        </div>
                        <div class="test-range">Parasitological examination</div>
                        <div class="test-status status-normal">EXAMINED</div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>

            <!-- Urinalysis Section -->
            <?php 
                $urinalysis_tests = ['urine_appearance', 'urine_form', 'urine_ph', 'specific_gravity', 'nitrite', 'protein', 'microscopy'];
                $has_urinalysis = false;
                foreach ($urinalysis_tests as $test) {
                    if (isset($test_data[$test]) && !empty($test_data[$test])) {
                        $has_urinalysis = true;
                        break;
                    }
                }
            ?>
            
            <?php if ($has_urinalysis): ?>
            <div class="test-section">
                <div class="test-section-header">
                    <i class="fa fa-tint"></i>
                    Urinalysis
                </div>
                <div class="test-results-grid">
                    <?php if (isset($test_data['urine_appearance']) && !empty($test_data['urine_appearance'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">Appearance</div>
                        <div class="test-value"><?php echo ucfirst($test_data['urine_appearance']); ?></div>
                        <div class="test-range">Normal: Clear/Yellow</div>
                        <div class="test-status <?php echo (in_array(strtolower($test_data['urine_appearance']), ['clear', 'yellow', 'straw'])) ? 'status-normal' : 'status-high'; ?>">
                            <?php echo (in_array(strtolower($test_data['urine_appearance']), ['clear', 'yellow', 'straw'])) ? 'NORMAL' : 'ABNORMAL'; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['urine_form']) && !empty($test_data['urine_form'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">Form</div>
                        <div class="test-value"><?php echo ucfirst($test_data['urine_form']); ?></div>
                        <div class="test-range">Normal: Liquid</div>
                        <div class="test-status status-normal">NORMAL</div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['urine_ph']) && !empty($test_data['urine_ph'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">pH</div>
                        <div class="test-value"><?php echo $test_data['urine_ph']; ?></div>
                        <div class="test-range">Normal: 4.5-8.0</div>
                        <div class="test-status <?php 
                            $ph = floatval($test_data['urine_ph']);
                            if ($ph < 4.5 || $ph > 8.0) echo 'status-high';
                            else echo 'status-normal';
                        ?>">
                            <?php 
                                $ph = floatval($test_data['urine_ph']);
                                echo ($ph < 4.5 || $ph > 8.0) ? 'ABNORMAL' : 'NORMAL';
                            ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['specific_gravity']) && !empty($test_data['specific_gravity'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">Specific Gravity</div>
                        <div class="test-value"><?php echo $test_data['specific_gravity']; ?></div>
                        <div class="test-range">Normal: 1.003-1.030</div>
                        <div class="test-status <?php 
                            $sg = floatval($test_data['specific_gravity']);
                            if ($sg < 1.003) echo 'status-low';
                            elseif ($sg > 1.030) echo 'status-high';
                            else echo 'status-normal';
                        ?>">
                            <?php 
                                $sg = floatval($test_data['specific_gravity']);
                                if ($sg < 1.003) echo 'LOW';
                                elseif ($sg > 1.030) echo 'HIGH';
                                else echo 'NORMAL';
                            ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['nitrite']) && !empty($test_data['nitrite'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">Nitrite</div>
                        <div class="test-value"><?php echo ucfirst($test_data['nitrite']); ?></div>
                        <div class="test-range">Normal: Negative</div>
                        <div class="test-status <?php echo ($test_data['nitrite'] == 'negative') ? 'status-negative' : 'status-positive'; ?>">
                            <?php echo strtoupper($test_data['nitrite']); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['protein']) && !empty($test_data['protein'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">Protein</div>
                        <div class="test-value"><?php echo ucfirst($test_data['protein']); ?></div>
                        <div class="test-range">Normal: Negative/Trace</div>
                        <div class="test-status <?php echo (in_array(strtolower($test_data['protein']), ['negative', 'trace'])) ? 'status-normal' : 'status-high'; ?>">
                            <?php echo (in_array(strtolower($test_data['protein']), ['negative', 'trace'])) ? 'NORMAL' : 'ABNORMAL'; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['microscopy']) && !empty($test_data['microscopy'])): ?>
                    <div class="test-result-item" style="grid-column: 1 / -1;">
                        <div class="test-name">Microscopy</div>
                        <div class="test-value" style="font-size: 14px; line-height: 1.4;">
                            <?php echo nl2br(htmlspecialchars($test_data['microscopy'])); ?>
                        </div>
                        <div class="test-range">Microscopic examination findings</div>
                        <div class="test-status status-normal">EXAMINED</div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>

            <!-- Liver Function Test Section -->
            <?php 
                $liver_tests = ['gpt_alt', 'got_ast', 'total_bilirubin'];
                $has_liver = false;
                foreach ($liver_tests as $test) {
                    if (isset($test_data[$test]) && !empty($test_data[$test])) {
                        $has_liver = true;
                        break;
                    }
                }
            ?>
            
            <?php if ($has_liver): ?>
            <div class="test-section">
                <div class="test-section-header">
                    <i class="fa fa-user-md"></i>
                    Liver Function Test
                </div>
                <div class="test-results-grid">
                    <?php if (isset($test_data['gpt_alt']) && !empty($test_data['gpt_alt'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">GPT (ALT)</div>
                        <div class="test-value"><?php echo $test_data['gpt_alt']; ?> U/L</div>
                        <div class="test-range">Normal: 7-35 U/L</div>
                        <div class="test-status <?php 
                            $alt = floatval($test_data['gpt_alt']);
                            if ($alt < 7) echo 'status-low';
                            elseif ($alt > 100) echo 'status-critical';
                            elseif ($alt > 35) echo 'status-high';
                            else echo 'status-normal';
                        ?>">
                            <?php 
                                $alt = floatval($test_data['gpt_alt']);
                                if ($alt < 7) echo 'LOW';
                                elseif ($alt > 100) echo 'CRITICAL';
                                elseif ($alt > 35) echo 'HIGH';
                                else echo 'NORMAL';
                            ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['got_ast']) && !empty($test_data['got_ast'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">GOT (AST)</div>
                        <div class="test-value"><?php echo $test_data['got_ast']; ?> U/L</div>
                        <div class="test-range">Normal: 8-40 U/L</div>
                        <div class="test-status <?php 
                            $ast = floatval($test_data['got_ast']);
                            if ($ast < 8) echo 'status-low';
                            elseif ($ast > 120) echo 'status-critical';
                            elseif ($ast > 40) echo 'status-high';
                            else echo 'status-normal';
                        ?>">
                            <?php 
                                $ast = floatval($test_data['got_ast']);
                                if ($ast < 8) echo 'LOW';
                                elseif ($ast > 120) echo 'CRITICAL';
                                elseif ($ast > 40) echo 'HIGH';
                                else echo 'NORMAL';
                            ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if (isset($test_data['total_bilirubin']) && !empty($test_data['total_bilirubin'])): ?>
                    <div class="test-result-item">
                        <div class="test-name">Total Bilirubin</div>
                        <div class="test-value"><?php echo $test_data['total_bilirubin']; ?> mg/dL</div>
                        <div class="test-range">Normal: 0.2-1.2 mg/dL</div>
                        <div class="test-status <?php 
                            $bili = floatval($test_data['total_bilirubin']);
                            if ($bili < 0.2) echo 'status-low';
                            elseif ($bili > 3.0) echo 'status-critical';
                            elseif ($bili > 1.2) echo 'status-high';
                            else echo 'status-normal';
                        ?>">
                            <?php 
                                $bili = floatval($test_data['total_bilirubin']);
                                if ($bili < 0.2) echo 'LOW';
                                elseif ($bili > 3.0) echo 'CRITICAL';
                                elseif ($bili > 1.2) echo 'HIGH';
                                else echo 'NORMAL';
                            ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>

        <?php else: ?>
            <!-- No structured test results available -->
            <div class="test-section">
                <div class="test-section-header">
                    <i class="fa fa-file-text"></i>
                    Report Information
                </div>
                <div style="padding: 30px; text-align: center; color: #666;">
                    <i class="fa fa-info-circle fa-3x" style="margin-bottom: 15px;"></i>
                    <h4>Report Details</h4>
                    <p><strong>Report Title:</strong> <?php echo isset($report->report_title) ? $report->report_title : 'Lab Report'; ?></p>
                    <?php if (isset($report->report_description) && !empty($report->report_description)): ?>
                        <p><strong>Description:</strong> <?php echo $report->report_description; ?></p>
                    <?php endif; ?>
                    <?php if (isset($report->test_names) && !empty($report->test_names)): ?>
                        <p><strong>Tests Performed:</strong> <?php echo $report->test_names; ?></p>
                    <?php endif; ?>
                    <p style="margin-top: 20px;">
                        <em>Detailed test results are available in the attached report file.</em>
                    </p>
                </div>
            </div>
        <?php endif; ?>

        <!-- Clinical Notes Section -->
        <div class="clinical-notes">
            <h4><i class="fa fa-stethoscope"></i> Clinical Notes & Recommendations</h4>
            <?php if (isset($report->notes) && !empty($report->notes)): ?>
                <p><strong>Clinical Notes:</strong> <?php echo nl2br(htmlspecialchars($report->notes)); ?></p>
            <?php endif; ?>
            
            <?php if (isset($test_data['remarks']) && !empty($test_data['remarks'])): ?>
                <p><strong>Laboratory Remarks:</strong> <?php echo nl2br(htmlspecialchars($test_data['remarks'])); ?></p>
            <?php endif; ?>
            
            <p><strong>• Follow-up as recommended by your physician</strong></p>
            <p>• Maintain proper medication compliance if prescribed</p>
            <p>• Regular monitoring as advised by your healthcare provider</p>
            <?php if (isset($report->is_critical) && $report->is_critical == 1): ?>
                <p style="color: #dc3545; font-weight: bold;">• CRITICAL VALUES DETECTED - Immediate medical attention required</p>
            <?php endif; ?>
        </div>

        <!-- Summary Section -->
        <div class="summary-section">
            <div class="summary-title">
                <i class="fa fa-check-circle"></i>
                Summary
            </div>
            <div class="summary-content">
                <strong>Report Status:</strong> <?php echo isset($report->status) ? ucfirst($report->status) : 'Completed'; ?><br>
                <strong>Verification Status:</strong> 
                <?php if (isset($report->verified_at) && !empty($report->verified_at)): ?>
                    Verified on <?php echo date('d-M-Y H:i', strtotime($report->verified_at)); ?>
                    <?php if (isset($report->verified_by_name)): ?>
                        by <?php echo $report->verified_by_name; ?>
                    <?php endif; ?>
                <?php else: ?>
                    Pending Verification
                <?php endif; ?><br>
                
                <?php if (isset($report->verification_notes) && !empty($report->verification_notes)): ?>
                    <strong>Verification Notes:</strong> <?php echo $report->verification_notes; ?><br>
                <?php endif; ?>
                
                <em style="margin-top: 10px; display: block;">
                    For detailed interpretation and clinical correlation, please consult with your healthcare provider.
                </em>
            </div>
        </div>

        <!-- Footer Signatures -->
        <div class="footer-signatures">
            <div class="signature-block">
                <div class="signature-line">Lab Technician</div>
                <div class="signature-role"><?php echo isset($report->technician_name) ? $report->technician_name : 'Lab Staff'; ?></div>
            </div>
            
            <div class="signature-block">
                <div class="signature-line">Pathologist</div>
                <div class="signature-role">
                    <?php echo isset($report->verified_by_name) ? $report->verified_by_name : 'Dr. Clinical Pathologist'; ?>
                </div>
            </div>
            
            <div class="signature-block">
                <div class="signature-line">Lab Director</div>
                <div class="signature-role">Dr. Laboratory Director</div>
            </div>
        </div>

        <!-- Print Information -->
        <div class="print-info">
            <p><strong>This is a computer-generated report from City Health Hospital Laboratory.</strong></p>
            <p>Report generated on: <?php echo date('d-M-Y H:i:s'); ?></p>
            <p>For any queries, contact Laboratory Department: +254 20 4408298</p>
            <?php if (isset($report->original_filename)): ?>
                <p>Original file: <?php echo $report->original_filename; ?></p>
            <?php endif; ?>
        </div>
    </div>

    <script>
        // Auto-focus any critical alerts
        document.addEventListener('DOMContentLoaded', function() {
            const criticalAlert = document.getElementById('criticalAlert');
            if (criticalAlert && criticalAlert.style.display !== 'none') {
                criticalAlert.scrollIntoView({ behavior: 'smooth', block: 'center' });
            }
        });

        // Print function
        function printReport() {
            window.print();
        }
    </script>
</body>
</html>