<?php
// Complete Import Index View - Place this in: application/views/admin/import/index.php
?>
<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-upload"></i> Import Consumables & Stock
            <small>Bulk import nursing consumables, pharmacy stock, and lab supplies</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url('admin/dashboard'); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Import</li>
        </ol>
    </section>

    <section class="content">
        <!-- Import Steps Progress -->
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title">Import Progress</h3>
                    </div>
                    <div class="box-body">
                        <div class="import-steps">
                            <ul class="nav nav-pills nav-justified" id="import-steps">
                                <li class="active">
                                    <a href="#step1" data-toggle="tab" onclick="goToStep(1)">
                                        <i class="fa fa-file-o"></i> 1. Select Module & File
                                    </a>
                                </li>
                                <li>
                                    <a href="#step2" data-toggle="tab" onclick="goToStep(2)">
                                        <i class="fa fa-eye"></i> 2. Preview & Map Columns
                                    </a>
                                </li>
                                <li>
                                    <a href="#step3" data-toggle="tab" onclick="goToStep(3)">
                                        <i class="fa fa-cogs"></i> 3. Configure Options
                                    </a>
                                </li>
                                <li>
                                    <a href="#step4" data-toggle="tab" onclick="goToStep(4)">
                                        <i class="fa fa-play"></i> 4. Process Import
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Import Form -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <span id="step-title">Import Data</span>
                        </h3>
                    </div>
                    
                    <div class="box-body">
                        <div class="tab-content">
                            <!-- Step 1: Select Module & File -->
                            <div class="tab-pane active" id="step1">
                                <div class="alert alert-info">
                                    <h4><i class="icon fa fa-info"></i> Getting Started:</h4>
                                    <p>Select the type of data you want to import and upload your file. Make sure your file is properly formatted with the correct columns.</p>
                                </div>

                                <?php echo form_open_multipart('admin/import/upload_file', array('id' => 'upload-form')); ?>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="import_type">
                                                    <i class="fa fa-list"></i> Import Module
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-control" id="import_type" name="import_type" required>
                                                    <option value="">Select Import Module</option>
                                                    <?php if (isset($import_modules) && is_array($import_modules)): ?>
                                                        <?php foreach ($import_modules as $key => $module): ?>
                                                            <option value="<?php echo $key; ?>" 
                                                                    data-description="<?php echo isset($module['description']) ? $module['description'] : ''; ?>">
                                                                <?php echo isset($module['name']) ? $module['name'] : $key; ?>
                                                            </option>
                                                        <?php endforeach; ?>
                                                    <?php else: ?>
                                                        <option value="nursing_consumables">Nursing Consumables</option>
                                                        <option value="pharmacy_stock">Pharmacy Stock</option>
                                                        <option value="lab_supplies">Lab Supplies</option>
                                                    <?php endif; ?>
                                                </select>
                                                <small class="help-block" id="module-description">
                                                    Choose the type of items you want to import
                                                </small>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="import_file">
                                                    <i class="fa fa-file"></i> Select File
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input type="file" class="form-control" id="import_file" name="import_file" 
                                                       accept=".xls,.xlsx,.csv" required>
                                                <small class="help-block">
                                                    <strong>Supported formats:</strong> Excel (.xls, .xlsx) and CSV (.csv)<br>
                                                    <strong>Maximum size:</strong> 5MB
                                                </small>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h4 class="panel-title">
                                                        <i class="fa fa-list-alt"></i> Import Guidelines
                                                    </h4>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <h5><i class="fa fa-check-circle text-success"></i> Required Columns:</h5>
                                                            <ul class="list-unstyled">
                                                                <li><i class="fa fa-arrow-right"></i> <strong>Item Name</strong> - Name of the item</li>
                                                                <li><i class="fa fa-arrow-right"></i> <strong>Closing Stock</strong> - Current stock quantity</li>
                                                            </ul>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <h5><i class="fa fa-info-circle text-info"></i> Optional Columns:</h5>
                                                            <ul class="list-unstyled">
                                                                <li><i class="fa fa-arrow-right"></i> Opening Stock, Added, Transfer In/Out</li>
                                                                <li><i class="fa fa-arrow-right"></i> Sales, Adjusted, Assembly, Value</li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row">
                                                        <div class="col-md-12">
                                                            <h5><i class="fa fa-exclamation-triangle text-warning"></i> Important Notes:</h5>
                                                            <ul class="list-unstyled">
                                                                <li><i class="fa fa-arrow-right"></i> Remove any extra header rows or company logos from your file</li>
                                                                <li><i class="fa fa-arrow-right"></i> Use consistent naming for items (avoid typos)</li>
                                                                <li><i class="fa fa-arrow-right"></i> Numeric values should not contain currency symbols or commas</li>
                                                                <li><i class="fa fa-arrow-right"></i> Empty rows will be automatically skipped</li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-12">
                                            <button type="button" class="btn btn-info" id="download-template" disabled>
                                                <i class="fa fa-download"></i> Download Template
                                            </button>
                                            <button type="submit" class="btn btn-primary btn-lg" id="upload-btn">
                                                <i class="fa fa-upload"></i> Upload & Preview File
                                            </button>
                                        </div>
                                    </div>
                                <?php echo form_close(); ?>
                            </div>

                            <!-- Step 2: Preview & Map Columns -->
                            <div class="tab-pane" id="step2">
                                <div id="preview-section" style="display: none;">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="alert alert-success">
                                                <h4><i class="fa fa-check-circle"></i> File uploaded successfully!</h4>
                                                <p class="margin-bottom-0">
                                                    <strong><span id="total-records"></span></strong>
                                                    <br><small class="text-muted">Showing first <span id="preview-count"></span> records for preview</small>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h4 class="panel-title">
                                                        <i class="fa fa-columns"></i> Column Mapping
                                                    </h4>
                                                </div>
                                                <div class="panel-body">
                                                    <p class="text-muted">Map the columns from your file to the database fields:</p>
                                                    <div id="column-mapping-section">
                                                        <!-- Column mapping will be populated by JavaScript -->
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h4 class="panel-title">
                                                        <i class="fa fa-table"></i> Data Preview
                                                    </h4>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="table-responsive">
                                                        <table class="table table-bordered table-striped table-hover" id="preview-table">
                                                            <thead id="preview-header" class="bg-light-blue">
                                                                <!-- Headers will be populated by JavaScript -->
                                                            </thead>
                                                            <tbody id="preview-body">
                                                                <!-- Data will be populated by JavaScript -->
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-12">
                                            <button type="button" class="btn btn-default" onclick="goToStep(1)">
                                                <i class="fa fa-arrow-left"></i> Back to File Selection
                                            </button>
                                            <button type="button" class="btn btn-primary btn-lg" id="proceed-to-options">
                                                Next: Configure Options <i class="fa fa-arrow-right"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Step 3: Configure Options -->
                            <div class="tab-pane" id="step3">
                                <div id="options-section">
                                    <div class="alert alert-info">
                                        <h4><i class="fa fa-cogs"></i> Configure Import Settings:</h4>
                                        <p>Choose how you want to handle duplicates and configure additional import options.</p>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="panel panel-warning">
                                                <div class="panel-heading">
                                                    <h4 class="panel-title">
                                                        <i class="fa fa-copy"></i> Duplicate Handling
                                                    </h4>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="form-group">
                                                        <div class="radio">
                                                            <label>
                                                                <input type="radio" name="duplicate_action" value="skip" checked>
                                                                <strong>Skip existing items</strong>
                                                            </label>
                                                            <small class="help-block">Items that already exist will be skipped (recommended for safety)</small>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <div class="radio">
                                                            <label>
                                                                <input type="radio" name="duplicate_action" value="update">
                                                                <strong>Update existing items</strong>
                                                            </label>
                                                            <small class="help-block">Existing items will be updated with new values</small>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <div class="radio">
                                                            <label>
                                                                <input type="radio" name="duplicate_action" value="error">
                                                                <strong>Show error for duplicates</strong>
                                                            </label>
                                                            <small class="help-block">Import will fail if duplicates are found</small>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="panel panel-success">
                                                <div class="panel-heading">
                                                    <h4 class="panel-title">
                                                        <i class="fa fa-gear"></i> Import Settings
                                                    </h4>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="form-group">
                                                        <div class="checkbox">
                                                            <label>
                                                                <input type="checkbox" name="create_backup" value="1" checked>
                                                                <strong>Create backup before import</strong>
                                                            </label>
                                                            <small class="help-block">Recommended for safety - creates a backup of current data</small>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <div class="checkbox">
                                                            <label>
                                                                <input type="checkbox" name="validate_data" value="1" checked>
                                                                <strong>Validate data before import</strong>
                                                            </label>
                                                            <small class="help-block">Check for required fields and correct data types</small>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <div class="checkbox">
                                                            <label>
                                                                <input type="checkbox" name="update_stock" value="1">
                                                                <strong>Update stock movements</strong>
                                                            </label>
                                                            <small class="help-block">Log stock changes in movement history</small>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <div class="checkbox">
                                                            <label>
                                                                <input type="checkbox" name="send_notifications" value="1">
                                                                <strong>Send notifications</strong>
                                                            </label>
                                                            <small class="help-block">Notify relevant staff about the import</small>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-12">
                                            <button type="button" class="btn btn-default" onclick="goToStep(2)">
                                                <i class="fa fa-arrow-left"></i> Back to Preview
                                            </button>
                                            <button type="button" class="btn btn-primary btn-lg" id="proceed-to-import">
                                                Next: Process Import <i class="fa fa-arrow-right"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Step 4: Process Import -->
                            <div class="tab-pane" id="step4">
                                <div id="import-section">
                                    <div class="alert alert-warning">
                                        <h4><i class="fa fa-warning"></i> Ready to Import:</h4>
                                        <p>Click "Start Import" to begin processing your data. This action cannot be undone.</p>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-12">
                                            <!-- Import Progress -->
                                            <div class="panel panel-info" id="import-progress-panel" style="display: none;">
                                                <div class="panel-heading">
                                                    <h4 class="panel-title">
                                                        <i class="fa fa-spinner fa-spin"></i> Import in Progress
                                                    </h4>
                                                </div>
                                                <div class="panel-body">
                                                    <div class="progress progress-striped active" id="import-progress">
                                                        <div class="progress-bar progress-bar-primary" role="progressbar" 
                                                             aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%">
                                                            <span class="sr-only">0% Complete</span>
                                                        </div>
                                                    </div>
                                                    <p id="progress-message" class="text-center">
                                                        <i class="fa fa-clock-o"></i> Please wait while we process your data...
                                                    </p>
                                                </div>
                                            </div>
                                            
                                            <!-- Import Status -->
                                            <div id="import-status" class="alert" style="display: none;"></div>
                                            
                                            <!-- Import Summary -->
                                            <div id="import-summary" style="display: none;">
                                                <div class="panel panel-success">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <i class="fa fa-check-circle"></i> Import Summary
                                                        </h4>
                                                    </div>
                                                    <div class="panel-body">
                                                        <div class="row">
                                                            <div class="col-md-3 col-sm-6">
                                                                <div class="stat-box bg-aqua">
                                                                    <div class="stat-icon">
                                                                        <i class="fa fa-list"></i>
                                                                    </div>
                                                                    <h3 id="processed-count">0</h3>
                                                                    <p>Records Processed</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-sm-6">
                                                                <div class="stat-box bg-green">
                                                                    <div class="stat-icon">
                                                                        <i class="fa fa-check"></i>
                                                                    </div>
                                                                    <h3 id="successful-count" class="text-success">0</h3>
                                                                    <p>Successful</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-sm-6">
                                                                <div class="stat-box bg-red">
                                                                    <div class="stat-icon">
                                                                        <i class="fa fa-times"></i>
                                                                    </div>
                                                                    <h3 id="failed-count" class="text-danger">0</h3>
                                                                    <p>Failed</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3 col-sm-6">
                                                                <div class="stat-box bg-yellow">
                                                                    <div class="stat-icon">
                                                                        <i class="fa fa-percent"></i>
                                                                    </div>
                                                                    <h3 id="success-rate">0%</h3>
                                                                    <p>Success Rate</p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <div id="error-details" style="display: none; margin-top: 20px;">
                                                            <div class="panel panel-danger">
                                                                <div class="panel-heading">
                                                                    <h5 class="panel-title">
                                                                        <i class="fa fa-exclamation-triangle"></i> Error Details
                                                                    </h5>
                                                                </div>
                                                                <div class="panel-body">
                                                                    <div class="alert alert-warning">
                                                                        <ul id="error-list" class="margin-bottom-0"></ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-12">
                                            <button type="button" class="btn btn-default" id="back-to-options" onclick="goToStep(3)">
                                                <i class="fa fa-arrow-left"></i> Back to Options
                                            </button>
                                            <button type="button" class="btn btn-success btn-lg" id="start-import">
                                                <i class="fa fa-play"></i> Start Import
                                            </button>
                                            <button type="button" class="btn btn-danger" id="cancel-import" style="display: none;">
                                                <i class="fa fa-stop"></i> Cancel Import
                                            </button>
                                            <button type="button" class="btn btn-default" id="start-over" style="display: none;">
                                                <i class="fa fa-refresh"></i> Start New Import
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Imports -->
        <?php if (isset($recent_imports) && !empty($recent_imports)): ?>
        <div class="row">
            <div class="col-md-12">
                <div class="box box-info collapsed-box">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-history"></i> Recent Imports
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-plus"></i>
                            </button>
                            <a href="<?php echo site_url('admin/import/history'); ?>" class="btn btn-sm btn-default">
                                <i class="fa fa-list"></i> View All History
                            </a>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th><i class="fa fa-calendar"></i> Date</th>
                                        <th><i class="fa fa-tag"></i> Module</th>
                                        <th><i class="fa fa-file"></i> Filename</th>
                                        <th><i class="fa fa-list-ol"></i> Records</th>
                                        <th><i class="fa fa-info-circle"></i> Status</th>
                                        <th><i class="fa fa-user"></i> User</th>
                                        <th><i class="fa fa-cogs"></i> Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($recent_imports as $import): ?>
                                    <tr>
                                        <td>
                                            <small><?php echo date('M j, Y H:i', strtotime($import->created_at)); ?></small>
                                        </td>
                                        <td>
                                            <span class="label label-info">
                                                <?php echo ucwords(str_replace('_', ' ', $import->import_type)); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <small><?php echo $import->filename; ?></small>
                                        </td>
                                        <td>
                                            <span class="badge bg-blue"><?php echo $import->records_processed; ?></span>
                                            <?php if ($import->records_successful > 0): ?>
                                                <span class="badge bg-green"><?php echo $import->records_successful; ?></span>
                                            <?php endif; ?>
                                            <?php if ($import->records_failed > 0): ?>
                                                <span class="badge bg-red"><?php echo $import->records_failed; ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ($import->status == 'completed'): ?>
                                                <span class="label label-success">Completed</span>
                                            <?php elseif ($import->status == 'failed'): ?>
                                                <span class="label label-danger">Failed</span>
                                            <?php else: ?>
                                                <span class="label label-warning">In Progress</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <small><?php echo isset($import->user_name) ? $import->user_name : 'System'; ?></small>
                                        </td>
                                        <td>
                                            <a href="<?php echo site_url('admin/import/view_import/' . $import->id); ?>" 
                                               class="btn btn-xs btn-info" title="View Details">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </section>
</div>

<!-- Loading Modal -->
<div class="modal fade" id="loading-modal" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-body text-center">
                <i class="fa fa-spinner fa-spin fa-3x text-primary"></i>
                <h4 id="loading-message" class="margin-top">Processing...</h4>
                <p id="loading-details" class="text-muted">Please wait while we process your request.</p>
            </div>
        </div>
    </div>
</div>

<style>
/* Import Steps Styling */
.import-steps {
    margin-bottom: 20px;
}

.import-steps .nav-pills > li > a {
    border-radius: 4px;
    font-weight: 500;
    padding: 12px 20px;
    margin: 0 2px;
    transition: all 0.3s ease;
}

.import-steps .nav-pills > li.active > a,
.import-steps .nav-pills > li.active > a:focus,
.import-steps .nav-pills > li.active > a:hover {
    background-color: #3c8dbc;
    color: white;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.import-steps .nav-pills > li:not(.active) > a {
    background-color: #f4f4f4;
    color: #666;
}

.import-steps .nav-pills > li:not(.active) > a:hover {
    background-color: #e0e0e0;
    color: #333;
}

/* Statistics Boxes */
.stat-box {
    text-align: center;
    padding: 20px 15px;
    border-radius: 8px;
    color: white;
    position: relative;
    overflow: hidden;
    margin-bottom: 15px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

.stat-box .stat-icon {
    position: absolute;
    top: 15px;
    right: 15px;
    font-size: 24px;
    opacity: 0.3;
}

.stat-box h3 {
    margin: 0 0 8px 0;
    font-size: 32px;
    font-weight: bold;
    text-shadow: 1px 1px 2px rgba(0,0,0,0.1);
}

.stat-box p {
    margin: 0;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    opacity: 0.9;
}

/* Progress Bar */
.progress {
    height: 30px;
    margin-bottom: 20px;
    border-radius: 4px;
    box-shadow: inset 0 1px 2px rgba(0,0,0,0.1);
}

.progress-bar {
    line-height: 30px;
    font-size: 14px;
    font-weight: 500;
    transition: width 0.6s ease;
}

/* Table Styling */
#preview-table {
    font-size: 12px;
    margin-bottom: 0;
}

#preview-table th {
    background-color: #f8f9fa;
    font-weight: 600;
    text-align: center;
    padding: 12px 8px;
    border-bottom: 2px solid #dee2e6;
}

#preview-table td {
    padding: 10px 8px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    max-width: 150px;
    vertical-align: middle;
}

#preview-table tbody tr:hover {
    background-color: #f8f9fa;
}

/* Form Styling */
.form-group label {
    font-weight: 600;
    margin-bottom: 8px;
    color: #333;
}

.form-group .help-block {
    font-size: 12px;
    color: #737373;
    margin-top: 5px;
    line-height: 1.4;
}

.form-control {
    border-radius: 4px;
    border: 1px solid #ddd;
    transition: border-color 0.3s ease;
}

.form-control:focus {
    border-color: #3c8dbc;
    box-shadow: 0 0 0 2px rgba(60, 141, 188, 0.1);
}

/* Radio and Checkbox Styling */
.radio label,
.checkbox label {
    font-weight: normal;
    margin-bottom: 8px;
    cursor: pointer;
    padding-left: 25px;
}

.radio input[type="radio"],
.checkbox input[type="checkbox"] {
    margin-left: -25px;
    margin-right: 0;
}

/* Panel Styling */
.panel {
    border-radius: 6px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.08);
    border: 1px solid #e0e0e0;
}

.panel-heading {
    border-radius: 5px 5px 0 0;
    padding: 12px 15px;
}

.panel-title {
    font-size: 15px;
    font-weight: 600;
    margin: 0;
}

.panel-body {
    padding: 20px 15px;
}

/* Alert Styling */
.alert {
    border-radius: 6px;
    border: none;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}

.alert h4 {
    margin-top: 0;
    margin-bottom: 10px;
    font-weight: 600;
}

.alert-dismissible .close {
    position: relative;
    top: -2px;
    right: -21px;
    color: inherit;
    opacity: 0.7;
}

.alert-dismissible .close:hover {
    opacity: 1;
}

/* Button Styling */
.btn {
    border-radius: 4px;
    font-weight: 500;
    padding: 8px 16px;
    margin-right: 8px;
    transition: all 0.3s ease;
}

.btn:last-child {
    margin-right: 0;
}

.btn-lg {
    padding: 12px 24px;
    font-size: 16px;
}

.btn-primary {
    background-color: #3c8dbc;
    border-color: #367fa9;
}

.btn-primary:hover {
    background-color: #367fa9;
    border-color: #2e6da4;
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.btn-success {
    background-color: #00a65a;
    border-color: #008d4c;
}

.btn-success:hover {
    background-color: #008d4c;
    border-color: #007438;
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

/* Column Mapping Styling */
.column-mapping-row {
    margin-bottom: 15px;
    padding: 15px;
    border: 1px solid #e0e0e0;
    border-radius: 6px;
    background-color: #fafafa;
    transition: all 0.3s ease;
}

.column-mapping-row:hover {
    background-color: #f0f8ff;
    border-color: #3c8dbc;
}

.column-mapping-row label {
    font-weight: 600;
    margin-bottom: 8px;
    color: #333;
}

.field-type {
    font-size: 12px;
    color: #666;
    font-style: italic;
    padding: 4px 8px;
    background-color: #e9ecef;
    border-radius: 3px;
    display: inline-block;
    margin-top: 5px;
}

/* Step Title Animation */
#step-title {
    transition: all 0.3s ease;
}

/* Loading States */
.btn[disabled] {
    opacity: 0.6;
    cursor: not-allowed;
}

/* Responsive Design */
@media (max-width: 768px) {
    .import-steps .nav-pills > li > a {
        padding: 8px 12px;
        font-size: 12px;
    }
    
    #preview-table th,
    #preview-table td {
        max-width: 100px;
        font-size: 11px;
        padding: 6px 4px;
    }
    
    .stat-box {
        margin-bottom: 10px;
    }
    
    .stat-box h3 {
        font-size: 24px;
    }
    
    .stat-box .stat-icon {
        font-size: 20px;
    }
    
    .btn-lg {
        padding: 10px 20px;
        font-size: 14px;
    }
    
    .panel-body {
        padding: 15px 10px;
    }
}

@media (max-width: 480px) {
    .import-steps .nav-pills > li > a {
        padding: 6px 8px;
        font-size: 10px;
    }
    
    .import-steps .nav-pills > li > a i {
        display: none;
    }
    
    .btn {
        margin-bottom: 5px;
        width: 100%;
    }
    
    .btn:last-child {
        margin-right: 0;
    }
}

/* Background Colors for Statistics */
.bg-aqua { background-color: #00c0ef !important; }
.bg-green { background-color: #00a65a !important; }
.bg-red { background-color: #dd4b39 !important; }
.bg-yellow { background-color: #f39c12 !important; }

/* Animation Classes */
.fade-in {
    animation: fadeIn 0.5s ease-in;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

.slide-up {
    animation: slideUp 0.3s ease-out;
}

@keyframes slideUp {
    from { opacity: 0; transform: translateY(30px); }
    to { opacity: 1; transform: translateY(0); }
}

/* Box hover effects */
.box:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    transition: box-shadow 0.3s ease;
}

/* Success/Error states */
.has-success .form-control {
    border-color: #00a65a;
}

.has-error .form-control {
    border-color: #dd4b39;
}

/* File input styling */
input[type="file"] {
    padding: 6px 12px;
}

/* Custom scrollbar for tables */
.table-responsive::-webkit-scrollbar {
    height: 8px;
}

.table-responsive::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 4px;
}

.table-responsive::-webkit-scrollbar-thumb {
    background: #c1c1c1;
    border-radius: 4px;
}

.table-responsive::-webkit-scrollbar-thumb:hover {
    background: #a8a8a8;
}

/* Print styles */
@media print {
    .box-tools,
    .btn,
    .import-steps,
    .alert-info {
        display: none !important;
    }
    
    .box {
        box-shadow: none;
        border: 1px solid #000;
    }
}
</style>

<script>
$(document).ready(function() {
    // Global variables
    var currentStep = 1;
    var columnMapping = {};
    var importSession = null;

    // Initialize import functionality
    console.log('Import page loaded successfully');
    updateStepTitle();

    // Handle import_type dropdown change
    $('#import_type').change(function() {
        var selectedOption = $(this).find('option:selected');
        var description = selectedOption.attr('data-description') || 'Choose the type of items you want to import';
        $('#module-description').text(description);
        $('#download-template').prop('disabled', !$(this).val());
        
        // Update template download URL
        if ($(this).val()) {
            $('#download-template').removeClass('disabled');
        } else {
            $('#download-template').addClass('disabled');
        }
    });

    // Handle Download Template button click
    $('#download-template').click(function() {
        var importType = $('#import_type').val();
        if (!importType) {
            showAlert('warning', 'Please select an import module before downloading the template.');
            return false;
        }
        
        var downloadUrl = '<?php echo site_url('admin/import/download_template/'); ?>' + importType;
        window.location.href = downloadUrl;
        return false;
    });

    // Handle Upload & Preview form submission
    $('#upload-form').submit(function(e) {
        e.preventDefault();
        
        var importType = $('#import_type').val();
        var fileInput = $('#import_file')[0];
        
        // Validation
        if (!importType) {
            showAlert('warning', 'Please select an import module.');
            return false;
        }
        
        if (!fileInput.files.length) {
            showAlert('warning', 'Please select a file to upload.');
            return false;
        }
        
        // File size validation (5MB = 5 * 1024 * 1024 bytes)
        var maxSize = 5 * 1024 * 1024;
        if (fileInput.files[0].size > maxSize) {
            showAlert('danger', 'File size must be less than 5MB. Your file is ' + 
                     (fileInput.files[0].size / (1024 * 1024)).toFixed(2) + 'MB.');
            return false;
        }
        
        // File type validation
        var allowedTypes = ['application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'text/csv'];
        var fileType = fileInput.files[0].type;
        var fileName = fileInput.files[0].name.toLowerCase();
        var fileExtension = fileName.split('.').pop();
        
        if (!allowedTypes.includes(fileType) && !['csv', 'xls', 'xlsx'].includes(fileExtension)) {
            showAlert('danger', 'Please select a valid file format (.csv, .xls, or .xlsx).');
            return false;
        }
        
        var formData = new FormData(this);
        uploadFile(formData);
    });

    // Handle step navigation buttons
    $('#proceed-to-options').click(function() {
        if (validateColumnMapping()) {
            goToStep(3);
        }
    });

    $('#proceed-to-import').click(function() {
        goToStep(4);
    });

    // Handle import buttons
    $('#start-import').click(function() {
        if (confirm('Are you sure you want to start the import? This action cannot be undone.')) {
            startImport();
        }
    });

    $('#cancel-import').click(function() {
        if (confirm('Are you sure you want to cancel the import?')) {
            cancelImport();
        }
    });

    $('#start-over').click(function() {
        if (confirm('This will start a new import process. Continue?')) {
            location.reload();
        }
    });

    // Functions
    function uploadFile(formData) {
        $.ajax({
            url: '<?php echo site_url('admin/import/upload_file'); ?>',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function() {
                $('#upload-btn').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Uploading...');
                showLoading('Uploading File', 'Please wait while we analyze your file...');
            },
            success: function(response) {
                hideLoading();
                
                if (response.status === 'success') {
                    importSession = response;
                    showPreview(response);
                    goToStep(2);
                    showAlert('success', 'File uploaded successfully! Review the preview below.');
                } else {
                    showAlert('danger', 'Upload failed: ' + response.message);
                }
            },
            error: function(xhr, status, error) {
                hideLoading();
                var errorMessage = 'Upload failed: ';
                
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage += xhr.responseJSON.message;
                } else if (xhr.status === 413) {
                    errorMessage += 'File too large. Maximum size is 5MB.';
                } else if (xhr.status === 0) {
                    errorMessage += 'Connection failed. Please check your internet connection.';
                } else {
                    errorMessage += error || 'Server error occurred.';
                }
                
                showAlert('danger', errorMessage);
            },
            complete: function() {
                $('#upload-btn').prop('disabled', false).html('<i class="fa fa-upload"></i> Upload & Preview File');
            }
        });
    }

    function showPreview(response) {
        // Update record counts
        $('#total-records').text(response.total_records + ' total records found.');
        $('#preview-count').text(response.preview_count || response.preview_data.data.length);

        // Show preview section with animation
        $('#preview-section').hide().removeClass('slide-up').addClass('slide-up').fadeIn(300);

        // Build column mapping
        buildColumnMapping(response.preview_data.columns);

        // Build preview table
        buildPreviewTable(response.preview_data.columns, response.preview_data.data);

        // Show additional info if there are more records
        if (response.total_records > (response.preview_count || response.preview_data.data.length)) {
            var moreRecordsMsg = '<div class="alert alert-info margin-top fade-in">' +
                               '<i class="fa fa-info-circle"></i> ' +
                               'This preview shows the first ' + (response.preview_count || response.preview_data.data.length) + ' records. ' +
                               'All ' + response.total_records + ' records will be processed during import.' +
                               '</div>';
            $('#preview-section').append(moreRecordsMsg);
        }

        // Enable next step
        $('#proceed-to-options').prop('disabled', false).removeClass('disabled');
    }

    function buildColumnMapping(columns) {
        var mappingHtml = '';
        var dbFields = getDbFieldsForModule($('#import_type').val());
        
        columns.forEach(function(column, index) {
            mappingHtml += '<div class="column-mapping-row">';
            mappingHtml += '<div class="row">';
            mappingHtml += '<div class="col-md-4">';
            mappingHtml += '<label><i class="fa fa-file-text-o"></i> File Column:</label>';
            mappingHtml += '<div class="well well-sm"><strong>' + column + '</strong></div>';
            mappingHtml += '</div>';
            mappingHtml += '<div class="col-md-4">';
            mappingHtml += '<label><i class="fa fa-database"></i> Maps to Database Field:</label>';
            mappingHtml += '<select class="form-control column-mapping" data-column="' + index + '">';
            mappingHtml += '<option value="">-- Do not import --</option>';
            
            dbFields.forEach(function(field) {
                var selected = autoMapColumn(column, field.value) ? 'selected' : '';
                var required = field.required ? ' (Required)' : '';
                mappingHtml += '<option value="' + field.value + '" ' + selected + '>' + 
                             field.label + required + '</option>';
            });
            
            mappingHtml += '</select>';
            mappingHtml += '</div>';
            mappingHtml += '<div class="col-md-4">';
            mappingHtml += '<label><i class="fa fa-info-circle"></i> Field Type:</label>';
            mappingHtml += '<div class="field-type" id="field-type-' + index + '">-</div>';
            mappingHtml += '</div>';
            mappingHtml += '</div>';
            mappingHtml += '</div>';
        });
        
        $('#column-mapping-section').html(mappingHtml);
        
        // Add change event listeners
        $('.column-mapping').change(function() {
            var columnIndex = $(this).data('column');
            var fieldValue = $(this).val();
            var fieldType = getFieldType(fieldValue);
            $('#field-type-' + columnIndex).text(fieldType);
            
            // Update column mapping object
            if (fieldValue) {
                columnMapping[columnIndex] = fieldValue;
            } else {
                delete columnMapping[columnIndex];
            }
        });
        
        // Trigger change event to populate field types
        $('.column-mapping').trigger('change');
    }

    function buildPreviewTable(columns, data) {
        // Build header
        var headerHtml = '<tr>';
        columns.forEach(function(column) {
            headerHtml += '<th>' + column + '</th>';
        });
        headerHtml += '</tr>';
        $('#preview-header').html(headerHtml);
        
        // Build body
        var bodyHtml = '';
        data.forEach(function(row, rowIndex) {
            bodyHtml += '<tr>';
            row.forEach(function(cell) {
                var cellValue = cell || '';
                // Truncate long values for display
                if (typeof cellValue === 'string' && cellValue.length > 50) {
                    cellValue = cellValue.substring(0, 47) + '...';
                }
                bodyHtml += '<td title="' + (cell || '') + '">' + cellValue + '</td>';
            });
            bodyHtml += '</tr>';
        });
        $('#preview-body').html(bodyHtml);
    }

    function validateColumnMapping() {
        var hasRequired = false;
        var requiredFields = ['item_name', 'closing_stock'];
        var mappedFields = Object.values(columnMapping);
        
        // Check if required fields are mapped
        requiredFields.forEach(function(field) {
            if (mappedFields.includes(field)) {
                hasRequired = true;
            }
        });
        
        if (!hasRequired) {
            showAlert('warning', 'Please map at least the required fields: Item Name and Closing Stock');
            return false;
        }
        
        return true;
    }

    function startImport() {
        // Collect import options
        var importOptions = {
            duplicate_action: $('input[name="duplicate_action"]:checked').val(),
            create_backup: $('input[name="create_backup"]:checked').length > 0 ? '1' : '0',
            validate_data: $('input[name="validate_data"]:checked').length > 0 ? '1' : '0',
            update_stock: $('input[name="update_stock"]:checked').length > 0 ? '1' : '0',
            send_notifications: $('input[name="send_notifications"]:checked').length > 0 ? '1' : '0',
            column_mapping: columnMapping
        };

        // Update UI
        $('#start-import, #back-to-options').hide();
        $('#cancel-import').show();
        $('#import-progress-panel').show();
        updateProgress(10, 'Initializing import...');

        // Make AJAX call
        $.ajax({
            url: '<?php echo site_url('admin/import/process_import'); ?>',
            type: 'POST',
            data: { import_options: importOptions },
            dataType: 'json',
            timeout: 300000, // 5 minutes timeout
            success: function(response) {
                $('#import-progress-panel').hide();
                $('#cancel-import').hide();
                
                if (response.status === 'success') {
                    showImportSummary(response.summary);
                    showAlert('success', '<strong>Import completed successfully!</strong> Check the summary below for details.');
                } else {
                    showAlert('danger', '<strong>Import failed:</strong> ' + response.message);
                }
                
                $('#start-over').show();
            },
            error: function(xhr, status, error) {
                $('#import-progress-panel').hide();
                $('#cancel-import').hide();
                
                var errorMessage = 'Import failed: ';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage += xhr.responseJSON.message;
                } else if (status === 'timeout') {
                    errorMessage += 'Import timed out. Please check if the import completed successfully.';
                } else {
                    errorMessage += error || 'Server error occurred.';
                }
                
                showAlert('danger', '<strong>Import failed:</strong> ' + errorMessage);
                $('#start-over').show();
            }
        });
    }

    function cancelImport() {
        $.ajax({
            url: '<?php echo site_url('admin/import/cancel_import'); ?>',
            type: 'POST',
            success: function() {
                showAlert('info', 'Import cancelled successfully.');
                setTimeout(function() {
                    location.reload();
                }, 2000);
            },
            error: function() {
                showAlert('danger', 'Error cancelling import. Please refresh the page.');
            }
        });
    }

    function showImportSummary(summary) {
        $('#processed-count').text(summary.processed || 0);
        $('#successful-count').text(summary.successful || 0);
        $('#failed-count').text(summary.failed || 0);
        
        var successRate = summary.processed > 0 ? 
            Math.round((summary.successful / summary.processed) * 100) : 0;
        $('#success-rate').text(successRate + '%');
        
        if (summary.errors && summary.errors.length > 0) {
            var errorHtml = '';
            summary.errors.forEach(function(error) {
                errorHtml += '<li>' + error + '</li>';
            });
            $('#error-list').html(errorHtml);
            $('#error-details').show();
        }
        
        $('#import-summary').fadeIn(500);
    }

    function updateProgress(percent, message) {
        $('.progress-bar').css('width', percent + '%').attr('aria-valuenow', percent);
        $('.progress-bar .sr-only').text(percent + '% Complete');
        
        if (message) {
            $('#progress-message').html('<i class="fa fa-cog fa-spin"></i> ' + message);
        }
    }

    function showAlert(type, message) {
        var alertClass = 'alert-' + type;
        var iconClass = {
            'success': 'fa-check-circle',
            'danger': 'fa-exclamation-triangle',
            'warning': 'fa-warning', 
            'info': 'fa-info-circle'
        }[type] || 'fa-info-circle';
        
        var alertHtml = '<div class="alert ' + alertClass + ' alert-dismissible fade-in">' +
                        '<button type="button" class="close" data-dismiss="alert">&times;</button>' +
                        '<i class="fa ' + iconClass + '"></i> ' + message +
                        '</div>';
        
        // Remove existing alerts in the current step
        $('.tab-pane.active .alert-dismissible').remove();
        
        // Add new alert at the top of current step
        $('.tab-pane.active').prepend(alertHtml);
        
        // Auto dismiss after 5 seconds for success messages
        if (type === 'success' || type === 'info') {
            setTimeout(function() {
                $('.alert-' + type).fadeOut();
            }, 5000);
        }
    }

    function showLoading(title, message) {
        $('#loading-message').text(title);
        $('#loading-details').text(message);
        $('#loading-modal').modal('show');
    }

    function hideLoading() {
        $('#loading-modal').modal('hide');
    }

    function updateStepTitle() {
        var titles = {
            1: 'Step 1: Select Module & File',
            2: 'Step 2: Preview & Map Columns', 
            3: 'Step 3: Configure Options',
            4: 'Step 4: Process Import'
        };
        $('#step-title').text(titles[currentStep] || 'Import Data');
    }

    function getDbFieldsForModule(moduleType) {
        var commonFields = [
            { value: 'item_name', label: 'Item Name', required: true },
            { value: 'closing_stock', label: 'Closing Stock', required: true },
            { value: 'opening_stock', label: 'Opening Stock', required: false },
            { value: 'added', label: 'Added', required: false },
            { value: 'transfer_in', label: 'Transfer In', required: false },
            { value: 'transfer_out', label: 'Transfer Out', required: false },
            { value: 'sales', label: 'Sales', required: false },
            { value: 'adjusted', label: 'Adjusted', required: false },
            { value: 'value', label: 'Value', required: false }
        ];
        
        if (moduleType === 'pharmacy_stock') {
            commonFields.push({ value: 'assembly', label: 'Assembly', required: false });
        }
        
        return commonFields;
    }

    function autoMapColumn(columnName, fieldValue) {
        var columnLower = columnName.toLowerCase().replace(/[^a-z]/g, '');
        var fieldLower = fieldValue.toLowerCase().replace(/[^a-z]/g, '');
        
        // Exact matches
        if (columnLower === fieldLower) return true;
        
        // Common variations
        var mappings = {
            'itemname': 'item_name',
            'item': 'item_name',
            'name': 'item_name',
            'productname': 'item_name',
            'description': 'item_name',
            'openingstock': 'opening_stock',
            'opening': 'opening_stock',
            'closingstock': 'closing_stock',
            'closing': 'closing_stock',
            'stock': 'closing_stock',
            'quantity': 'closing_stock',
            'transferin': 'transfer_in',
            'transferout': 'transfer_out',
            'adjusted': 'adjusted',
            'adjustment': 'adjusted',
            'sales': 'sales',
            'sold': 'sales',
            'value': 'value',
            'amount': 'value',
            'price': 'value',
            'cost': 'value'
        };
        
        return mappings[columnLower] === fieldValue;
    }

    function getFieldType(fieldValue) {
        var types = {
            'item_name': 'Text',
            'opening_stock': 'Number',
            'closing_stock': 'Number',
            'added': 'Number',
            'transfer_in': 'Number',
            'transfer_out': 'Number',
            'sales': 'Number',
            'adjusted': 'Number',
            'assembly': 'Number',
            'value': 'Decimal'
        };
        
        return types[fieldValue] || 'Unknown';
    }

    // Global function for step navigation
    window.goToStep = function(step) {
        // Update navigation
        $('#import-steps li').removeClass('active');
        $('#import-steps li').eq(step - 1).addClass('active');
        
        // Update content
        $('.tab-pane').removeClass('active');
        $('#step' + step).addClass('active');
        
        // Update step title
        currentStep = step;
        updateStepTitle();
        
        // Clear alerts when moving between steps
        $('.alert-dismissible').fadeOut();
        
        console.log('Moved to step: ' + step);
    };
});
</script>