<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Payslip - <?php echo $payroll->name . ' ' . $payroll->surname; ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 20px;
            background: white;
        }
        .payslip-container {
            max-width: 800px;
            margin: 0 auto;
            border: 1px solid #ddd;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #000;
            padding-bottom: 15px;
        }
        .logo {
            width: 60px;
            height: 60px;
            margin-bottom: 10px;
        }
        .company-name {
            font-size: 18px;
            font-weight: bold;
            margin: 10px 0;
            text-transform: uppercase;
        }
        .payslip-title {
            font-size: 16px;
            font-weight: bold;
            margin: 5px 0;
        }
        .employee-info {
            margin-bottom: 25px;
        }
        .employee-name {
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        .employee-number {
            font-size: 12px;
            margin-bottom: 5px;
        }
        .payslip-content {
            display: flex;
            justify-content: space-between;
        }
        .left-section {
            width: 48%;
        }
        .right-section {
            width: 48%;
        }
        .section {
            margin-bottom: 20px;
        }
        .section-title {
            font-weight: bold;
            font-size: 14px;
            margin-bottom: 10px;
            padding-bottom: 5px;
            border-bottom: 1px solid #000;
            text-transform: uppercase;
        }
        .amount-table {
            width: 100%;
            border-collapse: collapse;
        }
        .amount-table td {
            padding: 3px 5px;
            border: none;
        }
        .amount-table .label {
            text-align: left;
        }
        .amount-table .amount {
            text-align: right;
            font-family: monospace;
        }
        .total-row {
            border-top: 1px solid #000;
            font-weight: bold;
        }
        .net-pay {
            margin-top: 20px;
            padding: 10px;
            background-color: #f5f5f5;
            border: 2px solid #000;
        }
        .net-pay-amount {
            font-size: 16px;
            font-weight: bold;
            text-align: right;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        .no-print {
            text-align: center;
            margin: 20px 0;
        }
        .btn {
            background-color: #007bff;
            color: white;
            padding: 8px 16px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            margin: 0 5px;
            text-decoration: none;
            display: inline-block;
        }
        .btn-success { background-color: #28a745; }
        .btn-info { background-color: #17a2b8; }
        
        @media print {
            .no-print { display: none; }
            body { margin: 0; }
            .payslip-container { border: none; margin: 0; max-width: none; }
        }
    </style>
</head>
<body>
    <div class="payslip-container">
        <!-- Header -->
        <div class="header">
            <img src="<?php echo base_url(); ?>assets/images/logo.png" alt="Logo" class="logo">
            <div class="company-name"><?php echo $this->config->item('hospital_name') ?: 'Hospital Management System'; ?></div>
            <div class="payslip-title"><?php echo strtoupper(date('F Y', mktime(0, 0, 0, $payroll->month, 1, $payroll->year))); ?> PAYSLIP</div>
        </div>

        <!-- Employee Information -->
        <div class="employee-info">
            <div class="employee-name">EMPLOYEE NAME: <?php echo strtoupper($payroll->name . ' ' . $payroll->surname); ?></div>
            <div class="employee-number">EMPLOYEE NO: <?php echo $payroll->employee_id; ?></div>
        </div>

        <!-- Payslip Content -->
        <div class="payslip-content">
            <!-- Left Section -->
            <div class="left-section">
                <!-- Earnings Section -->
                <div class="section">
                    <div class="section-title">Earnings</div>
                    <table class="amount-table">
                        <?php 
                        $total_earnings = 0;
                        foreach ($earnings as $code => $amount): 
                            if ($amount > 0):
                                $total_earnings += $amount;
                        ?>
                        <tr>
                            <td class="label"><?php echo isset($component_names[$code]) ? $component_names[$code] : $code; ?></td>
                            <td class="amount"><?php echo number_format($amount, 2); ?></td>
                        </tr>
                        <?php 
                            endif;
                        endforeach; 
                        ?>
                        <?php if (count(array_filter($earnings)) > 1): ?>
                        <tr class="total-row">
                            <td class="label">Total Earnings</td>
                            <td class="amount"><?php echo number_format($total_earnings, 2); ?></td>
                        </tr>
                        <?php endif; ?>
                    </table>
                </div>

                <!-- Tax Calculation Section -->
                <div class="section">
                    <div class="section-title">Tax Calculation</div>
                    <table class="amount-table">
                        <tr>
                            <td class="label">Defined contribution</td>
                            <td class="amount"><?php echo number_format($deductions['NSSF'] ?? 0, 2); ?></td>
                        </tr>
                        <tr>
                            <td class="label">Taxable Pay</td>
                            <td class="amount"><?php echo number_format($details['taxable_pay'] ?? 0, 2); ?></td>
                        </tr>
                        <tr>
                            <td class="label">Tax charged</td>
                            <td class="amount"><?php echo number_format($deductions['PAYE'] ?? 0, 2); ?></td>
                        </tr>
                        <tr>
                            <td class="label">Relief</td>
                            <td class="amount"><?php echo number_format($details['tax_relief'] ?? 1408, 2); ?></td>
                        </tr>
                    </table>
                </div>
            </div>

            <!-- Right Section -->
            <div class="right-section">
                <!-- Deductions Section -->
                <div class="section">
                    <div class="section-title">Deductions</div>
                    <table class="amount-table">
                        <?php 
                        // Order deductions properly
                        $ordered_deductions = ['PAYE', 'NSSF', 'NHIF', 'AHL', 'LOAN', 'ADVANCE'];
                        
                        // Display ordered deductions first
                        foreach ($ordered_deductions as $code):
                            if (isset($deductions[$code]) && $deductions[$code] > 0):
                        ?>
                        <tr>
                            <td class="label"><?php echo isset($component_names[$code]) ? $component_names[$code] : $code; ?></td>
                            <td class="amount"><?php echo number_format($deductions[$code], 2); ?></td>
                        </tr>
                        <?php 
                            endif;
                        endforeach;
                        
                        // Display any remaining deductions
                        foreach ($deductions as $code => $amount):
                            if (!in_array($code, $ordered_deductions) && $amount > 0):
                        ?>
                        <tr>
                            <td class="label"><?php echo isset($component_names[$code]) ? $component_names[$code] : $code; ?></td>
                            <td class="amount"><?php echo number_format($amount, 2); ?></td>
                        </tr>
                        <?php 
                            endif;
                        endforeach; 
                        ?>
                        <tr class="total-row">
                            <td class="label">Total Deductions</td>
                            <td class="amount"><?php echo number_format($payroll->total_deductions, 2); ?></td>
                        </tr>
                    </table>
                </div>

                <!-- Net Pay Section -->
                <div class="net-pay">
                    <table class="amount-table">
                        <tr>
                            <td class="label" style="font-size: 16px;"><strong>NET PAY</strong></td>
                            <td class="net-pay-amount"><strong><?php echo number_format($payroll->net_salary, 2); ?></strong></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <!-- Action Buttons (No Print) -->
        <div class="no-print">
            <button class="btn" onclick="window.print()">Print Payslip</button>
            <a href="<?php echo base_url(); ?>admin/payslip/generate/<?php echo $payroll->id; ?>" class="btn btn-info" target="_blank">Download PDF</a>
            <button class="btn btn-success" onclick="emailPayslip(<?php echo $payroll->id; ?>)">Email Payslip</button>
            <a href="<?php echo base_url(); ?>admin/hr/payroll" class="btn">Back to Payroll</a>
        </div>

        <!-- Footer -->
        <div class="footer">
            Generated on <?php echo date('d/m/Y H:i:s'); ?> | 
            <?php echo $this->config->item('hospital_name') ?: 'Hospital Management System'; ?> Payroll System
        </div>
    </div>

    <script>
    function emailPayslip(payrollId) {
        if (confirm('Send payslip via email to staff member?')) {
            fetch('<?php echo base_url(); ?>admin/payslip/email/' + payrollId, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    alert('Payslip emailed successfully!');
                } else {
                    alert('Failed to email payslip: ' + data.message);
                }
            })
            .catch(error => {
                alert('Error: ' + error.message);
            });
        }
    }
    </script>
</body>
</html>