<?php
// =============================================
// 4. LEAVE MANAGEMENT VIEW - /admin/hr/leave/index.php
// =============================================
?>

<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-calendar"></i> <?php echo $title; ?>
            <small>Manage staff leave requests and approvals</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/hr">HR</a></li>
            <li class="active">Leave Management</li>
        </ol>
    </section>

    <section class="content">
        <!-- Leave Summary Cards -->
        <div class="row">
            <div class="col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-yellow"><i class="fa fa-clock-o"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Pending Requests</span>
                        <span class="info-box-number" id="pendingCount">0</span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-green"><i class="fa fa-check"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Approved Today</span>
                        <span class="info-box-number" id="approvedCount">0</span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-red"><i class="fa fa-user-times"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">On Leave Today</span>
                        <span class="info-box-number" id="onLeaveCount">0</span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box">
                    <span class="info-box-icon bg-blue"><i class="fa fa-calendar"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">This Month</span>
                        <span class="info-box-number" id="monthlyCount">0</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Leave Management -->
        <div class="row">
            <div class="col-md-8">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Leave Requests</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#applyLeaveModal">
                                <i class="fa fa-plus"></i> Apply Leave
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <!-- Filters -->
                        <div class="row margin-bottom">
                            <div class="col-md-3">
                                <select class="form-control" id="leave_status_filter">
                                    <option value="">All Status</option>
                                    <option value="pending">Pending</option>
                                    <option value="approved">Approved</option>
                                    <option value="rejected">Rejected</option>
                                    <option value="cancelled">Cancelled</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select class="form-control" id="leave_type_filter">
                                    <option value="">All Types</option>
                                    <?php if (isset($leave_types) && !empty($leave_types)): ?>
                                        <?php foreach ($leave_types as $type): ?>
                                            <option value="<?php echo $type->id; ?>"><?php echo $type->type; ?></option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <input type="date" class="form-control" id="leave_date_filter" placeholder="Filter by date">
                            </div>
                            <div class="col-md-3">
                                <button type="button" class="btn btn-info btn-block" onclick="leaveTable.draw();">
                                    <i class="fa fa-search"></i> Filter
                                </button>
                            </div>
                        </div>

                        <!-- Leave Table -->
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered" id="leaveDataTable">
                                <thead>
                                    <tr>
                                        <th>Employee</th>
                                        <th>Leave Type</th>
                                        <th>Start Date</th>
                                        <th>End Date</th>
                                        <th>Duration</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Data loaded via AJAX -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">Leave Calendar</h3>
                    </div>
                    <div class="box-body">
                        <div id="leaveCalendar"></div>
                    </div>
                </div>

                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">Leave Balance</h3>
                    </div>
                    <div class="box-body">
                        <div class="form-group">
                            <select class="form-control" id="staff_balance_select">
                                <option value="">Select Staff Member</option>
                                <?php if (isset($staff_list) && !empty($staff_list)): ?>
                                    <?php foreach ($staff_list as $staff): ?>
                                        <option value="<?php echo $staff->id; ?>">
                                            <?php echo $staff->name . ' ' . $staff->surname; ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                        <div id="leaveBalanceDisplay">
                            <p class="text-muted">Select staff to view leave balance</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Apply Leave Modal -->
<div class="modal fade" id="applyLeaveModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">×</button>
                <h4 class="modal-title"><i class="fa fa-calendar-plus-o"></i> Apply for Leave</h4>
            </div>
            <form id="applyLeaveForm" method="POST">
                <div class="modal-body">
                    <div class="form-group">
                        <label>Staff Member <span class="text-danger">*</span></label>
                        <select class="form-control" name="staff_id" required>
                            <option value="">Select Staff Member</option>
                            <?php if (isset($staff_list) && !empty($staff_list)): ?>
                                <?php foreach ($staff_list as $staff): ?>
                                    <option value="<?php echo $staff->id; ?>">
                                        <?php echo $staff->name . ' ' . $staff->surname . ' (' . $staff->employee_id . ')'; ?>
                                    </option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Leave Type <span class="text-danger">*</span></label>
                        <select class="form-control" name="leave_type_id" required>
                            <option value="">Select Leave Type</option>
                            <?php if (isset($leave_types) && !empty($leave_types)): ?>
                                <?php foreach ($leave_types as $type): ?>
                                    <option value="<?php echo $type->id; ?>"><?php echo $type->type; ?></option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Start Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" name="start_date" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>End Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" name="end_date" required>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Total Days</label>
                        <input type="number" class="form-control" name="total_days" readonly>
                    </div>

                    <div class="form-group">
                        <label>Reason <span class="text-danger">*</span></label>
                        <textarea class="form-control" name="reason" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> Submit Application
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Initialize Leave DataTable
    var leaveTable = $('#leaveDataTable').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "<?php echo base_url('admin/hr/getLeaveList'); ?>",
            "type": "POST",
            "data": function(d) {
                d.status = $('#leave_status_filter').val();
                d.leave_type = $('#leave_type_filter').val();
                d.date = $('#leave_date_filter').val();
            }
        },
        "columns": [
            {"data": "employee_name"},
            {"data": "leave_type"},
            {"data": "start_date"},
            {"data": "end_date"},
            {"data": "duration"},
            {"data": "status"},
            {"data": "actions", "orderable": false}
        ],
        "order": [[2, "desc"]]
    });

    // Calculate leave days
    $('input[name="start_date"], input[name="end_date"]').on('change', function() {
        var startDate = new Date($('input[name="start_date"]').val());
        var endDate = new Date($('input[name="end_date"]').val());
        
        if (startDate && endDate && endDate >= startDate) {
            var timeDiff = endDate.getTime() - startDate.getTime();
            var daysDiff = Math.ceil(timeDiff / (1000 * 3600 * 24)) + 1;
            $('input[name="total_days"]').val(daysDiff);
        }
    });

    // Apply Leave Form
    $('#applyLeaveForm').on('submit', function(e) {
        e.preventDefault();
        
        $.ajax({
            url: '<?php echo base_url("admin/hr/applyLeave"); ?>',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.status == 'success') {
                    toastr.success(response.message);
                    $('#applyLeaveModal').modal('hide');
                    $('#applyLeaveForm')[0].reset();
                    leaveTable.ajax.reload();
                } else {
                    toastr.error(response.message);
                }
            }
        });
    });

    // Load leave balance
    $('#staff_balance_select').on('change', function() {
        var staffId = $(this).val();
        if (staffId) {
            $.ajax({
                url: '<?php echo base_url("admin/hr/getLeaveBalance/"); ?>' + staffId,
                type: 'GET',
                dataType: 'json',
                success: function(response) {
                    if (response.status == 'success') {
                        displayLeaveBalance(response.data);
                    }
                }
            });
        } else {
            $('#leaveBalanceDisplay').html('<p class="text-muted">Select staff to view leave balance</p>');
        }
    });

    // Filter handlers
    $('#leave_status_filter, #leave_type_filter, #leave_date_filter').on('change', function() {
        leaveTable.draw();
    });
});

function displayLeaveBalance(balanceData) {
    var html = '<div class="table-responsive"><table class="table table-sm">';
    html += '<thead><tr><th>Leave Type</th><th>Balance</th></tr></thead><tbody>';
    
    if (balanceData && balanceData.length > 0) {
        $.each(balanceData, function(index, balance) {
            html += '<tr>';
            html += '<td>' + balance.leave_type + '</td>';
            html += '<td>' + balance.remaining_days + ' days</td>';
            html += '</tr>';
        });
    } else {
        html += '<tr><td colspan="2" class="text-center">No data available</td></tr>';
    }
    
    html += '</tbody></table></div>';
    $('#leaveBalanceDisplay').html(html);
}

// Approve Leave
function approveLeave(leaveId) {
    if (confirm('Are you sure you want to approve this leave request?')) {
        $.ajax({
            url: '<?php echo base_url("admin/hr/approveLeave/"); ?>' + leaveId,
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status == 'success') {
                    toastr.success(response.message);
                    leaveTable.ajax.reload();
                } else {
                    toastr.error(response.message);
                }
            }
        });
    }
}

// Reject Leave
function rejectLeave(leaveId) {
    var reason = prompt('Please enter rejection reason:');
    if (reason !== null && reason.trim() !== '') {
        $.ajax({
            url: '<?php echo base_url("admin/hr/rejectLeave/"); ?>' + leaveId,
            type: 'POST',
            data: { reason: reason },
            dataType: 'json',
            success: function(response) {
                if (response.status == 'success') {
                    toastr.success(response.message);
                    leaveTable.ajax.reload();
                } else {
                    toastr.error(response.message);
                }
            }
        });
    }
}
</script>