<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-users"></i> <?php echo $this->lang->line('hr_dashboard'); ?>
            <small><?php echo $this->lang->line('control_panel'); ?></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/dashboard"><i class="fa fa-dashboard"></i> <?php echo $this->lang->line('dashboard'); ?></a></li>
            <li class="active"><?php echo $this->lang->line('hr_dashboard'); ?></li>
        </ol>
    </section>

    <section class="content">
        <!-- Stats Overview -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3><?php echo isset($stats['total_staff']) ? $stats['total_staff'] : 0; ?></h3>
                        <p><?php echo $this->lang->line('total_staff'); ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-users"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/hr/staff" class="small-box-footer">
                        <?php echo $this->lang->line('more_info'); ?> <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3><?php echo isset($stats['active_staff']) ? $stats['active_staff'] : 0; ?></h3>
                        <p><?php echo $this->lang->line('active_staff'); ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-user-check"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/hr/staff" class="small-box-footer">
                        <?php echo $this->lang->line('more_info'); ?> <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3><?php echo isset($stats['on_leave_today']) ? $stats['on_leave_today'] : 0; ?></h3>
                        <p><?php echo $this->lang->line('on_leave_today'); ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-calendar-times"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/hr/leave" class="small-box-footer">
                        <?php echo $this->lang->line('more_info'); ?> <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3><?php echo isset($stats['pending_leave_requests']) ? $stats['pending_leave_requests'] : 0; ?></h3>
                        <p><?php echo $this->lang->line('pending_leave_requests'); ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-exclamation-triangle"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/hr/leave" class="small-box-footer">
                        <?php echo $this->lang->line('more_info'); ?> <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Additional Stats Row -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-purple">
                    <div class="inner">
                        <h3><?php echo isset($stats['expiring_contracts']) ? $stats['expiring_contracts'] : 0; ?></h3>
                        <p><?php echo $this->lang->line('expiring_contracts'); ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-file-text-o"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/hr/staff" class="small-box-footer">
                        <?php echo $this->lang->line('more_info'); ?> <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-orange">
                    <div class="inner">
                        <h3><?php echo isset($stats['training_due']) ? $stats['training_due'] : 0; ?></h3>
                        <p><?php echo $this->lang->line('training_due'); ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-graduation-cap"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/hr/training" class="small-box-footer">
                        <?php echo $this->lang->line('more_info'); ?> <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-teal">
                    <div class="inner">
                        <h3>KSh <?php echo isset($stats['monthly_payroll']) ? number_format($stats['monthly_payroll']) : '0'; ?></h3>
                        <p><?php echo $this->lang->line('monthly_payroll'); ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-money"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/hr/payroll" class="small-box-footer">
                        <?php echo $this->lang->line('more_info'); ?> <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-navy">
                    <div class="inner">
                        <h3><?php echo isset($stats['attendance_rate']) ? $stats['attendance_rate'] . '%' : '0%'; ?></h3>
                        <p><?php echo $this->lang->line('attendance_rate'); ?></p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-clock-o"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/hr/attendance" class="small-box-footer">
                        <?php echo $this->lang->line('more_info'); ?> <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Recent Activities -->
            <div class="col-md-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-clock-o"></i> <?php echo $this->lang->line('recent_activities'); ?></h3>
                    </div>
                    <div class="box-body">
                        <!-- Recent Hires -->
                        <h4><i class="fa fa-user-plus"></i> <?php echo $this->lang->line('recent_hires'); ?></h4>
                        <?php if (!empty($recent_hires)): ?>
                            <ul class="list-unstyled">
                                <?php foreach ($recent_hires as $hire): ?>
                                    <li class="media">
                                        <div class="media-left">
                                            <span class="label label-success"><i class="fa fa-user"></i></span>
                                        </div>
                                        <div class="media-body">
                                            <strong><?php echo $hire->name . ' ' . $hire->surname; ?></strong>
                                            <small class="text-muted"><?php echo $hire->department_name; ?></small>
                            <br><small class="text-muted"><?php echo date('M j, Y', strtotime($hire->date_of_joining)); ?></small>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php else: ?>
            <p class="text-muted"><?php echo $this->lang->line('no_recent_hires'); ?></p>
        <?php endif; ?>

        <hr>

        <!-- Recent Leave Requests -->
        <h4><i class="fa fa-calendar"></i> <?php echo $this->lang->line('recent_leave_requests'); ?></h4>
        <?php if (!empty($recent_leave_requests)): ?>
            <ul class="list-unstyled">
                <?php foreach ($recent_leave_requests as $leave): ?>
                    <li class="media">
                        <div class="media-left">
                            <span class="label label-<?php echo $leave->status == 'pending' ? 'warning' : ($leave->status == 'approved' ? 'success' : 'danger'); ?>">
                                <i class="fa fa-calendar"></i>
                            </span>
                        </div>
                        <div class="media-body">
                            <strong><?php echo $leave->staff_name . ' ' . $leave->staff_surname; ?></strong>
                            <small class="text-muted"><?php echo $leave->leave_type_name; ?></small>
                            <br><small class="text-muted">
                                <?php echo date('M j', strtotime($leave->start_date)) . ' - ' . date('M j, Y', strtotime($leave->end_date)); ?>
                                (<?php echo $leave->total_days; ?> days)
                            </small>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php else: ?>
            <p class="text-muted"><?php echo $this->lang->line('no_recent_leave_requests'); ?></p>
        <?php endif; ?>
    </div>
</div>
</div>

<!-- Quick Actions & Alerts -->
<div class="col-md-6">
<div class="box box-info">
    <div class="box-header with-border">
        <h3 class="box-title"><i class="fa fa-bolt"></i> <?php echo $this->lang->line('quick_actions'); ?></h3>
    </div>
    <div class="box-body">
        <div class="row">
            <div class="col-sm-6">
                <a href="<?php echo base_url(); ?>admin/hr/addStaff" class="btn btn-primary btn-block">
                    <i class="fa fa-user-plus"></i> <?php echo $this->lang->line('add_staff'); ?>
                </a>
            </div>
            <div class="col-sm-6">
                <a href="<?php echo base_url(); ?>admin/hr/leave" class="btn btn-success btn-block">
                    <i class="fa fa-calendar-plus-o"></i> <?php echo $this->lang->line('apply_leave'); ?>
                </a>
            </div>
        </div>
        <div class="row" style="margin-top: 10px;">
            <div class="col-sm-6">
                <a href="<?php echo base_url(); ?>admin/hr/attendance" class="btn btn-info btn-block">
                    <i class="fa fa-clock-o"></i> <?php echo $this->lang->line('mark_attendance'); ?>
                </a>
            </div>
            <div class="col-sm-6">
                <a href="<?php echo base_url(); ?>admin/hr/payroll" class="btn btn-warning btn-block">
                    <i class="fa fa-money"></i> <?php echo $this->lang->line('generate_payroll'); ?>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Compliance Alerts -->
<?php if (!empty($compliance_alerts)): ?>
    <div class="box box-danger">
        <div class="box-header with-border">
            <h3 class="box-title"><i class="fa fa-exclamation-triangle"></i> <?php echo $this->lang->line('compliance_alerts'); ?></h3>
        </div>
        <div class="box-body">
            <?php foreach ($compliance_alerts as $alert): ?>
                <div class="alert alert-<?php echo $alert['type']; ?> alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                    <h4><i class="icon fa fa-<?php echo $alert['type'] == 'warning' ? 'warning' : 'ban'; ?>"></i> <?php echo $alert['title']; ?></h4>
                    <?php echo $alert['message']; ?>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>

<!-- Upcoming Training -->
<?php if (!empty($upcoming_training)): ?>
    <div class="box box-success">
        <div class="box-header with-border">
            <h3 class="box-title"><i class="fa fa-graduation-cap"></i> <?php echo $this->lang->line('upcoming_training'); ?></h3>
        </div>
        <div class="box-body">
            <ul class="list-unstyled">
                <?php foreach ($upcoming_training as $training): ?>
                    <li class="media">
                        <div class="media-left">
                            <span class="label label-info"><i class="fa fa-graduation-cap"></i></span>
                        </div>
                        <div class="media-body">
                            <strong><?php echo $training->course_name; ?></strong>
                            <br><small class="text-muted">
                                <?php echo date('M j, Y', strtotime($training->session_date)); ?>
                                <?php if (isset($training->location)): ?>
                                    - <?php echo $training->location; ?>
                                <?php endif; ?>
                            </small>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
<?php endif; ?>
</div>
</div>

<!-- Charts Row -->
<div class="row">
<!-- Department Headcount Chart -->
<div class="col-md-6">
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title"><i class="fa fa-pie-chart"></i> <?php echo $this->lang->line('department_headcount'); ?></h3>
            <div class="box-tools pull-right">
                <button type="button" class="btn btn-box-tool" data-widget="collapse">
                    <i class="fa fa-minus"></i>
                </button>
            </div>
        </div>
        <div class="box-body">
            <canvas id="departmentChart" style="height: 300px;"></canvas>
        </div>
    </div>
</div>

<!-- Attendance Trend Chart -->
<div class="col-md-6">
    <div class="box box-info">
        <div class="box-header with-border">
            <h3 class="box-title"><i class="fa fa-line-chart"></i> <?php echo $this->lang->line('attendance_trend'); ?></h3>
            <div class="box-tools pull-right">
                <button type="button" class="btn btn-box-tool" data-widget="collapse">
                    <i class="fa fa-minus"></i>
                </button>
            </div>
        </div>
        <div class="box-body">
            <canvas id="attendanceChart" style="height: 300px;"></canvas>
        </div>
    </div>
</div>
</div>

<!-- Summary Tables Row -->
<div class="row">
<div class="col-md-12">
    <div class="box box-default">
        <div class="box-header with-border">
            <h3 class="box-title"><i class="fa fa-table"></i> <?php echo $this->lang->line('hr_summary'); ?></h3>
        </div>
        <div class="box-body">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    <li class="active"><a href="#staff-summary" data-toggle="tab"><?php echo $this->lang->line('staff_summary'); ?></a></li>
                    <li><a href="#leave-summary" data-toggle="tab"><?php echo $this->lang->line('leave_summary'); ?></a></li>
                    <li><a href="#training-summary" data-toggle="tab"><?php echo $this->lang->line('training_summary'); ?></a></li>
                </ul>
                <div class="tab-content">
                    <!-- Staff Summary Tab -->
                    <div class="active tab-pane" id="staff-summary">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('department'); ?></th>
                                        <th><?php echo $this->lang->line('total_staff'); ?></th>
                                        <th><?php echo $this->lang->line('active_staff'); ?></th>
                                        <th><?php echo $this->lang->line('on_leave'); ?></th>
                                        <th><?php echo $this->lang->line('attendance_rate'); ?></th>
                                    </tr>
                                </thead>
                                <tbody id="staff-summary-data">
                                    <tr>
                                        <td colspan="5" class="text-center"><?php echo $this->lang->line('loading'); ?>...</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Leave Summary Tab -->
                    <div class="tab-pane" id="leave-summary">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('leave_type'); ?></th>
                                        <th><?php echo $this->lang->line('applications'); ?></th>
                                        <th><?php echo $this->lang->line('approved'); ?></th>
                                        <th><?php echo $this->lang->line('pending'); ?></th>
                                        <th><?php echo $this->lang->line('total_days'); ?></th>
                                    </tr>
                                </thead>
                                <tbody id="leave-summary-data">
                                    <tr>
                                        <td colspan="5" class="text-center"><?php echo $this->lang->line('loading'); ?>...</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Training Summary Tab -->
                    <div class="tab-pane" id="training-summary">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('department'); ?></th>
                                        <th><?php echo $this->lang->line('enrollments'); ?></th>
                                        <th><?php echo $this->lang->line('completed'); ?></th>
                                        <th><?php echo $this->lang->line('completion_rate'); ?></th>
                                        <th><?php echo $this->lang->line('training_hours'); ?></th>
                                    </tr>
                                </thead>
                                <tbody id="training-summary-data">
                                    <tr>
                                        <td colspan="5" class="text-center"><?php echo $this->lang->line('loading'); ?>...</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
</section>
</div>

<script>
$(document).ready(function() {
    // Load dashboard data
    loadDashboardCharts();
    loadSummaryTables();
    
    // Auto-refresh every 5 minutes
    setInterval(function() {
        loadSummaryTables();
    }, 300000);
});

function loadDashboardCharts() {
    // Load department headcount chart
    $.ajax({
        url: '<?php echo base_url(); ?>admin/hr/getDepartmentHeadcount',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data.status === 'success') {
                createDepartmentChart(data.data);
            }
        }
    });
    
    // Load attendance trend chart
    $.ajax({
        url: '<?php echo base_url(); ?>admin/hr/getAttendanceTrend',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data.status === 'success') {
                createAttendanceChart(data.data);
            }
        }
    });
}

function loadSummaryTables() {
    // Load staff summary
    $.ajax({
        url: '<?php echo base_url(); ?>admin/hr/getStaffSummary',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data.status === 'success') {
                updateStaffSummaryTable(data.data);
            }
        }
    });
    
    // Load leave summary
    $.ajax({
        url: '<?php echo base_url(); ?>admin/hr/getLeaveSummary',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data.status === 'success') {
                updateLeaveSummaryTable(data.data);
            }
        }
    });
    
    // Load training summary
    $.ajax({
        url: '<?php echo base_url(); ?>admin/hr/getTrainingSummary',
        type: 'GET',
        dataType: 'json',
        success: function(data) {
            if (data.status === 'success') {
                updateTrainingSummaryTable(data.data);
            }
        }
    });
}

function createDepartmentChart(data) {
    var ctx = document.getElementById('departmentChart').getContext('2d');
    var chart = new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: data.labels,
            datasets: [{
                data: data.values,
                backgroundColor: [
                    '#f56954', '#00a65a', '#f39c12', '#00c0ef', 
                    '#3c8dbc', '#d2d6de', '#605ca8', '#ff851b'
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            legend: {
                position: 'bottom'
            }
        }
    });
}

function createAttendanceChart(data) {
    var ctx = document.getElementById('attendanceChart').getContext('2d');
    var chart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: data.labels,
            datasets: [{
                label: 'Attendance Rate (%)',
                data: data.values,
                borderColor: '#00c0ef',
                backgroundColor: 'rgba(0, 192, 239, 0.1)',
                tension: 0.1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    max: 100
                }
            }
        }
    });
}

function updateStaffSummaryTable(data) {
    var tbody = $('#staff-summary-data');
    tbody.empty();
    
    if (data.length > 0) {
        $.each(data, function(index, item) {
            var row = '<tr>' +
                '<td>' + item.department + '</td>' +
                '<td>' + item.total_staff + '</td>' +
                '<td>' + item.active_staff + '</td>' +
                '<td>' + item.on_leave + '</td>' +
                '<td>' + item.attendance_rate + '%</td>' +
                '</tr>';
            tbody.append(row);
        });
    } else {
        tbody.append('<tr><td colspan="5" class="text-center">No data available</td></tr>');
    }
}

function updateLeaveSummaryTable(data) {
    var tbody = $('#leave-summary-data');
    tbody.empty();
    
    if (data.length > 0) {
        $.each(data, function(index, item) {
            var row = '<tr>' +
                '<td>' + item.leave_type + '</td>' +
                '<td>' + item.applications + '</td>' +
                '<td>' + item.approved + '</td>' +
                '<td>' + item.pending + '</td>' +
                '<td>' + item.total_days + '</td>' +
                '</tr>';
            tbody.append(row);
        });
    } else {
        tbody.append('<tr><td colspan="5" class="text-center">No data available</td></tr>');
    }
}

function updateTrainingSummaryTable(data) {
    var tbody = $('#training-summary-data');
    tbody.empty();
    
    if (data.length > 0) {
        $.each(data, function(index, item) {
            var row = '<tr>' +
                '<td>' + item.department + '</td>' +
                '<td>' + item.enrollments + '</td>' +
                '<td>' + item.completed + '</td>' +
                '<td>' + item.completion_rate + '%</td>' +
                '<td>' + item.training_hours + '</td>' +
                '</tr>';
            tbody.append(row);
        });
    } else {
        tbody.append('<tr><td colspan="5" class="text-center">No data available</td></tr>');
    }
}
</script>