<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-clock-o"></i> Attendance Management
            <small>Staff attendance tracking and reporting</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/dashboard"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="<?php echo base_url(); ?>admin/hr"><i class="fa fa-users"></i> HR</a></li>
            <li class="active">Attendance</li>
        </ol>
    </section>

    <section class="content">
        <!-- Quick Actions -->
        <div class="row">
            <div class="col-md-3">
                <div class="info-box bg-green">
                    <span class="info-box-icon"><i class="fa fa-clock-o"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Present Today</span>
                        <span class="info-box-number"><?php echo $attendance_summary['present_today']; ?></span>
                        <span class="progress-description">Out of <?php echo $attendance_summary['total_staff']; ?> staff</span>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="info-box bg-red">
                    <span class="info-box-icon"><i class="fa fa-times"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Absent Today</span>
                        <span class="info-box-number"><?php echo $attendance_summary['absent_today']; ?></span>
                        <span class="progress-description">Staff not clocked in</span>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="info-box bg-yellow">
                    <span class="info-box-icon"><i class="fa fa-user-times"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">On Leave</span>
                        <span class="info-box-number"><?php echo $attendance_summary['on_leave_today']; ?></span>
                        <span class="progress-description">Approved leave today</span>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="info-box bg-blue">
                    <span class="info-box-icon"><i class="fa fa-percentage"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Attendance Rate</span>
                        <span class="info-box-number"><?php echo number_format($attendance_summary['attendance_rate'], 1); ?>%</span>
                        <span class="progress-description">This month</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Clock In/Out Section -->
        <div class="row">
            <div class="col-md-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-clock-o"></i> Clock In/Out</h3>
                    </div>
                    <div class="box-body">
                        <form id="clockInOutForm">
                            <div class="form-group">
                                <label>Select Staff Member</label>
                                <select class="form-control select2" name="staff_id" id="staff_id" required>
                                    <option value="">Select Staff</option>
                                    <!-- Staff options will be loaded via AJAX -->
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Location (Optional)</label>
                                <input type="text" class="form-control" name="location" id="location" placeholder="e.g., Main Office, Ward 1">
                            </div>
                            <div class="form-group">
                                <label>Notes (Optional)</label>
                                <textarea class="form-control" name="notes" id="notes" rows="2" placeholder="Any additional notes"></textarea>
                            </div>
                            <div class="form-group">
                                <button type="button" class="btn btn-success" id="clockInBtn">
                                    <i class="fa fa-play"></i> Clock In
                                </button>
                                <button type="button" class="btn btn-warning" id="clockOutBtn">
                                    <i class="fa fa-stop"></i> Clock Out
                                </button>
                            </div>
                        </form>
                        
                        <div id="attendanceStatus" style="display: none;">
                            <div class="alert alert-info">
                                <h5><i class="fa fa-info-circle"></i> Current Status</h5>
                                <div id="statusContent"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-calendar"></i> Today's Summary</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="description-block border-right">
                                    <span class="description-percentage text-green">
                                        <i class="fa fa-caret-up"></i> <?php echo number_format($attendance_summary['attendance_rate'], 1); ?>%
                                    </span>
                                    <h5 class="description-header"><?php echo $attendance_summary['present_today']; ?></h5>
                                    <span class="description-text">PRESENT</span>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="description-block">
                                    <span class="description-percentage text-red">
                                        <i class="fa fa-caret-down"></i> <?php echo number_format(100 - $attendance_summary['attendance_rate'], 1); ?>%
                                    </span>
                                    <h5 class="description-header"><?php echo $attendance_summary['absent_today']; ?></h5>
                                    <span class="description-text">ABSENT</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Attendance Records -->
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-list"></i> Attendance Records</h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-info btn-sm" onclick="exportAttendance()">
                        <i class="fa fa-download"></i> Export
                    </button>
                    <button type="button" class="btn btn-success btn-sm" onclick="refreshAttendance()">
                        <i class="fa fa-refresh"></i> Refresh
                    </button>
                </div>
            </div>
            <div class="box-body">
                <!-- Filters -->
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Department</label>
                            <select class="form-control" id="filter_department">
                                <option value="">All Departments</option>
                                <?php foreach ($departments as $department): ?>
                                    <option value="<?php echo $department->id; ?>"><?php echo $department->name; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Date From</label>
                            <input type="date" class="form-control" id="filter_date_from" value="<?php echo date('Y-m-01'); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Date To</label>
                            <input type="date" class="form-control" id="filter_date_to" value="<?php echo date('Y-m-d'); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div>
                                <button type="button" class="btn btn-primary btn-block" onclick="filterAttendance()">
                                    <i class="fa fa-search"></i> Filter
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Attendance Table -->
                <div class="table-responsive">
                    <table class="table table-striped table-bordered table-hover" id="attendance-table">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Employee ID</th>
                                <th>Name</th>
                                <th>Department</th>
                                <th>Date</th>
                                <th>Clock In</th>
                                <th>Clock Out</th>
                                <th>Total Hours</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
var attendanceTable;

$(document).ready(function() {
    // Initialize DataTable
    attendanceTable = $('#attendance-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '<?php echo base_url(); ?>admin/hr/getAttendanceList',
            type: 'POST',
            data: function(d) {
                d.department_id = $('#filter_department').val();
                d.date_from = $('#filter_date_from').val();
                d.date_to = $('#filter_date_to').val();
            }
        },
        columns: [
            { data: 0, orderable: false },
            { data: 1 },
            { data: 2 },
            { data: 3 },
            { data: 4 },
            { data: 5 },
            { data: 6 },
            { data: 7 },
            { data: 8, orderable: false }
        ],
        order: [[4, 'desc']],
        language: {
            processing: "Loading attendance data..."
        }
    // Clock Out button
    $('#clockOutBtn').click(function() {
        var staffId = $('#staff_id').val();
        if (!staffId) {
            alert('Please select a staff member');
            return;
        }

        $.ajax({
            url: '<?php echo base_url(); ?>admin/hr/clockOut',
            type: 'POST',
            data: {
                staff_id: staffId,
                location: $('#location').val(),
                notes: $('#notes').val()
            },
            dataType: 'json',
            beforeSend: function() {
                $('#clockOutBtn').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Clocking Out...');
            },
            success: function(response) {
                if (response.status === 'success') {
                    showNotification('success', response.message);
                    checkAttendanceStatus(staffId);
                    attendanceTable.draw();
                } else {
                    showNotification('error', response.message);
                }
            },
            error: function() {
                showNotification('error', 'An error occurred while clocking out');
            },
            complete: function() {
                $('#clockOutBtn').prop('disabled', false).html('<i class="fa fa-stop"></i> Clock Out');
            }
        });
    });

    // Staff selection change
    $('#staff_id').change(function() {
        var staffId = $(this).val();
        if (staffId) {
            checkAttendanceStatus(staffId);
        } else {
            $('#attendanceStatus').hide();
        }
    });

    // Filter change events
    $('#filter_department, #filter_date_from, #filter_date_to').change(function() {
        attendanceTable.draw();
    });
});

function loadStaffDropdown() {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/hr/getActiveStaff',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                var options = '<option value="">Select Staff</option>';
                response.data.forEach(function(staff) {
                    options += '<option value="' + staff.id + '">' + staff.employee_id + ' - ' + staff.name + ' ' + staff.surname + '</option>';
                });
                $('#staff_id').html(options);
            }
        }
    });
}

function checkAttendanceStatus(staffId) {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/hr/getTodayAttendance/' + staffId,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success' && response.data) {
                var attendance = response.data;
                var statusHtml = '';
                
                if (attendance.clock_in_time && !attendance.clock_out_time) {
                    statusHtml = '<strong>Status:</strong> <span class="text-success">Clocked In</span><br>';
                    statusHtml += '<strong>Clock In Time:</strong> ' + formatTime(attendance.clock_in_time) + '<br>';
                    statusHtml += '<strong>Duration:</strong> ' + calculateDuration(attendance.clock_in_time);
                    $('#clockInBtn').prop('disabled', true);
                    $('#clockOutBtn').prop('disabled', false);
                } else if (attendance.clock_in_time && attendance.clock_out_time) {
                    statusHtml = '<strong>Status:</strong> <span class="text-info">Completed</span><br>';
                    statusHtml += '<strong>Clock In:</strong> ' + formatTime(attendance.clock_in_time) + '<br>';
                    statusHtml += '<strong>Clock Out:</strong> ' + formatTime(attendance.clock_out_time) + '<br>';
                    statusHtml += '<strong>Total Hours:</strong> ' + (attendance.total_hours ? attendance.total_hours.toFixed(2) : '0') + ' hrs';
                    $('#clockInBtn').prop('disabled', true);
                    $('#clockOutBtn').prop('disabled', true);
                } else {
                    statusHtml = '<strong>Status:</strong> <span class="text-warning">Not Clocked In</span>';
                    $('#clockInBtn').prop('disabled', false);
                    $('#clockOutBtn').prop('disabled', true);
                }
                
                $('#statusContent').html(statusHtml);
                $('#attendanceStatus').show();
            } else {
                $('#statusContent').html('<strong>Status:</strong> <span class="text-warning">Not Clocked In</span>');
                $('#attendanceStatus').show();
                $('#clockInBtn').prop('disabled', false);
                $('#clockOutBtn').prop('disabled', true);
            }
        }
    });
}

function formatTime(datetime) {
    var date = new Date(datetime);
    return date.toLocaleTimeString('en-US', { 
        hour: '2-digit', 
        minute: '2-digit',
        hour12: true 
    });
}

function calculateDuration(clockInTime) {
    var clockIn = new Date(clockInTime);
    var now = new Date();
    var diff = now - clockIn;
    var hours = Math.floor(diff / (1000 * 60 * 60));
    var minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
    return hours + 'h ' + minutes + 'm';
}

function filterAttendance() {
    attendanceTable.draw();
}

function refreshAttendance() {
    attendanceTable.draw();
    location.reload();
}

function exportAttendance() {
    var params = {
        department_id: $('#filter_department').val(),
        date_from: $('#filter_date_from').val(),
        date_to: $('#filter_date_to').val()
    };
    
    var queryString = $.param(params);
    window.location.href = '<?php echo base_url(); ?>admin/hr/exportAttendance?' + queryString;
}

function showNotification(type, message) {
    var alertClass = 'alert-info';
    if (type === 'success') alertClass = 'alert-success';
    else if (type === 'error') alertClass = 'alert-danger';
    else if (type === 'warning') alertClass = 'alert-warning';
    
    var notification = $('<div class="alert ' + alertClass + ' alert-dismissible" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px;">' +
        '<button type="button" class="close" data-dismiss="alert">&times;</button>' +
        '<strong>' + type.charAt(0).toUpperCase() + type.slice(1) + ':</strong> ' + message +
        '</div>');
    
    $('body').append(notification);
    
    setTimeout(function() {
        notification.fadeOut();
    }, 5000);
}
</script>