<?php
$currency_symbol = $this->customlib->getHospitalCurrencyFormat();
?>

<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-balance-scale"></i> Trial Balance
            <small>Verify debit and credit balances</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/financial">Financial</a></li>
            <li class="active">Trial Balance</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { echo $this->session->flashdata('msg'); } ?>

        <!-- Date Selection -->
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-calendar"></i> As of Date</h3>
            </div>
            <div class="box-body">
                <form method="get" id="trialBalanceForm">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="as_of_date">As of Date</label>
                                <input type="date" class="form-control" name="as_of_date" id="as_of_date" 
                                       value="<?php echo $as_of_date; ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <div class="btn-group btn-block">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fa fa-refresh"></i> Generate
                                    </button>
                                    <button type="button" class="btn btn-success" id="exportTB">
                                        <i class="fa fa-download"></i> Export
                                    </button>
                                    <button type="button" class="btn btn-default" id="printTB">
                                        <i class="fa fa-print"></i> Print
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Quick Dates</label>
                                <div class="btn-group btn-block">
                                    <button type="button" class="btn btn-default btn-sm quick-date" data-date="<?php echo date('Y-m-d'); ?>">Today</button>
                                    <button type="button" class="btn btn-default btn-sm quick-date" data-date="<?php echo date('Y-m-t'); ?>">Month End</button>
                                    <button type="button" class="btn btn-default btn-sm quick-date" data-date="<?php echo date('Y-12-31'); ?>">Year End</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Balance Status -->
        <div class="row">
            <div class="col-md-4">
                <div class="info-box <?php echo $is_balanced ? 'bg-green' : 'bg-red'; ?>" id="balanceStatus">
                    <span class="info-box-icon">
                        <i class="fa <?php echo $is_balanced ? 'fa-check' : 'fa-exclamation-triangle'; ?>"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Trial Balance Status</span>
                        <span class="info-box-number">
                            <?php echo $is_balanced ? 'BALANCED' : 'UNBALANCED'; ?>
                        </span>
                        <div class="progress">
                            <div class="progress-bar" style="width: <?php echo $is_balanced ? '100' : '0'; ?>%"></div>
                        </div>
                        <span class="progress-description">
                            <?php echo $is_balanced ? 'Debits equal Credits' : 'Debits do not equal Credits'; ?>
                        </span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box bg-blue">
                    <span class="info-box-icon"><i class="fa fa-arrow-up"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Debits</span>
                        <span class="info-box-number" id="totalDebit">
                            <?php echo $currency_symbol; ?>
                            <span class="number-format"><?php echo number_format($total_debit, 2); ?></span>
                        </span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box bg-blue">
                    <span class="info-box-icon"><i class="fa fa-arrow-down"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Credits</span>
                        <span class="info-box-number" id="totalCredit">
                            <?php echo $currency_symbol; ?>
                            <span class="number-format"><?php echo number_format($total_credit, 2); ?></span>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Difference -->
        <?php $difference = abs($total_debit - $total_credit); ?>
        <?php if ($difference > 0.01): ?>
        <div class="alert alert-warning">
            <i class="fa fa-warning"></i> The trial balance is out of balance by 
            <strong><?php echo $currency_symbol . ' ' . number_format($difference, 2); ?></strong>.
            Please review your journal entries for any discrepancies.
        </div>
        <?php endif; ?>

        <!-- Trial Balance Table -->
        <div class="box box-success">
            <div class="box-header with-border">
                <h3 class="box-title">
                    <i class="fa fa-table"></i> Trial Balance as of <?php echo date('d M Y', strtotime($as_of_date)); ?>
                </h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse">
                        <i class="fa fa-minus"></i>
                    </button>
                    <div class="btn-group">
                        <button type="button" class="btn btn-box-tool dropdown-toggle" data-toggle="dropdown">
                            <i class="fa fa-wrench"></i>
                        </button>
                        <ul class="dropdown-menu" role="menu">
                            <li><a href="#" id="exportTB"><i class="fa fa-download"></i> Export</a></li>
                            <li><a href="#" id="printTB"><i class="fa fa-print"></i> Print</a></li>
                            <li class="divider"></li>
                            <li><a href="<?php echo base_url('admin/financial_reports/trial_balance'); ?>"><i class="fa fa-refresh"></i> Reset</a></li>
                        </ul>
                    </div>
                    <button type="button" class="btn btn-box-tool" data-widget="remove">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>
            <div class="box-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="trialBalanceTable">
                        <thead>
                            <tr class="bg-gray">
                                <th>Account Code</th>
                                <th>Account Name</th>
                                <th>Account Type</th>
                                <th class="text-right">Debit Balance</th>
                                <th class="text-right">Credit Balance</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            // Initialize account types array with proper structure
                            $account_types = [
                                'asset' => ['name' => 'Assets', 'accounts' => [], 'debit' => 0, 'credit' => 0],
                                'liability' => ['name' => 'Liabilities', 'accounts' => [], 'debit' => 0, 'credit' => 0],
                                'equity' => ['name' => 'Equity', 'accounts' => [], 'debit' => 0, 'credit' => 0],
                                'revenue' => ['name' => 'Revenue', 'accounts' => [], 'debit' => 0, 'credit' => 0],
                                'expense' => ['name' => 'Expenses', 'accounts' => [], 'debit' => 0, 'credit' => 0]
                            ];
                            
                            // Process accounts and group by type
                            if (!empty($accounts)) {
                                foreach ($accounts as $account) {
                                    $type = strtolower($account['account_type']);
                                    if (isset($account_types[$type])) {
                                        $account_types[$type]['accounts'][] = $account;
                                        $account_types[$type]['debit'] += $account['debit_balance'];
                                        $account_types[$type]['credit'] += $account['credit_balance'];
                                    }
                                }
                            }
                            foreach ($trial_balance as $account) {
                                $account_types[$account['account_type']][] = $account;
                            }
                            
                            // Display by account type
                            foreach ($account_types as $type => $data): 
                                if (empty($data['accounts'])) continue; // Skip empty account types
                                
                                // Account type header
                                ?>
                                <tr class="account-type-header">
                                    <td colspan="5">
                                        <strong><?php echo strtoupper($data['name']); ?> ACCOUNTS</strong>
                                    </td>
                                </tr>
                                
                                <?php 
                                // Individual accounts
                                foreach ($data['accounts'] as $account): 
                                    $balance = $account['debit_balance'] - $account['credit_balance'];
                                    $is_debit = $balance >= 0;
                                    $balance_abs = abs($balance);
                                ?>
                                <tr>
                                    <td><?php echo html_escape($account['account_code']); ?></td>
                                    <td><?php echo html_escape($account['account_name']); ?></td>
                                    <td class="text-right">
                                        <?php if ($is_debit && $balance_abs > 0): ?>
                                            <?php echo $currency_symbol . ' ' . number_format($balance_abs, 2); ?>
                                        <?php else: ?>&nbsp;<?php endif; ?>
                                    </td>
                                    <td class="text-right">
                                        <?php if (!$is_debit && $balance_abs > 0): ?>
                                            <?php echo $currency_symbol . ' ' . number_format($balance_abs, 2); ?>
                                        <?php else: ?>&nbsp;<?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; 
                                
                                // Account type subtotal
                                ?>
                                <tr class="type-subtotal">
                                    <td colspan="2" class="text-right">
                                        <strong>Total <?php echo $data['name']; ?></strong>
                                    </td>
                                    <td class="text-right">
                                        <strong><?php echo $currency_symbol . ' ' . number_format($data['debit'], 2); ?></strong>
                                    </td>
                                    <td class="text-right">
                                        <strong><?php echo $currency_symbol . ' ' . number_format($data['credit'], 2); ?></strong>
                                    </td>
                                </tr>
                                <tr><td colspan="5">&nbsp;</td></tr>
                                <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr class="bg-gray">
                                <th colspan="2" class="text-right">TRIAL BALANCE TOTALS</th>
                                <th class="text-right">
                                    <?php echo $currency_symbol . ' ' . number_format($total_debit, 2); ?>
                                </th>
                                <th class="text-right">
                                    <?php echo $currency_symbol . ' ' . number_format($total_credit, 2); ?>
                                </th>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <!-- Summary Statistics -->
                <div class="row" style="margin-top: 20px;">
                    <div class="col-md-6">
                        <div class="box box-default">
                            <div class="box-header with-border">
                                <h3 class="box-title"><i class="fa fa-info-circle"></i> Trial Balance Summary</h3>
                            </div>
                            <div class="box-body">
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Account Type</th>
                                                <th class="text-right">Debit (<?php echo $currency_symbol; ?>)</th>
                                                <th class="text-right">Credit (<?php echo $currency_symbol; ?>)</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($account_types as $type => $data): 
                                                if (empty($data['accounts'])) continue; ?>
                                            <tr>
                                                <td><?php echo $data['name']; ?></td>
                                                <td class="text-right"><?php echo number_format($data['debit'], 2); ?></td>
                                                <td class="text-right"><?php echo number_format($data['credit'], 2); ?></td>
                                            </tr>
                                            <?php endforeach; ?>
                                            <tr class="bg-gray">
                                                <th>Total</th>
                                                <th class="text-right"><?php echo number_format($total_debit, 2); ?></th>
                                                <th class="text-right"><?php echo number_format($total_credit, 2); ?></th>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="box box-info">
                            <div class="box-header with-border">
                                <h3 class="box-title"><i class="fa fa-question-circle"></i> About Trial Balance</h3>
                            </div>
                            <div class="box-body">
                                <p>The trial balance is a bookkeeping worksheet in which the balances of all ledgers are compiled into debit and credit account column totals that are equal.</p>
                                
                                <div class="callout callout-info">
                                    <h4><i class="fa fa-lightbulb-o"></i> Tips</h4>
                                    <ul>
                                        <li>Ensure all journal entries are properly recorded</li>
                                        <li>Verify that debits equal credits for each transaction</li>
                                        <li>Review any accounts with zero balances</li>
                                        <li>Check for transposition or calculation errors</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    // Initialize DataTable
    var table = $('#trialBalanceTable').DataTable({
        "paging": false,
        "ordering": false,
        "info": false,
        "searching": false,
        "dom": 'Bfrtip',
        "buttons": [
            {
                extend: 'excel',
                text: '<i class="fa fa-download"></i> Excel',
                className: 'btn btn-success btn-sm',
                exportOptions: {
                    columns: ':visible'
                }
            },
            {
                extend: 'pdf',
                text: '<i class="fa fa-file-pdf-o"></i> PDF',
                className: 'btn btn-danger btn-sm',
                exportOptions: {
                    columns: ':visible'
                }
            },
            {
                extend: 'print',
                text: '<i class="fa fa-print"></i> Print',
                className: 'btn btn-info btn-sm',
                autoPrint: true,
                customize: function(win) {
                    $(win.document.body).find('h1').css('text-align', 'center');
                    $(win.document.body).find('h1').css('margin-bottom', '20px');
                    $(win.document.body).find('table').addClass('print-table');
                }
            }
        ],
        "drawCallback": function(settings) {
            // Add animation to rows
            $('tr').each(function(i) {
                $(this).delay(i * 50).fadeIn();
            });
        }
    });
    
    // Handle quick date buttons
    $('.quick-date').on('click', function() {
        var date = $(this).data('date');
        $('#as_of_date').val(date);
        $('#trialBalanceForm').submit();
    });
    
    // Handle export button
    $('#exportTB').on('click', function() {
        var date = $('#as_of_date').val();
        window.location.href = '<?php echo base_url("admin/financial_reports/export_trial_balance?as_of_date="); ?>' + date;
    });
    
    // Handle print button
    $('#printTB').on('click', function() {
        window.print();
    });
    
    // Add animation to balance status
    if ($('#balanceStatus').hasClass('bg-red')) {
        $('#balanceStatus').addClass('pulse-animation');
    }
    
    // Tooltip initialization
    $('[data-toggle="tooltip"]').tooltip();
    
    // Datepicker initialization
    $('#as_of_date').datepicker({
        format: 'yyyy-mm-dd',
        autoclose: true,
        endDate: '0d',
        todayHighlight: true
    });
    $('#trialBalanceTable').DataTable({
        "paging": false,
        "searching": true,
        "ordering": true,
        "info": false,
        "responsive": true,
        "order": [[ 0, "asc" ]],
        "columnDefs": [
            { "orderable": false, "targets": [3, 4] }
        ]
    });

    // Quick date selection
    $('.quick-date').click(function() {
        var date = $(this).data('date');
        $('#as_of_date').val(date);
        $('#trialBalanceForm').submit();
    });

    // Export trial balance
    $('#exportTB').click(function() {
        var asOfDate = $('#as_of_date').val();
        window.open('<?php echo base_url(); ?>admin/financial/exportTrialBalance?as_of_date=' + asOfDate, '_blank');
    });

    // Print trial balance
    $('#printTB').click(function() {
        var asOfDate = $('#as_of_date').val();
        window.open('<?php echo base_url(); ?>admin/financial/printTrialBalance?as_of_date=' + asOfDate, '_blank');
    });

    // Account row click to view ledger
    $('.account-row').click(function() {
        var accountId = $(this).data('account-id');
        var asOfDate = $('#as_of_date').val();
        window.open('<?php echo base_url(); ?>admin/financial/generalledger?account_id=' + accountId + '&date_to=' + asOfDate, '_blank');
    });

    // Highlight unbalanced rows
    <?php if (!$is_balanced) : ?>
        $('.bg-red').effect("highlight", {color: "#ff6b6b"}, 3000);
    <?php endif; ?>

    // Auto-submit on date change
    $('#as_of_date').change(function() {
        $('#trialBalanceForm').submit();
    });

    // Balance check animation
    <?php if ($is_balanced) : ?>
        $('.fa-check').addClass('animated pulse infinite');
    <?php else : ?>
        $('.fa-exclamation-triangle').addClass('animated shake');
    <?php endif; ?>
});

// Keyboard shortcuts
$(document).keydown(function(e) {
    // Ctrl+P for print
    if (e.ctrlKey && e.keyCode === 80) {
        e.preventDefault();
        $('#printTB').click();
    }
    
    // Ctrl+E for export
    if (e.ctrlKey && e.keyCode === 69) {
        e.preventDefault();
        $('#exportTB').click();
    }
});

// Helper functions
function drillDownToLedger(accountId) {
    var asOfDate = $('#as_of_date').val();
    window.open('<?php echo base_url(); ?>admin/financial/generalledger?account_id=' + accountId + '&date_to=' + asOfDate, '_blank');
}

function generateComparativeTrialBalance() {
    // Future feature - comparative trial balance
    alert('Comparative Trial Balance feature coming soon!');
}

function checkBalance() {
    var totalDebits = <?php echo $total_debits; ?>;
    var totalCredits = <?php echo $total_credits; ?>;
    var difference = Math.abs(totalDebits - totalCredits);
    
    if (difference < 0.01) {
        showAlert('success', 'Trial Balance is balanced!');
    } else {
        showAlert('warning', 'Trial Balance is unbalanced by ' + difference.toFixed(2));
    }
}

function showAlert(type, message) {
    var alertClass = 'alert-' + type;
    var iconClass = type === 'success' ? 'fa-check' : 'fa-warning';
    
    var alertHtml = '<div class="alert ' + alertClass + ' alert-dismissible">' +
                   '<button type="button" class="close" data-dismiss="alert">&times;</button>' +
                   '<i class="fa ' + iconClass + '"></i> ' + message +
                   '</div>';
    
    $('.content').prepend(alertHtml);
    
    setTimeout(function() {
        $('.alert').fadeOut();
    }, 5000);
    
    // Function to format numbers with commas
    function formatNumber(num) {
        return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }
    
    // Update the display of numbers with formatting
    $('.number-format').each(function() {
        var num = parseFloat($(this).text().replace(/[^0-9.-]+/g, ""));
        if (!isNaN(num)) {
            $(this).text(formatNumber(num.toFixed(2)));
        }
    });
    
    // Handle form submission with AJAX for smoother experience
    $('#trialBalanceForm').on('submit', function(e) {
        e.preventDefault();
        
        var formData = $(this).serialize();
        var url = $(this).attr('action') || window.location.href;
        
        // Show loading state
        $('#trialBalanceTable_wrapper').addClass('loading');
        
        // Submit form via AJAX
        $.ajax({
            url: url,
            type: 'GET',
            data: formData,
            dataType: 'html',
            success: function(response) {
                // Replace the table content
                var newTable = $(response).find('#trialBalanceTable').html();
                $('#trialBalanceTable').html(newTable);
                
                // Update the date display
                var newDate = $(response).find('#as_of_date').val();
                $('#as_of_date').val(newDate);
                
                // Update the title
                var newTitle = $(response).find('h3.box-title').html();
                $('h3.box-title').html(newTitle);
                
                // Update balance status
                if ($(response).find('#balanceStatus').hasClass('bg-green')) {
                    $('#balanceStatus').removeClass('bg-red').addClass('bg-green');
                    $('#balanceStatus i').removeClass('fa-exclamation-triangle').addClass('fa-check');
                    $('#balanceStatus .info-box-number').text('BALANCED');
                    $('#balanceStatus .progress-description').text('Debits equal Credits');
                    $('#balanceStatus .progress-bar').css('width', '100%');
                } else {
                    $('#balanceStatus').removeClass('bg-green').addClass('bg-red');
                    $('#balanceStatus i').removeClass('fa-check').addClass('fa-exclamation-triangle');
                    $('#balanceStatus .info-box-number').text('UNBALANCED');
                    $('#balanceStatus .progress-description').text('Debits do not equal Credits');
                    $('#balanceStatus .progress-bar').css('width', '0%');
                }
                
                // Update totals
                var totalDebit = $(response).find('#totalDebit').text();
                var totalCredit = $(response).find('#totalCredit').text();
                $('#totalDebit').text(totalDebit);
                $('#totalCredit').text(totalCredit);
                
                // Format numbers
                $('.number-format').each(function() {
                    var num = parseFloat($(this).text().replace(/[^0-9.-]+/g, ""));
                    if (!isNaN(num)) {
                        $(this).text(formatNumber(num.toFixed(2)));
                    }
                });
                
                // Add animation to balance status if unbalanced
                if ($('#balanceStatus').hasClass('bg-red')) {
                    $('#balanceStatus').addClass('pulse-animation');
                } else {
                    $('#balanceStatus').removeClass('pulse-animation');
                }
                
                // Close loading state
                $('#trialBalanceTable_wrapper').removeClass('loading');
                
                // Show success message
                toastr.success('Trial balance updated successfully');
            },
            error: function() {
                // Show error message
                toastr.error('Failed to update trial balance. Please try again.');
                
                // Close loading state
                $('#trialBalanceTable_wrapper').removeClass('loading');
            }
        });
    });
});
</script>

<style>
/* Add some styling for the trial balance table */
#trialBalanceTable {
    font-size: 13px;
}

#trialBalanceTable th {
    background-color: #f4f4f4;
    font-weight: bold;
}

#trialBalanceTable .account-type-header {
    background-color: #f9f9f9;
    font-weight: bold;
}

#trialBalanceTable .type-subtotal {
    background-color: #f0f0f0;
    font-weight: bold;
}

#trialBalanceTable .text-right {
    text-align: right;
}

/* Loading state */
.loading {
    position: relative;
    opacity: 0.6;
    pointer-events: none;
}

.loading:after {
    content: 'Loading...';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    font-size: 16px;
    font-weight: bold;
    color: #3c8dbc;
}

/* Pulse animation for unbalanced status */
@keyframes pulse {
    0% { box-shadow: 0 0 0 0 rgba(221, 75, 57, 0.4); }
    70% { box-shadow: 0 0 0 10px rgba(221, 75, 57, 0); }
    100% { box-shadow: 0 0 0 0 rgba(221, 75, 57, 0); }
}

.pulse-animation {
    animation: pulse 2s infinite;
    border-radius: 4px;
}

/* Print styles */
@media print {
    .no-print, .no-print * {
        display: none !important;
    }
    
    .box {
        border-top: none;
        margin-bottom: 0;
    }
    
    .box-body {
        padding: 10px 0;
    }
    
    .print-table {
        width: 100% !important;
        margin-bottom: 20px;
    }
    
    .print-table th {
        background-color: #f4f4f4 !important;
        -webkit-print-color-adjust: exact;
    }
}

.account-type-header td {
    background-color: #f4f4f4;
    font-weight: bold;
    border-top: 2px solid #ddd;
}

.type-subtotal {
    background-color: #f9f9f9;
    font-weight: bold;
    border-bottom: 1px solid #ddd;
}

.account-row {
    cursor: pointer;
}

.account-row:hover {
    background-color: #f5f5f5;
}

.info-box-number {
    font-size: 18px !important;
    font-weight: bold;
}

.balance-status {
    font-size: 24px;
    font-weight: bold;
}

.balance-difference {
    color: #dd4b39;
    font-weight: bold;
}

@media print {
    .box-tools,
    .btn,
    .breadcrumb,
    .callout {
        display: none !important;
    }
    
    .content-wrapper {
        margin: 0 !important;
        padding: 0 !important;
    }
    
    .box {
        box-shadow: none !important;
        border: 1px solid #ddd !important;
    }
    
    .account-row {
        cursor: default;
    }
    
    .table {
        font-size: 12px;
    }
}

.animated {
    animation-duration: 1s;
    animation-fill-mode: both;
}

.pulse {
    animation-name: pulse;
    animation-iteration-count: infinite;
}

.shake {
    animation-name: shake;
    animation-duration: 0.82s;
    animation-iteration-count: 3;
}

@keyframes pulse {
    from {
        transform: scale3d(1, 1, 1);
    }
    50% {
        transform: scale3d(1.05, 1.05, 1.05);
    }
    to {
        transform: scale3d(1, 1, 1);
    }
}

@keyframes shake {
    from, to {
        transform: translate3d(0, 0, 0);
    }
    10%, 30%, 50%, 70%, 90% {
        transform: translate3d(-10px, 0, 0);
    }
    20%, 40%, 60%, 80% {
        transform: translate3d(10px, 0, 0);
    }
}

.quick-date {
    margin: 2px;
}

.balance-indicator {
    font-size: 20px;
    margin-right: 10px;
}

.balance-indicator.balanced {
    color: #00a65a;
}

.balance-indicator.unbalanced {
    color: #dd4b39;
}

.currency-amount {
    font-family: 'Courier New', monospace;
    font-weight: bold;
}

.zero-amount {
    color: #999;
    font-style: italic;
}

.account-link {
    text-decoration: none;
}

.account-link:hover {
    text-decoration: underline;
}

.trial-balance-header {
    text-align: center;
    margin-bottom: 20px;
    padding: 15px;
    background: #f4f4f4;
    border-radius: 5px;
}

.balance-check-icon {
    font-size: 24px;
    margin-right: 10px;
}

.summary-stats {
    background: #f9f9f9;
    padding: 15px;
    border-radius: 5px;
    margin-top: 20px;
}

.tb-export-buttons {
    margin-bottom: 15px;
}

.account-type-section {
    margin-bottom: 20px;
}

.difference-highlight {
    background-color: #fff3cd !important;
    border-left: 4px solid #ffc107;
}
</style>