<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-book"></i> General Ledger
            <small>Account transactions and balances</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/financial">Financial</a></li>
            <li class="active">General Ledger</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { echo $this->session->flashdata('msg'); } ?>

        <!-- Filter Section -->
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-filter"></i> Filters</h3>
            </div>
            <div class="box-body">
                <form method="get" id="ledgerFilterForm">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="account_id">Account</label>
                                <select class="form-control" name="account_id" id="account_id">
                                    <option value="">All Accounts</option>
                                    <?php foreach ($accounts as $account) : ?>
                                        <option value="<?php echo $account['id']; ?>" 
                                                <?php echo ($this->input->get('account_id') == $account['id']) ? 'selected' : ''; ?>>
                                            <?php echo $account['account_code'] . ' - ' . $account['account_name']; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="date_from">Date From</label>
                                <input type="date" class="form-control" name="date_from" id="date_from" 
                                       value="<?php echo $this->input->get('date_from') ?: date('Y-m-01'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="date_to">Date To</label>
                                <input type="date" class="form-control" name="date_to" id="date_to" 
                                       value="<?php echo $this->input->get('date_to') ?: date('Y-m-d'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <div class="btn-group btn-block">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fa fa-search"></i> Filter
                                    </button>
                                    <button type="button" class="btn btn-default" id="clearFilter">
                                        <i class="fa fa-refresh"></i> Clear
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Account Summary (if specific account selected) -->
        <?php if (isset($account_summary) && $account_summary) : ?>
            <div class="box box-info">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-calculator"></i> Account Summary</h3>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-blue"><i class="fa fa-arrow-up"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Opening Balance</span>
                                    <span class="info-box-number">
                                        <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                        <?php echo number_format($account_summary['opening_balance'], 2); ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-green"><i class="fa fa-plus"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Debits</span>
                                    <span class="info-box-number">
                                        <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                        <?php echo number_format($account_summary['total_debits'], 2); ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-red"><i class="fa fa-minus"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Credits</span>
                                    <span class="info-box-number">
                                        <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                        <?php echo number_format($account_summary['total_credits'], 2); ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-yellow"><i class="fa fa-balance-scale"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Closing Balance</span>
                                    <span class="info-box-number">
                                        <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                        <?php echo number_format($account_summary['closing_balance'], 2); ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Ledger Entries -->
        <div class="box box-success">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-list"></i> Ledger Entries</h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-success btn-sm" id="exportLedger">
                        <i class="fa fa-download"></i> Export
                    </button>
                    <button type="button" class="btn btn-default btn-sm" id="printLedger">
                        <i class="fa fa-print"></i> Print
                    </button>
                </div>
            </div>
            <div class="box-body">
                <?php if (isset($ledger_entries) && !empty($ledger_entries)) : ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="ledgerTable">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Reference</th>
                                    <th>Account</th>
                                    <th>Description</th>
                                    <th class="text-right">Debit</th>
                                    <th class="text-right">Credit</th>
                                    <th class="text-right">Balance</th>
                                    <th>Source</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $running_balance = isset($account_summary) ? $account_summary['opening_balance'] : 0;
                                foreach ($ledger_entries as $entry) : 
                                    $running_balance += $entry['debit_amount'] - $entry['credit_amount'];
                                ?>
                                    <tr>
                                        <td><?php echo date('d-M-Y', strtotime($entry['date'])); ?></td>
                                        <td>
                                            <span class="label label-primary"><?php echo $entry['reference_no']; ?></span>
                                        </td>
                                        <td>
                                            <small><?php echo $entry['account_code']; ?></small><br>
                                            <?php echo $entry['account_name']; ?>
                                        </td>
                                        <td>
                                            <strong><?php echo $entry['header_description']; ?></strong>
                                            <?php if ($entry['line_description']) : ?>
                                                <br><small class="text-muted"><?php echo $entry['line_description']; ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-right">
                                            <?php if ($entry['debit_amount'] > 0) : ?>
                                                <span class="text-green">
                                                    <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                                    <?php echo number_format($entry['debit_amount'], 2); ?>
                                                </span>
                                            <?php else : ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-right">
                                            <?php if ($entry['credit_amount'] > 0) : ?>
                                                <span class="text-red">
                                                    <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                                    <?php echo number_format($entry['credit_amount'], 2); ?>
                                                </span>
                                            <?php else : ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-right">
                                            <strong>
                                                <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                                <?php echo number_format($running_balance, 2); ?>
                                            </strong>
                                        </td>
                                        <td>
                                            <?php if ($entry['source_module']) : ?>
                                                <span class="label label-info"><?php echo ucfirst($entry['source_module']); ?></span>
                                            <?php else : ?>
                                                <span class="label label-default">Manual</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot>
                                <tr class="bg-gray">
                                    <th colspan="4">Total</th>
                                    <th class="text-right">
                                        <?php 
                                        $total_debits = array_sum(array_column($ledger_entries, 'debit_amount'));
                                        echo $this->customlib->getHospitalCurrencyFormat() . number_format($total_debits, 2);
                                        ?>
                                    </th>
                                    <th class="text-right">
                                        <?php 
                                        $total_credits = array_sum(array_column($ledger_entries, 'credit_amount'));
                                        echo $this->customlib->getHospitalCurrencyFormat() . number_format($total_credits, 2);
                                        ?>
                                    </th>
                                    <th class="text-right">
                                        <strong>
                                            <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                            <?php echo number_format($running_balance, 2); ?>
                                        </strong>
                                    </th>
                                    <th></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                <?php else : ?>
                    <div class="alert alert-info text-center">
                        <h4><i class="icon fa fa-info"></i> No Entries Found</h4>
                        <p>No ledger entries found for the selected criteria. Try adjusting your filters.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#ledgerTable').DataTable({
        "order": [[ 0, "desc" ]],
        "pageLength": 50,
        "responsive": true,
        "dom": 'Bfrtip',
        "buttons": [
            {
                extend: 'excel',
                text: '<i class="fa fa-file-excel-o"></i> Excel',
                className: 'btn btn-success btn-sm'
            },
            {
                extend: 'pdf',
                text: '<i class="fa fa-file-pdf-o"></i> PDF',
                className: 'btn btn-danger btn-sm'
            },
            {
                extend: 'print',
                text: '<i class="fa fa-print"></i> Print',
                className: 'btn btn-default btn-sm'
            }
        ]
    });

    // Clear filter
    $('#clearFilter').click(function() {
        $('#account_id').val('');
        $('#date_from').val('<?php echo date('Y-m-01'); ?>');
        $('#date_to').val('<?php echo date('Y-m-d'); ?>');
    });

    // Export ledger
    $('#exportLedger').click(function() {
        var params = $('#ledgerFilterForm').serialize();
        window.open('<?php echo base_url(); ?>admin/financial/exportGeneralLedger?' + params, '_blank');
    });

    // Print ledger
    $('#printLedger').click(function() {
        var params = $('#ledgerFilterForm').serialize();
        window.open('<?php echo base_url(); ?>admin/financial/printGeneralLedger?' + params, '_blank');
    });

    // Auto-submit form when account changes
    $('#account_id').change(function() {
        if ($(this).val()) {
            $('#ledgerFilterForm').submit();
        }
    });

    // Quick date filters
    $('.quick-date').click(function() {
        var range = $(this).data('range');
        var today = new Date();
        var startDate, endDate;

        switch(range) {
            case 'today':
                startDate = endDate = today.toISOString().split('T')[0];
                break;
            case 'week':
                startDate = new Date(today.setDate(today.getDate() - 7)).toISOString().split('T')[0];
                endDate = new Date().toISOString().split('T')[0];
                break;
            case 'month':
                startDate = new Date(today.getFullYear(), today.getMonth(), 1).toISOString().split('T')[0];
                endDate = new Date().toISOString().split('T')[0];
                break;
            case 'year':
                startDate = new Date(today.getFullYear(), 0, 1).toISOString().split('T')[0];
                endDate = new Date().toISOString().split('T')[0];
                break;
        }

        $('#date_from').val(startDate);
        $('#date_to').val(endDate);
        $('#ledgerFilterForm').submit();
    });
});

// Helper functions
function drillDownAccount(accountId) {
    $('#account_id').val(accountId);
    $('#ledgerFilterForm').submit();
}

function viewJournalEntry(journalId) {
    window.open('<?php echo base_url(); ?>admin/financial/viewJournalEntry/' + journalId, '_blank');
}
</script>

<style>
.info-box {
    margin-bottom: 15px;
}

.info-box-number {
    font-size: 16px !important;
    font-weight: bold;
}

.table-responsive {
    overflow-x: auto;
}

.ledger-balance {
    font-weight: bold;
    font-family: 'Courier New', monospace;
}

.running-balance-positive {
    color: #00a65a;
}

.running-balance-negative {
    color: #dd4b39;
}

@media print {
    .box-tools,
    .btn,
    .breadcrumb {
        display: none !important;
    }
    
    .content-wrapper {
        margin: 0 !important;
        padding: 0 !important;
    }
    
    .box {
        box-shadow: none !important;
        border: 1px solid #ddd !important;
    }
}

.quick-date-buttons {
    margin-bottom: 10px;
}

.quick-date {
    margin-right: 5px;
    margin-bottom: 5px;
}

.ledger-entry-row:hover {
    background-color: #f5f5f5;
}

.source-badge {
    font-size: 75%;
}

.balance-column {
    min-width: 120px;
}

.amount-column {
    min-width: 100px;
}
</style>