<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-list"></i> Chart of Accounts
            <small>Manage your account structure</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="#">Financial</a></li>
            <li class="active">Chart of Accounts</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { 
            echo $this->session->flashdata('msg'); 
        } ?>

        <div class="row">
            <!-- Add Account Form -->
            <div class="col-md-4">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-plus"></i> Add New Account
                        </h3>
                    </div>
                    <form method="post" action="<?php echo base_url(); ?>admin/financial/addAccount">
                        <div class="box-body">
                            <!-- Account Code -->
                            <div class="form-group">
                                <label for="account_code">Account Code <span class="text-red">*</span></label>
                                <input type="text" class="form-control" name="account_code" id="account_code" 
                                       placeholder="e.g., 1000" required maxlength="20">
                                <small class="help-block">Unique identifier for the account</small>
                            </div>
                    
                            <!-- Account Name -->
                            <div class="form-group">
                                <label for="account_name">Account Name <span class="text-red">*</span></label>
                                <input type="text" class="form-control" name="account_name" id="account_name" 
                                       placeholder="e.g., Cash in Hand" required maxlength="255">
                            </div>
                    
                            <!-- Account Type -->
                            <div class="form-group">
                                <label for="account_type">Account Type <span class="text-red">*</span></label>
                                <select class="form-control" name="account_type" id="account_type" required>
                                    <option value="">Select Account Type</option>
                                    <option value="asset">Asset</option>
                                    <option value="liability">Liability</option>
                                    <option value="equity">Equity</option>
                                    <option value="revenue">Revenue</option>
                                    <option value="expense">Expense</option>
                                </select>
                            </div>
                    
                            <!-- Parent Account -->
                            <div class="form-group">
                                <label for="parent_account_id">Parent Account</label>
                                <select class="form-control" name="parent_account_id" id="parent_account_id">
                                    <option value="">No Parent (Main Account)</option>
                                    <?php if(isset($accounts) && !empty($accounts)): ?>
                                        <?php foreach($accounts as $account): ?>
                                            <option value="<?php echo $account['id']; ?>">
                                                <?php echo $account['account_code']; ?> - <?php echo $account['account_name']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                                <small class="help-block">Optional: Select a parent account for hierarchy</small>
                            </div>
                    
                            <!-- Description -->
                            <div class="form-group">
                                <label for="description">Description</label>
                                <textarea class="form-control" name="description" id="description" rows="3" 
                                          placeholder="Optional description for this account"></textarea>
                            </div>
                    
                            <!-- Opening Balance -->
                            <div class="form-group">
                                <label for="opening_balance">Opening Balance</label>
                                <input type="number" step="0.01" class="form-control" name="opening_balance" 
                                       id="opening_balance" placeholder="0.00">
                                <small class="help-block">Optional: Enter the opening balance for this account</small>
                            </div>
                    
                            <!-- Active Status -->
                            <div class="form-group">
                                <label>
                                    <input type="checkbox" name="is_active" id="is_active" value="1" checked> 
                                    Active Account
                                </label>
                            </div>
                        </div>
                        <div class="box-footer">
                            <button type="submit" name="submit" value="1" class="btn btn-primary">
    <i class="fa fa-save"></i> Add Account
</button>
                            <button type="reset" class="btn btn-default">
                                <i class="fa fa-refresh"></i> Reset
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Account Types Legend -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-info-circle"></i> Account Types
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="legend-item">
                            <span class="label label-success">Asset</span>
                            <small>Resources owned by the organization</small>
                        </div>
                        <div class="legend-item">
                            <span class="label label-warning">Liability</span>
                            <small>Debts owed to others</small>
                        </div>
                        <div class="legend-item">
                            <span class="label label-info">Equity</span>
                            <small>Owner's interest in the organization</small>
                        </div>
                        <div class="legend-item">
                            <span class="label label-primary">Revenue</span>
                            <small>Income from operations</small>
                        </div>
                        <div class="legend-item">
                            <span class="label label-danger">Expense</span>
                            <small>Costs of doing business</small>
                        </div>
                    </div>
                </div>

                <!-- Quick Stats -->
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-bar-chart"></i> Account Statistics
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-xs-6">
                                <div class="description-block border-right">
                                    <span class="description-percentage text-green">
                                        <i class="fa fa-caret-up"></i> <?php echo count($accounts); ?>
                                    </span>
                                    <h5 class="description-header">Total Accounts</h5>
                                    <span class="description-text">Active accounts</span>
                                </div>
                            </div>
                            <div class="col-xs-6">
                                <div class="description-block">
                                    <span class="description-percentage text-blue">
                                        <i class="fa fa-caret-up"></i> 5
                                    </span>
                                    <h5 class="description-header">Account Types</h5>
                                    <span class="description-text">Available types</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Accounts List -->
            <div class="col-md-8">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-table"></i> Accounts List
                        </h3>
                        <div class="box-tools pull-right">
                            <div class="btn-group">
                                <button type="button" 
                                        class="btn btn-success btn-sm" 
                                        onclick="initializeDefaultAccounts()"
                                        title="Create default account structure">
                                    <i class="fa fa-magic"></i> Initialize Default Accounts
                                </button>
                                <button type="button" 
                                        class="btn btn-default btn-sm" 
                                        onclick="exportAccounts()"
                                        title="Export accounts to CSV">
                                    <i class="fa fa-download"></i> Export
                                </button>
                                <button type="button" 
                                        class="btn btn-info btn-sm" 
                                        onclick="location.reload()"
                                        title="Refresh table data">
                                    <i class="fa fa-refresh"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="box-body">
                        <!-- Search and Filter -->
                        <div class="row" style="margin-bottom: 15px;">
                            <div class="col-md-4">
                                <div class="input-group">
                                    <input type="text" 
                                           class="form-control" 
                                           id="searchAccounts" 
                                           placeholder="Search accounts...">
                                    <span class="input-group-addon">
                                        <i class="fa fa-search"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <select class="form-control" id="filterAccountType">
                                    <option value="">All Account Types</option>
                                    <?php foreach($account_types as $key => $type): ?>
                                        <option value="<?php echo $key; ?>"><?php echo $type; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <select class="form-control" id="filterStatus">
                                    <option value="">All Status</option>
                                    <option value="1">Active Only</option>
                                    <option value="0">Inactive Only</option>
                                </select>
                            </div>
                        </div>

                        <!-- Accounts Table -->
                        <?php if (empty($accounts)): ?>
                            <div class="alert alert-info text-center">
                                <h4><i class="icon fa fa-info"></i> No Accounts Found</h4>
                                <p>No accounts found. Create your first account using the form on the left or initialize default accounts.</p>
                                <button type="button" class="btn btn-primary" onclick="initializeDefaultAccounts()">
                                    <i class="fa fa-magic"></i> Initialize Default Accounts
                                </button>
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="accountsTable">
                                    <thead>
                                        <tr>
                                            <th>Code</th>
                                            <th>Account Name</th>
                                            <th>Type</th>
                                            <th>Parent</th>
                                            <th>Status</th>
                                            <th class="text-right">Balance</th>
                                            <th class="text-center">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach($accounts as $account): ?>
                                            <tr>
                                                <td><strong><?php echo $account['account_code']; ?></strong></td>
                                                <td>
                                                    <?php if($account['parent_account_id']): ?>
                                                        <i class="fa fa-level-up fa-rotate-90 text-muted"></i> 
                                                    <?php endif; ?>
                                                    <?php echo $account['account_name']; ?>
                                                </td>
                                                <td>
                                                    <span class="label <?php echo getAccountTypeClass($account['account_type']); ?>">
                                                        <?php echo ucfirst($account['account_type']); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <span class="text-muted">
                                                        <?php 
                                                        if($account['parent_account_id']) {
                                                            $parent = getAccountById($accounts, $account['parent_account_id']);
                                                            echo $parent ? $parent['account_name'] : '-';
                                                        } else {
                                                            echo '-';
                                                        }
                                                        ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <?php 
                                                    // More robust active check - handles string/int/boolean
                                                    $is_active = false;
                                                    if (isset($account['is_active'])) {
                                                        $is_active = ($account['is_active'] == 1 || $account['is_active'] === '1' || $account['is_active'] === true);
                                                    }
                                                    ?>
                                                    <?php if($is_active): ?>
                                                        <span class="label label-success"><i class="fa fa-check"></i> Active</span>
                                                    <?php else: ?>
                                                        <span class="label label-default"><i class="fa fa-times"></i> Inactive</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-right">
                                                    <span class="currency-amount">
                                                        <?php echo formatCurrency($account['opening_balance'] ?? 0); ?>
                                                    </span>
                                                </td>
                                                <td class="text-center">
                                                    <div class="btn-group">
                                                        <a href="<?php echo base_url(); ?>admin/financial/viewAccount/<?php echo $account['id']; ?>" 
                                                           class="btn btn-xs btn-info" title="View Details">
                                                            <i class="fa fa-eye"></i>
                                                        </a>
                                                        <a href="<?php echo base_url(); ?>admin/financial/editAccount/<?php echo $account['id']; ?>" 
                                                           class="btn btn-xs btn-warning" title="Edit Account">
                                                            <i class="fa fa-edit"></i>
                                                        </a>
                                                        <?php if($account['is_active'] == 1): ?>
                                                            <a href="<?php echo base_url(); ?>admin/financial/toggleAccountStatus/<?php echo $account['id']; ?>/0" 
                                                               class="btn btn-xs btn-default" title="Deactivate">
                                                                <i class="fa fa-pause"></i>
                                                            </a>
                                                        <?php else: ?>
                                                            <a href="<?php echo base_url(); ?>admin/financial/toggleAccountStatus/<?php echo $account['id']; ?>/1" 
                                                               class="btn btn-xs btn-success" title="Activate">
                                                                <i class="fa fa-play"></i>
                                                            </a>
                                                        <?php endif; ?>
                                                        <a href="<?php echo base_url(); ?>admin/financial/deleteAccount/<?php echo $account['id']; ?>" 
                                                           class="btn btn-xs btn-danger delete-account" title="Delete Account"
                                                           onclick="return confirm('Are you sure you want to delete this account?')">
                                                            <i class="fa fa-trash"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php
// Helper functions
function getAccountTypeClass($type) {
    switch($type) {
        case 'asset': return 'label-success';
        case 'liability': return 'label-warning';
        case 'equity': return 'label-info';
        case 'revenue': return 'label-primary';
        case 'expense': return 'label-danger';
        default: return 'label-default';
    }
}

function getAccountById($accounts, $id) {
    foreach($accounts as $account) {
        if($account['id'] == $id) {
            return $account;
        }
    }
    return null;
}

function formatCurrency($amount) {
    return 'KSh ' . number_format($amount, 2);
}
?>

<style>
.legend-item {
    margin-bottom: 8px;
    padding: 5px 0;
    border-bottom: 1px solid #f0f0f0;
}
.legend-item:last-child {
    border-bottom: none;
}
.legend-item .label {
    margin-right: 10px;
    min-width: 60px;
    display: inline-block;
    text-align: center;
}
.description-block {
    text-align: center;
    padding: 10px 0;
}
.description-header {
    margin: 0;
    font-size: 18px;
    font-weight: bold;
}
.description-text {
    font-size: 12px;
    text-transform: uppercase;
    color: #999;
}
.description-percentage {
    font-size: 14px;
    font-weight: 600;
}
.border-right {
    border-right: 1px solid #dee2e6;
}
.text-red {
    color: #dd4b39;
}
.help-block {
    font-size: 12px;
    color: #777;
    margin-top: 5px;
}
.currency-amount {
    font-family: 'Courier New', monospace;
    font-weight: bold;
}
</style>

<script>
$(document).ready(function() {
    // Initialize DataTable if there are accounts
    <?php if(!empty($accounts)): ?>
    $('#accountsTable').DataTable({
        "order": [[0, "asc"]],
        "pageLength": 25,
        "responsive": true,
        "columnDefs": [
            { "orderable": false, "targets": [6] }
        ]
    });
    <?php endif; ?>

    // Search functionality
    $('#searchAccounts').on('keyup', function() {
        <?php if(!empty($accounts)): ?>
        $('#accountsTable').DataTable().search(this.value).draw();
        <?php endif; ?>
    });

    // Filter functionality
    $('#filterAccountType, #filterStatus').on('change', function() {
        // Implement filtering logic if needed
        location.reload(); // Simple reload for now
    });
});

// Initialize default accounts
function initializeDefaultAccounts() {
    if(confirm('This will create a standard chart of accounts. Continue?')) {
        window.location.href = '<?php echo base_url(); ?>admin/financial/initializeDefaultAccounts';
    }
}

// Export accounts
function exportAccounts() {
    window.location.href = '<?php echo base_url(); ?>admin/financial/exportChartOfAccounts';
}
</script>
<script>
$(document).ready(function() {
    $('#addAccountForm').on('submit', function(e) {
        console.log('Form submitted');
        console.log('Form action:', $(this).attr('action'));
        console.log('Form method:', $(this).attr('method'));
        
        // Ensure required fields are filled
        var accountCode = $('#account_code').val().trim();
        var accountName = $('#account_name').val().trim();
        var accountType = $('#account_type').val();
        
        if (!accountCode || !accountName || !accountType) {
            alert('Please fill in all required fields');
            e.preventDefault();
            return false;
        }
        
        return true;
    });
});
</script>