<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-credit-card"></i> Accounts Payable
            <small>Outstanding vendor balances</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/financial">Financial</a></li>
            <li class="active">Accounts Payable</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { echo $this->session->flashdata('msg'); } ?>

        <!-- Summary Cards -->
        <div class="row">
            <div class="col-md-3">
                <div class="info-box bg-red">
                    <span class="info-box-icon"><i class="fa fa-money"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Outstanding</span>
                        <span class="info-box-number">
                            <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                            <?php 
                            $total_outstanding = 0;
                            if (!empty($payables)) {
                                $total_outstanding = array_sum(array_column($payables, 'balance'));
                            }
                            echo number_format($total_outstanding, 2);
                            ?>
                        </span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box bg-blue">
                    <span class="info-box-icon"><i class="fa fa-building"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Vendors</span>
                        <span class="info-box-number">
                            <?php echo !empty($payables) ? count($payables) : 0; ?>
                        </span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box bg-yellow">
                    <span class="info-box-icon"><i class="fa fa-clock-o"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Avg Days Outstanding</span>
                        <span class="info-box-number">
                            <?php 
                            $avg_days = 0;
                            if (!empty($payables)) {
                                $total_days = 0;
                                foreach ($payables as $payable) {
                                    if ($payable['last_transaction_date']) {
                                        $days = (strtotime(date('Y-m-d')) - strtotime($payable['last_transaction_date'])) / (60 * 60 * 24);
                                        $total_days += $days;
                                    }
                                }
                                $avg_days = count($payables) > 0 ? $total_days / count($payables) : 0;
                            }
                            echo round($avg_days);
                            ?> days
                        </span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box bg-green">
                    <span class="info-box-icon"><i class="fa fa-exclamation-triangle"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Overdue Amount</span>
                        <span class="info-box-number">
                            <?php 
                            $overdue_amount = 0;
                            if (isset($aging['over_90'])) {
                                $overdue_amount = $aging['over_90'];
                            }
                            echo $this->customlib->getHospitalCurrencyFormat() . number_format($overdue_amount, 2);
                            ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Payment Schedule -->
        <div class="box box-success">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-calendar"></i> Payment Schedule</h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-success btn-sm" id="exportSchedule">
                        <i class="fa fa-download"></i> Export
                    </button>
                </div>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="payment-schedule-box due-today">
                            <h4>Due Today</h4>
                            <div class="schedule-amount">
                                <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                <?php echo number_format($schedule['due_today'] ?? 0, 2); ?>
                            </div>
                            <div class="schedule-count">
                                <?php echo $schedule['due_today_count'] ?? 0; ?> payments
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="payment-schedule-box due-week">
                            <h4>Due This Week</h4>
                            <div class="schedule-amount">
                                <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                <?php echo number_format($schedule['due_week'] ?? 0, 2); ?>
                            </div>
                            <div class="schedule-count">
                                <?php echo $schedule['due_week_count'] ?? 0; ?> payments
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="payment-schedule-box due-month">
                            <h4>Due This Month</h4>
                            <div class="schedule-amount">
                                <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                <?php echo number_format($schedule['due_month'] ?? 0, 2); ?>
                            </div>
                            <div class="schedule-count">
                                <?php echo $schedule['due_month_count'] ?? 0; ?> payments
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="payment-schedule-box overdue">
                            <h4>Overdue</h4>
                            <div class="schedule-amount">
                                <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                <?php echo number_format($schedule['overdue'] ?? 0, 2); ?>
                            </div>
                            <div class="schedule-count">
                                <?php echo $schedule['overdue_count'] ?? 0; ?> payments
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Aging Analysis -->
        <div class="box box-info">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-pie-chart"></i> Payables Aging Analysis</h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-success btn-sm" id="exportAging">
                        <i class="fa fa-download"></i> Export
                    </button>
                </div>
            </div>
            <div class="box-body">
                <?php if (isset($aging) && !empty($aging)) : ?>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="aging-box current">
                                <h4>Current (0-30 days)</h4>
                                <div class="aging-amount">
                                    <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                    <?php echo number_format($aging['current_30'] ?? 0, 2); ?>
                                </div>
                                <div class="aging-percentage">
                                    <?php 
                                    $current_pct = $total_outstanding > 0 ? (($aging['current_30'] ?? 0) / $total_outstanding) * 100 : 0;
                                    echo number_format($current_pct, 1) . '%';
                                    ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="aging-box days-31-60">
                                <h4>31-60 days</h4>
                                <div class="aging-amount">
                                    <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                    <?php echo number_format($aging['days_31_60'] ?? 0, 2); ?>
                                </div>
                                <div class="aging-percentage">
                                    <?php 
                                    $days_31_60_pct = $total_outstanding > 0 ? (($aging['days_31_60'] ?? 0) / $total_outstanding) * 100 : 0;
                                    echo number_format($days_31_60_pct, 1) . '%';
                                    ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="aging-box days-61-90">
                                <h4>61-90 days</h4>
                                <div class="aging-amount">
                                    <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                    <?php echo number_format($aging['days_61_90'] ?? 0, 2); ?>
                                </div>
                                <div class="aging-percentage">
                                    <?php 
                                    $days_61_90_pct = $total_outstanding > 0 ? (($aging['days_61_90'] ?? 0) / $total_outstanding) * 100 : 0;
                                    echo number_format($days_61_90_pct, 1) . '%';
                                    ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="aging-box over-90">
                                <h4>Over 90 days</h4>
                                <div class="aging-amount">
                                    <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                    <?php echo number_format($aging['over_90'] ?? 0, 2); ?>
                                </div>
                                <div class="aging-percentage">
                                    <?php 
                                    $over_90_pct = $total_outstanding > 0 ? (($aging['over_90'] ?? 0) / $total_outstanding) * 100 : 0;
                                    echo number_format($over_90_pct, 1) . '%';
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Aging Chart -->
                    <div class="row" style="margin-top: 20px;">
                        <div class="col-md-6">
                            <canvas id="agingChart" height="200"></canvas>
                        </div>
                        <div class="col-md-6">
                            <div class="aging-summary">
                                <h5>Payment Performance</h5>
                                <div class="performance-metrics">
                                    <div class="metric">
                                        <span class="metric-label">Current Ratio:</span>
                                        <span class="metric-value <?php echo ($current_pct >= 70) ? 'text-green' : (($current_pct >= 50) ? 'text-orange' : 'text-red'); ?>">
                                            <?php echo number_format($current_pct, 1); ?>%
                                        </span>
                                    </div>
                                    <div class="metric">
                                        <span class="metric-label">Overdue Ratio:</span>
                                        <span class="metric-value <?php echo ($over_90_pct <= 10) ? 'text-green' : (($over_90_pct <= 20) ? 'text-orange' : 'text-red'); ?>">
                                            <?php echo number_format($over_90_pct, 1); ?>%
                                        </span>
                                    </div>
                                    <div class="metric">
                                        <span class="metric-label">Payment Risk:</span>
                                        <span class="metric-value">
                                            <?php 
                                            if ($over_90_pct <= 10) echo '<span class="text-green">Low</span>';
                                            elseif ($over_90_pct <= 20) echo '<span class="text-orange">Medium</span>';
                                            else echo '<span class="text-red">High</span>';
                                            ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php else : ?>
                    <div class="alert alert-info text-center">
                        <h4><i class="icon fa fa-info"></i> No Aging Data</h4>
                        <p>No outstanding payables found.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Outstanding Vendor Balances -->
        <div class="box box-warning">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-list"></i> Outstanding Vendor Balances</h3>
                <div class="box-tools pull-right">
                    <div class="btn-group">
                        <button type="button" class="btn btn-success btn-sm" id="schedulePayments">
                            <i class="fa fa-calendar"></i> Schedule Payments
                        </button>
                        <button type="button" class="btn btn-primary btn-sm" id="exportPayables">
                            <i class="fa fa-download"></i> Export
                        </button>
                        <button type="button" class="btn btn-default btn-sm" id="printPayables">
                            <i class="fa fa-print"></i> Print
                        </button>
                    </div>
                </div>
            </div>
            <div class="box-body">
                <?php if (!empty($payables)) : ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="payablesTable">
                            <thead>
                                <tr>
                                    <th>
                                        <input type="checkbox" id="selectAll">
                                    </th>
                                    <th>Vendor Code</th>
                                    <th>Vendor Name</th>
                                    <th>Contact</th>
                                    <th class="text-right">Outstanding Balance</th>
                                    <th>Last Transaction</th>
                                    <th>Days Outstanding</th>
                                    <th>Payment Terms</th>
                                    <th>Priority</th>
                                    <th class="text-center">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($payables as $payable) : 
                                    $days_outstanding = 0;
                                    if ($payable['last_transaction_date']) {
                                        $days_outstanding = (strtotime(date('Y-m-d')) - strtotime($payable['last_transaction_date'])) / (60 * 60 * 24);
                                    }
                                    
                                    // Determine priority level
                                    $priority = 'Low';
                                    $priority_class = 'label-success';
                                    if ($days_outstanding > 90) {
                                        $priority = 'High';
                                        $priority_class = 'label-danger';
                                    } elseif ($days_outstanding > 60) {
                                        $priority = 'Medium';
                                        $priority_class = 'label-warning';
                                    }
                                ?>
                                    <tr class="payable-row" data-supplier-id="<?php echo $payable['supplier_id']; ?>">
                                        <td>
                                            <input type="checkbox" class="supplier-checkbox" value="<?php echo $payable['supplier_id']; ?>">
                                        </td>
                                        <td>
                                            <a href="<?php echo base_url(); ?>admin/supplier/profile/<?php echo $payable['supplier_id']; ?>" 
                                               target="_blank" class="text-blue">
                                                <?php echo $payable['supplier_code']; ?>
                                            </a>
                                        </td>
                                        <td>
                                            <strong><?php echo $payable['supplier_name']; ?></strong>
                                            <br>
                                            <small class="text-muted"><?php echo $payable['supplier_category']; ?></small>
                                        </td>
                                        <td>
                                            <?php echo $payable['phone'] ?: 'N/A'; ?>
                                            <?php if ($payable['email']) : ?>
                                                <br><small><?php echo $payable['email']; ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-right">
                                            <span class="currency-amount text-red">
                                                <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                                <?php echo number_format($payable['balance'], 2); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <?php echo $payable['last_transaction_date'] ? date('d-M-Y', strtotime($payable['last_transaction_date'])) : 'N/A'; ?>
                                        </td>
                                        <td>
                                            <span class="days-outstanding <?php 
                                                if ($days_outstanding <= 30) echo 'text-green';
                                                elseif ($days_outstanding <= 60) echo 'text-orange';
                                                else echo 'text-red';
                                            ?>">
                                                <?php echo round($days_outstanding); ?> days
                                            </span>
                                        </td>
                                        <td>
                                            <?php echo $payable['payment_terms'] ?: 'Net 30'; ?>
                                        </td>
                                        <td>
                                            <span class="label <?php echo $priority_class; ?>">
                                                <?php echo $priority; ?>
                                            </span>
                                        </td>
                                        <td class="text-center">
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-xs btn-info view-details" 
                                                        data-supplier-id="<?php echo $payable['supplier_id']; ?>" title="View Details">
                                                    <i class="fa fa-eye"></i>
                                                </button>
                                                <button type="button" class="btn btn-xs btn-success record-payment" 
                                                        data-supplier-id="<?php echo $payable['supplier_id']; ?>" title="Record Payment">
                                                    <i class="fa fa-money"></i>
                                                </button>
                                                <button type="button" class="btn btn-xs btn-primary schedule-payment" 
                                                        data-supplier-id="<?php echo $payable['supplier_id']; ?>" title="Schedule Payment">
                                                    <i class="fa fa-calendar"></i>
                                                </button>
                                                <button type="button" class="btn btn-xs btn-warning create-credit" 
                                                        data-supplier-id="<?php echo $payable['supplier_id']; ?>" title="Create Credit Note">
                                                    <i class="fa fa-file-text"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot>
                                <tr class="bg-gray">
                                    <th colspan="4">TOTAL</th>
                                    <th class="text-right">
                                        <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                        <?php echo number_format($total_outstanding, 2); ?>
                                    </th>
                                    <th colspan="5"></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                <?php else : ?>
                    <div class="alert alert-success text-center">
                        <h4><i class="icon fa fa-check"></i> All Clear!</h4>
                        <p>No outstanding payables found. All vendor payments are up to date.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Recent Purchase Orders -->
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-shopping-cart"></i> Recent Purchase Orders</h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-primary btn-sm" onclick="window.location.href='<?php echo base_url(); ?>admin/procurement/purchase_orders'">
                        <i class="fa fa-plus"></i> View All
                    </button>
                </div>
            </div>
            <div class="box-body">
                <?php if (!empty($recent_pos)) : ?>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>PO Number</th>
                                    <th>Supplier</th>
                                    <th>Order Date</th>
                                    <th class="text-right">Amount</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recent_pos as $po) : ?>
                                    <tr>
                                        <td><?php echo $po['lpo_number']; ?></td>
                                        <td><?php echo $po['supplier_name']; ?></td>
                                        <td><?php echo date('d-M-Y', strtotime($po['order_date'])); ?></td>
                                        <td class="text-right">
                                            <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                            <?php echo number_format($po['total_amount'], 2); ?>
                                        </td>
                                        <td>
                                            <span class="label label-<?php 
                                                switch($po['status']) {
                                                    case 'confirmed': echo 'success'; break;
                                                    case 'sent': echo 'info'; break;
                                                    case 'draft': echo 'warning'; break;
                                                    default: echo 'default';
                                                }
                                            ?>"><?php echo ucfirst($po['status']); ?></span>
                                        </td>
                                        <td>
                                            <a href="<?php echo base_url(); ?>admin/procurement/view_po/<?php echo $po['id']; ?>" 
                                               class="btn btn-xs btn-info" title="View PO">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else : ?>
                    <p class="text-center text-muted">No recent purchase orders found.</p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-cogs"></i> Actions</h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-3">
                        <button type="button" class="btn btn-primary btn-block" id="paymentRun">
                            <i class="fa fa-play"></i> Payment Run
                        </button>
                    </div>
                    <div class="col-md-3">
                        <button type="button" class="btn btn-warning btn-block" id="agingReport">
                            <i class="fa fa-clock-o"></i> Aging Report
                        </button>
                    </div>
                    <div class="col-md-3">
                        <button type="button" class="btn btn-info btn-block" id="vendorReport">
                            <i class="fa fa-building"></i> Vendor Report
                        </button>
                    </div>
                    <div class="col-md-3">
                        <button type="button" class="btn btn-success btn-block" id="reconcileAccounts">
                            <i class="fa fa-check-square"></i> Reconcile Accounts
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Payment Recording Modal -->
<div class="modal fade" id="paymentModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Record Vendor Payment</h4>
            </div>
            <form id="paymentForm">
                <div class="modal-body">
                    <input type="hidden" id="payment_supplier_id" name="supplier_id">
                    
                    <div class="form-group">
                        <label>Vendor</label>
                        <input type="text" class="form-control" id="payment_supplier_name" readonly>
                    </div>
                    
                    <div class="form-group">
                        <label>Outstanding Balance</label>
                        <input type="text" class="form-control" id="outstanding_balance" readonly>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="payment_amount">Payment Amount <span class="text-red">*</span></label>
                                <input type="number" class="form-control" name="amount" id="payment_amount" 
                                       step="0.01" min="0" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="payment_mode">Payment Mode <span class="text-red">*</span></label>
                                <select class="form-control" name="payment_mode" id="payment_mode" required>
                                    <option value="">Select Mode</option>
                                    <option value="cash">Cash</option>
                                    <option value="cheque">Cheque</option>
                                    <option value="bank_transfer">Bank Transfer</option>
                                    <option value="eft">EFT</option>
                                    <option value="online">Online Payment</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="payment_date">Payment Date <span class="text-red">*</span></label>
                        <input type="date" class="form-control" name="payment_date" id="payment_date" 
                               value="<?php echo date('Y-m-d'); ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="payment_reference">Reference/Cheque No</label>
                        <input type="text" class="form-control" name="reference" id="payment_reference">
                    </div>
                    
                    <div class="form-group">
                        <label for="payment_notes">Notes</label>
                        <textarea class="form-control" name="notes" id="payment_notes" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">Record Payment</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Payment Schedule Modal -->
<div class="modal fade" id="scheduleModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Schedule Payment</h4>
            </div>
            <form id="scheduleForm">
                <div class="modal-body">
                    <input type="hidden" id="schedule_supplier_id" name="supplier_id">
                    
                    <div class="form-group">
                        <label>Vendor</label>
                        <input type="text" class="form-control" id="schedule_supplier_name" readonly>
                    </div>
                    
                    <div class="form-group">
                        <label>Outstanding Balance</label>
                        <input type="text" class="form-control" id="schedule_balance" readonly>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="scheduled_amount">Amount to Pay <span class="text-red">*</span></label>
                                <input type="number" class="form-control" name="amount" id="scheduled_amount" 
                                       step="0.01" min="0" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="scheduled_date">Scheduled Date <span class="text-red">*</span></label>
                                <input type="date" class="form-control" name="scheduled_date" id="scheduled_date" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="payment_method">Payment Method <span class="text-red">*</span></label>
                        <select class="form-control" name="payment_method" id="payment_method" required>
                            <option value="">Select Method</option>
                            <option value="cheque">Cheque</option>
                            <option value="bank_transfer">Bank Transfer</option>
                            <option value="eft">EFT</option>
                            <option value="online">Online Payment</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="schedule_notes">Notes</label>
                        <textarea class="form-control" name="notes" id="schedule_notes" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Schedule Payment</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#payablesTable').DataTable({
        "order": [[ 6, "desc" ]], // Sort by days outstanding
        "pageLength": 25,
        "responsive": true,
        "columnDefs": [
            { "orderable": false, "targets": [0, 9] }
        ]
    });

    // Initialize aging chart
    initializeAgingChart();

    // Select all checkbox
    $('#selectAll').change(function() {
        $('.supplier-checkbox').prop('checked', this.checked);
    });

    // Individual checkbox change
    $('.supplier-checkbox').change(function() {
        if (!this.checked) {
            $('#selectAll').prop('checked', false);
        }
    });

    // View details
    $('.view-details').click(function() {
        var supplierId = $(this).data('supplier-id');
        window.open('<?php echo base_url(); ?>admin/supplier/profile/' + supplierId, '_blank');
    });

    // Record payment
    $('.record-payment').click(function() {
        var supplierId = $(this).data('supplier-id');
        var row = $(this).closest('tr');
        var supplierName = row.find('td:nth-child(3) strong').text().trim();
        var balance = row.find('.currency-amount').text().replace(/[^0-9.-]/g, '');
        
        $('#payment_supplier_id').val(supplierId);
        $('#payment_supplier_name').val(supplierName);
        $('#outstanding_balance').val('<?php echo $this->customlib->getHospitalCurrencyFormat(); ?>' + balance);
        $('#payment_amount').attr('max', balance);
        
        $('#paymentModal').modal('show');
    });

    // Schedule payment
    $('.schedule-payment').click(function() {
        var supplierId = $(this).data('supplier-id');
        var row = $(this).closest('tr');
        var supplierName = row.find('td:nth-child(3) strong').text().trim();
        var balance = row.find('.currency-amount').text().replace(/[^0-9.-]/g, '');
        
        $('#schedule_supplier_id').val(supplierId);
        $('#schedule_supplier_name').val(supplierName);
        $('#schedule_balance').val('<?php echo $this->customlib->getHospitalCurrencyFormat(); ?>' + balance);
        $('#scheduled_amount').attr('max', balance);
        
        $('#scheduleModal').modal('show');
    });

    // Payment form submission
    $('#paymentForm').on('submit', function(e) {
        e.preventDefault();
        var formData = $(this).serialize();
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/financial/recordVendorPayment',
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#paymentModal').modal('hide');
                    showAlert('success', 'Payment recorded successfully!');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    showAlert('danger', response.message || 'Error recording payment');
                }
            },
            error: function() {
                showAlert('danger', 'An error occurred while recording payment');
            }
        });
    });

    // Schedule form submission
    $('#scheduleForm').on('submit', function(e) {
        e.preventDefault();
        var formData = $(this).serialize();
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/financial/scheduleVendorPayment',
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#scheduleModal').modal('hide');
                    showAlert('success', 'Payment scheduled successfully!');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    showAlert('danger', response.message || 'Error scheduling payment');
                }
            },
            error: function() {
                showAlert('danger', 'An error occurred while scheduling payment');
            }
        });
    });

    // Export functions
    $('#exportPayables').click(function() {
        window.open('<?php echo base_url(); ?>admin/financial/exportAccountsPayable', '_blank');
    });

    $('#exportAging').click(function() {
        window.open('<?php echo base_url(); ?>admin/financial/exportPayableAging', '_blank');
    });

    $('#exportSchedule').click(function() {
        window.open('<?php echo base_url(); ?>admin/financial/exportPaymentSchedule', '_blank');
    });

    // Print function
    $('#printPayables').click(function() {
        window.open('<?php echo base_url(); ?>admin/financial/printAccountsPayable', '_blank');
    });

    // Schedule payments for selected vendors
    $('#schedulePayments').click(function() {
        var selectedSuppliers = [];
        $('.supplier-checkbox:checked').each(function() {
            selectedSuppliers.push($(this).val());
        });
        
        if (selectedSuppliers.length === 0) {
            alert('Please select at least one vendor to schedule payments.');
            return;
        }
        
        window.location.href = '<?php echo base_url(); ?>admin/financial/bulkSchedulePayments?suppliers=' + selectedSuppliers.join(',');
    });

    // Action buttons
    $('#paymentRun').click(function() {
        window.location.href = '<?php echo base_url(); ?>admin/financial/paymentRun';
    });

    $('#agingReport').click(function() {
        window.open('<?php echo base_url(); ?>admin/financial/payableAgingReport', '_blank');
    });

    $('#vendorReport').click(function() {
        window.open('<?php echo base_url(); ?>admin/financial/vendorReport', '_blank');
    });

    $('#reconcileAccounts').click(function() {
        window.location.href = '<?php echo base_url(); ?>admin/financial/reconcilePayables';
    });
});

function initializeAgingChart() {
    var ctx = document.getElementById('agingChart').getContext('2d');
    
    var data = {
        labels: ['Current (0-30)', '31-60 days', '61-90 days', 'Over 90 days'],
        datasets: [{
            data: [
                <?php echo $aging['current_30'] ?? 0; ?>,
                <?php echo $aging['days_31_60'] ?? 0; ?>,
                <?php echo $aging['days_61_90'] ?? 0; ?>,
                <?php echo $aging['over_90'] ?? 0; ?>
            ],
            backgroundColor: ['#00a65a', '#f39c12', '#dd4b39', '#605ca8']
        }]
    };
    
    new Chart(ctx, {
        type: 'doughnut',
        data: data,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            var value = context.parsed || 0;
                            var total = context.dataset.data.reduce((a, b) => a + b, 0);
                            var percentage = total > 0 ? ((value / total) * 100).toFixed(1) : 0;
                            return context.label + ': <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>' + 
                                   value.toLocaleString() + ' (' + percentage + '%)';
                        }
                    }
                }
            }
        }
    });
}

function showAlert(type, message) {
    var alertHtml = '<div class="alert alert-' + type + ' alert-dismissible">' +
                   '<button type="button" class="close" data-dismiss="alert">&times;</button>' +
                   message +
                   '</div>';
    
    $('.content').prepend(alertHtml);
    
    setTimeout(function() {
        $('.alert').fadeOut();
    }, 5000);
}
</script>

<style>
.payment-schedule-box {
    text-align: center;
    padding: 20px;
    border-radius: 5px;
    margin-bottom: 15px;
    border: 1px solid #ddd;
}

.payment-schedule-box.due-today {
    background-color: #fff3cd;
    border-color: #ffeaa7;
}

.payment-schedule-box.due-week {
    background-color: #d1ecf1;
    border-color: #bee5eb;
}

.payment-schedule-box.due-month {
    background-color: #d4edda;
    border-color: #c3e6cb;
}

.payment-schedule-box.overdue {
    background-color: #f8d7da;
    border-color: #f5c6cb;
}

.payment-schedule-box h4 {
    margin-top: 0;
    font-size: 14px;
    color: #333;
}

.schedule-amount {
    font-size: 20px;
    font-weight: bold;
    color: #333;
    margin: 8px 0;
}

.schedule-count {
    font-size: 12px;
    color: #666;
}

.aging-box {
    text-align: center;
    padding: 20px;
    border-radius: 5px;
    margin-bottom: 15px;
    border: 1px solid #ddd;
}

.aging-box.current {
    background-color: #d4edda;
    border-color: #c3e6cb;
}

.aging-box.days-31-60 {
    background-color: #fff3cd;
    border-color: #ffeaa7;
}

.aging-box.days-61-90 {
    background-color: #f8d7da;
    border-color: #f5c6cb;
}

.aging-box.over-90 {
    background-color: #e2e3e5;
    border-color: #d6d8db;
}

.aging-box h4 {
    margin-top: 0;
    font-size: 14px;
    color: #333;
}

.aging-amount {
    font-size: 24px;
    font-weight: bold;
    color: #333;
    margin: 10px 0;
}

.aging-percentage {
    font-size: 16px;
    color: #666;
}

.currency-amount {
    font-family: 'Courier New', monospace;
    font-weight: bold;
}

.days-outstanding {
    font-weight: bold;
}

.performance-metrics {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 5px;
}

.metric {
    display: flex;
    justify-content: space-between;
    margin-bottom: 10px;
    padding: 5px 0;
    border-bottom: 1px solid #dee2e6;
}

.metric:last-child {
    border-bottom: none;
    margin-bottom: 0;
}

.metric-label {
    font-weight: bold;
}

.metric-value {
    font-weight: bold;
}

.payable-row:hover {
    background-color: #f5f5f5;
}

.info-box-number {
    font-size: 18px !important;
    font-weight: bold;
}

.aging-summary {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 5px;
    height: 200px;
}

.supplier-category {
    font-size: 11px;
    text-transform: uppercase;
    color: #777;
}

@media print {
    .box-tools,
    .btn,
    .breadcrumb,
    .modal {
        display: none !important;
    }
    
    .content-wrapper {
        margin: 0 !important;
        padding: 0 !important;
    }
    
    .box {
        box-shadow: none !important;
        border: 1px solid #ddd !important;
    }
    
    .table {
        font-size: 12px;
    }
}
</style>