<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-cogs"></i> Dispensary Settings & Configuration
            <small>Manage system settings and preferences</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/dispensary">Medical Dispensary</a></li>
            <li class="active">Settings</li>
        </ol>
    </section>

    <section class="content">
        <!-- Settings Navigation Tabs -->
        <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
                <li class="active"><a href="#general" data-toggle="tab"><i class="fa fa-cog"></i> General Settings</a></li>
                <li><a href="#categories" data-toggle="tab"><i class="fa fa-tags"></i> Medicine Categories</a></li>
                <li><a href="#units" data-toggle="tab"><i class="fa fa-balance-scale"></i> Units & Measures</a></li>
                <li><a href="#billing" data-toggle="tab"><i class="fa fa-file-text"></i> Billing Settings</a></li>
                <li><a href="#notifications" data-toggle="tab"><i class="fa fa-bell"></i> Notifications</a></li>
                <li><a href="#backup" data-toggle="tab"><i class="fa fa-database"></i> Backup & Maintenance</a></li>
            </ul>
            
            <div class="tab-content">
                <!-- General Settings Tab -->
                <div class="active tab-pane" id="general">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="box box-primary">
                                <div class="box-header with-border">
                                    <h3 class="box-title"><i class="fa fa-cog"></i> General Configuration</h3>
                                </div>
                                <form id="generalSettingsForm">
                                    <div class="box-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="dispensaryName">Dispensary Name</label>
                                                    <input type="text" class="form-control" id="dispensaryName" 
                                                           value="Medical Dispensary" placeholder="Enter dispensary name">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="pharmacistInCharge">Pharmacist in Charge</label>
                                                    <select class="form-control" id="pharmacistInCharge">
                                                        <option value="">Select Pharmacist</option>
                                                        <option value="1">Dr. John Doe</option>
                                                        <option value="2">Dr. Jane Smith</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="lowStockThreshold">Low Stock Threshold</label>
                                                    <input type="number" class="form-control" id="lowStockThreshold" 
                                                           value="50" min="1" placeholder="Enter threshold quantity">
                                                    <small class="help-block">Alert when stock falls below this number</small>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="expiryAlertDays">Expiry Alert Days</label>
                                                    <input type="number" class="form-control" id="expiryAlertDays" 
                                                           value="90" min="1" placeholder="Enter days">
                                                    <small class="help-block">Alert when medicines expire within this period</small>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="defaultTax">Default Tax Rate (%)</label>
                                                    <input type="number" class="form-control" id="defaultTax" 
                                                           value="16" min="0" max="100" step="0.01">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="maxDiscount">Maximum Discount (%)</label>
                                                    <input type="number" class="form-control" id="maxDiscount" 
                                                           value="20" min="0" max="100" step="0.01">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label>
                                                        <input type="checkbox" id="enableBarcodeScanning"> 
                                                        Enable Barcode Scanning
                                                    </label>
                                                </div>
                                                <div class="form-group">
                                                    <label>
                                                        <input type="checkbox" id="requirePrescription"> 
                                                        Require Prescription for Controlled Medicines
                                                    </label>
                                                </div>
                                                <div class="form-group">
                                                    <label>
                                                        <input type="checkbox" id="autoPrintReceipts" checked> 
                                                        Auto-print Receipts
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="box-footer">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fa fa-save"></i> Save General Settings
                                        </button>
                                        <button type="button" class="btn btn-default" onclick="resetGeneralSettings()">
                                            <i class="fa fa-refresh"></i> Reset
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="box box-info">
                                <div class="box-header with-border">
                                    <h3 class="box-title"><i class="fa fa-info-circle"></i> System Information</h3>
                                </div>
                                <div class="box-body">
                                    <table class="table table-condensed">
                                        <tr>
                                            <td><strong>Version:</strong></td>
                                            <td>1.0.0</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Last Updated:</strong></td>
                                            <td><?php echo date('d M Y'); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Total Medicines:</strong></td>
                                            <td id="totalMedicinesCount">Loading...</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Active Categories:</strong></td>
                                            <td id="activeCategoriesCount">Loading...</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Today's Bills:</strong></td>
                                            <td id="todaysBillsCount">Loading...</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            <div class="box box-warning">
                                <div class="box-header with-border">
                                    <h3 class="box-title"><i class="fa fa-exclamation-triangle"></i> Quick Actions</h3>
                                </div>
                                <div class="box-body">
                                    <button class="btn btn-warning btn-block" onclick="clearCache()">
                                        <i class="fa fa-refresh"></i> Clear System Cache
                                    </button>
                                    <button class="btn btn-info btn-block" onclick="optimizeDatabase()">
                                        <i class="fa fa-database"></i> Optimize Database
                                    </button>
                                    <button class="btn btn-success btn-block" onclick="exportSettings()">
                                        <i class="fa fa-download"></i> Export Settings
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Medicine Categories Tab -->
                <div class="tab-pane" id="categories">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="box box-success">
                                <div class="box-header with-border">
                                    <h3 class="box-title"><i class="fa fa-tags"></i> Medicine Categories</h3>
                                    <div class="box-tools pull-right">
                                        <button class="btn btn-sm btn-success" onclick="addCategory()">
                                            <i class="fa fa-plus"></i> Add Category
                                        </button>
                                    </div>
                                </div>
                                <div class="box-body">
                                    <div class="table-responsive">
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th width="5%">#</th>
                                                    <th width="60%">Category Name</th>
                                                    <th width="20%">Medicines Count</th>
                                                    <th width="15%">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody id="categoriesTableBody">
                                                <?php $i = 1; foreach ($medicine_categories as $category): ?>
                                                    <tr>
                                                        <td><?php echo $i++; ?></td>
                                                        <td><?php echo $category->medicine_category; ?></td>
                                                        <td><span class="label label-info">0</span></td>
                                                        <td>
                                                            <button class="btn btn-xs btn-primary" 
                                                                    onclick="editCategory(<?php echo $category->id; ?>, '<?php echo addslashes($category->medicine_category); ?>')">
                                                                <i class="fa fa-edit"></i>
                                                            </button>
                                                            <button class="btn btn-xs btn-danger" 
                                                                    onclick="deleteCategory(<?php echo $category->id; ?>)">
                                                                <i class="fa fa-trash"></i>
                                                            </button>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="box box-primary">
                                <div class="box-header with-border">
                                    <h3 class="box-title"><i class="fa fa-plus"></i> Add/Edit Category</h3>
                                </div>
                                <form id="categoryForm">
                                    <div class="box-body">
                                        <input type="hidden" id="categoryId" value="">
                                        <div class="form-group">
                                            <label for="categoryName">Category Name <span class="text-red">*</span></label>
                                            <input type="text" class="form-control" id="categoryName" 
                                                   placeholder="Enter category name" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="categoryDescription">Description (Optional)</label>
                                            <textarea class="form-control" id="categoryDescription" rows="3" 
                                                      placeholder="Enter category description"></textarea>
                                        </div>
                                    </div>
                                    <div class="box-footer">
                                        <button type="submit" class="btn btn-primary btn-block">
                                            <i class="fa fa-save"></i> Save Category
                                        </button>
                                        <button type="button" class="btn btn-default btn-block" onclick="resetCategoryForm()">
                                            <i class="fa fa-refresh"></i> Reset Form
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Units & Measures Tab -->
                <div class="tab-pane" id="units">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="box box-warning">
                                <div class="box-header with-border">
                                    <h3 class="box-title"><i class="fa fa-balance-scale"></i> Medicine Units</h3>
                                    <div class="box-tools pull-right">
                                        <button class="btn btn-sm btn-warning" onclick="addUnit()">
                                            <i class="fa fa-plus"></i> Add Unit
                                        </button>
                                    </div>
                                </div>
                                <div class="box-body">
                                    <div class="table-responsive">
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th width="5%">#</th>
                                                    <th width="30%">Unit Name</th>
                                                    <th width="15%">Abbreviation</th>
                                                    <th width="20%">Type</th>
                                                    <th width="15%">Status</th>
                                                    <th width="15%">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody id="unitsTableBody">
                                                <?php $i = 1; foreach ($pharmacy_units as $unit): ?>
                                                    <tr>
                                                        <td><?php echo $i++; ?></td>
                                                        <td><?php echo $unit->unit_name; ?></td>
                                                        <td><?php echo $unit->abbreviation; ?></td>
                                                        <td><?php echo ucfirst($unit->unit_type); ?></td>
                                                        <td>
                                                            <span class="label <?php echo $unit->is_active == 'yes' ? 'label-success' : 'label-danger'; ?>">
                                                                <?php echo $unit->is_active == 'yes' ? 'Active' : 'Inactive'; ?>
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <button class="btn btn-xs btn-primary" 
                                                                    onclick="editUnit(<?php echo $unit->id; ?>)">
                                                                <i class="fa fa-edit"></i>
                                                            </button>
                                                            <button class="btn btn-xs btn-danger" 
                                                                    onclick="deleteUnit(<?php echo $unit->id; ?>)">
                                                                <i class="fa fa-trash"></i>
                                                            </button>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="box box-primary">
                                <div class="box-header with-border">
                                    <h3 class="box-title"><i class="fa fa-plus"></i> Add/Edit Unit</h3>
                                </div>
                                <form id="unitForm">
                                    <div class="box-body">
                                        <input type="hidden" id="unitId" value="">
                                        <div class="form-group">
                                            <label for="unitName">Unit Name <span class="text-red">*</span></label>
                                            <input type="text" class="form-control" id="unitName" 
                                                   placeholder="e.g., Tablets, Bottles" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="unitAbbreviation">Abbreviation</label>
                                            <input type="text" class="form-control" id="unitAbbreviation" 
                                                   placeholder="e.g., tabs, btl" maxlength="10">
                                        </div>
                                        <div class="form-group">
                                            <label for="unitType">Unit Type</label>
                                            <select class="form-control" id="unitType">
                                                <option value="count">Count (pieces, tablets)</option>
                                                <option value="volume">Volume (ml, liters)</option>
                                                <option value="weight">Weight (mg, grams)</option>
                                                <option value="general">General</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="unitDescription">Description</label>
                                            <textarea class="form-control" id="unitDescription" rows="2" 
                                                      placeholder="Enter unit description"></textarea>
                                        </div>
                                        <div class="form-group">
                                            <label>
                                                <input type="checkbox" id="unitActive" checked> Active
                                            </label>
                                        </div>
                                    </div>
                                    <div class="box-footer">
                                        <button type="submit" class="btn btn-primary btn-block">
                                            <i class="fa fa-save"></i> Save Unit
                                        </button>
                                        <button type="button" class="btn btn-default btn-block" onclick="resetUnitForm()">
                                            <i class="fa fa-refresh"></i> Reset Form
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Billing Settings Tab -->
                <div class="tab-pane" id="billing">
                    <div class="box box-danger">
                        <div class="box-header with-border">
                            <h3 class="box-title"><i class="fa fa-file-text"></i> Billing Configuration</h3>
                        </div>
                        <form id="billingSettingsForm">
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h4>Receipt Settings</h4>
                                        <div class="form-group">
                                            <label for="receiptHeader">Receipt Header Text</label>
                                            <textarea class="form-control" id="receiptHeader" rows="3">MEDICAL DISPENSARY RECEIPT</textarea>
                                        </div>
                                        <div class="form-group">
                                            <label for="receiptFooter">Receipt Footer Text</label>
                                            <textarea class="form-control" id="receiptFooter" rows="2">Thank you for choosing our services!</textarea>
                                        </div>
                                        <div class="form-group">
                                            <label>
                                                <input type="checkbox" id="showQRCode"> 
                                                Include QR Code on Receipt
                                            </label>
                                        </div>
                                        <div class="form-group">
                                            <label>
                                                <input type="checkbox" id="showBarcode"> 
                                                Include Barcode on Receipt
                                            </label>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <h4>Billing Rules</h4>
                                        <div class="form-group">
                                            <label for="billNumberPrefix">Bill Number Prefix</label>
                                            <input type="text" class="form-control" id="billNumberPrefix" 
                                                   value="MDB" placeholder="Enter prefix">
                                        </div>
                                        <div class="form-group">
                                            <label for="roundingRule">Amount Rounding</label>
                                            <select class="form-control" id="roundingRule">
                                                <option value="none">No Rounding</option>
                                                <option value="nearest_5">Round to Nearest 5</option>
                                                <option value="nearest_10">Round to Nearest 10</option>
                                                <option value="up">Always Round Up</option>
                                                <option value="down">Always Round Down</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label>
                                                <input type="checkbox" id="allowPartialPayments"> 
                                                Allow Partial Payments
                                            </label>
                                        </div>
                                        <div class="form-group">
                                            <label>
                                                <input type="checkbox" id="requirePaymentUpfront" checked> 
                                                Require Payment Before Dispensing
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12">
                                        <h4>Payment Methods</h4>
                                        <div class="row">
                                            <div class="col-md-3">
                                                <label><input type="checkbox" id="enableCash" checked> Cash</label>
                                            </div>
                                            <div class="col-md-3">
                                                <label><input type="checkbox" id="enableCard" checked> Credit/Debit Card</label>
                                            </div>
                                            <div class="col-md-3">
                                                <label><input type="checkbox" id="enableMpesa" checked> M-Pesa</label>
                                            </div>
                                            <div class="col-md-3">
                                                <label><input type="checkbox" id="enableBankTransfer"> Bank Transfer</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="box-footer">
                                <button type="submit" class="btn btn-danger">
                                    <i class="fa fa-save"></i> Save Billing Settings
                                </button>
                                <button type="button" class="btn btn-default" onclick="resetBillingSettings()">
                                    <i class="fa fa-refresh"></i> Reset
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Notifications Tab -->
                <div class="tab-pane" id="notifications">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title"><i class="fa fa-bell"></i> Notification Settings</h3>
                        </div>
                        <form id="notificationSettingsForm">
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h4>Stock Alerts</h4>
                                        <div class="form-group">
                                            <label>
                                                <input type="checkbox" id="enableLowStockAlerts" checked> 
                                                Enable Low Stock Alerts
                                            </label>
                                        </div>
                                        <div class="form-group">
                                            <label>
                                                <input type="checkbox" id="enableExpiryAlerts" checked> 
                                                Enable Expiry Alerts
                                            </label>
                                        </div>
                                        <div class="form-group">
                                            <label for="alertFrequency">Alert Frequency</label>
                                            <select class="form-control" id="alertFrequency">
                                                <option value="realtime">Real-time</option>
                                                <option value="daily">Daily</option>
                                                <option value="weekly">Weekly</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <h4>Email Notifications</h4>
                                        <div class="form-group">
                                            <label for="alertEmail">Alert Email Address</label>
                                            <input type="email" class="form-control" id="alertEmail" 
                                                   placeholder="Enter email for alerts">
                                        </div>
                                        <div class="form-group">
                                            <label>
                                                <input type="checkbox" id="emailDailyReports"> 
                                                Send Daily Reports via Email
                                            </label>
                                        </div>
                                        <div class="form-group">
                                            <label>
                                                <input type="checkbox" id="emailWeeklyReports"> 
                                                Send Weekly Reports via Email
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12">
                                        <h4>SMS Notifications</h4>
                                        <div class="form-group">
                                            <label>
                                                <input type="checkbox" id="enableSMSAlerts"> 
                                                Enable SMS Alerts
                                            </label>
                                        </div>
                                        <div class="form-group">
                                            <label for="smsPhoneNumber">SMS Phone Number</label>
                                            <input type="tel" class="form-control" id="smsPhoneNumber" 
                                                   placeholder="Enter phone number for SMS alerts">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="box-footer">
                                <button type="submit" class="btn btn-info">
                                    <i class="fa fa-save"></i> Save Notification Settings
                                </button>
                                <button type="button" class="btn btn-default" onclick="testNotifications()">
                                    <i class="fa fa-envelope"></i> Test Notifications
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Backup & Maintenance Tab -->
                <div class="tab-pane" id="backup">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="box box-success">
                                <div class="box-header with-border">
                                    <h3 class="box-title"><i class="fa fa-database"></i> Data Backup</h3>
                                </div>
                                <div class="box-body">
                                    <div class="form-group">
                                        <label>
                                            <input type="checkbox" id="autoBackup" checked> 
                                            Enable Automatic Backup
                                        </label>
                                    </div>
                                    <div class="form-group">
                                        <label for="backupFrequency">Backup Frequency</label>
                                        <select class="form-control" id="backupFrequency">
                                            <option value="daily">Daily</option>
                                            <option value="weekly">Weekly</option>
                                            <option value="monthly">Monthly</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="backupRetention">Backup Retention (days)</label>
                                        <input type="number" class="form-control" id="backupRetention" 
                                               value="30" min="1">
                                    </div>
                                    <hr>
                                    <button class="btn btn-success btn-block" onclick="createBackup()">
                                        <i class="fa fa-download"></i> Create Manual Backup
                                    </button>
                                    <button class="btn btn-info btn-block" onclick="viewBackupHistory()">
                                        <i class="fa fa-history"></i> View Backup History
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="box box-warning">
                                <div class="box-header with-border">
                                    <h3 class="box-title"><i class="fa fa-wrench"></i> System Maintenance</h3>
                                </div>
                                <div class="box-body">
                                    <div class="alert alert-warning">
                                        <strong>Warning:</strong> Maintenance operations may temporarily affect system performance.
                                    </div>
                                    
                                    <button class="btn btn-warning btn-block" onclick="optimizeDatabase()">
                                        <i class="fa fa-database"></i> Optimize Database
                                    </button>
                                    <button class="btn btn-info btn-block" onclick="clearCache()">
                                        <i class="fa fa-refresh"></i> Clear System Cache
                                    </button>
                                    <button class="btn btn-default btn-block" onclick="cleanTempFiles()">
                                        <i class="fa fa-trash"></i> Clean Temporary Files
                                    </button>
                                    <button class="btn btn-danger btn-block" onclick="rebuildIndexes()">
                                        <i class="fa fa-cogs"></i> Rebuild Database Indexes
                                    </button>
                                    
                                    <hr>
                                    <h5>System Status</h5>
                                    <table class="table table-condensed">
                                        <tr>
                                            <td>Database Size:</td>
                                            <td id="dbSize">Loading...</td>
                                        </tr>
                                        <tr>
                                            <td>Cache Size:</td>
                                            <td id="cacheSize">Loading...</td>
                                        </tr>
                                        <tr>
                                            <td>Last Backup:</td>
                                            <td id="lastBackup">Loading...</td>
                                        </tr>
                                        <tr>
                                            <td>System Health:</td>
                                            <td><span class="label label-success">Good</span></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<style>
/* Settings specific styles */
.nav-tabs-custom {
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.nav-tabs-custom > .nav-tabs {
    border-bottom: 2px solid #f4f4f4;
}

.nav-tabs-custom > .nav-tabs > li.active {
    border-top-color: #3c8dbc;
}

.box {
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.form-control {
    border-radius: 4px;
    border: 1px solid #ddd;
    transition: border-color 0.3s ease;
}

.form-control:focus {
    border-color: #3c8dbc;
    box-shadow: 0 0 0 0.2rem rgba(60,141,188,0.25);
}

.btn {
    border-radius: 4px;
    font-weight: 500;
}

.table-responsive {
    border-radius: 6px;
}

.label {
    border-radius: 4px;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .nav-tabs-custom > .nav-tabs > li {
        float: none;
        width: 100%;
    }
    
    .nav-tabs-custom > .nav-tabs > li > a {
        text-align: center;
        margin-right: 0;
        margin-bottom: 1px;
    }
    
    .box-body {
        padding: 10px;
    }
}
</style>

<script>
$(document).ready(function() {
    // Load system information
    loadSystemInfo();
    
    // Initialize form handlers
    initializeFormHandlers();
    
    // Load existing settings
    loadSettings();
});

function loadSystemInfo() {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/getSystemInfo',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 1) {
                $('#totalMedicinesCount').text(response.data.total_medicines || 0);
                $('#activeCategoriesCount').text(response.data.active_categories || 0);
                $('#todaysBillsCount').text(response.data.todays_bills || 0);
                $('#dbSize').text(response.data.db_size || 'N/A');
                $('#cacheSize').text(response.data.cache_size || 'N/A');
                $('#lastBackup').text(response.data.last_backup || 'Never');
            }
        },
        error: function() {
            console.error('Failed to load system information');
        }
    });
}

function initializeFormHandlers() {
    // General Settings Form
    $('#generalSettingsForm').on('submit', function(e) {
        e.preventDefault();
        saveGeneralSettings();
    });
    
    // Category Form
    $('#categoryForm').on('submit', function(e) {
        e.preventDefault();
        saveCategory();
    });
    
    // Unit Form
    $('#unitForm').on('submit', function(e) {
        e.preventDefault();
        saveUnit();
    });
    
    // Billing Settings Form
    $('#billingSettingsForm').on('submit', function(e) {
        e.preventDefault();
        saveBillingSettings();
    });
    
    // Notification Settings Form
    $('#notificationSettingsForm').on('submit', function(e) {
        e.preventDefault();
        saveNotificationSettings();
    });
}

function loadSettings() {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/getSettings',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 1) {
                const settings = response.settings;
                
                // Populate general settings
                $('#dispensaryName').val(settings.dispensary_name || 'Medical Dispensary');
                $('#pharmacistInCharge').val(settings.pharmacist_in_charge || '');
                $('#lowStockThreshold').val(settings.low_stock_threshold || 50);
                $('#expiryAlertDays').val(settings.expiry_alert_days || 90);
                $('#defaultTax').val(settings.default_tax || 16);
                $('#maxDiscount').val(settings.max_discount || 20);
                
                // Populate checkboxes
                $('#enableBarcodeScanning').prop('checked', settings.enable_barcode_scanning === '1');
                $('#requirePrescription').prop('checked', settings.require_prescription === '1');
                $('#autoPrintReceipts').prop('checked', settings.auto_print_receipts === '1');
                
                // Populate billing settings
                $('#receiptHeader').val(settings.receipt_header || 'MEDICAL DISPENSARY RECEIPT');
                $('#receiptFooter').val(settings.receipt_footer || 'Thank you for choosing our services!');
                $('#billNumberPrefix').val(settings.bill_number_prefix || 'MDB');
                $('#roundingRule').val(settings.rounding_rule || 'none');
                
                // Populate notification settings
                $('#alertEmail').val(settings.alert_email || '');
                $('#alertFrequency').val(settings.alert_frequency || 'daily');
                $('#smsPhoneNumber').val(settings.sms_phone_number || '');
                
                // Populate backup settings
                $('#backupFrequency').val(settings.backup_frequency || 'daily');
                $('#backupRetention').val(settings.backup_retention || 30);
            }
        },
        error: function() {
            console.error('Failed to load settings');
        }
    });
}

function saveGeneralSettings() {
    const settings = {
        dispensary_name: $('#dispensaryName').val(),
        pharmacist_in_charge: $('#pharmacistInCharge').val(),
        low_stock_threshold: $('#lowStockThreshold').val(),
        expiry_alert_days: $('#expiryAlertDays').val(),
        default_tax: $('#defaultTax').val(),
        max_discount: $('#maxDiscount').val(),
        enable_barcode_scanning: $('#enableBarcodeScanning').is(':checked') ? '1' : '0',
        require_prescription: $('#requirePrescription').is(':checked') ? '1' : '0',
        auto_print_receipts: $('#autoPrintReceipts').is(':checked') ? '1' : '0'
    };
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/saveSettings',
        type: 'POST',
        data: { settings: settings, type: 'general' },
        dataType: 'json',
        success: function(response) {
            if (response.status === 1) {
                showAlert('General settings saved successfully!', 'success');
            } else {
                showAlert('Error saving settings: ' + response.message, 'danger');
            }
        },
        error: function() {
            showAlert('Error saving settings. Please try again.', 'danger');
        }
    });
}

function saveCategory() {
    const categoryData = {
        id: $('#categoryId').val(),
        name: $('#categoryName').val(),
        description: $('#categoryDescription').val()
    };
    
    if (!categoryData.name.trim()) {
        showAlert('Category name is required', 'warning');
        return;
    }
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/saveCategory',
        type: 'POST',
        data: categoryData,
        dataType: 'json',
        success: function(response) {
            if (response.status === 1) {
                showAlert('Category saved successfully!', 'success');
                resetCategoryForm();
                // Reload categories table
                location.reload();
            } else {
                showAlert('Error saving category: ' + response.message, 'danger');
            }
        },
        error: function() {
            showAlert('Error saving category. Please try again.', 'danger');
        }
    });
}

function saveUnit() {
    const unitData = {
        id: $('#unitId').val(),
        unit_name: $('#unitName').val(),
        abbreviation: $('#unitAbbreviation').val(),
        unit_type: $('#unitType').val(),
        description: $('#unitDescription').val(),
        is_active: $('#unitActive').is(':checked') ? 'yes' : 'no'
    };
    
    if (!unitData.unit_name.trim()) {
        showAlert('Unit name is required', 'warning');
        return;
    }
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/saveUnit',
        type: 'POST',
        data: unitData,
        dataType: 'json',
        success: function(response) {
            if (response.status === 1) {
                showAlert('Unit saved successfully!', 'success');
                resetUnitForm();
                // Reload units table
                location.reload();
            } else {
                showAlert('Error saving unit: ' + response.message, 'danger');
            }
        },
        error: function() {
            showAlert('Error saving unit. Please try again.', 'danger');
        }
    });
}

function saveBillingSettings() {
    const settings = {
        receipt_header: $('#receiptHeader').val(),
        receipt_footer: $('#receiptFooter').val(),
        show_qr_code: $('#showQRCode').is(':checked') ? '1' : '0',
        show_barcode: $('#showBarcode').is(':checked') ? '1' : '0',
        bill_number_prefix: $('#billNumberPrefix').val(),
        rounding_rule: $('#roundingRule').val(),
        allow_partial_payments: $('#allowPartialPayments').is(':checked') ? '1' : '0',
        require_payment_upfront: $('#requirePaymentUpfront').is(':checked') ? '1' : '0',
        enable_cash: $('#enableCash').is(':checked') ? '1' : '0',
        enable_card: $('#enableCard').is(':checked') ? '1' : '0',
        enable_mpesa: $('#enableMpesa').is(':checked') ? '1' : '0',
        enable_bank_transfer: $('#enableBankTransfer').is(':checked') ? '1' : '0'
    };
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/saveSettings',
        type: 'POST',
        data: { settings: settings, type: 'billing' },
        dataType: 'json',
        success: function(response) {
            if (response.status === 1) {
                showAlert('Billing settings saved successfully!', 'success');
            } else {
                showAlert('Error saving settings: ' + response.message, 'danger');
            }
        },
        error: function() {
            showAlert('Error saving settings. Please try again.', 'danger');
        }
    });
}

function saveNotificationSettings() {
    const settings = {
        enable_low_stock_alerts: $('#enableLowStockAlerts').is(':checked') ? '1' : '0',
        enable_expiry_alerts: $('#enableExpiryAlerts').is(':checked') ? '1' : '0',
        alert_frequency: $('#alertFrequency').val(),
        alert_email: $('#alertEmail').val(),
        email_daily_reports: $('#emailDailyReports').is(':checked') ? '1' : '0',
        email_weekly_reports: $('#emailWeeklyReports').is(':checked') ? '1' : '0',
        enable_sms_alerts: $('#enableSMSAlerts').is(':checked') ? '1' : '0',
        sms_phone_number: $('#smsPhoneNumber').val()
    };
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/saveSettings',
        type: 'POST',
        data: { settings: settings, type: 'notifications' },
        dataType: 'json',
        success: function(response) {
            if (response.status === 1) {
                showAlert('Notification settings saved successfully!', 'success');
            } else {
                showAlert('Error saving settings: ' + response.message, 'danger');
            }
        },
        error: function() {
            showAlert('Error saving settings. Please try again.', 'danger');
        }
    });
}

// Category Management Functions
function addCategory() {
    resetCategoryForm();
    $('#categoryName').focus();
}

function editCategory(id, name) {
    $('#categoryId').val(id);
    $('#categoryName').val(name);
    $('#categoryName').focus();
}

function deleteCategory(id) {
    if (confirm('Are you sure you want to delete this category? This action cannot be undone.')) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/dispensary/deleteCategory',
            type: 'POST',
            data: { id: id },
            dataType: 'json',
            success: function(response) {
                if (response.status === 1) {
                    showAlert('Category deleted successfully!', 'success');
                    location.reload();
                } else {
                    showAlert('Error deleting category: ' + response.message, 'danger');
                }
            },
            error: function() {
                showAlert('Error deleting category. Please try again.', 'danger');
            }
        });
    }
}

function resetCategoryForm() {
    $('#categoryForm')[0].reset();
    $('#categoryId').val('');
}

// Unit Management Functions
function addUnit() {
    resetUnitForm();
    $('#unitName').focus();
}

function editUnit(id) {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/getUnit',
        type: 'POST',
        data: { id: id },
        dataType: 'json',
        success: function(response) {
            if (response.status === 1) {
                const unit = response.unit;
                $('#unitId').val(unit.id);
                $('#unitName').val(unit.unit_name);
                $('#unitAbbreviation').val(unit.abbreviation);
                $('#unitType').val(unit.unit_type);
                $('#unitDescription').val(unit.description);
                $('#unitActive').prop('checked', unit.is_active === 'yes');
            }
        }
    });
}

function deleteUnit(id) {
    if (confirm('Are you sure you want to delete this unit? This action cannot be undone.')) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/dispensary/deleteUnit',
            type: 'POST',
            data: { id: id },
            dataType: 'json',
            success: function(response) {
                if (response.status === 1) {
                    showAlert('Unit deleted successfully!', 'success');
                    location.reload();
                } else {
                    showAlert('Error deleting unit: ' + response.message, 'danger');
                }
            },
            error: function() {
                showAlert('Error deleting unit. Please try again.', 'danger');
            }
        });
    }
}

function resetUnitForm() {
    $('#unitForm')[0].reset();
    $('#unitId').val('');
    $('#unitActive').prop('checked', true);
}

// Maintenance Functions
function clearCache() {
    if (confirm('This will clear all system cache. Continue?')) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/dispensary/clearCache',
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 1) {
                    showAlert('Cache cleared successfully!', 'success');
                } else {
                    showAlert('Error clearing cache: ' + response.message, 'danger');
                }
            },
            error: function() {
                showAlert('Error clearing cache. Please try again.', 'danger');
            }
        });
    }
}

function optimizeDatabase() {
    if (confirm('This will optimize the database. This may take a few minutes. Continue?')) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/dispensary/optimizeDatabase',
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 1) {
                    showAlert('Database optimized successfully!', 'success');
                    loadSystemInfo(); // Refresh system info
                } else {
                    showAlert('Error optimizing database: ' + response.message, 'danger');
                }
            },
            error: function() {
                showAlert('Error optimizing database. Please try again.', 'danger');
            }
        });
    }
}

function cleanTempFiles() {
    if (confirm('This will clean temporary files. Continue?')) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/dispensary/cleanTempFiles',
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 1) {
                    showAlert('Temporary files cleaned successfully!', 'success');
                } else {
                    showAlert('Error cleaning files: ' + response.message, 'danger');
                }
            },
            error: function() {
                showAlert('Error cleaning files. Please try again.', 'danger');
            }
        });
    }
}

function rebuildIndexes() {
    if (confirm('This will rebuild database indexes. This may take several minutes. Continue?')) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/dispensary/rebuildIndexes',
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 1) {
                    showAlert('Database indexes rebuilt successfully!', 'success');
                } else {
                    showAlert('Error rebuilding indexes: ' + response.message, 'danger');
                }
            },
            error: function() {
                showAlert('Error rebuilding indexes. Please try again.', 'danger');
            }
        });
    }
}

function createBackup() {
    if (confirm('Create a backup of all dispensary data?')) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/dispensary/createBackup',
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 1) {
                    showAlert('Backup created successfully!', 'success');
                    if (response.download_url) {
                        window.open(response.download_url, '_blank');
                    }
                } else {
                    showAlert('Error creating backup: ' + response.message, 'danger');
                }
            },
            error: function() {
                showAlert('Error creating backup. Please try again.', 'danger');
            }
        });
    }
}

function viewBackupHistory() {
    window.open('<?php echo base_url(); ?>admin/dispensary/backupHistory', '_blank');
}

function testNotifications() {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/testNotifications',
        type: 'POST',
        dataType: 'json',
        success: function(response) {
            if (response.status === 1) {
                showAlert('Test notifications sent successfully!', 'success');
            } else {
                showAlert('Error sending test notifications: ' + response.message, 'danger');
            }
        },
        error: function() {
            showAlert('Error sending test notifications. Please try again.', 'danger');
        }
    });
}

function exportSettings() {
    window.open('<?php echo base_url(); ?>admin/dispensary/exportSettings', '_blank');
}

// Reset Functions
function resetGeneralSettings() {
    if (confirm('Reset all general settings to default values?')) {
        $('#generalSettingsForm')[0].reset();
        $('#dispensaryName').val('Medical Dispensary');
        $('#lowStockThreshold').val('50');
        $('#expiryAlertDays').val('90');
        $('#defaultTax').val('16');
        $('#maxDiscount').val('20');
        $('#autoPrintReceipts').prop('checked', true);
    }
}

function resetBillingSettings() {
    if (confirm('Reset all billing settings to default values?')) {
        $('#billingSettingsForm')[0].reset();
        $('#receiptHeader').val('MEDICAL DISPENSARY RECEIPT');
        $('#receiptFooter').val('Thank you for choosing our services!');
        $('#billNumberPrefix').val('MDB');
        $('#roundingRule').val('none');
        $('#requirePaymentUpfront').prop('checked', true);
        $('#enableCash').prop('checked', true);
        $('#enableCard').prop('checked', true);
        $('#enableMpesa').prop('checked', true);
    }
}

// Alert function
function showAlert(message, type) {
    const alertClass = type === 'success' ? 'alert-success' : 
                      type === 'warning' ? 'alert-warning' : 
                      type === 'danger' ? 'alert-danger' : 'alert-info';
    
    const alertHtml = `
        <div class="alert ${alertClass} alert-dismissible" style="position: fixed; top: 70px; right: 20px; z-index: 9999; min-width: 300px;">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            ${message}
        </div>
    `;
    
    $('body').append(alertHtml);
    
    // Auto-hide after 5 seconds
    setTimeout(() => {
        $('.alert').fadeOut();
    }, 5000);
}
</script>