<?php $currency_symbol = $this->customlib->getHospitalCurrencyFormat(); ?>

<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-bar-chart"></i> Dispensary Reports & Analytics
            <small>Comprehensive reporting and business intelligence</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/dispensary">Medical Dispensary</a></li>
            <li class="active">Reports</li>
        </ol>
    </section>

    <section class="content">
        <!-- Quick Report Filters -->
        <div class="box box-info">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-filter"></i> Report Filters</h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-sm btn-default" onclick="resetFilters()">
                        <i class="fa fa-refresh"></i> Reset
                    </button>
                </div>
            </div>
            <div class="box-body">
                <form id="reportFiltersForm">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="dateFrom">Date From</label>
                                <input type="date" class="form-control" id="dateFrom" 
                                       value="<?php echo date('Y-m-01'); ?>" onchange="updateReports()">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="dateTo">Date To</label>
                                <input type="date" class="form-control" id="dateTo" 
                                       value="<?php echo date('Y-m-d'); ?>" onchange="updateReports()">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="medicineCategory">Medicine Category</label>
                                <select class="form-control" id="medicineCategory" onchange="updateReports()">
                                    <option value="">All Categories</option>
                                    <?php foreach ($medicine_categories as $category): ?>
                                        <option value="<?php echo $category->id; ?>">
                                            <?php echo $category->medicine_category; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="reportType">Report Type</label>
                                <select class="form-control" id="reportType" onchange="updateReports()">
                                    <option value="summary">Summary</option>
                                    <option value="detailed">Detailed</option>
                                    <option value="inventory">Inventory</option>
                                    <option value="performance">Performance</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Report Cards Row -->
        <div class="row">
            <div class="col-md-3">
                <div class="info-box bg-aqua">
                    <span class="info-box-icon"><i class="fa fa-file-text"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Bills</span>
                        <span class="info-box-number" id="totalBills">Loading...</span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">
                            Period: <span id="billsPeriod">This Month</span>
                        </span>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="info-box bg-green">
                    <span class="info-box-icon"><i class="fa fa-money"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Revenue</span>
                        <span class="info-box-number" id="totalRevenue">Loading...</span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">
                            Growth: <span id="revenueGrowth">+0%</span>
                        </span>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="info-box bg-yellow">
                    <span class="info-box-icon"><i class="fa fa-medkit"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Medicines Sold</span>
                        <span class="info-box-number" id="medicinesSold">Loading...</span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">
                            Units: <span id="totalUnits">0</span>
                        </span>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="info-box bg-red">
                    <span class="info-box-icon"><i class="fa fa-users"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Unique Patients</span>
                        <span class="info-box-number" id="uniquePatients">Loading...</span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">
                            Avg per day: <span id="avgPatients">0</span>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Sales Trend Chart -->
            <div class="col-md-8">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-line-chart"></i> Sales Trend Analysis</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-sm btn-primary" onclick="exportChart('sales')">
                                <i class="fa fa-download"></i> Export
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <canvas id="salesTrendChart" width="400" height="200"></canvas>
                    </div>
                </div>
            </div>

            <!-- Top Medicines -->
            <div class="col-md-4">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-trophy"></i> Top Selling Medicines</h3>
                    </div>
                    <div class="box-body">
                        <div id="topMedicinesList">
                            <div class="text-center">
                                <i class="fa fa-spinner fa-spin fa-2x"></i>
                                <p>Loading top medicines...</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Detailed Reports Table -->
            <div class="col-md-12">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-table"></i> Detailed Reports</h3>
                        <div class="box-tools pull-right">
                            <div class="btn-group">
                                <button type="button" class="btn btn-sm btn-warning dropdown-toggle" data-toggle="dropdown">
                                    <i class="fa fa-download"></i> Export <span class="caret"></span>
                                </button>
                                <ul class="dropdown-menu" role="menu">
                                    <li><a href="#" onclick="exportData('pdf')"><i class="fa fa-file-pdf-o"></i> PDF</a></li>
                                    <li><a href="#" onclick="exportData('excel')"><i class="fa fa-file-excel-o"></i> Excel</a></li>
                                    <li><a href="#" onclick="exportData('csv')"><i class="fa fa-file-text-o"></i> CSV</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table id="reportsTable" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Bill No</th>
                                        <th>Patient</th>
                                        <th>Items</th>
                                        <th>Subtotal</th>
                                        <th>Discount</th>
                                        <th>Tax</th>
                                        <th>Net Amount</th>
                                        <th>Payment Method</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody id="reportsTableBody">
                                    <tr>
                                        <td colspan="10" class="text-center">
                                            <i class="fa fa-spinner fa-spin"></i> Loading reports...
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Inventory Reports -->
        <div class="row">
            <div class="col-md-6">
                <div class="box box-danger">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-exclamation-triangle"></i> Critical Stock Alerts</h3>
                    </div>
                    <div class="box-body">
                        <div id="criticalStockList">
                            <div class="text-center">
                                <i class="fa fa-spinner fa-spin"></i>
                                <p>Loading stock alerts...</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-calendar"></i> Expiry Alerts</h3>
                    </div>
                    <div class="box-body">
                        <div id="expiryAlertsList">
                            <div class="text-center">
                                <i class="fa fa-spinner fa-spin"></i>
                                <p>Loading expiry alerts...</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Financial Analysis -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-pie-chart"></i> Financial Analysis</h3>
                        <div class="box-tools pull-right">
                            <div class="btn-group">
                                <button type="button" class="btn btn-sm btn-primary" onclick="toggleChart('revenue')">Revenue</button>
                                <button type="button" class="btn btn-sm btn-default" onclick="toggleChart('profit')">Profit</button>
                                <button type="button" class="btn btn-sm btn-default" onclick="toggleChart('categories')">Categories</button>
                            </div>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-8">
                                <canvas id="financialChart" width="400" height="300"></canvas>
                            </div>
                            <div class="col-md-4">
                                <div id="financialSummary">
                                    <h5>Financial Summary</h5>
                                    <table class="table table-condensed">
                                        <tr>
                                            <td><strong>Gross Revenue:</strong></td>
                                            <td class="text-right" id="grossRevenue"><?php echo $currency_symbol; ?>0.00</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Total Discounts:</strong></td>
                                            <td class="text-right" id="totalDiscounts"><?php echo $currency_symbol; ?>0.00</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Total Taxes:</strong></td>
                                            <td class="text-right" id="totalTaxes"><?php echo $currency_symbol; ?>0.00</td>
                                        </tr>
                                        <tr class="bg-yellow">
                                            <td><strong>Net Revenue:</strong></td>
                                            <td class="text-right" id="netRevenue"><?php echo $currency_symbol; ?>0.00</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Avg. Bill Value:</strong></td>
                                            <td class="text-right" id="avgBillValue"><?php echo $currency_symbol; ?>0.00</td>
                                        </tr>
                                        <tr>
                                            <td><strong>Payment Methods:</strong></td>
                                            <td class="text-right">
                                                <small id="paymentBreakdown">Loading...</small>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Chart.js -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.js"></script>

<style>
/* Reports specific styles */
.info-box {
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    transition: transform 0.3s ease;
}

.info-box:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}

.box {
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.table-responsive {
    border-radius: 6px;
}

.progress {
    height: 4px;
    margin-bottom: 5px;
}

.btn-group .btn {
    border-radius: 4px;
}

.top-medicine-item {
    padding: 10px;
    border-bottom: 1px solid #f0f0f0;
    transition: background-color 0.3s ease;
}

.top-medicine-item:hover {
    background-color: #f8f9fa;
}

.top-medicine-item:last-child {
    border-bottom: none;
}

.medicine-rank {
    display: inline-block;
    width: 30px;
    height: 30px;
    line-height: 30px;
    text-align: center;
    border-radius: 50%;
    font-weight: bold;
    font-size: 12px;
    margin-right: 10px;
}

.rank-1 { background: #f39c12; color: white; }
.rank-2 { background: #95a5a6; color: white; }
.rank-3 { background: #e67e22; color: white; }
.rank-other { background: #ecf0f1; color: #2c3e50; }

@media (max-width: 768px) {
    .info-box-number {
        font-size: 18px;
    }
    
    .box-body {
        padding: 10px;
    }
    
    .table-responsive {
        font-size: 12px;
    }
}
</style>

<script>
// Global variables for charts
let salesChart = null;
let financialChart = null;

$(document).ready(function() {
    // Initialize reports
    updateReports();
    
    // Initialize charts
    initializeSalesChart();
    initializeFinancialChart();
    
    // Auto-refresh every 5 minutes
    setInterval(updateReports, 300000);
});

function updateReports() {
    const filters = {
        date_from: $('#dateFrom').val(),
        date_to: $('#dateTo').val(),
        medicine_category: $('#medicineCategory').val(),
        report_type: $('#reportType').val()
    };
    
    // Update all report sections
    updateSummaryCards(filters);
    updateReportsTable(filters);
    updateTopMedicines(filters);
    updateStockAlerts();
    updateFinancialSummary(filters);
}

function updateSummaryCards(filters) {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/getSalesReport',
        type: 'POST',
        data: filters,
        dataType: 'json',
        success: function(response) {
            if (response.status === 1) {
                const data = response.data;
                $('#totalBills').text(data.total_bills || 0);
                $('#totalRevenue').text('<?php echo $currency_symbol; ?>' + 
                    (parseFloat(data.total_revenue || 0).toLocaleString()));
                $('#medicinesSold').text(data.medicines_sold || 0);
                $('#uniquePatients').text(data.unique_patients || 0);
                
                // Update additional metrics
                $('#totalUnits').text((data.total_units || 0) + ' units');
                $('#avgPatients').text(Math.round((data.unique_patients || 0) / 30));
                $('#revenueGrowth').text((data.growth_percentage || 0) + '%');
            }
        },
        error: function() {
            console.error('Failed to update summary cards');
        }
    });
}

function updateReportsTable(filters) {
    $('#reportsTableBody').html('<tr><td colspan="10" class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading...</td></tr>');
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/getDetailedReport',
        type: 'POST',
        data: filters,
        dataType: 'json',
        success: function(response) {
            if (response.status === 1) {
                let html = '';
                const bills = response.bills || [];
                
                if (bills.length === 0) {
                    html = '<tr><td colspan="10" class="text-center text-muted">No data found for selected criteria</td></tr>';
                } else {
                    bills.forEach(function(bill) {
                        const statusClass = bill.status === 'paid' ? 'label-success' : 
                                          bill.status === 'pending' ? 'label-warning' : 'label-default';
                        
                        html += `
                            <tr>
                                <td>${new Date(bill.bill_date).toLocaleDateString()}</td>
                                <td><strong>${bill.bill_no}</strong></td>
                                <td>${bill.patient_name || 'Walk-in'}</td>
                                <td>${bill.item_count}</td>
                                <td class="text-right"><?php echo $currency_symbol; ?>${parseFloat(bill.subtotal).toFixed(2)}</td>
                                <td class="text-right"><?php echo $currency_symbol; ?>${parseFloat(bill.discount_amount).toFixed(2)}</td>
                                <td class="text-right"><?php echo $currency_symbol; ?>${parseFloat(bill.tax_amount).toFixed(2)}</td>
                                <td class="text-right"><strong><?php echo $currency_symbol; ?>${parseFloat(bill.net_amount).toFixed(2)}</strong></td>
                                <td>${bill.payment_method}</td>
                                <td><span class="label ${statusClass}">${bill.status.toUpperCase()}</span></td>
                            </tr>
                        `;
                    });
                }
                
                $('#reportsTableBody').html(html);
            } else {
                $('#reportsTableBody').html('<tr><td colspan="10" class="text-center text-danger">Error loading data</td></tr>');
            }
        },
        error: function() {
            $('#reportsTableBody').html('<tr><td colspan="10" class="text-center text-danger">Failed to load reports</td></tr>');
        }
    });
}

function updateTopMedicines(filters) {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/getTopMedicines',
        type: 'POST',
        data: filters,
        dataType: 'json',
        success: function(response) {
            if (response.status === 1) {
                let html = '';
                const medicines = response.medicines || [];
                
                if (medicines.length === 0) {
                    html = '<div class="text-center text-muted">No data available</div>';
                } else {
                    medicines.forEach(function(medicine, index) {
                        const rank = index + 1;
                        const rankClass = rank === 1 ? 'rank-1' : rank === 2 ? 'rank-2' : rank === 3 ? 'rank-3' : 'rank-other';
                        
                        html += `
                            <div class="top-medicine-item">
                                <span class="medicine-rank ${rankClass}">${rank}</span>
                                <strong>${medicine.medicine_name}</strong>
                                <br>
                                <small class="text-muted">${medicine.medicine_company || 'N/A'}</small>
                                <div class="pull-right">
                                    <span class="label label-primary">${medicine.total_sold} sold</span>
                                    <br>
                                    <small><?php echo $currency_symbol; ?>${parseFloat(medicine.total_revenue).toFixed(0)}</small>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        `;
                    });
                }
                
                $('#topMedicinesList').html(html);
            }
        },
        error: function() {
            $('#topMedicinesList').html('<div class="text-center text-danger">Error loading top medicines</div>');
        }
    });
}

function updateStockAlerts() {
    // Update critical stock alerts
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/getCriticalStock',
        type: 'POST',
        dataType: 'json',
        success: function(response) {
            if (response.status === 1) {
                let html = '';
                const items = response.items || [];
                
                if (items.length === 0) {
                    html = '<div class="callout callout-success"><h4>All Good!</h4><p>No critical stock issues found.</p></div>';
                } else {
                    html = '<ul class="list-unstyled">';
                    items.forEach(function(item) {
                        const alertClass = item.stock <= 0 ? 'text-danger' : 'text-warning';
                        html += `
                            <li class="${alertClass}">
                                <i class="fa fa-exclamation-triangle"></i>
                                <strong>${item.medicine_name}</strong>
                                <span class="pull-right">${item.stock} left</span>
                            </li>
                        `;
                    });
                    html += '</ul>';
                }
                
                $('#criticalStockList').html(html);
            }
        }
    });
    
    // Update expiry alerts
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/getExpiryAlerts',
        type: 'POST',
        dataType: 'json',
        success: function(response) {
            if (response.status === 1) {
                let html = '';
                const items = response.items || [];
                
                if (items.length === 0) {
                    html = '<div class="callout callout-success"><h4>All Good!</h4><p>No medicines expiring soon.</p></div>';
                } else {
                    html = '<ul class="list-unstyled">';
                    items.forEach(function(item) {
                        const daysToExpiry = Math.ceil((new Date(item.expiry) - new Date()) / (1000 * 60 * 60 * 24));
                        const alertClass = daysToExpiry <= 0 ? 'text-danger' : daysToExpiry <= 30 ? 'text-warning' : 'text-info';
                        
                        html += `
                            <li class="${alertClass}">
                                <i class="fa fa-calendar"></i>
                                <strong>${item.medicine_name}</strong>
                                <span class="pull-right">${daysToExpiry} days</span>
                            </li>
                        `;
                    });
                    html += '</ul>';
                }
                
                $('#expiryAlertsList').html(html);
            }
        }
    });
}

function updateFinancialSummary(filters) {
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/getFinancialSummary',
        type: 'POST',
        data: filters,
        dataType: 'json',
        success: function(response) {
            if (response.status === 1) {
                const data = response.data;
                $('#grossRevenue').text('<?php echo $currency_symbol; ?>' + parseFloat(data.gross_revenue || 0).toFixed(2));
                $('#totalDiscounts').text('<?php echo $currency_symbol; ?>' + parseFloat(data.total_discounts || 0).toFixed(2));
                $('#totalTaxes').text('<?php echo $currency_symbol; ?>' + parseFloat(data.total_taxes || 0).toFixed(2));
                $('#netRevenue').text('<?php echo $currency_symbol; ?>' + parseFloat(data.net_revenue || 0).toFixed(2));
                $('#avgBillValue').text('<?php echo $currency_symbol; ?>' + parseFloat(data.avg_bill_value || 0).toFixed(2));
                $('#paymentBreakdown').text(data.payment_breakdown || 'N/A');
            }
        }
    });
}

function initializeSalesChart() {
    const ctx = document.getElementById('salesTrendChart').getContext('2d');
    salesChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: [],
            datasets: [{
                label: 'Sales',
                data: [],
                borderColor: '#3c8dbc',
                backgroundColor: 'rgba(60,141,188,0.1)',
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
    
    // Load initial data
    updateSalesChart();
}

function initializeFinancialChart() {
    const ctx = document.getElementById('financialChart').getContext('2d');
    financialChart = new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: [],
            datasets: [{
                data: [],
                backgroundColor: [
                    '#f56954', '#00a65a', '#f39c12', '#00c0ef', '#3c8dbc', '#d2d6de'
                ]
            }]
        },
        options: {
            responsive: true
        }
    });
    
    // Load initial data
    toggleChart('categories');
}

function updateSalesChart() {
    const filters = {
        date_from: $('#dateFrom').val(),
        date_to: $('#dateTo').val()
    };
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/getSalesTrend',
        type: 'POST',
        data: filters,
        dataType: 'json',
        success: function(response) {
            if (response.status === 1 && salesChart) {
                salesChart.data.labels = response.labels || [];
                salesChart.data.datasets[0].data = response.data || [];
                salesChart.update();
            }
        }
    });
}

function toggleChart(type) {
    $('.btn-group .btn').removeClass('btn-primary').addClass('btn-default');
    $(`button[onclick="toggleChart('${type}')"]`).removeClass('btn-default').addClass('btn-primary');
    
    const filters = {
        date_from: $('#dateFrom').val(),
        date_to: $('#dateTo').val(),
        chart_type: type
    };
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/getChartData',
        type: 'POST',
        data: filters,
        dataType: 'json',
        success: function(response) {
            if (response.status === 1 && financialChart) {
                financialChart.data.labels = response.labels || [];
                financialChart.data.datasets[0].data = response.data || [];
                financialChart.update();
            }
        }
    });
}

function resetFilters() {
    $('#dateFrom').val('<?php echo date('Y-m-01'); ?>');
    $('#dateTo').val('<?php echo date('Y-m-d'); ?>');
    $('#medicineCategory').val('');
    $('#reportType').val('summary');
    updateReports();
}

function exportData(format) {
    const filters = {
        date_from: $('#dateFrom').val(),
        date_to: $('#dateTo').val(),
        medicine_category: $('#medicineCategory').val(),
        report_type: $('#reportType').val(),
        export_format: format
    };
    
    const params = new URLSearchParams(filters);
    window.open(`<?php echo base_url(); ?>admin/dispensary/exportReport?${params}`, '_blank');
}

function exportChart(chartType) {
    let canvas, filename;
    
    if (chartType === 'sales') {
        canvas = document.getElementById('salesTrendChart');
        filename = 'sales_trend_chart.png';
    } else {
        canvas = document.getElementById('financialChart');
        filename = 'financial_chart.png';
    }
    
    const link = document.createElement('a');
    link.download = filename;
    link.href = canvas.toDataURL();
    link.click();
}
</script>