<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($title) ? $title : 'Dispensing Receipt'; ?></title>
    <style>
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; }
            .receipt { box-shadow: none; margin: 0; }
        }
        
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background: #f5f5f5;
        }
        
        .receipt {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            border-radius: 8px;
        }
        
        .header {
            text-align: center;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        
        .hospital-name {
            font-size: 24px;
            font-weight: bold;
            color: #2c3e50;
            margin-bottom: 5px;
        }
        
        .hospital-details {
            color: #666;
            font-size: 14px;
            line-height: 1.5;
        }
        
        .bill-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 5px;
        }
        
        .bill-title {
            font-size: 20px;
            font-weight: bold;
            color: #2c3e50;
        }
        
        .bill-number {
            font-size: 16px;
            color: #007bff;
            font-weight: bold;
        }
        
        .patient-info {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 30px;
            padding: 20px;
            border: 1px solid #dee2e6;
            border-radius: 5px;
            background: #f8f9fa;
        }
        
        .patient-section h3 {
            margin: 0 0 15px 0;
            color: #495057;
            font-size: 16px;
            border-bottom: 1px solid #dee2e6;
            padding-bottom: 5px;
        }
        
        .info-row {
            display: flex;
            margin-bottom: 8px;
        }
        
        .info-label {
            font-weight: bold;
            width: 120px;
            color: #495057;
        }
        
        .info-value {
            color: #333;
        }
        
        .medicines-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        
        .medicines-table th {
            background: #495057;
            color: white;
            padding: 12px 8px;
            text-align: left;
            font-weight: 600;
            border: 1px solid #495057;
        }
        
        .medicines-table td {
            padding: 10px 8px;
            border: 1px solid #dee2e6;
            vertical-align: top;
        }
        
        .medicines-table tbody tr:nth-child(even) {
            background: #f8f9fa;
        }
        
        .medicine-name {
            font-weight: 600;
            color: #2c3e50;
        }
        
        .batch-info {
            font-size: 12px;
            color: #666;
            margin-top: 2px;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .bill-summary {
            border: 2px solid #495057;
            border-radius: 5px;
            overflow: hidden;
            margin-bottom: 30px;
        }
        
        .summary-header {
            background: #495057;
            color: white;
            padding: 12px 15px;
            font-weight: bold;
            text-align: center;
        }
        
        .summary-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 15px;
            border-bottom: 1px solid #dee2e6;
        }
        
        .summary-row:last-child {
            border-bottom: none;
            background: #f8f9fa;
            font-weight: bold;
            font-size: 16px;
        }
        
        .summary-label {
            color: #495057;
        }
        
        .summary-value {
            color: #2c3e50;
            font-weight: 600;
        }
        
        .footer-info {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #dee2e6;
        }
        
        .footer-section h4 {
            margin: 0 0 10px 0;
            color: #495057;
            font-size: 14px;
        }
        
        .footer-section p {
            margin: 5px 0;
            color: #666;
            font-size: 13px;
        }
        
        .signature-line {
            border-top: 1px solid #333;
            margin-top: 20px;
            padding-top: 5px;
            text-align: center;
            font-size: 12px;
            color: #666;
        }
        
        .print-buttons {
            text-align: center;
            margin: 20px 0;
        }
        
        .btn {
            padding: 10px 20px;
            margin: 0 10px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
        }
        
        .btn-primary {
            background: #007bff;
            color: white;
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn:hover {
            opacity: 0.9;
            transform: translateY(-1px);
        }
        
        .dosage-instructions {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 5px;
            padding: 15px;
            margin: 20px 0;
        }
        
        .dosage-instructions h4 {
            margin: 0 0 10px 0;
            color: #856404;
            font-size: 14px;
        }
        
        .dosage-instructions p {
            margin: 5px 0;
            color: #856404;
            font-size: 13px;
        }
        
        @media (max-width: 768px) {
            .receipt {
                margin: 10px;
                padding: 20px;
            }
            
            .patient-info {
                grid-template-columns: 1fr;
                gap: 15px;
            }
            
            .footer-info {
                grid-template-columns: 1fr;
                gap: 20px;
            }
            
            .medicines-table {
                font-size: 12px;
            }
            
            .medicines-table th,
            .medicines-table td {
                padding: 8px 4px;
            }
        }
    </style>
</head>
<body>
    <!-- Print Buttons -->
    <div class="print-buttons no-print">
        <button class="btn btn-primary" onclick="window.print()">
            <i class="fa fa-print"></i> Print Receipt
        </button>
        <a href="<?php echo base_url('admin/dispensary/dispensing'); ?>" class="btn btn-secondary">
            <i class="fa fa-arrow-left"></i> Back to Dispensing
        </a>
    </div>

    <div class="receipt">
        <!-- Hospital Header -->
        <div class="header">
            <div class="hospital-name">
                <?php 
                    // Safely get hospital name
                    if (method_exists($this->customlib, 'getSchoolName')) {
                        echo $this->customlib->getSchoolName();
                    } else {
                        echo 'Medical Hospital'; // Default name
                    }
                ?>
            </div>
            <div class="hospital-details">
                <?php 
                    // Safely get hospital details
                    if (method_exists($this->customlib, 'getSchoolAddress')) {
                        echo $this->customlib->getSchoolAddress();
                    } else {
                        echo 'Hospital Address';
                    }
                ?><br>
                Phone: <?php 
                    if (method_exists($this->customlib, 'getSchoolPhone')) {
                        echo $this->customlib->getSchoolPhone();
                    } else {
                        echo 'N/A';
                    }
                ?> | 
                Email: <?php 
                    if (method_exists($this->customlib, 'getSchoolEmail')) {
                        echo $this->customlib->getSchoolEmail();
                    } else {
                        echo 'N/A';
                    }
                ?>
            </div>
        </div>

        <!-- Bill Header -->
        <div class="bill-header">
            <div class="bill-title">MEDICAL DISPENSARY RECEIPT</div>
            <div class="bill-number">
                Bill #: <?php echo isset($bill->bill_no) ? $bill->bill_no : 'MDB' . str_pad($bill->id, 6, '0', STR_PAD_LEFT); ?>
            </div>
        </div>

        <!-- Patient Information -->
        <div class="patient-info">
            <div class="patient-section">
                <h3>Patient Information</h3>
                <div class="info-row">
                    <span class="info-label">Patient ID:</span>
                    <span class="info-value"><?php echo isset($bill->patient_unique_id) ? $bill->patient_unique_id : 'N/A'; ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Name:</span>
                    <span class="info-value"><?php echo isset($bill->patient_name) ? $bill->patient_name : 'Walk-in Customer'; ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Age/Gender:</span>
                    <span class="info-value">
                        <?php 
                            $age = isset($bill->age) ? $bill->age : 'N/A';
                            $gender = isset($bill->gender) ? $bill->gender : 'N/A';
                            echo $age . ' / ' . $gender;
                        ?>
                    </span>
                </div>
                <div class="info-row">
                    <span class="info-label">Mobile:</span>
                    <span class="info-value"><?php echo isset($bill->mobileno) ? $bill->mobileno : 'N/A'; ?></span>
                </div>
            </div>
            
            <div class="patient-section">
                <h3>Bill Information</h3>
                <div class="info-row">
                    <span class="info-label">Date:</span>
                    <span class="info-value">
                        <?php 
                            $date = isset($bill->date) ? $bill->date : date('Y-m-d H:i:s');
                            echo date('d-m-Y H:i', strtotime($date)); 
                        ?>
                    </span>
                </div>
                <div class="info-row">
                    <span class="info-label">Payment Mode:</span>
                    <span class="info-value">Cash</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Payment Status:</span>
                    <span class="info-value"><?php echo isset($bill->payment_status) ? ucfirst($bill->payment_status) : 'Paid'; ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Dispensed By:</span>
                    <span class="info-value"><?php echo isset($bill->generated_by_name) ? $bill->generated_by_name : 'Pharmacist'; ?></span>
                </div>
            </div>
        </div>

        <!-- Medicine Details -->
        <table class="medicines-table">
            <thead>
                <tr>
                    <th style="width: 5%;">#</th>
                    <th style="width: 35%;">Medicine Details</th>
                    <th style="width: 15%;">Batch Info</th>
                    <th style="width: 10%;">Qty</th>
                    <th style="width: 15%;">Unit Price</th>
                    <th style="width: 20%;">Amount</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($bill_items) && is_array($bill_items)): ?>
                    <?php $serial = 1; ?>
                    <?php foreach ($bill_items as $item): ?>
                        <tr>
                            <td class="text-center"><?php echo $serial++; ?></td>
                            <td>
                                <div class="medicine-name">
                                    <?php echo isset($item->medicine_name) ? $item->medicine_name : 'Medicine'; ?>
                                </div>
                                <div class="batch-info">
                                    <?php if (isset($item->medicine_company) && $item->medicine_company): ?>
                                        Company: <?php echo $item->medicine_company; ?>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <strong>Batch:</strong> <?php echo isset($item->batch_no) ? $item->batch_no : 'N/A'; ?><br>
                                <strong>Expiry:</strong> 
                                <?php 
                                    if (isset($item->expiry) && $item->expiry) {
                                        echo date('m/Y', strtotime($item->expiry));
                                    } else {
                                        echo 'N/A';
                                    }
                                ?>
                            </td>
                            <td class="text-center"><?php echo isset($item->quantity) ? $item->quantity : '0'; ?></td>
                            <td class="text-right">
                                <?php 
                                    $currency = isset($currency_symbol) ? $currency_symbol : '$';
                                    $price = isset($item->sale_price) ? $item->sale_price : 0;
                                    echo $currency . number_format($price, 2); 
                                ?>
                            </td>
                            <td class="text-right">
                                <?php 
                                    $amount = isset($item->amount) ? $item->amount : 0;
                                    echo $currency . number_format($amount, 2); 
                                ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" class="text-center">No items found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <!-- Bill Summary -->
        <div class="bill-summary">
            <div class="summary-header">BILL SUMMARY</div>
            <div class="summary-row">
                <span class="summary-label">Subtotal:</span>
                <span class="summary-value">
                    <?php 
                        $currency = isset($currency_symbol) ? $currency_symbol : '$';
                        $total = isset($bill->total) ? $bill->total : 0;
                        echo $currency . number_format($total, 2); 
                    ?>
                </span>
            </div>
            <?php if (isset($bill->discount) && $bill->discount > 0): ?>
                <div class="summary-row">
                    <span class="summary-label">
                        Discount (<?php echo isset($bill->discount_percentage) ? $bill->discount_percentage : '0'; ?>%):
                    </span>
                    <span class="summary-value">- <?php echo $currency . number_format($bill->discount, 2); ?></span>
                </div>
            <?php endif; ?>
            <?php if (isset($bill->tax) && $bill->tax > 0): ?>
                <div class="summary-row">
                    <span class="summary-label">
                        Tax (<?php echo isset($bill->tax_percentage) ? $bill->tax_percentage : '0'; ?>%):
                    </span>
                    <span class="summary-value"><?php echo $currency . number_format($bill->tax, 2); ?></span>
                </div>
            <?php endif; ?>
            <div class="summary-row">
                <span class="summary-label">Net Amount:</span>
                <span class="summary-value">
                    <?php 
                        $net_amount = isset($bill->net_amount) ? $bill->net_amount : $total;
                        echo $currency . number_format($net_amount, 2); 
                    ?>
                </span>
            </div>
        </div>

        <!-- Dosage Instructions -->
        <div class="dosage-instructions">
            <h4><i class="fa fa-info-circle"></i> Important Instructions</h4>
            <p><strong>• Take medicines as prescribed by your doctor</strong></p>
            <p>• Complete the full course even if you feel better</p>
            <p>• Store medicines in a cool, dry place away from children</p>
            <p>• Check expiry dates before consumption</p>
            <p>• Consult your doctor if you experience any side effects</p>
            <?php if (isset($bill->note) && $bill->note): ?>
                <p><strong>Special Notes:</strong> <?php echo $bill->note; ?></p>
            <?php endif; ?>
        </div>

        <!-- Footer Information -->
        <div class="footer-info">
            <div class="footer-section">
                <h4>Return Policy</h4>
                <p>• Medicines can be returned within 7 days with original receipt</p>
                <p>• Opened/used medicines cannot be returned</p>
                <p>• Prescription medicines require doctor's approval for return</p>
            </div>
            
            <div class="footer-section">
                <h4>Contact Information</h4>
                <p>Medical Dispensary Department</p>
                <p>Phone: <?php 
                    if (method_exists($this->customlib, 'getSchoolPhone')) {
                        echo $this->customlib->getSchoolPhone();
                    } else {
                        echo 'N/A';
                    }
                ?></p>
                <p>Emergency: Available 24/7</p>
                <div class="signature-line">
                    Pharmacist Signature
                </div>
            </div>
        </div>

        <!-- Print Footer -->
        <div style="text-align: center; margin-top: 30px; padding-top: 20px; border-top: 1px solid #dee2e6; font-size: 12px; color: #666;">
            <p>This is a computer-generated receipt. No signature required.</p>
            <p>Printed on: <?php echo date('d-m-Y H:i:s'); ?></p>
        </div>
    </div>

    <script>
        // Auto-print when page loads (optional)
        // window.onload = function() { window.print(); }
        
        // Print function
        function printReceipt() {
            window.print();
        }
        
        // Go back function
        function goBack() {
            window.history.back();
        }
    </script>
</body>
</html>