<?php $currency_symbol = $this->customlib->getHospitalCurrencyFormat(); ?>

<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-cubes"></i> Medicine Stock Management
            <small>Monitor and manage medicine inventory</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/dispensary">Medical Dispensary</a></li>
            <li class="active">Medicine Stock</li>
        </ol>
    </section>

    <section class="content">
        <!-- Alert Messages -->
        <div id="alertContainer" style="display: none;">
            <div class="alert alert-dismissible" id="alertBox">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <span id="alertMessage"></span>
            </div>
        </div>

        <!-- Stock Overview Cards -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3><?php echo count($medicines); ?></h3>
                        <p>Total Medicines</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-medkit"></i>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3><?php echo $low_stock_count; ?></h3>
                        <p>Low Stock Items</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-exclamation-triangle"></i>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3><?php echo $expired_count; ?></h3>
                        <p>Expired Items</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-warning"></i>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3><?php echo count(array_filter($medicines, function($m) { return $m->total_stock > 50; })); ?></h3>
                        <p>In Stock</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-check"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Medicine Stock Table -->
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-table"></i> Medicine Stock Details</h3>
                <div class="box-tools pull-right">
                    <div class="btn-group">
                        <button type="button" class="btn btn-sm btn-success" onclick="showAddMedicineModal()">
                            <i class="fa fa-plus"></i> Add Medicine
                        </button>
                        <button type="button" class="btn btn-sm btn-info" onclick="refreshStock()">
                            <i class="fa fa-refresh"></i> Refresh
                        </button>
                        <button type="button" class="btn btn-sm btn-success" onclick="exportStock()">
                            <i class="fa fa-download"></i> Export
                        </button>
                    </div>
                </div>
            </div>
            <div class="box-body">
                <!-- Filters -->
                <div class="row filter-section" style="margin-bottom: 20px;">
                    <div class="col-md-3">
                        <select class="form-control" id="categoryFilter">
                            <option value="">All Categories</option>
                            <?php foreach ($medicine_categories as $category): ?>
                                <option value="<?php echo $category->id; ?>">
                                    <?php echo $category->medicine_category; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select class="form-control" id="stockFilter">
                            <option value="">All Stock Levels</option>
                            <option value="in_stock">In Stock</option>
                            <option value="low_stock">Low Stock</option>
                            <option value="out_of_stock">Out of Stock</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <select class="form-control" id="expiryFilter">
                            <option value="">All Items</option>
                            <option value="expired">Expired</option>
                            <option value="expiring_soon">Expiring Soon</option>
                            <option value="good">Good Expiry</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <input type="text" class="form-control" id="searchMedicine" placeholder="Search medicine...">
                    </div>
                </div>

                <!-- Medicine Stock Table with Fixed Headers -->
                <div class="table-responsive">
                    <table class="table table-striped table-bordered table-hover" id="medicineStockTable">
                        <thead>
                            <tr style="background-color: #3c8dbc; color: white;">
                                <th style="width: 5%; padding: 12px 8px; font-weight: 600;">#</th>
                                <th style="width: 25%; padding: 12px 8px; font-weight: 600;">Medicine Details</th>
                                <th style="width: 15%; padding: 12px 8px; font-weight: 600;">Category</th>
                                <th style="width: 10%; padding: 12px 8px; font-weight: 600;">Total Stock</th>
                                <th style="width: 10%; padding: 12px 8px; font-weight: 600;">Available</th>
                                <th style="width: 10%; padding: 12px 8px; font-weight: 600;">Status</th>
                                <th style="width: 15%; padding: 12px 8px; font-weight: 600;">Nearest Expiry</th>
                                <th style="width: 10%; padding: 12px 8px; font-weight: 600;">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($medicines)): ?>
                                <?php $serial = 1; ?>
                                <?php foreach ($medicines as $medicine): ?>
                                    <?php 
                                        $stock_status = '';
                                        $stock_class = '';
                                        $expiry_class = '';
                                        
                                        if ($medicine->total_stock <= 0) {
                                            $stock_status = 'Out of Stock';
                                            $stock_class = 'label-danger';
                                        } elseif ($medicine->total_stock <= 50) {
                                            $stock_status = 'Low Stock';
                                            $stock_class = 'label-warning';
                                        } else {
                                            $stock_status = 'In Stock';
                                            $stock_class = 'label-success';
                                        }
                                        
                                        // Check expiry
                                        if ($medicine->nearest_expiry) {
                                            $expiry_date = new DateTime($medicine->nearest_expiry);
                                            $today = new DateTime();
                                            $diff = $today->diff($expiry_date);
                                            
                                            if ($expiry_date < $today) {
                                                $expiry_class = 'text-danger';
                                            } elseif ($diff->days <= 30) {
                                                $expiry_class = 'text-warning';
                                            } else {
                                                $expiry_class = 'text-success';
                                            }
                                        }
                                    ?>
                                    <tr>
                                        <td style="padding: 10px 8px;"><?php echo $serial++; ?></td>
                                        <td style="padding: 10px 8px;">
                                            <strong><?php echo $medicine->medicine_name; ?></strong>
                                            <?php if ($medicine->medicine_company): ?>
                                                <br><small class="text-muted"><?php echo $medicine->medicine_company; ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td style="padding: 10px 8px;"><?php echo $medicine->medicine_category ?: 'N/A'; ?></td>
                                        <td class="text-center" style="padding: 10px 8px;">
                                            <span class="badge bg-blue"><?php echo $medicine->total_stock ?: 0; ?></span>
                                        </td>
                                        <td class="text-center" style="padding: 10px 8px;">
                                            <span class="badge bg-green"><?php echo $medicine->total_stock ?: 0; ?></span>
                                        </td>
                                        <td style="padding: 10px 8px;">
                                            <span class="label <?php echo $stock_class; ?>">
                                                <?php echo $stock_status; ?>
                                            </span>
                                        </td>
                                        <td class="<?php echo $expiry_class; ?>" style="padding: 10px 8px;">
                                            <?php if ($medicine->nearest_expiry): ?>
                                                <?php echo date('d/m/Y', strtotime($medicine->nearest_expiry)); ?>
                                            <?php else: ?>
                                                N/A
                                            <?php endif; ?>
                                        </td>
                                        <td style="padding: 10px 8px;">
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-xs btn-info" 
                                                        onclick="viewMedicineDetails(<?php echo $medicine->id; ?>)"
                                                        title="View Details"
                                                        data-medicine-id="<?php echo $medicine->id; ?>">
                                                    <i class="fa fa-eye"></i>
                                                </button>
                                                <button type="button" class="btn btn-xs btn-warning" 
                                                        onclick="adjustStock(<?php echo $medicine->id; ?>)"
                                                        title="Adjust Stock"
                                                        data-medicine-id="<?php echo $medicine->id; ?>">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                                <?php if ($medicine->total_stock > 0): ?>
                                                    <button type="button" class="btn btn-xs btn-success" 
                                                            onclick="quickDispense(<?php echo $medicine->id; ?>)"
                                                            title="Quick Dispense"
                                                            data-medicine-id="<?php echo $medicine->id; ?>">
                                                        <i class="fa fa-shopping-cart"></i>
                                                    </button>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="8" class="text-center text-muted" style="padding: 20px;">No medicines found</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Low Stock Alert -->
        <?php if (!empty($low_stock_medicines)): ?>
            <div class="box box-warning">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-exclamation-triangle"></i> Low Stock Alert</h3>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-box-tool" data-widget="collapse">
                            <i class="fa fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="box-body">
                    <div class="table-responsive">
                        <table class="table table-condensed">
                            <thead>
                                <tr>
                                    <th>Medicine</th>
                                    <th>Company</th>
                                    <th>Stock</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($low_stock_medicines as $medicine): ?>
                                    <tr>
                                        <td><?php echo $medicine->medicine_name; ?></td>
                                        <td><?php echo $medicine->medicine_company ?: 'N/A'; ?></td>
                                        <td>
                                            <span class="label label-warning">
                                                <?php echo $medicine->total_stock ?: 0; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-xs btn-primary" 
                                                    onclick="addStock(<?php echo $medicine->id; ?>)">
                                                <i class="fa fa-plus"></i> Add Stock
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Expired Medicines Alert -->
        <?php if (!empty($expired_medicines)): ?>
            <div class="box box-danger">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-warning"></i> Expired Medicines</h3>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-box-tool" data-widget="collapse">
                            <i class="fa fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="box-body">
                    <div class="table-responsive">
                        <table class="table table-condensed">
                            <thead>
                                <tr>
                                    <th>Medicine</th>
                                    <th>Batch</th>
                                    <th>Expiry Date</th>
                                    <th>Quantity</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($expired_medicines as $medicine): ?>
                                    <tr>
                                        <td><?php echo $medicine->medicine_name; ?></td>
                                        <td><?php echo $medicine->batch_no; ?></td>
                                        <td class="text-danger">
                                            <?php echo date('d/m/Y', strtotime($medicine->expiry)); ?>
                                        </td>
                                        <td><?php echo $medicine->available_quantity; ?></td>
                                        <td>
                                            <button type="button" class="btn btn-xs btn-danger" 
                                                    onclick="markExpired(<?php echo $medicine->id; ?>)">
                                                <i class="fa fa-trash"></i> Mark Expired
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </section>
</div>

<!-- Medicine Details Modal -->
<div class="modal fade" id="medicineDetailsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-medkit"></i> Medicine Details
                </h4>
            </div>
            <div class="modal-body">
                <div id="medicineDetailsContent">
                    <div class="text-center">
                        <i class="fa fa-spinner fa-spin fa-2x"></i>
                        <p>Loading medicine details...</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Stock Adjustment Modal -->
<div class="modal fade" id="stockAdjustmentModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-edit"></i> Stock Adjustment
                </h4>
            </div>
            <div class="modal-body">
                <div id="stockAdjustmentContent">
                    <div class="text-center">
                        <i class="fa fa-spinner fa-spin fa-2x"></i>
                        <p>Loading stock adjustment form...</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Medicine Modal -->
<div class="modal fade" id="addMedicineModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-plus"></i> Add New Medicine
                </h4>
            </div>
            <div class="modal-body">
                <form id="addMedicineForm">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="medicineName">Medicine Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="medicineName" name="medicine_name" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="medicineCategory">Category <span class="text-danger">*</span></label>
                                <select class="form-control" id="medicineCategory" name="medicine_category_id" required>
                                    <option value="">Select Category</option>
                                    <?php foreach ($medicine_categories as $category): ?>
                                        <option value="<?php echo $category->id; ?>">
                                            <?php echo $category->medicine_category; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="medicineCompany">Manufacturer/Company</label>
                                <input type="text" class="form-control" id="medicineCompany" name="medicine_company">
                            </div>
                            
                            <div class="form-group">
                                <label for="medicineComposition">Composition</label>
                                <textarea class="form-control" id="medicineComposition" name="medicine_composition" rows="3"></textarea>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="medicineGroup">Medicine Group</label>
                                <input type="text" class="form-control" id="medicineGroup" name="medicine_group">
                            </div>
                            
                            <div class="form-group">
                                <label for="medicineUnit">Unit <span class="text-danger">*</span></label>
                                <select class="form-control" id="medicineUnit" name="unit" required>
                                    <option value="">Select Unit</option>
                                    <option value="Tablet">Tablet</option>
                                    <option value="Capsule">Capsule</option>
                                    <option value="Syrup">Syrup</option>
                                    <option value="Injection">Injection</option>
                                    <option value="Cream">Cream</option>
                                    <option value="Ointment">Ointment</option>
                                    <option value="Drops">Drops</option>
                                    <option value="Sachets">Sachets</option>
                                    <option value="ml">ml</option>
                                    <option value="mg">mg</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="unitPacking">Unit Packing</label>
                                <input type="text" class="form-control" id="unitPacking" name="unit_packing" placeholder="e.g., 10 tablets per strip">
                            </div>
                            
                            <div class="form-group">
                                <label for="minLevel">Minimum Stock Level</label>
                                <input type="number" class="form-control" id="minLevel" name="min_level" min="0" value="10">
                            </div>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <h4><i class="fa fa-cubes"></i> Initial Stock Information</h4>
                    
                    <div id="batchContainer">
                        <div class="batch-entry" data-batch="1" style="border: 1px solid #ddd; padding: 15px; margin-bottom: 15px; border-radius: 5px;">
                            <h5 style="color: #3c8dbc; margin-bottom: 15px;">Batch #1</h5>
                            
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Batch Number <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="batches[1][batch_no]" required>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Quantity <span class="text-danger">*</span></label>
                                        <input type="number" class="form-control" name="batches[1][quantity]" min="1" required>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Purchase Rate</label>
                                        <input type="number" class="form-control" name="batches[1][purchase_rate]" step="0.01" min="0">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Sale Rate <span class="text-danger">*</span></label>
                                        <input type="number" class="form-control" name="batches[1][sale_rate]" step="0.01" min="0" required>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Expiry Date</label>
                                        <input type="date" class="form-control" name="batches[1][expiry]">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Supplier</label>
                                        <input type="text" class="form-control" name="batches[1][supplier]">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Tax (%)</label>
                                        <input type="number" class="form-control" name="batches[1][tax]" step="0.01" min="0" max="100" value="0">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="text-center" style="margin-top: 15px;">
                        <button type="button" class="btn btn-info btn-sm" onclick="addBatch()">
                            <i class="fa fa-plus"></i> Add Another Batch
                        </button>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-success" onclick="saveMedicine()">
                    <i class="fa fa-save"></i> Save Medicine
                </button>
            </div>
        </div>
    </div>
</div>

<style>
.filter-section {
    background: #f9f9f9;
    padding: 15px;
    border-radius: 5px;
    border: 1px solid #ddd;
}

.stock-card {
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    transition: transform 0.2s;
}

.stock-card:hover {
    transform: translateY(-2px);
}

/* Fixed table header styles */
.table thead th {
    background-color: #3c8dbc !important;
    color: white !important;
    font-weight: 600 !important;
    border: 1px solid #3c8dbc !important;
    position: sticky;
    top: 0;
    z-index: 10;
}

.table tbody tr:hover {
    background-color: #f5f5f5;
}

.btn-group .btn {
    margin-right: 2px;
}

.badge {
    font-size: 11px;
}

.label {
    font-size: 11px;
}

/* Ensure table is properly styled */
#medicineStockTable {
    width: 100% !important;
    margin-bottom: 20px;
}

#medicineStockTable thead {
    background-color: #3c8dbc;
}

#medicineStockTable thead th {
    color: white;
    font-weight: 600;
    text-align: center;
    vertical-align: middle;
}

/* DataTables wrapper fixes */
.dataTables_wrapper .dataTables_length {
    float: left;
}

.dataTables_wrapper .dataTables_filter {
    float: right;
}

.dataTables_wrapper .dataTables_info {
    clear: both;
    float: left;
    padding-top: 8px;
}

.dataTables_wrapper .dataTables_paginate {
    float: right;
    text-align: right;
    padding-top: 8px;
}

/* Loading spinner */
.loading-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    display: none;
    z-index: 9999;
}

.loading-spinner {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    color: white;
}

/* Add Medicine Modal Styles */
.batch-entry {
    position: relative;
}

.remove-batch {
    position: absolute;
    top: 10px;
    right: 10px;
    background: #d9534f;
    color: white;
    border: none;
    width: 25px;
    height: 25px;
    border-radius: 50%;
    cursor: pointer;
    font-size: 12px;
}

.remove-batch:hover {
    background: #c9302c;
}

#addMedicineModal .modal-body {
    max-height: 70vh;
    overflow-y: auto;
}
</style>

<script>
// Global variables for add medicine functionality
let batchCounter = 1;

$(document).ready(function() {
    console.log('Medicine stock page loaded');
    console.log('Base URL:', '<?php echo base_url(); ?>');
    
    // Initialize DataTable with proper settings
    if ($.fn.DataTable) {
        var table = $('#medicineStockTable').DataTable({
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
            "pageLength": 25,
            "order": [[1, "asc"]],
            "columnDefs": [
                { "orderable": false, "targets": [7] }, // Disable sorting for actions column
                { "searchable": false, "targets": [0, 7] } // Disable search for # and actions
            ],
            "language": {
                "lengthMenu": "Show _MENU_ entries",
                "zeroRecords": "No medicines found",
                "info": "Showing _START_ to _END_ of _TOTAL_ medicines",
                "infoEmpty": "Showing 0 to 0 of 0 medicines",
                "infoFiltered": "(filtered from _MAX_ total medicines)",
                "search": "Search:",
                "paginate": {
                    "first": "First",
                    "last": "Last",
                    "next": "Next",
                    "previous": "Previous"
                }
            }
        });
        
        console.log('DataTable initialized successfully');
    } else {
        console.error('DataTables library not loaded');
    }
    
    // Filter functionality
    $('#categoryFilter, #stockFilter, #expiryFilter').on('change', function() {
        filterTable();
    });
    
    $('#searchMedicine').on('keyup', function() {
        if ($.fn.DataTable.isDataTable('#medicineStockTable')) {
            var table = $('#medicineStockTable').DataTable();
            table.search(this.value).draw();
        }
    });
});

function filterTable() {
    if (!$.fn.DataTable.isDataTable('#medicineStockTable')) {
        console.error('DataTable not initialized');
        return;
    }
    
    var categoryFilter = $('#categoryFilter').val();
    var stockFilter = $('#stockFilter').val();
    var expiryFilter = $('#expiryFilter').val();
    
    var table = $('#medicineStockTable').DataTable();
    
    // Reset all filters
    table.columns().search('').draw();
    
    // Apply category filter
    if (categoryFilter) {
        table.column(2).search(categoryFilter, false, false);
    }
    
    // Apply stock filter
    if (stockFilter) {
        var searchTerm = '';
        switch(stockFilter) {
            case 'in_stock': searchTerm = 'In Stock'; break;
            case 'low_stock': searchTerm = 'Low Stock'; break;
            case 'out_of_stock': searchTerm = 'Out of Stock'; break;
        }
        table.column(5).search(searchTerm, false, false);
    }
    
    table.draw();
}

// Add Medicine Modal Functions
function showAddMedicineModal() {
    console.log('Opening Add Medicine Modal');
    $('#addMedicineModal').modal('show');
    resetAddMedicineForm();
}

function addBatch() {
    batchCounter++;
    const batchHtml = `
        <div class="batch-entry" data-batch="${batchCounter}" style="border: 1px solid #ddd; padding: 15px; margin-bottom: 15px; border-radius: 5px; position: relative;">
            <button type="button" class="remove-batch" onclick="removeBatch(${batchCounter})" title="Remove Batch">
                <i class="fa fa-times"></i>
            </button>
            <h5 style="color: #3c8dbc; margin-bottom: 15px;">Batch #${batchCounter}</h5>
            
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Batch Number <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="batches[${batchCounter}][batch_no]" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Quantity <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="batches[${batchCounter}][quantity]" min="1" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Purchase Rate</label>
                        <input type="number" class="form-control" name="batches[${batchCounter}][purchase_rate]" step="0.01" min="0">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Sale Rate <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="batches[${batchCounter}][sale_rate]" step="0.01" min="0" required>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Expiry Date</label>
                        <input type="date" class="form-control" name="batches[${batchCounter}][expiry]">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Supplier</label>
                        <input type="text" class="form-control" name="batches[${batchCounter}][supplier]">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Tax (%)</label>
                        <input type="number" class="form-control" name="batches[${batchCounter}][tax]" step="0.01" min="0" max="100" value="0">
                    </div>
                </div>
            </div>
        </div>
    `;
    
    $('#batchContainer').append(batchHtml);
}

function removeBatch(batchNumber) {
    if ($('.batch-entry').length > 1) {
        $(`.batch-entry[data-batch="${batchNumber}"]`).remove();
    } else {
        showAlert('At least one batch is required', 'warning');
    }
}

function saveMedicine() {
    console.log('Saving medicine...');
    
    // Validate required fields
    const medicineName = $('#medicineName').val().trim();
    const medicineCategory = $('#medicineCategory').val();
    const medicineUnit = $('#medicineUnit').val();
    
    if (!medicineName || !medicineCategory || !medicineUnit) {
        showAlert('Please fill in all required fields (Medicine Name, Category, and Unit)', 'danger');
        return;
    }
    
    // Collect batch data
    const batches = {};
    let hasValidBatch = false;
    
    $('.batch-entry').each(function() {
        const batchNum = $(this).data('batch');
        const batchNo = $(`input[name="batches[${batchNum}][batch_no]"]`).val();
        const quantity = $(`input[name="batches[${batchNum}][quantity]"]`).val();
        const saleRate = $(`input[name="batches[${batchNum}][sale_rate]"]`).val();
        
        if (batchNo && quantity && saleRate) {
            hasValidBatch = true;
            batches[batchNum] = {
                batch_no: batchNo,
                quantity: parseInt(quantity),
                purchase_rate: parseFloat($(`input[name="batches[${batchNum}][purchase_rate]"]`).val() || 0),
                sale_rate: parseFloat(saleRate),
                expiry: $(`input[name="batches[${batchNum}][expiry]"]`).val(),
                supplier: $(`input[name="batches[${batchNum}][supplier]"]`).val(),
                tax: parseFloat($(`input[name="batches[${batchNum}][tax]"]`).val() || 0)
            };
        }
    });
    
    if (!hasValidBatch) {
        showAlert('Please add at least one valid batch with batch number, quantity, and sale rate', 'danger');
        return;
    }
    
    // Prepare data for submission
    const medicineData = {
        medicine_name: medicineName,
        medicine_category_id: medicineCategory,
        medicine_company: $('#medicineCompany').val(),
        medicine_composition: $('#medicineComposition').val(),
        medicine_group: $('#medicineGroup').val(),
        unit: medicineUnit,
        unit_packing: $('#unitPacking').val(),
        min_level: parseInt($('#minLevel').val() || 10),
        batches: batches
    };
    
    // Show loading
    showAlert('Saving medicine...', 'info');
    
    // Make AJAX call to save medicine
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/saveMedicine',
        type: 'POST',
        data: medicineData,
        dataType: 'json',
        beforeSend: function() {
            console.log('Sending medicine data:', medicineData);
        },
        success: function(response) {
            console.log('Save medicine response:', response);
            if (response.status === 1) {
                showAlert('Medicine saved successfully!', 'success');
                $('#addMedicineModal').modal('hide');
                resetAddMedicineForm();
                
                // Refresh the page to show new medicine
                setTimeout(function() {
                    location.reload();
                }, 1500);
            } else {
                showAlert('Error: ' + (response.message || 'Failed to save medicine'), 'danger');
            }
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', xhr, status, error);
            console.error('Response text:', xhr.responseText);
            showAlert('Error saving medicine. Please try again.', 'danger');
        }
    });
}

function resetAddMedicineForm() {
    document.getElementById('addMedicineForm').reset();
    $('#batchContainer').html(`
        <div class="batch-entry" data-batch="1" style="border: 1px solid #ddd; padding: 15px; margin-bottom: 15px; border-radius: 5px;">
            <h5 style="color: #3c8dbc; margin-bottom: 15px;">Batch #1</h5>
            
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Batch Number <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="batches[1][batch_no]" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Quantity <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="batches[1][quantity]" min="1" required>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Purchase Rate</label>
                        <input type="number" class="form-control" name="batches[1][purchase_rate]" step="0.01" min="0">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>Sale Rate <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="batches[1][sale_rate]" step="0.01" min="0" required>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Expiry Date</label>
                        <input type="date" class="form-control" name="batches[1][expiry]">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Supplier</label>
                        <input type="text" class="form-control" name="batches[1][supplier]">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Tax (%)</label>
                        <input type="number" class="form-control" name="batches[1][tax]" step="0.01" min="0" max="100" value="0">
                    </div>
                </div>
            </div>
        </div>
    `);
    batchCounter = 1;
}

// Existing functions (keeping your original design)
function viewMedicineDetails(medicineId) {
    console.log('Viewing medicine details for ID:', medicineId);
    
    if (!medicineId) {
        console.error('Medicine ID is required');
        showAlert('Medicine ID is required', 'danger');
        return;
    }
    
    // Show modal first
    $('#medicineDetailsModal').modal('show');
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/getMedicineFullDetails',
        type: 'POST',
        data: { medicine_id: medicineId },
        dataType: 'json',
        beforeSend: function() {
            console.log('Sending AJAX request for medicine details');
            $('#medicineDetailsContent').html('<div class="text-center"><i class="fa fa-spinner fa-spin fa-2x"></i><p>Loading medicine details...</p></div>');
        },
        success: function(response) {
            console.log('Medicine details response:', response);
            if (response.status === 1) {
                $('#medicineDetailsContent').html(response.content);
            } else {
                $('#medicineDetailsContent').html('<div class="alert alert-warning"><i class="fa fa-warning"></i> ' + (response.message || 'Failed to load medicine details') + '</div>');
            }
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', xhr, status, error);
            console.error('Response text:', xhr.responseText);
            $('#medicineDetailsContent').html('<div class="alert alert-danger"><i class="fa fa-error"></i> Error loading medicine details. Please try again.</div>');
        }
    });
}

function adjustStock(medicineId) {
    console.log('Adjusting stock for medicine ID:', medicineId);
    
    if (!medicineId) {
        console.error('Medicine ID is required');
        showAlert('Medicine ID is required', 'danger');
        return;
    }
    
    // Show modal first
    $('#stockAdjustmentModal').modal('show');
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/dispensary/getStockAdjustmentForm',
        type: 'POST',
        data: { medicine_id: medicineId },
        dataType: 'json',
        beforeSend: function() {
            $('#stockAdjustmentContent').html('<div class="text-center"><i class="fa fa-spinner fa-spin fa-2x"></i><p>Loading stock adjustment form...</p></div>');
        },
        success: function(response) {
            console.log('Stock adjustment form response:', response);
            if (response.status === 1) {
                $('#stockAdjustmentContent').html(response.content);
            } else {
                $('#stockAdjustmentContent').html('<div class="alert alert-warning"><i class="fa fa-warning"></i> ' + (response.message || 'Failed to load stock adjustment form') + '</div>');
            }
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', xhr, status, error);
            $('#stockAdjustmentContent').html('<div class="alert alert-danger"><i class="fa fa-error"></i> Error loading stock adjustment form. Please try again.</div>');
        }
    });
}

function quickDispense(medicineId) {
    console.log('Quick dispense for medicine ID:', medicineId);
    
    // Redirect to dispensing page with pre-selected medicine
    window.location.href = '<?php echo base_url(); ?>admin/dispensary/dispensing?medicine_id=' + medicineId;
}

function addStock(medicineId) {
    console.log('Adding stock for medicine ID:', medicineId);
    adjustStock(medicineId);
}

function markExpired(batchId) {
    console.log('Marking batch as expired:', batchId);
    
    if (confirm('Are you sure you want to mark this batch as expired? This action cannot be undone.')) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/dispensary/markBatchExpired',
            type: 'POST',
            data: { batch_id: batchId },
            dataType: 'json',
            success: function(response) {
                if (response.status === 1) {
                    showAlert('Batch marked as expired successfully', 'success');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    showAlert('Failed to mark batch as expired: ' + response.message, 'danger');
                }
            },
            error: function() {
                showAlert('Error marking batch as expired', 'danger');
            }
        });
    }
}

function refreshStock() {
    console.log('Refreshing stock data');
    showAlert('Refreshing stock data...', 'info');
    location.reload();
}

function exportStock() {
    console.log('Exporting stock data');
    window.open('<?php echo base_url(); ?>admin/dispensary/exportStock?format=excel', '_blank');
}

function showAlert(message, type) {
    var alertClass = 'alert-info';
    if (type === 'success') alertClass = 'alert-success';
    else if (type === 'warning') alertClass = 'alert-warning';
    else if (type === 'danger') alertClass = 'alert-danger';
    
    $('#alertBox').removeClass('alert-success alert-warning alert-danger alert-info').addClass(alertClass);
    $('#alertMessage').text(message);
    $('#alertContainer').show();
    
    // Auto-hide after 5 seconds
    setTimeout(function() {
        $('#alertContainer').fadeOut();
    }, 5000);
}

// Debug function to test if buttons are working
function testButton() {
    console.log('Test button clicked!');
    alert('Button is working!');
}
</script>