<?php $currency_symbol = $this->customlib->getHospitalCurrencyFormat(); ?>

<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-medkit"></i> Medical Dispensary Dashboard
            <small>Overview of dispensary operations and key metrics</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Medical Dispensary</li>
        </ol>
    </section>

    <section class="content">
        <!-- Quick Stats Boxes -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3><?php echo $total_medicines; ?></h3>
                        <p>Total Medicines</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-medkit"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/dispensary/medicineStock" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3><?php echo count($low_stock_medicines); ?></h3>
                        <p>Low Stock Alerts</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-exclamation-triangle"></i>
                    </div>
                    <a href="#lowStockModal" data-toggle="modal" class="small-box-footer">
                        View Details <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3><?php echo count($expired_medicines); ?></h3>
                        <p>Expired Medicines</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-calendar-times-o"></i>
                    </div>
                    <a href="#expiredModal" data-toggle="modal" class="small-box-footer">
                        View Details <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3><?php echo $currency_symbol . number_format($todays_sales->total_sales ?: 0, 0); ?></h3>
                        <p>Today's Sales</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-line-chart"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/dispensary/reports" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Quick Actions Row -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-bolt"></i> Quick Actions</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-3">
                                <a href="<?php echo base_url(); ?>admin/dispensary/dispensing" class="btn btn-primary btn-lg btn-block">
                                    <i class="fa fa-file-text-o"></i><br>
                                    <span>New Dispensing</span><br>
                                    <small>Process medicine dispensing</small>
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="<?php echo base_url(); ?>admin/dispensary/medicineStock" class="btn btn-success btn-lg btn-block">
                                    <i class="fa fa-cubes"></i><br>
                                    <span>Medicine Stock</span><br>
                                    <small>View and manage inventory</small>
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="<?php echo base_url(); ?>admin/patient/search" class="btn btn-info btn-lg btn-block">
                                    <i class="fa fa-search"></i><br>
                                    <span>Find Patient</span><br>
                                    <small>Search patient records</small>
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="<?php echo base_url(); ?>admin/dispensary/reports" class="btn btn-warning btn-lg btn-block">
                                    <i class="fa fa-bar-chart"></i><br>
                                    <span>Reports</span><br>
                                    <small>View analytics & reports</small>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Today's Sales Summary -->
            <div class="col-md-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-shopping-cart"></i> Today's Sales Summary</h3>
                        <div class="box-tools pull-right">
                            <span class="label label-primary"><?php echo date('d M Y'); ?></span>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="info-box bg-blue">
                                    <span class="info-box-icon"><i class="fa fa-file-text"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Total Bills</span>
                                        <span class="info-box-number"><?php echo $todays_sales->total_bills ?: 0; ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-box bg-green">
                                    <span class="info-box-icon"><i class="fa fa-money"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Total Revenue</span>
                                        <span class="info-box-number"><?php echo $currency_symbol . number_format($todays_sales->total_sales ?: 0, 2); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <?php if ($pending_bills->count > 0): ?>
                            <div class="alert alert-warning">
                                <h4><i class="fa fa-exclamation-triangle"></i> Pending Bills</h4>
                                You have <strong><?php echo $pending_bills->count; ?></strong> pending bills 
                                worth <strong><?php echo $currency_symbol . number_format($pending_bills->total_balance, 2); ?></strong>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Recent Transactions -->
            <div class="col-md-6">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-history"></i> Recent Transactions</h3>
                        <div class="box-tools pull-right">
                            <a href="<?php echo base_url(); ?>admin/dispensary/reports" class="btn btn-sm btn-default">
                                View All
                            </a>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($recent_transactions)): ?>
                            <div class="table-responsive" style="max-height: 300px; overflow-y: auto;">
                                <table class="table table-striped table-condensed">
                                    <thead>
                                        <tr>
                                            <th>Bill No</th>
                                            <th>Patient</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($recent_transactions as $transaction): ?>
                                            <tr>
                                                <td>
                                                    <strong><?php echo $transaction->bill_no; ?></strong><br>
                                                    <small><?php echo date('d/m H:i', strtotime($transaction->bill_date)); ?></small>
                                                </td>
                                                <td>
                                                    <?php echo $transaction->patient_name ?: 'Walk-in'; ?><br>
                                                    <small class="text-muted"><?php echo $transaction->patient_unique_id ?: 'N/A'; ?></small>
                                                </td>
                                                <td class="text-right">
                                                    <?php echo $currency_symbol . number_format($transaction->net_amount, 2); ?>
                                                </td>
                                                <td>
                                                    <?php
                                                    $status_class = $transaction->status == 'paid' ? 'label-success' : 
                                                                   ($transaction->status == 'pending' ? 'label-warning' : 'label-default');
                                                    ?>
                                                    <span class="label <?php echo $status_class; ?>">
                                                        <?php echo ucfirst($transaction->status); ?>
                                                    </span>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="callout callout-info">
                                <h4>No Recent Transactions</h4>
                                <p>No dispensing transactions found for today.</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Critical Alerts Row -->
        <?php if (!empty($low_stock_medicines) || !empty($expired_medicines)): ?>
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-danger">
                        <div class="box-header with-border">
                            <h3 class="box-title"><i class="fa fa-warning"></i> Critical Alerts</h3>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <?php if (!empty($low_stock_medicines)): ?>
                                    <div class="col-md-6">
                                        <div class="alert alert-warning">
                                            <h4><i class="fa fa-exclamation-triangle"></i> Low Stock Alert</h4>
                                            <p>The following medicines are running low on stock:</p>
                                            <ul>
                                                <?php foreach (array_slice($low_stock_medicines, 0, 5) as $medicine): ?>
                                                    <li>
                                                        <strong><?php echo $medicine->medicine_name; ?></strong> 
                                                        - <?php echo $medicine->total_stock ?: 0; ?> units remaining
                                                    </li>
                                                <?php endforeach; ?>
                                                <?php if (count($low_stock_medicines) > 5): ?>
                                                    <li><em>...and <?php echo count($low_stock_medicines) - 5; ?> more</em></li>
                                                <?php endif; ?>
                                            </ul>
                                            <button class="btn btn-warning btn-sm" data-toggle="modal" data-target="#lowStockModal">
                                                View All Low Stock Items
                                            </button>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($expired_medicines)): ?>
                                    <div class="col-md-6">
                                        <div class="alert alert-danger">
                                            <h4><i class="fa fa-calendar-times-o"></i> Expired Medicines</h4>
                                            <p>The following medicines have expired:</p>
                                            <ul>
                                                <?php foreach (array_slice($expired_medicines, 0, 5) as $medicine): ?>
                                                    <li>
                                                        <strong><?php echo $medicine->medicine_name; ?></strong> 
                                                        - Expired on <?php echo date('d/m/Y', strtotime($medicine->expiry)); ?>
                                                    </li>
                                                <?php endforeach; ?>
                                                <?php if (count($expired_medicines) > 5): ?>
                                                    <li><em>...and <?php echo count($expired_medicines) - 5; ?> more</em></li>
                                                <?php endif; ?>
                                            </ul>
                                            <button class="btn btn-danger btn-sm" data-toggle="modal" data-target="#expiredModal">
                                                View All Expired Items
                                            </button>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </section>
</div>

<!-- Low Stock Modal -->
<div class="modal fade" id="lowStockModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-yellow">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-exclamation-triangle"></i> Low Stock Medicines
                </h4>
            </div>
            <div class="modal-body">
                <?php if (!empty($low_stock_medicines)): ?>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Medicine Name</th>
                                    <th>Company</th>
                                    <th>Current Stock</th>
                                    <th>Batches</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($low_stock_medicines as $medicine): ?>
                                    <tr>
                                        <td><strong><?php echo $medicine->medicine_name; ?></strong></td>
                                        <td><?php echo $medicine->medicine_company ?: 'N/A'; ?></td>
                                        <td>
                                            <span class="label label-warning">
                                                <?php echo $medicine->total_stock ?: 0; ?> units
                                            </span>
                                        </td>
                                        <td><?php echo $medicine->batch_count ?: 0; ?> batches</td>
                                        <td>
                                            <a href="<?php echo base_url(); ?>admin/dispensary/medicineStock" 
                                               class="btn btn-xs btn-primary">
                                                <i class="fa fa-eye"></i> View Details
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="callout callout-success">
                        <h4>All Good!</h4>
                        <p>No medicines are currently running low on stock.</p>
                    </div>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <a href="<?php echo base_url(); ?>admin/dispensary/medicineStock" class="btn btn-primary">
                    Manage Stock
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Expired Medicines Modal -->
<div class="modal fade" id="expiredModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-red">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-calendar-times-o"></i> Expired Medicines
                </h4>
            </div>
            <div class="modal-body">
                <?php if (!empty($expired_medicines)): ?>
                    <div class="alert alert-danger">
                        <strong>Warning:</strong> These medicines have expired and should be removed from dispensing inventory immediately.
                    </div>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Medicine Name</th>
                                    <th>Company</th>
                                    <th>Batch No</th>
                                    <th>Expiry Date</th>
                                    <th>Remaining Stock</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($expired_medicines as $medicine): ?>
                                    <tr>
                                        <td><strong><?php echo $medicine->medicine_name; ?></strong></td>
                                        <td><?php echo $medicine->medicine_company ?: 'N/A'; ?></td>
                                        <td><?php echo $medicine->batch_no; ?></td>
                                        <td>
                                            <span class="label label-danger">
                                                <?php echo date('d/m/Y', strtotime($medicine->expiry)); ?>
                                            </span>
                                        </td>
                                        <td><?php echo $medicine->available_quantity; ?> units</td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="callout callout-success">
                        <h4>All Good!</h4>
                        <p>No expired medicines found in current inventory.</p>
                    </div>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <a href="<?php echo base_url(); ?>admin/dispensary/medicineStock" class="btn btn-danger">
                    Manage Expired Stock
                </a>
            </div>
        </div>
    </div>
</div>

<style>
/* Dashboard specific styles */
.small-box {
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    transition: transform 0.3s ease;
}

.small-box:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}

.info-box {
    border-radius: 6px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.btn-lg {
    border-radius: 8px;
    padding: 15px;
    text-align: center;
    transition: all 0.3s ease;
}

.btn-lg:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}

.box {
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.box-header {
    border-bottom: 1px solid #f4f4f4;
    border-radius: 8px 8px 0 0;
}

.alert {
    border-radius: 6px;
    border: none;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.table-responsive {
    border-radius: 6px;
}

.modal-content {
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

.modal-header.bg-yellow {
    background-color: #f39c12;
    color: white;
    border-radius: 8px 8px 0 0;
}

.modal-header.bg-red {
    background-color: #dd4b39;
    color: white;
    border-radius: 8px 8px 0 0;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .btn-lg {
        padding: 10px;
        font-size: 12px;
    }
    
    .btn-lg i {
        font-size: 20px;
        margin-bottom: 5px;
    }
    
    .small-box .inner h3 {
        font-size: 24px;
    }
    
    .info-box-number {
        font-size: 14px;
    }
}
</style>

<script>
$(document).ready(function() {
    // Auto-refresh dashboard every 5 minutes
    setInterval(function() {
        location.reload();
    }, 300000); // 5 minutes
    
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    // Smooth scrolling for anchor links
    $('a[href^="#"]').on('click', function(event) {
        var target = $(this.getAttribute('href'));
        if (target.length) {
            event.preventDefault();
            $('html, body').stop().animate({
                scrollTop: target.offset().top - 70
            }, 1000);
        }
    });
});

// Function to show notifications for critical alerts
function checkCriticalAlerts() {
    <?php if (!empty($low_stock_medicines)): ?>
        toastr.warning('<?php echo count($low_stock_medicines); ?> medicines are running low on stock!', 'Low Stock Alert');
    <?php endif; ?>
    
    <?php if (!empty($expired_medicines)): ?>
        toastr.error('<?php echo count($expired_medicines); ?> medicines have expired!', 'Expired Medicines');
    <?php endif; ?>
}

// Call function on page load
$(document).ready(function() {
    // Delay to ensure page is fully loaded
    setTimeout(checkCriticalAlerts, 2000);
});
</script>