<!DOCTYPE html>
<html>
<head>
    <title>Pharmacy Bill Receipt - <?php echo $bill->bill_no; ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            font-size: 14px;
            line-height: 1.4;
        }
        
        .receipt-container {
            max-width: 800px;
            margin: 0 auto;
            border: 1px solid #ddd;
            padding: 20px;
        }
        
        .header {
            text-align: center;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        
        .hospital-name {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 5px;
            color: #2c3e50;
        }
        
        .hospital-address {
            font-size: 12px;
            color: #666;
            margin-bottom: 10px;
        }
        
        .receipt-title {
            font-size: 18px;
            font-weight: bold;
            background: #f8f9fa;
            padding: 8px;
            border: 1px solid #ddd;
            margin-top: 10px;
        }
        
        .bill-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
            border-bottom: 1px solid #eee;
            padding-bottom: 15px;
        }
        
        .bill-info-left, .bill-info-right {
            flex: 1;
        }
        
        .customer-info {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        
        .customer-type-badge {
            display: inline-block;
            padding: 3px 8px;
            border-radius: 12px;
            font-size: 11px;
            font-weight: bold;
            text-transform: uppercase;
            margin-left: 10px;
        }
        
        .walkin-badge {
            background: #28a745;
            color: white;
        }
        
        .registered-badge {
            background: #007bff;
            color: white;
        }
        
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        .items-table th,
        .items-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        
        .items-table th {
            background: #f8f9fa;
            font-weight: bold;
        }
        
        .items-table .text-right {
            text-align: right;
        }
        
        .items-table .text-center {
            text-align: center;
        }
        
        .totals-section {
            float: right;
            width: 300px;
            margin-top: 10px;
        }
        
        .totals-table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .totals-table td {
            padding: 8px;
            border-bottom: 1px solid #eee;
        }
        
        .totals-table .total-row {
            font-weight: bold;
            font-size: 16px;
            background: #f8f9fa;
            border-top: 2px solid #333;
        }
        
        .payment-info {
            clear: both;
            margin-top: 20px;
            padding-top: 15px;
            border-top: 1px solid #eee;
        }
        
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #ddd;
            font-size: 12px;
            color: #666;
        }
        
        .print-only {
            display: none;
        }
        
        @media print {
            body {
                margin: 0;
                padding: 10px;
                font-size: 12px;
            }
            
            .receipt-container {
                border: none;
                padding: 0;
                max-width: none;
            }
            
            .print-only {
                display: block;
            }
            
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <!-- Header -->
        <div class="header">
            <div class="hospital-name">
                <?php echo $hospital_name ?? 'Medical Center'; ?>
            </div>
            <div class="hospital-address">
                <?php echo $hospital_address ?? 'Hospital Address'; ?>
            </div>
            <div class="receipt-title">
                PHARMACY BILL RECEIPT
            </div>
        </div>

        <!-- Bill Information -->
        <div class="bill-info">
            <div class="bill-info-left">
                <strong>Bill No:</strong> <?php echo $bill->bill_no ?? 'N/A'; ?><br>
                <strong>Date:</strong> <?php echo date('d M Y, h:i A', strtotime($bill->date)); ?><br>
                <strong>Cashier:</strong> <?php echo $bill->generated_by_name ?? 'System'; ?>
            </div>
            <div class="bill-info-right">
                <strong>Payment Method:</strong> <?php echo ucfirst($bill->payment_method ?? 'Cash'); ?><br>
                <strong>Status:</strong> <span style="color: green;">PAID</span><br>
                <strong>Print Time:</strong> <?php echo date('d M Y, h:i A'); ?>
            </div>
        </div>

        <!-- Customer Information -->
        <div class="customer-info">
            <h4 style="margin-top: 0;">
                Customer Information
                <span class="customer-type-badge <?php echo $customer_type === 'walkin' ? 'walkin-badge' : 'registered-badge'; ?>">
                    <?php echo $customer_type === 'walkin' ? 'Walk-in' : 'Registered'; ?>
                </span>
            </h4>
            
            <div style="display: flex; justify-content: space-between;">
                <div>
                    <strong>Name:</strong> <?php echo $customer_name; ?><br>
                    <strong>ID:</strong> <?php echo $customer_id; ?><br>
                    <strong>Phone:</strong> <?php echo $customer_phone; ?>
                </div>
                
                <?php if ($customer_type === 'walkin' && !empty($bill->customer_age)): ?>
                <div>
                    <strong>Age:</strong> <?php echo $bill->customer_age; ?> years<br>
                    <?php if (!empty($bill->customer_gender)): ?>
                    <strong>Gender:</strong> <?php echo $bill->customer_gender; ?><br>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Items Table -->
        <table class="items-table">
            <thead>
                <tr>
                    <th width="5%">#</th>
                    <th width="35%">Medicine Details</th>
                    <th width="15%">Batch/Expiry</th>
                    <th width="10%">Qty</th>
                    <th width="15%">Unit Price</th>
                    <th width="20%">Amount</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($bill_items)): ?>
                    <?php foreach ($bill_items as $index => $item): ?>
                    <tr>
                        <td class="text-center"><?php echo $index + 1; ?></td>
                        <td>
                            <strong><?php echo $item->medicine_name; ?></strong>
                            <?php if (!empty($item->medicine_category)): ?>
                                <br><small style="color: #666;"><?php echo $item->medicine_category; ?></small>
                            <?php endif; ?>
                        </td>
                        <td>
                            <strong>Batch:</strong> <?php echo $item->batch_no ?? 'N/A'; ?><br>
                            <strong>Expiry:</strong> <?php echo date('M Y', strtotime($item->expiry ?? 'now')); ?>
                        </td>
                        <td class="text-center"><?php echo $item->quantity; ?></td>
                        <td class="text-right"><?php echo $currency_symbol . number_format($item->sale_price, 2); ?></td>
                        <td class="text-right"><?php echo $currency_symbol . number_format($item->amount, 2); ?></td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" class="text-center" style="color: #999; padding: 20px;">
                            No items found
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <!-- Totals Section -->
        <div class="totals-section">
            <table class="totals-table">
                <tr>
                    <td><strong>Subtotal:</strong></td>
                    <td class="text-right"><?php echo $currency_symbol . number_format($bill->total ?? 0, 2); ?></td>
                </tr>
                
                <?php if ($bill->discount > 0): ?>
                <tr>
                    <td>Discount (<?php echo number_format($bill->discount_percentage ?? 0, 1); ?>%):</td>
                    <td class="text-right" style="color: green;">-<?php echo $currency_symbol . number_format($bill->discount, 2); ?></td>
                </tr>
                <?php endif; ?>
                
                <?php if ($bill->tax > 0): ?>
                <tr>
                    <td>Tax (<?php echo number_format($bill->tax_percentage ?? 0, 1); ?>%):</td>
                    <td class="text-right"><?php echo $currency_symbol . number_format($bill->tax, 2); ?></td>
                </tr>
                <?php endif; ?>
                
                <tr class="total-row">
                    <td><strong>NET AMOUNT:</strong></td>
                    <td class="text-right"><strong><?php echo $currency_symbol . number_format($bill->net_amount, 2); ?></strong></td>
                </tr>
            </table>
        </div>

        <!-- Payment Information -->
        <div class="payment-info">
            <div style="display: flex; justify-content: space-between;">
                <div>
                    <strong>Payment Method:</strong> <?php echo ucfirst($bill->payment_method ?? 'cash'); ?><br>
                    <strong>Amount Paid:</strong> <?php echo $currency_symbol . number_format($bill->amount_paid ?? $bill->net_amount, 2); ?>
                </div>
                <div>
                    <?php
                    $balance = ($bill->balance_amount ?? 0);
                    if ($balance > 0): ?>
                        <strong>Change Given:</strong> <?php echo $currency_symbol . number_format($balance, 2); ?>
                    <?php elseif ($balance < 0): ?>
                        <strong>Balance Due:</strong> <?php echo $currency_symbol . number_format(abs($balance), 2); ?>
                    <?php else: ?>
                        <strong>Exact Payment</strong>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Notes Section -->
        <?php if (!empty($bill->note)): ?>
        <div style="margin-top: 20px; padding: 10px; background: #fff3cd; border: 1px solid #ffeaa7; border-radius: 4px;">
            <strong>Notes:</strong> <?php echo htmlspecialchars($bill->note); ?>
        </div>
        <?php endif; ?>

        <!-- Footer -->
        <div class="footer">
            <div style="margin-bottom: 10px;">
                <strong>Thank you for your business!</strong>
            </div>
            
            <div style="font-size: 11px; color: #888;">
                <?php if ($customer_type === 'registered'): ?>
                    • Keep this receipt for warranty and returns<br>
                    • Contact us for any prescription refills or queries<br>
                <?php else: ?>
                    • Keep this receipt for returns and warranty claims<br>
                    • For prescription refills, please bring your prescription<br>
                <?php endif; ?>
                • All sales are final unless otherwise specified
            </div>
            
            <div style="margin-top: 15px; font-size: 10px; color: #aaa;">
                Generated by Hospital Management System - <?php echo date('Y'); ?>
            </div>
        </div>

        <!-- Print Instructions (visible on screen only) -->
        <div class="no-print" style="text-align: center; margin-top: 20px; padding: 15px; background: #e9ecef; border-radius: 5px;">
            <button onclick="window.print()" style="background: #007bff; color: white; border: none; padding: 10px 20px; border-radius: 4px; cursor: pointer; margin-right: 10px;">
                <i class="fa fa-print"></i> Print Receipt
            </button>
            <button onclick="window.close()" style="background: #6c757d; color: white; border: none; padding: 10px 20px; border-radius: 4px; cursor: pointer;">
                Close Window
            </button>
        </div>

        <!-- Print-only duplicate notice -->
        <div class="print-only" style="page-break-before: always;">
            <div style="text-align: center; font-size: 14px; margin-bottom: 20px; padding: 10px; border: 2px dashed #999;">
                <strong>CUSTOMER COPY</strong><br>
                <small>Keep this copy for your records</small>
            </div>
            
            <!-- Repeat the entire receipt content for customer copy -->
            <div style="font-size: 11px;">
                <div style="text-align: center; margin-bottom: 15px;">
                    <div style="font-size: 18px; font-weight: bold;"><?php echo $hospital_name ?? 'Medical Center'; ?></div>
                    <div><?php echo $hospital_address ?? 'Hospital Address'; ?></div>
                    <div style="margin-top: 8px; font-weight: bold;">PHARMACY RECEIPT</div>
                </div>
                
                <div style="margin-bottom: 15px;">
                    <strong>Bill:</strong> <?php echo $bill->bill_no ?? 'N/A'; ?> | 
                    <strong>Date:</strong> <?php echo date('d M Y', strtotime($bill->date)); ?> | 
                    <strong>Customer:</strong> <?php echo $customer_name; ?>
                    <span style="margin-left: 10px; padding: 2px 6px; background: <?php echo $customer_type === 'walkin' ? '#28a745' : '#007bff'; ?>; color: white; border-radius: 8px; font-size: 9px;">
                        <?php echo strtoupper($customer_type); ?>
                    </span>
                </div>
                
                <table style="width: 100%; border-collapse: collapse; font-size: 10px; margin-bottom: 10px;">
                    <thead>
                        <tr style="background: #f0f0f0;">
                            <th style="border: 1px solid #ddd; padding: 4px; text-align: left;">Medicine</th>
                            <th style="border: 1px solid #ddd; padding: 4px; text-align: center;">Qty</th>
                            <th style="border: 1px solid #ddd; padding: 4px; text-align: right;">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($bill_items)): ?>
                            <?php foreach ($bill_items as $item): ?>
                            <tr>
                                <td style="border: 1px solid #ddd; padding: 4px;"><?php echo $item->medicine_name; ?></td>
                                <td style="border: 1px solid #ddd; padding: 4px; text-align: center;"><?php echo $item->quantity; ?></td>
                                <td style="border: 1px solid #ddd; padding: 4px; text-align: right;"><?php echo $currency_symbol . number_format($item->amount, 2); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
                
                <div style="text-align: right; margin-bottom: 10px;">
                    <?php if ($bill->discount > 0): ?>
                        <div>Subtotal: <?php echo $currency_symbol . number_format($bill->total, 2); ?></div>
                        <div>Discount: -<?php echo $currency_symbol . number_format($bill->discount, 2); ?></div>
                    <?php endif; ?>
                    <?php if ($bill->tax > 0): ?>
                        <div>Tax: <?php echo $currency_symbol . number_format($bill->tax, 2); ?></div>
                    <?php endif; ?>
                    <div style="font-weight: bold; font-size: 12px; border-top: 1px solid #000; padding-top: 3px;">
                        Total: <?php echo $currency_symbol . number_format($bill->net_amount, 2); ?>
                    </div>
                </div>
                
                <div style="text-align: center; font-size: 9px; color: #666;">
                    Thank you for your business!<br>
                    <?php echo date('d M Y, h:i A'); ?>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Auto-print when page loads (optional)
        // window.onload = function() { window.print(); }
        
        // Print function
        function printReceipt() {
            window.print();
        }
        
        // Close function
        function closeWindow() {
            window.close();
        }
    </script>
</body>
</html>