<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-share"></i> Release Consumables to Department
            <small>Issue consumables from main store to departments</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/consumable">Consumable Store</a></li>
            <li class="active">Release to Department</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { ?>
            <div class="row">
                <div class="col-md-12">
                    <?php echo $this->session->flashdata('msg'); ?>
                </div>
            </div>
        <?php } ?>

        <!-- Form validation errors -->
        <?php if (validation_errors()) { ?>
            <div class="row">
                <div class="col-md-12">
                    <div class="alert alert-danger">
                        <i class="fa fa-exclamation-triangle"></i>
                        <strong>Please correct the following errors:</strong>
                        <?php echo validation_errors(); ?>
                    </div>
                </div>
            </div>
        <?php } ?>
        
        <!-- Release Form -->
        <div class="row">
            <div class="col-md-8">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-edit"></i> Release Details</h3>
                        <div class="box-tools pull-right">
                            <span class="label label-primary">Step 1: Select Items</span>
                        </div>
                    </div>
                    <form action="<?php echo current_url(); ?>" method="post" id="releaseForm">
                        <div class="box-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="department_id">Department <span class="text-danger">*</span></label>
                                        <select name="department_id" id="department_id" class="form-control" required>
                                            <option value="">Select Department</option>
                                            <?php foreach ($departments as $department) { ?>
                                                <option value="<?php echo $department->id; ?>" 
                                                        <?php echo (set_value('department_id') == $department->id) ? 'selected' : ''; ?>
                                                        <?php echo ($this->input->get('department_id') == $department->id) ? 'selected' : ''; ?>>
                                                    <?php echo $department->department_name; ?>
                                                </option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="consumable_id">Consumable <span class="text-danger">*</span></label>
                                        <select name="consumable_id" id="consumable_id" class="form-control" required>
                                            <option value="">Select Consumable</option>
                                            <?php foreach ($consumables as $consumable) { ?>
                                                <option value="<?php echo $consumable->id; ?>" 
                                                        data-stock="<?php echo $consumable->current_stock; ?>"
                                                        data-unit="<?php echo $consumable->unit_of_measure; ?>"
                                                        data-cost="<?php echo $consumable->unit_cost; ?>"
                                                        <?php echo (set_value('consumable_id') == $consumable->id) ? 'selected' : ''; ?>
                                                        <?php echo ($this->input->get('consumable_id') == $consumable->id) ? 'selected' : ''; ?>>
                                                    <?php echo $consumable->consumable_name; ?> 
                                                    (<?php echo $consumable->consumable_code; ?>) - 
                                                    Stock: <?php echo $consumable->current_stock; ?> <?php echo $consumable->unit_of_measure; ?>
                                                </option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="quantity">Quantity to Release <span class="text-danger">*</span></label>
                                        <input type="number" name="quantity" id="quantity" 
                                               class="form-control" min="1" placeholder="0" 
                                               value="<?php echo set_value('quantity'); ?>" required>
                                        <small class="text-muted" id="unit_display">units</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Available Stock</label>
                                        <div class="form-control" style="background-color: #f4f4f4;" id="available_stock_display">
                                            Select consumable first
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Total Value (KES)</label>
                                        <div class="form-control" style="background-color: #f4f4f4;" id="total_value_display">
                                            0.00
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="notes">Notes / Reason for Release</label>
                                        <textarea name="notes" id="notes" class="form-control" rows="3" 
                                                  placeholder="Optional notes about this release (e.g., emergency requirement, routine restocking)"><?php echo set_value('notes'); ?></textarea>
                                    </div>
                                </div>
                            </div>

                            <!-- Stock Alert -->
                            <div class="alert alert-info" id="stock_alert" style="display: none;">
                                <i class="fa fa-info-circle"></i>
                                <span id="stock_alert_message"></span>
                            </div>

                            <!-- Low Stock Warning -->
                            <div class="alert alert-warning" id="low_stock_warning" style="display: none;">
                                <i class="fa fa-exclamation-triangle"></i>
                                <strong>Low Stock Warning:</strong> 
                                <span id="low_stock_message"></span>
                            </div>

                            <!-- Insufficient Stock Error -->
                            <div class="alert alert-danger" id="insufficient_stock_error" style="display: none;">
                                <i class="fa fa-times-circle"></i>
                                <strong>Insufficient Stock:</strong> 
                                <span id="insufficient_stock_message"></span>
                            </div>
                        </div>

                        <div class="box-footer">
                            <div class="row">
                                <div class="col-md-6">
                                    <a href="<?php echo base_url(); ?>admin/consumable/department_stock" class="btn btn-default">
                                        <i class="fa fa-arrow-left"></i> Back to Department Stock
                                    </a>
                                </div>
                                <div class="col-md-6 text-right">
                                    <button type="button" class="btn btn-warning" onclick="resetForm()">
                                        <i class="fa fa-refresh"></i> Reset
                                    </button>
                                    <button type="submit" class="btn btn-success" id="releaseButton">
                                        <i class="fa fa-share"></i> Release to Department
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Quick Reference Panel -->
            <div class="col-md-4">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-info-circle"></i> Release Guidelines</h3>
                    </div>
                    <div class="box-body">
                        <div class="callout callout-info">
                            <h5><i class="fa fa-lightbulb-o"></i> Quick Tips:</h5>
                            <ul class="list-unstyled">
                                <li><i class="fa fa-check text-green"></i> Check department requirements before releasing</li>
                                <li><i class="fa fa-check text-green"></i> Verify expiry dates for medical items</li>
                                <li><i class="fa fa-check text-green"></i> Document the reason for release</li>
                                <li><i class="fa fa-check text-green"></i> Consider department storage capacity</li>
                            </ul>
                        </div>

                        <div class="callout callout-warning">
                            <h5><i class="fa fa-exclamation-triangle"></i> Important Notes:</h5>
                            <ul class="list-unstyled">
                                <li><i class="fa fa-arrow-right text-orange"></i> Released items cannot be returned to main stock automatically</li>
                                <li><i class="fa fa-arrow-right text-orange"></i> Department will be responsible for the items</li>
                                <li><i class="fa fa-arrow-right text-orange"></i> Transaction will be recorded for audit</li>
                            </ul>
                        </div>

                        <div class="info-box bg-green" id="selected_item_info" style="display: none;">
                            <span class="info-box-icon"><i class="fa fa-cube"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text" id="item_name">Item Name</span>
                                <span class="info-box-number" id="item_stock">0</span>
                                <div class="progress">
                                    <div class="progress-bar" id="stock_progress" style="width: 0%"></div>
                                </div>
                                <span class="progress-description" id="stock_status">Stock Status</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Recent Releases -->
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-history"></i> Recent Releases</h3>
                    </div>
                    <div class="box-body" style="max-height: 300px; overflow-y: auto;">
                        <div class="text-center text-muted">
                            <i class="fa fa-info-circle"></i>
                            <p>Recent releases will be shown here</p>