<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-building"></i> Department Stock Management
            <small>Monitor and manage departmental consumable inventory</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/consumable">Consumable Store</a></li>
            <li class="active">Department Stock</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { ?>
            <div class="row">
                <div class="col-md-12">
                    <?php echo $this->session->flashdata('msg'); ?>
                </div>
            </div>
        <?php } ?>

        <!-- Department Selection -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-filter"></i> Select Department</h3>
                        <div class="box-tools pull-right">
                            <a href="<?php echo base_url(); ?>admin/consumable/release_to_department" class="btn btn-success btn-sm">
                                <i class="fa fa-share"></i> Release Items
                            </a>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="department_selector">Choose Department:</label>
                                    <select id="department_selector" class="form-control">
                                        <option value="">Select a department to view stock...</option>
                                        <?php foreach ($departments as $dept) { ?>
                                            <option value="<?php echo $dept->id; ?>" 
                                                    <?php echo (isset($selected_department) && $selected_department == $dept->id) ? 'selected' : ''; ?>>
                                                <?php echo $dept->department_name; ?>
                                            </option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="row">
                                    <?php foreach (array_slice($departments, 0, 4) as $dept) { ?>
                                        <div class="col-md-3">
                                            <a href="<?php echo base_url(); ?>admin/consumable/department_stock/<?php echo $dept->id; ?>" 
                                               class="btn btn-default btn-block <?php echo (isset($selected_department) && $selected_department == $dept->id) ? 'btn-primary' : ''; ?>">
                                                <i class="fa fa-building"></i><br>
                                                <?php echo $dept->department_name; ?>
                                            </a>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php if (isset($selected_department) && isset($department_stock)) { ?>
            <!-- Department Information -->
            <div class="row">
                <div class="col-md-8">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">
                                <i class="fa fa-info-circle"></i> 
                                <?php echo $department_info->department_name; ?> - Stock Overview
                            </h3>
                            <div class="box-tools pull-right">
                                <span class="label label-info">
                                    <?php echo count($department_stock); ?> items in stock
                                </span>
                            </div>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="info-box bg-aqua">
                                        <span class="info-box-icon"><i class="fa fa-cubes"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Total Items</span>
                                            <span class="info-box-number"><?php echo count($department_stock); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box bg-green">
                                        <span class="info-box-icon"><i class="fa fa-money"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Total Value</span>
                                            <span class="info-box-number">
                                                <?php 
                                                $total_value = 0;
                                                foreach ($department_stock as $stock) {
                                                    $total_value += $stock->dept_stock_value;
                                                }
                                                echo 'KES ' . number_format($total_value, 0);
                                                ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box bg-yellow">
                                        <span class="info-box-icon"><i class="fa fa-exclamation-triangle"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Low Stock</span>
                                            <span class="info-box-number">
                                                <?php 
                                                $low_stock_count = 0;
                                                foreach ($department_stock as $stock) {
                                                    if ($stock->dept_stock_status == 'Low Stock') {
                                                        $low_stock_count++;
                                                    }
                                                }
                                                echo $low_stock_count;
                                                ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box bg-red">
                                        <span class="info-box-icon"><i class="fa fa-times-circle"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Out of Stock</span>
                                            <span class="info-box-number">
                                                <?php 
                                                $out_of_stock_count = 0;
                                                foreach ($department_stock as $stock) {
                                                    if ($stock->dept_stock_status == 'Out of Stock') {
                                                        $out_of_stock_count++;
                                                    }
                                                }
                                                echo $out_of_stock_count;
                                                ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="col-md-4">
                    <div class="box box-success">
                        <div class="box-header with-border">
                            <h3 class="box-title"><i class="fa fa-flash"></i> Quick Actions</h3>
                        </div>
                        <div class="box-body">
                            <a href="<?php echo base_url(); ?>admin/consumable/release_to_department?department_id=<?php echo $selected_department; ?>" 
                               class="btn btn-primary btn-block btn-lg">
                                <i class="fa fa-share"></i> Release Items to Department
                            </a>
                            <a href="<?php echo base_url(); ?>admin/consumable/create_requisition?department_id=<?php echo $selected_department; ?>" 
                               class="btn btn-warning btn-block btn-lg">
                                <i class="fa fa-file-text"></i> Create Requisition
                            </a>
                            <a href="<?php echo base_url(); ?>admin/consumable/transactions?department_id=<?php echo $selected_department; ?>" 
                               class="btn btn-info btn-block btn-lg">
                                <i class="fa fa-exchange"></i> View Transactions
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Department Stock Table -->
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-default">
                        <div class="box-header with-border">
                            <h3 class="box-title">
                                <i class="fa fa-list"></i> Stock Items - <?php echo $department_info->department_name; ?>
                            </h3>
                            <div class="box-tools pull-right">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                                        <i class="fa fa-filter"></i> Filter <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a href="#" onclick="filterStock('all')">All Items</a></li>
                                        <li><a href="#" onclick="filterStock('normal')">Normal Stock</a></li>
                                        <li><a href="#" onclick="filterStock('low')">Low Stock</a></li>
                                        <li><a href="#" onclick="filterStock('out')">Out of Stock</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="box-body">
                            <?php if (!empty($department_stock)) { ?>
                                <div class="table-responsive">
                                    <table class="table table-striped table-bordered" id="departmentStockTable">
                                        <thead>
                                            <tr>
                                                <th>Item</th>
                                                <th>Category</th>
                                                <th>Current Stock</th>
                                                <th>Min Stock</th>
                                                <th>Status</th>
                                                <th>Unit Cost</th>
                                                <th>Total Value</th>
                                                <th>Last Restocked</th>
                                                <th width="120">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($department_stock as $stock) { 
                                                // Determine status styling
                                                $status_class = 'label-success';
                                                $stock_class = 'text-success';
                                                $icon = 'fa-check-circle';
                                                
                                                if ($stock->dept_stock_status == 'Out of Stock') {
                                                    $status_class = 'label-danger';
                                                    $stock_class = 'text-danger';
                                                    $icon = 'fa-times-circle';
                                                } elseif ($stock->dept_stock_status == 'Low Stock') {
                                                    $status_class = 'label-warning';
                                                    $stock_class = 'text-warning';
                                                    $icon = 'fa-exclamation-triangle';
                                                }
                                            ?>
                                                <tr data-status="<?php echo strtolower(str_replace(' ', '', $stock->dept_stock_status)); ?>">
                                                    <td>
                                                        <strong><?php echo $stock->consumable_name; ?></strong>
                                                        <br><small class="text-muted"><?php echo $stock->consumable_code; ?></small>
                                                    </td>
                                                    <td>
                                                        <span class="label label-default">
                                                            <?php echo $stock->category_name; ?>
                                                        </span>
                                                    </td>
                                                    <td class="text-center">
                                                        <span class="<?php echo $stock_class; ?>">
                                                            <i class="fa <?php echo $icon; ?>"></i>
                                                            <strong><?php echo number_format($stock->current_stock); ?></strong>
                                                        </span>
                                                        <br><small class="text-muted"><?php echo $stock->unit_of_measure; ?></small>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php echo number_format($stock->minimum_stock); ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <span class="label <?php echo $status_class; ?>">
                                                            <?php echo $stock->dept_stock_status; ?>
                                                        </span>
                                                    </td>
                                                    <td class="text-right">
                                                        KES <?php echo number_format($stock->unit_cost, 2); ?>
                                                    </td>
                                                    <td class="text-right">
                                                        <strong>KES <?php echo number_format($stock->dept_stock_value, 2); ?></strong>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php if ($stock->last_restocked_date) { ?>
                                                            <small><?php echo date('M j, Y', strtotime($stock->last_restocked_date)); ?></small>
                                                        <?php } else { ?>
                                                            <small class="text-muted">Never</small>
                                                        <?php } ?>
                                                    </td>
                                                    <td>
                                                        <div class="btn-group btn-group-xs">
                                                            <button type="button" class="btn btn-primary" 
                                                                    onclick="releaseMore(<?php echo $stock->consumable_id; ?>)"
                                                                    title="Release more items">
                                                                <i class="fa fa-plus"></i>
                                                            </button>
                                                            <button type="button" class="btn btn-warning" 
                                                                    onclick="adjustStock(<?php echo $stock->consumable_id; ?>, '<?php echo $stock->consumable_name; ?>')"
                                                                    title="Adjust stock">
                                                                <i class="fa fa-edit"></i>
                                                            </button>
                                                            <button type="button" class="btn btn-info" 
                                                                    onclick="viewHistory(<?php echo $stock->consumable_id; ?>)"
                                                                    title="View history">
                                                                <i class="fa fa-history"></i>
                                                            </button>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php } else { ?>
                                <div class="text-center" style="padding: 50px;">
                                    <i class="fa fa-cube fa-3x text-muted"></i>
                                    <h4>No Stock Items</h4>
                                    <p class="text-muted">
                                        This department doesn't have any consumables in stock yet.
                                    </p>
                                    <a href="<?php echo base_url(); ?>admin/consumable/release_to_department?department_id=<?php echo $selected_department; ?>" 
                                       class="btn btn-primary">
                                        <i class="fa fa-share"></i> Release Items to Department
                                    </a>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>

        <?php } else { ?>
            <!-- No Department Selected -->
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-default">
                        <div class="box-body text-center" style="padding: 100px;">
                            <i class="fa fa-building fa-5x text-muted"></i>
                            <h3>Select a Department</h3>
                            <p class="text-muted">Choose a department from the dropdown above to view its consumable stock levels.</p>
                            
                            <div class="row" style="margin-top: 30px;">
                                <?php foreach ($departments as $dept) { ?>
                                    <div class="col-md-3">
                                        <a href="<?php echo base_url(); ?>admin/consumable/department_stock/<?php echo $dept->id; ?>" 
                                           class="btn btn-default btn-lg btn-block">
                                            <i class="fa fa-building"></i><br>
                                            <?php echo $dept->department_name; ?>
                                        </a>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>

    </section>
</div>

<!-- Stock Adjustment Modal -->
<div class="modal fade" id="adjustStockModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-edit"></i> Adjust Department Stock
                </h4>
            </div>
            <form id="adjustStockForm">
                <div class="modal-body">
                    <div class="form-group">
                        <label>Item:</label>
                        <div id="adjustItemName" class="form-control" style="background-color: #f4f4f4;"></div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Current Stock:</label>
                                <div id="adjustCurrentStock" class="form-control" style="background-color: #f4f4f4;"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="adjustment_type">Adjustment Type:</label>
                                <select id="adjustment_type" class="form-control" required>
                                    <option value="">Select Type</option>
                                    <option value="add">Add Stock</option>
                                    <option value="reduce">Reduce Stock</option>
                                    <option value="set">Set Exact Amount</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="adjustment_quantity">Quantity:</label>
                        <input type="number" id="adjustment_quantity" class="form-control" min="0" required>
                    </div>
                    <div class="form-group">
                        <label for="adjustment_reason">Reason for Adjustment:</label>
                        <textarea id="adjustment_reason" class="form-control" rows="3" placeholder="Explain why this adjustment is needed..." required></textarea>
                    </div>
                    <input type="hidden" id="adjust_consumable_id">
                    <input type="hidden" id="adjust_department_id" value="<?php echo isset($selected_department) ? $selected_department : ''; ?>">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> Apply Adjustment
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Custom CSS -->
<style>
    .info-box-content {
        padding: 5px 10px;
    }
    
    .info-box-text {
        text-transform: none;
        font-weight: 500;
        font-size: 12px;
    }
    
    .info-box-number {
        font-size: 16px;
        font-weight: bold;
    }
    
    .table > thead > tr > th,
    .table > tbody > tr > td {
        vertical-align: middle;
    }
    
    .btn-group-xs > .btn {
        padding: 2px 5px;
        font-size: 10px;
    }
    
    .label {
        font-size: 85%;
        padding: 3px 6px;
    }
    
    .text-success { color: #00a65a !important; }
    .text-warning { color: #f39c12 !important; }
    .text-danger { color: #dd4b39 !important; }
    .text-info { color: #3c8dbc !important; }
    
    .box-body .btn-lg {
        padding: 12px 16px;
        margin-bottom: 10px;
        font-size: 14px;
    }
    
    #departmentStockTable th {
        background-color: #f4f4f4;
        font-weight: 600;
    }
    
    .modal-body .form-group {
        margin-bottom: 15px;
    }
</style>

<!-- JavaScript -->
<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#departmentStockTable').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "pageLength": 25,
        "order": [[4, "desc"], [0, "asc"]], // Sort by status (problems first), then name
        "columnDefs": [
            { "orderable": false, "targets": [8] }, // Actions column
            { "className": "text-center", "targets": [2, 3, 4, 7] },
            { "className": "text-right", "targets": [5, 6] }
        ]
    });
    
    // Department selector change handler
    $('#department_selector').change(function() {
        var departmentId = $(this).val();
        if (departmentId) {
            window.location.href = '<?php echo base_url(); ?>admin/consumable/department_stock/' + departmentId;
        } else {
            window.location.href = '<?php echo base_url(); ?>admin/consumable/department_stock';
        }
    });
    
    // Stock adjustment form handler
    $('#adjustStockForm').on('submit', function(e) {
        e.preventDefault();
        processStockAdjustment();
    });
});

/**
 * Filter stock table by status
 */
function filterStock(status) {
    var table = $('#departmentStockTable').DataTable();
    
    if (status === 'all') {
        table.column(4).search('').draw();
    } else {
        var searchTerm = '';
        switch (status) {
            case 'normal':
                searchTerm = 'Normal';
                break;
            case 'low':
                searchTerm = 'Low Stock';
                break;
            case 'out':
                searchTerm = 'Out of Stock';
                break;
        }
        table.column(4).search(searchTerm).draw();
    }
}

/**
 * Release more items to department
 */
function releaseMore(consumableId) {
    var departmentId = <?php echo isset($selected_department) ? $selected_department : 0; ?>;
    window.location.href = '<?php echo base_url(); ?>admin/consumable/release_to_department?department_id=' + departmentId + '&consumable_id=' + consumableId;
}

/**
 * Adjust stock for item
 */
function adjustStock(consumableId, consumableName) {
    $('#adjust_consumable_id').val(consumableId);
    $('#adjustItemName').text(consumableName);
    
    // Get current stock from table row
    var row = $('button[onclick="adjustStock(' + consumableId + ', \'' + consumableName + '\')"]').closest('tr');
    var currentStock = row.find('td:eq(2) strong').text().replace(/,/g, '');
    $('#adjustCurrentStock').text(currentStock + ' units');
    
    $('#adjustStockModal').modal('show');
}

/**
 * View transaction history for item
 */
function viewHistory(consumableId) {
    var departmentId = <?php echo isset($selected_department) ? $selected_department : 0; ?>;
    window.open('<?php echo base_url(); ?>admin/consumable/transactions?consumable_id=' + consumableId + '&department_id=' + departmentId, '_blank');
}

/**
 * Process stock adjustment
 */
function processStockAdjustment() {
    var formData = {
        consumable_id: $('#adjust_consumable_id').val(),
        department_id: $('#adjust_department_id').val(),
        adjustment_type: $('#adjustment_type').val(),
        quantity: $('#adjustment_quantity').val(),
        reason: $('#adjustment_reason').val()
    };
    
    // Validate form
    if (!formData.adjustment_type || !formData.quantity || !formData.reason) {
        alert('Please fill in all required fields.');
        return;
    }
    
    // Show loading state
    $('#adjustStockForm button[type="submit"]').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Processing...');
    
    // In a real implementation, this would be an AJAX call to the server
    // For now, we'll show a confirmation and reload
    setTimeout(function() {
        alert('Stock adjustment has been recorded successfully.');
        location.reload();
    }, 1000);
}

/**
 * Auto-refresh page every 5 minutes to keep stock levels current
 */
setTimeout(function() {
    if (confirm('Refresh page to get latest stock levels?')) {
        location.reload();
    }
}, 300000); // 5 minutes

// Initialize tooltips
$(document).ready(function() {
    $('[data-toggle="tooltip"]').tooltip();
});
</script>

<!-- Include DataTables -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/dataTables.bootstrap.min.css">
<script type="text/javascript" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.24/js/dataTables.bootstrap.min.js"></script>