<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-plus-circle"></i> Create Consumable Requisition
            <small>Request consumables from main store</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/consumable">Consumable Store</a></li>
            <li><a href="<?php echo base_url(); ?>admin/consumable/requisitions">Requisitions</a></li>
            <li class="active">Create New</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { ?>
            <div class="row">
                <div class="col-md-12">
                    <?php echo $this->session->flashdata('msg'); ?>
                </div>
            </div>
        <?php } ?>

        <!-- Form validation errors -->
        <?php if (validation_errors()) { ?>
            <div class="row">
                <div class="col-md-12">
                    <div class="alert alert-danger">
                        <i class="fa fa-exclamation-triangle"></i>
                        <strong>Please correct the following errors:</strong>
                        <?php echo validation_errors(); ?>
                    </div>
                </div>
            </div>
        <?php } ?>

        <form action="<?php echo current_url(); ?>" method="post" id="createRequisitionForm">
            
            <!-- Requisition Header -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-info-circle"></i> Requisition Information</h3>
                    <div class="box-tools pull-right">
                        <span class="label label-primary">Step 1: Basic Details</span>
                    </div>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="requesting_department_id">Requesting Department <span class="text-danger">*</span></label>
                                <select name="requesting_department_id" id="requesting_department_id" class="form-control" required>
                                    <option value="">Select Department</option>
                                    <?php foreach ($departments as $department) { ?>
                                        <option value="<?php echo $department->id; ?>" 
                                                <?php echo (set_value('requesting_department_id') == $department->id) ? 'selected' : ''; ?>
                                                <?php echo ($this->input->get('department_id') == $department->id) ? 'selected' : ''; ?>>
                                            <?php echo $department->department_name; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="request_date">Request Date <span class="text-danger">*</span></label>
                                <input type="date" name="request_date" id="request_date" 
                                       class="form-control" value="<?php echo set_value('request_date', date('Y-m-d')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="required_date">Required By Date</label>
                                <input type="date" name="required_date" id="required_date" 
                                       class="form-control" value="<?php echo set_value('required_date'); ?>"
                                       min="<?php echo date('Y-m-d'); ?>">
                                <small class="text-muted">When do you need these items?</small>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="priority">Priority <span class="text-danger">*</span></label>
                                <select name="priority" id="priority" class="form-control" required>
                                    <option value="">Select Priority</option>
                                    <option value="low" <?php echo (set_value('priority') == 'low') ? 'selected' : ''; ?>>Low</option>
                                    <option value="medium" <?php echo (set_value('priority', 'medium') == 'medium') ? 'selected' : ''; ?>>Medium</option>
                                    <option value="high" <?php echo (set_value('priority') == 'high') ? 'selected' : ''; ?>>High</option>
                                    <option value="urgent" <?php echo (set_value('priority') == 'urgent') ? 'selected' : ''; ?>>Urgent</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-9">
                            <div class="form-group">
                                <label for="purpose">Purpose <span class="text-danger">*</span></label>
                                <input type="text" name="purpose" id="purpose" class="form-control" 
                                       placeholder="Brief description of the purpose (e.g., Patient care, Emergency stock, Routine restocking)" 
                                       value="<?php echo set_value('purpose'); ?>" required>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="justification">Justification</label>
                                <textarea name="justification" id="justification" class="form-control" rows="3" 
                                          placeholder="Detailed justification for this requisition (e.g., current stock levels, patient needs, etc.)"><?php echo set_value('justification'); ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Items Selection -->
            <div class="box box-success">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-shopping-cart"></i> Request Items</h3>
                    <div class="box-tools pull-right">
                        <span class="label label-success">Step 2: Add Items</span>
                    </div>
                </div>
                <div class="box-body">
                    <!-- Add Item Form -->
                    <div class="row">
                        <div class="col-md-5">
                            <div class="form-group">
                                <label for="consumable_search">Search Consumables:</label>
                                <select id="consumable_search" class="form-control">
                                    <option value="">Start typing to search consumables...</option>
                                    <?php foreach ($consumables as $consumable) { ?>
                                        <option value="<?php echo $consumable->id; ?>" 
                                                data-name="<?php echo $consumable->consumable_name; ?>"
                                                data-code="<?php echo $consumable->consumable_code; ?>"
                                                data-stock="<?php echo $consumable->current_stock; ?>"
                                                data-unit="<?php echo $consumable->unit_of_measure; ?>"
                                                data-cost="<?php echo $consumable->unit_cost; ?>"
                                                <?php echo ($this->input->get('consumable_id') == $consumable->id) ? 'selected' : ''; ?>>
                                            <?php echo $consumable->consumable_name; ?> (<?php echo $consumable->consumable_code; ?>) - 
                                            Stock: <?php echo $consumable->current_stock; ?> <?php echo $consumable->unit_of_measure; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="item_quantity">Quantity:</label>
                                <input type="number" id="item_quantity" class="form-control" min="1" placeholder="0">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="item_justification">Item Justification:</label>
                                <input type="text" id="item_justification" class="form-control" 
                                       placeholder="Reason for requesting this item">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>&nbsp;</label><br>
                                <button type="button" class="btn btn-success btn-block" onclick="addItemToRequisition()">
                                    <i class="fa fa-plus"></i> Add Item
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Selected Items Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered" id="requisitionItemsTable">
                            <thead>
                                <tr class="bg-light-blue">
                                    <th>Item</th>
                                    <th width="100">Available Stock</th>
                                    <th width="100">Requested Qty</th>
                                    <th width="120">Est. Unit Cost</th>
                                    <th width="120">Est. Total Cost</th>
                                    <th width="200">Justification</th>
                                    <th width="80">Action</th>
                                </tr>
                            </thead>
                            <tbody id="requisitionItemsBody">
                                <tr id="noItemsRow">
                                    <td colspan="7" class="text-center text-muted">
                                        <i class="fa fa-info-circle"></i> No items added yet. Use the form above to add items to this requisition.
                                    </td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr class="bg-gray">
                                    <th colspan="4" class="text-right">Total Estimated Cost:</th>
                                    <th id="totalEstimatedCost">KES 0.00</th>
                                    <th colspan="2"></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                    <!-- Hidden inputs for form submission -->
                    <div id="hiddenItemInputs"></div>
                </div>
            </div>

            <!-- Summary and Actions -->
            <div class="box box-info">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-summary"></i> Requisition Summary</h3>
                    <div class="box-tools pull-right">
                        <span class="label label-info">Step 3: Review & Submit</span>
                    </div>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="info-box bg-aqua">
                                <span class="info-box-icon"><i class="fa fa-shopping-cart"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Items</span>
                                    <span class="info-box-number" id="summaryItemCount">0</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-green">
                                <span class="info-box-icon"><i class="fa fa-money"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Est. Cost</span>
                                    <span class="info-box-number" id="summaryTotalCost">KES 0</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box" id="summaryPriorityBox">
                                <span class="info-box-icon"><i class="fa fa-flag"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Priority</span>
                                    <span class="info-box-number" id="summaryPriority">-</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-yellow">
                                <span class="info-box-icon"><i class="fa fa-calendar"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Required By</span>
                                    <span class="info-box-number" id="summaryRequiredDate">-</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="box box-default">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <a href="<?php echo base_url(); ?>admin/consumable/requisitions" class="btn btn-default btn-lg">
                                <i class="fa fa-arrow-left"></i> Back to Requisitions
                            </a>
                        </div>
                        <div class="col-md-4 text-center">
                            <button type="button" class="btn btn-warning btn-lg" onclick="clearForm()">
                                <i class="fa fa-refresh"></i> Clear Form
                            </button>
                        </div>
                        <div class="col-md-4 text-right">
                            <button type="submit" class="btn btn-success btn-lg" id="submitRequisitionBtn" disabled>
                                <i class="fa fa-save"></i> Create Requisition
                            </button>
                        </div>
                    </div>
                </div>
            </div>

        </form>

    </section>
</div>

<!-- Item Selection Modal -->
<div class="modal fade" id="itemSelectionModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-search"></i> Browse Consumables
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <input type="text" id="modalItemSearch" class="form-control" 
                                   placeholder="Search by name, code, or category...">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <select id="modalCategoryFilter" class="form-control">
                                <option value="">All Categories</option>
                                <!-- Categories would be populated here -->
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <div class="checkbox">
                                <label>
                                    <input type="checkbox" id="modalStockFilter"> In Stock Only
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="modalItemResults" style="max-height: 400px; overflow-y: auto;">
                    <div class="text-center text-muted">
                        <i class="fa fa-search fa-2x"></i>
                        <p>Start typing to search for consumables</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Custom CSS -->
<style>
    .bg-light-blue {
        background-color: #3c8dbc !important;
        color: white;
    }
    
    .info-box-content {
        padding: 5px 10px;
    }
    
    .info-box-text {
        text-transform: none;
        font-weight: 500;
        font-size: 12px;
    }
    
    .info-box-number {
        font-size: 16px;
        font-weight: bold;
    }
    
    #requisitionItemsTable tbody tr:hover {
        background-color: #f5f5f5;
    }
    
    .btn-group-xs > .btn {
        padding: 2px 5px;
        font-size: 10px;
    }
    
    .text-danger { color: #dc3545 !important; }
    .text-success { color: #28a745 !important; }
    .text-warning { color: #ffc107 !important; }
    .text-info { color: #17a2b8 !important; }
    
    .form-control:focus {
        border-color: #28a745;
        box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 0 3px rgba(40,167,69,.1);
    }
    
    .modal-body .form-group {
        margin-bottom: 15px;
    }
    
    .item-card {
        border: 1px solid #ddd;
        border-radius: 4px;
        padding: 10px;
        margin-bottom: 10px;
        cursor: pointer;
        transition: all 0.3s ease;
    }
    
    .item-card:hover {
        border-color: #3c8dbc;
        background-color: #f9f9f9;
    }
    
    .item-card.selected {
        border-color: #3c8dbc;
        background-color: #d9edf7;
    }
</style>

<!-- JavaScript -->
<script>
var requisitionItems = [];
var totalEstimatedCost = 0;

$(document).ready(function() {
    // Initialize form
    initializeForm();
    
    // Form field change handlers
    $('#priority, #required_date').change(function() {
        updateSummary();
    });
    
    // Pre-select item if passed via URL
    var urlParams = new URLSearchParams(window.location.search);
    if (urlParams.get('consumable_id')) {
        $('#consumable_search').val(urlParams.get('consumable_id')).trigger('change');
    }
    
    // Form submission handler
    $('#createRequisitionForm').on('submit', function(e) {
        if (!validateForm()) {
            e.preventDefault();
            return false;
        }
        
        // Show loading state
        $('#submitRequisitionBtn').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Creating...');
    });
});

/**
 * Initialize form elements
 */
function initializeForm() {
    // Initialize Select2 for better dropdowns
    if (typeof $.fn.select2 !== 'undefined') {
        $('#consumable_search').select2({
            placeholder: "Search for consumables...",
            allowClear: true,
            width: '100%'
        });
        
        $('#requesting_department_id').select2({
            placeholder: "Select department...",
            allowClear: true
        });
    }
    
    updateSummary();
}

/**
 * Add item to requisition
 */
function addItemToRequisition() {
    var consumableId = $('#consumable_search').val();
    var quantity = parseInt($('#item_quantity').val());
    var justification = $('#item_justification').val();
    
    // Validation
    if (!consumableId) {
        alert('Please select a consumable item.');
        return;
    }
    
    if (!quantity || quantity <= 0) {
        alert('Please enter a valid quantity.');
        return;
    }
    
    // Check if item already added
    if (requisitionItems.find(item => item.consumable_id === consumableId)) {
        alert('This item has already been added to the requisition.');
        return;
    }
    
    // Get item details
    var selectedOption = $('#consumable_search option:selected');
    var itemData = {
        consumable_id: consumableId,
        name: selectedOption.data('name'),
        code: selectedOption.data('code'),
        available_stock: selectedOption.data('stock'),
        unit: selectedOption.data('unit'),
        unit_cost: parseFloat(selectedOption.data('cost')) || 0,
        quantity_requested: quantity,
        justification: justification,
        total_cost: (parseFloat(selectedOption.data('cost')) || 0) * quantity
    };
    
    // Add to array
    requisitionItems.push(itemData);
    
    // Update display
    updateItemsTable();
    updateSummary();
    
    // Clear form
    $('#consumable_search').val(null).trigger('change');
    $('#item_quantity').val('');
    $('#item_justification').val('');
}

/**
 * Remove item from requisition
 */
function removeItem(index) {
    requisitionItems.splice(index, 1);
    updateItemsTable();
    updateSummary();
}

/**
 * Update items table display
 */
function updateItemsTable() {
    var tbody = $('#requisitionItemsBody');
    tbody.empty();
    
    if (requisitionItems.length === 0) {
        tbody.append(`
            <tr id="noItemsRow">
                <td colspan="7" class="text-center text-muted">
                    <i class="fa fa-info-circle"></i> No items added yet. Use the form above to add items to this requisition.
                </td>
            </tr>
        `);
        $('#submitRequisitionBtn').prop('disabled', true);
    } else {
        requisitionItems.forEach(function(item, index) {
            var stockStatus = '';
            if (item.available_stock <= 0) {
                stockStatus = '<span class="label label-danger">Out of Stock</span>';
            } else if (item.quantity_requested > item.available_stock) {
                stockStatus = '<span class="label label-warning">Exceeds Stock</span>';
            } else {
                stockStatus = '<span class="label label-success">Available</span>';
            }
            
            var row = `
                <tr>
                    <td>
                        <strong>${item.name}</strong><br>
                        <small class="text-muted">${item.code}</small>
                    </td>
                    <td class="text-center">
                        ${item.available_stock} ${item.unit}<br>
                        ${stockStatus}
                    </td>
                    <td class="text-center">
                        <input type="number" class="form-control input-sm" value="${item.quantity_requested}" 
                               min="1" onchange="updateItemQuantity(${index}, this.value)" style="width: 80px;">
                    </td>
                    <td class="text-right">KES ${item.unit_cost.toFixed(2)}</td>
                    <td class="text-right"><strong>KES ${item.total_cost.toFixed(2)}</strong></td>
                    <td>
                        <input type="text" class="form-control input-sm" value="${item.justification || ''}" 
                               placeholder="Optional justification" onchange="updateItemJustification(${index}, this.value)">
                    </td>
                    <td class="text-center">
                        <button type="button" class="btn btn-danger btn-xs" onclick="removeItem(${index})" title="Remove item">
                            <i class="fa fa-trash"></i>
                        </button>
                    </td>
                </tr>
            `;
            tbody.append(row);
        });
        $('#submitRequisitionBtn').prop('disabled', false);
    }
    
    // Update hidden inputs for form submission
    updateHiddenInputs();
}

/**
 * Update item quantity
 */
function updateItemQuantity(index, newQuantity) {
    var quantity = parseInt(newQuantity) || 1;
    requisitionItems[index].quantity_requested = quantity;
    requisitionItems[index].total_cost = requisitionItems[index].unit_cost * quantity;
    updateItemsTable();
    updateSummary();
}

/**
 * Update item justification
 */
function updateItemJustification(index, newJustification) {
    requisitionItems[index].justification = newJustification;
    updateHiddenInputs();
}

/**
 * Update hidden inputs for form submission
 */
function updateHiddenInputs() {
    var hiddenInputsDiv = $('#hiddenItemInputs');
    hiddenInputsDiv.empty();
    
    requisitionItems.forEach(function(item, index) {
        hiddenInputsDiv.append(`
            <input type="hidden" name="consumable_id[${index}]" value="${item.consumable_id}">
            <input type="hidden" name="quantity_requested[${index}]" value="${item.quantity_requested}">
            <input type="hidden" name="item_justification[${index}]" value="${item.justification || ''}">
        `);
    });
}

/**
 * Update summary display
 */
function updateSummary() {
    // Calculate totals
    totalEstimatedCost = requisitionItems.reduce((sum, item) => sum + item.total_cost, 0);
    
    // Update displays
    $('#summaryItemCount').text(requisitionItems.length);
    $('#summaryTotalCost').text('KES ' + totalEstimatedCost.toLocaleString());
    $('#totalEstimatedCost').text('KES ' + totalEstimatedCost.toFixed(2));
    
    // Update priority
    var priority = $('#priority').val();
    if (priority) {
        $('#summaryPriority').text(priority.charAt(0).toUpperCase() + priority.slice(1));
        var priorityBox = $('#summaryPriorityBox');
        priorityBox.removeClass('bg-blue bg-green bg-yellow bg-red');
        switch (priority) {
            case 'low':
                priorityBox.addClass('bg-blue');
                break;
            case 'medium':
                priorityBox.addClass('bg-green');
                break;
            case 'high':
                priorityBox.addClass('bg-yellow');
                break;
            case 'urgent':
                priorityBox.addClass('bg-red');
                break;
        }
    } else {
        $('#summaryPriority').text('-');
        $('#summaryPriorityBox').removeClass('bg-blue bg-green bg-yellow bg-red');
    }
    
    // Update required date
    var requiredDate = $('#required_date').val();
    if (requiredDate) {
        var date = new Date(requiredDate);
        $('#summaryRequiredDate').text(date.toLocaleDateString('en-US', { 
            month: 'short', 
            day: 'numeric', 
            year: 'numeric' 
        }));
    } else {
        $('#summaryRequiredDate').text('-');
    }
}

/**
 * Validate form before submission
 */
function validateForm() {
    var errors = [];
    
    // Check basic fields
    if (!$('#requesting_department_id').val()) {
        errors.push('Please select a requesting department');
    }
    
    if (!$('#request_date').val()) {
        errors.push('Please select a request date');
    }
    
    if (!$('#priority').val()) {
        errors.push('Please select a priority level');
    }
    
    if (!$('#purpose').val().trim()) {
        errors.push('Please enter the purpose of this requisition');
    }
    
    // Check items
    if (requisitionItems.length === 0) {
        errors.push('Please add at least one item to the requisition');
    }
    
    // Check for items exceeding stock
    var stockExceeded = requisitionItems.some(item => 
        item.quantity_requested > item.available_stock && item.available_stock > 0
    );
    
    if (stockExceeded) {
        if (!confirm('Some items have requested quantities that exceed available stock. Do you want to continue?')) {
            return false;
        }
    }
    
    // Show errors if any
    if (errors.length > 0) {
        showValidationErrors(errors);
        return false;
    }
    
    return true;
}

/**
 * Show validation errors
 */
function showValidationErrors(errors) {
    var errorHtml = '<div class="alert alert-danger alert-dismissible">' +
                   '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>' +
                   '<h4><i class="icon fa fa-ban"></i> Please correct the following errors:</h4><ul>';
    
    errors.forEach(function(error) {
        errorHtml += '<li>' + error + '</li>';
    });
    
    errorHtml += '</ul></div>';
    
    // Insert error message at the top of the form
    $('.content-header').after(errorHtml);
    
    // Scroll to top
    $('html, body').animate({ scrollTop: 0 }, 'fast');
    
    // Auto-hide after 10 seconds
    setTimeout(function() {
        $('.alert-danger').fadeOut();
    }, 10000);
}

/**
 * Clear form and reset to defaults
 */
function clearForm() {
    if (confirm('Are you sure you want to clear all form data? This will remove all added items.')) {
        // Reset form fields
        $('#createRequisitionForm')[0].reset();
        
        // Clear items array
        requisitionItems = [];
        
        // Update displays
        updateItemsTable();
        updateSummary();
        
        // Reset select2 dropdowns
        if (typeof $.fn.select2 !== 'undefined') {
            $('#consumable_search, #requesting_department_id').val(null).trigger('change');
        }
        
        // Reset button state
        $('#submitRequisitionBtn').prop('disabled', true).html('<i class="fa fa-save"></i> Create Requisition');
    }
}

/**
 * Open item browser modal
 */
function openItemBrowser() {
    $('#itemSelectionModal').modal('show');
}

/**
 * Quick add common items
 */
function quickAddCommonItems() {
    // This would show a modal with commonly requested items
    alert('Quick add feature will be implemented in the next version.');
}

/**
 * Save as draft
 */
function saveAsDraft() {
    if (requisitionItems.length === 0) {
        alert('Please add at least one item before saving as draft.');
        return;
    }
    
    if (confirm('Save this requisition as draft? You can complete it later.')) {
        // Add hidden field to indicate draft status
        $('<input>').attr({
            type: 'hidden',
            name: 'save_as_draft',
            value: '1'
        }).appendTo('#createRequisitionForm');
        
        // Submit form
        $('#createRequisitionForm').submit();
    }
}

// Initialize tooltips and other UI enhancements
$(document).ready(function() {
    $('[data-toggle="tooltip"]').tooltip();
    
    // Add quick action buttons
    var quickActionsHtml = `
        <div class="col-md-12 text-center" style="margin-bottom: 15px;">
            <div class="btn-group">
                <button type="button" class="btn btn-info btn-sm" onclick="openItemBrowser()">
                    <i class="fa fa-search"></i> Browse Items
                </button>
                <button type="button" class="btn btn-warning btn-sm" onclick="quickAddCommonItems()">
                    <i class="fa fa-star"></i> Common Items
                </button>
                <button type="button" class="btn btn-default btn-sm" onclick="saveAsDraft()">
                    <i class="fa fa-save"></i> Save as Draft
                </button>
            </div>
        </div>
    `;
    
    // Insert quick actions after the add item form
    $('.box-success .box-body .row').after(quickActionsHtml);
});

// Auto-save functionality (optional)
setInterval(function() {
    if (requisitionItems.length > 0) {
        // Auto-save to localStorage for recovery
        var formData = {
            items: requisitionItems,
            department: $('#requesting_department_id').val(),
            priority: $('#priority').val(),
            purpose: $('#purpose').val(),
            justification: $('#justification').val(),
            required_date: $('#required_date').val(),
            timestamp: new Date().getTime()
        };
        localStorage.setItem('requisition_draft', JSON.stringify(formData));
    }
}, 30000); // Save every 30 seconds

// Recovery functionality
$(document).ready(function() {
    var savedDraft = localStorage.getItem('requisition_draft');
    if (savedDraft) {
        var draftData = JSON.parse(savedDraft);
        var draftAge = (new Date().getTime() - draftData.timestamp) / (1000 * 60); // minutes
        
        if (draftAge < 60 && draftData.items.length > 0) { // Less than 1 hour old
            if (confirm('Found a saved draft from ' + Math.round(draftAge) + ' minutes ago. Do you want to restore it?')) {
                // Restore form data
                $('#requesting_department_id').val(draftData.department).trigger('change');
                $('#priority').val(draftData.priority);
                $('#purpose').val(draftData.purpose);
                $('#justification').val(draftData.justification);
                $('#required_date').val(draftData.required_date);
                
                // Restore items
                requisitionItems = draftData.items;
                updateItemsTable();
                updateSummary();
            }
        }
    }
});

// Clear draft on successful submission
$('#createRequisitionForm').on('submit', function() {
    localStorage.removeItem('requisition_draft');
});
</script>

<!-- Include Select2 for better dropdowns -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>