<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-cubes"></i> Manage Consumables
            <small>Hospital consumable inventory management</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/consumable">Consumable Store</a></li>
            <li class="active">Manage Consumables</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { ?>
            <div class="row">
                <div class="col-md-12">
                    <?php echo $this->session->flashdata('msg'); ?>
                </div>
            </div>
        <?php } ?>

        <!-- Filters and Search -->
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-filter"></i> Search & Filter</h3>
                <div class="box-tools pull-right">
                    <a href="<?php echo base_url(); ?>admin/consumable/add_consumable" class="btn btn-success">
                        <i class="fa fa-plus"></i> Add New Consumable
                    </a>
                </div>
            </div>
            <div class="box-body">
                <form method="get" action="<?php echo current_url(); ?>" class="form-inline">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Search:</label>
                                <input type="text" name="search" class="form-control" 
                                       placeholder="Name, code, or generic name..."
                                       value="<?php echo $this->input->get('search'); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Category:</label>
                                <select name="category_id" class="form-control">
                                    <option value="">All Categories</option>
                                    <?php foreach ($categories as $category) { ?>
                                        <option value="<?php echo $category->id; ?>" 
                                                <?php echo ($this->input->get('category_id') == $category->id) ? 'selected' : ''; ?>>
                                            <?php echo $category->category_name; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>&nbsp;</label><br>
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="low_stock" value="1" 
                                               <?php echo $this->input->get('low_stock') ? 'checked' : ''; ?>>
                                        Low Stock Only
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>&nbsp;</label><br>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-search"></i> Search
                                </button>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>&nbsp;</label><br>
                                <a href="<?php echo current_url(); ?>" class="btn btn-default">
                                    <i class="fa fa-refresh"></i> Clear
                                </a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Consumables List -->
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title">
                    <i class="fa fa-list"></i> Consumables List 
                    <span class="label label-info"><?php echo count($consumables); ?> items</span>
                </h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse">
                        <i class="fa fa-minus"></i>
                    </button>
                </div>
            </div>
            <div class="box-body">
                <?php if (!empty($consumables)) { ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered" id="consumablesTable">
                            <thead>
                                <tr>
                                    <th>Code</th>
                                    <th>Name</th>
                                    <th>Category</th>
                                    <th>Current Stock</th>
                                    <th>Unit Cost (KES)</th>
                                    <th>Selling Price (KES)</th>
                                    <th>Status</th>
                                    <th>Stock Value (KES)</th>
                                    <th width="150">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($consumables as $consumable) { 
                                    // Determine stock status styling
                                    $stock_class = 'text-success';
                                    $stock_icon = 'fa-check-circle';
                                    $status_badge = 'label-success';
                                    
                                    if ($consumable->stock_status == 'Out of Stock') {
                                        $stock_class = 'text-danger';
                                        $stock_icon = 'fa-times-circle';
                                        $status_badge = 'label-danger';
                                    } elseif ($consumable->stock_status == 'Low Stock') {
                                        $stock_class = 'text-warning';
                                        $stock_icon = 'fa-exclamation-triangle';
                                        $status_badge = 'label-warning';
                                    } elseif ($consumable->stock_status == 'Overstock') {
                                        $stock_class = 'text-info';
                                        $stock_icon = 'fa-arrow-up';
                                        $status_badge = 'label-info';
                                    }
                                ?>
                                    <tr>
                                        <td>
                                            <strong><?php echo $consumable->consumable_code; ?></strong>
                                        </td>
                                        <td>
                                            <strong><?php echo $consumable->consumable_name; ?></strong>
                                            <?php if ($consumable->generic_name) { ?>
                                                <br><small class="text-muted">Generic: <?php echo $consumable->generic_name; ?></small>
                                            <?php } ?>
                                            <?php if ($consumable->strength) { ?>
                                                <br><small class="text-info">Strength: <?php echo $consumable->strength; ?></small>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <span class="label label-default">
                                                <?php echo $consumable->category_name; ?>
                                            </span>
                                        </td>
                                        <td class="text-center">
                                            <span class="<?php echo $stock_class; ?>">
                                                <i class="fa <?php echo $stock_icon; ?>"></i>
                                                <strong><?php echo number_format($consumable->current_stock); ?></strong>
                                            </span>
                                            <br>
                                            <small class="text-muted"><?php echo $consumable->unit_of_measure; ?></small>
                                            <?php if ($consumable->reorder_level > 0) { ?>
                                                <br><small class="text-muted">Reorder: <?php echo $consumable->reorder_level; ?></small>
                                            <?php } ?>
                                        </td>
                                        <td class="text-right">
                                            <?php echo number_format($consumable->unit_cost, 2); ?>
                                        </td>
                                        <td class="text-right">
                                            <?php echo number_format($consumable->selling_price, 2); ?>
                                            <?php if ($consumable->markup_percentage > 0) { ?>
                                                <br><small class="text-success">+<?php echo $consumable->markup_percentage; ?>%</small>
                                            <?php } ?>
                                        </td>
                                        <td class="text-center">
                                            <span class="label <?php echo $status_badge; ?>">
                                                <?php echo $consumable->stock_status; ?>
                                            </span>
                                        </td>
                                        <td class="text-right">
                                            <strong><?php echo number_format($consumable->total_stock_value, 2); ?></strong>
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-default btn-xs dropdown-toggle" 
                                                        data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <i class="fa fa-cog"></i> Actions <span class="caret"></span>
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <?php if ($this->rbac->hasPrivilege('consumable_store', 'can_view')) { ?>
                                                        <li>
                                                            <a href="#" onclick="viewConsumableDetails(<?php echo $consumable->id; ?>)">
                                                                <i class="fa fa-eye"></i> View Details
                                                            </a>
                                                        </li>
                                                    <?php } ?>
                                                    <?php if ($this->rbac->hasPrivilege('consumable_store', 'can_edit')) { ?>
                                                        <li>
                                                            <a href="<?php echo base_url(); ?>admin/consumable/edit_consumable/<?php echo $consumable->id; ?>">
                                                                <i class="fa fa-edit"></i> Edit
                                                            </a>
                                                        </li>
                                                    <?php } ?>
                                                    <li class="divider"></li>
                                                    <li>
                                                        <a href="<?php echo base_url(); ?>admin/consumable/release_to_department?consumable_id=<?php echo $consumable->id; ?>">
                                                            <i class="fa fa-share"></i> Release to Department
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="#" onclick="addToRequisition(<?php echo $consumable->id; ?>)">
                                                            <i class="fa fa-file-text"></i> Add to Requisition
                                                        </a>
                                                    </li>
                                                    <?php if ($consumable->batch_tracking == 'yes') { ?>
                                                        <li class="divider"></li>
                                                        <li>
                                                            <a href="#" onclick="viewBatches(<?php echo $consumable->id; ?>)">
                                                                <i class="fa fa-barcode"></i> View Batches
                                                            </a>
                                                        </li>
                                                    <?php } ?>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                <?php } else { ?>
                    <div class="text-center" style="padding: 50px;">
                        <i class="fa fa-cube fa-3x text-muted"></i>
                        <h4>No consumables found</h4>
                        <p class="text-muted">
                            No consumables match your current filters.
                            <?php if (!empty($current_filters)) { ?>
                                <a href="<?php echo base_url(); ?>admin/consumable/consumables">Clear filters</a> to see all items.
                            <?php } ?>
                        </p>
                        <a href="<?php echo base_url(); ?>admin/consumable/add_consumable" class="btn btn-success">