<?php
$currency_symbol = $this->customlib->getHospitalCurrencyFormat();
$genderList = $this->customlib->getGender_Patient();
?>

<!-- Include SecuGen WebAPI scripts -->
<script src="<?php echo base_url('WebAPI-JavaScript/secugen.js'); ?>"></script>

<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
        <div class="row"> 
            <div class="col-md-12">
                <div class="nav-tabs-custom border0">
                    <div class="box box-primary"> 
                        <div class="box-header with-border">
                            <h3 class="box-title titlefix">
                                <i class="fa fa-user-md"></i> <?php echo $this->lang->line('patient_consultation'); ?>
                            </h3>
                            <div class="box-tools pull-right">
                                <?php if ($this->rbac->hasPrivilege('consultation', 'can_add')) { ?>
                                    <a data-toggle="modal" id="add_consultation" onclick="holdModal('consultationModal')" class="btn btn-primary btn-sm">
                                        <i class="fa fa-plus"></i> <?php echo $this->lang->line('new_consultation'); ?>
                                    </a>
                                <?php } ?>
                                
                                <?php if ($this->rbac->hasPrivilege('consultation', 'can_view')) { ?>
                                    <a href="<?php echo base_url("admin/consultation/history"); ?>" class="btn btn-info btn-sm">
                                        <i class="fa fa-history"></i> <?php echo $this->lang->line('consultation_history'); ?>
                                    </a>
                                <?php } ?>
                            </div>
                        </div>

                        <ul class="nav nav-tabs navlistscroll">
                            <li class="active"><a href="#tab_patient_search" data-toggle="tab">
                                <i class="fa fa-search"></i> <?php echo $this->lang->line('patient_search') ?>
                            </a></li>
                            <li><a href="#tab_consultation_list" data-toggle="tab">
                                <i class="fa fa-list"></i> <?php echo $this->lang->line('consultation_list') ?>
                            </a></li>
                            <li><a href="#tab_diagnosis_management" data-toggle="tab">
                                <i class="fa fa-stethoscope"></i> Diagnosis Management
                            </a></li>
                        </ul>

                        <div class="tab-content">
                            <!-- Patient Search Tab -->
                            <div class="tab-pane active" id="tab_patient_search">
                                <div class="topmius35">
                                    <div class="row">
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('search_patient'); ?></label>
                                                <select onchange="get_PatientDetailsForConsultation(this.value)" class="form-control patient_list_ajax" id="consultation_patient_search" name="patient_search">
                                                    <option value=""><?php echo $this->lang->line('select_patient'); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <?php if ($this->rbac->hasPrivilege('patient', 'can_add')) { ?>
                                                <label>&nbsp;</label><br>
                                                <a data-toggle="modal" id="add_new_patient" onclick="holdModal('myModalpa')" class="btn btn-success">
                                                    <i class="fa fa-plus"></i> <?php echo $this->lang->line('add_new_patient'); ?>
                                                </a>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>

                                <!-- Patient Details Section -->
                                <div class="box-body">
                                    <div id="ajax_load"></div>
                                    <div class="row ptt10" id="consultationPatientDetails" style="display:none">
                                        <div class="col-lg-8 col-md-8 col-sm-8">
                                            <div class="row">
                                                <div class="col-md-9 col-sm-9 col-xs-9">
                                                    <ul class="singlelist">
                                                        <li class="singlelist24bold">
                                                            <span id="consultation_patient_name"></span>
                                                            <span id="consultation_patient_id" class="text-muted"></span>
                                                        </li>
                                                        <li>
                                                            <i class="fas fa-user-secret" data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line('guardian'); ?>"></i>
                                                            <span id="consultation_guardian"></span>
                                                        </li>
                                                    </ul>   
                                                    <ul class="multilinelist">   
                                                        <li>
                                                            <i class="fas fa-venus-mars" data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line('gender'); ?>"></i>
                                                            <span id="consultation_gender"></span>
                                                        </li>
                                                        <li>
                                                            <i class="fas fa-tint" data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line('blood_group'); ?>"></i>
                                                            <span id="consultation_blood_group"></span>
                                                        </li>
                                                        <li>
                                                            <i class="fas fa-ring" data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line('marital_status'); ?>"></i>
                                                            <span id="consultation_marital_status"></span>
                                                        </li> 
                                                    </ul>  
                                                    <ul class="singlelist">  
                                                        <li>
                                                            <i class="fas fa-hourglass-half" data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line('age'); ?>"></i>
                                                            <span id="consultation_age"></span> <span id="consultation_as_of_date"></span>
                                                        </li>   
                                                        <li>
                                                            <i class="fa fa-phone-square" data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line('phone'); ?>"></i> 
                                                            <span id="consultation_phone"></span>
                                                        </li>
                                                        <li>
                                                            <i class="fa fa-envelope" data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line('email'); ?>"></i>
                                                            <span id="consultation_email"></span>
                                                        </li>
                                                        <li>
                                                            <i class="fas fa-street-view" data-toggle="tooltip" data-placement="top" title="<?php echo $this->lang->line('address'); ?>"></i>
                                                            <span id="consultation_address"></span>
                                                        </li>
                                                        <li>
                                                            <b><?php echo $this->lang->line('any_known_allergies') ?> </b> 
                                                            <span id="consultation_allergies"></span>
                                                        </li>
                                                        <li>
                                                            <b><?php echo $this->lang->line('remarks') ?> </b> 
                                                            <span id="consultation_notes"></span>
                                                        </li>
                                                    </ul>

                                                    <!-- Fingerprint Verification Section -->
                                                    <div class="fingerprint-verification-section" style="margin-top: 20px;">
                                                        <h5><i class="fa fa-fingerprint"></i> <?php echo $this->lang->line('identity_verification'); ?></h5>
                                                        
                                                        <div class="panel panel-default">
                                                            <div class="panel-heading" style="padding: 8px 15px; background-color: #f8f9fa;">
                                                                <h6 class="panel-title" style="margin: 0;">
                                                                    <i class="fa fa-shield"></i> Biometric Verification Required for Consultation
                                                                </h6>
                                                            </div>
                                                            <div class="panel-body" style="padding: 15px;">
                                                                
                                                                <!-- Service Status -->
                                                                <div id="consultation_secugen_service_status" class="mb-3"></div>
                                                                
                                                                <div class="row">
                                                                    <div class="col-md-6">
                                                                        <div class="text-center mb-3">
                                                                            <label class="control-label">Patient Fingerprint</label>
                                                                            <div style="border: 2px dashed #ddd; padding: 10px; border-radius: 8px; background-color: #fafafa;">
                                                                                <img id="consultation_fingerprint_img" src="./Images/PlaceFinger.bmp" 
                                                                                     alt="Patient Fingerprint" 
                                                                                     style="height: 120px; width: 96px; border: 1px solid #ccc; border-radius: 4px; display: block; margin: 0 auto;">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    
                                                                    <div class="col-md-6">
                                                                        <div class="verification-controls">
                                                                            <label class="control-label">Identity Verification</label>
                                                                            
                                                                            <div class="btn-group-vertical" style="width: 100%; margin-bottom: 15px;">
                                                                                <button type="button" id="verifyPatientIdentity" class="btn btn-success" style="margin-bottom: 8px;" disabled>
                                                                                    <i class="fa fa-check"></i> Verify Patient Identity
                                                                                </button>
                                                                                <button type="button" id="skipVerification" class="btn btn-warning" style="margin-bottom: 8px;">
                                                                                    <i class="fa fa-exclamation-triangle"></i> Skip Verification (Admin Only)
                                                                                </button>
                                                                            </div>
                                                                            
                                                                            <div class="btn-group" style="width: 100%;">
                                                                                <button type="button" id="consultation_manual_capture" class="btn btn-info btn-sm" style="width: 50%;">
                                                                                    <i class="fa fa-hand-pointer-o"></i> Manual
                                                                                </button>
                                                                                <button type="button" id="consultation_test_connection" class="btn btn-default btn-sm" style="width: 50%;">
                                                                                    <i class="fa fa-wrench"></i> Test
                                                                                </button>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                
                                                                <!-- Status Display -->
                                                                <div id="consultation_verification_status" class="mt-3"></div>
                                                                
                                                                <!-- Start Consultation Button -->
                                                                <div class="text-center" style="margin-top: 15px;">
                                                                    <button type="button" id="startConsultationBtn" class="btn btn-primary btn-lg" disabled>
                                                                        <i class="fa fa-user-md"></i> Start Consultation
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <!-- Hidden Data Storage -->
                                                        <input type="hidden" id="consultation_patient_id_hidden" value="">
                                                        <input type="hidden" id="consultation_fingerprint_template" value="">
                                                        <input type="hidden" id="consultation_fingerprint_image" value="">
                                                        <input type="hidden" id="consultation_verification_passed" value="0">
                                                    </div>
                                                </div><!-- ./col-md-9 -->
                                                
                                                <div class="col-md-3 col-sm-3 col-xs-3"> 
                                                    <div class="pull-right">
                                                        <img class="modal-profile-user-img img-responsive" src="<?php echo base_url() . 'uploads/patient_images/no_image.png' . img_time() ?>" id="consultation_patient_image" alt="Patient Photo">
                                                    </div>           
                                                </div><!-- ./col-md-3 -->
                                            </div>
                                        </div><!--./col-lg-8-->
                                        
                                        <!-- Recent Consultations -->
                                        <div class="col-lg-4 col-md-4 col-sm-4">
                                            <div class="panel panel-info">
                                                <div class="panel-heading">
                                                    <h3 class="panel-title">
                                                        <i class="fa fa-history"></i> Recent Consultations
                                                    </h3>
                                                </div>
                                                <div class="panel-body">
                                                    <div id="recent_consultations">
                                                        <p class="text-muted text-center">Select a patient to view consultation history</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!--./row-->
                                </div>
                            </div>

                            <!-- Consultation List Tab -->
                            <div class="tab-pane" id="tab_consultation_list">
                                <div class="box-body table-responsive">
                                    <table class="table table-striped table-bordered table-hover consultation_list" cellspacing="0" width="100%" data-export-title="<?php echo $this->lang->line('consultation_list'); ?>">
                                        <thead>
                                            <tr>
                                                <th><?php echo $this->lang->line('consultation_id'); ?></th>
                                                <th><?php echo $this->lang->line('date'); ?></th>
                                                <th><?php echo $this->lang->line('patient_name'); ?></th>
                                                <th><?php echo $this->lang->line('doctor'); ?></th>
                                                <th><?php echo $this->lang->line('symptoms'); ?></th>
                                                <th>Primary Diagnosis</th>
                                                <th class="text-right noExport"><?php echo $this->lang->line('action') ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <!-- Diagnosis Management Tab -->
                            <div class="tab-pane" id="tab_diagnosis_management">
                                <div class="box-body">
                                    <?php if ($this->rbac->hasPrivilege('diagnosis', 'can_view')) { ?>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <i class="fa fa-stethoscope"></i> ICD Diagnosis Code Quick Access
                                                        </h4>
                                                    </div>
                                                    <div class="panel-body">
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <div class="form-group">
                                                                    <label>Quick Search Diagnosis</label>
                                                                    <input type="text" id="quick_diagnosis_search" class="form-control" placeholder="Search by code or description...">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label>ICD Version</label>
                                                                    <select id="quick_icd_version" class="form-control">
                                                                        <option value="ICD10">ICD-10</option>
                                                                        <option value="ICD11">ICD-11</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label>&nbsp;</label><br>
                                                                    <button type="button" id="searchDiagnosisBtn" class="btn btn-primary">
                                                                        <i class="fa fa-search"></i> Search
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <div id="diagnosis_search_results" style="display: none;">
                                                            <h5>Search Results:</h5>
                                                            <div id="diagnosis_results_container"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>  
            </div>
        </div> 
    </section>
</div>

<!-- Enhanced Consultation Modal with ICD Diagnosis -->
<div class="modal fade" id="consultationModal" role="dialog" aria-labelledby="consultationModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content mx-2">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title" id="consultationModalLabel">
                    <i class="fa fa-user-md"></i> <span id="consultation_modal_title"><?php echo $this->lang->line('new_consultation'); ?></span>
                </h4>
            </div>
            
            <form id="consultationForm" accept-charset="utf-8" method="post">
                <div class="modal-body">
                    <div class="row">
                        <!-- Patient Information Display -->
                        <div class="col-md-12">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h4 class="panel-title">
                                        <i class="fa fa-user"></i> Patient Information
                                        <span id="verification_badge" class="pull-right"></span>
                                    </h4>
                                </div>
                                <div class="panel-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p><strong>Name:</strong> <span id="modal_patient_name"></span></p>
                                            <p><strong>Age:</strong> <span id="modal_patient_age"></span></p>
                                            <p><strong>Gender:</strong> <span id="modal_patient_gender"></span></p>
                                        </div>
                                        <div class="col-md-6">
                                            <p><strong>Phone:</strong> <span id="modal_patient_phone"></span></p>
                                            <p><strong>Blood Group:</strong> <span id="modal_patient_blood_group"></span></p>
                                            <p><strong>Allergies:</strong> <span id="modal_patient_allergies"></span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Consultation Basic Information -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="consultation_date"><?php echo $this->lang->line('consultation_date'); ?></label>
                                <small class="req"> *</small>
                                <input type="date" name="consultation_date" id="consultation_date" class="form-control" value="<?php echo date('Y-m-d'); ?>" required>
                                <span class="text-danger"></span>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="consultation_doctor"><?php echo $this->lang->line('consulting_doctor'); ?></label>
                                <small class="req"> *</small>
                                <select name="doctor" id="consultation_doctor" class="form-control select2" required>
                                    <option value=""><?php echo $this->lang->line('select_doctor'); ?></option>
                                    <?php foreach ($doctors as $doctor) { ?>
                                        <option value="<?php echo $doctor['id']; ?>" <?php if ($doctor['id'] == $this->customlib->getStaffID()) echo 'selected'; ?>>
                                            <?php echo $doctor['name'] . ' ' . $doctor['surname'] . ' (' . $doctor['employee_id'] . ')'; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                                <span class="text-danger"></span>
                            </div>
                        </div>

                        <!-- Symptoms -->
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="consultation_symptoms"><?php echo $this->lang->line('symptoms'); ?></label>
                                <small class="req"> *</small>
                                <textarea name="symptoms" id="consultation_symptoms" class="form-control" rows="4" placeholder="<?php echo $this->lang->line('describe_symptoms'); ?>" required></textarea>
                                <span class="text-danger"></span>
                            </div>
                        </div>

                        <!-- ICD Diagnosis Section -->
                        <div class="col-md-12">
                            <div class="panel panel-info">
                                <div class="panel-heading">
                                    <h4 class="panel-title">
                                        <i class="fa fa-stethoscope"></i> Medical Diagnosis (ICD Codes)
                                        <button type="button" class="btn btn-success btn-xs pull-right" id="addDiagnosisBtn">
                                            <i class="fa fa-plus"></i> Add Diagnosis
                                        </button>
                                    </h4>
                                </div>
                                <div class="panel-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>ICD Version</label>
                                                <select id="icd_version_filter" class="form-control">
                                                    <option value="ICD10">ICD-10</option>
                                                    <option value="ICD11">ICD-11</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label>Quick Category Filter</label>
                                                <select id="diagnosis_category_filter" class="form-control">
                                                    <option value="">All Categories</option>
                                                    <option value="Infectious diseases">Infectious Diseases</option>
                                                    <option value="Endocrine diseases">Endocrine Diseases</option>
                                                    <option value="Circulatory diseases">Circulatory Diseases</option>
                                                    <option value="Respiratory diseases">Respiratory Diseases</option>
                                                    <option value="Digestive diseases">Digestive Diseases</option>
                                                    <option value="Musculoskeletal diseases">Musculoskeletal Diseases</option>
                                                    <option value="Symptoms and signs">Symptoms and Signs</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Diagnosis List Container -->
                                    <div id="diagnosis_list_container">
                                        <div class="diagnosis-item" data-index="0">
                                            <div class="row">
                                                <div class="col-md-8">
                                                    <div class="form-group">
                                                        <label>Primary Diagnosis <span class="text-danger">*</span></label>
                                                        <select name="diagnosis_codes[0][diagnosis_code_id]" class="form-control diagnosis-select" data-index="0" required>
                                                            <option value="">Search and select diagnosis...</option>
                                                        </select>
                                                        <small class="help-block">
                                                            <span class="diagnosis-info" data-index="0"></span>
                                                        </small>
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label>Type</label>
                                                        <select name="diagnosis_codes[0][type]" class="form-control">
                                                            <option value="primary">Primary</option>
                                                            <option value="secondary">Secondary</option>
                                                            <option value="complication">Complication</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-1">
                                                    <div class="form-group">
                                                        <label>&nbsp;</label><br>
                                                        <button type="button" class="btn btn-danger btn-sm remove-diagnosis" style="display: none;">
                                                            <i class="fa fa-trash"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label>Clinical Notes for this Diagnosis</label>
                                                        <textarea name="diagnosis_codes[0][notes]" class="form-control" rows="2" placeholder="Additional notes, severity, complications..."></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="alert alert-info">
                                        <i class="fa fa-info-circle"></i>
                                        <strong>ICD Coding Guidelines:</strong>
                                        <ul class="mb-0 mt-1">
                                            <li>Primary diagnosis should be the main condition being treated</li>
                                            <li>Secondary diagnoses are co-existing conditions</li>
                                            <li>Use specific codes when possible (avoid "unspecified" unless necessary)</li>
                                            <li>Search by code, description, or keywords</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Traditional Diagnosis Field (kept for compatibility) -->
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="consultation_diagnosis"><?php echo $this->lang->line('diagnosis'); ?></label>
                                <textarea name="diagnosis" id="consultation_diagnosis" class="form-control" rows="4" placeholder="<?php echo $this->lang->line('medical_diagnosis'); ?>"></textarea>
                            </div>
                        </div>

                        <!-- Clinical Notes -->
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="consultation_notes"><?php echo $this->lang->line('consultation_notes'); ?></label>
                                <textarea name="notes" id="consultation_notes" class="form-control" rows="3" placeholder="<?php echo $this->lang->line('additional_notes'); ?>"></textarea>
                            </div>
                        </div>

                        <!-- Hidden Fields -->
                        <input type="hidden" name="patient_id" id="modal_patient_id">
                        <input type="hidden" name="consultation_id" id="modal_consultation_id">
                        <input type="hidden" name="verification_status" id="modal_verification_status" value="0">
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">
                        <i class="fa fa-times"></i> <?php echo $this->lang->line('cancel'); ?>
                    </button>
                    <button type="submit" id="consultationSubmitBtn" class="btn btn-primary">
                        <i class="fa fa-save"></i> <span id="consultation_submit_text"><?php echo $this->lang->line('save_consultation'); ?></span>
                    </button>
                    <button type="submit" name="save_print" id="consultationSavePrintBtn" class="btn btn-info">
                        <i class="fa fa-print"></i> <?php echo $this->lang->line('save_print'); ?>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- View Consultation Modal -->
<div class="modal fade" id="viewConsultationModal" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content mx-2">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-eye"></i> <?php echo $this->lang->line('consultation_details'); ?>
                </h4>
                <div class="modalicon pull-right">
                    <div id="consultation_edit_delete">
                        <!-- Edit/Delete buttons will be added here dynamically -->
                    </div>
                </div>
            </div>
            <div class="modal-body pt0 pb0">
                <div id="consultation_details_content">
                    <!-- Consultation details will be loaded here -->
                </div>
            </div>
        </div>
    </div>
</div>
<style>
/* Consultation Page Specific Styles */
.consultation-verification-panel {
    border: 2px solid #ddd;
    border-radius: 8px;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
}

.verification-required {
    border-color: #f0ad4e;
    background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7	100%);
}

.verification-passed {
    border-color: #5cb85c;
    background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
}

.consultation-patient-card {
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    border-radius: 8px;
    transition: all 0.3s ease;
}

.consultation-patient-card:hover {
    box-shadow: 0 4px 16px rgba(0,0,0,0.15);
}

.recent-consultation-item {
    border-left: 4px solid #007bff;
    padding: 10px;
    margin-bottom: 10px;
    background-color: #f8f9fa;
    border-radius: 4px;
}

.recent-consultation-item:hover {
    background-color: #e9ecef;
    cursor: pointer;
}

.verification-status-badge {
    display: inline-block;
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 11px;
    font-weight: bold;
    text-transform: uppercase;
}

.verified {
    background-color: #28a745;
    color: white;
}

.not-verified {
    background-color: #dc3545;
    color: white;
}

.skip-verification {
    background-color: #ffc107;
    color: #212529;
}

.consultation-form-section {
    border: 1px solid #ddd;
    border-radius: 6px;
    padding: 15px;
    margin-bottom: 15px;
    background-color: #fafafa;
}

.modal-media-header {
    background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
    color: white;
}

#startConsultationBtn:disabled {
    opacity: 0.6;
    cursor: not-allowed;
}

#startConsultationBtn:not(:disabled) {
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0% { box-shadow: 0 0 0 0 rgba(0, 123, 255, 0.7); }
    70% { box-shadow: 0 0 0 10px rgba(0, 123, 255, 0); }
    100% { box-shadow: 0 0 0 0 rgba(0, 123, 255, 0); }
}

/* ICD Diagnosis Section Styles */
.diagnosis-item {
    border: 1px solid #ddd;
    border-radius: 6px;
    padding: 15px;
    margin-bottom: 15px;
    background-color: #fafafa;
    position: relative;
}

.diagnosis-item:first-child {
    border-color: #5cb85c;
    background-color: #f0f8f0;
}

.diagnosis-item:first-child:before {
    content: "PRIMARY";
    position: absolute;
    top: -8px;
    left: 10px;
    background: #5cb85c;
    color: white;
    padding: 2px 8px;
    border-radius: 10px;
    font-size: 10px;
    font-weight: bold;
}

.diagnosis-select {
    font-family: 'Courier New', monospace;
}

.diagnosis-info {
    color: #666;
    font-style: italic;
}

.icd-code-badge {
    display: inline-block;
    background: #007bff;
    color: white;
    padding: 2px 6px;
    border-radius: 3px;
    font-size: 10px;
    font-weight: bold;
    margin-right: 5px;
}

.diagnosis-category {
    color: #666;
    font-size: 11px;
}

/* Select2 customization for diagnosis */
.select2-container--default .select2-selection--single {
    height: 34px;
    border: 1px solid #d2d6de;
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 32px;
    padding-left: 8px;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 32px;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .consultation-patient-card .row {
        margin: 0;
    }
    
    .consultation-patient-card .col-md-3,
    .consultation-patient-card .col-md-6,
    .consultation-patient-card .col-md-9 {
        padding: 5px;
    }
    
    .btn-group-vertical {
        width: 100% !important;
    }
    
    .verification-controls .btn {
        width: 100%;
        margin-bottom: 8px !important;
    }
    
    .diagnosis-item .col-md-8,
    .diagnosis-item .col-md-3,
    .diagnosis-item .col-md-1 {
        margin-bottom: 10px;
    }
}
</style>

<script type="text/javascript">
$(document).ready(function() {
    
    // =============================================
    // CONSULTATION-SPECIFIC SECUGEN CONFIGURATION
    // =============================================
    
    // Inherit SecuGen configuration from existing system
    var consultationSecugenConfig = {
        baseUrl: 'https://localhost:8443',
        httpUrl: 'http://localhost:8443',
        endpoints: {
            capture: '/SGIFPCapture',
            getInfo: '/SGIFPGetInfo',
            getVersion: '/SGIFPGetVersion'
        },
        serviceActive: false,
        quality: 50,
        timeout: 20000,
        lastError: null,
        verificationRequired: true // Consultation requires verification by default
    };

    // Global consultation state
    window.consultationState = {
        selectedPatientId: null,
        storedTemplate: null,
        liveTemplate: null,
        currentMatchScore: 0,
        verificationPassed: false,
        verificationHistory: [],
        diagnosisIndex: 1 // Start from 1 since 0 is the primary diagnosis
    };

    // =============================================
    // PATIENT SEARCH AND DETAILS FUNCTIONALITY
    // =============================================
    
    // Initialize patient search dropdown
    function initializePatientSearch() {
        $('.patient_list_ajax').select2({
            placeholder: "Search for a patient...",
            allowClear: true,
            minimumInputLength: 2,
            ajax: {
                url: '<?php echo base_url(); ?>admin/patient/searchByName',
                dataType: 'json',
                delay: 300,
                data: function (params) {
                    return {
                        q: params.term,
                        page: params.page || 1
                    };
                },
                processResults: function (data) {
                    return {
                        results: data.results || [],
                        pagination: {
                            more: data.pagination && data.pagination.more
                        }
                    };
                },
                cache: true
            },
            templateResult: function(patient) {
                if (patient.loading) return patient.text;
                
                return $(`
                    <div class="patient-search-result">
                        <div><strong>${patient.text}</strong></div>
                        <div><small class="text-muted">ID: ${patient.id} | Phone: ${patient.phone || 'N/A'}</small></div>
                    </div>
                `);
            }
        });
    }
    
    // Enhanced patient search for consultation
    window.get_PatientDetailsForConsultation = function(id) {
        var base_url = "<?php echo base_url(); ?>backend/images/loading.gif";
        $("#ajax_load").html("<center><img src='" + base_url + "'/></center>");
        
        if(id == '') {
            $("#ajax_load").html("");
            $("#consultationPatientDetails").hide();
            clearConsultationForm();
            return;
        }
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/patientDetails',
            type: "POST",
            data: {id: id},
            dataType: 'json',
            success: function (res) {
                if (res) {
                    $("#ajax_load").html("");
                    $("#consultationPatientDetails").show();
                    
                    // Store patient ID globally
                    window.consultationState.selectedPatientId = id;
                    
                    // Populate patient details
                    populateConsultationPatientDetails(res);
                    
                    // Load fingerprint data
                    loadPatientFingerprintData(id);
                    
                    // Load recent consultations
                    loadRecentConsultations(id);
                    
                    // Store patient ID
                    $('#consultation_patient_id_hidden').val(id);
                    
                    // Reset verification status
                    resetVerificationStatus();
                    
                } else {
                    $("#ajax_load").html("");
                    $("#consultationPatientDetails").hide();
                    clearConsultationForm();
                }
            },
            error: function() {
                $("#ajax_load").html("");
                showConsultationAlert('Failed to load patient details', 'danger');
            }
        });
    };
    
    // Populate patient details in consultation view
    function populateConsultationPatientDetails(patientData) {
        $('#consultation_patient_name').html(patientData.patient_name + " (" + patientData.id + ")");
        $('#consultation_patient_id').html("ID: " + patientData.id);
        $('#consultation_guardian').html(patientData.guardian_name || 'N/A');
        $('#consultation_gender').html(patientData.gender || 'N/A');
        $('#consultation_blood_group').html(patientData.blood_group_name || 'N/A');
        $('#consultation_marital_status').html(patientData.marital_status || 'N/A');
        $('#consultation_age').html(patientData.patient_age || 'N/A');
        $('#consultation_as_of_date').html(patientData.as_of_date || '');
        $('#consultation_phone').html(patientData.mobileno || 'N/A');
        $('#consultation_email').html(patientData.email || 'N/A');
        $('#consultation_address').html(patientData.address || 'N/A');
        $('#consultation_allergies').html(patientData.known_allergies || 'None');
        $('#consultation_notes').html(patientData.note || 'None');
        
        // Set patient image
        if(patientData.image != null) {
            $("#consultation_patient_image").attr("src", '<?php echo base_url() ?>' + patientData.image + '<?php echo img_time(); ?>');
        } else {
            $("#consultation_patient_image").attr("src", '<?php echo base_url() ?>uploads/patient_images/no_image.png');
        }
    }
    
    // Load patient fingerprint data for verification
    function loadPatientFingerprintData(patientId) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/getFingerprintData',
            type: 'POST',
            data: { patient_id: patientId },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    const data = response.data;
                    
                    if (data.fingerprint_template && data.fingerprint_template.length > 0) {
                        $('#consultation_fingerprint_template').val(data.fingerprint_template);
                        window.consultationState.storedTemplate = data.fingerprint_template;
                        
                        $('#consultation_verification_status').html(`
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle"></i> 
                                <strong>Fingerprint on file</strong> - Please verify patient identity before consultation
                            </div>
                        `);
                        
                        if (data.fingerprint_image) {
                            $('#consultation_fingerprint_image').val(data.fingerprint_image);
                            $('#consultation_fingerprint_img').attr('src', 'data:image/bmp;base64,' + data.fingerprint_image);
                        }
                        
                        // Enable verification button
                        $('#verifyPatientIdentity').prop('disabled', false);
                        
                    } else {
                        $('#consultation_verification_status').html(`
                            <div class="alert alert-warning">
                                <i class="fa fa-exclamation-triangle"></i> 
                                <strong>No fingerprint on file</strong> - Verification cannot be performed. Admin override required.
                            </div>
                        `);
                        
                        // Disable verification, but allow admin override
                        $('#verifyPatientIdentity').prop('disabled', true);
                    }
                } else {
                    $('#consultation_verification_status').html(`
                        <div class="alert alert-danger">
                            <i class="fa fa-exclamation-circle"></i> 
                            Failed to load fingerprint data
                        </div>
                    `);
                }
            },
            error: function() {
                $('#consultation_verification_status').html(`
                    <div class="alert alert-danger">
                        <i class="fa fa-exclamation-circle"></i> 
                        Failed to connect to verification service
                    </div>
                `);
            }
        });
    }
    
    // Load recent consultations for the patient
    function loadRecentConsultations(patientId) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/consultation/getPatientConsultations',
            type: 'POST',
            data: { patient_id: patientId, limit: 5 },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success' && response.consultations.length > 0) {
                    let consultationsHtml = '';
                    response.consultations.forEach(function(consultation) {
                        consultationsHtml += `
                            <div class="recent-consultation-item" onclick="viewConsultationWithDiagnosis(${consultation.id})">
                                <div class="row">
                                    <div class="col-xs-8">
                                        <strong>${new Date(consultation.date).toLocaleDateString()}</strong><br>
                                        <small class="text-muted">Dr. ${consultation.doctor_name}</small><br>
                                        <span class="text-primary">${consultation.symptoms.substring(0, 50)}...</span>
                                        ${consultation.primary_diagnosis ? '<br><span class="icd-code-badge">' + consultation.primary_diagnosis + '</span>' : ''}
                                    </div>
                                    <div class="col-xs-4 text-right">
                                        <small class="text-muted">${consultation.created_at}</small>
                                    </div>
                                </div>
                            </div>
                        `;
                    });
                    $('#recent_consultations').html(consultationsHtml);
                } else {
                    $('#recent_consultations').html('<p class="text-muted text-center">No previous consultations found</p>');
                }
            },
            error: function() {
                $('#recent_consultations').html('<p class="text-danger text-center">Failed to load consultation history</p>');
            }
        });
    }
    
    // =============================================
    // FINGERPRINT VERIFICATION FOR CONSULTATION
    // =============================================
    
    // Verify patient identity for consultation
    $('#verifyPatientIdentity').on('click', function() {
        const patientId = $('#consultation_patient_id_hidden').val();
        const storedTemplate = $('#consultation_fingerprint_template').val();
        
        if (!patientId || !storedTemplate) {
            showConsultationAlert('Cannot verify - missing patient data or fingerprint template', 'danger');
            return;
        }
        
        $(this).prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Verifying...');
        $('#consultation_verification_status').html(`
            <div class="alert alert-info">
                <i class="fa fa-spinner fa-spin"></i> Please place finger on scanner for verification...
            </div>
        `);
        
        // Perform verification
        performConsultationVerification(patientId, storedTemplate);
    });
    
    // Perform fingerprint verification for consultation
    function performConsultationVerification(patientId, storedTemplate) {
        const captureUrl = consultationSecugenConfig.baseUrl + consultationSecugenConfig.endpoints.capture;
        
        $.ajax({
            url: captureUrl,
            type: 'POST',
            data: {
                Quality: consultationSecugenConfig.quality,
                Timeout: consultationSecugenConfig.timeout,
                WSQCompression: 2.25
            },
            timeout: consultationSecugenConfig.timeout + 5000,
            success: function(response) {
                const result = typeof response === 'string' ? JSON.parse(response) : response;
                handleConsultationVerificationResult(result, storedTemplate, patientId);
            },
            error: function(xhr, status, error) {
                handleConsultationVerificationError(error);
            }
        });
    }
    
    // Handle consultation verification result
    function handleConsultationVerificationResult(captureResult, storedTemplate, patientId) {
        $('#verifyPatientIdentity').prop('disabled', false).html('<i class="fa fa-check"></i> Verify Patient Identity');
        
        if (captureResult.ErrorCode === 0 && captureResult.TemplateBase64) {
            window.consultationState.liveTemplate = captureResult.TemplateBase64;
            
            // Perform template matching
            performConsultationTemplateMatching(captureResult.TemplateBase64, storedTemplate, patientId);
        } else {
            $('#consultation_verification_status').html(`
                <div class="alert alert-danger">
                    <i class="fa fa-exclamation-triangle"></i> 
                    Fingerprint capture failed: ${captureResult.ErrorDescription || 'Unknown error'}
                </div>
            `);
        }
    }
    
    // Handle consultation verification error
    function handleConsultationVerificationError(error) {
        $('#verifyPatientIdentity').prop('disabled', false).html('<i class="fa fa-check"></i> Verify Patient Identity');
        $('#consultation_verification_status').html(`
            <div class="alert alert-danger">
                <i class="fa fa-exclamation-triangle"></i> 
                Verification failed: ${error}. Try manual capture or check scanner connection.
            </div>
        `);
    }
    
    // Perform template matching for consultation
    function performConsultationTemplateMatching(capturedTemplate, storedTemplate, patientId) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/verifyFingerprint',
            type: 'POST',
            data: {
                patient_id: patientId,
                captured_template: capturedTemplate,
                stored_template: storedTemplate,
                context: 'consultation'
            },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success' && response.is_matched) {
                    // Verification successful
                    window.consultationState.verificationPassed = true;
                    window.consultationState.currentMatchScore = response.matching_score;
                    
                    $('#consultation_verification_passed').val('1');
                    $('#consultation_verification_status').html(`
                        <div class="alert alert-success">
                            <i class="fa fa-check-circle"></i> 
                            <strong>Identity Verified Successfully!</strong><br>
                            Match Score: ${response.matching_score} - Patient identity confirmed
                        </div>
                    `);
                    
                    // Enable consultation button
                    $('#startConsultationBtn').prop('disabled', false);
                    
                    // Show success animation
                    showVerificationSuccessAnimation();
                    
                    // Add to verification history
                    addToVerificationHistory(response.matching_score, true, 'SecuGen Template Matching');
                    
                } else {
                    // Verification failed
                    $('#consultation_verification_status').html(`
                        <div class="alert alert-danger">
                            <i class="fa fa-times-circle"></i> 
                            <strong>Identity Verification Failed</strong><br>
                            Score: ${response.matching_score || 0} - Please try again or contact administrator
                        </div>
                    `);
                    
                    // Add to verification history
                    addToVerificationHistory(response.matching_score || 0, false, 'SecuGen Template Matching');
                }
            },
            error: function() {
                $('#consultation_verification_status').html(`
                    <div class="alert alert-danger">
                        <i class="fa fa-exclamation-circle"></i> 
                        Verification service error - please try again
                    </div>
                `);
            }
        });
    }
    
    // Skip verification (admin only)
    $('#skipVerification').on('click', function() {
        if (confirm('Are you sure you want to skip identity verification? This should only be done by authorized administrators.')) {
            window.consultationState.verificationPassed = false;
            $('#consultation_verification_passed').val('0');
            $('#consultation_verification_status').html(`
                <div class="alert alert-warning">
                    <i class="fa fa-exclamation-triangle"></i> 
                    <strong>Verification Skipped</strong> - Admin override applied
                </div>
            `);
            
            // Enable consultation button
            $('#startConsultationBtn').prop('disabled', false);
            
            // Add to verification history
            addToVerificationHistory(0, false, 'Admin Override - Verification Skipped');
        }
    });
    
    // Manual capture for consultation
    $('#consultation_manual_capture').on('click', function() {
        manualConsultationCapture();
    });
    
    // Manual capture function
    function manualConsultationCapture() {
        const patientId = $('#consultation_patient_id_hidden').val();
        const storedTemplate = $('#consultation_fingerprint_template').val();
        
        if (!patientId || !storedTemplate) {
            showConsultationAlert('Cannot verify - missing patient data', 'danger');
            return;
        }
        
        $('#consultation_manual_capture').prop('disabled', true).text('Capturing...');
        $('#consultation_verification_status').html(`
            <div class="alert alert-info">
                <i class="fa fa-spinner fa-spin"></i> Manual capture - place finger on scanner...
            </div>
        `);
        
        const captureUrl = consultationSecugenConfig.baseUrl + consultationSecugenConfig.endpoints.capture;
        
        const xhr = new XMLHttpRequest();
        xhr.open('POST', captureUrl, true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.timeout = consultationSecugenConfig.timeout;
        
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                $('#consultation_manual_capture').prop('disabled', false).html('<i class="fa fa-hand-pointer-o"></i> Manual');
                
                if (xhr.status === 200) {
                    try {
                        const result = JSON.parse(xhr.responseText);
                        handleConsultationVerificationResult(result, storedTemplate, patientId);
                    } catch (e) {
                        $('#consultation_verification_status').html(`
                            <div class="alert alert-danger">Invalid response from scanner</div>
                        `);
                    }
                } else {
                    $('#consultation_verification_status').html(`
                        <div class="alert alert-danger">Manual capture failed: HTTP ${xhr.status}</div>
                    `);
                }
            }
        };
        
        const postData = `Quality=${consultationSecugenConfig.quality}&Timeout=${consultationSecugenConfig.timeout}&WSQCompression=2.25`;
        xhr.send(postData);
    }
    
    // Test connection for consultation
    $('#consultation_test_connection').on('click', function() {
        testConsultationConnection();
    });
    
    function testConsultationConnection() {
        $('#consultation_test_connection').prop('disabled', true).text('Testing...');
        
        $.ajax({
            url: consultationSecugenConfig.baseUrl + consultationSecugenConfig.endpoints.getInfo,
            type: 'GET',
            timeout: 5000,
            success: function() {
                consultationSecugenConfig.serviceActive = true;
                $('#consultation_secugen_service_status').html(`
                    <div class="alert alert-success">
                        <i class="fa fa-check-circle"></i> Scanner connection successful
                    </div>
                `);
                $('#verifyPatientIdentity').prop('disabled', false);
            },
            error: function() {
                $('#consultation_secugen_service_status').html(`
                    <div class="alert alert-danger">
                        <i class="fa fa-exclamation-circle"></i> Scanner not connected - check device and drivers
                    </div>
                `);
            },
            complete: function() {
                $('#consultation_test_connection').prop('disabled', false).html('<i class="fa fa-wrench"></i> Test');
            }
        });
    }
    
    // =============================================
    // ICD DIAGNOSIS MANAGEMENT
    // =============================================
    
    // Initialize diagnosis select2 dropdowns
    function initializeDiagnosisSelect(index) {
        const selectElement = $(`.diagnosis-select[data-index="${index}"]`);
        
        selectElement.select2({
            placeholder: "Type to search diagnosis codes...",
            allowClear: true,
            minimumInputLength: 2,
            ajax: {
                url: '<?php echo base_url(); ?>admin/diagnosis/searchForConsultation',
                dataType: 'json',
                delay: 300,
                data: function (params) {
                    return {
                        q: params.term,
                        icd_version: $('#icd_version_filter').val(),
                        category: $('#diagnosis_category_filter').val()
                    };
                },
                processResults: function (data) {
                    return {
                        results: data.results
                    };
                },
                cache: true
            },
            templateResult: function(item) {
                if (item.loading) return item.text;
                
                return $(`
                    <div>
                        <div>
                            <span class="icd-code-badge">${item.code}</span>
                            <strong>${item.title}</strong>
                        </div>
                        <div class="diagnosis-category">${item.category || ''}</div>
                        <div><small class="text-muted">${item.description || ''}</small></div>
                    </div>
                `);
            },
            templateSelection: function(item) {
                if (item.code) {
                    // Update diagnosis info
                    $(`.diagnosis-info[data-index="${index}"]`).html(`
                        <span class="icd-code-badge">${item.code}</span>
                        <strong>${item.category}</strong> - ${item.description}
                    `);
                    return `${item.code} - ${item.title}`;
                }
                return item.text;
            }
        });
    }
    
    // Initialize primary diagnosis select
    initializeDiagnosisSelect(0);
    
    // Add new diagnosis
    $('#addDiagnosisBtn').on('click', function() {
        const newDiagnosisHtml = `
            <div class="diagnosis-item" data-index="${window.consultationState.diagnosisIndex}">
                <div class="row">
                    <div class="col-md-8">
                        <div class="form-group">
                            <label>Additional Diagnosis</label>
                            <select name="diagnosis_codes[${window.consultationState.diagnosisIndex}][diagnosis_code_id]" class="form-control diagnosis-select" data-index="${window.consultationState.diagnosisIndex}">
                                <option value="">Search and select diagnosis...</option>
                            </select>
                            <small class="help-block">
                                <span class="diagnosis-info" data-index="${window.consultationState.diagnosisIndex}"></span>
                            </small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Type</label>
                            <select name="diagnosis_codes[${window.consultationState.diagnosisIndex}][type]" class="form-control">
                                <option value="secondary">Secondary</option>
                                <option value="complication">Complication</option>
                                <option value="primary">Primary</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <label>&nbsp;</label><br>
                            <button type="button" class="btn btn-danger btn-sm remove-diagnosis">
                                <i class="fa fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Clinical Notes for this Diagnosis</label>
                            <textarea name="diagnosis_codes[${window.consultationState.diagnosisIndex}][notes]" class="form-control" rows="2" placeholder="Additional notes, severity, complications..."></textarea>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        $('#diagnosis_list_container').append(newDiagnosisHtml);
        initializeDiagnosisSelect(window.consultationState.diagnosisIndex);
        
        // Show remove button for all non-primary diagnoses
        $('.remove-diagnosis').show();
        
        window.consultationState.diagnosisIndex++;
    });
    
    // Remove diagnosis
    $(document).on('click', '.remove-diagnosis', function() {
        if (confirm('Are you sure you want to remove this diagnosis?')) {
            $(this).closest('.diagnosis-item').remove();
            
            // Hide remove button if only primary diagnosis remains
            if ($('.diagnosis-item').length === 1) {
                $('.remove-diagnosis').hide();
            }
        }
    });
    
    // ICD version filter change
    $('#icd_version_filter').on('change', function() {
        // Clear all diagnosis selections
        $('.diagnosis-select').val(null).trigger('change');
        $('.diagnosis-info').html('');
        
        // Show notification
        showConsultationAlert('ICD version changed. Please reselect diagnoses.', 'info');
    });
    
    // Category filter change
    $('#diagnosis_category_filter').on('change', function() {
        // Just update the searches, don't clear selections
        showConsultationAlert('Category filter applied to new searches.', 'info');
    });
    
    // =============================================
    // CONSULTATION MANAGEMENT
    // =============================================
    
    // Start consultation
    $('#startConsultationBtn').on('click', function() {
        const patientId = $('#consultation_patient_id_hidden').val();
        const verificationPassed = $('#consultation_verification_passed').val();
        
        if (!patientId) {
            showConsultationAlert('Please select a patient first', 'warning');
            return;
        }
        
        // Populate modal with patient data
        populateConsultationModal(patientId, verificationPassed);
        
        // Show consultation modal
        $('#consultationModal').modal('show');
    });
    
    // Populate consultation modal
    function populateConsultationModal(patientId, verificationPassed) {
        // Copy patient data to modal
        $('#modal_patient_id').val(patientId);
        $('#modal_verification_status').val(verificationPassed);
        $('#modal_patient_name').text($('#consultation_patient_name').text());
        $('#modal_patient_age').text($('#consultation_age').text());
        $('#modal_patient_gender').text($('#consultation_gender').text());
        $('#modal_patient_phone').text($('#consultation_phone').text());
        $('#modal_patient_blood_group').text($('#consultation_blood_group').text());
        $('#modal_patient_allergies').text($('#consultation_allergies').text());
        
        // Set verification badge
        if (verificationPassed === '1') {
            $('#verification_badge').html('<span class="verification-status-badge verified"><i class="fa fa-shield"></i> Verified</span>');
        } else {
            $('#verification_badge').html('<span class="verification-status-badge skip-verification"><i class="fa fa-exclamation-triangle"></i> Override</span>');
        }
        
        // Clear form
        $('#consultationForm')[0].reset();
        $('#consultation_date').val(new Date().toISOString().split('T')[0]);
        $('#modal_consultation_id').val(''); // Clear for new consultation
        
        // Reset diagnosis section
        resetDiagnosisSection();
    }
    
    // Enhanced consultation form submission with diagnosis
    $('#consultationForm').off('submit').on('submit', function(e) {
        e.preventDefault();
        
        // Validate primary diagnosis
        const primaryDiagnosis = $('select[name="diagnosis_codes[0][diagnosis_code_id]"]').val();
        if (!primaryDiagnosis) {
            showConsultationAlert('Please select at least a primary diagnosis', 'warning');
            return;
        }
        
        const submitBtn = $(e.originalEvent.submitter);
        const isPrint = submitBtn.attr('name') === 'save_print';
        
        submitBtn.prop('disabled', true);
        if (isPrint) {
            submitBtn.html('<i class="fa fa-spinner fa-spin"></i> Saving & Printing...');
        } else {
            submitBtn.html('<i class="fa fa-spinner fa-spin"></i> Saving...');
        }
        
        // Prepare form data including diagnosis codes
        const formData = new FormData(this);
        
        // Add diagnosis data
        $('.diagnosis-item').each(function(index) {
            const diagnosisCodeId = $(this).find('.diagnosis-select').val();
            const diagnosisType = $(this).find('select[name*="[type]"]').val();
            const diagnosisNotes = $(this).find('textarea[name*="[notes]"]').val();
            
            if (diagnosisCodeId) {
                formData.append(`diagnosis_codes[${index}][diagnosis_code_id]`, diagnosisCodeId);
                formData.append(`diagnosis_codes[${index}][type]`, diagnosisType);
                formData.append(`diagnosis_codes[${index}][notes]`, diagnosisNotes);
                formData.append(`diagnosis_codes[${index}][is_primary]`, index === 0 ? '1' : '0');
            }
        });
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/consultation/save',
            type: 'POST',
            data: formData,
            dataType: 'json',
            contentType: false,
            processData: false,
            success: function(response) {
                if (response.status === 'success') {
                    showConsultationAlert(response.message, 'success');
                    $('#consultationModal').modal('hide');
                    
                    // Reload consultation list
                    if ($.fn.DataTable.isDataTable('.consultation_list')) {
                        $('.consultation_list').DataTable().ajax.reload();
                    }
                    
                    // Reload recent consultations
                    const patientId = $('#consultation_patient_id_hidden').val();
                    if (patientId) {
                        loadRecentConsultations(patientId);
                    }
                    
                    // Print if requested
                    if (isPrint && response.consultation_id) {
                        printConsultation(response.consultation_id);
                    }
                    
                } else {
                    showConsultationAlert(response.message || 'Failed to save consultation', 'danger');
                }
            },
            error: function() {
                showConsultationAlert('Error saving consultation', 'danger');
            },
            complete: function() {
                submitBtn.prop('disabled', false);
                if (isPrint) {
                    submitBtn.html('<i class="fa fa-print"></i> Save & Print');
                } else {
                    submitBtn.html('<i class="fa fa-save"></i> Save Consultation');
                }
            }
        });
    });
    
    // =============================================
    // DIAGNOSIS SEARCH FUNCTIONALITY
    // =============================================
    
    // Quick diagnosis search
    $('#searchDiagnosisBtn').on('click', function() {
        const searchTerm = $('#quick_diagnosis_search').val();
        const icdVersion = $('#quick_icd_version').val();
        
        if (!searchTerm.trim()) {
            showConsultationAlert('Please enter a search term', 'warning');
            return;
        }
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/diagnosis/searchForConsultation',
            type: 'POST',
            data: {
                q: searchTerm,
                icd_version: icdVersion
            },
            dataType: 'json',
            success: function(response) {
                if (response.results && response.results.length > 0) {
                    let resultsHtml = '';
                    response.results.forEach(function(item) {
                        resultsHtml += `
                            <div class="diagnosis-search-result" style="border: 1px solid #ddd; padding: 10px; margin: 5px 0; border-radius: 4px; cursor: pointer;" onclick="selectDiagnosisCode('${item.code}', '${item.title}')">
                                <div>
                                    <span class="icd-code-badge">${item.code}</span>
                                    <strong>${item.title}</strong>
                                </div>
                                <div class="text-muted">${item.description || ''}</div>
                                <div class="diagnosis-category">${item.category || ''}</div>
                            </div>
                        `;
                    });
                    
                    $('#diagnosis_results_container').html(resultsHtml);
                    $('#diagnosis_search_results').show();
                } else {
                    $('#diagnosis_results_container').html('<p class="text-muted">No diagnosis codes found matching your search.</p>');
                    $('#diagnosis_search_results').show();
                }
            },
            error: function() {
                showConsultationAlert('Error searching diagnosis codes', 'danger');
            }
        });
    });
    
    // Select diagnosis code from search results
    window.selectDiagnosisCode = function(code, title) {
        const info = `Code: ${code} - ${title}`;
        showConsultationAlert(`Selected: ${info}`, 'info');
        
        // Copy to clipboard
        navigator.clipboard.writeText(code).then(function() {
            showConsultationAlert(`Code "${code}" copied to clipboard`, 'success');
        }).catch(function() {
            // Fallback for older browsers
            const textArea = document.createElement("textarea");
            textArea.value = code;
            document.body.appendChild(textArea);
            textArea.select();
            document.execCommand('copy');
            document.body.removeChild(textArea);
        });
    };
    
    // =============================================
    // CONSULTATION LIST MANAGEMENT
    // =============================================
    
    // Initialize consultation list DataTable
    function initializeConsultationTable() {
        if (!$.fn.DataTable.isDataTable('.consultation_list')) {
            $('.consultation_list').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '<?php echo base_url(); ?>admin/consultation/getConsultationList',
                    type: 'POST'
                },
                columns: [
                    { data: 'id' },
                    { data: 'date' },
                    { data: 'patient_name' },
                    { data: 'doctor_name' },
                    { data: 'symptoms' },
                    { data: 'primary_diagnosis' },
                    { data: 'actions', orderable: false }
                ],
                order: [[0, 'desc']],
                pageLength: 25,
                responsive: true
            });
        }
    }
    
    // Enhanced edit consultation function to load diagnosis
    window.editConsultationWithDiagnosis = function(consultationId) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/consultation/getDetailsWithDiagnosis',
            type: 'POST',
            data: { consultation_id: consultationId },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    const consultation = response.consultation;
                    const diagnoses = response.diagnoses || [];
                    
                    // Populate basic form
                    $('#modal_consultation_id').val(consultation.id);
                    $('#modal_patient_id').val(consultation.patient_id);
                    $('#consultation_date').val(consultation.date);
                    $('#consultation_doctor').val(consultation.doctor);
                    $('#consultation_symptoms').val(consultation.symptoms);
                    $('#consultation_diagnosis').val(consultation.diagnosis);
                    $('#consultation_notes').val(consultation.notes);
                    
                    // Reset and populate diagnosis section
                    resetDiagnosisSection();
                    
                    // Load existing diagnoses
                    if (diagnoses.length > 0) {
                        diagnoses.forEach(function(diagnosis, index) {
                            if (index > 0) {
                                // Add additional diagnosis items for secondary diagnoses
                                $('#addDiagnosisBtn').click();
                            }
                            
                            // Set diagnosis values
                            const currentIndex = index;
                            const selectElement = $(`.diagnosis-select[data-index="${currentIndex}"]`);
                            
                            // Create option and select it
                            const option = new Option(
                                `${diagnosis.code} - ${diagnosis.title}`,
                                diagnosis.diagnosis_code_id,
                                true,
                                true
                            );
                            selectElement.append(option).trigger('change');
                            
                            // Set additional fields
                            $(`select[name="diagnosis_codes[${currentIndex}][type]"]`).val(
                                diagnosis.is_primary ? 'primary' : 'secondary'
                            );
                            $(`textarea[name="diagnosis_codes[${currentIndex}][notes]"]`).val(
                                diagnosis.notes || ''
                            );
                            
                            // Update diagnosis info
                            $(`.diagnosis-info[data-index="${currentIndex}"]`).html(`
                                <span class="icd-code-badge">${diagnosis.code}</span>
                                <strong>${diagnosis.category}</strong> - ${diagnosis.description}
                            `);
                        });
                    }
                    
                    // Update modal title
                    $('#consultation_modal_title').text('Edit Consultation');
                    $('#consultation_submit_text').text('Update Consultation');
                    
                    // Show modal
                    $('#consultationModal').modal('show');
                    
                } else {
                    showConsultationAlert('Failed to load consultation for editing', 'danger');
                }
            },
            error: function() {
                showConsultationAlert('Error loading consultation data', 'danger');
            }
        });
    };
    
    // Enhanced view consultation to show diagnosis codes
    window.viewConsultationWithDiagnosis = function(consultationId) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/consultation/getDetailsWithDiagnosis',
            type: 'POST',
            data: { consultation_id: consultationId },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    const consultation = response.consultation;
                    const diagnoses = response.diagnoses || [];
                    
                    let diagnosisHtml = '';
                    if (diagnoses.length > 0) {
                        diagnosisHtml = '<h5><i class="fa fa-stethoscope"></i> Medical Diagnoses (ICD Codes)</h5>';
                        diagnoses.forEach(function(diagnosis, index) {
                            const isPrimary = diagnosis.is_primary == 1;
                            const badgeClass = isPrimary ? 'label-success' : 'label-info';
                            const typeText = isPrimary ? 'Primary' : 'Secondary';
                            
                            diagnosisHtml += `
                                <div class="row" style="margin-bottom: 10px; padding: 10px; background: ${isPrimary ? '#f0f8f0' : '#f8f9fa'}; border-radius: 4px;">
                                    <div class="col-md-12">
                                        <span class="label ${badgeClass}">${typeText}</span>
                                        <strong style="margin-left: 10px;">${diagnosis.code}</strong> - ${diagnosis.title}
                                        <br><small class="text-muted">${diagnosis.description}</small>
                                        <br><span class="text-info"><i class="fa fa-tag"></i> ${diagnosis.category}</span>
                                        ${diagnosis.notes ? `<br><strong>Notes:</strong> ${diagnosis.notes}` : ''}
                                    </div>
                                </div>
                            `;
                        });
                    } else {
                        diagnosisHtml = '<p class="text-muted">No ICD diagnosis codes recorded</p>';
                    }
                    
                    const detailsHtml = `
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered">
                                <tr>
                                    <th width="25%">Consultation ID</th>
                                    <td>${consultation.id}</td>
                                    <th width="25%">Date</th>
                                    <td>${new Date(consultation.date).toLocaleDateString()}</td>
                                </tr>
                                <tr>
                                    <th>Patient</th>
                                    <td>${consultation.patient_name}</td>
                                    <th>Doctor</th>
                                    <td>Dr. ${consultation.doctor_name}</td>
                                </tr>
                                <tr>
                                    <th>Symptoms</th>
                                    <td colspan="3">${consultation.symptoms || 'N/A'}</td>
                                </tr>
                                <tr>
                                    <th>Traditional Diagnosis</th>
                                    <td colspan="3">${consultation.diagnosis || 'N/A'}</td>
                                </tr>
                                <tr>
                                    <th>Clinical Notes</th>
                                    <td colspan="3">${consultation.notes || 'N/A'}</td>
                                </tr>
                                <tr>
                                    <th>Created</th>
                                    <td colspan="3">${new Date(consultation.created_at).toLocaleString()}</td>
                                </tr>
                            </table>
                        </div>
                        <div style="margin-top: 15px;">
                            ${diagnosisHtml}
                        </div>
                    `;
                    
                    $('#consultation_details_content').html(detailsHtml);
                    
                    // Add edit/delete buttons
                    let actionButtons = '';
                    <?php if ($this->rbac->hasPrivilege('consultation', 'can_edit')) { ?>
                        actionButtons += `<a href="#" onclick="editConsultationWithDiagnosis(${consultation.id})" data-toggle="tooltip" title="Edit"><i class="fa fa-pencil"></i></a> `;
                    <?php } ?>
                    <?php if ($this->rbac->hasPrivilege('consultation', 'can_delete')) { ?>
                        actionButtons += `<a href="#" onclick="deleteConsultation(${consultation.id})" data-toggle="tooltip" title="Delete"><i class="fa fa-trash"></i></a> `;
                    <?php } ?>
                    actionButtons += `<a href="#" onclick="printConsultation(${consultation.id})" data-toggle="tooltip" title="Print"><i class="fa fa-print"></i></a>`;
                    
                    $('#consultation_edit_delete').html(actionButtons);
                    $('#viewConsultationModal').modal('show');
                    
                } else {
                    showConsultationAlert('Failed to load consultation details', 'danger');
                }
            },
            error: function() {
                showConsultationAlert('Error loading consultation details', 'danger');
            }
        });
    };
    
    // Delete consultation
    window.deleteConsultation = function(consultationId) {
        if (confirm('Are you sure you want to delete this consultation? This action cannot be undone.')) {
            $.ajax({
                url: '<?php echo base_url(); ?>admin/consultation/delete',
                type: 'POST',
                data: { consultation_id: consultationId },
                dataType: 'json',
                success: function(response) {
                    if (response.status === 'success') {
                        showConsultationAlert(response.message, 'success');
                        $('#viewConsultationModal').modal('hide');
                        
                        // Reload consultation list
                        if ($.fn.DataTable.isDataTable('.consultation_list')) {
                            $('.consultation_list').DataTable().ajax.reload();
                        }
                        
                        // Reload recent consultations if patient is selected
                        const patientId = $('#consultation_patient_id_hidden').val();
                        if (patientId) {
                            loadRecentConsultations(patientId);
                        }
                    } else {
                        showConsultationAlert(response.message || 'Failed to delete consultation', 'danger');
                    }
                },
                error: function() {
                    showConsultationAlert('Error deleting consultation', 'danger');
                }
            });
        }
    };
    
    // Print consultation
    window.printConsultation = function(consultationId) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/consultation/printConsultation',
            type: 'POST',
            data: { consultation_id: consultationId },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    // Open print window
                    const printWindow = window.open('', '_blank');
                    printWindow.document.write(response.print_data);
                    printWindow.document.close();
                    printWindow.print();
                } else {
                    showConsultationAlert('Failed to generate print data', 'danger');
                }
            },
            error: function() {
                showConsultationAlert('Error generating print data', 'danger');
            }
        });
    };
    
    // =============================================
    // UTILITY FUNCTIONS
    // =============================================
    
    // Show consultation alert
    function showConsultationAlert(message, type) {
        const alertId = 'consultation-alert-' + Date.now();
        const alertHtml = `
            <div id="${alertId}" class="alert alert-${type} alert-dismissible" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px;">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <strong>${type.charAt(0).toUpperCase() + type.slice(1)}:</strong> ${message}
            </div>
        `;
        
        $('body').append(alertHtml);
        
        setTimeout(() => {
            $('#' + alertId).fadeOut(() => {
                $('#' + alertId).remove();
            });
        }, 5000);
    }
    
    // Show verification success animation
    function showVerificationSuccessAnimation() {
        // Add a subtle animation to the start consultation button
        $('#startConsultationBtn').addClass('btn-success').removeClass('btn-primary');
        setTimeout(() => {
            $('#startConsultationBtn').addClass('btn-primary').removeClass('btn-success');
        }, 2000);
    }
    
    // Reset verification status
    function resetVerificationStatus() {
        window.consultationState.verificationPassed = false;
        window.consultationState.currentMatchScore = 0;
        window.consultationState.storedTemplate = null;
        window.consultationState.liveTemplate = null;
        
        $('#consultation_verification_passed').val('0');
        $('#consultation_verification_status').html('');
        $('#startConsultationBtn').prop('disabled', true);
        $('#consultation_fingerprint_template').val('');
        $('#consultation_fingerprint_image').val('');
        $('#consultation_fingerprint_img').attr('src', './Images/PlaceFinger.bmp');
    }
    
    // Clear consultation form
    function clearConsultationForm() {
        window.consultationState.selectedPatientId = null;
        $('#consultation_patient_id_hidden').val('');
        $('#recent_consultations').html('<p class="text-muted text-center">Select a patient to view consultation history</p>');
        resetVerificationStatus();
    }
    
    // Reset diagnosis section
    function resetDiagnosisSection() {
        // Remove all additional diagnosis items
        $('.diagnosis-item[data-index!="0"]').remove();
        
        // Reset primary diagnosis
        $('.diagnosis-select[data-index="0"]').val(null).trigger('change');
        $('.diagnosis-info[data-index="0"]').html('');
        $('textarea[name="diagnosis_codes[0][notes]"]').val('');
        $('select[name="diagnosis_codes[0][type]"]').val('primary');
        
        // Hide remove buttons
        $('.remove-diagnosis').hide();
        
        // Reset diagnosis counter
        window.consultationState.diagnosisIndex = 1;
    }
    
    // Add to verification history
    function addToVerificationHistory(score, success, method) {
        const timestamp = new Date().toLocaleString();
        window.consultationState.verificationHistory.push({
            timestamp: timestamp,
            score: score,
            success: success,
            method: method
        });
        
        // Keep only last 10 records
        if (window.consultationState.verificationHistory.length > 10) {
            window.consultationState.verificationHistory.shift();
        }
    }
    
    // Modal reset when closed
    $('#consultationModal').on('hidden.bs.modal', function() {
        $('#consultationForm')[0].reset();
        $('#modal_consultation_id').val('');
        $('#consultation_modal_title').text('New Consultation');
        $('#consultation_submit_text').text('Save Consultation');
        
        // Reset diagnosis section
        resetDiagnosisSection();
    });
    
    // =============================================
    // INITIALIZATION
    // =============================================
    
    // Initialize components
    initializePatientSearch();
    initializeConsultationTable();
    
    // Initialize SecuGen service detection
    setTimeout(function() {
        testConsultationConnection();
    }, 2000);
    
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    // Debug functions
    window.debugConsultationSystem = function() {
        console.log('=== CONSULTATION SYSTEM DEBUG ===');
        console.log('Selected Patient ID:', window.consultationState.selectedPatientId);
        console.log('Verification Passed:', window.consultationState.verificationPassed);
        console.log('Current Match Score:', window.consultationState.currentMatchScore);
        console.log('Stored Template Length:', window.consultationState.storedTemplate ? window.consultationState.storedTemplate.length : 0);
        console.log('Live Template Length:', window.consultationState.liveTemplate ? window.consultationState.liveTemplate.length : 0);
        console.log('Verification History:', window.consultationState.verificationHistory);
        console.log('Diagnosis Index:', window.consultationState.diagnosisIndex);
        console.log('SecuGen Service Active:', consultationSecugenConfig.serviceActive);
        
        // Test components
        console.log('Testing patient search...');
        if ($('#consultation_patient_search').length) {
            console.log('✓ Patient search dropdown found');
        } else {
            console.log('✗ Patient search dropdown not found');
        }
        
        console.log('Testing diagnosis system...');
        $('.diagnosis-item').each(function(index) {
            const diagnosisValue = $(this).find('.diagnosis-select').val();
            const diagnosisText = $(this).find('.diagnosis-select').select2('data');
            console.log(`Diagnosis ${index}:`, {
                value: diagnosisValue,
                text: diagnosisText,
                type: $(this).find('select[name*="[type]"]').val(),
                notes: $(this).find('textarea[name*="[notes]"]').val()
            });
        });
    };
    
    console.log('Enhanced consultation system with fingerprint verification and ICD diagnosis codes initialized successfully');
    console.log('Available debug functions: debugConsultationSystem()');
});

// Helper function for modal management
function holdModal(modalId) {
    $('#' + modalId).modal({
        backdrop: 'static',
        keyboard: false,
        show: true
    });
}
</script>

<!-- Include patient add modal -->
<?php $this->load->view('admin/patient/patientaddmodal'); ?>

<!-- Include Select2 CSS and JS if not already included -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

<!-- Include DataTables CSS and JS if not already included -->
<link rel="stylesheet" type="text/css" href="<?php echo base_url(); ?>backend/plugins/datatables/dataTables.bootstrap.css">
<script type="text/javascript" src="<?php echo base_url(); ?>backend/plugins/datatables/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="<?php echo base_url(); ?>backend/plugins/datatables/dataTables.bootstrap.min.js"></script>