<link rel="stylesheet" href="<?php echo base_url();?>backend/dist/css/jquery-ui.css">
<style>
    .content-wrapper { background-color: #ecf0f5; }
    
    .billing-header {
        background: linear-gradient(135deg, #00a65a 0%, #00c0ef 100%);
        color: white; padding: 20px; border-radius: 8px; margin-bottom: 20px;
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    
    .patient-type-card {
        background: white; border-radius: 8px; padding: 20px; margin-bottom: 15px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1); border-left: 4px solid #00a65a;
        transition: all 0.3s ease;
    }
    
    .patient-type-card:hover {
        transform: translateY(-2px); box-shadow: 0 4px 15px rgba(0,166,90,0.2);
    }
    
    .type-gcc { border-left-color: #17a2b8; }
    .type-general { border-left-color: #28a745; }
    .type-specialized { border-left-color: #dc3545; }
    
    .type-icon {
        width: 50px; height: 50px; border-radius: 50%;
        display: inline-flex; align-items: center; justify-content: center;
        margin-right: 15px; color: white; font-size: 20px;
    }
    
    .icon-gcc { background: #17a2b8; }
    .icon-general { background: #28a745; }
    .icon-specialized { background: #dc3545; }
    
    .billing-section {
        background: linear-gradient(145deg, #f9f9f9, #ffffff);
        border: 2px solid #00a65a; border-radius: 8px; padding: 25px;
        box-shadow: 0 4px 12px rgba(0,166,90,0.15); margin-bottom: 20px;
    }
    
    .search-container {
        position: relative;
    }
    
    .patient-suggestions {
        position: absolute; top: 100%; left: 0; right: 0;
        background: white; border: 1px solid #ddd; border-top: none;
        border-radius: 0 0 6px 6px; max-height: 200px; overflow-y: auto;
        z-index: 1000; display: none;
    }
    
    .suggestion-item {
        padding: 10px 15px; border-bottom: 1px solid #f0f0f0;
        cursor: pointer; transition: background-color 0.3s ease;
    }
    
    .suggestion-item:hover {
        background-color: #f8f9fa;
    }
    
    .suggestion-item:last-child {
        border-bottom: none;
    }
    
    .stats-card {
        background: white; border-radius: 8px; padding: 20px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1); margin-bottom: 20px;
        border-left: 4px solid #00a65a;
    }
    
    .stats-number {
        font-size: 24px; font-weight: bold; color: #00a65a;
    }
    
    .stats-label {
        color: #777; font-size: 14px; margin-top: 5px;
    }
    
    .workflow-step {
        padding: 15px; border-bottom: 1px solid #f4f4f4; display: flex;
        align-items: center; transition: background-color 0.3s ease;
    }
    
    .workflow-step:hover { background-color: #f9f9f9; }
    .workflow-step:last-child { border-bottom: none; }
    
    .step-number {
        background: #00a65a; color: white; width: 30px; height: 30px;
        border-radius: 50%; display: flex; align-items: center;
        justify-content: center; margin-right: 15px; font-weight: bold;
        font-size: 14px; box-shadow: 0 2px 4px rgba(0,166,90,0.3);
    }
    
    .step-content h6 {
        margin: 0 0 5px 0; color: #333; font-weight: 600; font-size: 16px;
    }
    
    .step-content small { color: #777; font-size: 13px; }
    
    .form-control {
        border-radius: 6px; border: 1px solid #ddd;
        transition: border-color 0.3s ease, box-shadow 0.3s ease;
    }
    
    .form-control:focus {
        border-color: #00a65a;
        box-shadow: 0 0 0 0.2rem rgba(0,166,90,0.25);
    }
    
    .btn-billing {
        background: linear-gradient(45deg, #00a65a, #00c0ef);
        color: white; border: none; border-radius: 6px;
        padding: 10px 20px; font-weight: 600;
        transition: all 0.3s ease;
    }
    
    .btn-billing:hover {
        transform: translateY(-1px); box-shadow: 0 4px 8px rgba(0,166,90,0.3);
        color: white;
    }
    
    .recent-activity {
        max-height: 300px; overflow-y: auto;
    }
    
    .activity-item {
        padding: 10px 0; border-bottom: 1px solid #f0f0f0;
    }
    
    .activity-time {
        color: #777; font-size: 12px;
    }
    
    .invoice-status {
        padding: 4px 8px; border-radius: 4px; font-size: 12px; font-weight: bold;
    }
    
    .status-paid { background: #d4edda; color: #155724; }
    .status-partial { background: #fff3cd; color: #856404; }
    .status-pending { background: #f8d7da; color: #721c24; }
</style>

<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-calculator"></i> Unified Billing System
            <small>Comprehensive billing for all patient types</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Billing</li>
        </ol>
    </section>

    <section class="content">
        <!-- Billing Header -->
        <div class="billing-header">
            <div class="row">
                <div class="col-md-8">
                    <h3><i class="fa fa-users"></i> Patient-Centered Billing</h3>
                    <p class="margin-bottom-none">Search for any patient and manage their complete billing lifecycle from consultation to payment</p>
                </div>
                <div class="col-md-4 text-right">
                    <div class="stats-summary">
                        <div class="stats-number"><?php echo isset($billing_stats['total_invoices_today']) ? $billing_stats['total_invoices_today'] : 0; ?></div>
                        <div class="stats-label">Today's Invoices</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Patient Types Information -->
        <div class="row">
            <div class="col-md-4">
                <div class="patient-type-card type-gcc">
                    <div class="row">
                        <div class="col-md-3">
                            <span class="type-icon icon-gcc">
                                <i class="fa fa-globe"></i>
                            </span>
                        </div>
                        <div class="col-md-9">
                            <h4 style="margin-top: 0; color: #17a2b8;">GCC Patients</h4>
                            <p><strong>Fixed Fee:</strong> KES 10,500</p>
                            <p><small>One-time payment at registration for comprehensive medical examination</small></p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="patient-type-card type-general">
                    <div class="row">
                        <div class="col-md-3">
                            <span class="type-icon icon-general">
                                <i class="fa fa-user"></i>
                            </span>
                        </div>
                        <div class="col-md-9">
                            <h4 style="margin-top: 0; color: #28a745;">General Patients</h4>
                            <p><strong>Consultation:</strong> KES 900</p>
                            <p><small>Plus Lab, Radiology & Pharmacy charges per service</small></p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="patient-type-card type-specialized">
                    <div class="row">
                        <div class="col-md-3">
                            <span class="type-icon icon-specialized">
                                <i class="fa fa-user-md"></i>
                            </span>
                        </div>
                        <div class="col-md-9">
                            <h4 style="margin-top: 0; color: #dc3545;">Specialized Patients</h4>
                            <p><strong>Consultation:</strong> KES 1,500</p>
                            <p><small>Dental, Optical & other procedures plus additional costs</small></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Patient Search Section -->
        <div class="row">
            <div class="col-md-8">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title titlefix">
                            <i class="fa fa-search"></i> Patient Billing Lookup
                        </h3>
                    </div>
                    <div class="billing-section">
                        <form action="<?php echo base_url()?>admin/bill/dashboard" accept-charset="utf-8" method="post" class="form-inline">
                            <?php echo $this->customlib->getCSRF(); ?>
                            <div class="form-group align-top">
                                <div class="search-container"> 
                                    <label><i class="fa fa-user"></i> Search Patient</label>
                                    <small class="req"> *</small>
                                    <input type="text" name="patient_search" class="form-control" id="patient_search" 
                                           placeholder="Enter patient name, ID, or phone number..." autocomplete="off">
                                    <input type="hidden" name="patient_id" id="selected_patient_id">
                                    <div class="patient-suggestions" id="patient_suggestions"></div>
                                    <span class="text-danger"><?php echo form_error('patient_id'); ?></span>
                                </div>    
                            </div>
                            <div class="form-group">
                                <div> 
                                    <button type="submit" id="search_btn" value="search_filter" 
                                            class="btn btn-billing btn-sm" disabled>
                                        <i class="fa fa-search"></i> View Billing
                                    </button>   
                                </div>     
                            </div> 
                            <?php if(!empty($error_message)): ?>
                                <div class="alert alert-danger" style="margin-top: 15px;">
                                    <i class="fa fa-exclamation-triangle"></i> <?php echo $error_message;?>
                                </div>
                            <?php endif; ?>
                        </form>
                        
                        <div class="text-center" style="margin-top: 20px;">
                            <small class="text-muted">
                                <i class="fa fa-info-circle"></i> Search by patient name, unique ID, or phone number to access their billing information
                            </small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Statistics -->
            <div class="col-md-4">
                <div class="stats-card">
                    <div class="stats-number">KES <?php echo number_format(isset($billing_stats['total_payments_today']) ? $billing_stats['total_payments_today'] : 0); ?></div>
                    <div class="stats-label">Today's Collections</div>
                </div>
                <div class="stats-card">
                    <div class="stats-number"><?php echo isset($billing_stats['pending_invoices']) ? $billing_stats['pending_invoices'] : 0; ?></div>
                    <div class="stats-label">Pending Invoices</div>
                </div>
            </div>
        </div>

        <!-- Unified Billing Workflow -->
        <div class="box box-success">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-sitemap"></i> Unified Billing Process</h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="workflow-step">
                            <div class="step-number">1</div>
                            <div class="step-content">
                                <h6>Patient Registration</h6>
                                <small>Patient is registered and type is determined (GCC/General/Specialized)</small>
                            </div>
                        </div>
                        <div class="workflow-step">
                            <div class="step-number">2</div>
                            <div class="step-content">
                                <h6>Service Delivery</h6>
                                <small>Patient receives consultation and/or other medical services</small>
                            </div>
                        </div>
                        <div class="workflow-step">
                            <div class="step-number">3</div>
                            <div class="step-content">
                                <h6>Charge Calculation</h6>
                                <small>System calculates charges based on patient type and services received</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="workflow-step">
                            <div class="step-number">4</div>
                            <div class="step-content">
                                <h6>Invoice Generation</h6>
                                <small>Consolidated invoice is generated for all services</small>
                            </div>
                        </div>
                        <div class="workflow-step">
                            <div class="step-number">5</div>
                            <div class="step-content">
                                <h6>Payment Processing</h6>
                                <small>Payments are recorded and invoice status is updated</small>
                            </div>
                        </div>
                        <div class="workflow-step">
                            <div class="step-number">6</div>
                            <div class="step-content">
                                <h6>Receipt & Archive</h6>
                                <small>Receipt is generated and documents are archived</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Activity & Quick Actions -->
        <div class="row">
            <div class="col-md-4">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-bolt"></i> Quick Actions</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-12">
                                <a href="<?php echo base_url('admin/bill/reports'); ?>" class="btn btn-info btn-block btn-sm">
                                    <i class="fa fa-chart-bar"></i> Billing Reports
                                </a>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 10px;">
                            <div class="col-md-12">
                                <a href="<?php echo base_url('admin/bill/download_center'); ?>" class="btn btn-success btn-block btn-sm">
                                    <i class="fa fa-download"></i> Download Center
                                </a>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 10px;">
                            <div class="col-md-12">
                                <button class="btn btn-warning btn-block btn-sm" onclick="generateDailyReport()">
                                    <i class="fa fa-file-pdf-o"></i> Daily Summary
                                </button>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 10px;">
                            <div class="col-md-12">
                                <a href="<?php echo base_url('admin/patient'); ?>" class="btn btn-primary btn-block btn-sm">
                                    <i class="fa fa-users"></i> Patient Management
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-clock-o"></i> Recent Invoices</h3>
                    </div>
                    <div class="box-body">
                        <div class="recent-activity">
                            <?php if (!empty($recent_invoices)): ?>
                                <?php foreach ($recent_invoices as $invoice): ?>
                                    <div class="activity-item">
                                        <div class="row">
                                            <div class="col-md-8">
                                                <strong>#<?php echo $invoice['invoice_number']; ?></strong><br>
                                                <small><?php echo $invoice['patient_name']; ?></small>
                                            </div>
                                            <div class="col-md-4 text-right">
                                                <span class="invoice-status status-<?php echo $invoice['status']; ?>">
                                                    <?php echo ucfirst($invoice['status']); ?>
                                                </span>
                                                <div class="activity-time">
                                                    <?php echo date('M j', strtotime($invoice['created_at'])); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <div class="text-center text-muted">
                                    <i class="fa fa-file-o"></i><br>
                                    No recent invoices
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="box box-danger">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-exclamation-triangle"></i> Pending Payments</h3>
                    </div>
                    <div class="box-body">
                        <div class="recent-activity">
                            <?php if (!empty($pending_payments)): ?>
                                <?php foreach ($pending_payments as $payment): ?>
                                    <div class="activity-item">
                                        <div class="row">
                                            <div class="col-md-8">
                                                <strong>KES <?php echo number_format($payment['amount_due']); ?></strong><br>
                                                <small><?php echo $payment['patient_name']; ?></small>
                                            </div>
                                            <div class="col-md-4 text-right">
                                                <button class="btn btn-xs btn-primary" onclick="followUpPayment('<?php echo $payment['patient_id']; ?>')">
                                                    Follow Up
                                                </button>
                                                <div class="activity-time">
                                                    Due: <?php echo date('M j', strtotime($payment['due_date'])); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <div class="text-center text-muted">
                                    <i class="fa fa-check-circle"></i><br>
                                    All payments up to date
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Patient Type Statistics -->
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-pie-chart"></i> Patient Type Distribution</h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-4 text-center">
                        <div class="patient-type-card type-gcc">
                            <h4 style="color: #17a2b8;">GCC Patients</h4>
                            <div class="stats-number" style="color: #17a2b8;">
                                <?php 
                                // Get GCC patient count from database
                                $this->db->where('patient_type', 'GCC');
                                $gcc_count = $this->db->count_all_results('patients');
                                echo $gcc_count;
                                ?>
                            </div>
                            <p>Total GCC registrations</p>
                        </div>
                    </div>
                    <div class="col-md-4 text-center">
                        <div class="patient-type-card type-general">
                            <h4 style="color: #28a745;">General Patients</h4>
                            <div class="stats-number" style="color: #28a745;">
                                <?php 
                                // Get General patient count
                                $this->db->where('patient_type !=', 'GCC');
                                $this->db->where('patient_type !=', 'Specialized');
                                $general_count = $this->db->count_all_results('patients');
                                echo $general_count;
                                ?>
                            </div>
                            <p>Active general patients</p>
                        </div>
                    </div>
                    <div class="col-md-4 text-center">
                        <div class="patient-type-card type-specialized">
                            <h4 style="color: #dc3545;">Specialized Patients</h4>
                            <div class="stats-number" style="color: #dc3545;">
                                <?php 
                                // Get Specialized patient count
                                $this->db->where('patient_type', 'Specialized');
                                $spec_count = $this->db->count_all_results('patients');
                                echo $spec_count;
                                ?>
                            </div>
                            <p>Specialized procedures</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script type="text/javascript">
$(document).ready(function() {
    // Patient search functionality
    $('#patient_search').on('input', function() {
        const searchTerm = $(this).val().trim();
        
        if (searchTerm.length >= 2) {
            searchPatients(searchTerm);
        } else {
            $('#patient_suggestions').hide();
            $('#selected_patient_id').val('');
            $('#search_btn').prop('disabled', true);
        }
    });

    // Hide suggestions when clicking outside
    $(document).on('click', function(e) {
        if (!$(e.target).closest('.search-container').length) {
            $('#patient_suggestions').hide();
        }
    });
});

function searchPatients(searchTerm) {
    $.ajax({
        url: base_url + 'admin/bill/getPatientSuggestions',
        type: 'GET',
        data: { term: searchTerm },
        dataType: 'json',
        success: function(patients) {
            displayPatientSuggestions(patients);
        },
        error: function() {
            $('#patient_suggestions').hide();
        }
    });
}

function displayPatientSuggestions(patients) {
    const suggestionsContainer = $('#patient_suggestions');
    suggestionsContainer.empty();
    
    if (patients.length > 0) {
        patients.forEach(function(patient) {
            const suggestionItem = $(`
                <div class="suggestion-item" data-patient-id="${patient.patient_id}">
                    <strong>${patient.label.split(' (')[0]}</strong><br>
                    <small>${patient.label}</small>
                </div>
            `);
            
            suggestionItem.on('click', function() {
                selectPatient(patient);
            });
            
            suggestionsContainer.append(suggestionItem);
        });
        
        suggestionsContainer.show();
    } else {
        suggestionsContainer.hide();
    }
}

function selectPatient(patient) {
    $('#patient_search').val(patient.value);
    $('#selected_patient_id').val(patient.patient_id);
    $('#patient_suggestions').hide();
    $('#search_btn').prop('disabled', false);
}

function generateDailyReport() {
    window.open(base_url + 'admin/bill/generate_daily_report', '_blank');
}

function followUpPayment(patientId) {
    window.location.href = base_url + 'admin/bill/patient_billing_summary/' + patientId;
}

// Auto-refresh stats every 30 seconds
setInterval(function() {
    refreshBillingStats();
}, 30000);

function refreshBillingStats() {
    $.ajax({
        url: base_url + 'admin/bill/get_billing_stats',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                // Update stats on page
                $('.stats-number').each(function(index) {
                    switch(index) {
                        case 0:
                            $(this).text(response.data.total_invoices_today);
                            break;
                        case 1:
                            $(this).text('KES ' + number_format(response.data.total_payments_today));
                            break;
                        case 2:
                            $(this).text(response.data.pending_invoices);
                            break;
                    }
                });
            }
        }
    });
}

function number_format(number) {
    return new Intl.NumberFormat().format(number);
}

// Keyboard shortcuts for patient search
$('#patient_search').on('keydown', function(e) {
    const suggestions = $('.suggestion-item');
    
    if (e.key === 'ArrowDown') {
        e.preventDefault();
        if (suggestions.length > 0) {
            const current = $('.suggestion-item.highlighted');
            if (current.length === 0) {
                suggestions.first().addClass('highlighted');
            } else {
                current.removeClass('highlighted');
                const next = current.next('.suggestion-item');
                if (next.length > 0) {
                    next.addClass('highlighted');
                } else {
                    suggestions.first().addClass('highlighted');
                }
            }
        }
    } else if (e.key === 'ArrowUp') {
        e.preventDefault();
        if (suggestions.length > 0) {
            const current = $('.suggestion-item.highlighted');
            if (current.length === 0) {
                suggestions.last().addClass('highlighted');
            } else {
                current.removeClass('highlighted');
                const prev = current.prev('.suggestion-item');
                if (prev.length > 0) {
                    prev.addClass('highlighted');
                } else {
                    suggestions.last().addClass('highlighted');
                }
            }
        }
    } else if (e.key === 'Enter') {
        e.preventDefault();
        const highlighted = $('.suggestion-item.highlighted');
        if (highlighted.length > 0) {
            highlighted.click();
        } else if ($('#selected_patient_id').val()) {
            $('#search_btn').click();
        }
    } else if (e.key === 'Escape') {
        $('#patient_suggestions').hide();
    }
});

// Add highlighting style
$('<style>')
    .prop('type', 'text/css')
    .html('.suggestion-item.highlighted { background-color: #e9ecef; }')
    .appendTo('head');
</script>