<?php
// File: application/views/admin/bill/reports.php
?>
<link rel="stylesheet" href="<?php echo base_url();?>backend/dist/css/jquery-ui.css">
<style>
    .content-wrapper { background-color: #ecf0f5; }
    
    .reports-header {
        background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%);
        color: white; padding: 20px; border-radius: 8px; margin-bottom: 20px;
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    
    .filter-card {
        background: white; border-radius: 8px; padding: 20px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1); margin-bottom: 20px;
        border-left: 4px solid #f39c12;
    }
    
    .report-card {
        background: white; border-radius: 8px; padding: 20px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1); margin-bottom: 20px;
        border: 1px solid #e3e3e3; transition: all 0.3s ease;
    }
    
    .report-card:hover {
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        border-color: #f39c12;
    }
    
    .summary-stat {
        text-align: center; padding: 15px; margin-bottom: 15px;
        background: #f8f9fa; border-radius: 6px;
    }
    
    .summary-number {
        font-size: 24px; font-weight: bold; margin-bottom: 5px;
    }
    
    .summary-label {
        color: #666; font-size: 12px; text-transform: uppercase;
    }
    
    .chart-container {
        position: relative; height: 300px; margin: 20px 0;
    }
    
    .btn-export {
        background: linear-gradient(45deg, #f39c12, #e67e22);
        color: white; border: none; border-radius: 4px;
        padding: 8px 16px; transition: all 0.3s ease;
    }
    
    .btn-export:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 8px rgba(243,156,18,0.3);
        color: white;
    }
    
    .table-responsive {
        border-radius: 6px; overflow: hidden;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
    }
    
    .report-table {
        margin-bottom: 0;
    }
    
    .report-table th {
        background: #f8f9fa; font-weight: 600;
        border-bottom: 2px solid #dee2e6;
    }
    
    .date-range-picker {
        display: flex; gap: 10px; align-items: center;
    }
    
    .form-control:focus {
        border-color: #f39c12;
        box-shadow: 0 0 0 0.2rem rgba(243,156,18,0.25);
    }
</style>

<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-chart-bar"></i> Billing Reports
            <small>Financial analytics and reporting dashboard</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url('admin/dashboard'); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url('admin/bill/dashboard'); ?>">Billing</a></li>
            <li class="active">Reports</li>
        </ol>
    </section>

    <section class="content">
        <!-- Reports Header -->
        <div class="reports-header">
            <div class="row">
                <div class="col-md-8">
                    <h3><i class="fa fa-chart-line"></i> Financial Reports Dashboard</h3>
                    <p>Comprehensive billing and payment analytics for informed decision making</p>
                </div>
                <div class="col-md-4 text-right">
                    <button class="btn btn-export btn-lg" onclick="exportAllReports()">
                        <i class="fa fa-download"></i> Export All Reports
                    </button>
                </div>
            </div>
        </div>

        <!-- Date Range Filter -->
        <div class="filter-card">
            <form id="reportFilterForm" method="GET">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>From Date</label>
                            <input type="date" name="date_from" class="form-control" 
                                   value="<?php echo $date_from; ?>" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>To Date</label>
                            <input type="date" name="date_to" class="form-control" 
                                   value="<?php echo $date_to; ?>" required>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Patient Type</label>
                            <select name="patient_type" class="form-control">
                                <option value="">All Types</option>
                                <option value="gcc">GCC Patients</option>
                                <option value="general">General Patients</option>
                                <option value="specialized">Specialized Patients</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <button type="submit" name="generate_report" value="1" class="btn btn-primary btn-block">
                                <i class="fa fa-search"></i> Generate Reports
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <?php if (isset($billing_summary)): ?>
        <!-- Summary Statistics -->
        <div class="row">
            <div class="col-md-3">
                <div class="summary-stat" style="border-left: 4px solid #00a65a;">
                    <div class="summary-number text-success">
                        KES <?php echo number_format($billing_summary['total_amount'] ?? 0, 2); ?>
                    </div>
                    <div class="summary-label">Total Billed</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="summary-stat" style="border-left: 4px solid #3c8dbc;">
                    <div class="summary-number text-primary">
                        KES <?php echo number_format($billing_summary['paid_amount'] ?? 0, 2); ?>
                    </div>
                    <div class="summary-label">Total Collected</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="summary-stat" style="border-left: 4px solid #f39c12;">
                    <div class="summary-number text-warning">
                        KES <?php echo number_format($billing_summary['outstanding_amount'] ?? 0, 2); ?>
                    </div>
                    <div class="summary-label">Outstanding</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="summary-stat" style="border-left: 4px solid #dd4b39;">
                    <div class="summary-number text-danger">
                        <?php echo $billing_summary['total_bills'] ?? 0; ?>
                    </div>
                    <div class="summary-label">Total Bills</div>
                </div>
            </div>
        </div>

        <!-- Payment Method Breakdown -->
        <div class="row">
            <div class="col-md-6">
                <div class="report-card">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-credit-card"></i> Payment Methods Summary
                        </h3>
                        <div class="box-tools pull-right">
                            <button class="btn btn-sm btn-export" onclick="exportPaymentSummary()">
                                <i class="fa fa-download"></i> Export
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="chart-container">
                            <canvas id="paymentMethodChart"></canvas>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-striped report-table">
                                <thead>
                                    <tr>
                                        <th>Payment Method</th>
                                        <th>Count</th>
                                        <th>Amount</th>
                                        <th>Percentage</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><i class="fa fa-money"></i> Cash</td>
                                        <td><?php echo $payment_summary['cash_payments'] ?? 0; ?></td>
                                        <td>KES <?php echo number_format($payment_summary['cash_amount'] ?? 0, 2); ?></td>
                                        <td>
                                            <div class="progress" style="height: 20px;">
                                                <div class="progress-bar bg-success" style="width: <?php echo ($payment_summary['cash_percentage'] ?? 0); ?>%">
                                                    <?php echo number_format($payment_summary['cash_percentage'] ?? 0, 1); ?>%
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><i class="fa fa-credit-card"></i> Card</td>
                                        <td><?php echo $payment_summary['card_payments'] ?? 0; ?></td>
                                        <td>KES <?php echo number_format($payment_summary['card_amount'] ?? 0, 2); ?></td>
                                        <td>
                                            <div class="progress" style="height: 20px;">
                                                <div class="progress-bar bg-primary" style="width: <?php echo ($payment_summary['card_percentage'] ?? 0); ?>%">
                                                    <?php echo number_format($payment_summary['card_percentage'] ?? 0, 1); ?>%
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><i class="fa fa-check"></i> Cheque</td>
                                        <td><?php echo $payment_summary['cheque_payments'] ?? 0; ?></td>
                                        <td>KES <?php echo number_format($payment_summary['cheque_amount'] ?? 0, 2); ?></td>
                                        <td>
                                            <div class="progress" style="height: 20px;">
                                                <div class="progress-bar bg-warning" style="width: <?php echo ($payment_summary['cheque_percentage'] ?? 0); ?>%">
                                                    <?php echo number_format($payment_summary['cheque_percentage'] ?? 0, 1); ?>%
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><i class="fa fa-mobile"></i> Mobile Money</td>
                                        <td><?php echo $payment_summary['mobile_payments'] ?? 0; ?></td>
                                        <td>KES <?php echo number_format($payment_summary['mobile_amount'] ?? 0, 2); ?></td>
                                        <td>
                                            <div class="progress" style="height: 20px;">
                                                <div class="progress-bar bg-info" style="width: <?php echo ($payment_summary['mobile_percentage'] ?? 0); ?>%">
                                                    <?php echo number_format($payment_summary['mobile_percentage'] ?? 0, 1); ?>%
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="report-card">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-chart-pie"></i> Revenue by Patient Type
                        </h3>
                        <div class="box-tools pull-right">
                            <button class="btn btn-sm btn-export" onclick="exportRevenueBreakdown()">
                                <i class="fa fa-download"></i> Export
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="chart-container">
                            <canvas id="revenueChart"></canvas>
                        </div>
                        <div class="row text-center">
                            <div class="col-md-4">
                                <div class="summary-stat" style="border-left: 4px solid #17a2b8;">
                                    <div class="summary-number text-info">
                                        KES <?php echo number_format($billing_summary['gcc_revenue'] ?? 0, 2); ?>
                                    </div>
                                    <div class="summary-label">GCC Revenue</div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="summary-stat" style="border-left: 4px solid #28a745;">
                                    <div class="summary-number text-success">
                                        KES <?php echo number_format($billing_summary['general_revenue'] ?? 0, 2); ?>
                                    </div>
                                    <div class="summary-label">General Revenue</div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="summary-stat" style="border-left: 4px solid #dc3545;">
                                    <div class="summary-number text-danger">
                                        KES <?php echo number_format($billing_summary['specialized_revenue'] ?? 0, 2); ?>
                                    </div>
                                    <div class="summary-label">Specialized Revenue</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Outstanding Analysis -->
        <div class="row">
            <div class="col-md-12">
                <div class="report-card">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-exclamation-triangle"></i> Outstanding Payments Analysis
                        </h3>
                        <div class="box-tools pull-right">
                            <button class="btn btn-sm btn-export" onclick="exportOutstandingReport()">
                                <i class="fa fa-download"></i> Export
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="summary-stat" style="border-left: 4px solid #dc3545;">
                                    <div class="summary-number text-danger">
                                        KES <?php echo number_format($outstanding_summary['total_outstanding'] ?? 0, 2); ?>
                                    </div>
                                    <div class="summary-label">Total Outstanding</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="summary-stat" style="border-left: 4px solid #f39c12;">
                                    <div class="summary-number text-warning">
                                        KES <?php echo number_format($outstanding_summary['overdue_amount'] ?? 0, 2); ?>
                                    </div>
                                    <div class="summary-label">Overdue Amount</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="summary-stat" style="border-left: 4px solid #17a2b8;">
                                    <div class="summary-number text-info">
                                        KES <?php echo number_format($outstanding_summary['current_due'] ?? 0, 2); ?>
                                    </div>
                                    <div class="summary-label">Current Due</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="summary-stat" style="border-left: 4px solid #6c757d;">
                                    <div class="summary-number text-muted">
                                        <?php echo number_format($outstanding_summary['collection_rate'] ?? 0, 1); ?>%
                                    </div>
                                    <div class="summary-label">Collection Rate</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php else: ?>
        <!-- No Reports Generated -->
        <div class="report-card text-center">
            <div class="box-body" style="padding: 50px;">
                <i class="fa fa-chart-bar fa-5x text-muted" style="margin-bottom: 20px;"></i>
                <h4 class="text-muted">No Reports Generated</h4>
                <p class="text-muted">Please select a date range and click "Generate Reports" to view financial analytics</p>
                <button type="button" class="btn btn-primary" onclick="$('#reportFilterForm').submit();">
                    <i class="fa fa-chart-line"></i> Generate Sample Report
                </button>
            </div>
        </div>
        <?php endif; ?>

        <!-- Quick Actions -->
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-bolt"></i> Quick Actions</h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-3">
                        <a href="<?php echo base_url('admin/bill/dashboard'); ?>" class="btn btn-primary btn-block">
                            <i class="fa fa-arrow-left"></i><br>Back to Dashboard<br>
                            <small>Return to billing</small>
                        </a>
                    </div>
                    <div class="col-md-3">
                        <button class="btn btn-success btn-block" onclick="exportAllReports()">
                            <i class="fa fa-download"></i><br>Export All<br>
                            <small>Download reports</small>
                        </button>
                    </div>
                    <div class="col-md-3">
                        <button class="btn btn-info btn-block" onclick="scheduleReport()">
                            <i class="fa fa-clock"></i><br>Schedule Report<br>
                            <small>Automated reports</small>
                        </button>
                    </div>
                    <div class="col-md-3">
                        <a href="<?php echo base_url('admin/bill/download_center'); ?>" class="btn btn-warning btn-block">
                            <i class="fa fa-archive"></i><br>Invoice Archive<br>
                            <small>Download center</small>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Load Chart.js for visualizations -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script type="text/javascript">
$(document).ready(function() {
    // Initialize charts if data is available
    <?php if (isset($payment_summary)): ?>
    initializePaymentMethodChart();
    initializeRevenueChart();
    <?php endif; ?>
});

function initializePaymentMethodChart() {
    const ctx = document.getElementById('paymentMethodChart').getContext('2d');
    new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: ['Cash', 'Card', 'Cheque', 'Mobile Money'],
            datasets: [{
                data: [
                    <?php echo $payment_summary['cash_amount'] ?? 0; ?>,
                    <?php echo $payment_summary['card_amount'] ?? 0; ?>,
                    <?php echo $payment_summary['cheque_amount'] ?? 0; ?>,
                    <?php echo $payment_summary['mobile_amount'] ?? 0; ?>
                ],
                backgroundColor: ['#28a745', '#007bff', '#ffc107', '#17a2b8'],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return context.label + ': KES ' + context.parsed.toLocaleString();
                        }
                    }
                }
            }
        }
    });
}

function initializeRevenueChart() {
    const ctx = document.getElementById('revenueChart').getContext('2d');
    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: ['GCC', 'General', 'Specialized'],
            datasets: [{
                label: 'Revenue (KES)',
                data: [
                    <?php echo $billing_summary['gcc_revenue'] ?? 0; ?>,
                    <?php echo $billing_summary['general_revenue'] ?? 0; ?>,
                    <?php echo $billing_summary['specialized_revenue'] ?? 0; ?>
                ],
                backgroundColor: ['#17a2b8', '#28a745', '#dc3545'],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return 'KES ' + value.toLocaleString();
                        }
                    }
                }
            },
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return 'Revenue: KES ' + context.parsed.y.toLocaleString();
                        }
                    }
                }
            }
        }
    });
}

function exportAllReports() {
    toastr.info('Exporting all reports...');
    window.open(base_url + 'admin/bill/export_reports?date_from=<?php echo $date_from; ?>&date_to=<?php echo $date_to; ?>', '_blank');
}

function exportPaymentSummary() {
    toastr.info('Exporting payment summary...');
    window.open(base_url + 'admin/bill/export_payment_summary?date_from=<?php echo $date_from; ?>&date_to=<?php echo $date_to; ?>', '_blank');
}

function exportRevenueBreakdown() {
    toastr.info('Exporting revenue breakdown...');
    window.open(base_url + 'admin/bill/export_revenue_breakdown?date_from=<?php echo $date_from; ?>&date_to=<?php echo $date_to; ?>', '_blank');
}

function exportOutstandingReport() {
    toastr.info('Exporting outstanding report...');
    window.open(base_url + 'admin/bill/export_outstanding_report?date_from=<?php echo $date_from; ?>&date_to=<?php echo $date_to; ?>', '_blank');
}

function scheduleReport() {
    toastr.info('Report scheduling feature will be implemented');
    // Future implementation for scheduled reports
}
</script>