<?php
// File: application/views/admin/bill/print_receipt.php
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Payment Receipt #<?php echo $payment['id']; ?> - <?php echo $organization['name'] ?? 'City Health Clinic'; ?></title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <style>
        @page {
            size: A5;
            margin: 10mm;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 0;
            background: white;
        }
        
        .receipt-container {
            max-width: 400px;
            margin: 0 auto;
            background: white;
            padding: 15px;
            border: 2px dashed #ccc;
        }
        
        .receipt-header {
            text-align: center;
            border-bottom: 1px solid #ddd;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        
        .clinic-name {
            font-size: 18px;
            font-weight: bold;
            color: #00a65a;
            margin-bottom: 5px;
        }
        
        .clinic-info {
            font-size: 10px;
            color: #666;
            line-height: 1.5;
        }
        
        .receipt-title {
            font-size: 16px;
            font-weight: bold;
            color: #333;
            margin: 15px 0 10px 0;
            text-align: center;
            text-transform: uppercase;
            letter-spacing: 2px;
        }
        
        .receipt-meta {
            margin-bottom: 20px;
        }
        
        .meta-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            padding: 5px 0;
            border-bottom: 1px dotted #ddd;
        }
        
        .meta-row:last-child {
            border-bottom: none;
        }
        
        .meta-label {
            font-weight: bold;
            color: #555;
        }
        
        .meta-value {
            color: #333;
            text-align: right;
        }
        
        .amount-section {
            background: #f8f9fa;
            padding: 15px;
            margin: 20px 0;
            border-radius: 6px;
            border: 1px solid #e9ecef;
        }
        
        .amount-display {
            text-align: center;
            font-size: 24px;
            font-weight: bold;
            color: #00a65a;
            margin-bottom: 10px;
        }
        
        .amount-words {
            text-align: center;
            font-size: 11px;
            color: #666;
            font-style: italic;
            text-transform: capitalize;
        }
        
        .payment-details {
            margin: 20px 0;
        }
        
        .payment-method {
            background: #e7f3ff;
            padding: 10px;
            border-radius: 4px;
            border-left: 4px solid #007bff;
            margin-bottom: 10px;
        }
        
        .payment-method .method-name {
            font-weight: bold;
            color: #0056b3;
        }
        
        .payment-method .method-details {
            font-size: 11px;
            color: #666;
            margin-top: 5px;
        }
        
        .service-info {
            background: #fff3cd;
            padding: 10px;
            border-radius: 4px;
            border-left: 4px solid #ffc107;
            margin: 15px 0;
        }
        
        .service-info .service-type {
            font-weight: bold;
            color: #856404;
        }
        
        .receipt-footer {
            margin-top: 25px;
            padding-top: 15px;
            border-top: 1px solid #ddd;
            text-align: center;
        }
        
        .footer-text {
            font-size: 10px;
            color: #666;
            margin: 5px 0;
        }
        
        .thank-you {
            font-size: 14px;
            font-weight: bold;
            color: #00a65a;
            margin: 15px 0 10px 0;
        }
        
        .qr-placeholder {
            width: 60px;
            height: 60px;
            border: 1px solid #ddd;
            margin: 10px auto;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 8px;
            color: #999;
            background: #f8f9fa;
        }
        
        .receipt-number {
            background: #333;
            color: white;
            padding: 5px 10px;
            border-radius: 15px;
            font-size: 11px;
            font-weight: bold;
            margin: 10px 0;
        }
        
        @media print {
            body {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .receipt-container {
                border: none;
            }
            
            .no-print {
                display: none !important;
            }
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <!-- Receipt Header -->
        <div class="receipt-header">
            <div class="clinic-name"><?php echo $organization['name'] ?? 'City Health Clinic'; ?></div>
            <div class="clinic-info">
                <?php if (!empty($organization['address'])): ?>
                    <?php echo $organization['address']; ?><br>
                <?php endif; ?>
                <?php if (!empty($organization['phone'])): ?>
                    Tel: <?php echo $organization['phone']; ?>
                <?php endif; ?>
                <?php if (!empty($organization['email'])): ?>
                    | Email: <?php echo $organization['email']; ?>
                <?php endif; ?>
            </div>
            <div class="receipt-number">
                Receipt #<?php echo str_pad($payment['id'], 6, '0', STR_PAD_LEFT); ?>
            </div>
        </div>

        <div class="receipt-title">Payment Receipt</div>

        <!-- Receipt Meta Information -->
        <div class="receipt-meta">
            <div class="meta-row">
                <span class="meta-label">Date & Time:</span>
                <span class="meta-value"><?php echo date('M j, Y g:i A', strtotime($payment['payment_date'])); ?></span>
            </div>
            <div class="meta-row">
                <span class="meta-label">Patient Name:</span>
                <span class="meta-value"><?php echo $patient['patient_name']; ?></span>
            </div>
            <div class="meta-row">
                <span class="meta-label">Patient ID:</span>
                <span class="meta-value"><?php echo $patient['patient_unique_id']; ?></span>
            </div>
            <?php if (!empty($patient['mobileno'])): ?>
            <div class="meta-row">
                <span class="meta-label">Phone:</span>
                <span class="meta-value"><?php echo $patient['mobileno']; ?></span>
            </div>
            <?php endif; ?>
            <div class="meta-row">
                <span class="meta-label">Received By:</span>
                <span class="meta-value">Staff ID: <?php echo $payment['received_by']; ?></span>
            </div>
        </div>

        <!-- Amount Section -->
        <div class="amount-section">
            <div class="amount-display">
                KES <?php echo number_format($payment['amount'], 2); ?>
            </div>
            <div class="amount-words">
                <?php 
                // Convert amount to words - simplified version
                $amount_in_words = $this->convertAmountToWords($payment['amount']);
                echo "(" . $amount_in_words . " only)";
                ?>
            </div>
        </div>

        <!-- Service Information -->
        <div class="service-info">
            <div class="service-type">
                Service: <?php echo ucfirst(str_replace('_', ' ', $payment['section'] ?? 'General Payment')); ?>
            </div>
            <?php if (!empty($payment['note'])): ?>
                <div style="margin-top: 5px; font-size: 11px; color: #666;">
                    Note: <?php echo $payment['note']; ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Payment Details -->
        <div class="payment-details">
            <div class="payment-method">
                <div class="method-name">
                    Payment Method: <?php echo $payment['payment_mode']; ?>
                </div>
                <div class="method-details">
                    <?php if ($payment['payment_mode'] == 'Cheque' && !empty($payment['cheque_no'])): ?>
                        Cheque Number: <?php echo $payment['cheque_no']; ?>
                        <?php if (!empty($payment['cheque_date'])): ?>
                            | Cheque Date: <?php echo date('M j, Y', strtotime($payment['cheque_date'])); ?>
                        <?php endif; ?>
                    <?php elseif ($payment['payment_mode'] == 'Card'): ?>
                        Card Payment - Transaction processed securely
                    <?php elseif ($payment['payment_mode'] == 'Mobile Money'): ?>
                        Mobile Money Transfer
                    <?php elseif ($payment['payment_mode'] == 'Bank Transfer'): ?>
                        Bank Transfer Payment
                    <?php else: ?>
                        Cash Payment Received
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Transaction Details -->
        <div class="receipt-meta">
            <div class="meta-row">
                <span class="meta-label">Transaction ID:</span>
                <span class="meta-value"><?php echo 'TXN' . str_pad($payment['id'], 8, '0', STR_PAD_LEFT); ?></span>
            </div>
            <?php if (!empty($payment['case_reference_id'])): ?>
            <div class="meta-row">
                <span class="meta-label">Case Reference:</span>
                <span class="meta-value"><?php echo $payment['case_reference_id']; ?></span>
            </div>
            <?php endif; ?>
            <div class="meta-row">
                <span class="meta-label">Payment Status:</span>
                <span class="meta-value" style="color: #28a745; font-weight: bold;">PAID</span>
            </div>
        </div>

        <!-- Receipt Footer -->
        <div class="receipt-footer">
            <div class="thank-you">Thank You for Your Payment!</div>
            
            <div class="qr-placeholder">
                QR Code<br>
                <small>Verify</small>
            </div>
            
            <div class="footer-text">
                This is a computer-generated receipt and does not require a signature.
            </div>
            <div class="footer-text">
                Generated on <?php echo date('M j, Y \a\t g:i A'); ?>
            </div>
            <div class="footer-text">
                For inquiries, please contact our billing department.
            </div>
            <?php if (!empty($organization['phone'])): ?>
                <div class="footer-text">
                    Phone: <?php echo $organization['phone']; ?>
                </div>
            <?php endif; ?>
            
            <div style="margin-top: 15px; padding-top: 10px; border-top: 1px dashed #ccc;">
                <div class="footer-text" style="font-weight: bold; color: #00a65a;">
                    "Your Health, Our Priority"
                </div>
            </div>
        </div>
    </div>

    <!-- Print Button (No Print) -->
    <div class="no-print" style="position: fixed; top: 20px; right: 20px; z-index: 1000;">
        <button onclick="window.print()" style="background: #00a65a; color: white; border: none; padding: 8px 16px; border-radius: 4px; cursor: pointer; font-size: 12px; margin-right: 5px;">
            <i class="fa fa-print"></i> Print
        </button>
        <button onclick="window.close()" style="background: #6c757d; color: white; border: none; padding: 8px 16px; border-radius: 4px; cursor: pointer; font-size: 12px;">
            <i class="fa fa-times"></i> Close
        </button>
    </div>

    <script>
        // Auto-print when page loads
        window.addEventListener('load', function() {
            // Auto-print after short delay
            setTimeout(function() {
                window.print();
            }, 500);
        });
        
        // Print keyboard shortcut
        document.addEventListener('keydown', function(e) {
            if (e.ctrlKey && e.key === 'p') {
                e.preventDefault();
                window.print();
            }
        });
    </script>
</body>
</html>

<?php
// Helper function to convert amount to words (add this to your controller or create a helper)
function convertAmountToWords($amount) {
    $ones = array(
        0 => 'zero', 1 => 'one', 2 => 'two', 3 => 'three', 4 => 'four', 5 => 'five',
        6 => 'six', 7 => 'seven', 8 => 'eight', 9 => 'nine', 10 => 'ten',
        11 => 'eleven', 12 => 'twelve', 13 => 'thirteen', 14 => 'fourteen', 15 => 'fifteen',
        16 => 'sixteen', 17 => 'seventeen', 18 => 'eighteen', 19 => 'nineteen'
    );
    
    $tens = array(
        0 => '', 1 => '', 2 => 'twenty', 3 => 'thirty', 4 => 'forty', 5 => 'fifty',
        6 => 'sixty', 7 => 'seventy', 8 => 'eighty', 9 => 'ninety'
    );
    
    $hundreds = array('', 'thousand', 'million', 'billion');
    
    if ($amount == 0) return 'zero';
    
    $amount = number_format($amount, 2, '.', '');
    list($integer, $fraction) = explode('.', $amount);
    
    $words = '';
    $chunked = array_reverse(str_split(strrev($integer), 3));
    
    for ($i = 0; $i < count($chunked); $i++) {
        $chunk = strrev($chunked[$i]);
        $chunk_int = intval($chunk);
        
        if ($chunk_int == 0) continue;
        
        $chunk_words = '';
        
        if ($chunk_int >= 100) {
            $chunk_words .= $ones[intval($chunk / 100)] . ' hundred ';
            $chunk %= 100;
        }
        
        if ($chunk >= 20) {
            $chunk_words .= $tens[intval($chunk / 10)] . ' ';
            $chunk %= 10;
        }
        
        if ($chunk > 0) {
            $chunk_words .= $ones[$chunk] . ' ';
        }
        
        if ($i > 0) {
            $chunk_words .= $hundreds[count($chunked) - $i] . ' ';
        }
        
        $words = $chunk_words . $words;
    }
    
    $words = trim($words);
    
    if ($fraction > 0) {
        $words .= ' and ' . intval($fraction) . '/100';
    }
    
    return $words;
}
?>