<link rel="stylesheet" href="<?php echo base_url();?>backend/dist/css/jquery-ui.css">
<style>
    .content-wrapper { background-color: #ecf0f5; }
    
    .download-header {
        background: linear-gradient(135deg, #00a65a 0%, #00c0ef 100%);
        color: white; padding: 20px; border-radius: 8px; margin-bottom: 20px;
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    
    .search-section {
        background: #f8f9fa; border-radius: 8px; padding: 20px;
        border: 1px solid #dee2e6; margin-bottom: 20px;
    }
    
    .invoice-grid {
        display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
        gap: 20px; margin-bottom: 20px;
    }
    
    .invoice-card {
        background: white; border-radius: 8px; padding: 20px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1); border: 1px solid #e3e3e3;
        transition: all 0.3s ease; position: relative;
    }
    
    .invoice-card:hover {
        transform: translateY(-2px); box-shadow: 0 4px 15px rgba(0,166,90,0.2);
        border-color: #00a65a;
    }
    
    .invoice-header {
        display: flex; justify-content: space-between; align-items: flex-start;
        margin-bottom: 15px; padding-bottom: 10px; border-bottom: 1px solid #f0f0f0;
    }
    
    .invoice-number {
        font-size: 18px; font-weight: bold; color: #333;
    }
    
    .invoice-date {
        color: #777; font-size: 14px;
    }
    
    .status-badge {
        padding: 4px 8px; border-radius: 4px; font-size: 12px; font-weight: bold;
        position: absolute; top: 15px; right: 15px;
    }
    
    .status-paid { background: #d4edda; color: #155724; }
    .status-partial { background: #fff3cd; color: #856404; }
    .status-pending { background: #f8d7da; color: #721c24; }
    .status-cancelled { background: #e2e3e5; color: #383d41; }
    
    .patient-info {
        margin-bottom: 15px;
    }
    
    .patient-name {
        font-weight: 600; color: #333; margin-bottom: 5px;
    }
    
    .case-id {
        color: #777; font-size: 13px;
    }
    
    .amount-info {
        display: flex; justify-content: space-between; align-items: center;
        margin-bottom: 15px; padding: 10px; background: #f8f9fa; border-radius: 6px;
    }
    
    .total-amount {
        font-size: 16px; font-weight: bold; color: #00a65a;
    }
    
    .due-amount {
        font-size: 14px; color: #dc3545;
    }
    
    .action-buttons {
        display: flex; gap: 8px; flex-wrap: wrap;
    }
    
    .btn-action {
        flex: 1; padding: 6px 12px; font-size: 12px; border-radius: 4px;
        transition: all 0.3s ease;
    }
    
    .btn-view { background: #17a2b8; color: white; border: none; }
    .btn-download { background: #28a745; color: white; border: none; }
    .btn-print { background: #6c757d; color: white; border: none; }
    .btn-email { background: #ffc107; color: #212529; border: none; }
    
    .btn-action:hover {
        transform: translateY(-1px); box-shadow: 0 2px 4px rgba(0,0,0,0.2);
    }
    
    .pagination-wrapper {
        background: white; border-radius: 8px; padding: 20px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1); text-align: center;
    }
    
    .filter-tags {
        margin-top: 10px;
    }
    
    .filter-tag {
        display: inline-block; background: #00a65a; color: white;
        padding: 4px 8px; border-radius: 4px; font-size: 12px; margin-right: 5px;
    }
    
    .filter-tag .remove {
        margin-left: 5px; cursor: pointer;
    }
    
    .stats-row {
        margin-bottom: 20px;
    }
    
    .stat-box {
        background: white; border-radius: 8px; padding: 15px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.08); text-align: center;
        border-bottom: 3px solid #00a65a;
    }
    
    .stat-number {
        font-size: 20px; font-weight: bold; color: #00a65a; margin-bottom: 5px;
    }
    
    .stat-label {
        color: #777; font-size: 14px;
    }
    
    .bulk-actions {
        background: white; border-radius: 8px; padding: 15px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1); margin-bottom: 20px;
    }
    
    .select-all-wrapper {
        margin-bottom: 10px; padding-bottom: 10px; border-bottom: 1px solid #f0f0f0;
    }
    
    .empty-state {
        text-align: center; padding: 60px 20px; color: #777;
    }
    
    .empty-state i {
        font-size: 64px; margin-bottom: 20px; color: #ccc;
    }
</style>

<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-download"></i> Download Center
            <small>Access and manage all saved invoices and billing documents</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url('admin/dashboard'); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url('admin/bill/dashboard'); ?>">Billing</a></li>
            <li class="active">Download Center</li>
        </ol>
    </section>

    <section class="content">
        <!-- Download Center Header -->
        <div class="download-header">
            <div class="col-lg-3 col-md-6">
                <div class="stat-box">
                    <div class="stat-number">
                        <?php 
                        $pending_count = 0;
                        if (!empty($saved_invoices)) {
                            foreach ($saved_invoices as $invoice) {
                                if (in_array($invoice['status'], ['pending', 'partial'])) $pending_count++;
                            }
                        }
                        echo $pending_count;
                        ?>
                    </div>
                    <div class="stat-label">Pending Invoices</div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stat-box">
                    <div class="stat-number">
                        <?php 
                        $this_month = 0;
                        if (!empty($saved_invoices)) {
                            foreach ($saved_invoices as $invoice) {
                                if (date('Y-m', strtotime($invoice['invoice_date'])) == date('Y-m')) $this_month++;
                            }
                        }
                        echo $this_month;
                        ?>
                    </div>
                    <div class="stat-label">This Month</div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stat-box">
                    <div class="stat-number">
                        <?php 
                        $total_value = 0;
                        if (!empty($saved_invoices)) {
                            foreach ($saved_invoices as $invoice) {
                                $total_value += $invoice['total_amount'];
                            }
                        }
                        echo 'KES ' . number_format($total_value);
                        ?>
                    </div>
                    <div class="stat-label">Total Value</div>
                </div>
            </div>
        </div>

        <!-- Search and Filter Section -->
        <div class="search-section">
            <form method="GET" action="<?php echo current_url(); ?>" id="searchForm">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><i class="fa fa-search"></i> Search Invoice</label>
                            <input type="text" name="search" class="form-control" 
                                   placeholder="Invoice number, patient name..." 
                                   value="<?php echo $this->input->get('search'); ?>">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label><i class="fa fa-filter"></i> Status</label>
                            <select name="status" class="form-control">
                                <option value="">All Status</option>
                                <option value="paid" <?php echo $this->input->get('status') == 'paid' ? 'selected' : ''; ?>>Paid</option>
                                <option value="pending" <?php echo $this->input->get('status') == 'pending' ? 'selected' : ''; ?>>Pending</option>
                                <option value="partial" <?php echo $this->input->get('status') == 'partial' ? 'selected' : ''; ?>>Partial</option>
                                <option value="cancelled" <?php echo $this->input->get('status') == 'cancelled' ? 'selected' : ''; ?>>Cancelled</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label><i class="fa fa-calendar"></i> Date From</label>
                            <input type="date" name="date_from" class="form-control" 
                                   value="<?php echo $this->input->get('date_from'); ?>">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label><i class="fa fa-calendar"></i> Date To</label>
                            <input type="date" name="date_to" class="form-control" 
                                   value="<?php echo $this->input->get('date_to'); ?>">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label><i class="fa fa-sort"></i> Sort By</label>
                            <select name="sort" class="form-control">
                                <option value="date_desc" <?php echo $this->input->get('sort') == 'date_desc' ? 'selected' : ''; ?>>Latest First</option>
                                <option value="date_asc" <?php echo $this->input->get('sort') == 'date_asc' ? 'selected' : ''; ?>>Oldest First</option>
                                <option value="amount_desc" <?php echo $this->input->get('sort') == 'amount_desc' ? 'selected' : ''; ?>>Highest Amount</option>
                                <option value="amount_asc" <?php echo $this->input->get('sort') == 'amount_asc' ? 'selected' : ''; ?>>Lowest Amount</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <label style="visibility: hidden;">Search</label><br>
                            <button type="submit" class="btn btn-primary btn-block">
                                <i class="fa fa-search"></i>
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- Active Filters Display -->
                <div class="filter-tags">
                    <?php if ($this->input->get('search')): ?>
                        <span class="filter-tag">
                            Search: "<?php echo htmlspecialchars($this->input->get('search')); ?>"
                            <span class="remove" onclick="removeFilter('search')">&times;</span>
                        </span>
                    <?php endif; ?>
                    <?php if ($this->input->get('status')): ?>
                        <span class="filter-tag">
                            Status: <?php echo ucfirst($this->input->get('status')); ?>
                            <span class="remove" onclick="removeFilter('status')">&times;</span>
                        </span>
                    <?php endif; ?>
                    <?php if ($this->input->get('date_from') || $this->input->get('date_to')): ?>
                        <span class="filter-tag">
                            Date Range: <?php echo $this->input->get('date_from') ?: 'Any'; ?> to <?php echo $this->input->get('date_to') ?: 'Any'; ?>
                            <span class="remove" onclick="removeFilter('date')">&times;</span>
                        </span>
                    <?php endif; ?>
                    <?php if ($this->input->get('search') || $this->input->get('status') || $this->input->get('date_from') || $this->input->get('date_to')): ?>
                        <a href="<?php echo current_url(); ?>" class="btn btn-sm btn-default">
                            <i class="fa fa-times"></i> Clear All Filters
                        </a>
                    <?php endif; ?>
                </div>
            </form>
        </div>

        <!-- Bulk Actions -->
        <?php if (!empty($saved_invoices)): ?>
            <div class="bulk-actions">
                <div class="select-all-wrapper">
                    <label>
                        <input type="checkbox" id="selectAll"> Select All Invoices
                    </label>
                    <span class="selected-count" style="margin-left: 20px; color: #777;">
                        <span id="selectedCount">0</span> selected
                    </span>
                </div>
                <div class="bulk-buttons">
                    <button class="btn btn-success btn-sm" onclick="bulkDownload()" id="bulkDownloadBtn" disabled>
                        <i class="fa fa-download"></i> Download Selected
                    </button>
                    <button class="btn btn-info btn-sm" onclick="bulkPrint()" id="bulkPrintBtn" disabled>
                        <i class="fa fa-print"></i> Print Selected
                    </button>
                    <button class="btn btn-warning btn-sm" onclick="bulkEmail()" id="bulkEmailBtn" disabled>
                        <i class="fa fa-envelope"></i> Email Selected
                    </button>
                    <button class="btn btn-primary btn-sm" onclick="exportToZip()" id="exportZipBtn" disabled>
                        <i class="fa fa-file-archive-o"></i> Export as ZIP
                    </button>
                </div>
            </div>
        <?php endif; ?>

        <!-- Invoices Grid -->
        <?php if (!empty($saved_invoices)): ?>
            <div class="invoice-grid">
                <?php foreach ($saved_invoices as $invoice): ?>
                    <div class="invoice-card" data-invoice-id="<?php echo $invoice['id']; ?>">
                        <div class="invoice-header">
                            <div>
                                <div class="invoice-number">#<?php echo $invoice['invoice_number']; ?></div>
                                <div class="invoice-date"><?php echo date('M j, Y', strtotime($invoice['invoice_date'])); ?></div>
                            </div>
                            <input type="checkbox" class="invoice-checkbox" value="<?php echo $invoice['id']; ?>">
                        </div>
                        
                        <div class="status-badge status-<?php echo $invoice['status']; ?>">
                            <?php echo ucfirst($invoice['status']); ?>
                        </div>
                        
                        <div class="patient-info">
                            <div class="patient-name"><?php echo $invoice['patient_name']; ?></div>
                            <div class="case-id">Case ID: <?php echo $invoice['case_id']; ?></div>
                        </div>
                        
                        <div class="amount-info">
                            <div>
                                <div class="total-amount">KES <?php echo number_format($invoice['total_amount'], 2); ?></div>
                                <small class="text-muted">Total Amount</small>
                            </div>
                            <?php if ($invoice['status'] !== 'paid'): ?>
                                <div class="text-right">
                                    <div class="due-amount">KES <?php echo number_format($invoice['total_amount'] - ($invoice['total_paid'] ?? 0), 2); ?></div>
                                    <small class="text-muted">Due Amount</small>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="action-buttons">
                            <button class="btn btn-action btn-view" onclick="viewInvoice('<?php echo $invoice['id']; ?>')" 
                                    title="View Invoice">
                                <i class="fa fa-eye"></i>
                            </button>
                            <button class="btn btn-action btn-download" onclick="downloadInvoice('<?php echo $invoice['id']; ?>')" 
                                    title="Download PDF">
                                <i class="fa fa-download"></i>
                            </button>
                            <button class="btn btn-action btn-print" onclick="printInvoice('<?php echo $invoice['id']; ?>')" 
                                    title="Print Invoice">
                                <i class="fa fa-print"></i>
                            </button>
                            <button class="btn btn-action btn-email" onclick="emailInvoice('<?php echo $invoice['id']; ?>')" 
                                    title="Email Invoice">
                                <i class="fa fa-envelope"></i>
                            </button>
                        </div>
                        
                        <div style="margin-top: 10px; font-size: 12px; color: #777;">
                            <i class="fa fa-clock-o"></i> Created: <?php echo date('M j, Y g:i A', strtotime($invoice['created_at'])); ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="empty-state">
                <i class="fa fa-file-text-o"></i>
                <h3>No Invoices Found</h3>
                <p>No invoices match your current search criteria.</p>
                <a href="<?php echo base_url('admin/bill/dashboard'); ?>" class="btn btn-primary">
                    <i class="fa fa-plus"></i> Generate Your First Invoice
                </a>
            </div>
        <?php endif; ?>

        <!-- Pagination -->
        <?php if (!empty($saved_invoices) && isset($pagination)): ?>
            <div class="pagination-wrapper">
                <?php echo $pagination; ?>
            </div>
        <?php endif; ?>

        <!-- Quick Actions -->
        <div class="box box-info">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-bolt"></i> Quick Actions</h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-3">
                        <button class="btn btn-success btn-block" onclick="generateMonthlyReport()">
                            <i class="fa fa-calendar"></i><br>Monthly Report<br>
                            <small>Download this month's summary</small>
                        </button>
                    </div>
                    <div class="col-md-3">
                        <button class="btn btn-info btn-block" onclick="backupAllInvoices()">
                            <i class="fa fa-cloud-download"></i><br>Backup All<br>
                            <small>Download complete archive</small>
                        </button>
                    </div>
                    <div class="col-md-3">
                        <a href="<?php echo base_url('admin/bill/reports'); ?>" class="btn btn-warning btn-block">
                            <i class="fa fa-chart-bar"></i><br>Analytics<br>
                            <small>View detailed reports</small>
                        </a>
                    </div>
                    <div class="col-md-3">
                        <a href="<?php echo base_url('admin/bill/dashboard'); ?>" class="btn btn-primary btn-block">
                            <i class="fa fa-dashboard"></i><br>Billing Dashboard<br>
                            <small>Return to main billing</small>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Email Invoice Modal -->
<div class="modal fade" id="emailInvoiceModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header" style="background: linear-gradient(45deg, #00a65a, #00c0ef); color: white;">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-envelope"></i> Email Invoice</h4>
            </div>
            <form id="emailInvoiceForm">
                <div class="modal-body">
                    <input type="hidden" name="invoice_id" id="emailInvoiceId">
                    
                    <div class="form-group">
                        <label>Email Address</label>
                        <input type="email" name="email" class="form-control" required 
                               placeholder="recipient@example.com">
                    </div>
                    
                    <div class="form-group">
                        <label>Subject</label>
                        <input type="text" name="subject" class="form-control" 
                               value="Invoice from <?php echo $this->config->item('name'); ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Message</label>
                        <textarea name="message" class="form-control" rows="4" 
                                  placeholder="Dear Patient, Please find attached your invoice..."></textarea>
                    </div>
                    
                    <div class="checkbox">
                        <label>
                            <input type="checkbox" name="send_copy" checked> Send a copy to me
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-send"></i> Send Invoice
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">
$(document).ready(function() {
    // Initialize checkbox handling
    initializeCheckboxes();
    
    // Auto-submit search form on filter changes
    $('select[name="status"], select[name="sort"]').on('change', function() {
        $('#searchForm').submit();
    });
});

function initializeCheckboxes() {
    // Select all functionality
    $('#selectAll').on('change', function() {
        const isChecked = $(this).prop('checked');
        $('.invoice-checkbox').prop('checked', isChecked);
        updateSelectedCount();
        toggleBulkButtons();
    });
    
    // Individual checkbox handling
    $('.invoice-checkbox').on('change', function() {
        updateSelectedCount();
        toggleBulkButtons();
        
        // Update select all checkbox
        const totalCheckboxes = $('.invoice-checkbox').length;
        const checkedCheckboxes = $('.invoice-checkbox:checked').length;
        $('#selectAll').prop('checked', totalCheckboxes === checkedCheckboxes);
    });
}

function updateSelectedCount() {
    const count = $('.invoice-checkbox:checked').length;
    $('#selectedCount').text(count);
}

function toggleBulkButtons() {
    const hasSelected = $('.invoice-checkbox:checked').length > 0;
    $('#bulkDownloadBtn, #bulkPrintBtn, #bulkEmailBtn, #exportZipBtn').prop('disabled', !hasSelected);
}

function removeFilter(filterType) {
    const form = $('#searchForm');
    
    switch(filterType) {
        case 'search':
            $('input[name="search"]').val('');
            break;
        case 'status':
            $('select[name="status"]').val('');
            break;
        case 'date':
            $('input[name="date_from"], input[name="date_to"]').val('');
            break;
    }
    
    form.submit();
}

function viewInvoice(invoiceId) {
    window.open(base_url + 'admin/bill/view_invoice/' + invoiceId, '_blank');
}

function downloadInvoice(invoiceId) {
    window.open(base_url + 'admin/bill/download_invoice_pdf/' + invoiceId, '_blank');
}

function printInvoice(invoiceId) {
    $.ajax({
        url: base_url + 'admin/bill/print_invoice',
        type: 'POST',
        data: { invoice_id: invoiceId, print_type: 'original' },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                const printWindow = window.open('', '_blank');
                printWindow.document.write(response.page);
                printWindow.document.close();
                printWindow.print();
            } else {
                toastr.error('Failed to generate print view');
            }
        }
    });
}

function emailInvoice(invoiceId) {
    $('#emailInvoiceId').val(invoiceId);
    $('#emailInvoiceModal').modal('show');
}

// Email form submission
$('#emailInvoiceForm').on('submit', function(e) {
    e.preventDefault();
    
    $.ajax({
        url: base_url + 'admin/bill/email_invoice',
        type: 'POST',
        data: $(this).serialize(),
        dataType: 'json',
        beforeSend: function() {
            $('#emailInvoiceModal .btn-primary').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Sending...');
        },
        success: function(response) {
            if (response.status === 'success') {
                $('#emailInvoiceModal').modal('hide');
                toastr.success('Invoice emailed successfully');
            } else {
                toastr.error(response.message || 'Failed to send email');
            }
        },
        error: function() {
            toastr.error('An error occurred while sending the email');
        },
        complete: function() {
            $('#emailInvoiceModal .btn-primary').prop('disabled', false).html('<i class="fa fa-send"></i> Send Invoice');
        }
    });
});

function bulkDownload() {
    const selectedIds = $('.invoice-checkbox:checked').map(function() {
        return $(this).val();
    }).get();
    
    if (selectedIds.length === 0) {
        toastr.warning('Please select invoices to download');
        return;
    }
    
    const form = $('<form>', {
        'method': 'POST',
        'action': base_url + 'admin/bill/bulk_download_invoices'
    });
    
    selectedIds.forEach(function(id) {
        form.append($('<input>', {
            'type': 'hidden',
            'name': 'invoice_ids[]',
            'value': id
        }));
    });
    
    $('body').append(form);
    form.submit();
    form.remove();
}

function bulkPrint() {
    const selectedIds = $('.invoice-checkbox:checked').map(function() {
        return $(this).val();
    }).get();
    
    if (selectedIds.length === 0) {
        toastr.warning('Please select invoices to print');
        return;
    }
    
    $.ajax({
        url: base_url + 'admin/bill/bulk_print_invoices',
        type: 'POST',
        data: { invoice_ids: selectedIds },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                const printWindow = window.open('', '_blank');
                printWindow.document.write(response.content);
                printWindow.document.close();
                printWindow.print();
            } else {
                toastr.error('Failed to prepare invoices for printing');
            }
        }
    });
}

function bulkEmail() {
    const selectedIds = $('.invoice-checkbox:checked').map(function() {
        return $(this).val();
    }).get();
    
    if (selectedIds.length === 0) {
        toastr.warning('Please select invoices to email');
        return;
    }
    
    toastr.info('Bulk email feature will be implemented');
}

function exportToZip() {
    const selectedIds = $('.invoice-checkbox:checked').map(function() {
        return $(this).val();
    }).get();
    
    if (selectedIds.length === 0) {
        toastr.warning('Please select invoices to export');
        return;
    }
    
    toastr.info('Preparing ZIP archive...');
    
    const form = $('<form>', {
        'method': 'POST',
        'action': base_url + 'admin/bill/export_invoices_zip'
    });
    
    selectedIds.forEach(function(id) {
        form.append($('<input>', {
            'type': 'hidden',
            'name': 'invoice_ids[]',
            'value': id
        }));
    });
    
    $('body').append(form);
    form.submit();
    form.remove();
}

function generateMonthlyReport() {
    const currentMonth = new Date().toISOString().slice(0, 7); // YYYY-MM format
    window.open(base_url + 'admin/bill/monthly_report/' + currentMonth, '_blank');
}

function backupAllInvoices() {
    if (confirm('This will download all invoices. This may take some time. Continue?')) {
        window.open(base_url + 'admin/bill/backup_all_invoices', '_blank');
    }
}

// Keyboard shortcuts
$(document).keydown(function(e) {
    // Ctrl+A to select all
    if (e.ctrlKey && e.keyCode === 65) {
        e.preventDefault();
        $('#selectAll').prop('checked', true).trigger('change');
    }
    
    // Escape to clear selection
    if (e.keyCode === 27) {
        $('#selectAll').prop('checked', false).trigger('change');
    }
});

// Auto-refresh every 5 minutes
setInterval(function() {
    if (!$('.invoice-checkbox:checked').length) {
        location.reload();
    }
}, 300000);

// Initialize page
$(document).ready(function() {
    // Set focus on search field
    $('input[name="search"]').focus();
    
    // Initialize any tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    // Auto-submit search after typing (debounced)
    let searchTimeout;
    $('input[name="search"]').on('input', function() {
        clearTimeout(searchTimeout);
        const searchTerm = $(this).val().trim();
        
        if (searchTerm.length >= 3 || searchTerm.length === 0) {
            searchTimeout = setTimeout(function() {
                $('#searchForm').submit();
            }, 1000);
        }
    });
    
    // Show welcome message if no invoices
    <?php if (empty($saved_invoices)): ?>
        setTimeout(function() {
            if (!sessionStorage.getItem('billing_welcome_shown')) {
                toastr.info('Welcome to the Download Center! Generate some invoices to see them here.', 'Getting Started');
                sessionStorage.setItem('billing_welcome_shown', 'true');
            }
        }, 1000);
    <?php endif; ?>
});

// Export functions for different formats
function exportToCSV() {
    const selectedIds = $('.invoice-checkbox:checked').map(function() {
        return $(this).val();
    }).get();
    
    const url = base_url + 'admin/bill/export_invoices_csv';
    const form = $('<form>', {
        'method': 'POST',
        'action': url
    });
    
    if (selectedIds.length > 0) {
        selectedIds.forEach(function(id) {
            form.append($('<input>', {
                'type': 'hidden',
                'name': 'invoice_ids[]',
                'value': id
            }));
        });
    }
    
    $('body').append(form);
    form.submit();
    form.remove();
}

// Advanced filtering
function applyAdvancedFilter() {
    const filterModal = `
        <div class="modal fade" id="advancedFilterModal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title">Advanced Filters</h4>
                    </div>
                    <div class="modal-body">
                        <form id="advancedFilterForm">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Amount Range</label>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <input type="number" name="amount_min" class="form-control" placeholder="Min">
                                            </div>
                                            <div class="col-md-6">
                                                <input type="number" name="amount_max" class="form-control" placeholder="Max">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Patient Type</label>
                                        <select name="patient_type" class="form-control">
                                            <option value="">All Types</option>
                                            <option value="gcc">GCC</option>
                                            <option value="general">General</option>
                                            <option value="specialized">Specialized</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Created By</label>
                                        <select name="created_by" class="form-control">
                                            <option value="">All Users</option>
                                            <!-- Options will be populated dynamically -->
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Invoice Type</label>
                                        <select name="invoice_type" class="form-control">
                                            <option value="">All Types</option>
                                            <option value="final">Final</option>
                                            <option value="interim">Interim</option>
                                            <option value="partial">Partial</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-primary" onclick="applyFilters()">Apply Filters</button>
                    </div>
                </div>
            </div>
        </div>
    `;
    
    $('body').append(filterModal);
    $('#advancedFilterModal').modal('show');
}

function applyFilters() {
    // Get form data and append to search form
    const filterData = $('#advancedFilterForm').serialize();
    const currentAction = $('#searchForm').attr('action');
    $('#searchForm').attr('action', currentAction + '?' + filterData);
    $('#searchForm').submit();
}

// Quick stats calculation
function calculateQuickStats() {
    const invoices = $('.invoice-card');
    let totalValue = 0;
    let paidCount = 0;
    let pendingCount = 0;
    
    invoices.each(function() {
        const amount = parseFloat($(this).find('.total-amount').text().replace(/[^\d.-]/g, ''));
        const status = $(this).find('.status-badge').hasClass('status-paid') ? 'paid' : 'pending';
        
        totalValue += amount;
        if (status === 'paid') {
            paidCount++;
        } else {
            pendingCount++;
        }
    });
    
    console.log('Quick Stats:', {
        totalInvoices: invoices.length,
        totalValue: totalValue,
        paidCount: paidCount,
        pendingCount: pendingCount
    });
}

// Context menu for invoice cards (right-click options)
$(document).on('contextmenu', '.invoice-card', function(e) {
    e.preventDefault();
    const invoiceId = $(this).data('invoice-id');
    
    const contextMenu = `
        <div class="context-menu" style="position: fixed; top: ${e.pageY}px; left: ${e.pageX}px; background: white; border: 1px solid #ccc; border-radius: 4px; padding: 5px; z-index: 9999; box-shadow: 0 2px 8px rgba(0,0,0,0.15);">
            <div class="context-item" onclick="viewInvoice('${invoiceId}')">
                <i class="fa fa-eye"></i> View Invoice
            </div>
            <div class="context-item" onclick="downloadInvoice('${invoiceId}')">
                <i class="fa fa-download"></i> Download
            </div>
            <div class="context-item" onclick="printInvoice('${invoiceId}')">
                <i class="fa fa-print"></i> Print
            </div>
            <div class="context-item" onclick="emailInvoice('${invoiceId}')">
                <i class="fa fa-envelope"></i> Email
            </div>
        </div>
    `;
    
    $('.context-menu').remove();
    $('body').append(contextMenu);
    
    // Remove context menu when clicking elsewhere
    $(document).one('click', function() {
        $('.context-menu').remove();
    });
});

// Add context menu styles
$('<style>')
    .prop('type', 'text/css')
    .html(`
        .context-item {
            padding: 8px 12px;
            cursor: pointer;
            border-radius: 3px;
            font-size: 13px;
        }
        .context-item:hover {
            background-color: #f8f9fa;
        }
        .context-item i {
            margin-right: 8px;
            width: 12px;
        }
    `)
    .appendTo('head');
</script>