<?php
// File: application/views/admin/bill/download_center.php
?>
<link rel="stylesheet" href="<?php echo base_url();?>backend/dist/css/jquery-ui.css">
<style>
    .content-wrapper { background-color: #ecf0f5; }
    
    .download-header {
        background: linear-gradient(135deg, #f39c12 0%, #d68910 100%);
        color: white; padding: 20px; border-radius: 8px; margin-bottom: 20px;
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    
    .search-card {
        background: white; border-radius: 8px; padding: 20px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1); margin-bottom: 20px;
        border-left: 4px solid #f39c12;
    }
    
    .invoice-card {
        background: white; border-radius: 8px; margin-bottom: 15px;
        border: 1px solid #e3e3e3; transition: all 0.3s ease;
        overflow: hidden;
    }
    
    .invoice-card:hover {
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        border-color: #f39c12; transform: translateY(-2px);
    }
    
    .invoice-header {
        background: #f8f9fa; padding: 15px; border-bottom: 1px solid #e3e3e3;
        display: flex; justify-content: space-between; align-items: center;
    }
    
    .invoice-body {
        padding: 15px;
    }
    
    .status-badge {
        padding: 6px 12px; border-radius: 20px; font-weight: bold;
        font-size: 12px; text-transform: uppercase;
    }
    
    .status-paid { background: #d4edda; color: #155724; }
    .status-partial { background: #fff3cd; color: #856404; }
    .status-pending { background: #f8d7da; color: #721c24; }
    
    .patient-type-badge {
        padding: 4px 8px; border-radius: 12px; font-size: 11px;
        font-weight: bold; color: white; margin-left: 10px;
    }
    
    .type-gcc { background: #17a2b8; }
    .type-general { background: #28a745; }
    .type-specialized { background: #dc3545; }
    
    .amount-display {
        font-size: 18px; font-weight: bold;
    }
    
    .amount-total { color: #333; }
    .amount-paid { color: #28a745; }
    .amount-due { color: #dc3545; }
    
    .action-buttons {
        display: flex; gap: 5px; flex-wrap: wrap;
    }
    
    .btn-action {
        padding: 4px 8px; font-size: 12px; border-radius: 4px;
        transition: all 0.3s ease;
    }
    
    .btn-download {
        background: #007bff; color: white; border: none;
    }
    
    .btn-download:hover {
        background: #0056b3; color: white;
        transform: translateY(-1px);
    }
    
    .btn-email {
        background: #17a2b8; color: white; border: none;
    }
    
    .btn-email:hover {
        background: #138496; color: white;
        transform: translateY(-1px);
    }
    
    .btn-view {
        background: #28a745; color: white; border: none;
    }
    
    .btn-view:hover {
        background: #1e7e34; color: white;
        transform: translateY(-1px);
    }
    
    .search-filters {
        display: flex; gap: 10px; align-items: center; flex-wrap: wrap;
    }
    
    .form-control:focus {
        border-color: #f39c12;
        box-shadow: 0 0 0 0.2rem rgba(243,156,18,0.25);
    }
    
    .bulk-actions {
        background: #f8f9fa; padding: 15px; border-radius: 6px;
        margin-bottom: 20px; border-left: 4px solid #6c757d;
    }
    
    .pagination-wrapper {
        background: white; padding: 15px; border-radius: 6px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.08);
    }
    
    .empty-state {
        text-align: center; padding: 50px 20px;
        color: #6c757d;
    }
    
    .empty-state i {
        font-size: 64px; margin-bottom: 20px;
        opacity: 0.5;
    }
</style>

<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-download"></i> Invoice Download Center
            <small>Access and download all generated invoices</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url('admin/dashboard'); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url('admin/bill/dashboard'); ?>">Billing</a></li>
            <li class="active">Download Center</li>
        </ol>
    </section>

    <section class="content">
        <!-- Download Center Header -->
        <div class="download-header">
            <div class="row">
                <div class="col-md-8">
                    <h3><i class="fa fa-archive"></i> Invoice Download Center</h3>
                    <p>Access, download, and manage all generated invoices from a centralized location</p>
                </div>
                <div class="col-md-4 text-right">
                    <button class="btn btn-success btn-lg" onclick="bulkDownload()">
                        <i class="fa fa-download"></i> Bulk Download
                    </button>
                </div>
            </div>
        </div>

        <!-- Search and Filter -->
        <div class="search-card">
            <form id="searchForm" method="GET">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Search</label>
                            <input type="text" name="search" class="form-control" 
                                   placeholder="Invoice number, patient name..." 
                                   value="<?php echo $search_params['search'] ?? ''; ?>">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Status</label>
                            <select name="status" class="form-control">
                                <option value="">All Status</option>
                                <option value="paid" <?php echo ($search_params['status'] ?? '') == 'paid' ? 'selected' : ''; ?>>Paid</option>
                                <option value="partial" <?php echo ($search_params['status'] ?? '') == 'partial' ? 'selected' : ''; ?>>Partial</option>
                                <option value="pending" <?php echo ($search_params['status'] ?? '') == 'pending' ? 'selected' : ''; ?>>Pending</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>Patient Type</label>
                            <select name="patient_type" class="form-control">
                                <option value="">All Types</option>
                                <option value="gcc" <?php echo ($search_params['patient_type'] ?? '') == 'gcc' ? 'selected' : ''; ?>>GCC</option>
                                <option value="general" <?php echo ($search_params['patient_type'] ?? '') == 'general' ? 'selected' : ''; ?>>General</option>
                                <option value="specialized" <?php echo ($search_params['patient_type'] ?? '') == 'specialized' ? 'selected' : ''; ?>>Specialized</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>From Date</label>
                            <input type="date" name="date_from" class="form-control" 
                                   value="<?php echo $search_params['date_from'] ?? ''; ?>">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>To Date</label>
                            <input type="date" name="date_to" class="form-control" 
                                   value="<?php echo $search_params['date_to'] ?? ''; ?>">
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <button type="submit" class="btn btn-primary btn-block">
                                <i class="fa fa-search"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Sort By</label>
                            <select name="sort" class="form-control" onchange="this.form.submit()">
                                <option value="date_desc" <?php echo ($search_params['sort'] ?? '') == 'date_desc' ? 'selected' : ''; ?>>Date (Newest First)</option>
                                <option value="date_asc" <?php echo ($search_params['sort'] ?? '') == 'date_asc' ? 'selected' : ''; ?>>Date (Oldest First)</option>
                                <option value="amount_desc" <?php echo ($search_params['sort'] ?? '') == 'amount_desc' ? 'selected' : ''; ?>>Amount (High to Low)</option>
                                <option value="amount_asc" <?php echo ($search_params['sort'] ?? '') == 'amount_asc' ? 'selected' : ''; ?>>Amount (Low to High)</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div class="btn-group btn-block">
                                <a href="<?php echo base_url('admin/bill/download_center'); ?>" class="btn btn-default">
                                    <i class="fa fa-refresh"></i> Clear Filters
                                </a>
                                <button type="button" class="btn btn-info" onclick="exportSearch()">
                                    <i class="fa fa-download"></i> Export Results
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <!-- Bulk Actions -->
        <?php if (!empty($saved_invoices)): ?>
        <div class="bulk-actions" style="display: none;" id="bulkActionsBar">
            <div class="row">
                <div class="col-md-8">
                    <span id="selectedCount">0</span> invoices selected
                </div>
                <div class="col-md-4 text-right">
                    <div class="btn-group">
                        <button class="btn btn-sm btn-primary" onclick="bulkDownloadSelected()">
                            <i class="fa fa-download"></i> Download Selected
                        </button>
                        <button class="btn btn-sm btn-info" onclick="bulkEmailSelected()">
                            <i class="fa fa-envelope"></i> Email Selected
                        </button>
                        <button class="btn btn-sm btn-default" onclick="clearSelection()">
                            <i class="fa fa-times"></i> Clear Selection
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Invoice List -->
        <?php if (!empty($saved_invoices)): ?>
            <div class="row">
                <?php foreach ($saved_invoices as $invoice): ?>
                <div class="col-md-6">
                    <div class="invoice-card">
                        <div class="invoice-header">
                            <div>
                                <input type="checkbox" class="invoice-checkbox" value="<?php echo $invoice['id']; ?>" 
                                       onchange="updateBulkActions()">
                                <strong style="margin-left: 10px;">
                                    Invoice #<?php echo $invoice['invoice_number']; ?>
                                </strong>
                                <span class="patient-type-badge type-<?php echo $invoice['patient_type'] ?? 'general'; ?>">
                                    <?php 
                                    $type_labels = array('gcc' => 'GCC', 'general' => 'GEN', 'specialized' => 'SPEC');
                                    echo $type_labels[$invoice['patient_type'] ?? 'general'];
                                    ?>
                                </span>
                            </div>
                            <div>
                                <span class="status-badge status-<?php echo $invoice['status']; ?>">
                                    <?php echo ucfirst($invoice['status']); ?>
                                </span>
                            </div>
                        </div>
                        <div class="invoice-body">
                            <div class="row">
                                <div class="col-md-8">
                                    <p class="mb-1">
                                        <strong><i class="fa fa-user"></i> <?php echo $invoice['patient_name']; ?></strong>
                                        <br><small class="text-muted">ID: <?php echo $invoice['patient_unique_id']; ?></small>
                                    </p>
                                    <p class="mb-1">
                                        <i class="fa fa-calendar"></i> <?php echo date('M j, Y', strtotime($invoice['invoice_date'])); ?>
                                        <br><small class="text-muted">
                                            Due: <?php echo date('M j, Y', strtotime($invoice['due_date'] ?? $invoice['invoice_date'])); ?>
                                        </small>
                                    </p>
                                </div>
                                <div class="col-md-4 text-right">
                                    <div class="amount-display amount-total">
                                        KES <?php echo number_format($invoice['total_amount'], 2); ?>
                                    </div>
                                    <?php if ($invoice['total_paid'] > 0): ?>
                                        <small class="amount-paid">
                                            Paid: KES <?php echo number_format($invoice['total_paid'], 2); ?>
                                        </small>
                                    <?php endif; ?>
                                    <?php if ($invoice['balance_due'] > 0): ?>
                                        <br><small class="amount-due">
                                            Due: KES <?php echo number_format($invoice['balance_due'], 2); ?>
                                        </small>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <hr style="margin: 10px 0;">
                            <div class="action-buttons">
                                <button class="btn btn-action btn-download" 
                                        onclick="downloadInvoice('<?php echo $invoice['id']; ?>')"
                                        data-toggle="tooltip" title="Download PDF">
                                    <i class="fa fa-download"></i> Download
                                </button>
                                <button class="btn btn-action btn-view" 
                                        onclick="viewInvoice('<?php echo $invoice['id']; ?>')"
                                        data-toggle="tooltip" title="View Invoice">
                                    <i class="fa fa-eye"></i> View
                                </button>
                                <button class="btn btn-action btn-email" 
                                        onclick="emailInvoice('<?php echo $invoice['id']; ?>')"
                                        data-toggle="tooltip" title="Email Invoice">
                                    <i class="fa fa-envelope"></i> Email
                                </button>
                                <?php if ($invoice['status'] != 'paid'): ?>
                                <button class="btn btn-action btn-warning" 
                                        onclick="recordPayment('<?php echo $invoice['id']; ?>')"
                                        data-toggle="tooltip" title="Record Payment">
                                    <i class="fa fa-money"></i> Payment
                                </button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>

            <!-- Pagination -->
            <?php if (!empty($pagination)): ?>
            <div class="pagination-wrapper">
                <div class="row">
                    <div class="col-md-6">
                        <p class="text-muted">
                            Showing <?php echo count($saved_invoices); ?> of <?php echo $total_invoices; ?> invoices
                        </p>
                    </div>
                    <div class="col-md-6">
                        <div class="text-right">
                            <?php echo $pagination; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

        <?php else: ?>
            <!-- Empty State -->
            <div class="invoice-card">
                <div class="empty-state">
                    <i class="fa fa-file-invoice"></i>
                    <h4>No Invoices Found</h4>
                    <p>No invoices match your current search criteria.</p>
                    <div class="mt-3">
                        <a href="<?php echo base_url('admin/bill/download_center'); ?>" class="btn btn-primary">
                            <i class="fa fa-refresh"></i> Clear Filters
                        </a>
                        <a href="<?php echo base_url('admin/bill/dashboard'); ?>" class="btn btn-success">
                            <i class="fa fa-plus"></i> Generate New Invoice
                        </a>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Quick Navigation -->
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-link"></i> Quick Navigation</h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-3">
                        <a href="<?php echo base_url('admin/bill/dashboard'); ?>" class="btn btn-primary btn-block">
                            <i class="fa fa-arrow-left"></i><br>Back to Billing<br>
                            <small>Return to main dashboard</small>
                        </a>
                    </div>
                    <div class="col-md-3">
                        <a href="<?php echo base_url('admin/bill/reports'); ?>" class="btn btn-info btn-block">
                            <i class="fa fa-chart-bar"></i><br>Financial Reports<br>
                            <small>Analytics dashboard</small>
                        </a>
                    </div>
                    <div class="col-md-3">
                        <button class="btn btn-success btn-block" onclick="exportAllInvoices()">
                            <i class="fa fa-download"></i><br>Export All<br>
                            <small>Download all invoices</small>
                        </button>
                    </div>
                    <div class="col-md-3">
                        <button class="btn btn-warning btn-block" onclick="openSettings()">
                            <i class="fa fa-cog"></i><br>Settings<br>
                            <small>Download preferences</small>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Email Invoice Modal -->
<div class="modal fade" id="emailInvoiceModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header" style="background: linear-gradient(45deg, #17a2b8, #00c0ef); color: white;">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-envelope"></i> Email Invoice</h4>
            </div>
            <form id="emailInvoiceForm">
                <div class="modal-body">
                    <input type="hidden" name="invoice_id" id="emailInvoiceId">
                    
                    <div class="form-group">
                        <label>Recipient Email</label>
                        <input type="email" name="email" class="form-control" required
                               placeholder="Enter recipient email address">
                    </div>
                    
                    <div class="form-group">
                        <label>Subject</label>
                        <input type="text" name="subject" class="form-control" 
                               value="Your Medical Invoice from City Health Clinic">
                    </div>
                    
                    <div class="form-group">
                        <label>Message</label>
                        <textarea name="message" class="form-control" rows="4" 
                                  placeholder="Enter email message...">Dear Patient,

Please find attached your medical invoice. If you have any questions regarding this invoice, please don't hesitate to contact us.

Thank you for choosing City Health Clinic.

Best regards,
Billing Department</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-info">
                        <i class="fa fa-send"></i> Send Email
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">
$(document).ready(function() {
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
});

function downloadInvoice(invoiceId) {
    window.open(base_url + 'admin/bill/download_invoice_pdf/' + invoiceId, '_blank');
}

function viewInvoice(invoiceId) {
    window.open(base_url + 'admin/bill/view_invoice/' + invoiceId, '_blank');
}

function emailInvoice(invoiceId) {
    $('#emailInvoiceId').val(invoiceId);
    $('#emailInvoiceModal').modal('show');
}

function recordPayment(invoiceId) {
    // This would open a payment recording modal
    toastr.info('Payment recording for invoice #' + invoiceId + ' will be implemented');
}

function updateBulkActions() {
    const checkedBoxes = $('.invoice-checkbox:checked');
    const count = checkedBoxes.length;
    
    if (count > 0) {
        $('#bulkActionsBar').show();
        $('#selectedCount').text(count);
    } else {
        $('#bulkActionsBar').hide();
    }
}

function clearSelection() {
    $('.invoice-checkbox').prop('checked', false);
    updateBulkActions();
}

function bulkDownloadSelected() {
    const selectedIds = [];
    $('.invoice-checkbox:checked').each(function() {
        selectedIds.push($(this).val());
    });
    
    if (selectedIds.length === 0) {
        toastr.warning('Please select invoices to download');
        return;
    }
    
    $.ajax({
        url: base_url + 'admin/bill/bulk_download_invoices',
        type: 'POST',
        data: { invoice_ids: selectedIds },
        success: function(response) {
            toastr.success('Download started for ' + selectedIds.length + ' invoices');
        },
        error: function() {
            toastr.error('Failed to start bulk download');
        }
    });
}

function bulkEmailSelected() {
    const selectedIds = [];
    $('.invoice-checkbox:checked').each(function() {
        selectedIds.push($(this).val());
    });
    
    if (selectedIds.length === 0) {
        toastr.warning('Please select invoices to email');
        return;
    }
    
    toastr.info('Bulk email functionality for ' + selectedIds.length + ' invoices will be implemented');
}

function bulkDownload() {
    toastr.info('Starting bulk download of all visible invoices...');
    // This would trigger download of all invoices matching current filters
}

function exportSearch() {
    const formData = $('#searchForm').serialize();
    window.open(base_url + 'admin/bill/export_invoice_list?' + formData, '_blank');
}

function exportAllInvoices() {
    toastr.info('Exporting all invoices...');
    window.open(base_url + 'admin/bill/export_all_invoices', '_blank');
}

function openSettings() {
    toastr.info('Download center settings will be implemented');
}

// Email Invoice Form Submit
$('#emailInvoiceForm').on('submit', function(e) {
    e.preventDefault();
    
    var formData = $(this).serialize();
    
    $.ajax({
        url: base_url + 'admin/bill/email_invoice',
        type: 'POST',
        data: formData,
        dataType: 'json',
        beforeSend: function() {
            $('#emailInvoiceModal .btn-info').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Sending...');
        },
        success: function(response) {
            if (response.status === 'success') {
                $('#emailInvoiceModal').modal('hide');
                toastr.success(response.message);
            } else {
                toastr.error(response.message || 'Failed to send email');
            }
        },
        error: function() {
            toastr.error('An error occurred while sending the email');
        },
        complete: function() {
            $('#emailInvoiceModal .btn-info').prop('disabled', false).html('<i class="fa fa-send"></i> Send Email');
        }
    });
});
</script>